/*
 * Software License Agreement (BSD License)
 *
 *  Copyright (c) 2009, Willow Garage, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of Willow Garage, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef DB_TRANSPARENT_OBJECTS_HPP_
#define DB_TRANSPARENT_OBJECTS_HPP_

#include <object_recognition_core/db/document.h>

#include <edges_pose_refiner/poseEstimator.hpp>

namespace object_recognition_core
{
  namespace db
  {
    // Specializations for cv::FileNode
    template<>
    void
    object_recognition_core::db::DummyDocument::get_attachment<transpod::PoseEstimator>(const AttachmentName &attachment_name,
                                                                                   transpod::PoseEstimator &value) const;

    template<>
    void
    object_recognition_core::db::Document::get_attachment_and_cache<transpod::PoseEstimator>(const AttachmentName &attachment_name,
                                                                                             transpod::PoseEstimator &value);

    template<>
    void
    object_recognition_core::db::DummyDocument::set_attachment<transpod::PoseEstimator>(const AttachmentName &attachment_name,
                                                                                   const transpod::PoseEstimator &value);
  }
}

#endif
