/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.hrp.joystick.views;

import jp.go.aist.hrp.joystick.Activator;
import jp.go.aist.hrp.joystick.rtc.JoystickComp;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.ModuleInitProc;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class joystickView
extends ViewPart {
    private Canvas canvas;
    private static Point pj;
    private static Point PC;
    private boolean mouseDrag = false;
    private Region region;

    static {
        PC = pj = new Point(0, 0);
    }

    public void execJoystick() {
        System.out.println("[Joystick] COMPONENT START");
        String confPath = Activator.getConfigFilePath();
        if (confPath == "") {
            System.out.println("Failed to locate the path to configuration file : rtc.conf");
            System.out.println("Joystick Aborted");
        } else {
            String[] args = new String[]{"-f", confPath};
            Manager manager = Manager.init((String[])args);
            JoystickComp joystickComp = new JoystickComp();
            manager.setModuleInitProc((ModuleInitProc)joystickComp);
            if (manager.getPOAManager().get_state().value() != 1) {
                manager.activateManager();
                manager.runManager(true);
            }
        }
    }

    public static Point getJoystickPosition() {
        Point pos = new Point(joystickView.pj.x - joystickView.PC.x, joystickView.pj.y - joystickView.PC.y);
        pos.y = -pos.y;
        return pos;
    }

    public void createPartControl(Composite parent) {
        this.canvas = new Canvas(parent, 264192);
        this.execJoystick();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point p0 = joystickView.this.canvas.getLocation();
                Point p1 = joystickView.this.canvas.getSize();
                Point P0 = new Point(p0.x, p0.y);
                Point P1 = new Point(p0.x + p1.x, p0.y + p1.y);
                Point pc = new Point((P0.x + P1.x) / 2, (P0.y + P1.y) / 2);
                PC = pc;
                Color col1 = new Color((Device)e.display, 221, 221, 221);
                Color col2 = new Color((Device)e.display, 238, 238, 238);
                Color white = new Color((Device)e.display, 255, 255, 255);
                Image image = new Image((Device)joystickView.this.canvas.getDisplay(), joystickView.this.canvas.getBounds());
                GC gcImage = new GC((Drawable)image);
                gcImage.setBackground(e.gc.getBackground());
                gcImage.fillRectangle(image.getBounds());
                gcImage.setForeground(white);
                int i = 10;
                while (i > 0) {
                    p0.x = pc.x - 50 * i;
                    p0.y = pc.y - 50 * i;
                    p1.x = pc.x + 50 * i;
                    p1.y = pc.y + 50 * i;
                    Color color = i % 2 == 0 ? col1 : col2;
                    gcImage.setBackground(color);
                    gcImage.fillOval(p0.x, p0.y, p1.x - p0.x, p1.y - p0.y);
                    gcImage.drawOval(p0.x, p0.y, p1.x - p0.x, p1.y - p0.y);
                    --i;
                }
                gcImage.setForeground(e.display.getSystemColor(2));
                gcImage.drawLine(pc.x, P0.y, pc.x, P1.y);
                gcImage.drawLine(P0.x, pc.y, P1.x, pc.y);
                gcImage.drawString("x", P1.x - 20, pc.y + 10);
                gcImage.drawString("y", pc.x + 10, P0.y);
                if (!joystickView.this.mouseDrag) {
                    pj = new Point(pc.x, pc.y);
                }
                Point pos = joystickView.getJoystickPosition();
                double _r = (double)Math.round(Math.hypot(pos.x, pos.y) * 100.0) / 100.0;
                double _th = (double)Math.round(Math.toDegrees(Math.atan2(pos.y, pos.x)) * 100.0) / 100.0;
                gcImage.drawString("x: " + pos.x, (pc.x + P1.x) / 2 - 20, P1.y - 40);
                gcImage.drawString("y: " + pos.y, (pc.x + P1.x) / 2 + 55, P1.y - 40);
                gcImage.drawString("r: " + _r, (pc.x + P1.x) / 2 - 20, P1.y - 20);
                gcImage.drawString("th: " + _th, (pc.x + P1.x) / 2 + 50, P1.y - 20);
                gcImage.setBackground(col1);
                gcImage.drawLine(pc.x, pc.y, pj.x, pj.y);
                gcImage.fillOval(pj.x - 10, pj.y - 10, 20, 20);
                gcImage.drawOval(pj.x - 10, pj.y - 10, 20, 20);
                e.gc.drawImage(image, 0, 0);
                image.dispose();
                gcImage.dispose();
                joystickView.this.region = new Region();
                joystickView.this.region.add(new Rectangle(pj.x - 10, pj.y - 10, 20, 20));
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point ep = new Point(e.x, e.y);
                if (joystickView.this.region.contains(ep)) {
                    joystickView.this.mouseDrag = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                joystickView.this.mouseDrag = false;
                joystickView.this.canvas.redraw();
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (joystickView.this.mouseDrag) {
                    pj.x = e.x;
                    pj.y = e.y;
                    joystickView.this.canvas.redraw();
                }
            }
        });
    }

    public void setFocus() {
    }
}

