/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.buffer;

import java.util.Vector;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.util.DataRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBuffer<DataType>
implements BufferBase<DataType> {
    private int m_length;
    private int m_oldPtr;
    private int m_newPtr;
    private Vector<Data<DataType>> m_buffer;

    public RingBuffer(int length) {
        this.m_length = length < 2 ? 2 : length;
        this.m_oldPtr = 0;
        this.m_newPtr = length < 2 ? 1 : length - 1;
        this.m_buffer = new Vector(this.m_length);
        int i = 0;
        while (i < this.m_length) {
            this.m_buffer.add(new Data());
            ++i;
        }
    }

    public void init(DataType data) {
        int i = 0;
        while (i < this.m_length) {
            this.put(data);
            ++i;
        }
    }

    @Override
    public int length() {
        return this.m_length;
    }

    @Override
    public boolean write(DataType value) {
        this.put(value);
        return true;
    }

    @Override
    public boolean read(DataRef<DataType> valueRef) {
        valueRef.v = this.get();
        return true;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return !this.isNew();
    }

    @Override
    public boolean isNew() {
        return this.m_buffer.get(this.m_newPtr).isNew();
    }

    @Override
    public void put(DataType data) {
        this.m_buffer.get(this.m_oldPtr).write(data);
        this.m_newPtr = this.m_oldPtr++;
        this.m_oldPtr %= this.m_length;
    }

    @Override
    public DataType get() {
        return this.m_buffer.get(this.m_newPtr).read();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Data<D> {
        private D data = null;
        private boolean is_new = false;

        public void write(D other) {
            this.data = other;
            this.is_new = true;
        }

        public D read() {
            this.is_new = false;
            return this.data;
        }

        public boolean isNew() {
            return this.is_new;
        }
    }
}

