/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.PortInterfacePolarity;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import java.util.Vector;
import jp.go.aist.rtm.RTC.port.CorbaConsumerBase;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVListHolderFactory;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.operatorFunc;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class CorbaPort
extends PortBase {
    private NVListHolder m_providers = NVListHolderFactory.create();
    private Vector<Consumer> m_consumers = new Vector();

    public CorbaPort(String name) {
        super(name);
        this.addProperty("port.port_type", "CorbaPort");
    }

    public boolean registerProvider(String instance_name, String type_name, Servant provider) throws ServantAlreadyActive, WrongPolicy, ObjectNotActive {
        if (!this.appendInterface(instance_name, type_name, PortInterfacePolarity.PROVIDED)) {
            return false;
        }
        byte[] oid = this._default_POA().activate_object(provider);
        Object obj = this._default_POA().id_to_reference(oid);
        StringBuffer key = new StringBuffer("port");
        key.append(".").append(type_name).append(".").append(instance_name);
        CORBA_SeqUtil.push_back(this.m_providers, NVUtil.newNV(key.toString(), obj));
        return true;
    }

    public boolean registerConsumer(String instance_name, String type_name, CorbaConsumerBase consumer) {
        if (!this.appendInterface(instance_name, type_name, PortInterfacePolarity.REQUIRED)) {
            return false;
        }
        Consumer cons = new Consumer(instance_name, type_name, consumer);
        this.m_consumers.add(cons);
        return true;
    }

    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connector_profile) {
        NVListHolder holder = new NVListHolder(connector_profile.value.properties);
        CORBA_SeqUtil.push_back_list(holder, this.m_providers);
        connector_profile.value.properties = holder.value;
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connector_profile) {
        NVListHolder nv = new NVListHolder(connector_profile.value.properties);
        CORBA_SeqUtil.for_each(nv, (operatorFunc)new subscribe(this.m_consumers));
        return ReturnCode_t.RTC_OK;
    }

    protected void unsubscribeInterfaces(ConnectorProfile connector_profile) {
        NVListHolder nv = new NVListHolder(connector_profile.properties);
        CORBA_SeqUtil.for_each(nv, (operatorFunc)new unsubscribe(this.m_consumers));
        connector_profile.properties = nv.value;
    }

    private class Consumer {
        private String name;
        private CorbaConsumerBase consumer;

        public Consumer(String _instance_name, String _type_name, CorbaConsumerBase _cons) {
            this.name = "port." + _type_name + "." + _instance_name;
            this.consumer = _cons;
        }

        public Consumer(Consumer cons) {
            this.name = cons.name;
            this.consumer = cons.consumer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class subscribe
    implements operatorFunc {
        private Vector<Consumer> m_cons;
        private int m_len;

        public subscribe(Vector<Consumer> cons) {
            this.m_cons = new Vector<Consumer>(cons);
            this.m_len = cons.size();
        }

        @Override
        public void operator(java.lang.Object elem) {
            this.operator((NameValue)elem);
        }

        public void operator(NameValue nv) {
            int i = 0;
            while (i < this.m_len) {
                if (this.m_cons.get(i).name.equals(nv.name)) {
                    try {
                        Object obj = nv.value.extract_Object();
                        this.m_cons.get(i).consumer.setObject(obj);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class unsubscribe
    implements operatorFunc {
        private Vector<Consumer> m_cons;
        private int m_len;

        public unsubscribe(Vector<Consumer> cons) {
            this.m_cons = new Vector<Consumer>(cons);
            this.m_len = cons.size();
        }

        @Override
        public void operator(java.lang.Object elem) {
            this.operator((NameValue)elem);
        }

        public void operator(NameValue nv) {
            int i = 0;
            while (i < this.m_len) {
                if (this.m_cons.get(i).name.equals(nv.name)) {
                    this.m_cons.get(i).consumer.releaseObject();
                }
                ++i;
            }
        }
    }
}

