/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.OutPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.DataRef;
import org.omg.CORBA.portable.OutputStream;

public class InPortPullConnector
extends InPortConnector {
    private OutPortConsumer m_consumer;
    private Logbuf rtcout;

    public InPortPullConnector(ConnectorBase.Profile profile, OutPortConsumer outPortConsumer, BufferBase<OutputStream> bufferBase) throws Exception {
        super(profile, bufferBase);
        this.m_consumer = outPortConsumer;
        this.rtcout = new Logbuf("InPortPullConnector");
        this.rtcout.setLevel("PARANOID");
        if (bufferBase == null) {
            this.m_buffer = this.createBuffer(this.m_profile);
        }
        if (this.m_buffer == null || this.m_consumer == null) {
            throw new Exception("bad_alloc()");
        }
        this.m_consumer.setBuffer(this.m_buffer);
    }

    @Override
    public ReturnCode read(DataRef<OutputStream> dataRef) {
        if (this.m_buffer == null) {
            return ReturnCode.PORT_ERROR;
        }
        this.m_buffer.read(dataRef);
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode disconnect() {
        return ReturnCode.PORT_OK;
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.Profile profile) {
        String string = profile.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }
}

