/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.spi.orb.ORB;
import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.FactoryGlobal;
import jp.go.aist.rtm.RTC.OutPortProviderFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.port.OutPortBase;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.OutPortProvider;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import org.omg.CORBA.portable.OutputStream;

public class OutPortPullConnector
extends OutPortConnector {
    protected OutPortProvider m_provider;
    protected BufferBase<OutputStream> m_buffer;
    private ORB m_spi_orb;
    private OutPortBase m_outport;
    private ConnectorListeners m_listeners;

    public OutPortPullConnector(ConnectorBase.ConnectorInfo connectorInfo, OutPortProvider outPortProvider, ConnectorListeners connectorListeners, BufferBase<OutputStream> bufferBase) throws Exception {
        super(connectorInfo);
        this._constructor(connectorInfo, outPortProvider, connectorListeners, bufferBase);
    }

    public OutPortPullConnector(ConnectorBase.ConnectorInfo connectorInfo, OutPortProvider outPortProvider, ConnectorListeners connectorListeners) throws Exception {
        super(connectorInfo);
        BufferBase<OutputStream> bufferBase = null;
        this._constructor(connectorInfo, outPortProvider, connectorListeners, bufferBase);
    }

    private void _constructor(ConnectorBase.ConnectorInfo connectorInfo, OutPortProvider outPortProvider, ConnectorListeners connectorListeners, BufferBase<OutputStream> bufferBase) throws Exception {
        this.m_provider = outPortProvider;
        this.m_buffer = bufferBase;
        this.m_listeners = connectorListeners;
        this.m_spi_orb = (ORB)ORBUtil.getOrb();
        if (this.m_buffer == null) {
            this.m_buffer = this.createBuffer(connectorInfo);
        }
        if (this.m_provider == null || this.m_buffer == null) {
            throw new Exception("bad_alloc()");
        }
        this.m_buffer.init(connectorInfo.properties.getNode("buffer"));
        this.m_provider.setBuffer(this.m_buffer);
        this.m_provider.setConnector(this);
        this.m_provider.setListener(connectorInfo, this.m_listeners);
        this.onConnect();
    }

    @Override
    public <DataType> ReturnCode write(DataType DataType) {
        this.rtcout.println(2, "write()");
        OutPort outPort = (OutPort)this.m_outport;
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.m_spi_orb, this.m_isLittleEndian);
        outPort.write_stream(DataType, (OutputStream)encapsOutputStream);
        this.m_buffer.write((OutputStream)encapsOutputStream);
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode disconnect() {
        FactoryGlobal factoryGlobal;
        this.onDisconnect();
        if (this.m_provider != null) {
            factoryGlobal = OutPortProviderFactory.instance();
            factoryGlobal.deleteObject(this.m_provider);
        }
        this.m_provider = null;
        if (this.m_buffer != null) {
            factoryGlobal = BufferFactory.instance();
            factoryGlobal.deleteObject(this.m_buffer);
        }
        this.m_buffer = null;
        return ReturnCode.PORT_OK;
    }

    @Override
    public BufferBase<OutputStream> getBuffer() {
        return this.m_buffer;
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.ConnectorInfo connectorInfo) {
        String string = connectorInfo.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }

    protected void onConnect() {
        this.m_listeners.connector_[5].notify(this.m_profile);
    }

    protected void onDisconnect() {
        this.m_listeners.connector_[6].notify(this.m_profile);
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void setOutPortBase(OutPortBase outPortBase) {
        this.m_outport = outPortBase;
    }
}

