/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.SDOPackage;

import _SDOPackage.Configuration;
import _SDOPackage.ConfigurationHelper;
import _SDOPackage.ConfigurationPOA;
import _SDOPackage.ConfigurationSet;
import _SDOPackage.ConfigurationSetListHolder;
import _SDOPackage.DeviceProfile;
import _SDOPackage.InternalError;
import _SDOPackage.InvalidParameter;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import _SDOPackage.NotAvailable;
import _SDOPackage.Organization;
import _SDOPackage.OrganizationListHolder;
import _SDOPackage.Parameter;
import _SDOPackage.ParameterListHolder;
import _SDOPackage.ServiceProfile;
import _SDOPackage.ServiceProfileListHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jp.go.aist.rtm.RTC.ConfigAdmin;
import jp.go.aist.rtm.RTC.SdoServiceAdmin;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.Any;

public class Configuration_impl
extends ConfigurationPOA {
    protected Configuration m_objref;
    protected DeviceProfile m_deviceProfile = new DeviceProfile();
    protected ServiceProfileListHolder m_serviceProfiles;
    protected ParameterListHolder m_parameters;
    protected ConfigAdmin m_configsets;
    protected Map<String, Properties> m_configsetopts = new HashMap<String, Properties>();
    protected SdoServiceAdmin m_sdoservice;
    protected String m_sdoservice_mutex = new String();
    protected OrganizationListHolder m_organizations;
    protected Logbuf rtcout;

    public Configuration_impl(ConfigAdmin configAdmin, SdoServiceAdmin sdoServiceAdmin) {
        this.m_configsets = configAdmin;
        this.m_sdoservice = sdoServiceAdmin;
        this.m_objref = this._this();
        this.rtcout = new Logbuf("Configuration_impl");
        this.m_organizations = new OrganizationListHolder();
        this.m_organizations.value = new Organization[0];
        this.m_serviceProfiles = new ServiceProfileListHolder();
        this.m_serviceProfiles.value = new ServiceProfile[0];
    }

    @Override
    public Configuration _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = ConfigurationHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.m_objref;
    }

    private void toProperties(Properties properties, ConfigurationSet configurationSet) {
        NVListHolder nVListHolder = new NVListHolder();
        nVListHolder.value = configurationSet.configuration_data;
        NVUtil.copyToProperties(properties, nVListHolder);
    }

    private void toConfigurationSet(ConfigurationSet configurationSet, Properties properties) {
        configurationSet.description = new String(properties.getProperty("description"));
        configurationSet.id = new String(properties.getName());
        NVListHolder nVListHolder = new NVListHolder();
        NVUtil.copyFromProperties(nVListHolder, properties);
        configurationSet.configuration_data = nVListHolder.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_device_profile(DeviceProfile deviceProfile) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.set_device_profile()");
        try {
            if (this.m_deviceProfile == null) {
                this.m_deviceProfile = new DeviceProfile();
            }
            DeviceProfile deviceProfile2 = this.m_deviceProfile;
            synchronized (deviceProfile2) {
                this.m_deviceProfile = deviceProfile;
            }
        }
        catch (Exception exception) {
            throw new InternalError("Unknown Error:set_device_profile()");
        }
        return true;
    }

    @Override
    public boolean add_service_profile(ServiceProfile serviceProfile) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.add_service_profile()");
        try {
            return this.m_sdoservice.addSdoServiceConsumer(serviceProfile);
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::add_service_profile");
        }
    }

    @Override
    public boolean add_organization(Organization organization) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.add_organization()");
        try {
            if (this.m_organizations == null) {
                this.m_organizations = new OrganizationListHolder();
                this.m_organizations.value = new Organization[0];
            }
            CORBA_SeqUtil.push_back(this.m_organizations, organization);
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::set_service_profile");
        }
        return true;
    }

    @Override
    public boolean remove_service_profile(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.remove_service_profile(" + string + ")");
        try {
            return this.m_sdoservice.removeSdoServiceConsumer(string);
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::remove_service_profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_organization(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.remove_organization(" + string + ")");
        try {
            OrganizationListHolder organizationListHolder = this.m_organizations;
            synchronized (organizationListHolder) {
                for (int i = 0; i < this.m_organizations.value.length; ++i) {
                    if (!string.equals(this.m_organizations.value[i].get_organization_id())) continue;
                    CORBA_SeqUtil.erase(this.m_organizations, i);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::remove_service_profile");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameter[] get_configuration_parameters() throws NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.get_configurations()");
        try {
            if (this.m_parameters == null) {
                this.m_parameters = new ParameterListHolder();
                this.m_parameters.value = new Parameter[0];
            }
            ParameterListHolder parameterListHolder = this.m_parameters;
            synchronized (parameterListHolder) {
                ParameterListHolder parameterListHolder2 = new ParameterListHolder(this.m_parameters.value);
                return parameterListHolder2.value;
            }
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::get_configuration_parameters()");
        }
    }

    @Override
    public synchronized NameValue[] get_configuration_parameter_values() throws NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.get_configuration_parameter_values()");
        NVListHolder nVListHolder = new NVListHolder();
        nVListHolder.value = new NameValue[0];
        return nVListHolder.value;
    }

    @Override
    public Any get_configuration_parameter_value(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.get_configuration_parameter_value(" + string + ")");
        if (string == null || string.equals("")) {
            throw new InvalidParameter("Name is empty.");
        }
        Any any = ORBUtil.getOrb().create_any();
        return any;
    }

    @Override
    public boolean set_configuration_parameter(String string, Any any) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.set_configuration_parameter(" + string + ")");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationSet[] get_configuration_sets() throws NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.get_configuration_sets()");
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                ConfigurationSetListHolder configurationSetListHolder = new ConfigurationSetListHolder();
                configurationSetListHolder.value = new ConfigurationSet[0];
                Vector<Properties> vector = new Vector<Properties>(this.m_configsets.getConfigurationSets());
                configurationSetListHolder.value = new ConfigurationSet[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    if (configurationSetListHolder.value[i] == null) {
                        configurationSetListHolder.value[i] = new ConfigurationSet();
                    }
                    this.toConfigurationSet(configurationSetListHolder.value[i], vector.elementAt(i));
                }
                return configurationSetListHolder.value;
            }
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::get_configuration_sets()");
        }
    }

    @Override
    public synchronized ConfigurationSet get_configuration_set(String string) throws NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.get_configuration_set(" + string + ")");
        if (string == null || string.equals("")) {
            throw new InternalError("ID is empty");
        }
        if (!this.m_configsets.haveConfig(string)) {
            throw new InternalError("No such ConfigurationSet");
        }
        Properties properties = new Properties(this.m_configsets.getConfigurationSet(string));
        try {
            ConfigurationSet configurationSet = new ConfigurationSet();
            this.toConfigurationSet(configurationSet, properties);
            return configurationSet;
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::get_configuration_set()");
        }
    }

    @Override
    public boolean set_configuration_set_values(ConfigurationSet configurationSet) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.set_configuration_set_values()");
        String string = configurationSet.id;
        if (string == null || string.equals("")) {
            throw new InvalidParameter("ID is empty.");
        }
        try {
            Properties properties = new Properties(string);
            this.toProperties(properties, configurationSet);
            if (properties.findNode("exported_ports") != null) {
                String[] stringArray = properties.getProperty("exported_ports").split(",");
                String string2 = "";
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String[] stringArray2 = stringArray[i].split("\\.");
                    string2 = stringArray2.length > 2 ? string2 + stringArray2[0] + "." + stringArray2[stringArray2.length - 1] : string2 + stringArray[i];
                    if (i == stringArray.length - 1) continue;
                    string2 = string2 + ",";
                }
                properties.setProperty("exported_ports", string2);
            }
            return this.m_configsets.setConfigurationSetValues(string, properties);
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::set_configuration_set_values()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationSet get_active_configuration_set() throws NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.get_active_configuration_set()");
        if (!this.m_configsets.isActive()) {
            throw new NotAvailable();
        }
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                ConfigurationSet configurationSet = new ConfigurationSet();
                this.toConfigurationSet(configurationSet, this.m_configsets.getActiveConfigurationSet());
                return configurationSet;
            }
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::get_active_configuration_set()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add_configuration_set(ConfigurationSet configurationSet) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl::add_configuration_set()");
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                String string = configurationSet.id;
                Properties properties = new Properties(string);
                this.toProperties(properties, configurationSet);
                return this.m_configsets.addConfigurationSet(properties);
            }
        }
        catch (Exception exception) {
            throw new InternalError("Configuration.add_configuration_set()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_configuration_set(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.remove_configuration_set(" + string + ")");
        if (string == null || string.equals("")) {
            throw new InvalidParameter("ID is empty.");
        }
        try {
            ConfigAdmin configAdmin = this.m_configsets;
            synchronized (configAdmin) {
                if (!this.m_configsets.haveConfig(string)) {
                    throw new InvalidParameter("No such ConfigurationSet");
                }
                return this.m_configsets.removeConfigurationSet(string);
            }
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::remove_configuration_set()");
        }
    }

    @Override
    public boolean activate_configuration_set(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "Configuration_impl.activate_configuration_set(" + string + ")");
        if (string == null || string.equals("")) {
            throw new InvalidParameter("ID is empty.");
        }
        if (!this.m_configsets.haveConfig(string)) {
            throw new InvalidParameter("No such ConfigurationSet");
        }
        try {
            return this.m_configsets.activateConfigurationSet(string);
        }
        catch (Exception exception) {
            throw new InternalError("Configuration::activate_configuration_set()");
        }
    }

    public Configuration getObjRef() {
        this.rtcout.println(2, "Configuration_impl.getObjRef()");
        return this.m_objref;
    }

    public final DeviceProfile getDeviceProfile() {
        this.rtcout.println(2, "Configuration_impl.getDeviceProfile()");
        return this.m_deviceProfile;
    }

    public final OrganizationListHolder getOrganizations() {
        this.rtcout.println(2, "Configuration_impl.getOrganizations()");
        return this.m_organizations;
    }
}

