/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import RTC.Time;
import RTC.TimeHelper;
import RTC.TimedBoolean;
import RTC.TimedBooleanHelper;
import RTC.TimedBooleanSeq;
import RTC.TimedBooleanSeqHelper;
import RTC.TimedChar;
import RTC.TimedCharHelper;
import RTC.TimedCharSeq;
import RTC.TimedCharSeqHelper;
import RTC.TimedDouble;
import RTC.TimedDoubleHelper;
import RTC.TimedDoubleSeq;
import RTC.TimedDoubleSeqHelper;
import RTC.TimedFloat;
import RTC.TimedFloatHelper;
import RTC.TimedFloatSeq;
import RTC.TimedFloatSeqHelper;
import RTC.TimedLong;
import RTC.TimedLongHelper;
import RTC.TimedLongSeq;
import RTC.TimedLongSeqHelper;
import RTC.TimedOctet;
import RTC.TimedOctetHelper;
import RTC.TimedOctetSeq;
import RTC.TimedOctetSeqHelper;
import RTC.TimedShort;
import RTC.TimedShortHelper;
import RTC.TimedShortSeq;
import RTC.TimedShortSeqHelper;
import RTC.TimedState;
import RTC.TimedStateHelper;
import RTC.TimedString;
import RTC.TimedStringHelper;
import RTC.TimedStringSeq;
import RTC.TimedStringSeqHelper;
import RTC.TimedULong;
import RTC.TimedULongHelper;
import RTC.TimedULongSeq;
import RTC.TimedULongSeqHelper;
import RTC.TimedUShort;
import RTC.TimedUShortHelper;
import RTC.TimedUShortSeq;
import RTC.TimedUShortSeqHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;

public class TypeCast<T> {
    private Class<T> klass;

    public TypeCast(Class<T> clazz) {
        assert (clazz != null);
        this.klass = clazz;
    }

    public T castType(Any any) {
        if (this.klass.equals(Byte.class)) {
            return this.klass.cast(any.extract_octet());
        }
        if (this.klass.equals(Double.class)) {
            return this.klass.cast(any.extract_double());
        }
        if (this.klass.equals(Float.class)) {
            return this.klass.cast(Float.valueOf(any.extract_float()));
        }
        if (this.klass.equals(Integer.class)) {
            return this.klass.cast(any.extract_long());
        }
        if (this.klass.equals(Long.class)) {
            return this.klass.cast(any.extract_longlong());
        }
        if (this.klass.equals(Short.class)) {
            return this.klass.cast(any.extract_short());
        }
        if (this.klass.equals(String.class)) {
            return this.klass.cast(any.extract_wstring());
        }
        if (this.klass.equals(Character.class)) {
            return this.klass.cast(Character.valueOf(any.extract_char()));
        }
        if (this.klass.equals(Boolean.class)) {
            return this.klass.cast(any.extract_boolean());
        }
        if (this.klass.equals(Time.class)) {
            return this.klass.cast(TimeHelper.extract(any));
        }
        if (this.klass.equals(TimedBoolean.class)) {
            return this.klass.cast(TimedBooleanHelper.extract(any));
        }
        if (this.klass.equals(TimedChar.class)) {
            return this.klass.cast(TimedCharHelper.extract(any));
        }
        if (this.klass.equals(TimedDouble.class)) {
            return this.klass.cast(TimedDoubleHelper.extract(any));
        }
        if (this.klass.equals(TimedFloat.class)) {
            return this.klass.cast(TimedFloatHelper.extract(any));
        }
        if (this.klass.equals(TimedLong.class)) {
            return this.klass.cast(TimedLongHelper.extract(any));
        }
        if (this.klass.equals(TimedOctet.class)) {
            return this.klass.cast(TimedOctetHelper.extract(any));
        }
        if (this.klass.equals(TimedShort.class)) {
            return this.klass.cast(TimedShortHelper.extract(any));
        }
        if (this.klass.equals(TimedState.class)) {
            return this.klass.cast(TimedStateHelper.extract(any));
        }
        if (this.klass.equals(TimedString.class)) {
            return this.klass.cast(TimedStringHelper.extract(any));
        }
        if (this.klass.equals(TimedULong.class)) {
            return this.klass.cast(TimedULongHelper.extract(any));
        }
        if (this.klass.equals(TimedUShort.class)) {
            return this.klass.cast(TimedUShortHelper.extract(any));
        }
        if (this.klass.equals(TimedBooleanSeq.class)) {
            return this.klass.cast(TimedBooleanSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedCharSeq.class)) {
            return this.klass.cast(TimedCharSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedDoubleSeq.class)) {
            return this.klass.cast(TimedDoubleSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedFloatSeq.class)) {
            return this.klass.cast(TimedFloatSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedLongSeq.class)) {
            return this.klass.cast(TimedLongSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedOctetSeq.class)) {
            return this.klass.cast(TimedOctetSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedShortSeq.class)) {
            return this.klass.cast(TimedShortSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedStringSeq.class)) {
            return this.klass.cast(TimedStringSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedULongSeq.class)) {
            return this.klass.cast(TimedULongSeqHelper.extract(any));
        }
        if (this.klass.equals(TimedUShortSeq.class)) {
            return this.klass.cast(TimedUShortSeqHelper.extract(any));
        }
        String string = this.klass.getCanonicalName();
        if (string == null) {
            throw new IllegalStateException("Cannot get class name.");
        }
        try {
            Class<?> clazz = Class.forName(string + "Helper", true, this.klass.getClassLoader());
            Method method = clazz.getMethod("extract", Any.class);
            java.lang.Object object = method.invoke(null, any);
            return this.klass.cast(object);
        }
        catch (Exception exception) {
            throw new ClassCastException("Unknown data type.");
        }
    }

    public T castType(Object object) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String string = this.klass.getCanonicalName();
        if (string == null) {
            throw new IllegalStateException("Cannot get class name.");
        }
        Class<?> clazz = Class.forName(string + "Helper", true, this.klass.getClassLoader());
        Method method = clazz.getMethod("narrow", Object.class);
        java.lang.Object object2 = method.invoke(null, object);
        return this.klass.cast(object2);
    }

    public Any castAny(T t) {
        t = this.replaceNull(t);
        Any any = ORBUtil.getOrb().create_any();
        if (this.klass.equals(Byte.class)) {
            any.insert_octet(((Byte)Byte.class.cast(t)).byteValue());
            return any;
        }
        if (this.klass.equals(Double.class)) {
            any.insert_double(((Double)Double.class.cast(t)).doubleValue());
            return any;
        }
        if (this.klass.equals(Float.class)) {
            any.insert_float(((Float)Float.class.cast(t)).floatValue());
            return any;
        }
        if (this.klass.equals(Integer.class)) {
            any.insert_long(((Integer)Integer.class.cast(t)).intValue());
            return any;
        }
        if (this.klass.equals(Long.class)) {
            any.insert_longlong(((Long)Long.class.cast(t)).longValue());
            return any;
        }
        if (this.klass.equals(Short.class)) {
            any.insert_short(((Short)Short.class.cast(t)).shortValue());
            return any;
        }
        if (this.klass.equals(String.class)) {
            any.insert_wstring((String)String.class.cast(t));
            return any;
        }
        if (this.klass.equals(Character.class)) {
            any.insert_char(((Character)Character.class.cast(t)).charValue());
            return any;
        }
        if (this.klass.equals(Boolean.class)) {
            any.insert_boolean(((Boolean)Boolean.class.cast(t)).booleanValue());
            return any;
        }
        if (this.klass.equals(Time.class)) {
            TimeHelper.insert(any, (Time)Time.class.cast(t));
            return any;
        }
        if (this.klass.equals(TimedBoolean.class)) {
            TimedBoolean timedBoolean = (TimedBoolean)TimedBoolean.class.cast(t);
            timedBoolean.tm = this.fillTime(timedBoolean.tm);
            TimedBooleanHelper.insert(any, timedBoolean);
            return any;
        }
        if (this.klass.equals(TimedChar.class)) {
            TimedChar timedChar = (TimedChar)TimedChar.class.cast(t);
            timedChar.tm = this.fillTime(timedChar.tm);
            TimedCharHelper.insert(any, timedChar);
            return any;
        }
        if (this.klass.equals(TimedDouble.class)) {
            TimedDouble timedDouble = (TimedDouble)TimedDouble.class.cast(t);
            timedDouble.tm = this.fillTime(timedDouble.tm);
            TimedDoubleHelper.insert(any, timedDouble);
            return any;
        }
        if (this.klass.equals(TimedFloat.class)) {
            TimedFloat timedFloat = (TimedFloat)TimedFloat.class.cast(t);
            timedFloat.tm = this.fillTime(timedFloat.tm);
            TimedFloatHelper.insert(any, timedFloat);
            return any;
        }
        if (this.klass.equals(TimedLong.class)) {
            TimedLong timedLong = (TimedLong)TimedLong.class.cast(t);
            timedLong.tm = this.fillTime(timedLong.tm);
            TimedLongHelper.insert(any, timedLong);
            return any;
        }
        if (this.klass.equals(TimedOctet.class)) {
            TimedOctet timedOctet = (TimedOctet)TimedOctet.class.cast(t);
            timedOctet.tm = this.fillTime(timedOctet.tm);
            TimedOctetHelper.insert(any, timedOctet);
            return any;
        }
        if (this.klass.equals(TimedShort.class)) {
            TimedShort timedShort = (TimedShort)TimedShort.class.cast(t);
            timedShort.tm = this.fillTime(timedShort.tm);
            TimedShortHelper.insert(any, timedShort);
            return any;
        }
        if (this.klass.equals(TimedState.class)) {
            TimedState timedState = (TimedState)TimedState.class.cast(t);
            timedState.tm = this.fillTime(timedState.tm);
            TimedStateHelper.insert(any, timedState);
            return any;
        }
        if (this.klass.equals(TimedString.class)) {
            TimedString timedString = (TimedString)TimedString.class.cast(t);
            timedString.tm = this.fillTime(timedString.tm);
            timedString.data = this.fillString(timedString.data);
            TimedStringHelper.insert(any, timedString);
            return any;
        }
        if (this.klass.equals(TimedULong.class)) {
            TimedULong timedULong = (TimedULong)TimedULong.class.cast(t);
            timedULong.tm = this.fillTime(timedULong.tm);
            TimedULongHelper.insert(any, timedULong);
            return any;
        }
        if (this.klass.equals(TimedUShort.class)) {
            TimedUShort timedUShort = (TimedUShort)TimedUShort.class.cast(t);
            timedUShort.tm = this.fillTime(timedUShort.tm);
            TimedUShortHelper.insert(any, timedUShort);
            return any;
        }
        if (this.klass.equals(TimedBooleanSeq.class)) {
            TimedBooleanSeq timedBooleanSeq = (TimedBooleanSeq)TimedBooleanSeq.class.cast(t);
            timedBooleanSeq.tm = this.fillTime(timedBooleanSeq.tm);
            TimedBooleanSeqHelper.insert(any, timedBooleanSeq);
            return any;
        }
        if (this.klass.equals(TimedCharSeq.class)) {
            TimedCharSeq timedCharSeq = (TimedCharSeq)TimedCharSeq.class.cast(t);
            timedCharSeq.tm = this.fillTime(timedCharSeq.tm);
            TimedCharSeqHelper.insert(any, timedCharSeq);
            return any;
        }
        if (this.klass.equals(TimedDoubleSeq.class)) {
            TimedDoubleSeq timedDoubleSeq = (TimedDoubleSeq)TimedDoubleSeq.class.cast(t);
            timedDoubleSeq.tm = this.fillTime(timedDoubleSeq.tm);
            TimedDoubleSeqHelper.insert(any, timedDoubleSeq);
            return any;
        }
        if (this.klass.equals(TimedFloatSeq.class)) {
            TimedFloatSeq timedFloatSeq = (TimedFloatSeq)TimedFloatSeq.class.cast(t);
            timedFloatSeq.tm = this.fillTime(timedFloatSeq.tm);
            TimedFloatSeqHelper.insert(any, timedFloatSeq);
            return any;
        }
        if (this.klass.equals(TimedLongSeq.class)) {
            TimedLongSeq timedLongSeq = (TimedLongSeq)TimedLongSeq.class.cast(t);
            timedLongSeq.tm = this.fillTime(timedLongSeq.tm);
            TimedLongSeqHelper.insert(any, timedLongSeq);
            return any;
        }
        if (this.klass.equals(TimedOctetSeq.class)) {
            TimedOctetSeq timedOctetSeq = (TimedOctetSeq)TimedOctetSeq.class.cast(t);
            timedOctetSeq.tm = this.fillTime(timedOctetSeq.tm);
            TimedOctetSeqHelper.insert(any, timedOctetSeq);
            return any;
        }
        if (this.klass.equals(TimedShortSeq.class)) {
            TimedShortSeq timedShortSeq = (TimedShortSeq)TimedShortSeq.class.cast(t);
            timedShortSeq.tm = this.fillTime(timedShortSeq.tm);
            TimedShortSeqHelper.insert(any, timedShortSeq);
            return any;
        }
        if (this.klass.equals(TimedStringSeq.class)) {
            TimedStringSeq timedStringSeq = (TimedStringSeq)TimedStringSeq.class.cast(t);
            timedStringSeq.tm = this.fillTime(timedStringSeq.tm);
            TimedStringSeqHelper.insert(any, timedStringSeq);
            return any;
        }
        if (this.klass.equals(TimedULongSeq.class)) {
            TimedULongSeq timedULongSeq = (TimedULongSeq)TimedULongSeq.class.cast(t);
            timedULongSeq.tm = this.fillTime(timedULongSeq.tm);
            TimedULongSeqHelper.insert(any, timedULongSeq);
            return any;
        }
        if (this.klass.equals(TimedUShortSeq.class)) {
            TimedUShortSeq timedUShortSeq = (TimedUShortSeq)TimedUShortSeq.class.cast(t);
            timedUShortSeq.tm = this.fillTime(timedUShortSeq.tm);
            TimedUShortSeqHelper.insert(any, timedUShortSeq);
            return any;
        }
        String string = this.klass.getCanonicalName();
        if (string == null) {
            throw new IllegalStateException("Cannot get class name.");
        }
        try {
            Class<?> clazz = Class.forName(string, true, this.klass.getClassLoader());
            java.lang.Object obj = clazz.cast(t);
            Class<?> clazz2 = Class.forName(string + "Helper", true, this.klass.getClassLoader());
            Method method = clazz2.getMethod("insert", Any.class, clazz);
            method.invoke(null, any, obj);
            return any;
        }
        catch (Exception exception) {
            throw new ClassCastException("Unknown data type.");
        }
    }

    public static String getDataTypeCodeName(Class clazz) {
        return clazz.getSimpleName();
    }

    public String getDataTypeCodeName() {
        return TypeCast.getDataTypeCodeName(this.klass);
    }

    private Time fillTime(Time time) {
        if (time != null) {
            return time;
        }
        long l = System.currentTimeMillis();
        int n = (int)(l / 1000L);
        int n2 = (int)(l % 1000L * 1000000L);
        return new Time(n, n2);
    }

    private String fillString(String string) {
        if (string != null) {
            return string;
        }
        return new String();
    }

    private T replaceNull(T t) {
        if (t != null) {
            return t;
        }
        if (this.klass.equals(Byte.class)) {
            return (T)new Byte(0);
        }
        if (this.klass.equals(Double.class)) {
            return (T)new Double(0.0);
        }
        if (this.klass.equals(Float.class)) {
            return (T)new Float(0.0f);
        }
        if (this.klass.equals(Integer.class)) {
            return (T)new Integer(0);
        }
        if (this.klass.equals(Long.class)) {
            return (T)new Long(0L);
        }
        if (this.klass.equals(Short.class)) {
            return (T)new Short(0);
        }
        if (this.klass.equals(Time.class)) {
            return (T)new Time();
        }
        if (this.klass.equals(TimedBoolean.class)) {
            return (T)new TimedBoolean();
        }
        if (this.klass.equals(TimedChar.class)) {
            return (T)new TimedChar();
        }
        if (this.klass.equals(TimedDouble.class)) {
            return (T)new TimedDouble();
        }
        if (this.klass.equals(TimedFloat.class)) {
            return (T)new TimedFloat();
        }
        if (this.klass.equals(TimedLong.class)) {
            return (T)new TimedLong();
        }
        if (this.klass.equals(TimedOctet.class)) {
            return (T)new TimedOctet();
        }
        if (this.klass.equals(TimedShort.class)) {
            return (T)new TimedShort();
        }
        if (this.klass.equals(TimedState.class)) {
            return (T)new TimedState();
        }
        if (this.klass.equals(TimedString.class)) {
            return (T)new TimedString();
        }
        if (this.klass.equals(TimedULong.class)) {
            return (T)new TimedULong();
        }
        if (this.klass.equals(TimedUShort.class)) {
            return (T)new TimedUShort();
        }
        if (this.klass.equals(TimedBooleanSeq.class)) {
            return (T)new TimedBooleanSeq(null, new boolean[0]);
        }
        if (this.klass.equals(TimedCharSeq.class)) {
            return (T)new TimedCharSeq(null, new char[0]);
        }
        if (this.klass.equals(TimedDoubleSeq.class)) {
            return (T)new TimedDoubleSeq(null, new double[0]);
        }
        if (this.klass.equals(TimedFloatSeq.class)) {
            return (T)new TimedFloatSeq(null, new float[0]);
        }
        if (this.klass.equals(TimedLongSeq.class)) {
            return (T)new TimedLongSeq(null, new int[0]);
        }
        if (this.klass.equals(TimedOctetSeq.class)) {
            return (T)new TimedOctetSeq(null, new byte[0]);
        }
        if (this.klass.equals(TimedShortSeq.class)) {
            return (T)new TimedShortSeq(null, new short[0]);
        }
        if (this.klass.equals(TimedStringSeq.class)) {
            return (T)new TimedStringSeq(null, new String[0]);
        }
        if (this.klass.equals(TimedULongSeq.class)) {
            return (T)new TimedULongSeq(null, new int[0]);
        }
        if (this.klass.equals(TimedUShortSeq.class)) {
            return (T)new TimedUShortSeq(null, new short[0]);
        }
        throw new ClassCastException("Unknown data type.");
    }
}

