#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file ECFactory.py
# @brief ExecutionContext Factory class
# @date $Date: 2007/04/13 16:06:22 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
# 
# Copyright (C) 2007-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


import string

import OpenRTM_aist


##
# @if jp
#
# @brief ExecutionContext˴Ѵؿ
# 
# ExecutionContextΥ󥹥󥹤˴뤿δؿ
#
# \param ec ˴оExecutionContextΥ󥹥
#
# @else
#
# @endif
def ECDelete(ec):
  del ec


##
# @if jp
# @class ECFactoryBase
# @brief ECFactoryBase ݥ饹
# 
# ExecutionContextFactoryݥ饹
# ExecutionContext뤿ζFactory饹ϡ
# ʲδؿμ󶡤ʤФʤʤ
#
# public󥿡եȤưʲΤΤ󶡤롣
# - name()   : оExecutionContext̾Τμ
# - create() : ExecutionContext󥹥󥹤
# - destroy(): ExecutionContext󥹥󥹤˴
#
# @since 0.4.0
#
# @else
#
# @endif
class ECFactoryBase :
  """
  """

  ##
  # @if jp
  #
  # @brief оExecutionContext̾μѴؿ(֥饹)
  # 
  # оExecutionContext̾Τ뤿δؿ<BR>
  # δؿ϶ݥ֥饹Ǽɬפ롣
  #
  # @param self
  #
  # @return оExecutionContext̾
  # 
  # @else
  # 
  # This method should be implemented in subclasses
  #
  # @endif
  def name(self):
    pass


  ##
  # @if jp
  #
  # @brief ExecutionContextѴؿ(֥饹)
  # 
  # ExecutionContextΥ󥹥󥹤뤿δؿ<BR>
  # δؿ϶ݥ֥饹Ǽɬפ롣
  #
  # @param self
  #
  # @return ExecutionContext󥹥
  # 
  # @else
  #
  # @endif
  def create(self):
    pass

  ##
  # @if jp
  #
  # @brief ExecutionContext˴Ѵؿ(֥饹)
  # 
  # ExecutionContextΥ󥹥󥹤˴뤿δؿ<BR>
  # δؿ϶ݥ֥饹Ǽɬפ롣
  #
  # @param self
  # @param comp ˴оݤExecutionContext󥹥
  # 
  # @else
  #
  # @endif
  def destroy(self, comp):
    pass



##
# @if jp
# @class ECFactoryPython
# @brief ECFactoryPython 饹
# 
# PythonExecutionContext󥹥󥹤Factory饹
#
# @since 0.4.1
#
# @else
#
# @endif
class ECFactoryPython(ECFactoryBase):
  """
  """

  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  # 
  # 󥹥ȥ饯
  #
  # @param self
  # @param name оExecutionContext̾
  # @param new_func ExecutionContextѴؿ
  # @param delete_func ExecutionContext˴Ѵؿ
  # 
  # @else
  #
  # @endif
  def __init__(self, name, new_func, delete_func):
    self._name   = name
    self._New    = new_func
    self._Delete = delete_func
    
    return


  ##
  # @if jp
  #
  # @brief оExecutionContext̾Τ
  # 
  # оݤExecutionContext̾Τ롣
  #
  # @param self
  #
  # @return оExecutionContext̾
  # 
  # @else
  #
  # @endif
  def name(self):
    return self._name

  ##
  # @if jp
  #
  # @brief оExecutionContext󥹥󥹤
  # 
  # оݤExecutionContext饹Υ󥹥󥹤롣
  #
  # @param self
  #
  # @return ExecutionContext󥹥
  # 
  # @else
  #
  # @endif
  def create(self):
    return self._New()

  ##
  # @if jp
  #
  # @brief оExecutionContext󥹥󥹤˴
  # 
  # оExecutionContext饹Υ󥹥󥹤˴롣
  #
  # @param self
  # @param ec ˴оExecutionContext󥹥
  # 
  # @else
  #
  # @endif
  def destroy(self, ec):
    self._Delete(ec)
    
