#!/usr/bin/env python
# -*- coding: euc-jp -*-


##
# @file OutPort.py
# @brief OutPort class
# @date $Date: 2007/09/19$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
# 
# Copyright (C) 2006-2008
#     Noriaki Ando
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


from omniORB import *
from omniORB import any

import OpenRTM_aist


##
# @if jp
# @brief ǡ˥ॹפ򥻥åȤ
#
# ǡݡȤΥǡФƥॹפ򥻥åȤ롣ǡݡ
# ΥǡϹ¤ΤΥСȤ tm.sec, tm.nsec ɬפ롣
#
# @param data ॹפ򥻥åȤǡ¹Ը¹ԻΥॹ
#             פåȤ
#
# @else
# @brief Setting timestamp to data
#
# This function sets timestamp to data of data port. This data should
# have tm.sec, tm.nsec as members of the structure.
#
# @param data Data to be set timestamp. After executing this
#             function, current timestamp is set to the data.
#
# @endif
# template <class DataType>
# void setTimestamp(DataType& data)
def setTimestamp(data):
  # set timestamp
  tm = OpenRTM_aist.Time()
  data.tm.sec  = tm.sec
  data.tm.nsec = tm.usec * 1000


##
# @if jp
#
# @class OutPort
#
# @brief OutPort 饹
# 
# OutPort ѥ饹
#
# @since 0.2.0
#
# @else
# 
# @endif
class OutPort(OpenRTM_aist.OutPortBase):
  """
  """



  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param name ݡ̾
  # @param value ΥݡȤ˥Хɤǡѿ
  # @param buffer_ Хåե
  #
  # @else
  #
  # @brief Constructor
  #
  # @endif
  def __init__(self, name, value, buffer=None):
    OpenRTM_aist.OutPortBase.__init__(self, name, OpenRTM_aist.toTypename(value))
    self._value          = value
    #self._timeoutTick    = 1000 # timeout tick: 1ms
    #self._writeBlock     = False
    #self._writeTimeout   = 0
    self._OnWrite        = None
    self._OnWriteConvert = None
    #self._OnOverflow     = None
    #self._OnUnderflow    = None
    #self._OnConnect      = None
    #self._OnDisconnect   = None
    

  def __del__(self, OutPortBase=OpenRTM_aist.OutPortBase):
    OutPortBase.__del__(self)
    return

  ##
  # @if jp
  #
  # @brief ǡ񤭹
  #
  # ݡȤإǡ񤭹ࡣ
  #
  # - Хåե󥯥 OnWrite åȤƤ硢
  #   OutPort ݻХåե˽񤭹 OnWrite ƤФ롣
  # - OutPort ݻХåեСե򸡽ФǤХåեǤꡢ
  #   ġ񤭹ݤ˥ХåեСե򸡽Ф硢
  #   Хåե󥯥 OnOverflow ƤФ롣
  # - Хåե󥯥 OnWriteConvert åȤƤ硢
  #   Хåե񤭹߻ˡ OnWriteConvert  operator() ͤ
  #   Хåե˽񤭹ޤ롣
  #
  # @param self
  # @param value 񤭹оݥǡ
  #
  # @return 񤭹߽(񤭹:true񤭹߼:false)
  #
  # @else
  #
  # @brief Write data
  #
  # @endif
  # virtual bool write(const DataType& value)
  ##
  # @if jp
  #
  # @brief ǡ񤭹
  #
  # ݡȤإǡ񤭹ࡣ
  # ꤵ줿ͤݡȤ˽񤭹ࡣ
  #
  # @param self
  # @param value 񤭹оݥǡ
  #
  # @return 񤭹߽(񤭹:true񤭹߼:false)
  #
  # @else
  #
  # @endif
  # bool operator<<(DataType& value)
  def write(self, value=None):
    if not value:
      value=self._value

    
    if self._OnWrite:
      self._OnWrite(value)

    # check number of connectors
    conn_size = len(self._connectors)
    if not conn_size > 0:
      return True
  
    # set timestamp
    #tm = Time()
    #value.tm.sec  = tm.sec
    #value.tm.nsec = tm.usec * 1000

    #tm_pre = Time()

    if self._OnWriteConvert:
      value = self._OnWriteConvert(value)
      
    result = True

    guard = OpenRTM_aist.ScopedLock(self._connector_mutex)
    for con in self._connectors:
      ret = con.write(value)
      if ret != self.PORT_OK:
        result = False
        if ret == self.CONNECTION_LOST:
          self.disconnect(con.id())

    return result


  ##
  # @if jp
  #
  # @brief ǡ񤭹߽Υ֥å⡼ɤ
  #
  # 񤭹߽Фƥ֥å⡼ɤꤹ롣
  # ֥å⡼ɤꤷ硢Хåե˽񤭹ΰ褬Ǥ뤫
  # ॢȤȯޤ write() ᥽åɤθƤӤ֥å롣
  #
  # @param self
  # @param block ֥å⡼ɥե饰
  #
  # @else
  #
  # @brief Set read() block mode
  #
  # @endif
  #def setWriteBlock(self, block):
  #  self._writeBlock = block


  ##
  # @if jp
  #
  # @brief 񤭹߽ΥॢȻ֤
  # 
  # write() ΥॢȻ֤ usec ꤹ롣
  # write() ϥ֥å⡼ɤǤʤФʤʤ
  #
  # @param self
  # @param timeout ॢȻ [usec]
  #
  # @else
  #
  # @brief Set write() timeout
  #
  # @endif
  #def setWriteTimeout(self, timeout):
  #  self._writeTimeout = timeout


  ##
  # @if jp
  #
  # @brief OnWrite Хå
  #
  # ǡ񤭹ľ˸ƤФ OnWrite Хåե󥯥ꤹ롣
  #
  # @param self
  # @param on_write OnWrite Хåե󥯥
  #
  # @else
  #
  # @brief Set OnWrite callback
  #
  # @endif
  def setOnWrite(self, on_write):
    self._OnWrite = on_write


  ##
  # @if jp
  #
  # @brief OnWriteConvert Хå
  #
  # ǡ񤭹߻˸ƤФ OnWriteConvert Хåե󥯥
  # 롣
  # ΥХåؿν̤񤭹ޤ롣
  # Τ񤭹ߥǡΥե륿󥰤ǽȤʤ롣
  #
  # @param self
  # @param on_wconvert OnWriteConvert Хåե󥯥
  #
  # @else
  #
  # @brief Set OnWriteConvert callback
  #
  # @endif
  def setOnWriteConvert(self, on_wconvert):
    self._OnWriteConvert = on_wconvert


  ##
  # @if jp
  #
  # @brief ǡ̾ѥ᥽å
  #
  # ǡη̾뤿ᡢInPortCorbaProviderƤФ롣
  # 
  # @param self
  #
  # @return ХåեꤵƤǡη̾
  #
  # @else
  #
  # @endif
  def getPortDataType(self):
    val = any.to_any(self._value)
    return str(val.typecode().name())



  class subscribe:
    def __init__(self, prof, subs = None):
      if subs:
        self._prof = subs._prof
        self._consumer = subs._consumer
        return

      self._prof = prof
      self._consumer = None
      

    def __call__(self, cons):
      if cons.subscribeInterface(self._prof.properties):
        self._consumer = cons
