#!/bin/sh
#
# @file pkg_install_vine.sh
# @brief OpenRTM-aist dependent packages installation script for Vine Linux
# @author Noriaki Ando <n-ando@aist.go.jp>
#         Shinji Kurihara
#         Tetsuo Ando
#
# Υ륹ץȤϡaceomniORBΥѥå򥤥󥹥ȡ뤷
# Vine LinuxγȯĶۤޤ
#
#---------------------------------------
# VineС
#---------------------------------------
vinever=`cat /etc/vine-release | sed 's/.*\([0-9].[0-9]\).*/\1/'`

#---------------------------------------
# ݥȥꥵ
#---------------------------------------
openrtm_repo="rpm     http://www.openrtm.org/pub/Linux/Vine/apt $vinever/\$(ARCH) main"

#---------------------------------------
# ѥåꥹ
#---------------------------------------
omnipy="python omniORB-servers omniORBpy omniORBpy-devel omniORBpy-standard"
openrtm="OpenRTM-aist-Python OpenRTM-aist-Python-example"
packages="$omnipy $openrtm"




#----------------------------------------
# root ɤå
#----------------------------------------
check_root () {
    if test ! `id -u` = 0 ; then
	echo ""
	echo "This script should be run by root user."
	echo "Abort."
	echo ""
	exit 1
    fi
}

#---------------------------------------
# ꥹȹؿ
#---------------------------------------
update_source_list () {
    rtmsite=`grep openrtm /etc/apt/sources.list`
    if test "x$rtmsite" = "x" ; then
	echo "OpenRTM-aist Υݥȥ꤬ϿƤޤ"
	echo "Source.list  OpenRTM-aist Υݥȥ: "
	echo "  " $openrtm_repo
	read -p "ɲäޤǤ (y/n) [y] " kick_shell

	if test "x$kick_shell" = "xn" ; then
	    echo "Ǥޤ"
	    exit 0
	else
	    echo $openrtm_repo >> /etc/apt/sources.list
	fi
    fi
}

#----------------------------------------
# ѥå򥤥󥹥ȡ뤹
#----------------------------------------
install_packages () {
    for p in $*; do
	if test "x$p" = "x0.4.2" ; then
	    :
	else
	    if echo "$p" | grep -q '=0.4.2' ; then
		str=`echo "$p" |sed 's/=0.4.2//'`
	    else 
		str="$p"
	    fi

	    ins=`rpm -qa $str`

	    if test "x$ins" = "x"; then
		echo "Now installing: " $p
		apt-get install $p
		echo "done."
		echo ""
	    else  
		if echo "$ins" |grep -q '0.4.2-0' ; then
			apt-get install $p
			echo "done." 
			echo ""
	       else 
 		    echo $ins
		    echo $str "is already installed."
		    echo ""
		fi
	    fi
	fi
    done
}


#------------------------------------------------------------
# ꥹȤսˤ
#------------------------------------------------------------
reverse () {
    for i in $*; do
	echo $i
    done | sed '1!G;h;$!d'
}

#----------------------------------------
# ѥå򥢥󥤥󥹥ȡ뤹
#----------------------------------------
uninstall_packages () {
    for p in $*; do
	echo "Now uninstalling: " $p
	rpm -e $p
	echo "done."
	echo ""
    done
}



#---------------------------------------
# ᥤ
#---------------------------------------
check_root
if test "x$1" = "x-u" ; then
    uninstall_packages `reverse $packages`
else
    update_source_list
    apt-get update
    install_packages $packages
fi

