/*******************************************************************************
 *  ObjectProperties.cpp
 *
 *  (C) 2008 AG Aktives Sehen <agas@uni-koblenz.de>
 *           Universitaet Koblenz-Landau
 *
 *  Information on Code Review state:
 *  Author: <initials>; DevelTest: Date; Reviewer: Initials; Review: Date; State: NOK
 *
 *  Additional information:
 *  $Id: ObjectProperties.cpp 31722 2009-04-23 12:48:01Z sisuthie $
 *******************************************************************************/


#include <or_libs/ObjectRecognition/ObjectProperties.h>


ObjectProperties::ObjectProperties( std::string name )
{
    m_Name=name;
    m_Type="";
}


ObjectProperties::~ObjectProperties()
{
    for ( unsigned i=0; i < m_ImageProperties.size(); i++)
    {
        if ( m_ImageProperties[i] )
        {
            delete m_ImageProperties[i];
        }
    }
}


ObjectProperties::ObjectProperties(const ObjectProperties& other)
{
    *this = other;
}


ObjectProperties& ObjectProperties::operator=(const ObjectProperties& other)
                     {
    for ( unsigned i=0; i < m_ImageProperties.size(); i++)
    {
        if ( m_ImageProperties[i] ) { delete m_ImageProperties[i]; }
    }
    m_ImageProperties.clear();

    //copy new data
    m_Name = other.m_Name;
    m_Type = other.m_Type;

    for ( unsigned i=0; i < other.m_ImageProperties.size(); i++)
    {
        m_ImageProperties.push_back( new ImagePropertiesCV( *(other.m_ImageProperties[i]) ) );
    }

    return *this;
}

void ObjectProperties::addImageProperties( ImagePropertiesCV* imageProperties )
{
    m_ImageProperties.push_back( imageProperties );
}

void ObjectProperties::deleteImageProperties( std::string name )
{
  std::vector<ImagePropertiesCV*> newImageProperties;

  for ( unsigned i=0; i<m_ImageProperties.size(); i++ )
  {
    if ( m_ImageProperties[i]->getName() == name )
    {
      delete m_ImageProperties[i];
    }
    else
    {
      newImageProperties.push_back( m_ImageProperties[i] );
    }
  }

  m_ImageProperties = newImageProperties;
}

void ObjectProperties::deleteImageProperties( int index )
{
  std::vector<ImagePropertiesCV*> newImageProperties;

  for ( unsigned i=0; i<m_ImageProperties.size(); i++ )
  {
    if ( i == (unsigned) index )
    {
      delete m_ImageProperties[i];
    }
    else
    {
      newImageProperties.push_back( m_ImageProperties[i] );
    }
  }

  m_ImageProperties = newImageProperties;
}


void ObjectProperties::deleteAll()
{
	m_ImageProperties.clear();
}


const ImagePropertiesCV* ObjectProperties::getImageProperties( std::string name ) const
{
  for ( unsigned i=0; i<m_ImageProperties.size(); i++ )
  {
    if ( m_ImageProperties[i]->getName() == name )
    {
      return m_ImageProperties[i];
    }
  }
  return 0;
}

std::vector<std::string> ObjectProperties::getImageNames()
{
  std::vector<std::string> result;
  result.reserve( m_ImageProperties.size() );

  for ( unsigned i=0; i<m_ImageProperties.size(); i++ )
  {
    result.push_back( m_ImageProperties[i]->getName() );
//     TRACE_INFO( m_ImageProperties[i]->getName() )
  }


  return result;
}


void ObjectProperties::printOn( std::ostream& strm )
{
    unsigned size=m_ImageProperties.size();

    strm << "Object name: " << m_Name << std::endl;
    strm << "Object type: " << m_Type << std::endl;
    strm << "# of images: " << size << std::endl << std::endl;

    strm << "Number keypoints in images:";
    for ( unsigned i=0; i < size; i++)
    {
        strm << " " << m_ImageProperties[i]->getKeyPoints()->size();
    }

    strm << std::endl << std::endl;
}

#undef THIS
