/*
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateDeviceControllerCategories.py script *
 *                                                        *
 **********************************************************/
#import <Foundation/Foundation.h>
#import <libARCommands/ARCommands.h>

#import "ARNetworkConfig.h"
#import "DeviceController.h"

/*
 * State sent when all settings has been sent.
 */
extern NSString *const DeviceControllerSettingsStateAllSettingsChangedNotification;
/*
 * State sent when all settings has been resetting.
 */
extern NSString *const DeviceControllerSettingsStateResetChangedNotification;
/*
 * Product name
 */
extern NSString *const DeviceControllerSettingsStateProductNameChangedNotification;
extern NSString *const DeviceControllerSettingsStateProductNameChangedNotificationNameKey; /* Product name */
/*
 * Product versions
 */
extern NSString *const DeviceControllerSettingsStateProductVersionChangedNotification;
extern NSString *const DeviceControllerSettingsStateProductVersionChangedNotificationSoftwareKey; /* Product software version */
extern NSString *const DeviceControllerSettingsStateProductVersionChangedNotificationHardwareKey; /* Product hardware version */
/*
 * Product serial number
 */
extern NSString *const DeviceControllerSettingsStateProductSerialHighChangedNotification;
extern NSString *const DeviceControllerSettingsStateProductSerialHighChangedNotificationHighKey; /* Serial high number (hexadecimal value) */
/*
 * Product serial number
 */
extern NSString *const DeviceControllerSettingsStateProductSerialLowChangedNotification;
extern NSString *const DeviceControllerSettingsStateProductSerialLowChangedNotificationLowKey; /* Serial low number (hexadecimal value) */
/*
 * Inform current Country set in product. (Answer to 'Country' command)
 */
extern NSString *const DeviceControllerSettingsStateCountryChangedNotification;
extern NSString *const DeviceControllerSettingsStateCountryChangedNotificationCodeKey; /* Country code with ISO 3166 format, empty string means unknown country. */
/*
 * Inform Auto Country Settings
 */
extern NSString *const DeviceControllerSettingsStateAutoCountryChangedNotification;
extern NSString *const DeviceControllerSettingsStateAutoCountryChangedNotificationAutomaticKey; /* Boolean : 0 : Manual / 1 : Auto */
/*
 * State sent when all product states has been sent.
 */
extern NSString *const DeviceControllerCommonStateAllStatesChangedNotification;
/*
 * Battery state
 */
extern NSString *const DeviceControllerCommonStateBatteryStateChangedNotification;
extern NSString *const DeviceControllerCommonStateBatteryStateChangedNotificationPercentKey; /* Battery percentage */
/*
 * Mass storage state list
 */
extern NSString *const DeviceControllerCommonStateMassStorageStateListChangedNotification;
extern NSString *const DeviceControllerCommonStateMassStorageStateListChangedNotificationMass_storage_idKey; /* Mass storage id (unique) */
extern NSString *const DeviceControllerCommonStateMassStorageStateListChangedNotificationNameKey; /* Mass storage name */
/*
 * Mass storage info state list
 */
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotification;
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationMass_storage_idKey; /* Mass storage state id (unique) */
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationSizeKey; /* Mass storage size in MBytes */
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationUsed_sizeKey; /* Mass storage used size in MBytes */
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationPluggedKey; /* Mass storage plugged (1 if mass storage is plugged, otherwise 0) */
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationFullKey; /* Mass storage full information state (1 if mass storage full, 0 otherwise). */
extern NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationInternalKey; /* Mass storage internal type state (1 if mass storage is internal, 0 otherwise) */
/*
 * Current date state
 */
extern NSString *const DeviceControllerCommonStateCurrentDateChangedNotification;
extern NSString *const DeviceControllerCommonStateCurrentDateChangedNotificationDateKey; /* Date with ISO-8601 format */
/*
 * Current time state
 */
extern NSString *const DeviceControllerCommonStateCurrentTimeChangedNotification;
extern NSString *const DeviceControllerCommonStateCurrentTimeChangedNotificationTimeKey; /* Time with ISO-8601 format */
/*
 * Mass storage info remaining list
 */
extern NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification;
extern NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationFree_spaceKey; /* Mass storage free space in MBytes */
extern NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationRec_timeKey; /* Mass storage record time reamining in minute */
extern NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationPhoto_remainingKey; /* Mass storage photo remaining */
/*
 * Wifi Signal between controller and product state
 */
extern NSString *const DeviceControllerCommonStateWifiSignalChangedNotification;
extern NSString *const DeviceControllerCommonStateWifiSignalChangedNotificationRssiKey; /* RSSI of the signal between controller and the product (in dbm) */
/*
 * Overheat temperature reached
 */
extern NSString *const DeviceControllerOverHeatStateOverHeatChangedNotification;
/*
 * Overheat regulation state changed
 */
extern NSString *const DeviceControllerOverHeatStateOverHeatRegulationChangedNotification;
extern NSString *const DeviceControllerOverHeatStateOverHeatRegulationChangedNotificationRegulationTypeKey; /* Type of overheat regulation : 0 for ventilation, 1 for switch off */
/*
 * Tell the device when the controller application enters/leaves the piloting HUD.
 */
extern NSString *const DeviceControllerControllerStateIsPilotingChangedNotification;
extern NSString *const DeviceControllerControllerStateIsPilotingChangedNotificationPilotingKey; /* 0 when the application is not in the piloting HUD, 1 when it enters the HUD. */
/*
 * Status of the wifi config : either indoor or outdoor
 */
extern NSString *const DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotification;
extern NSString *const DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotificationOutdoorKey; /* 1 if it should use outdoor wifi settings, 0 otherwise */
/*
 * Playing state of a mavlink flight plan
 */
extern NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotification;
extern NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationStateKey; /* State of the mavlink */
extern NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationFilepathKey; /* flight plan file path from the mavlink ftp root */
extern NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationTypeKey; /* type of the played mavlink file */
/*
 * FlightPlan play state error
 */
extern NSString *const DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotification;
extern NSString *const DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotificationErrorKey; /* State of play error */
/*
 * Sent when the state of the magneto calibration has changed
 */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotification;
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationXAxisCalibrationKey; /* State of the x axis (roll) calibration : 1 if calibration is done, 0 otherwise */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationYAxisCalibrationKey; /* State of the y axis (pitch) calibration : 1 if calibration is done, 0 otherwise */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationZAxisCalibrationKey; /* State of the z axis (yaw) calibration : 1 if calibration is done, 0 otherwise */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationCalibrationFailedKey; /* 1 if calibration has failed, 0 otherwise. If this arg is 1, consider all previous arg as 0 */
/*
 * Status of the calibration requirement
 */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotification;
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotificationRequiredKey; /* 1 if calibration is required, 0 if current calibration is still valid */
/*
 * Event sent by a product to inform about the axis to calibrate
 */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotification;
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotificationAxisKey; /* The axis to calibrate */
/*
 * Status of the calibration process
 */
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotification;
extern NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotificationStartedKey; /* 1 if calibration has started, 0 otherwise */
/*
 * Status of the camera settings
 */
extern NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotification;
extern NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationFovKey; /* Value of the camera horizontal fov (in degree) */
extern NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMaxKey; /* Value of max pan (right pan) (in degree) */
extern NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMinKey; /* Value of min pan (left pan) (in degree) */
extern NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMaxKey; /* Value of max tilt (top tilt) (in degree) */
extern NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMinKey; /* Value of min tilt (bottom tilt) (in degree) */

@class DeviceController;

@interface DeviceController (libARCommands)
- (void)registerCommonARCommandsCallbacks;
- (void)unregisterCommonARCommandsCallbacks;
/* 
 * Signals the remote that the host will disconnect and close its
 * libARNetwork instance (and all threads that use libARNetwork)
 */
- (BOOL)DeviceController_SendNetworkDisconnect:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Get all product settings, the product must send all settings
 */
- (BOOL)DeviceController_SendSettingsAllSettings:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Reset all settings
 */
- (BOOL)DeviceController_SendSettingsReset:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Set Product name
 */
- (BOOL)DeviceController_SendSettingsProductName:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withName:(char *)name;
/* 
 * Set current Country of controller
 */
- (BOOL)DeviceController_SendSettingsCountry:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCode:(char *)code;
/* 
 * Set Auto Country Settings
 */
- (BOOL)DeviceController_SendSettingsAutoCountry:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withAutomatic:(uint8_t)automatic;
/* 
 * Get all product states.
 */
- (BOOL)DeviceController_SendCommonAllStates:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Set current date of controller
 */
- (BOOL)DeviceController_SendCommonCurrentDate:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withDate:(char *)date;
/* 
 * Set current time of controller
 */
- (BOOL)DeviceController_SendCommonCurrentTime:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withTime:(char *)time;
/* 
 * Command to ask reboot to product
 */
- (BOOL)DeviceController_SendCommonReboot:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Switch off the drone when a overheat appeared
 */
- (BOOL)DeviceController_SendOverHeatSwitchOff:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Ventilate the drone when a overheat appeared
 */
- (BOOL)DeviceController_SendOverHeatVentilate:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Send to product if it should use its outdoor wifi config, or indoor
 */
- (BOOL)DeviceController_SendWifiSettingsOutdoorSetting:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withOutdoor:(uint8_t)outdoor;
/* 
 * Start the flight plan
 */
- (BOOL)DeviceController_SendMavlinkStart:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withFilepath:(char *)filepath withType:(eARCOMMANDS_COMMON_MAVLINK_START_TYPE)type;
/* 
 * Pause the flightplan (can be restarted with a start)
 */
- (BOOL)DeviceController_SendMavlinkPause:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Stop the flightplan
 */
- (BOOL)DeviceController_SendMavlinkStop:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Sent when a calibration of the magnetometer is asked or is aborted
 */
- (BOOL)DeviceController_SendCalibrationMagnetoCalibration:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCalibrate:(uint8_t)calibrate;
@end

// END GENERATED CODE
