/*
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateDeviceControllerCategories.py script *
 *                                                        *
 **********************************************************/
#import <libARSAL/ARSAL.h>
#import "DeviceControllerProtected.h"
#import "DeviceController+libARCommands.h"

NSString *const DeviceControllerSettingsStateAllSettingsChangedNotification = @"DeviceControllerSettingsStateAllSettingsChangedNotification";
NSString *const DeviceControllerSettingsStateResetChangedNotification = @"DeviceControllerSettingsStateResetChangedNotification";
NSString *const DeviceControllerSettingsStateProductNameChangedNotification = @"DeviceControllerSettingsStateProductNameChangedNotification";
NSString *const DeviceControllerSettingsStateProductNameChangedNotificationNameKey = @"DeviceControllerSettingsStateProductNameChangedNotificationNameKey";
NSString *const DeviceControllerSettingsStateProductVersionChangedNotification = @"DeviceControllerSettingsStateProductVersionChangedNotification";
NSString *const DeviceControllerSettingsStateProductVersionChangedNotificationSoftwareKey = @"DeviceControllerSettingsStateProductVersionChangedNotificationSoftwareKey";
NSString *const DeviceControllerSettingsStateProductVersionChangedNotificationHardwareKey = @"DeviceControllerSettingsStateProductVersionChangedNotificationHardwareKey";
NSString *const DeviceControllerSettingsStateProductSerialHighChangedNotification = @"DeviceControllerSettingsStateProductSerialHighChangedNotification";
NSString *const DeviceControllerSettingsStateProductSerialHighChangedNotificationHighKey = @"DeviceControllerSettingsStateProductSerialHighChangedNotificationHighKey";
NSString *const DeviceControllerSettingsStateProductSerialLowChangedNotification = @"DeviceControllerSettingsStateProductSerialLowChangedNotification";
NSString *const DeviceControllerSettingsStateProductSerialLowChangedNotificationLowKey = @"DeviceControllerSettingsStateProductSerialLowChangedNotificationLowKey";
NSString *const DeviceControllerSettingsStateCountryChangedNotification = @"DeviceControllerSettingsStateCountryChangedNotification";
NSString *const DeviceControllerSettingsStateCountryChangedNotificationCodeKey = @"DeviceControllerSettingsStateCountryChangedNotificationCodeKey";
NSString *const DeviceControllerSettingsStateAutoCountryChangedNotification = @"DeviceControllerSettingsStateAutoCountryChangedNotification";
NSString *const DeviceControllerSettingsStateAutoCountryChangedNotificationAutomaticKey = @"DeviceControllerSettingsStateAutoCountryChangedNotificationAutomaticKey";
NSString *const DeviceControllerCommonStateAllStatesChangedNotification = @"DeviceControllerCommonStateAllStatesChangedNotification";
NSString *const DeviceControllerCommonStateBatteryStateChangedNotification = @"DeviceControllerCommonStateBatteryStateChangedNotification";
NSString *const DeviceControllerCommonStateBatteryStateChangedNotificationPercentKey = @"DeviceControllerCommonStateBatteryStateChangedNotificationPercentKey";
NSString *const DeviceControllerCommonStateMassStorageStateListChangedNotification = @"DeviceControllerCommonStateMassStorageStateListChangedNotification";
NSString *const DeviceControllerCommonStateMassStorageStateListChangedNotificationMass_storage_idKey = @"DeviceControllerCommonStateMassStorageStateListChangedNotificationMass_storage_idKey";
NSString *const DeviceControllerCommonStateMassStorageStateListChangedNotificationNameKey = @"DeviceControllerCommonStateMassStorageStateListChangedNotificationNameKey";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotification = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotification";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationMass_storage_idKey = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationMass_storage_idKey";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationSizeKey = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationSizeKey";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationUsed_sizeKey = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationUsed_sizeKey";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationPluggedKey = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationPluggedKey";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationFullKey = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationFullKey";
NSString *const DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationInternalKey = @"DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationInternalKey";
NSString *const DeviceControllerCommonStateCurrentDateChangedNotification = @"DeviceControllerCommonStateCurrentDateChangedNotification";
NSString *const DeviceControllerCommonStateCurrentDateChangedNotificationDateKey = @"DeviceControllerCommonStateCurrentDateChangedNotificationDateKey";
NSString *const DeviceControllerCommonStateCurrentTimeChangedNotification = @"DeviceControllerCommonStateCurrentTimeChangedNotification";
NSString *const DeviceControllerCommonStateCurrentTimeChangedNotificationTimeKey = @"DeviceControllerCommonStateCurrentTimeChangedNotificationTimeKey";
NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification = @"DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification";
NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationFree_spaceKey = @"DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationFree_spaceKey";
NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationRec_timeKey = @"DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationRec_timeKey";
NSString *const DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationPhoto_remainingKey = @"DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationPhoto_remainingKey";
NSString *const DeviceControllerCommonStateWifiSignalChangedNotification = @"DeviceControllerCommonStateWifiSignalChangedNotification";
NSString *const DeviceControllerCommonStateWifiSignalChangedNotificationRssiKey = @"DeviceControllerCommonStateWifiSignalChangedNotificationRssiKey";
NSString *const DeviceControllerOverHeatStateOverHeatChangedNotification = @"DeviceControllerOverHeatStateOverHeatChangedNotification";
NSString *const DeviceControllerOverHeatStateOverHeatRegulationChangedNotification = @"DeviceControllerOverHeatStateOverHeatRegulationChangedNotification";
NSString *const DeviceControllerOverHeatStateOverHeatRegulationChangedNotificationRegulationTypeKey = @"DeviceControllerOverHeatStateOverHeatRegulationChangedNotificationRegulationTypeKey";
NSString *const DeviceControllerControllerStateIsPilotingChangedNotification = @"DeviceControllerControllerStateIsPilotingChangedNotification";
NSString *const DeviceControllerControllerStateIsPilotingChangedNotificationPilotingKey = @"DeviceControllerControllerStateIsPilotingChangedNotificationPilotingKey";
NSString *const DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotification = @"DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotification";
NSString *const DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotificationOutdoorKey = @"DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotificationOutdoorKey";
NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotification = @"DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotification";
NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationStateKey = @"DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationStateKey";
NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationFilepathKey = @"DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationFilepathKey";
NSString *const DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationTypeKey = @"DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationTypeKey";
NSString *const DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotification = @"DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotification";
NSString *const DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotificationErrorKey = @"DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotificationErrorKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotification = @"DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotification";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationXAxisCalibrationKey = @"DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationXAxisCalibrationKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationYAxisCalibrationKey = @"DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationYAxisCalibrationKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationZAxisCalibrationKey = @"DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationZAxisCalibrationKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationCalibrationFailedKey = @"DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationCalibrationFailedKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotification = @"DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotification";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotificationRequiredKey = @"DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotificationRequiredKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotification = @"DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotification";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotificationAxisKey = @"DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotificationAxisKey";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotification = @"DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotification";
NSString *const DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotificationStartedKey = @"DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotificationStartedKey";
NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotification = @"DeviceControllerCameraSettingsStateCameraSettingsChangedNotification";
NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationFovKey = @"DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationFovKey";
NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMaxKey = @"DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMaxKey";
NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMinKey = @"DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMinKey";
NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMaxKey = @"DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMaxKey";
NSString *const DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMinKey = @"DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMinKey";

@implementation DeviceController (libARCommands)
const char *DeviceController_TAG = " DeviceController";

#pragma mark static C callback
static void common_settingsstate_allsettingschanged_callback(void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionary];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateAllSettingsChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateAllSettingsChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateAllSettingsChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_resetchanged_callback(void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionary];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateResetChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateResetChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateResetChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_productnamechanged_callback(char * name, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:name encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerSettingsStateProductNameChangedNotificationNameKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateProductNameChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateProductNameChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateProductNameChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_productversionchanged_callback(char * software, char * hardware, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:software encoding:NSUTF8StringEncoding], [NSString stringWithCString:hardware encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerSettingsStateProductVersionChangedNotificationSoftwareKey, DeviceControllerSettingsStateProductVersionChangedNotificationHardwareKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateProductVersionChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateProductVersionChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateProductVersionChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_productserialhighchanged_callback(char * high, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:high encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerSettingsStateProductSerialHighChangedNotificationHighKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateProductSerialHighChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateProductSerialHighChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateProductSerialHighChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_productseriallowchanged_callback(char * low, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:low encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerSettingsStateProductSerialLowChangedNotificationLowKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateProductSerialLowChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateProductSerialLowChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateProductSerialLowChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_countrychanged_callback(char * code, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:code encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerSettingsStateCountryChangedNotificationCodeKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateCountryChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateCountryChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateCountryChangedNotification object:self userInfo:dict];
}

static void common_settingsstate_autocountrychanged_callback(uint8_t automatic, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:automatic]] forKeys:@[DeviceControllerSettingsStateAutoCountryChangedNotificationAutomaticKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerSettingsStateAutoCountryChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerSettingsStateAutoCountryChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerSettingsStateAutoCountryChangedNotification object:self userInfo:dict];
}

static void common_commonstate_allstateschanged_callback(void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionary];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateAllStatesChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateAllStatesChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateAllStatesChangedNotification object:self userInfo:dict];
}

static void common_commonstate_batterystatechanged_callback(uint8_t percent, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:percent]] forKeys:@[DeviceControllerCommonStateBatteryStateChangedNotificationPercentKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateBatteryStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateBatteryStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateBatteryStateChangedNotification object:self userInfo:dict];
}

static void common_commonstate_massstoragestatelistchanged_callback(uint8_t mass_storage_id, char * name, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:mass_storage_id], [NSString stringWithCString:name encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerCommonStateMassStorageStateListChangedNotificationMass_storage_idKey, DeviceControllerCommonStateMassStorageStateListChangedNotificationNameKey]];
    NSMutableDictionary *listDictionary = [self.privateNotificationsDictionary objectForKey:DeviceControllerCommonStateMassStorageStateListChangedNotification];
    if(listDictionary == nil)
    {
        listDictionary = [NSMutableDictionary dictionary];
    }
    [listDictionary setObject:dict forKey:[NSNumber numberWithUnsignedChar:mass_storage_id]];
    dict = listDictionary;
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateMassStorageStateListChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateMassStorageStateListChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateMassStorageStateListChangedNotification object:self userInfo:dict];
}

static void common_commonstate_massstorageinfostatelistchanged_callback(uint8_t mass_storage_id, uint32_t size, uint32_t used_size, uint8_t plugged, uint8_t full, uint8_t internal, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:mass_storage_id], [NSNumber numberWithUnsignedInt:size], [NSNumber numberWithUnsignedInt:used_size], [NSNumber numberWithUnsignedChar:plugged], [NSNumber numberWithUnsignedChar:full], [NSNumber numberWithUnsignedChar:internal]] forKeys:@[DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationMass_storage_idKey, DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationSizeKey, DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationUsed_sizeKey, DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationPluggedKey, DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationFullKey, DeviceControllerCommonStateMassStorageInfoStateListChangedNotificationInternalKey]];
    NSMutableDictionary *listDictionary = [self.privateNotificationsDictionary objectForKey:DeviceControllerCommonStateMassStorageInfoStateListChangedNotification];
    if(listDictionary == nil)
    {
        listDictionary = [NSMutableDictionary dictionary];
    }
    [listDictionary setObject:dict forKey:[NSNumber numberWithUnsignedChar:mass_storage_id]];
    dict = listDictionary;
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateMassStorageInfoStateListChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateMassStorageInfoStateListChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateMassStorageInfoStateListChangedNotification object:self userInfo:dict];
}

static void common_commonstate_currentdatechanged_callback(char * date, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:date encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerCommonStateCurrentDateChangedNotificationDateKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateCurrentDateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateCurrentDateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateCurrentDateChangedNotification object:self userInfo:dict];
}

static void common_commonstate_currenttimechanged_callback(char * time, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSString stringWithCString:time encoding:NSUTF8StringEncoding]] forKeys:@[DeviceControllerCommonStateCurrentTimeChangedNotificationTimeKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateCurrentTimeChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateCurrentTimeChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateCurrentTimeChangedNotification object:self userInfo:dict];
}

static void common_commonstate_massstorageinforemaininglistchanged_callback(uint32_t free_space, uint16_t rec_time, uint32_t photo_remaining, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedInt:free_space], [NSNumber numberWithUnsignedShort:rec_time], [NSNumber numberWithUnsignedInt:photo_remaining]] forKeys:@[DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationFree_spaceKey, DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationRec_timeKey, DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotificationPhoto_remainingKey]];
    NSMutableDictionary *listDictionary = [self.privateNotificationsDictionary objectForKey:DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification];
    if(listDictionary == nil)
    {
        listDictionary = [NSMutableDictionary dictionary];
    }
    [listDictionary setObject:dict forKey:[NSNumber numberWithUnsignedInt:free_space]];
    dict = listDictionary;
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateMassStorageInfoRemainingListChangedNotification object:self userInfo:dict];
}

static void common_commonstate_wifisignalchanged_callback(int16_t rssi, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithShort:rssi]] forKeys:@[DeviceControllerCommonStateWifiSignalChangedNotificationRssiKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCommonStateWifiSignalChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCommonStateWifiSignalChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCommonStateWifiSignalChangedNotification object:self userInfo:dict];
}

static void common_overheatstate_overheatchanged_callback(void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionary];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerOverHeatStateOverHeatChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerOverHeatStateOverHeatChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerOverHeatStateOverHeatChangedNotification object:self userInfo:dict];
}

static void common_overheatstate_overheatregulationchanged_callback(uint8_t regulationType, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:regulationType]] forKeys:@[DeviceControllerOverHeatStateOverHeatRegulationChangedNotificationRegulationTypeKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerOverHeatStateOverHeatRegulationChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerOverHeatStateOverHeatRegulationChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerOverHeatStateOverHeatRegulationChangedNotification object:self userInfo:dict];
}

static void common_controllerstate_ispilotingchanged_callback(uint8_t piloting, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:piloting]] forKeys:@[DeviceControllerControllerStateIsPilotingChangedNotificationPilotingKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerControllerStateIsPilotingChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerControllerStateIsPilotingChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerControllerStateIsPilotingChangedNotification object:self userInfo:dict];
}

static void common_wifisettingsstate_outdoorsettingschanged_callback(uint8_t outdoor, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:outdoor]] forKeys:@[DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotificationOutdoorKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerWifiSettingsStateOutdoorSettingsChangedNotification object:self userInfo:dict];
}

static void common_mavlinkstate_mavlinkfileplayingstatechanged_callback(eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE state, char * filepath, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE type, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithInt:state], [NSString stringWithCString:filepath encoding:NSUTF8StringEncoding], [NSNumber numberWithInt:type]] forKeys:@[DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationStateKey, DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationFilepathKey, DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotificationTypeKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerMavlinkStateMavlinkFilePlayingStateChangedNotification object:self userInfo:dict];
}

static void common_mavlinkstate_mavlinkplayerrorstatechanged_callback(eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR error, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithInt:error]] forKeys:@[DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotificationErrorKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerMavlinkStateMavlinkPlayErrorStateChangedNotification object:self userInfo:dict];
}

static void common_calibrationstate_magnetocalibrationstatechanged_callback(uint8_t xAxisCalibration, uint8_t yAxisCalibration, uint8_t zAxisCalibration, uint8_t calibrationFailed, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:xAxisCalibration], [NSNumber numberWithUnsignedChar:yAxisCalibration], [NSNumber numberWithUnsignedChar:zAxisCalibration], [NSNumber numberWithUnsignedChar:calibrationFailed]] forKeys:@[DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationXAxisCalibrationKey, DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationYAxisCalibrationKey, DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationZAxisCalibrationKey, DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotificationCalibrationFailedKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCalibrationStateMagnetoCalibrationStateChangedNotification object:self userInfo:dict];
}

static void common_calibrationstate_magnetocalibrationrequiredstate_callback(uint8_t required, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:required]] forKeys:@[DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotificationRequiredKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCalibrationStateMagnetoCalibrationRequiredStateNotification object:self userInfo:dict];
}

static void common_calibrationstate_magnetocalibrationaxistocalibratechanged_callback(eARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS axis, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithInt:axis]] forKeys:@[DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotificationAxisKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCalibrationStateMagnetoCalibrationAxisToCalibrateChangedNotification object:self userInfo:dict];
}

static void common_calibrationstate_magnetocalibrationstartedchanged_callback(uint8_t started, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithUnsignedChar:started]] forKeys:@[DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotificationStartedKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCalibrationStateMagnetoCalibrationStartedChangedNotification object:self userInfo:dict];
}

static void common_camerasettingsstate_camerasettingschanged_callback(float fov, float panMax, float panMin, float tiltMax, float tiltMin, void *custom)
{
    DeviceController *self = (__bridge DeviceController*)custom;
    NSDictionary* dict = [NSDictionary dictionaryWithObjects:@[[NSNumber numberWithFloat:fov], [NSNumber numberWithFloat:panMax], [NSNumber numberWithFloat:panMin], [NSNumber numberWithFloat:tiltMax], [NSNumber numberWithFloat:tiltMin]] forKeys:@[DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationFovKey, DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMaxKey, DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationPanMinKey, DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMaxKey, DeviceControllerCameraSettingsStateCameraSettingsChangedNotificationTiltMinKey]];
    [self.privateNotificationsDictionary setObject:dict forKey:DeviceControllerCameraSettingsStateCameraSettingsChangedNotification];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerNotificationsDictionaryChanged object:self userInfo:[NSDictionary dictionaryWithObject:dict forKey:DeviceControllerCameraSettingsStateCameraSettingsChangedNotification]];
    [[NSNotificationCenter defaultCenter] postNotificationName:DeviceControllerCameraSettingsStateCameraSettingsChangedNotification object:self userInfo:dict];
}


- (void)registerCommonARCommandsCallbacks
{
    // Command class Event
    // Command class SettingsState
    ARCOMMANDS_Decoder_SetCommonSettingsStateAllSettingsChangedCallback(common_settingsstate_allsettingschanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateResetChangedCallback(common_settingsstate_resetchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductNameChangedCallback(common_settingsstate_productnamechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductVersionChangedCallback(common_settingsstate_productversionchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialHighChangedCallback(common_settingsstate_productserialhighchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialLowChangedCallback(common_settingsstate_productseriallowchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateCountryChangedCallback(common_settingsstate_countrychanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonSettingsStateAutoCountryChangedCallback(common_settingsstate_autocountrychanged_callback, (__bridge void *)(self));
    // Command class CommonState
    ARCOMMANDS_Decoder_SetCommonCommonStateAllStatesChangedCallback(common_commonstate_allstateschanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateBatteryStateChangedCallback(common_commonstate_batterystatechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageStateListChangedCallback(common_commonstate_massstoragestatelistchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoStateListChangedCallback(common_commonstate_massstorageinfostatelistchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateCurrentDateChangedCallback(common_commonstate_currentdatechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateCurrentTimeChangedCallback(common_commonstate_currenttimechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoRemainingListChangedCallback(common_commonstate_massstorageinforemaininglistchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCommonStateWifiSignalChangedCallback(common_commonstate_wifisignalchanged_callback, (__bridge void *)(self));
    // Command class OverHeatState
    ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatChangedCallback(common_overheatstate_overheatchanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatRegulationChangedCallback(common_overheatstate_overheatregulationchanged_callback, (__bridge void *)(self));
    // Command class ControllerState
    ARCOMMANDS_Decoder_SetCommonControllerIsPilotingCallback(common_controllerstate_ispilotingchanged_callback, (__bridge void *)(self));
    // Command class WifiSettingsState
    ARCOMMANDS_Decoder_SetCommonWifiSettingsStateOutdoorSettingsChangedCallback(common_wifisettingsstate_outdoorsettingschanged_callback, (__bridge void *)(self));
    // Command class MavlinkState
    ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkFilePlayingStateChangedCallback(common_mavlinkstate_mavlinkfileplayingstatechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkPlayErrorStateChangedCallback(common_mavlinkstate_mavlinkplayerrorstatechanged_callback, (__bridge void *)(self));
    // Command class CalibrationState
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStateChangedCallback(common_calibrationstate_magnetocalibrationstatechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationRequiredStateCallback(common_calibrationstate_magnetocalibrationrequiredstate_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback(common_calibrationstate_magnetocalibrationaxistocalibratechanged_callback, (__bridge void *)(self));
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStartedChangedCallback(common_calibrationstate_magnetocalibrationstartedchanged_callback, (__bridge void *)(self));
    // Command class CameraSettingsState
    ARCOMMANDS_Decoder_SetCommonCameraSettingsStateCameraSettingsChangedCallback(common_camerasettingsstate_camerasettingschanged_callback, (__bridge void *)(self));
}

- (void)unregisterCommonARCommandsCallbacks
{
    // Command class Event
    // Command class SettingsState
    ARCOMMANDS_Decoder_SetCommonSettingsStateAllSettingsChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateResetChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductNameChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductVersionChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialHighChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialLowChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateCountryChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonSettingsStateAutoCountryChangedCallback(NULL, NULL);
    // Command class CommonState
    ARCOMMANDS_Decoder_SetCommonCommonStateAllStatesChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateBatteryStateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageStateListChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoStateListChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateCurrentDateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateCurrentTimeChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoRemainingListChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCommonStateWifiSignalChangedCallback(NULL, NULL);
    // Command class OverHeatState
    ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatRegulationChangedCallback(NULL, NULL);
    // Command class ControllerState
    ARCOMMANDS_Decoder_SetCommonControllerIsPilotingCallback(NULL, NULL);
    // Command class WifiSettingsState
    ARCOMMANDS_Decoder_SetCommonWifiSettingsStateOutdoorSettingsChangedCallback(NULL, NULL);
    // Command class MavlinkState
    ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkFilePlayingStateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkPlayErrorStateChangedCallback(NULL, NULL);
    // Command class CalibrationState
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationRequiredStateCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback(NULL, NULL);
    ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStartedChangedCallback(NULL, NULL);
    // Command class CameraSettingsState
    ARCOMMANDS_Decoder_SetCommonCameraSettingsStateCameraSettingsChangedCallback(NULL, NULL);
}

#pragma mark ARCommands sending function 
    // Command class Network
- (BOOL)DeviceController_SendNetworkDisconnect:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Disconnect command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonNetworkDisconnect(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Disconnect command.");
    }

    return sentStatus;
}
    // Command class Settings
- (BOOL)DeviceController_SendSettingsAllSettings:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send AllSettings command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonSettingsAllSettings(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
      sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send AllSettings command.");
    }
    return sentStatus;
}
- (BOOL)DeviceController_SendSettingsReset:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Reset command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonSettingsReset(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Reset command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendSettingsProductName:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withName:(char *)name
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send ProductName command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonSettingsProductName(cmdbuf, sizeof(cmdbuf), &actualSize, name);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send ProductName command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendSettingsCountry:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCode:(char *)code
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Country command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonSettingsCountry(cmdbuf, sizeof(cmdbuf), &actualSize, code);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Country command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendSettingsAutoCountry:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withAutomatic:(uint8_t)automatic
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send AutoCountry command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonSettingsAutoCountry(cmdbuf, sizeof(cmdbuf), &actualSize, automatic);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send AutoCountry command.");
    }

    return sentStatus;
}
    // Command class Common
- (BOOL)DeviceController_SendCommonAllStates:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send AllStates command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonCommonAllStates(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send AllStates command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendCommonCurrentDate:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withDate:(char *)date
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send CurrentDate command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonCommonCurrentDate(cmdbuf, sizeof(cmdbuf), &actualSize, date);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send CurrentDate command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendCommonCurrentTime:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withTime:(char *)time
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send CurrentTime command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonCommonCurrentTime(cmdbuf, sizeof(cmdbuf), &actualSize, time);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send CurrentTime command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendCommonReboot:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Reboot command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonCommonReboot(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Reboot command.");
    }

    return sentStatus;
}
    // Command class OverHeat
- (BOOL)DeviceController_SendOverHeatSwitchOff:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send SwitchOff command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonOverHeatSwitchOff(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send SwitchOff command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendOverHeatVentilate:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Ventilate command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonOverHeatVentilate(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Ventilate command.");
    }

    return sentStatus;
}
    // Command class WifiSettings
- (BOOL)DeviceController_SendWifiSettingsOutdoorSetting:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withOutdoor:(uint8_t)outdoor
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send OutdoorSetting command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonWifiSettingsOutdoorSetting(cmdbuf, sizeof(cmdbuf), &actualSize, outdoor);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send OutdoorSetting command.");
    }

    return sentStatus;
}
    // Command class Mavlink
- (BOOL)DeviceController_SendMavlinkStart:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withFilepath:(char *)filepath withType:(eARCOMMANDS_COMMON_MAVLINK_START_TYPE)type
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Start command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonMavlinkStart(cmdbuf, sizeof(cmdbuf), &actualSize, filepath, type);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Start command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendMavlinkPause:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Pause command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonMavlinkPause(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Pause command.");
    }

    return sentStatus;
}
- (BOOL)DeviceController_SendMavlinkStop:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send Stop command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonMavlinkStop(cmdbuf, sizeof(cmdbuf), &actualSize);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send Stop command.");
    }

    return sentStatus;
}
    // Command class Calibration
- (BOOL)DeviceController_SendCalibrationMagnetoCalibration:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCalibrate:(uint8_t)calibrate
{
    u_int8_t cmdbuf[128];
    int32_t actualSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError;
    BOOL sentStatus;

    // Send MagnetoCalibration command
    sentStatus = NO;
    cmdError = ARCOMMANDS_Generator_GenerateCommonCalibrationMagnetoCalibration(cmdbuf, sizeof(cmdbuf), &actualSize, calibrate);
    if (cmdError == ARCOMMANDS_GENERATOR_OK)
    {
        sentStatus = [self sendData:cmdbuf withSize:actualSize onBufferWithId:bufferId withSendPolicy:policy withCompletionBlock:completionBlock];
    }
    if (!sentStatus)
    {
        ARSAL_PRINT(ARSAL_PRINT_ERROR, DeviceController_TAG, "Failed to send MagnetoCalibration command.");
    }

    return sentStatus;
}
@end

// END GENERATED CODE
