/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**
 * @file libARCommands/ARCOMMANDS_Generator.h
 * @brief libARCommands generator header.
 * This file contains all declarations needed to generate commands
 * @note Autogenerated file
 **/
#ifndef _LIBARCOMMANDS_ARCOMMANDS_GENERATOR_H_
#define _LIBARCOMMANDS_ARCOMMANDS_GENERATOR_H_
#include <libARCommands/ARCOMMANDS_Types.h>
#include <inttypes.h>


/**
 * @brief Error codes for ARCOMMANDS_Generator_GenerateCommand functions
 */
typedef enum {
    ARCOMMANDS_GENERATOR_OK = 0, ///< No error occured
    ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS, ///< At least one of the arguments is invalid
    ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE, ///< The given output buffer was not large enough for the command
    ARCOMMANDS_GENERATOR_ERROR, ///< Any other error
} eARCOMMANDS_GENERATOR_ERROR;


// Feature generic


/**
 * @brief default
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateGenericDefault (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);


// Feature ARDrone3


/**
 * @brief Do a flat trim
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingFlatTrim (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Ask the drone to take off
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingTakeOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Ask the drone to move around.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _flag Boolean flag to activate roll/pitch movement
 * @param _roll Roll consign for the drone [-100;100]
 * @param _pitch Pitch consign for the drone [-100;100]
 * @param _yaw Yaw consign for the drone [-100;100]
 * @param _gaz Gaz consign for the drone [-100;100]
 * @param _timestampAndSeqNum Command timestamp in milliseconds (low 24 bits) + command sequence number [0;255] (high 8 bits).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingPCMD (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _flag, int8_t _roll, int8_t _pitch, int8_t _yaw, int8_t _gaz, uint32_t _timestampAndSeqNum);

/**
 * @brief Ask the drone to land
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingLanding (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Put drone in emergency user state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingEmergency (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Ask the drone to fly to home
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start the navigate home, 0 to stop it
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingNavigateHome (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start);

/**
 * @brief @deprecated
 * [NOT USED] Set Drone3 in automatic take off mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of automatic take off mode (1 for autotake off enabled)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingAutoTakeOffMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state);

/**
 * @brief [DRAFT] Move the drone to a relative position and rotate heading by a given angle
 * The frame is horizontal and relative to the current drone orientation:
 * - X is front
 * - Y is right
 * - Z is down
 * The movement settings of the device are those set for the autonomous flight.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _dX Wanted displacement along the front axis [m]
 * @param _dY Wanted displacement along the right axis [m]
 * @param _dZ Wanted displacement along the down axis [m]
 * @param _dPsi Wanted rotation of heading  [rad]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingMoveBy (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _dX, float _dY, float _dZ, float _dPsi);

/**
 * @brief Set drone in user take off state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of user take off mode
 * @param _state - 1 to enter in user take off.
 * @param _state - 0 to exit from user take off.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingUserTakeOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state);

/**
 * @brief Ask Fixed wings to circle
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _direction The circling direction
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingCircle (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION _direction);

/**
 * @brief Make a flip
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _direction Direction for the flip
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AnimationsFlip (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION _direction);

/**
 * @brief Ask the drone to move camera.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _tilt Tilt camera consign for the drone (in degree)
 * @param _tilt The value is saturated by the drone.
 * @param _tilt Saturation value is sent by thre drone through CameraSettingsChanged command.
 * @param _pan Pan camera consign for the drone (in degree)
 * @param _pan The value is saturated by the drone.
 * @param _pan Saturation value is sent by thre drone through CameraSettingsChanged command.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3CameraOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _tilt, int8_t _pan);

/**
 * @brief @deprecated
 * Take picture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mass_storage_id Mass storage id to take picture
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPicture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id);

/**
 * @brief @deprecated
 * Video record
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _record Command to record video
 * @param _mass_storage_id Mass storage id to record
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD _record, uint8_t _mass_storage_id);

/**
 * @brief Take picture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPictureV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Video record
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _record Command to record video
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideoV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD _record);

/**
 * @brief Launches wifi network scan
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band The band(s) : 2.4 Ghz, 5 Ghz, or both
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiScan (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND _band);

/**
 * @brief Controller inquire the list of authorized wifi channels.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiAuthChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set Max Altitude
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current altitude max in m
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set Max Tilt
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current tilt max in degree
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxTilt (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief @deprecated
 * Enable/Disable absolut control
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _on 1 to enable, 0 to disable
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsAbsolutControl (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _on);

/**
 * @brief Set the distance max of the drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value Current max distance in meter
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxDistance (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief Indication about how the product handle flying over the max distance limitation
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _shouldNotFlyOver 1 if the drone can't fly further than max distance, 0 if no limitation on the drone should be done
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsNoFlyOverMaxDistance (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _shouldNotFlyOver);

/**
 * @brief [NOT USED] Set the maximum horizontal speed used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum horizontal speed [m/s]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Set the maximum vertical speed used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum vertical speed [m/s]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Set the maximum horizontal acceleration used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum horizontal acceleration [m/s2]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Set the maximum vertical acceleration used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum vertical acceleration [m/s2]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Set the maximum yaw rotation speed used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum yaw rotation speed [rad/s]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief Enable / Disable Banked Turn mode.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value 1 to enable, 0 to disable
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsBankedTurn (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _value);

/**
 * @brief Set Min Altitude
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current altitude min in m
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMinAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set Fixed wings circling default direction
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The circling direction
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingDirection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE _value);

/**
 * @brief Set Fixed wings circling radius
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The circling radius in meter
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingRadius (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _value);

/**
 * @brief Set Fixed wings circling altitude
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The circling altitude in meter
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _value);

/**
 * @brief Set pitch mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The Pitch mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsPitchMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE _value);

/**
 * @brief Set fixed wings Landing Mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The Landing mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsLandingMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE _value);

/**
 * @brief Set Max Vertical speed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max vertical speed in m/s
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set Max Yaw Rotation speed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max yaw rotation speed in degree/s
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Presence of hull protection
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _present 1 if present, 0 if not present
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsHullProtection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present);

/**
 * @brief @deprecated
 * Outdoor property
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _outdoor 1 if outdoor flight, 0 if indoor flight
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsOutdoor (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor);

/**
 * @brief Set Max Pitch/Rool Rotation speed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max pitch/roll rotation speed in degree/s
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxPitchRollRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Auto-select channel of choosen band
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi selection (auto, manual)
 * @param _band The allowed band(s) : 2.4 Ghz, 5 Ghz, or all
 * @param _channel The channel (not used in auto mode)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE _type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND _band, uint8_t _channel);

/**
 * @brief Sent by the controller to set the wifi security
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi security (open, wpa2)
 * @param _key The key to secure the network (empty if type is open)
 * @param _keyType Type of the key
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSecurity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE _type, const char * _key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE _keyType);

/**
 * @brief The format of the photo
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of photo format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsPictureFormatSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE _type);

/**
 * @brief AutoWhiteBalance mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type auto white balance
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsAutoWhiteBalanceSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE _type);

/**
 * @brief The exposition of the image
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value Exposition value (bounds given by ExpositionChanged arg min and max, by default [-3:3])
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsExpositionSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief The saturation of the image
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value Saturation value (bounds given by SaturationChanged arg min and max, by default [-100:100])
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsSaturationSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief Picture taken periodically
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 1 if timelapse is enabled, 0 otherwise
 * @param _interval interval in seconds for taking pictures
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsTimelapseSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, float _interval);

/**
 * @brief Video autorecord
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 1 if video autorecord is enabled, 0 otherwise
 * @param _mass_storage_id Mass storage id to take video
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoAutorecordSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, uint8_t _mass_storage_id);

/**
 * @brief Set Video stabilization mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mode Video stabilization mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoStabilizationMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE _mode);

/**
 * @brief Enable/disable video streaming.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enable 1 to enable, 0 to disable.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingVideoEnable (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable);

/**
 * @brief @deprecated
 * Set home location
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Home latitude in decimal degrees
 * @param _longitude Home longitude in decimal degrees
 * @param _altitude Home altitude in meters
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSetHome (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude);

/**
 * @brief Reset home location and let the drone make its own home
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsResetHome (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief send controller GPS location
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude GPS latitude in decimal degrees
 * @param _longitude GPS longitude in decimal degrees
 * @param _altitude GPS altitude in meters
 * @param _horizontalAccuracy Horizontal Accuracy in meter ; equal -1 if no horizontal Accuracy
 * @param _verticalAccuracy Vertical Accuracy in meter ; equal -1 if no vertical Accuracy
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSendControllerGPS (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude, double _horizontalAccuracy, double _verticalAccuracy);

/**
 * @brief Set user preference for the type of the home position. Note that this is only a preference
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of the home position
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsHomeType (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE _type);

/**
 * @brief Set the delay after which the drone will automatically try to return home
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _delay Delay in second
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsReturnHomeDelay (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _delay);

/**
 * @brief Electric frequency of the country determined by the position of the controller
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _frequency Type of the electric frequency
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringElectricFrequency (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY _frequency);

/**
 * @brief Set the anti flickering mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mode Mode of the anti flickering functionnality
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringSetMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE _mode);

/**
 * @brief @deprecated
 * State of picture recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state 1 if picture has been taken, 0 otherwise
 * @param _mass_storage_id Mass storage id where the picture was recorded
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStatePictureStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state, uint8_t _mass_storage_id);

/**
 * @brief @deprecated
 * State of video recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of video
 * @param _mass_storage_id Mass storage id where the video was recorded
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStateVideoStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id);

/**
 * @brief State of device picture recording changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of device picture recording
 * @param _error Error to explain the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStatePictureStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error);

/**
 * @brief State of device video recording changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of device video recording
 * @param _error Error to explain the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStateVideoStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error);

/**
 * @brief Event of picture recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _event Last event of picture recording
 * @param _error Error to explain the event
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordEventPictureEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error);

/**
 * @brief Event of video recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _event Event of video recording
 * @param _error Error to explain the event
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordEventVideoEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error);

/**
 * @brief Drone acknowledges that flat trim was correctly processed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateFlatTrimChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Drone flying state changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state Drone flying state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateFlyingStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state);

/**
 * @brief Drone alert state changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state Drone alert state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAlertStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state);

/**
 * @brief Navigating home state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of navigate home
 * @param _reason Reason of the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateNavigateHomeStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE _state, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON _reason);

/**
 * @brief Drone position changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Latitude position in decimal degrees (500.0 if not available)
 * @param _longitude Longitude position in decimal degrees (500.0 if not available)
 * @param _altitude Altitude in meters (from GPS)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStatePositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude);

/**
 * @brief Drone speed changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speedX Speed on the x axis (when drone moves forward, speed is > 0) (in m/s)
 * @param _speedY Speed on the y axis (when drone moves to right, speed is > 0) (in m/s)
 * @param _speedZ Speed on the z axis (when drone moves down, speed is > 0) (in m/s)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _speedX, float _speedY, float _speedZ);

/**
 * @brief Drone attitude changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _roll roll value (in radian)
 * @param _pitch Pitch value (in radian)
 * @param _yaw Yaw value (in radian)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAttitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _roll, float _pitch, float _yaw);

/**
 * @brief @deprecated
 * Status of the drone3 automatic take off mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of automatic take off mode (1 if enabled)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAutoTakeOffModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state);

/**
 * @brief Drone altitude changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _altitude Altitude in meters
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _altitude);

/**
 * @brief [NOT USED] End of relative displacement of the drone
 * The frame is horizontal and relative to the current drone orientation:
 * - X is front
 * - Y is right
 * - Z is down
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _dX Distance traveled along the front axis [m]
 * @param _dY Distance traveled along the right axis [m]
 * @param _dZ Distance traveled along the down axis [m]
 * @param _dPsi Applied angle on heading  [rad]
 * @param _error Error to explain the event
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingEventMoveByEnd (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _dX, float _dY, float _dZ, float _dPsi, eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR _error);

/**
 * @brief One scanning result found
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid SSID of the AP
 * @param _rssi RSSI of the AP in dbm (negative value)
 * @param _band The band : 2.4 GHz or 5 GHz
 * @param _channel Channel of the AP
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateWifiScanListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, int16_t _rssi, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel);

/**
 * @brief State sent when all scanning result sent
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateAllWifiScanChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Notify of an Authorized Channel.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band The band of this channel : 2.4 GHz or 5 GHz
 * @param _channel The authorized channel.
 * @param _in_or_out Bit 0 is 1 if channel is authorized outside (0 otherwise) ; Bit 1 is 1 if channel is authorized inside (0 otherwise)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateWifiAuthChannelListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out);

/**
 * @brief Notify the end of the list of Authorized wifi Channel.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateAllWifiAuthChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Max Altitude sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current altitude max
 * @param _min Range min of altitude
 * @param _max Range max of altitude
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Max tilt sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max tilt
 * @param _min Range min of tilt
 * @param _max Range max of tilt
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxTiltChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief @deprecated
 * Absolut control boolean sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _on 1 if enabled, 0 if disabled
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAbsolutControlChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _on);

/**
 * @brief Max distance sent by the drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max distance in meter
 * @param _min Minimal possible max distance
 * @param _max Maximal possible max distance
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxDistanceChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Indication about how the product handle flying over the max distance limitation
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _shouldNotFlyOver 1 if the drone won't fly further than max distance, 0 if no limitation on the drone will be done
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _shouldNotFlyOver);

/**
 * @brief [NOT USED] Maximum horizontal speed used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum horizontal speed [m/s]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Maximum vertical speed used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum vertical speed [m/s]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Maximum horizontal acceleration used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum horizontal acceleration [m/s2]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Maximum vertical acceleration used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum vertical acceleration [m/s2]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief [NOT USED] Maximum yaw rotation speed used by the autonomous flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value maximum yaw rotation speed [rad/s]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value);

/**
 * @brief Banked Turn state.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state 1 if enabled, 0 if disabled
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateBankedTurnChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state);

/**
 * @brief Min Altitude sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current altitude min
 * @param _min Range min of altitude min
 * @param _max Range max of altitude min
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMinAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Fixed wings circling default direction changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The circling direction
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingDirectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE _value);

/**
 * @brief Fixed wings circling radius changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current The current circling radius in meter
 * @param _min Range min of circling radius in meter
 * @param _max Range max of circling radius in meter
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingRadiusChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _current, uint16_t _min, uint16_t _max);

/**
 * @brief Fixed wings circling altitude changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current The current circling altitude in meter
 * @param _min Range min of circling altitude in meter
 * @param _max Range max of circling altitude in meter
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _current, uint16_t _min, uint16_t _max);

/**
 * @brief Pitch mode changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The Pitch mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStatePitchModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE _value);

/**
 * @brief Fixed wings Landing Mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value The Landing mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateLandingModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE _value);

/**
 * @brief Max vertical speed sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max vertical speed in m/s
 * @param _min Range min of vertical speed
 * @param _max Range max of vertical speed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxVerticalSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Max yaw rotation speed sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max yaw rotation speed in degree/s
 * @param _min Range min of yaw rotation speed
 * @param _max Range max of yaw rotation speed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxRotationSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Presence of hull protection sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _present 1 if present, 0 if not present
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateHullProtectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present);

/**
 * @brief @deprecated
 * Outdoor property sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _outdoor 1 if outdoor flight, 0 if indoor flight
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateOutdoorChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor);

/**
 * @brief Max pitch/roll rotation speed sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max pitch/roll rotation speed in degree/s
 * @param _min Range min of pitch/roll rotation speed
 * @param _max Range max of pitch/roll rotation speed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Wifi selection from product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi selection settings
 * @param _band The actual  wifi band state
 * @param _channel The channel (depends of the band)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSelectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel);

/**
 * @brief @deprecated
 * Sent by the drone when its wifi security changes
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi security (open, wpa2)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSecurityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE _type);

/**
 * @brief Sent by the drone when its wifi security changes
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi security (open, wpa2)
 * @param _key The key used to secure the network (empty if type is open)
 * @param _keyType Type of the key
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSecurity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE _type, const char * _key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE _keyType);

/**
 * @brief @deprecated
 * Product Motor version (the first argument is the unique identifier for the list)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _motor_number Product Motor number
 * @param _type Product Motor type
 * @param _software Product Motors software version
 * @param _hardware Product Motors hardware version
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateProductMotorVersionListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _motor_number, const char * _type, const char * _software, const char * _hardware);

/**
 * @brief Product GPS versions
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _software Product GPS software version
 * @param _hardware Product GPS hardware version
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateProductGPSVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware);

/**
 * @brief Motor status changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _motorIds Bit field for concerned motor. If bit 0 = 1, motor 1 is affected by this error. Same with bit 1, 2 and 3.
 * @param _motorError Enumeration of the motor error
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorErrorStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _motorIds, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR _motorError);

/**
 * @brief @deprecated
 * Motor software version status
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _version name of the version : dot separated fields (major version - minor version - firmware type - nb motors handled). Firmware types : Release, Debug, Alpha, Test-bench
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorSoftwareVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version);

/**
 * @brief Motor flights status
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _nbFlights total number of flights
 * @param _lastFlightDuration Duration of the last flight (in seconds)
 * @param _totalFlightDuration Duration of all flights (in seconds)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorFlightsStatusChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _nbFlights, uint16_t _lastFlightDuration, uint32_t _totalFlightDuration);

/**
 * @brief Motor status about last error
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _motorError Enumeration of the motor error
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorErrorLastErrorChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR _motorError);

/**
 * @brief @deprecated
 * Product P7ID
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _serialID Product P7ID
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateP7ID (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _serialID);

/**
 * @brief The format of the photo
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of photo format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStatePictureFormatChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE _type);

/**
 * @brief AutoWhiteBalance mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type auto white balance
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateAutoWhiteBalanceChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE _type);

/**
 * @brief The exposition of the image
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value Exposition value
 * @param _min Min exposition value
 * @param _max Max exposition value
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateExpositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value, float _min, float _max);

/**
 * @brief The saturation of the image
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _value Saturation value
 * @param _min Min saturation value
 * @param _max Max saturation value
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateSaturationChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value, float _min, float _max);

/**
 * @brief Picture taken periodically
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 1 if timelapse is enabled, 0 otherwise
 * @param _interval interval in seconds for taking pictures
 * @param _minInterval Minimal interval for taking pictures
 * @param _maxInterval Maximal interval for taking pictures
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateTimelapseChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, float _interval, float _minInterval, float _maxInterval);

/**
 * @brief Video autorecord
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 1 if video autorecord is enabled, 0 otherwise
 * @param _mass_storage_id Mass storage id for the taken video
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateVideoAutorecordChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, uint8_t _mass_storage_id);

/**
 * @brief Video stabilization mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mode Video stabilization mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateVideoStabilizationModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE _mode);

/**
 * @brief Return video streaming status.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled Current video streaming status.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingStateVideoEnableChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled);

/**
 * @brief Return home status
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Home latitude in decimal degrees
 * @param _longitude Home longitude in decimal degrees
 * @param _altitude Home altitude in meters
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateHomeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude);

/**
 * @brief Reset home status
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Home latitude in decimal degrees
 * @param _longitude Home longitude in decimal degrees
 * @param _altitude Home altitude in meters
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateResetHomeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude);

/**
 * @brief GPS fix state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _fixed 1 if gps on drone is fixed, 0 otherwise
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateGPSFixStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _fixed);

/**
 * @brief GPS update state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state The state of the gps update
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateGPSUpdateStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE _state);

/**
 * @brief State of the type of the home position. This type is the user preference. The prefered home type may not be available, see HomeTypeStatesChanged to get the drone home type.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of the home position
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateHomeTypeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE _type);

/**
 * @brief State of the delay after which the drone will automatically try to return home
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _delay Delay in second
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateReturnHomeDelayChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _delay);

/**
 * @brief Camera orientation
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _tilt Tilt camera consign for the drone [-100;100]
 * @param _pan Pan camera consign for the drone [-100;100]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3CameraStateOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _tilt, int8_t _pan);

/**
 * @brief Orientation of the camera center.
 * This is the value to send when we want to center the camera.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _tilt Tilt value (in degree)
 * @param _pan Pan value (in degree)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3CameraStateDefaultCameraOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _tilt, int8_t _pan);

/**
 * @brief Electric frequency of the country determined by the position of the controller
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _frequency Type of the electric frequency
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringStateElectricFrequencyChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY _frequency);

/**
 * @brief Anti flickering mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mode Mode of the anti flickering functionnality
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringStateModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE _mode);

/**
 * @brief The number of satellite used to compute the gps position
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _numberOfSatellite The number of satellite
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSStateNumberOfSatelliteChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _numberOfSatellite);

/**
 * @brief Availability of the return home types in a map : for each type other args will be sent by the drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of the return home
 * @param _available 1 if this type is available, 0 otherwise
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSStateHomeTypeAvailabilityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE _type, uint8_t _available);

/**
 * @brief The return home type chosen
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of the return home chosen
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSStateHomeTypeChosenChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE _type);

/**
 * @brief Features enabled
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _features Bitfield representing enabled features.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PROStateFeatures (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint64_t _features);


// Feature JumpingSumo


/**
 * @brief Ask the JS speed and turn ratio.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _flag Boolean for "touch screen".
 * @param _speed Speed value [-100:100].
 * @param _turn Turn value. [-100:100]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPCMD (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _flag, int8_t _speed, int8_t _turn);

/**
 * @brief Request a posture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Type of Posture
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPosture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE _type);

/**
 * @brief Add the specified offset to the current cap.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _offset Offset value in radians.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingAddCapOffset (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _offset);

/**
 * @brief Stop jump, emergency jump stop, stop jump motor and stay there.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpStop (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Cancel jump and come back to previous state (if possible).
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpCancel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Request jump loading
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpLoad (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Request a jump
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Type of jump
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJump (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE _type);

/**
 * @brief Play a parameterless animation.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _id Animation ID.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsSimpleAnimation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID _id);

/**
 * @brief @deprecated
 * Take picture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mass_storage_id Mass storage id to take picture
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPicture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id);

/**
 * @brief @deprecated
 * Video record
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _record Command to record video
 * @param _mass_storage_id Mass storage id to record
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD _record, uint8_t _mass_storage_id);

/**
 * @brief Take picture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPictureV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Video record
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _record Command to record video
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideoV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD _record);

/**
 * @brief Auto-select channel of choosen band
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi selection (auto, manual)
 * @param _band The allowed band(s) : 2.4 Ghz, 5 Ghz, or all
 * @param _channel The channel (not used in auto mode)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsWifiSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE _type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND _band, uint8_t _channel);

/**
 * @brief Launches wifi network scan
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band The band(s) : 2.4 Ghz, 5 Ghz, or both
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiScan (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND _band);

/**
 * @brief Controller inquire the list of authorized wifi channels.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiAuthChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Master volume control.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _volume Master audio volume [0:100].
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsMasterVolume (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _volume);

/**
 * @brief Audio Theme.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _theme The audio theme to set.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsTheme (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME _theme);

/**
 * @brief Command to ask device all metadata scripts.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanAllScriptsMetadata (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Notify device that a new file has been uploaded.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _uuid UUID of uploaded file.
 * @param _md5Hash MD5 hash code computed over file.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptUploaded (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid, const char * _md5Hash);

/**
 * @brief Ask the device to delete a script.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _uuid UUID of the file to delete.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptDelete (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid);

/**
 * @brief Ask the device to play a script.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _uuid UUID of the file to play.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanPlayScript (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid);

/**
 * @brief @deprecated
 * Outdoor property
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _outdoor 1 if outdoor, 0 if indoor
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsOutdoor (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor);

/**
 * @brief Enable/disable video streaming.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enable 1 to enable, 0 to disable.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingVideoEnable (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable);

/**
 * @brief Set video automatic recording state.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 0: Disabled 1: Enabled.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsAutorecord (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled);

/**
 * @brief State of posture changed.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of posture
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStatePostureChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE _state);

/**
 * @brief JS alert state changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state JS alert state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStateAlertStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state);

/**
 * @brief Notification sent when JS speed changes.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speed Speed command applied to motors in range [-100;100].
 * @param _realSpeed Actual real-world speed in cm/s. Value -32768 returned if not available.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStateSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _speed, int16_t _realSpeed);

/**
 * @brief State of jump load changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of jump load
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpLoadChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE _state);

/**
 * @brief State of jump type changed.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of jump type.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpTypeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE _state);

/**
 * @brief State about the jump motor problem
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _error Enum describing the problem of the motor
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpMotorProblemChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR _error);

/**
 * @brief @deprecated
 * Product GPS versions
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _software Product GPS software version
 * @param _hardware Product GPS hardware version
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoSettingsStateProductGPSVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware);

/**
 * @brief @deprecated
 * State of picture recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state 1 if picture has been taken, 0 otherwise
 * @param _mass_storage_id Mass storage id where the picture was recorded
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStatePictureStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state, uint8_t _mass_storage_id);

/**
 * @brief @deprecated
 * State of video recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of video
 * @param _mass_storage_id Mass storage id where the video was recorded
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStateVideoStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id);

/**
 * @brief State of device picture recording changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of device picture recording
 * @param _error Error to explain the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStatePictureStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error);

/**
 * @brief State of device video recording changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of device video recording
 * @param _error Error to explain the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStateVideoStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error);

/**
 * @brief Event of picture recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _event Last event of picture recording
 * @param _error Error to explain the event
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordEventPictureEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error);

/**
 * @brief Event of video recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _event Event of video recording
 * @param _error Error to explain the event
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordEventVideoEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error);

/**
 * @brief Wifi selection from product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi selection settings
 * @param _band The actual  wifi band state
 * @param _channel The channel (depends of the band)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsStateWifiSelectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel);

/**
 * @brief One scanning result found
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid SSID of the AP
 * @param _rssi RSSI of the AP in dbm (negative value)
 * @param _band The band : 2.4 GHz or 5 GHz
 * @param _channel Channel of the AP
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateWifiScanListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, int16_t _rssi, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel);

/**
 * @brief State sent when all scanning result sent
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateAllWifiScanChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Notify of an Authorized Channel.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band The band of this channel : 2.4 GHz or 5 GHz
 * @param _channel The authorized channel.
 * @param _in_or_out Bit 0 is 1 if channel is authorized outside (0 otherwise) ; Bit 1 is 1 if channel is authorized inside (0 otherwise)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateWifiAuthChannelListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out);

/**
 * @brief Notify the end of the list of Authorized wifi Channel.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateAllWifiAuthChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Notification sent by the firmware to give an indication of the WiFi link quality.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _quality The WiFi link quality in range 0-6, the higher the value, the higher the link quality.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateLinkQualityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _quality);

/**
 * @brief Master volume control.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _volume Master audio volume [0:100].
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsStateMasterVolumeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _volume);

/**
 * @brief Command to notify controller of new Audio Theme.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _theme The audio theme to set.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsStateThemeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME _theme);

/**
 * @brief Update the controller with metadata.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _uuid Script uuid for which metadata changed.
 * @param _version Version number for this script.
 * @param _product Product targeted by script.
 * @param _name Display name of the script.
 * @param _lastModified Timestamp relative to the UNIX epoch of the last time the file was modified.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptMetadataListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid, uint8_t _version, const char * _product, const char * _name, uint64_t _lastModified);

/**
 * @brief Notify controller that all script metadatas are updated.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateAllScriptsMetadataChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Device response to ScriptUploaded command.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _resultCode Error code.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptUploadChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE _resultCode);

/**
 * @brief Device response to ScriptDelete command.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _resultCode Error code.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptDeleteChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE _resultCode);

/**
 * @brief Device response to PlayScript command.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _resultCode Error code.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStatePlayScriptChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE _resultCode);

/**
 * @brief @deprecated
 * Outdoor property sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _outdoor 1 if outdoor, 0 if indoor
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsStateOutdoorChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor);

/**
 * @brief Return video streaming status.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled Current video streaming status.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingStateVideoEnableChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled);

/**
 * @brief Get video automatic recording status.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 0: Disabled 1: Enabled.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsStateAutorecordChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled);


// Feature MiniDrone


/**
 * @brief Do a flat trim
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingFlatTrim (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Ask the drone to take off
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingTakeOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Ask the drone to move around.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _flag Boolean flag to activate roll/pitch movement
 * @param _roll Roll consign for the MiniDrone [-100;100]
 * @param _pitch Pitch consign for the MiniDrone [-100;100]
 * @param _yaw Yaw consign for the MiniDrone [-100;100]
 * @param _gaz Gaz consign for the MiniDrone [-100;100]
 * @param _timestamp Timestamp in miliseconds. Not an absolute time. (Typically 0 = time of connexion).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingPCMD (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _flag, int8_t _roll, int8_t _pitch, int8_t _yaw, int8_t _gaz, uint32_t _timestamp);

/**
 * @brief Ask the MiniDrone to land
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingLanding (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Put drone in emergency state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingEmergency (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set MiniDrone automatic take off mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of automatic take off mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingAutoTakeOffMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state);

/**
 * @brief Make a flip
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _direction Direction for the flip
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneAnimationsFlip (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION _direction);

/**
 * @brief Change the product cap
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _offset Change the cap with offset angle [-180;180]
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneAnimationsCap (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int16_t _offset);

/**
 * @brief @deprecated
 * Take picture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mass_storage_id Mass storage id to take picture
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPicture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id);

/**
 * @brief Take picture
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPictureV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set Max Altitude
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current altitude max in m
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set Max Tilt
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current tilt max in degree
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxTilt (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set Max Vertical speed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max vertical speed in m/s
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set Max Rotation speed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max rotation speed in degree/s
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Presence of wheels
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _present 1 if present, 0 if not present
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsWheels (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present);

/**
 * @brief Set Max Horizontal speed (only used in case where PilotingSettings_MaxTilt is not used like in hydrofoil mode)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max Horizontal speed in m/s
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxHorizontalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current);

/**
 * @brief Set MiniDrone cut out mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enable Enable cut out mode (1 if is activate, 0 otherwise)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsCutOutMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable);

/**
 * @brief Set the controller latitude for a run.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Controller latitude in decimal degrees
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLatitudeForRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude);

/**
 * @brief Set the controller longitude for a run.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _longitude Controller longitude in decimal degrees
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLongitudeForRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _longitude);

/**
 * @brief Set the controller type.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Controller type like iOS or Android
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerType (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _type);

/**
 * @brief Set the controller name.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _name Controller name like com.parrot.freeflight3
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerName (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name);

/**
 * @brief MiniDrone send flat trim was correctly processed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateFlatTrimChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Drone flying state changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state Drone flying state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateFlyingStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state);

/**
 * @brief Drone alert state changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state Drone alert state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateAlertStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state);

/**
 * @brief Set MiniDrone automatic take off mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of automatic take off mode
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateAutoTakeOffModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state);

/**
 * @brief @deprecated
 * State of picture recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state 1 if picture has been taken, 0 otherwise
 * @param _mass_storage_id Mass storage id to record
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordStatePictureStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state, uint8_t _mass_storage_id);

/**
 * @brief State of device picture recording changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of device picture recording
 * @param _error Error to explain the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordStatePictureStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error);

/**
 * @brief Event of picture recording
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _event Last event of picture recording
 * @param _error Error to explain the event
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordEventPictureEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error);

/**
 * @brief Max Altitude sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current altitude max
 * @param _min Range min of altitude
 * @param _max Range max of altitude
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsStateMaxAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Max tilt sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max tilt
 * @param _min Range min of tilt
 * @param _max Range max of tilt
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsStateMaxTiltChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Max vertical speed sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max vertical speed in m/s
 * @param _min Range min of vertical speed
 * @param _max Range max of vertical speed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxVerticalSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Max rotation speed sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max rotation speed in degree/s
 * @param _min Range min of rotation speed
 * @param _max Range max of rotation speed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxRotationSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief Presence of wheels sent by product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _present 1 if present, 0 if not present
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateWheelsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present);

/**
 * @brief Max horizontal speed sent by product (only used in case where PilotingSettings_MaxTilt is not used like in hydrofoil mode)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _current Current max horizontal speed in m/s
 * @param _min Range min of horizontal speed
 * @param _max Range max of horizontal speed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxHorizontalSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max);

/**
 * @brief @deprecated
 * Product Motors versions
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _motor Product Motor number [1 - 4]
 * @param _type Product Motor type
 * @param _software Product Motors software version
 * @param _hardware Product Motors hardware version
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateProductMotorsVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _motor, const char * _type, const char * _software, const char * _hardware);

/**
 * @brief @deprecated
 * Product Inertial versions
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _software Product Inertial software version
 * @param _hardware Product Inertial hardware version
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateProductInertialVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware);

/**
 * @brief MiniDrone cut out mode
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enable State of cut out mode (1 if is activate, 0 otherwise)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateCutOutModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable);

/**
 * @brief @deprecated
 * Flood control regulation
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _delay Delay (in ms) between two PCMD
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneFloodControlStateFloodControlChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _delay);


// Feature SkyController


/**
 * @brief Request wifi list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiRequestWifiList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Request current connected wifi
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiRequestCurrentWifi (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Connect to wifi
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _bssid Wifi bssid
 * @param _ssid Wifi ssid
 * @param _passphrase Wifi passphrase
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiConnectToWifi (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _bssid, const char * _ssid, const char * _passphrase);

/**
 * @brief Forget wifi
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid Wifi ssid
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiForgetWifi (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid);

/**
 * @brief Controller inquire the list of authorized wifi channels
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiWifiAuthChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Request Device list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceRequestDeviceList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Request current connected Device
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceRequestCurrentDevice (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief ask to connect to a device
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _deviceName Device name
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceConnectToDevice (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _deviceName);

/**
 * @brief Get all product settings, the product must send all settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsAllSettings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Reset all settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsReset (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Get all product states
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCommonAllStates (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set AccessPoint SSID
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid AccessPoint SSID
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsAccessPointSSID (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid);

/**
 * @brief Set AccessPoint Channel
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _channel AccessPoint Channel
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsAccessPointChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _channel);

/**
 * @brief Set AccessPoint Band and Channel
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi selection (only manual at the moment)
 * @param _band The allowed band : 2.4 Ghz or 5 Ghz
 * @param _channel The channel
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsWifiSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE _type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND _band, uint8_t _channel);

/**
 * @brief Reset pan and tilt to center
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCameraResetOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send the button and axis list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosGetGamepadControls (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send its current button mapping
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsGetCurrentButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send the possible mappings for each button
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsGetAvailableButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set a button mapping to the SkyController
 * @note replaces previous mapping for the given key
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _key_id The keycode to map
 * @param _mapping_uid The mapping to associate with the key
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsSetButtonMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _key_id, const char * _mapping_uid);

/**
 * @brief Asks the SkyController to reset the button mappings to the default value
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsDefaultButtonMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send its current axis mapping
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsGetCurrentAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send the possible mappings for each axis
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsGetAvailableAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set a axis mapping to the SkyController
 * @note replaces previous mapping for the given axis
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _axis_id The axiscode to map
 * @param _mapping_uid The mapping to associate with the axis
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsSetAxisMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _mapping_uid);

/**
 * @brief Asks the SkyController to reset the axis mappings to the default value
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsDefaultAxisMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send its current axis filters
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersGetCurrentAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Asks the SkyController to send the preset filters
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersGetPresetAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set an axis filter to the SkyController
 * @note replaces previous filter for the given axis
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _axis_id The axiscode to filter
 * @param _filter_uid_or_builder The mapping preset to associate with the axis
 * @param _filter_uid_or_builder (Or a string to build a new one)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersSetAxisFilter (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _filter_uid_or_builder);

/**
 * @brief Asks the SkyController to reset the axis filters to the default value
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersDefaultAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set the SkyController piloting source
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _source The source
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCoPilotingSetPilotingSource (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE _source);

/**
 * @brief Asks the SkyController to send (or not) the magneto calibration quality updates.
 * The MagnetoCalibrationState will always be sent when the status parameters changes,
 * regardless of this setting.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enable Flag to enable the feature.
 * @param _enable 1 = enable quality updates
 * @param _enable 0 = disable quality updates
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdates (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable);

/**
 * @brief Return the available wifi list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _bssid Wifi bssid
 * @param _ssid Wifi ssid
 * @param _secured Is wifi secured by passphrase
 * @param _saved Is wifi saved in terminal
 * @param _rssi Wifi rssi
 * @param _frequency Wifi frequency
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _bssid, const char * _ssid, uint8_t _secured, uint8_t _saved, int32_t _rssi, int32_t _frequency);

/**
 * @brief Return connexion status
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid Wifi ssid
 * @param _status Wifi status
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateConnexionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS _status);

/**
 * @brief Notify of an Authorized Channel
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band The band of this channel : 2.4 GHz or 5 GHz
 * @param _channel The authorized channel
 * @param _in_or_out Bit 0 is 1 if channel is authorized outside (0 otherwise) ; Bit 1 is 1 if channel is authorized inside (0 otherwise)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiAuthChannelListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out);

/**
 * @brief Notify the end of the list of Authorized wifi Channel
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateAllWifiAuthChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief State of the wifi signal
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _level Level of the signal. Levels are from 0 to 5. 0 is an unknown value. 1 is a weak wifi signal, 5 is the best.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiSignalChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _level);

/**
 * @brief Return the available Device list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _name Device name
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceStateDeviceList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name);

/**
 * @brief Return device connexion status
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _status Wifi status to Device
 * @param _deviceName Device name
 * @param _deviceProductID Device name
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceStateConnexionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS _status, const char * _deviceName, uint16_t _deviceProductID);

/**
 * @brief State sent when all settings has been sent
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateAllSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief State sent when all settings has been resetting
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateResetChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Product serial number
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _serialNumber Serial number (hexadecimal value)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateProductSerialChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _serialNumber);

/**
 * @brief Product variant of SkyController
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _variant Variant of the product
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateProductVariantChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT _variant);

/**
 * @brief State sent when all product states has been sent
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCommonStateAllStatesChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief State sent when SkyController battery has changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _percent SkyController battery
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateBatteryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _percent);

/**
 * @brief State sent when SkyController gps fix has changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _fixed SkyController fixed
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateGpsFixChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _fixed);

/**
 * @brief State sent when the SkyController gps position has changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude SkyController latitude (500. if not available)
 * @param _longitude SkyController longiture (500. if not available)
 * @param _altitude Altitude (in meters) above sea level
 * @param _altitude Only meaningful if latitude and longiture are available
 * @param _heading SkyController heading relative to magnetic north (500.f if not available)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateGpsPositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude, float _heading);

/**
 * @brief State sent when AccessPoint ssid has been sent
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid AccessPoint SSID
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateAccessPointSSIDChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid);

/**
 * @brief State sent when AccessPoint channel has been sent
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _channel AccessPoint Channel
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateAccessPointChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _channel);

/**
 * @brief Wifi selection from product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type of wifi selection (only manual at the moment)
 * @param _band The allowed band : 2.4 Ghz or 5 Ghz
 * @param _channel The channel
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateWifiSelectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel);

/**
 * @brief Describe an existing button or axis of the gamepad
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type The type (axis/button) of the control
 * @param _id The button or axis id
 * @param _id @note A button and an axis can have the same ID, but their type is different
 * @param _name Display name for the control
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosStateGamepadControl (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE _type, int32_t _id, const char * _name);

/**
 * @brief Sent by the SkyController after sending its last 'gamepadControl' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosStateAllGamepadControlsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent by the SkyController each time a mapping changes
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _key_id The keycode mapped
 * @param _mapping_uid The mapping associated
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateCurrentButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _key_id, const char * _mapping_uid);

/**
 * @brief Sent by the SkyController after sending its last 'currentButtonMappings' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAllCurrentButtonMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent after a 'getAvailableButtonMappings' request
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mapping_uid The mapping UID (used in communication with the SkyController)
 * @param _name Display name for the user
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAvailableButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _mapping_uid, const char * _name);

/**
 * @brief Sent by the SkyController after sending its last 'availableButtonMappings' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent by the SkyController each time a mapping changes
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _axis_id The axiscode mapped
 * @param _mapping_uid The mapping associated
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateCurrentAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _mapping_uid);

/**
 * @brief Sent by the SkyController after sending its last 'currentAxisMappings' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAllCurrentAxisMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent after a 'getAvailableAxisMappings' request
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mapping_uid The mapping UID (used in communication with the SkyController)
 * @param _name Display name for the user
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAvailableAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _mapping_uid, const char * _name);

/**
 * @brief Sent by the SkyController after sending its last 'availableAxisMappings' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAllAvailableAxisMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent by the SkyController each time a filter changes
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _axis_id The axiscode filtered
 * @param _filter_uid_or_builder The filter associated
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateCurrentAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _filter_uid_or_builder);

/**
 * @brief Sent by the SkyController after sending its last 'currentAxisFilters' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateAllCurrentFiltersSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent after a 'getPresetAxisFilters' request
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _filter_uid The filter UID (used in communication with the SkyController)
 * @param _name Display name for the user
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStatePresetAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _filter_uid, const char * _name);

/**
 * @brief Sent by the SkyController after sending its last 'presetAxisFilters' command
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateAllPresetFiltersSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Source of the piloting commands
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _source The source
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCoPilotingStatePilotingSource (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE _source);

/**
 * @brief The current state of the magnetometer calibration
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _status The global status of the calibration
 * @param _X_Quality Calibration quality on X axis.
 * @param _X_Quality 0 is bad, 255 is perfect
 * @param _Y_Quality Calibration quality on Y axis.
 * @param _Y_Quality 0 is bad, 255 is perfect
 * @param _Z_Quality Calibration quality on Z axis.
 * @param _Z_Quality 0 is bad, 255 is perfect
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCalibrationStateMagnetoCalibrationState (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS _status, uint8_t _X_Quality, uint8_t _Y_Quality, uint8_t _Z_Quality);

/**
 * @brief State of the "send calibration state on quality change" setting.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled Flag (is the feature enabled).
 * @param _enabled 1 = The skycontroller sends updated when quality is updated
 * @param _enabled 0 = The skycontroller only sent updated when state is updated
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesState (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled);

/**
 * @brief Event sent when the settings button is pressed.
 * This event is sent only when the sky controller is connected
 * to a drone.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonEventsSettings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);


// Feature unknown_feature_1


/**
 * @brief Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start geographic unknown feature_1 process, 0 to stop it
 * @param _start Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param _distance_is_default 0 if distance is set by user, 1 if set by current distance (in this case distance value is not used)
 * @param _distance_is_default Not used when arg start is at 0
 * @param _distance_is_default Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param _distance The distance leader-follower in meter
 * @param _distance Not used when arg start is at 0
 * @param _distance Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param _elevation_is_default 0 if elevation is set by user, 1 if set by current elevation (in this case elevation value is not used) (not used when arg start is at 0)
 * @param _elevation_is_default Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param _elevation The elevation leader-follower in rad (not used when arg start is at 0)
 * @param _elevation Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param _azimuth_is_default 0 if azimuth is set by user, 1 if set by current azimuth (in this case azimuth value is not used) (not used when arg start is at 0)
 * @param _azimuth_is_default Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @param _azimuth The azimuth north-leader-follower in rad (not used when arg start is at 0)
 * @param _azimuth Begin or stop geographic type followMe (follow the leader keeping the same vector). \n\                       Sending this command will stop other running followMe.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1GeographicRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth);

/**
 * @brief Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start relative unknown feature_1 process, 0 to stop it
 * @param _start Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param _distance_is_default 0 if distance is set by user, 1 if set by current distance (in this case distance value is not used) (not used when arg start is at 0)
 * @param _distance_is_default Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param _distance The distance leader-follower in meter (not used when arg start is at 0)
 * @param _distance Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param _elevation_is_default 0 if elevation is set by user, 1 if set by current elevation (in this case elevation value is not used) (not used when arg start is at 0)
 * @param _elevation_is_default Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param _elevation The elevation leader-follower in rad (not used when arg start is at 0)
 * @param _elevation Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param _azimuth_is_default 0 if azimuth is set by user, 1 if set by current azimuth (in this case azimuth value is not used) (not used when arg start is at 0)
 * @param _azimuth_is_default Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @param _azimuth The azimuth north-leader-follower in rad (not used when arg start is at 0)
 * @param _azimuth Begin or stop relative type followMe (follow the leader keeping the same orientation to its direction).\n\                       Sending this command will stop other running followMe.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1RelativeRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth);

/**
 * @brief Begin or stop look at type followMe (stare at the leader while hovering).\n\                      Sending this command will stop other running followMe.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start look at process, 0 to stop it
 * @param _start Begin or stop look at type followMe (stare at the leader while hovering).\n\                      Sending this command will stop other running followMe.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1LookAtRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start);

/**
 * @brief Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start the anim, 0 to stop it
 * @param _start Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param _speed_is_default Not used when start is 0
 * @param _speed_is_default Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param _speed The desired speed of the anim in m/s
 * @param _speed Not used when speed_is_default is 1
 * @param _speed Not used when start is 0
 * @param _speed Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param _revolution_nb_is_default 0 if the number of revolution is set by user, 1 if default revolution nb should be used
 * @param _revolution_nb_is_default Not used when start is 0
 * @param _revolution_nb_is_default Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param _revolution_number The number of revolution (in turn)
 * @param _revolution_number Negative value is infinite
 * @param _revolution_number Example: 1.5 makes an entire turn plus half of a turn
 * @param _revolution_number Not used when revolutionNb_is_default is 1
 * @param _revolution_number Not used when start is 0
 * @param _revolution_number Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param _vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value should be used
 * @param _vertical_distance_is_default Not used when start is 0
 * @param _vertical_distance_is_default Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @param _vertical_distance Distance that should be made by the product to reach the top of the spiral in m
 * @param _vertical_distance Not used when verticalDistance_is_default is 1
 * @param _vertical_distance Not used when start is 0
 * @param _vertical_distance Begin or stop a spiral animation.\n\                      The spiral animation allows the drone to revolve around the target while going up, with a fixed radius.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SpiralAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _revolution_nb_is_default, float _revolution_number, uint8_t _vertical_distance_is_default, float _vertical_distance);

/**
 * @brief Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start the anim, 0 to stop it
 * @param _start Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param _speed_is_default Not used when start is 0
 * @param _speed_is_default Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param _speed The desired speed of the anim in m/s
 * @param _speed Not used when speed_is_default is 1
 * @param _speed Not used when start is 0
 * @param _speed Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param _vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value should be used
 * @param _vertical_distance_is_default Not used when start is 0
 * @param _vertical_distance_is_default Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @param _vertical_distance Distance that should be made by the product to reach the top of the swing in m
 * @param _vertical_distance Not used when verticalDistance_is_default is 1
 * @param _vertical_distance Not used when start is 0
 * @param _vertical_distance Begin or stop a swing animation.\n\                      The swing animation enables a vertical point of view while the drone passes over the target.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SwingAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance);

/**
 * @brief Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start the anim, 0 to stop it
 * @param _start Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param _speed_is_default Not used when start is 0
 * @param _speed_is_default Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param _speed The desired speed of the anim in m/s
 * @param _speed Not used when speed_is_default is 1
 * @param _speed Not used when start is 0
 * @param _speed Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param _distance_is_default 0 if the distance is set by user, 1 if default value should be used
 * @param _distance_is_default Not used when start is 0
 * @param _distance_is_default Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @param _distance Distance that should be made by the product to reach its return point in m
 * @param _distance Not used when distance_is_default is 1
 * @param _distance Not used when start is 0
 * @param _distance Begin or stop a boomerang animation.\n\                      The boomerang animation enables a zoom-out/zoom-in trajectory while preserving the framing chosen by the user.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1BoomerangAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _distance_is_default, float _distance);

/**
 * @brief Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start the anim, 0 to stop it
 * @param _start Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param _speed_is_default Not used when start is 0
 * @param _speed_is_default Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param _speed The desired speed of the anim in m/s
 * @param _speed Not used when speed_is_default is 1
 * @param _speed Not used when start is 0
 * @param _speed Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param _vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value should be used
 * @param _vertical_distance_is_default Not used when start is 0
 * @param _vertical_distance_is_default Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @param _vertical_distance Distance that should be made by the product to reach the top of the vertical zoom-out in m
 * @param _vertical_distance Not used when verticalDistance_is_default is 1
 * @param _vertical_distance Not used when start is 0
 * @param _vertical_distance Begin or stop a candle animation.\n\                      The candle animation enables a zoom-in directly on the target followed by a vertical zoom-out.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1CandleAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance);

/**
 * @brief Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _start 1 to start the anim, 0 to stop it
 * @param _start Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed should be used
 * @param _speed_is_default Not used when start is 0
 * @param _speed_is_default Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param _speed The desired speed of the anim in m/s
 * @param _speed Not used when speed_is_default is 1
 * @param _speed Not used when start is 0
 * @param _speed Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param _angle_is_default 0 if the angle is set by user, 1 if default value should be used
 * @param _angle_is_default Not used when start is 0
 * @param _angle_is_default Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param _angle Desired angle Product-User-Target in rad
 * @param _angle Not used when angle_is_default is 1
 * @param _angle Not used when start is 0
 * @param _angle Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param _horizontal_distance_is_default 0 if the horizontal distance is set by user, 1 if default value should be used
 * @param _horizontal_distance_is_default Not used when start is 0
 * @param _horizontal_distance_is_default Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @param _horizontal_distance Distance that should be made by the product to reach its target in m
 * @param _horizontal_distance Not used when horizontalDistance_is_default is 1
 * @param _horizontal_distance Not used when start is 0
 * @param _horizontal_distance Begin or stop a dolly slide animation.\n\                      Allows the drone to catch up to the target before flying past it, creating a zoom-in/zoom_out effect without a curved path.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1DollySlideAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _angle_is_default, float _angle, uint8_t _horizontal_distance_is_default, float _horizontal_distance);

/**
 * @brief User desired framing in the video.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _horizontal Horizontal position in the video (in %, from left to right)
 * @param _horizontal User desired framing in the video.
 * @param _vertical Vertical position in the video (in %, from bottom to top)
 * @param _vertical User desired framing in the video.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserFramingPosition (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _horizontal, int8_t _vertical);

/**
 * @brief User gps data
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Latitude of the user (in deg)
 * @param _longitude Longitude of the user (in deg)
 * @param _altitude Altitude of the user (in meters, according to sea level)
 * @param _horizontal_accuracy Horizontal accuracy (in meter)
 * @param _vertical_accuracy Vertical accuracy (in meter)
 * @param _north_speed North speed (in meter per second)
 * @param _east_speed East speed (in meter per second)
 * @param _down_speed Vertical speed (in meter per second) (down is positive)
 * @param _timestamp Timestamp of the gps data
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserGPSData (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, float _altitude, float _horizontal_accuracy, float _vertical_accuracy, float _north_speed, float _east_speed, float _down_speed, double _timestamp);

/**
 * @brief User barometer data
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _pressure Atmospheric pressure in hPa (millibar)
 * @param _timestamp Timestamp of the barometer data
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserBaroData (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _pressure, double _timestamp);

/**
 * @brief Send vision detection results.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _target_pan Pan angle of detected target in radian
 * @param _target_pan Send vision detection results.
 * @param _target_tilt Tilt angle of detected target in radian
 * @param _target_tilt Send vision detection results.
 * @param _change_of_scale Target's change of scale : new width = (1+ changOfScale) * old width
 * @param _change_of_scale Send vision detection results.
 * @param _confidence_index Confidence index of the Lynx detection (from 0 to 255, the highest is the best)
 * @param _confidence_index Send vision detection results.
 * @param _is_new_selection Boolean. 1 if the selection is new, 0 otherwise
 * @param _is_new_selection Send vision detection results.
 * @param _timestamp Acquisition time of processed picture in millisecond
 * @param _timestamp Send vision detection results.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1LynxDetection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _target_pan, float _target_tilt, float _change_of_scale, uint8_t _confidence_index, uint8_t _is_new_selection, uint64_t _timestamp);

/**
 * @brief Get the UnknownFeature_1 types you can run.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Get the UnknownFeature_1 types you can run.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1Availability (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE _type);

/**
 * @brief State of the UnknownFeature_1 run
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1Run (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE _type);

/**
 * @brief Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _distance_is_default 0 if distance is set by user, 1 if set by current distance
 * @param _distance_is_default Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @param _distance The distance leader-follower in meter, if distance is default, this value is the current drone distance
 * @param _distance Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @param _elevation_is_default 0 if elevation is set by user, 1 if set by current elevation
 * @param _elevation_is_default Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @param _elevation The elevation leader-follower in rad, if elevation is default, this value is the current leader to drone elevation angle
 * @param _elevation Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @param _azimuth_is_default 0 if azimuth is set by user, 1 if set by current azimuth
 * @param _azimuth_is_default Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @param _azimuth The azimuth north-leader-follower in rad, if azimuth is default, this value is the current leader to drone azimuth
 * @param _azimuth Geographic configuration changed.\n\                      This event is only valid when [Run type](#134-2) is geographic.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1GeographicConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth);

/**
 * @brief Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _distance_is_default 0 if distance is set by user, 1 if set by current distance
 * @param _distance_is_default Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @param _distance The distance leader-follower in meter, if distance is default, this value is the current drone distance
 * @param _distance Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @param _elevation_is_default 0 if elevation is set by user, 1 if set set by current elevation
 * @param _elevation_is_default Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @param _elevation The elevation leader-follower in rad, if elevation is default, this value is the current leader to drone elevation
 * @param _elevation Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @param _azimuth_is_default 0 if azimuth is set by user, 1 if set by current azimuth
 * @param _azimuth_is_default Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @param _azimuth The azimuth course-leader-follower in rad, if azimuth is default, this value is the current leader to drone azimuth
 * @param _azimuth Relative configuration changed.\n\                      This event is only valid when [Run type](#134-2) is relative.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1RelativeConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth);

/**
 * @brief State of the current UnknownFeature_1 animation.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type State of the current UnknownFeature_1 animation.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1AnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE _type);

/**
 * @brief Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed is used
 * @param _speed_is_default Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @param _speed The speed of the anim in m/s
 * @param _speed Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @param _revolution_nb_is_default 0 if the number of revolution is set by user, 1 if default revolution nb is used
 * @param _revolution_nb_is_default Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @param _revolution_nb The number of revolution (in turn)
 * @param _revolution_nb Negative value is infinite
 * @param _revolution_nb Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @param _vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value is used
 * @param _vertical_distance_is_default Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @param _vertical_distance Distance that will be made by the product to reach the top of the spiral in m
 * @param _vertical_distance Spiral animation configuration changed.\n\                 This event is only valid when AnimRun type is spiral
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SpiralAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _revolution_nb_is_default, float _revolution_nb, uint8_t _vertical_distance_is_default, float _vertical_distance);

/**
 * @brief Swing animation configuration changed.\n\                 This event is only valid when AnimRun type is swing
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed is used
 * @param _speed_is_default Swing animation configuration changed.\n\                 This event is only valid when AnimRun type is swing
 * @param _speed The speed of the anim in m/s
 * @param _speed Swing animation configuration changed.\n\                 This event is only valid when AnimRun type is swing
 * @param _vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value is used
 * @param _vertical_distance_is_default Swing animation configuration changed.\n\                 This event is only valid when AnimRun type is swing
 * @param _vertical_distance Distance that will be made by the product to reach the top of the swing in m
 * @param _vertical_distance Swing animation configuration changed.\n\                 This event is only valid when AnimRun type is swing
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SwingAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance);

/**
 * @brief Boomerang animation configuration changed.\n\                 This event is only valid when AnimRun type is boomerang
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed is used
 * @param _speed_is_default Boomerang animation configuration changed.\n\                 This event is only valid when AnimRun type is boomerang
 * @param _speed The speed of the anim in m/s
 * @param _speed Boomerang animation configuration changed.\n\                 This event is only valid when AnimRun type is boomerang
 * @param _distance_is_default 0 if the distance is set by user, 1 if default value is used
 * @param _distance_is_default Boomerang animation configuration changed.\n\                 This event is only valid when AnimRun type is boomerang
 * @param _distance Distance that will be made by the product to reach its return point in m
 * @param _distance Boomerang animation configuration changed.\n\                 This event is only valid when AnimRun type is boomerang
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1BoomerangAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _distance_is_default, float _distance);

/**
 * @brief Candle animation configuration changed.\n\                 This event is only valid when AnimRun type is candle
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed is used
 * @param _speed_is_default Candle animation configuration changed.\n\                 This event is only valid when AnimRun type is candle
 * @param _speed The speed of the anim in m/s
 * @param _speed Candle animation configuration changed.\n\                 This event is only valid when AnimRun type is candle
 * @param _vertical_distance_is_default 0 if the vertical distance is set by user, 1 if default value is used
 * @param _vertical_distance_is_default Candle animation configuration changed.\n\                 This event is only valid when AnimRun type is candle
 * @param _vertical_distance Distance that will be made by the product to reach the top of the vertical zoom-out in m
 * @param _vertical_distance Candle animation configuration changed.\n\                 This event is only valid when AnimRun type is candle
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1CandleAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance);

/**
 * @brief DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _speed_is_default 0 if speed is set by user, 1 if default speed is used
 * @param _speed_is_default DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @param _speed The speed of the anim in m/s
 * @param _speed DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @param _angle_is_default 0 if the angle is set by user, 1 if default value is used
 * @param _angle_is_default DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @param _angle Angle Product-User-Target in rad
 * @param _angle DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @param _horizontal_distance_is_default 0 if the horizontal distance is set by user, 1 if default value is used
 * @param _horizontal_distance_is_default DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @param _horizontal_distance Distance that will be made by the product to reach its target in m
 * @param _horizontal_distance DollySlide animation configuration changed.\n\                 This event is only valid when AnimRun type is dolly_slide
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1DollySlideAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _angle_is_default, float _angle, uint8_t _horizontal_distance_is_default, float _horizontal_distance);

/**
 * @brief User desired framing in the video changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _horizontal Horizontal position in the video (in %, from left to right)
 * @param _vertical Vertical position in the video (in %, from bottom to top)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserFramingPositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _horizontal, int8_t _vertical);


// Feature common


/**
 * @brief @deprecated
 * Signals the remote that the host will disconnect and close its
 * libARNetwork instance (and all threads that use libARNetwork)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonNetworkDisconnect (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Get all product settings, the product must send all settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsAllSettings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Reset all settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsReset (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set Product name
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _name Product name
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsProductName (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name);

/**
 * @brief Set current Country of controller
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _code Country code with ISO 3166 format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsCountry (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _code);

/**
 * @brief Set Auto Country Settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _automatic Boolean : 0 : Manual / 1 : Auto
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsAutoCountry (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _automatic);

/**
 * @brief Get all product states.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonAllStates (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set current date of controller
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _date Date with ISO-8601 format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonCurrentDate (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _date);

/**
 * @brief Set current time of controller
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _time Time with ISO-8601 format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonCurrentTime (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _time);

/**
 * @brief Command to ask reboot to product
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonReboot (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief @deprecated
 * Switch off the drone when a overheat appeared
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatSwitchOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief @deprecated
 * Ventilate the drone when a overheat appeared
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatVentilate (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Tell the device when the controller application enters/leaves the piloting HUD.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _piloting 0 when the application is not in the piloting HUD, 1 when it enters the HUD.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonControllerIsPiloting (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _piloting);

/**
 * @brief Send to product if it should use its outdoor wifi config, or indoor
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _outdoor 1 if it should use outdoor wifi settings, 0 otherwise
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonWifiSettingsOutdoorSetting (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor);

/**
 * @brief Start the flight plan
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _filepath flight plan file path from the mavlink ftp root
 * @param _type type of the played mavlink file
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStart (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _filepath, eARCOMMANDS_COMMON_MAVLINK_START_TYPE _type);

/**
 * @brief Pause the flightplan (can be restarted with a start)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkPause (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Stop the flightplan
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStop (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Sent when a calibration of the magnetometer is asked or is aborted
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _calibrate 1 if the calibration should be started, 0 if it should be aborted
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationMagnetoCalibration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _calibrate);

/**
 * @brief Set the controller position for a run. This command is used by all non gps products. Watch out, this command cannot be used with BLE products
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _latitude Controller latitude in decimal degrees
 * @param _longitude Controller longitude in decimal degrees
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonGPSControllerPositionForRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude);

/**
 * @brief Tell the firmware whether the controller is ready to start audio streaming.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ready Bit field for TX and RX ready.
 * @param _ready bit 0 is 1 if controller is ready and wants to receive sound (Drone TX)
 * @param _ready bit 1 is 1 if controller is ready and wants to send sound (Drone RX)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAudioControllerReadyForStreaming (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _ready);

/**
 * @brief Set instensity of lighting LEDs.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _left Set the left LED intensity value (0 through 255).
 * @param _right Set the right LED intensity value (0 through 255).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonHeadlightsIntensity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _left, uint8_t _right);

/**
 * @brief Start a paramaterless animation.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _anim Animation to start.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStartAnimation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM _anim);

/**
 * @brief Stop a running animation.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _anim Animation to stop.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStopAnimation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM _anim);

/**
 * @brief Stop all running animations.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStopAllAnimations (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Set the current accessory configuration.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _accessory Accessory configuration to set.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryConfig (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY _accessory);

/**
 * @brief @deprecated
 * Set the maximum charge rate allowed to charge a battery.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _rate The new maximum charge rate.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerSetMaxChargeRate (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE _rate);

/**
 * @brief Signals the remote that the host will disconnect and close its
 * libARNetwork instance (and all threads that use libARNetwork)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _cause Cause of the disconnection of the product
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonNetworkEventDisconnection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE _cause);

/**
 * @brief State sent when all settings has been sent.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateAllSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief State sent when all settings has been resetting.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateResetChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Product name
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _name Product name
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductNameChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name);

/**
 * @brief Product versions
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _software Product software version
 * @param _hardware Product hardware version
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware);

/**
 * @brief Product serial number
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _high Serial high number (hexadecimal value)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductSerialHighChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _high);

/**
 * @brief Product serial number
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _low Serial low number (hexadecimal value)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductSerialLowChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _low);

/**
 * @brief Inform current Country set in product. (Answer to 'Country' command)
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _code Country code with ISO 3166 format, empty string means unknown country.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateCountryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _code);

/**
 * @brief Inform Auto Country Settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _automatic Boolean : 0 : Manual / 1 : Auto
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateAutoCountryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _automatic);

/**
 * @brief State sent when all product states has been sent.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateAllStatesChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Battery state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _percent Battery percentage
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateBatteryStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _percent);

/**
 * @brief Mass storage state list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mass_storage_id Mass storage id (unique)
 * @param _name Mass storage name
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id, const char * _name);

/**
 * @brief Mass storage info state list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _mass_storage_id Mass storage state id (unique)
 * @param _size Mass storage size in MBytes
 * @param _used_size Mass storage used size in MBytes
 * @param _plugged Mass storage plugged (1 if mass storage is plugged, otherwise 0)
 * @param _full Mass storage full information state (1 if mass storage full, 0 otherwise).
 * @param _internal Mass storage internal type state (1 if mass storage is internal, 0 otherwise)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageInfoStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id, uint32_t _size, uint32_t _used_size, uint8_t _plugged, uint8_t _full, uint8_t _internal);

/**
 * @brief Current date state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _date Date with ISO-8601 format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateCurrentDateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _date);

/**
 * @brief Current time state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _time Time with ISO-8601 format
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateCurrentTimeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _time);

/**
 * @brief @deprecated
 * Mass storage info remaining list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _free_space Mass storage free space in MBytes
 * @param _rec_time Mass storage record time reamining in minute
 * @param _photo_remaining Mass storage photo remaining
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageInfoRemainingListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint32_t _free_space, uint16_t _rec_time, uint32_t _photo_remaining);

/**
 * @brief Wifi Signal between controller and product state
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _rssi RSSI of the signal between controller and the product (in dbm)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateWifiSignalChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int16_t _rssi);

/**
 * @brief Sensors states list
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _sensorName Sensor name
 * @param _sensorState Sensor state (1 if the sensor is OK, 0 if the sensor is NOT OK)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateSensorsStatesListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME _sensorName, uint8_t _sensorState);

/**
 * @brief Inform of the product model. This is used to customize the UI depending on the connected product.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _model The Model of the product.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateProductModel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL _model);

/**
 * @brief List of the countries known by the device
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _listFlags List entry attribute Bitfield.
 * @param _listFlags 0x01: First: indicate it's the first element of the list.
 * @param _listFlags 0x02: Last:  indicate it's the last element of the list.
 * @param _listFlags 0x04: Empty: indicate the list is empty (implies First/Last). All other arguments should be ignored.
 * @param _countryCodes Following of country code with ISO 3166 format, separated by ";". Be careful of the command size allowed by the network used. If necessary, split the list in several commands.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateCountryListKnown (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _listFlags, const char * _countryCodes);

/**
 * @brief @deprecated
 * Overheat temperature reached
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatStateOverHeatChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief @deprecated
 * Overheat regulation state changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _regulationType Type of overheat regulation : 0 for ventilation, 1 for switch off
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatStateOverHeatRegulationChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _regulationType);

/**
 * @brief Status of the wifi config : either indoor or outdoor
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _outdoor 1 if it should use outdoor wifi settings, 0 otherwise
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonWifiSettingsStateOutdoorSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor);

/**
 * @brief Playing state of a mavlink flight plan
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _state State of the mavlink
 * @param _filepath flight plan file path from the mavlink ftp root
 * @param _type type of the played mavlink file
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStateMavlinkFilePlayingStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE _state, const char * _filepath, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE _type);

/**
 * @brief FlightPlan play state error
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _error State of play error
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStateMavlinkPlayErrorStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR _error);

/**
 * @brief Sent when the state of the magneto calibration has changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _xAxisCalibration State of the x axis (roll) calibration : 1 if calibration is done, 0 otherwise
 * @param _yAxisCalibration State of the y axis (pitch) calibration : 1 if calibration is done, 0 otherwise
 * @param _zAxisCalibration State of the z axis (yaw) calibration : 1 if calibration is done, 0 otherwise
 * @param _calibrationFailed 1 if calibration has failed, 0 otherwise. If this arg is 1, consider all previous arg as 0
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _xAxisCalibration, uint8_t _yAxisCalibration, uint8_t _zAxisCalibration, uint8_t _calibrationFailed);

/**
 * @brief Status of the calibration requirement
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _required 1 if calibration is required, 0 if current calibration is still valid
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationRequiredState (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _required);

/**
 * @brief Event sent by a product to inform about the axis to calibrate
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _axis The axis to calibrate
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS _axis);

/**
 * @brief Status of the calibration process
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _started 1 if calibration has started, 0 otherwise
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationStartedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _started);

/**
 * @brief Status of the camera settings
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _fov Value of the camera horizontal fov (in degree)
 * @param _panMax Value of max pan (right pan) (in degree)
 * @param _panMin Value of min pan (left pan) (in degree)
 * @param _tiltMax Value of max tilt (top tilt) (in degree)
 * @param _tiltMin Value of min tilt (bottom tilt) (in degree)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCameraSettingsStateCameraSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _fov, float _panMax, float _panMin, float _tiltMax, float _tiltMin);

/**
 * @brief State of availability to run a flight plan file
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _AvailabilityState Running a flightPlan file is available (1 running a flightPlan file is available, otherwise 0)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanStateAvailabilityStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _AvailabilityState);

/**
 * @brief List of state of drone flightPlan components
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _component Drone FlightPlan component id (unique)
 * @param _State State of the FlightPlan component (1 FlightPlan component OK, otherwise 0)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanStateComponentStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT _component, uint8_t _State);

/**
 * @brief Event of flight plan start error
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanEventStartingErrorEvent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Bridle speed of the drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanEventSpeedBridleEvent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Controller libARCommands version
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _version version of libARCommands ("1.2.3.4" format)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateControllerLibARCommandsVersion (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version);

/**
 * @brief SkyController libARCommands version
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _version version of libARCommands ("1.2.3.4" format)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateSkyControllerLibARCommandsVersion (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version);

/**
 * @brief Device libARCommands version
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _version version of libARCommands ("1.2.3.4" format)
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateDeviceLibARCommandsVersion (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version);

/**
 * @brief Notify the controller whether the audio streaming is running.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _running Bit field for TX and RX running
 * @param _running bit 0 is 1 if Drone TX is running
 * @param _running bit 1 is 1 if Drone RX is running
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAudioStateAudioStreamingRunning (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _running);

/**
 * @brief Notify the instensity values for headlight LEDs.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _left The intensity value for the left LED (0 through 255).
 * @param _right The intensity value for the right LED (0 through 255).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonHeadlightsStateIntensityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _left, uint8_t _right);

/**
 * @brief List of animations state.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _anim Animation type.
 * @param _state State of the animation
 * @param _error Error to explain the state
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStateList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM _anim, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE _state, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR _error);

/**
 * @brief List of supported accessories
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _accessory Accessory configurations supported by the product.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryStateSupportedAccessoriesListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY _accessory);

/**
 * @brief Accessory config response.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _newAccessory Accessory configuration reported by firmware.
 * @param _error Error code.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryStateAccessoryConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY _newAccessory, eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR _error);

/**
 * @brief Possibility to modify the accessory configuration.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _enabled 1 if the modification of the accessory Config is enabled, 0 otherwise
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryStateAccessoryConfigModificationEnabled (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled);

/**
 * @brief @deprecated
 * The maximum charge rate reported by the firmware.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _rate The current maximum charge rate.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateMaxChargeRateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE _rate);

/**
 * @brief @deprecated
 * The charge status of the battery changed.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _status Charger status.
 * @param _phase The current charging phase.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateCurrentChargeStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS _status, eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE _phase);

/**
 * @brief @deprecated
 * The charge rate of the last charge sent by the firmware.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _rate The charge rate recorded by the firmware for the last charge.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateLastChargeRateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE _rate);

/**
 * @brief Information of the charge.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _phase The current charging phase.
 * @param _rate The charge rate. If phase is DISCHARGING, refers to the last charge.
 * @param _intensity The charging intensity, in dA. (12dA = 1,2A) ; If phase is DISCHARGING, refers to the last charge. Equals to 0 if not known.
 * @param _fullChargingTime The full charging time estimated, in minute. If phase is DISCHARGING, refers to the last charge. Equals to 0 if not known.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateChargingInfo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE _phase, eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE _rate, uint8_t _intensity, uint8_t _fullChargingTime);

/**
 * @brief Sent when a run id has changed
 * Run ids are uniquely identifying a run or a flight
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _runId Id of the run
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonRunStateRunIdChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _runId);


// Feature commonDebug


/**
 * @brief Send a packet to the drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _packet Packet to send to the drone
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugStatsSendPacket (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _packet);

/**
 * @brief Ask drone to start sending packets
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _frequency Frequency of the packet
 * @param _packetSize Size of the the packet
 * @param _date time of day in sec
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugStatsStartSendingPacketFromDrone (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _frequency, uint8_t _packetSize, uint32_t _date);

/**
 * @brief Ask drone to stop sending packets
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugStatsStopSendingPacketFromDrone (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Cmd sent by controller to get all settings info (generate "SettingInfo" events).
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsGetAll (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Change setting value.
 * Cmd sent by controller to change a writable setting.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _id Setting Id.
 * @param _value New setting value (string encoded).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsSet (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _id, const char * _value);

/**
 * @brief Send a packet from drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _packet packet from drone
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugStatsEventSendPacket (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _packet);

/**
 * @brief Sent by the drone as answer to GetSettingsInfo
 * Describe a debug setting and give the current value.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _listFlags List entry attribute Bitfield.
 * @param _listFlags 0x01: First: indicate it's the first element of the list.
 * @param _listFlags 0x02: Last:  indicate it's the last element of the list.
 * @param _listFlags 0x04: Empty: indicate the list is empty (implies First/Last). All other arguments should be ignored.
 * @param _id Setting Id.
 * @param _label Setting displayed label (single line).
 * @param _type Setting type.
 * @param _mode Setting mode.
 * @param _range_min Setting range minimal value for decimal type.
 * @param _range_max Setting range max value for decimal type.
 * @param _range_step Setting step value for decimal type
 * @param _value Current Setting value (string encoded).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsStateInfo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _listFlags, uint16_t _id, const char * _label, eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE _type, eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE _mode, const char * _range_min, const char * _range_max, const char * _range_step, const char * _value);

/**
 * @brief Setting value changed.
 * Cmd sent by drone when setting changed occurred.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _id Setting Id.
 * @param _value New setting value (string encoded).
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _id, const char * _value);


// Feature pro


/**
 * @brief Bought features on this pro version of the controller (features that have been bought)
 * This command starts the pro authentification process
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _features Bought features
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateProProBoughtFeatures (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint64_t _features);

/**
 * @brief Response to the challenge string sent by the controller
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _listFlags List entry attribute Bitfield.
 * @param _listFlags 0x01: First: indicate it's the first element of the list.
 * @param _listFlags 0x02: Last:  indicate it's the last element of the list.
 * @param _listFlags 0x04: Empty: indicate the list is empty (implies First/Last). All other arguments should be ignored.
 * @param _signedChallenge the signed challenge
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateProProResponse (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _listFlags, const char * _signedChallenge);

/**
 * @brief Activate some pro features
 * Pro features activated should be part of the list returned by ProState->FeaturesSupported
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _features Pro features to activate
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateProProActivateFeatures (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint64_t _features);

/**
 * @brief Features supported. This command ends the pro authentification
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _status Status of the supported features
 * @param _features Supported pro features.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateProProStateSupportedFeatures (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS _status, uint64_t _features);

/**
 * @brief Pro features that are currently activated
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _features Activated pro features.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateProProStateFeaturesActivated (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint64_t _features);

/**
 * @brief Challenge event sent from the drone
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _challenge the challenge that the receiver will have to sign
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateProProEventChallengeEvent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _challenge);


// Feature wifi


/**
 * @brief Launches wifi network scan for a given band to get a list of all wifi networks found by the drone.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band Launches wifi network scan for a given band to get a list of all wifi networks found by the drone.
 * @param _band a combination of ; ARCOMMANDS_FLAG_WIFI_BAND_2_4GHZ ; ARCOMMANDS_FLAG_WIFI_BAND_5GHZ
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiScan (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _band);

/**
 * @brief Get all available Wifi channels.\nThe list of available Wifi channels is related to the country of the drone. You can get this country with the event [WifiCountryChanged](#wifi-CountryChanged).
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiUpdateAuthorizedChannels (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen);

/**
 * @brief Select channel of choosen band to put the drone's access point on this channel.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Select channel of choosen band to put the drone's access point on this channel.
 * @param _band Select channel of choosen band to put the drone's access point on this channel.
 * @param _channel The channel you want to select. Used only when type is manual.
 * @param _channel Select channel of choosen band to put the drone's access point on this channel.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiSetApChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_SELECTION_TYPE _type, eARCOMMANDS_WIFI_BAND _band, uint8_t _channel);

/**
 * @brief Set the wifi security.\nThe security is changed on the next boot.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Set the wifi security.\nThe security is changed on the next boot.
 * @param _key The key to secure the network. Not used if type is open
 * @param _key Set the wifi security.\nThe security is changed on the next boot.
 * @param _key_type Set the wifi security.\nThe security is changed on the next boot.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiSetSecurity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_SECURITY_TYPE _type, const char * _key, eARCOMMANDS_WIFI_SECURITY_KEY_TYPE _key_type);

/**
 * @brief Set the wifi country.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _selection_mode Set the wifi country.
 * @param _code Country code with ISO 3166 format. Not used if automatic is 1.
 * @param _code Set the wifi country.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiSetCountry (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_COUNTRY_SELECTION _selection_mode, const char * _code);

/**
 * @brief Set indoor or outdoor wifi settings.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _environement Set indoor or outdoor wifi settings.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiSetEnvironement (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_ENVIRONEMENT _environement);

/**
 * @brief Wifi scan results.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _ssid SSID of the AP
 * @param _ssid Wifi scan results.
 * @param _rssi RSSI of the AP.
 * @param _rssi Wifi scan results.
 * @param _band Wifi scan results.
 * @param _channel Channel of the AP
 * @param _channel Wifi scan results.
 * @param _list_flags Wifi scan results.
 * @param _list_flags a combination of ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_FIRST ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_LAST ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_EMPTY ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_REMOVE
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiScannedItem (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, int16_t _rssi, eARCOMMANDS_WIFI_BAND _band, uint8_t _channel, uint8_t _list_flags);

/**
 * @brief Available channel results.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _band Available channel results.
 * @param _channel The channel number
 * @param _channel Available channel results.
 * @param _environement Available channel results.
 * @param _environement a combination of ; ARCOMMANDS_FLAG_WIFI_ENVIRONEMENT_INDOOR ; ARCOMMANDS_FLAG_WIFI_ENVIRONEMENT_OUTDOOR
 * @param _list_flags Available channel results.
 * @param _list_flags a combination of ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_FIRST ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_LAST ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_EMPTY ; ARCOMMANDS_FLAG_GENERIC_LIST_FLAGS_REMOVE
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiAuthorizedChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_BAND _band, uint8_t _channel, uint8_t _environement, uint8_t _list_flags);

/**
 * @brief Wifi selection changed.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _type Wifi selection changed.
 * @param _band Wifi selection changed.
 * @param _channel The channel of the drone's access point
 * @param _channel Wifi selection changed.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiApChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_SELECTION_TYPE _type, eARCOMMANDS_WIFI_BAND _band, uint8_t _channel);

/**
 * @brief Wifi security changed
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _key The key to secure the network. Not used if type is open
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiSecurityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _key, eARCOMMANDS_WIFI_SECURITY_TYPE _key_type);

/**
 * @brief Wifi country changed.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _selection_mode Wifi country changed.
 * @param _code Country code with ISO 3166 format, empty string means unknown country.
 * @param _code Wifi country changed.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiCountryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_COUNTRY_SELECTION _selection_mode, const char * _code);

/**
 * @brief Status of the wifi config : either indoor or outdoor.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _environement 1 if it uses outdoor wifi settings, 0 otherwise
 * @param _environement Status of the wifi config : either indoor or outdoor.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiEnvironementChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_WIFI_ENVIRONEMENT _environement);

/**
 * @brief Rssi Changed. This is an information about the Wifi link quality.
 * @warning A command is not NULL terminated and can contain NULL bytes.
 * @param buffer Pointer to the buffer in which the library should store the command
 * @param buffLen Size of the buffer
 * @param cmdLen Pointer to an integer that will hold the actual size of the command
 * @param _rssi Rssi on the connected wifi network. Rssi values are generally between -30 and -120dBm. The nearest of 0 is the better.
 * @param _rssi Rssi Changed. This is an information about the Wifi link quality.
 * @return Error code (see eARCOMMANDS_GENERATOR_ERROR)
 */
eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateWifiRssiChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int16_t _rssi);



#endif /* _LIBARCOMMANDS_ARCOMMANDS_GENERATOR_H_ */
