/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/********************************************
 *            AUTOGENERATED FILE            *
 *             DO NOT MODIFY IT             *
 *                                          *
 * To add new commands :                    *
 *  - Modify ../Xml/commands.xml file       *
 *  - Re-run generateCommandsList.py script *
 *                                          *
 ********************************************/
#include <config.h>
#include "ARCOMMANDS_ReadWrite.h"
#include <libARCommands/ARCOMMANDS_Types.h>
#include <libARCommands/ARCOMMANDS_Generator.h>
#include <libARCommands/ARCOMMANDS_Ids.h>

// Feature generic

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateGenericDefault (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_GENERIC, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_GENERIC_CMD_DEFAULT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}


// Feature ARDrone3

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingFlatTrim (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_FLATTRIM, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingTakeOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_TAKEOFF, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingPCMD (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _flag, int8_t _roll, int8_t _pitch, int8_t _yaw, int8_t _gaz, uint32_t _timestampAndSeqNum)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_PCMD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _flag
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _flag, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _roll
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _roll, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pitch
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _pitch, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _yaw
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _yaw, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _gaz
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _gaz, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _timestampAndSeqNum
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _timestampAndSeqNum, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingLanding (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_LANDING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingEmergency (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_EMERGENCY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingNavigateHome (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_NAVIGATEHOME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingAutoTakeOffMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_AUTOTAKEOFFMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingMoveBy (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _dX, float _dY, float _dZ, float _dPsi)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_MOVEBY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dX
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dX, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dY
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dZ
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dZ, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dPsi
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dPsi, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingUserTakeOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_USERTAKEOFF, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingCircle (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION _direction)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_CIRCLE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _direction
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _direction, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AnimationsFlip (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION _direction)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_ANIMATIONS_CMD_FLIP, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _direction
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _direction, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3CameraOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _tilt, int8_t _pan)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERA, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CAMERA_CMD_ORIENTATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _tilt
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _tilt, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pan
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _pan, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPicture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTURE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD _record, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _record
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _record, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPictureV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTUREV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideoV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD _record)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEOV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _record
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _record, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiScan (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND _band)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFISCAN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiAuthChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFIAUTHCHANNEL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXALTITUDE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxTilt (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXTILT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsAbsolutControl (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _on)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_ABSOLUTCONTROL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _on
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _on, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxDistance (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXDISTANCE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsNoFlyOverMaxDistance (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _shouldNotFlyOver)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_NOFLYOVERMAXDISTANCE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _shouldNotFlyOver
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _shouldNotFlyOver, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALACCELERATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXROTATIONSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsBankedTurn (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_BANKEDTURN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMinAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MINALTITUDE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingDirection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGDIRECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingRadius (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGRADIUS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGALTITUDE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsPitchMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_PITCHMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsLandingMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_LANDINGMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXVERTICALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXROTATIONSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsHullProtection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_HULLPROTECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _present
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _present, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsOutdoor (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_OUTDOOR, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _outdoor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _outdoor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxPitchRollRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXPITCHROLLROTATIONSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE _type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSecurity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE _type, const char * _key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE _keyType)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_key == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISECURITY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _key
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _key, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _keyType
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _keyType, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsPictureFormatSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_PICTUREFORMATSELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsAutoWhiteBalanceSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_AUTOWHITEBALANCESELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsExpositionSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_EXPOSITIONSELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsSaturationSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_SATURATIONSELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsTimelapseSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, float _interval)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_TIMELAPSESELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _interval
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _interval, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoAutorecordSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOAUTORECORDSELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoStabilizationMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE _mode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOSTABILIZATIONMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _mode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingVideoEnable (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMING_CMD_VIDEOENABLE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enable
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enable, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSetHome (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SETHOME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsResetHome (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RESETHOME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSendControllerGPS (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude, double _horizontalAccuracy, double _verticalAccuracy)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SENDCONTROLLERGPS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontalAccuracy
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _horizontalAccuracy, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _verticalAccuracy
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _verticalAccuracy, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsHomeType (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_HOMETYPE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsReturnHomeDelay (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _delay)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RETURNHOMEDELAY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _delay
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _delay, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringElectricFrequency (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY _frequency)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_ELECTRICFREQUENCY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _frequency
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _frequency, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringSetMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE _mode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_SETMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _mode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStatePictureStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStateVideoStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStatePictureStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStateVideoStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordEventPictureEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _event
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _event, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaRecordEventVideoEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _event
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _event, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateFlatTrimChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLATTRIMCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateFlyingStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLYINGSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAlertStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALERTSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateNavigateHomeStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE _state, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON _reason)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_NAVIGATEHOMESTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _reason
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _reason, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStatePositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_POSITIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _speedX, float _speedY, float _speedZ)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_SPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speedX
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speedX, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speedY
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speedY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speedZ
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speedZ, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAttitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _roll, float _pitch, float _yaw)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ATTITUDECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _roll
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _roll, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pitch
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _pitch, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _yaw
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _yaw, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAutoTakeOffModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _altitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALTITUDECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingEventMoveByEnd (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _dX, float _dY, float _dZ, float _dPsi, eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGEVENT_CMD_MOVEBYEND, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dX
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dX, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dY
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dZ
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dZ, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _dPsi
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _dPsi, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateWifiScanListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, int16_t _rssi, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFISCANLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rssi
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _rssi, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateAllWifiScanChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFISCANCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateWifiAuthChannelListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _in_or_out
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _in_or_out, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkStateAllWifiAuthChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxTiltChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAbsolutControlChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _on)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_ABSOLUTCONTROLCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _on
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _on, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxDistanceChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXDISTANCECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _shouldNotFlyOver)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_NOFLYOVERMAXDISTANCECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _shouldNotFlyOver
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _shouldNotFlyOver, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXROTATIONSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateBankedTurnChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_BANKEDTURNCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMinAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MINALTITUDECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingDirectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGDIRECTIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingRadiusChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _current, uint16_t _min, uint16_t _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGRADIUSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _current, uint16_t _min, uint16_t _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGALTITUDECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStatePitchModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_PITCHMODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateLandingModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE _value)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_LANDINGMODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxVerticalSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxRotationSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateHullProtectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_HULLPROTECTIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _present
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _present, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateOutdoorChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _outdoor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _outdoor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXPITCHROLLROTATIONSPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSelectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSecurityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSecurity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE _type, const char * _key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE _keyType)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_key == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _key
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _key, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _keyType
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _keyType, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateProductMotorVersionListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _motor_number, const char * _type, const char * _software, const char * _hardware)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_type == NULL) ||
        (_software == NULL) ||
        (_hardware == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTMOTORVERSIONLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _motor_number
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _motor_number, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _software
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _software, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _hardware
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _hardware, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateProductGPSVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_software == NULL) ||
        (_hardware == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _software
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _software, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _hardware
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _hardware, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorErrorStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _motorIds, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR _motorError)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _motorIds
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _motorIds, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _motorError
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _motorError, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorSoftwareVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_version == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORSOFTWAREVERSIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _version
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _version, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorFlightsStatusChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _nbFlights, uint16_t _lastFlightDuration, uint32_t _totalFlightDuration)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORFLIGHTSSTATUSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _nbFlights
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _nbFlights, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _lastFlightDuration
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _lastFlightDuration, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _totalFlightDuration
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _totalFlightDuration, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorErrorLastErrorChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR _motorError)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORLASTERRORCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _motorError
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _motorError, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3SettingsStateP7ID (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _serialID)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_serialID == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_P7ID, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _serialID
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _serialID, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStatePictureFormatChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_PICTUREFORMATCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateAutoWhiteBalanceChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_AUTOWHITEBALANCECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateExpositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_EXPOSITIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateSaturationChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _value, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_SATURATIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _value
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _value, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateTimelapseChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, float _interval, float _minInterval, float _maxInterval)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_TIMELAPSECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _interval
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _interval, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _minInterval
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _minInterval, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _maxInterval
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _maxInterval, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateVideoAutorecordChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOAUTORECORDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateVideoStabilizationModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE _mode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOSTABILIZATIONMODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _mode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingStateVideoEnableChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateHomeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateResetHomeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RESETHOMECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateGPSFixStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _fixed)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSFIXSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _fixed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _fixed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateGPSUpdateStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSUPDATESTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateHomeTypeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMETYPECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateReturnHomeDelayChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _delay)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RETURNHOMEDELAYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _delay
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _delay, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3CameraStateOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _tilt, int8_t _pan)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERASTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_ORIENTATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _tilt
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _tilt, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pan
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _pan, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3CameraStateDefaultCameraOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _tilt, int8_t _pan)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERASTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_DEFAULTCAMERAORIENTATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _tilt
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _tilt, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pan
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _pan, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringStateElectricFrequencyChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY _frequency)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_ELECTRICFREQUENCYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _frequency
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _frequency, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringStateModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE _mode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_MODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _mode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSStateNumberOfSatelliteChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _numberOfSatellite)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_NUMBEROFSATELLITECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _numberOfSatellite
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _numberOfSatellite, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSStateHomeTypeAvailabilityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE _type, uint8_t _available)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPEAVAILABILITYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _available
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _available, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3GPSStateHomeTypeChosenChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPECHOSENCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateARDrone3PROStateFeatures (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint64_t _features)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_ARDRONE3, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_CLASS_PROSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_ARDRONE3_PROSTATE_CMD_FEATURES, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _features
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU64ToBuffer (buffer, _features, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}


// Feature JumpingSumo

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPCMD (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _flag, int8_t _speed, int8_t _turn)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_PCMD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _flag
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _flag, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _turn
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _turn, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPosture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_POSTURE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingAddCapOffset (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _offset)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_ADDCAPOFFSET, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _offset
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _offset, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpStop (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPSTOP, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpCancel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPCANCEL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpLoad (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPLOAD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJump (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMP, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsSimpleAnimation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID _id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_SIMPLEANIMATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPicture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTURE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD _record, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _record
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _record, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPictureV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTUREV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideoV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD _record)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEOV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _record
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _record, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsWifiSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE _type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGS_CMD_WIFISELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiScan (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND _band)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFISCAN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiAuthChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFIAUTHCHANNEL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsMasterVolume (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _volume)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_MASTERVOLUME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _volume
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _volume, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsTheme (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME _theme)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_THEME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _theme
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _theme, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanAllScriptsMetadata (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_ALLSCRIPTSMETADATA, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptUploaded (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid, const char * _md5Hash)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_uuid == NULL) ||
        (_md5Hash == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTUPLOADED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _uuid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _uuid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _md5Hash
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _md5Hash, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptDelete (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_uuid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTDELETE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _uuid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _uuid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanPlayScript (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_uuid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_PLAYSCRIPT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _uuid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _uuid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsOutdoor (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGS_CMD_OUTDOOR, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _outdoor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _outdoor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingVideoEnable (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMING_CMD_VIDEOENABLE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enable
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enable, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsAutorecord (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGS_CMD_AUTORECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStatePostureChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_POSTURECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStateAlertStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_ALERTSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStateSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _speed, int16_t _realSpeed)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_SPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _realSpeed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _realSpeed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpLoadChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPLOADCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpTypeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPTYPECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpMotorProblemChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPMOTORPROBLEMCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoSettingsStateProductGPSVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_software == NULL) ||
        (_hardware == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _software
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _software, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _hardware
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _hardware, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStatePictureStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStateVideoStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStatePictureStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStateVideoStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordEventPictureEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _event
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _event, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordEventVideoEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _event
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _event, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsStateWifiSelectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateWifiScanListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, int16_t _rssi, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFISCANLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rssi
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _rssi, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateAllWifiScanChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFISCANCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateWifiAuthChannelListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _in_or_out
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _in_or_out, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateAllWifiAuthChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateLinkQualityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _quality)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_LINKQUALITYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _quality
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _quality, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsStateMasterVolumeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _volume)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_MASTERVOLUMECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _volume
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _volume, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsStateThemeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME _theme)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_THEMECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _theme
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _theme, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptMetadataListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _uuid, uint8_t _version, const char * _product, const char * _name, uint64_t _lastModified)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_uuid == NULL) ||
        (_product == NULL) ||
        (_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTMETADATALISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _uuid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _uuid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _version
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _version, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _product
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _product, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _lastModified
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU64ToBuffer (buffer, _lastModified, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateAllScriptsMetadataChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_ALLSCRIPTSMETADATACHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptUploadChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE _resultCode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTUPLOADCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _resultCode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _resultCode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptDeleteChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE _resultCode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTDELETECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _resultCode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _resultCode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStatePlayScriptChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE _resultCode)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_PLAYSCRIPTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _resultCode
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _resultCode, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsStateOutdoorChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _outdoor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _outdoor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingStateVideoEnableChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsStateAutorecordChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_JUMPINGSUMO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGSSTATE_CMD_AUTORECORDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}


// Feature MiniDrone

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingFlatTrim (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_FLATTRIM, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingTakeOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_TAKEOFF, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingPCMD (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _flag, int8_t _roll, int8_t _pitch, int8_t _yaw, int8_t _gaz, uint32_t _timestamp)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_PCMD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _flag
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _flag, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _roll
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _roll, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pitch
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _pitch, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _yaw
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _yaw, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _gaz
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _gaz, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _timestamp
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _timestamp, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingLanding (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_LANDING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingEmergency (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_EMERGENCY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingAutoTakeOffMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_AUTOTAKEOFFMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneAnimationsFlip (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION _direction)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_FLIP, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _direction
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _direction, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneAnimationsCap (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int16_t _offset)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_CAP, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _offset
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _offset, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPicture (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTURE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPictureV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORD, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTUREV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxAltitude (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXALTITUDE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxTilt (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXTILT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxVerticalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXVERTICALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxRotationSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXROTATIONSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsWheels (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_WHEELS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _present
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _present, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxHorizontalSpeed (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXHORIZONTALSPEED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsCutOutMode (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SETTINGS_CMD_CUTOUTMODE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enable
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enable, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLatitudeForRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_GPS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLATITUDEFORRUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLongitudeForRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _longitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_GPS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLONGITUDEFORRUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerType (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_type == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_CONFIGURATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERTYPE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerName (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_CONFIGURATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERNAME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateFlatTrimChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLATTRIMCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateFlyingStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLYINGSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateAlertStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_ALERTSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingStateAutoTakeOffModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordStatePictureStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _state, uint8_t _mass_storage_id)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordStatePictureStateChangedV2 (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordEventPictureEventChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _event
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _event, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsStateMaxAltitudeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsStateMaxTiltChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxVerticalSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxRotationSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateWheelsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _present)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_WHEELSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _present
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _present, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxHorizontalSpeedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _current, float _min, float _max)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXHORIZONTALSPEEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _current
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _current, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _min
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _min, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _max
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _max, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateProductMotorsVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _motor, const char * _type, const char * _software, const char * _hardware)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_type == NULL) ||
        (_software == NULL) ||
        (_hardware == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTMOTORSVERSIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _motor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _motor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _software
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _software, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _hardware
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _hardware, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateProductInertialVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_software == NULL) ||
        (_hardware == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTINERTIALVERSIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _software
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _software, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _hardware
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _hardware, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateCutOutModeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_CUTOUTMODECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enable
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enable, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateMiniDroneFloodControlStateFloodControlChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint16_t _delay)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_MINIDRONE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_CLASS_FLOODCONTROLSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_MINIDRONE_FLOODCONTROLSTATE_CMD_FLOODCONTROLCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _delay
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _delay, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}


// Feature SkyController

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiRequestWifiList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTWIFILIST, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiRequestCurrentWifi (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTCURRENTWIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiConnectToWifi (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _bssid, const char * _ssid, const char * _passphrase)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_bssid == NULL) ||
        (_ssid == NULL) ||
        (_passphrase == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_CONNECTTOWIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _bssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _bssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _passphrase
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _passphrase, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiForgetWifi (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_FORGETWIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiWifiAuthChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_WIFIAUTHCHANNEL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceRequestDeviceList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTDEVICELIST, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceRequestCurrentDevice (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTCURRENTDEVICE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceConnectToDevice (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _deviceName)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_deviceName == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_CONNECTTODEVICE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _deviceName
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _deviceName, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsAllSettings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_ALLSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsReset (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_RESET, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCommonAllStates (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_COMMON_CMD_ALLSTATES, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsAccessPointSSID (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTSSID, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsAccessPointChannel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTCHANNEL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsWifiSelection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE _type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_WIFISELECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCameraResetOrientation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CAMERA, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CAMERA_CMD_RESETORIENTATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosGetGamepadControls (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOS_CMD_GETGAMEPADCONTROLS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsGetCurrentButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETCURRENTBUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsGetAvailableButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETAVAILABLEBUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsSetButtonMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _key_id, const char * _mapping_uid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_mapping_uid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_SETBUTTONMAPPING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _key_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _key_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mapping_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _mapping_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsDefaultButtonMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_DEFAULTBUTTONMAPPING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsGetCurrentAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETCURRENTAXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsGetAvailableAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETAVAILABLEAXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsSetAxisMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _mapping_uid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_mapping_uid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_SETAXISMAPPING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _axis_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _axis_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mapping_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _mapping_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsDefaultAxisMapping (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_DEFAULTAXISMAPPING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersGetCurrentAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETCURRENTAXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersGetPresetAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETPRESETAXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersSetAxisFilter (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _filter_uid_or_builder)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_filter_uid_or_builder == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_SETAXISFILTER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _axis_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _axis_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _filter_uid_or_builder
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _filter_uid_or_builder, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersDefaultAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_DEFAULTAXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCoPilotingSetPilotingSource (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE _source)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_COPILOTING_CMD_SETPILOTINGSOURCE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _source
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _source, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdates (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enable)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATION_CMD_ENABLEMAGNETOCALIBRATIONQUALITYUPDATES, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enable
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enable, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _bssid, const char * _ssid, uint8_t _secured, uint8_t _saved, int32_t _rssi, int32_t _frequency)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_bssid == NULL) ||
        (_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFILIST, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _bssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _bssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _secured
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _secured, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _saved
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _saved, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rssi
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _rssi, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _frequency
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _frequency, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateConnexionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid, eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS _status)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_CONNEXIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _status
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _status, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiAuthChannelListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFIAUTHCHANNELLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _in_or_out
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _in_or_out, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateAllWifiAuthChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_ALLWIFIAUTHCHANNELCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiSignalChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _level)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFISIGNALCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _level
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _level, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceStateDeviceList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICESTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_DEVICELIST, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerDeviceStateConnexionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS _status, const char * _deviceName, uint16_t _deviceProductID)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_deviceName == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICESTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_CONNEXIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _status
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _status, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _deviceName
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _deviceName, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _deviceProductID
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _deviceProductID, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateAllSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateResetChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_RESETCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateProductSerialChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _serialNumber)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_serialNumber == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTSERIALCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _serialNumber
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _serialNumber, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateProductVariantChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT _variant)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTVARIANTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _variant
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _variant, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCommonStateAllStatesChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_COMMONSTATE_CMD_ALLSTATESCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateBatteryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _percent)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_BATTERYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _percent
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _percent, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateGpsFixChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _fixed)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSFIXCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _fixed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _fixed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateGpsPositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, double _altitude, float _heading)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSPOSITIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _heading
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _heading, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateAccessPointSSIDChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _ssid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_ssid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTSSIDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ssid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _ssid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateAccessPointChannelChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTCHANNELCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateWifiSelectionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_WIFISELECTIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _band
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _band, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _channel
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _channel, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosStateGamepadControl (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE _type, int32_t _id, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_GAMEPADCONTROL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosStateAllGamepadControlsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_ALLGAMEPADCONTROLSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateCurrentButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _key_id, const char * _mapping_uid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_mapping_uid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_CURRENTBUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _key_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _key_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mapping_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _mapping_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAllCurrentButtonMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLCURRENTBUTTONMAPPINGSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAvailableButtonMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _mapping_uid, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_mapping_uid == NULL) ||
        (_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_AVAILABLEBUTTONMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mapping_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _mapping_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLAVAILABLEBUTTONSMAPPINGSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateCurrentAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _mapping_uid)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_mapping_uid == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_CURRENTAXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _axis_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _axis_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mapping_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _mapping_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAllCurrentAxisMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLCURRENTAXISMAPPINGSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAvailableAxisMappings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _mapping_uid, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_mapping_uid == NULL) ||
        (_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_AVAILABLEAXISMAPPINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mapping_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _mapping_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAllAvailableAxisMappingsSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLAVAILABLEAXISMAPPINGSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateCurrentAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int32_t _axis_id, const char * _filter_uid_or_builder)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_filter_uid_or_builder == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_CURRENTAXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _axis_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _axis_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _filter_uid_or_builder
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _filter_uid_or_builder, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateAllCurrentFiltersSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLCURRENTFILTERSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStatePresetAxisFilters (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _filter_uid, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_filter_uid == NULL) ||
        (_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_PRESETAXISFILTERS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _filter_uid
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _filter_uid, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateAllPresetFiltersSent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLPRESETFILTERSSENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCoPilotingStatePilotingSource (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE _source)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTINGSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_COPILOTINGSTATE_CMD_PILOTINGSOURCE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _source
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _source, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCalibrationStateMagnetoCalibrationState (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS _status, uint8_t _X_Quality, uint8_t _Y_Quality, uint8_t _Z_Quality)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _status
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _status, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _X_Quality
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _X_Quality, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _Y_Quality
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _Y_Quality, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _Z_Quality
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _Z_Quality, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesState (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONQUALITYUPDATESSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateSkyControllerButtonEventsSettings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_SKYCONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONEVENTS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_SKYCONTROLLER_BUTTONEVENTS_CMD_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}


// Feature unknown_feature_1

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1GeographicRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _elevation_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _elevation, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _azimuth_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _azimuth, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1RelativeRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _elevation_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _elevation, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _azimuth_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _azimuth, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1LookAtRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LOOK_AT_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SpiralAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _revolution_nb_is_default, float _revolution_number, uint8_t _vertical_distance_is_default, float _vertical_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _revolution_nb_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _revolution_nb_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _revolution_number
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _revolution_number, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SwingAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1BoomerangAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _distance_is_default, float _distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1CandleAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1DollySlideAnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _start, uint8_t _speed_is_default, float _speed, uint8_t _angle_is_default, float _angle, uint8_t _horizontal_distance_is_default, float _horizontal_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _start
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _start, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _angle_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _angle_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _angle
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _angle, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _horizontal_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _horizontal_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserFramingPosition (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _horizontal, int8_t _vertical)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _horizontal, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserGPSData (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude, float _altitude, float _horizontal_accuracy, float _vertical_accuracy, float _north_speed, float _east_speed, float _down_speed, double _timestamp)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_GPS_DATA, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _altitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _altitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal_accuracy
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _horizontal_accuracy, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_accuracy
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_accuracy, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _north_speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _north_speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _east_speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _east_speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _down_speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _down_speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _timestamp
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _timestamp, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserBaroData (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _pressure, double _timestamp)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_BARO_DATA, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _pressure
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _pressure, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _timestamp
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _timestamp, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1LynxDetection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _target_pan, float _target_tilt, float _change_of_scale, uint8_t _confidence_index, uint8_t _is_new_selection, uint64_t _timestamp)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LYNX_DETECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _target_pan
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _target_pan, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _target_tilt
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _target_tilt, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _change_of_scale
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _change_of_scale, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _confidence_index
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _confidence_index, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _is_new_selection
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _is_new_selection, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _timestamp
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU64ToBuffer (buffer, _timestamp, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1Availability (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_AVAILABILITY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1Run (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1GeographicConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _elevation_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _elevation, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _azimuth_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _azimuth, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1RelativeConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _distance_is_default, float _distance, uint8_t _elevation_is_default, float _elevation, uint8_t _azimuth_is_default, float _azimuth)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _elevation_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _elevation
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _elevation, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _azimuth_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _azimuth
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _azimuth, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1AnimRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_ANIM_RUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SpiralAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _revolution_nb_is_default, float _revolution_nb, uint8_t _vertical_distance_is_default, float _vertical_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _revolution_nb_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _revolution_nb_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _revolution_nb
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _revolution_nb, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1SwingAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1BoomerangAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _distance_is_default, float _distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1CandleAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _vertical_distance_is_default, float _vertical_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _vertical_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1DollySlideAnimConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _speed_is_default, float _speed, uint8_t _angle_is_default, float _angle, uint8_t _horizontal_distance_is_default, float _horizontal_distance)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_CONFIG_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _speed_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _speed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _speed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _angle_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _angle_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _angle
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _angle, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal_distance_is_default
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _horizontal_distance_is_default, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal_distance
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _horizontal_distance, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateUnknownFeature1UserFramingPositionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int8_t _horizontal, int8_t _vertical)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_CLASS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION_CHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _horizontal
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _horizontal, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _vertical
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _vertical, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}


// Feature common

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonNetworkDisconnect (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_NETWORK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_NETWORK_CMD_DISCONNECT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsAllSettings (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGS_CMD_ALLSETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsReset (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGS_CMD_RESET, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsProductName (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGS_CMD_PRODUCTNAME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsCountry (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _code)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_code == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGS_CMD_COUNTRY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _code
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _code, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsAutoCountry (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _automatic)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGS_CMD_AUTOCOUNTRY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _automatic
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _automatic, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonAllStates (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMON_CMD_ALLSTATES, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonCurrentDate (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _date)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_date == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTDATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _date
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _date, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonCurrentTime (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _time)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_time == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTTIME, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _time
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _time, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonReboot (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMON_CMD_REBOOT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatSwitchOff (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_OVERHEAT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_SWITCHOFF, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatVentilate (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_OVERHEAT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_VENTILATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonControllerIsPiloting (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _piloting)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CONTROLLER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CONTROLLER_CMD_ISPILOTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _piloting
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _piloting, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonWifiSettingsOutdoorSetting (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_WIFISETTINGS_CMD_OUTDOORSETTING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _outdoor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _outdoor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStart (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _filepath, eARCOMMANDS_COMMON_MAVLINK_START_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_filepath == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_MAVLINK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_MAVLINK_CMD_START, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _filepath
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _filepath, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkPause (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_MAVLINK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_MAVLINK_CMD_PAUSE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStop (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_MAVLINK, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_MAVLINK_CMD_STOP, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationMagnetoCalibration (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _calibrate)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CALIBRATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CALIBRATION_CMD_MAGNETOCALIBRATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _calibrate
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _calibrate, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonGPSControllerPositionForRun (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, double _latitude, double _longitude)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_GPS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_GPS_CMD_CONTROLLERPOSITIONFORRUN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _latitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _latitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _longitude
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddDoubleToBuffer (buffer, _longitude, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAudioControllerReadyForStreaming (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _ready)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_AUDIO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_AUDIO_CMD_CONTROLLERREADYFORSTREAMING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _ready
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _ready, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonHeadlightsIntensity (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _left, uint8_t _right)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_HEADLIGHTS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_HEADLIGHTS_CMD_INTENSITY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _left
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _left, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _right
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _right, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStartAnimation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM _anim)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STARTANIMATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _anim
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _anim, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStopAnimation (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM _anim)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STOPANIMATION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _anim
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _anim, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStopAllAnimations (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STOPALLANIMATIONS, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryConfig (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY _accessory)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ACCESSORY, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ACCESSORY_CMD_CONFIG, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _accessory
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _accessory, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerSetMaxChargeRate (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE _rate)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CHARGER, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CHARGER_CMD_SETMAXCHARGERATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rate
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _rate, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonNetworkEventDisconnection (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE _cause)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_NETWORKEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_NETWORKEVENT_CMD_DISCONNECTION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _cause
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _cause, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateAllSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateResetChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_RESETCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductNameChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTNAMECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductVersionChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _software, const char * _hardware)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_software == NULL) ||
        (_hardware == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTVERSIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _software
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _software, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _hardware
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _hardware, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductSerialHighChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _high)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_high == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALHIGHCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _high
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _high, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateProductSerialLowChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _low)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_low == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALLOWCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _low
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _low, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateCountryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _code)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_code == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_COUNTRYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _code
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _code, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonSettingsStateAutoCountryChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _automatic)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_AUTOCOUNTRYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _automatic
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _automatic, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateAllStatesChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_ALLSTATESCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateBatteryStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _percent)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_BATTERYSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _percent
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _percent, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id, const char * _name)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_name == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGESTATELISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _name
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _name, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageInfoStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _mass_storage_id, uint32_t _size, uint32_t _used_size, uint8_t _plugged, uint8_t _full, uint8_t _internal)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOSTATELISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _mass_storage_id
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _mass_storage_id, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _size
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _size, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _used_size
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _used_size, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _plugged
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _plugged, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _full
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _full, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _internal
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _internal, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateCurrentDateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _date)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_date == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTDATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _date
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _date, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateCurrentTimeChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _time)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_time == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTTIMECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _time
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _time, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageInfoRemainingListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint32_t _free_space, uint16_t _rec_time, uint32_t _photo_remaining)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOREMAININGLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _free_space
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _free_space, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rec_time
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _rec_time, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _photo_remaining
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _photo_remaining, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateWifiSignalChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, int16_t _rssi)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_WIFISIGNALCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rssi
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, _rssi, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateSensorsStatesListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME _sensorName, uint8_t _sensorState)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_SENSORSSTATESLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _sensorName
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _sensorName, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _sensorState
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _sensorState, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateProductModel (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL _model)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_PRODUCTMODEL, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _model
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _model, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCommonStateCountryListKnown (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _listFlags, const char * _countryCodes)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_countryCodes == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_COUNTRYLISTKNOWN, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _listFlags
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _listFlags, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _countryCodes
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _countryCodes, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatStateOverHeatChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_OVERHEATSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonOverHeatStateOverHeatRegulationChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _regulationType)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_OVERHEATSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATREGULATIONCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _regulationType
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _regulationType, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonWifiSettingsStateOutdoorSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _outdoor)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_WIFISETTINGSSTATE_CMD_OUTDOORSETTINGSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _outdoor
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _outdoor, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStateMavlinkFilePlayingStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE _state, const char * _filepath, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE _type)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_filepath == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_MAVLINKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_MAVLINKSTATE_CMD_MAVLINKFILEPLAYINGSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _filepath
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _filepath, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _type
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _type, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonMavlinkStateMavlinkPlayErrorStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_MAVLINKSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_MAVLINKSTATE_CMD_MAVLINKPLAYERRORSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _xAxisCalibration, uint8_t _yAxisCalibration, uint8_t _zAxisCalibration, uint8_t _calibrationFailed)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _xAxisCalibration
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _xAxisCalibration, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _yAxisCalibration
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _yAxisCalibration, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _zAxisCalibration
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _zAxisCalibration, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _calibrationFailed
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _calibrationFailed, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationRequiredState (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _required)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONREQUIREDSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _required
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _required, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS _axis)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _axis
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _axis, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationStartedChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _started)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CALIBRATIONSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTARTEDCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _started
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _started, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonCameraSettingsStateCameraSettingsChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, float _fov, float _panMax, float _panMin, float _tiltMax, float _tiltMin)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CAMERASETTINGSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CAMERASETTINGSSTATE_CMD_CAMERASETTINGSCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _fov
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _fov, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _panMax
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _panMax, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _panMin
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _panMin, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _tiltMax
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _tiltMax, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _tiltMin
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddFloatToBuffer (buffer, _tiltMin, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanStateAvailabilityStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _AvailabilityState)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_FLIGHTPLANSTATE_CMD_AVAILABILITYSTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _AvailabilityState
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _AvailabilityState, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanStateComponentStateListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT _component, uint8_t _State)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_FLIGHTPLANSTATE_CMD_COMPONENTSTATELISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _component
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _component, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _State
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _State, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanEventStartingErrorEvent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_FLIGHTPLANEVENT_CMD_STARTINGERROREVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonFlightPlanEventSpeedBridleEvent (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_FLIGHTPLANEVENT_CMD_SPEEDBRIDLEEVENT, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateControllerLibARCommandsVersion (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_version == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ARLIBSVERSIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_CONTROLLERLIBARCOMMANDSVERSION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _version
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _version, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateSkyControllerLibARCommandsVersion (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_version == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ARLIBSVERSIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_SKYCONTROLLERLIBARCOMMANDSVERSION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _version
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _version, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateDeviceLibARCommandsVersion (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _version)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_version == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ARLIBSVERSIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_DEVICELIBARCOMMANDSVERSION, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _version
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddStringToBuffer (buffer, _version, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAudioStateAudioStreamingRunning (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _running)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_AUDIOSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_AUDIOSTATE_CMD_AUDIOSTREAMINGRUNNING, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _running
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _running, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonHeadlightsStateIntensityChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _left, uint8_t _right)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_HEADLIGHTSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_HEADLIGHTSSTATE_CMD_INTENSITYCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _left
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _left, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _right
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _right, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAnimationsStateList (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM _anim, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE _state, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONSSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ANIMATIONSSTATE_CMD_LIST, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _anim
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _anim, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _state
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _state, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryStateSupportedAccessoriesListChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY _accessory)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ACCESSORYSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_SUPPORTEDACCESSORIESLISTCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _accessory
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _accessory, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryStateAccessoryConfigChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY _newAccessory, eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR _error)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ACCESSORYSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_ACCESSORYCONFIGCHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _newAccessory
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _newAccessory, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _error
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _error, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonAccessoryStateAccessoryConfigModificationEnabled (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, uint8_t _enabled)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_ACCESSORYSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_ACCESSORYCONFIGMODIFICATIONENABLED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _enabled
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _enabled, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateMaxChargeRateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE _rate)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CHARGERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_MAXCHARGERATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rate
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _rate, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateCurrentChargeStateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS _status, eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE _phase)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CHARGERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_CURRENTCHARGESTATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _status
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _status, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _phase
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _phase, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateLastChargeRateChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE _rate)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CHARGERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_LASTCHARGERATECHANGED, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rate
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _rate, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonChargerStateChargingInfo (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE _phase, eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE _rate, uint8_t _intensity, uint8_t _fullChargingTime)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CLASS_CHARGERSTATE, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write id header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU16ToBuffer (buffer, ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_CHARGINGINFO, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _phase
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _phase, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _rate
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, _rate, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _intensity
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _intensity, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write arg _fullChargingTime
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, _fullChargingTime, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        *cmdLen = currIndexInBuffer;
    } // No else --> Do not set cmdLen if an error occured
    return retVal;
}

eARCOMMANDS_GENERATOR_ERROR ARCOMMANDS_Generator_GenerateCommonRunStateRunIdChanged (uint8_t *buffer, int32_t buffLen, int32_t *cmdLen, const char * _runId)
{
    int32_t currIndexInBuffer = 0;
    eARCOMMANDS_GENERATOR_ERROR retVal = ARCOMMANDS_GENERATOR_OK;
    if ((buffer == NULL) ||
        (cmdLen == NULL))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check
    // Test all String args (if any)
    if ((_runId == NULL) ||
       (0))
    {
        return ARCOMMANDS_GENERATOR_ERROR_BAD_ARGS;
    } // No else --> Args Check

    // Write feature header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuffer (buffer, ARCOMMANDS_ID_FEATURE_COMMON, currIndexInBuffer, buffLen);
        if (currIndexInBuffer == -1)
        {
            retVal = ARCOMMANDS_GENERATOR_ERROR_NOT_ENOUGH_SPACE;
        } // No else --> Do not modify retVal if no issue was found
    } // No else --> Processing block
    // Write class header
    if (retVal == ARCOMMANDS_GENERATOR_OK)
    {
        currIndexInBuffer = ARCOMMANDS_ReadWrite_AddU8ToBuf