/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/********************************************
 *            AUTOGENERATED FILE            *
 *             DO NOT MODIFY IT             *
 *                                          *
 * To add new commands :                    *
 *  - Modify ../Xml/commands.xml file       *
 *  - Re-run generateCommandsList.py script *
 *                                          *
 ********************************************/
#include <config.h>
#include <stdio.h>
#include "ARCOMMANDS_ReadWrite.h"
#include <libARSAL/ARSAL_Endianness.h>

// ------- //
// WRITERS //
// ------- //

// Add an 8 bit value to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddU8ToBuffer (uint8_t *buffer, uint8_t newVal, int32_t oldOffset, int32_t buffCap)
{
    int32_t retVal = 0;
    int32_t size = oldOffset + sizeof(newVal);

    if (buffCap < size)
    {
        retVal = -1;
    }
    else
    {
        uint8_t *buffptr = &(buffer [oldOffset]);
        uint8_t localVal = newVal;
        memcpy (buffptr, &localVal, sizeof (localVal));
        retVal = oldOffset + sizeof (localVal);
    }
    return retVal;
}

// Add a 16 bit value to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddU16ToBuffer (uint8_t *buffer, uint16_t newVal, int32_t oldOffset, int32_t buffCap)
{
    int32_t retVal = 0;
    int32_t size = oldOffset + sizeof(newVal);

    if (buffCap < size)
    {
        retVal = -1;
    }
    else
    {
        uint16_t *buffptr = (uint16_t *)& (buffer [oldOffset]);
        uint16_t localVal = htods (newVal);
        memcpy (buffptr, &localVal, sizeof (localVal));
        retVal = oldOffset + sizeof (localVal);
    }
    return retVal;
}

// Add a 32 bit value to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddU32ToBuffer (uint8_t *buffer, uint32_t newVal, int32_t oldOffset, int32_t buffCap)
{
    int32_t retVal = 0;
    int32_t size = oldOffset + sizeof(newVal);

    if (buffCap < size)
    {
        retVal = -1;
    }
    else
    {
        uint32_t *buffptr = (uint32_t *)& (buffer [oldOffset]);
        uint32_t localVal = htodl (newVal);
        memcpy (buffptr, &localVal, sizeof (localVal));
        retVal = oldOffset + sizeof (localVal);
    }
    return retVal;
}

// Add a 64 bit value to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddU64ToBuffer (uint8_t *buffer, uint64_t newVal, int32_t oldOffset, int32_t buffCap)
{
    int32_t retVal = 0;
    int32_t size = oldOffset + sizeof(newVal);

    if (buffCap < size)
    {
        retVal = -1;
    }
    else
    {
        uint64_t *buffptr = (uint64_t *)& (buffer [oldOffset]);
        uint64_t localVal = htodll (newVal);
        memcpy (buffptr, &localVal, sizeof (localVal));
        retVal = oldOffset + sizeof (localVal);
    }
    return retVal;
}

// Add a NULL Terminated String to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddStringToBuffer (uint8_t *buffer, const char *newVal, int32_t oldOffset, int32_t buffCap)
{
    int32_t retVal = 0;
    int32_t size = oldOffset + sizeof(newVal);

    if (buffCap < size)
    {
        retVal = -1;
    }
    else
    {
        char *buffptr = (char *)& (buffer [oldOffset]);
        strcpy (buffptr, newVal);
        retVal = oldOffset + strlen (newVal) + 1;
    }
    return retVal;
}

// Add a float to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddFloatToBuffer (uint8_t *buffer, float newVal, int32_t oldOffset, int32_t buffCap)
{
    union {
        float f;
        uint32_t u32;
    } val = { .f = newVal };
    return ARCOMMANDS_ReadWrite_AddU32ToBuffer (buffer, val.u32, oldOffset, buffCap);
}

// Add a double to the buffer
// Returns -1 if the buffer is not big enough
// Returns the new offset in the buffer on success
int32_t ARCOMMANDS_ReadWrite_AddDoubleToBuffer (uint8_t *buffer, double newVal, int32_t oldOffset, int32_t buffCap)
{
    union {
        double d;
        uint64_t u64;
    } val = { .d = newVal };
    return ARCOMMANDS_ReadWrite_AddU64ToBuffer (buffer, val.u64, oldOffset, buffCap);
}

// ------- //
// READERS //
// ------- //

// Read an 8 bit value from the buffer
// On error, return zero and set *error to 1, else set *error to 0
uint8_t ARCOMMANDS_ReadWrite_Read8FromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    uint8_t retVal = 0;
    int newOffset = *offset + sizeof (uint8_t);
    if (newOffset > capacity)
    {
        *error = 1;
    }
    else
    {
        retVal = buffer [*offset];
        *offset = newOffset;
        *error = 0;
    }
    return retVal;
}

// Read a 16 bit value from the buffer
// On error, return zero and set *error to 1, else set *error to 0
uint16_t ARCOMMANDS_ReadWrite_Read16FromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    uint16_t retVal = 0;
    uint8_t *buffAddr = &buffer[*offset];
    int newOffset = *offset + sizeof (uint16_t);
    if (newOffset > capacity)
    {
        *error = 1;
    }
    else
    {
        memcpy (&retVal, buffAddr, sizeof (uint16_t));
        retVal = dtohs (retVal);
        *offset = newOffset;
        *error = 0;
    }
    return retVal;
}

// Read a 32 bit value from the buffer
// On error, return zero and set *error to 1, else set *error to 0
uint32_t ARCOMMANDS_ReadWrite_Read32FromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    uint32_t retVal = 0;
    uint8_t *buffAddr = &buffer[*offset];
    int newOffset = *offset + sizeof (uint32_t);
    if (newOffset > capacity)
    {
        *error = 1;
    }
    else
    {
        memcpy (&retVal, buffAddr, sizeof (uint32_t));
        retVal = dtohl (retVal);
        *offset = newOffset;
        *error = 0;
    }
    return retVal;
}

// Read a 64 bit value from the buffer
// On error, return zero and set *error to 1, else set *error to 0
uint64_t ARCOMMANDS_ReadWrite_Read64FromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    uint64_t retVal = 0;
    uint8_t *buffAddr = &buffer[*offset];
    int newOffset = *offset + sizeof (uint64_t);
    if (newOffset > capacity)
    {
        *error = 1;
    }
    else
    {
        memcpy (&retVal, buffAddr, sizeof (uint64_t));
        retVal = dtohll (retVal);
        *offset = newOffset;
        *error = 0;
    }
    return retVal;
}

// Read a float value from the buffer
// On error, return zero and set *error to 1, else set *error to 0
float ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    float retVal = 0;
    uint8_t *buffAddr = &buffer[*offset];
    int newOffset = *offset + sizeof (float);
    if (newOffset > capacity)
    {
        *error = 1;
    }
    else
    {
        memcpy (&retVal, buffAddr, sizeof (float));
        retVal = dtohf (retVal);
        *offset = newOffset;
        *error = 0;
    }
    return retVal;
}

// Read a double value from the buffer
// On error, return zero and set *error to 1, else set *error to 0
double ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    double retVal = 0;
    uint8_t *buffAddr = &buffer[*offset];
    int newOffset = *offset + sizeof (double);
    if (newOffset > capacity)
    {
        *error = 1;
    }
    else
    {
        memcpy (&retVal, buffAddr, sizeof (double));
        retVal = dtohd (retVal);
        *offset = newOffset;
        *error = 0;
    }
    return retVal;
}

// Read a string value from the buffer
// On error, return NULL and set *error to 1, else set *error to 0
char* ARCOMMANDS_ReadWrite_ReadStringFromBuffer (uint8_t *buffer, int32_t capacity, int32_t *offset, int32_t *error)
{
    // We don't check args because this function is only called by autogenerated code
    char *retVal = NULL;
    char *buffAddr = (char *)&buffer[*offset];
    int newOffset = *offset;
    while ((newOffset < capacity) && ('\0' != (char) buffer [newOffset]))
    {
        newOffset += sizeof (char);
    }
    if (newOffset >= capacity)
    {
        *error = 1;
    }
    else
    {
        retVal = buffAddr;
        *offset = newOffset + 1;
        *error = 0;
    }
    return retVal;
}

// -------- //
// TOSTRING //
// -------- //

// Write a string in a buffer
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_WriteString (const char *stringToWrite, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int retVal = -1;
    int capacity = outputLen - outputOffset - 1;
    int len = strlen (stringToWrite);
    if (capacity >= len)
    {
        strncat (output, stringToWrite, len);
        retVal = outputOffset + len;
    } // No else --> If capacity is not enough, keep retVal to -1
    return retVal;
}

// Write a string in a buffer from an uint8_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintU8 (const char *name, uint8_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = -1;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRIU8
        len = snprintf (& output [offset], capacity, "%" PRIu8, arg);
#else
        len = snprintf (& output [offset], capacity, "%u", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from an int8_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintI8 (const char *name, int8_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = -1;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRII8
        len = snprintf (& output [offset], capacity, "%" PRIi8, arg);
#else
        len = snprintf (& output [offset], capacity, "%d", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from an uint16_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintU16 (const char *name, uint16_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = -1;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRIU16
        len = snprintf (& output [offset], capacity, "%" PRIu16, arg);
#else
        len = snprintf (& output [offset], capacity, "%u", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from an int16_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintI16 (const char *name, int16_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = offset;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRII16
        len = snprintf (& output [offset], capacity, "%" PRIi16, arg);
#else
        len = snprintf (& output [offset], capacity, "%d", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from an uint32_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintU32 (const char *name, uint32_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = offset;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRIU32
        len = snprintf (& output [offset], capacity, "%" PRIu32, arg);
#else
        len = snprintf (& output [offset], capacity, "%u", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from an int32_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintI32 (const char *name, int32_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = offset;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRII32
        len = snprintf (& output [offset], capacity, "%" PRIi32, arg);
#else
        len = snprintf (& output [offset], capacity, "%d", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from an uint64_t arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintU64 (const char *name, uint64_t arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = offset;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
#if HAVE_DECL_PRIU64
        len = snprintf (& output [offset], capacity, "%" PRIu64, arg);
#else
        len = snprintf (& output [offset], capacity, "%llu", arg);
#endif
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from float arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintFloat (const char *name, float arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = offset;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
        len = snprintf (& output [offset], capacity, "%f", arg);
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from a double arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintDouble (const char *name, double arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int capacity, len;
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    int retVal = offset;
    if (offset >= 0)
    {
        capacity = outputLen - offset - 1;
        len = snprintf (& output [offset], capacity, "%f", arg);
        if (len >= capacity)
        {
            retVal = -1;
        }
        else
        {
            retVal = offset + len;
        }
    } // No else --> Do nothing if the previous WriteString failed
    return retVal;
}

// Write a string in a buffer from a string arg
// On error, return -1, else return offset in string
int ARCOMMANDS_ReadWrite_PrintString (const char *name, char *arg, char *output, int outputLen, int outputOffset)
{
    // We don't check args because this function is only called by autogenerated code
    int offset = ARCOMMANDS_ReadWrite_WriteString (name, output, outputLen, outputOffset);
    if (offset >= 0)
    {
        offset = ARCOMMANDS_ReadWrite_WriteString (arg, output, outputLen, offset);
    } // No else --> Do nothing if the previous WriteString failed
    return offset;
}

