;;
;; DO NOT EDIT THIS FILE
;;
;; this file is automatically generated from /tmp/pr2_21717.dae on (Linux pr1012 3.4.28.rt40-1-pr2-rt x86_64) at Mon Jul 27 05:59:22 2015

;;
;; /home/furushchev/ros/hydro/src/jsk-ros-pkg/jsk_pr2eus/pr2eus $ /home/furushchev/ros/hydro/devel/lib/euscollada/collada2eus /tmp/pr2_21717.dae /home/furushchev/ros/hydro/src/jsk-ros-pkg/jsk_model_tools/euscollada//pr2.yaml /tmp/pr2_21717.l 
;;

;; copy euscollada-robot class definition from euscollada/src/euscollada-robot.l
;;
(defclass euscollada-robot
;; This euscollada-robot class is for robots converted from collada files.
;; This class provides :init-ending override.
  :super robot-model
  :slots ()
  )
(defmethod euscollada-robot
  (:init-ending
   ()
   ;; fix all links' mass properties ;; root link relative (collada) -> link local (euslisp)
   (dolist (l links)
     (setq (l . acentroid) (send l :inverse-transform-vector
                                 (send (send (car links) :worldcoords) :transform-vector
                                       (l . acentroid))))
     (setq (l . inertia-tensor) (m* (transpose (send l :worldrot))
                                    (m* (send (car links) :worldrot)
                                        (l . inertia-tensor))))
     )
   (send-super :init-ending)
   (send self :make-collision-model-for-links)

   ;;
   (dolist (j (mapcan #'(lambda (x) (if (and (derivedp (cdr x) joint)
					     (not (memq (cdr x) (send self :joint-list))))
					(list (cdr x)))) (send self :slots)))
     (send (send j :child-link) :add-joint j)
     (send (send j :child-link) :add-parent-link (send j :parent-link))
     (send (send j :parent-link) :add-child-links (send j :child-link)))
   )
  (:change-visual
   (&optional (visual :convex))
   (dolist (lk (send self :links))
     (dolist (bd (send lk :bodies))
       (when (derivedp bd collada-body)
         (send bd :change-visual visual)))))
  ;; fullbody-inverse-kinematics overwrite
  ;;  reduce root-link's weight based on leg's joint limit
  ;;  increase stop and cog-gain
  (:fullbody-inverse-kinematics
   (target-coords &rest args &key (stop 250) (cog-gain 2.0) (additional-weight-list) &allow-other-keys)
   (let* ((leg-ul (send self :calc-union-link-list (send self :legs :links))))
     (send self :reset-joint-angle-limit-weight-old leg-ul)
     (send-message* self robot-model :fullbody-inverse-kinematics
                    target-coords
                    :stop stop :cog-gain cog-gain
                    :additional-weight-list
                    (append
                     additional-weight-list
                     (list
                      (list (car (send self :links))
                            #'(lambda ()
                                ;; set root-link 6dof-joint's weight based on legs' joint limit
                                (let* ((min-weight
                                        (reduce #'(lambda (x y) (min x y))
                                                (coerce (send self :calc-inverse-kinematics-weight-from-link-list
                                                              leg-ul :union-link-list leg-ul) cons))))
                                  (fill (instantiate float-vector 6) min-weight)))
                            )
                      ))
                    args)
     ))
  ;; make collision model from faces or gl-vertices
  (:make-collision-model-for-links
   (&key (fat 0) (collision-func 'pqp-collision-check) ((:links ls) (send self :links)))
   (dolist (ll ls)
     (send ll
           (read-from-string
            (format nil ":make-~Amodel"
                    (string-right-trim "-COLLISION-CHECK" (string collision-func))))
           :fat fat
           :faces (flatten (mapcar #'(lambda (x)
                                       (cond
                                        ((find-method x :def-gl-vertices)
                                         (send (x . glvertices) :convert-to-faces :wrt :world))
                                        (t
                                         (send x :faces))))
                                   (send ll :bodies)))))
   )
  )

;; copy euscollada-body class definition from euscollada/src/euscollada-robot.l
(defclass collada-body
  :super body
  :slots (glvertices)
  )
(defmethod collada-body
  (:draw (vwr)
   (when glvertices
     (send glvertices :draw vwr)))
  (:set-color (&rest args)
   (send-super* :set-color args)
   (when glvertices (send* glvertices :set-color args)))
  (:change-visual
   (&optional (visual :convex))
   (case visual
     ((list :convex :hull :convex-hull)
      (unless (send self :get :original-mesh)
        (send self :put :original-mesh glvertices)) ;; store original mesh
      (let* ((org-mesh (send self :get :original-mesh))
             (org-cds (send org-mesh :copy-worldcoords))
             (glv (gl::make-glvertices-from-faces (send self :faces))))
        (send glv :set-offset (send org-cds :inverse-transformation))
        (send glv :transform org-cds)
        (send org-mesh :assoc glv)
        (setq glvertices glv)
        glv))
     ((list :original :mesh :glvertices :original-mesh)
      (let ((org-mesh (send self :get :original-mesh)))
        (when org-mesh
          (dolist (d (send org-mesh :descendants)) ;; dissoc all discendants
            (send org-mesh :dissoc d))
          (setq glvertices org-mesh)
          org-mesh)))
     ))
  )
;;
#|
;; overdriven by pr2-sensor-robot, which is defined below of this code.
;; (auto generated from make-pr2-model-file.l)
(defun pr2 () (setq *pr2* (instance pr2-robot :init)))
|#

(defclass pr2-robot
  :super euscollada-robot
  :slots (base_bellow_joint_jt base_footprint_joint_jt base_laser_joint_jt bl_caster_l_wheel_joint_jt bl_caster_r_wheel_joint_jt bl_caster_rotation_joint_jt br_caster_l_wheel_joint_jt br_caster_r_wheel_joint_jt br_caster_rotation_joint_jt double_stereo_frame_joint_jt fl_caster_l_wheel_joint_jt fl_caster_r_wheel_joint_jt fl_caster_rotation_joint_jt fr_caster_l_wheel_joint_jt fr_caster_r_wheel_joint_jt fr_caster_rotation_joint_jt head_chain_cb_jt head_mount_joint_jt head_mount_kinect_ir_joint_jt head_mount_kinect_ir_optical_frame_joint_jt head_mount_kinect_rgb_joint_jt head_mount_kinect_rgb_optical_frame_joint_jt head_mount_prosilica_joint_jt head_mount_prosilica_optical_frame_joint_jt head_pan_joint_jt head_plate_frame_joint_jt head_tilt_joint_jt high_def_frame_joint_jt high_def_optical_frame_joint_jt imu_joint_jt l_elbow_flex_joint_jt l_forearm_cam_frame_joint_jt l_forearm_cam_optical_frame_joint_jt l_forearm_joint_jt l_forearm_roll_joint_jt l_gripper_joint_jt l_gripper_l_finger_joint_jt l_gripper_l_finger_tip_joint_jt l_gripper_led_joint_jt l_gripper_motor_accelerometer_joint_jt l_gripper_motor_screw_joint_jt l_gripper_motor_slider_joint_jt l_gripper_palm_joint_jt l_gripper_r_finger_joint_jt l_gripper_r_finger_tip_joint_jt l_gripper_tool_joint_jt l_shoulder_lift_joint_jt l_shoulder_pan_joint_jt l_torso_lift_side_plate_joint_jt l_upper_arm_joint_jt l_upper_arm_roll_joint_jt l_wrist_flex_joint_jt l_wrist_roll_joint_jt laser_tilt_joint_jt laser_tilt_mount_joint_jt left_arm_chain_cb_jt narrow_stereo_frame_joint_jt narrow_stereo_l_stereo_camera_frame_joint_jt narrow_stereo_l_stereo_camera_optical_frame_joint_jt narrow_stereo_optical_frame_joint_jt narrow_stereo_r_stereo_camera_frame_joint_jt narrow_stereo_r_stereo_camera_optical_frame_joint_jt projector_wg6802418_child_frame_joint_jt projector_wg6802418_frame_joint_jt r_elbow_flex_joint_jt r_forearm_cam_frame_joint_jt r_forearm_cam_optical_frame_joint_jt r_forearm_joint_jt r_forearm_roll_joint_jt r_gripper_joint_jt r_gripper_l_finger_joint_jt r_gripper_l_finger_tip_joint_jt r_gripper_led_joint_jt r_gripper_motor_accelerometer_joint_jt r_gripper_motor_screw_joint_jt r_gripper_motor_slider_joint_jt r_gripper_palm_joint_jt r_gripper_r_finger_joint_jt r_gripper_r_finger_tip_joint_jt r_gripper_tool_joint_jt r_shoulder_lift_joint_jt r_shoulder_pan_joint_jt r_torso_lift_side_plate_joint_jt r_upper_arm_joint_jt r_upper_arm_roll_joint_jt r_wrist_flex_joint_jt r_wrist_roll_joint_jt right_arm_chain_cb_jt sensor_mount_frame_joint_jt torso_lift_joint_jt torso_lift_motor_screw_joint_jt wide_stereo_frame_joint_jt wide_stereo_l_stereo_camera_frame_joint_jt wide_stereo_l_stereo_camera_optical_frame_joint_jt wide_stereo_optical_frame_joint_jt wide_stereo_r_stereo_camera_frame_joint_jt wide_stereo_r_stereo_camera_optical_frame_joint_jt base_bellow_link_lk base_laser_link_lk bl_caster_l_wheel_link_lk bl_caster_r_wheel_link_lk bl_caster_rotation_link_lk br_caster_l_wheel_link_lk br_caster_r_wheel_link_lk br_caster_rotation_link_lk fl_caster_l_wheel_link_lk fl_caster_r_wheel_link_lk fl_caster_rotation_link_lk fr_caster_l_wheel_link_lk fr_caster_r_wheel_link_lk fr_caster_rotation_link_lk head_chain_cb_link_lk head_mount_kinect_ir_optical_frame_lk head_mount_kinect_rgb_optical_frame_lk head_mount_kinect_rgb_link_lk head_mount_kinect_ir_link_lk head_mount_prosilica_optical_frame_lk head_mount_prosilica_link_lk head_mount_link_lk projector_wg6802418_child_frame_lk projector_wg6802418_frame_lk narrow_stereo_l_stereo_camera_optical_frame_lk narrow_stereo_r_stereo_camera_optical_frame_lk narrow_stereo_r_stereo_camera_frame_lk narrow_stereo_l_stereo_camera_frame_lk narrow_stereo_optical_frame_lk narrow_stereo_link_lk wide_stereo_l_stereo_camera_optical_frame_lk wide_stereo_r_stereo_camera_optical_frame_lk wide_stereo_r_stereo_camera_frame_lk wide_stereo_l_stereo_camera_frame_lk wide_stereo_optical_frame_lk wide_stereo_link_lk double_stereo_link_lk high_def_optical_frame_lk high_def_frame_lk sensor_mount_link_lk head_plate_frame_lk head_tilt_link_lk head_pan_link_lk imu_link_lk l_forearm_cam_optical_frame_lk l_forearm_cam_frame_lk l_gripper_l_finger_tip_link_lk l_gripper_l_finger_link_lk l_gripper_led_frame_lk l_gripper_motor_accelerometer_link_lk l_gripper_motor_screw_link_lk l_gripper_motor_slider_link_lk l_gripper_l_finger_tip_frame_lk l_gripper_r_finger_tip_link_lk l_gripper_r_finger_link_lk l_gripper_tool_frame_lk l_gripper_palm_link_lk left_arm_chain_cb_link_lk l_wrist_roll_link_lk l_wrist_flex_link_lk l_forearm_link_lk l_forearm_roll_link_lk l_elbow_flex_link_lk l_upper_arm_link_lk l_upper_arm_roll_link_lk l_shoulder_lift_link_lk l_shoulder_pan_link_lk l_torso_lift_side_plate_link_lk laser_tilt_link_lk laser_tilt_mount_link_lk r_forearm_cam_optical_frame_lk r_forearm_cam_frame_lk r_gripper_l_finger_tip_link_lk r_gripper_l_finger_link_lk r_gripper_led_frame_lk r_gripper_motor_accelerometer_link_lk r_gripper_motor_screw_link_lk r_gripper_motor_slider_link_lk r_gripper_l_finger_tip_frame_lk r_gripper_r_finger_tip_link_lk r_gripper_r_finger_link_lk r_gripper_tool_frame_lk r_gripper_palm_link_lk right_arm_chain_cb_link_lk r_wrist_roll_link_lk r_wrist_flex_link_lk r_forearm_link_lk r_forearm_roll_link_lk r_elbow_flex_link_lk r_upper_arm_link_lk r_upper_arm_roll_link_lk r_shoulder_lift_link_lk r_shoulder_pan_link_lk r_torso_lift_side_plate_link_lk torso_lift_link_lk torso_lift_motor_screw_link_lk base_link_lk base_footprint_lk rarm-grasping-obj larm-grasping-obj))
(defmethod pr2-robot
  (:init
   (&rest args)
   (let ()
     (send-super* :init :name "pr2" args)

     ;; node id=vkmodel0_node0, name=base_bellow_link, sid=node0
     (let ( b_gkmodel0_base_bellow_link_geom0)
       ;; define bodyset-link for base_bellow_link : vkmodel0_node0
       (setq b_gkmodel0_base_bellow_link_geom0 (instance pr2_gkmodel0_base_bellow_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_base_bellow_link_geom0,domNode=base_bellow_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_base_bellow_link_geom0 :transform localcds :world)
       )
       (setq base_bellow_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_base_bellow_link_geom0)
                       :name "base_bellow_link"))
       (send base_bellow_link_lk :weight 1000.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.9000000000000000e+02 0.0000000000000000e+00 8.5100000000000011e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (base_bellow_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (base_bellow_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=base_bellow_link_lk,domNode=base_bellow_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send base_bellow_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send base_bellow_link_lk :transform
             (make-coords :pos (float-vector -2.9000000000000000e+02 0.0000000000000000e+00 8.0000000000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node2, name=base_laser_link, sid=node2
     (let ()
       ;; define cascaded-coords for base_laser_link
       (setq base_laser_link_lk (instance bodyset-link :init (make-cascoords) :name "base_laser_link"))
       (send base_laser_link_lk :weight 1.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.7500000000000000e+02 0.0000000000000000e+00 3.0300000000000000e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (base_laser_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+05 1.0000000000000000e+03 1.0000000000000000e+05))) (transpose (send tmp-c :worldrot))))
         (setq (base_laser_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=base_laser_link_lk,domNode=base_laser_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.7500000000000000e+02 0.0000000000000000e+00 2.5200000000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send base_laser_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node4, name=bl_caster_l_wheel_link, sid=node4
     (let ( b_gkmodel0_bl_caster_l_wheel_link_geom0)
       ;; define bodyset-link for bl_caster_l_wheel_link : vkmodel0_node4
       (setq b_gkmodel0_bl_caster_l_wheel_link_geom0 (instance pr2_gkmodel0_bl_caster_l_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_bl_caster_l_wheel_link_geom0,domNode=bl_caster_l_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_bl_caster_l_wheel_link_geom0 :transform localcds :world)
       )
       (setq bl_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_bl_caster_l_wheel_link_geom0)
                       :name "bl_caster_l_wheel_link"))
       (send bl_caster_l_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.2459999999999999e+02 2.7360000000000002e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (bl_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (bl_caster_l_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=bl_caster_l_wheel_link_lk,domNode=bl_caster_l_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send bl_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send bl_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node5, name=bl_caster_r_wheel_link, sid=node5
     (let ( b_gkmodel0_bl_caster_r_wheel_link_geom0)
       ;; define bodyset-link for bl_caster_r_wheel_link : vkmodel0_node5
       (setq b_gkmodel0_bl_caster_r_wheel_link_geom0 (instance pr2_gkmodel0_bl_caster_r_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_bl_caster_r_wheel_link_geom0,domNode=bl_caster_r_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_bl_caster_r_wheel_link_geom0 :transform localcds :world)
       )
       (setq bl_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_bl_caster_r_wheel_link_geom0)
                       :name "bl_caster_r_wheel_link"))
       (send bl_caster_r_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.2459999999999999e+02 1.7559999999999999e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (bl_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (bl_caster_r_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=bl_caster_r_wheel_link_lk,domNode=bl_caster_r_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send bl_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send bl_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node6, name=bl_caster_rotation_link, sid=node6
     (let ( b_gkmodel0_bl_caster_rotation_link_geom0)
       ;; define bodyset-link for bl_caster_rotation_link : vkmodel0_node6
       (setq b_gkmodel0_bl_caster_rotation_link_geom0 (instance pr2_gkmodel0_bl_caster_rotation_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_bl_caster_rotation_link_geom0,domNode=bl_caster_rotation_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_bl_caster_rotation_link_geom0 :transform localcds :world)
       )
       (setq bl_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_bl_caster_rotation_link_geom0)
                       :name "bl_caster_rotation_link"))
       (send bl_caster_rotation_link_lk :weight 3473.082)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.2459999999999999e+02 2.2459999999999999e+02 1.4919999999999999e+02) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (bl_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (bl_caster_rotation_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=bl_caster_rotation_link_lk,domNode=bl_caster_rotation_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send bl_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send bl_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector -2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=bl_caster_l_wheel_link_lk,domNode=bl_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send bl_caster_l_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=bl_caster_l_wheel_link_lk,domNode=bl_caster_rotation_link,targetCount=1,parent=bl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send bl_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) bl_caster_rotation_link_lk)

       ;; writeTransform(name=bl_caster_l_wheel_link_lk,domNode=bl_caster_rotation_link,targetCount=2,parent=bl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send bl_caster_rotation_link_lk :assoc bl_caster_l_wheel_link_lk)

       ;; writeTransform(name=bl_caster_r_wheel_link_lk,domNode=bl_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send bl_caster_r_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=bl_caster_r_wheel_link_lk,domNode=bl_caster_rotation_link,targetCount=1,parent=bl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send bl_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) bl_caster_rotation_link_lk)

       ;; writeTransform(name=bl_caster_r_wheel_link_lk,domNode=bl_caster_rotation_link,targetCount=2,parent=bl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send bl_caster_rotation_link_lk :assoc bl_caster_r_wheel_link_lk)
       )

     ;; node id=vkmodel0_node7, name=br_caster_l_wheel_link, sid=node7
     (let ( b_gkmodel0_br_caster_l_wheel_link_geom0)
       ;; define bodyset-link for br_caster_l_wheel_link : vkmodel0_node7
       (setq b_gkmodel0_br_caster_l_wheel_link_geom0 (instance pr2_gkmodel0_br_caster_l_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_br_caster_l_wheel_link_geom0,domNode=br_caster_l_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_br_caster_l_wheel_link_geom0 :transform localcds :world)
       )
       (setq br_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_br_caster_l_wheel_link_geom0)
                       :name "br_caster_l_wheel_link"))
       (send br_caster_l_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.2459999999999999e+02 -1.7559999999999999e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (br_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (br_caster_l_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=br_caster_l_wheel_link_lk,domNode=br_caster_l_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send br_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send br_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node8, name=br_caster_r_wheel_link, sid=node8
     (let ( b_gkmodel0_br_caster_r_wheel_link_geom0)
       ;; define bodyset-link for br_caster_r_wheel_link : vkmodel0_node8
       (setq b_gkmodel0_br_caster_r_wheel_link_geom0 (instance pr2_gkmodel0_br_caster_r_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_br_caster_r_wheel_link_geom0,domNode=br_caster_r_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_br_caster_r_wheel_link_geom0 :transform localcds :world)
       )
       (setq br_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_br_caster_r_wheel_link_geom0)
                       :name "br_caster_r_wheel_link"))
       (send br_caster_r_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.2459999999999999e+02 -2.7360000000000002e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (br_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (br_caster_r_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=br_caster_r_wheel_link_lk,domNode=br_caster_r_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send br_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send br_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node9, name=br_caster_rotation_link, sid=node9
     (let ( b_gkmodel0_br_caster_rotation_link_geom0)
       ;; define bodyset-link for br_caster_rotation_link : vkmodel0_node9
       (setq b_gkmodel0_br_caster_rotation_link_geom0 (instance pr2_gkmodel0_br_caster_rotation_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_br_caster_rotation_link_geom0,domNode=br_caster_rotation_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_br_caster_rotation_link_geom0 :transform localcds :world)
       )
       (setq br_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_br_caster_rotation_link_geom0)
                       :name "br_caster_rotation_link"))
       (send br_caster_rotation_link_lk :weight 3473.082)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -2.2459999999999999e+02 -2.2459999999999999e+02 1.4919999999999999e+02) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (br_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (br_caster_rotation_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=br_caster_rotation_link_lk,domNode=br_caster_rotation_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send br_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send br_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector -2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=br_caster_l_wheel_link_lk,domNode=br_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send br_caster_l_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=br_caster_l_wheel_link_lk,domNode=br_caster_rotation_link,targetCount=1,parent=br_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send br_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) br_caster_rotation_link_lk)

       ;; writeTransform(name=br_caster_l_wheel_link_lk,domNode=br_caster_rotation_link,targetCount=2,parent=br_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send br_caster_rotation_link_lk :assoc br_caster_l_wheel_link_lk)

       ;; writeTransform(name=br_caster_r_wheel_link_lk,domNode=br_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send br_caster_r_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=br_caster_r_wheel_link_lk,domNode=br_caster_rotation_link,targetCount=1,parent=br_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send br_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) br_caster_rotation_link_lk)

       ;; writeTransform(name=br_caster_r_wheel_link_lk,domNode=br_caster_rotation_link,targetCount=2,parent=br_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send br_caster_rotation_link_lk :assoc br_caster_r_wheel_link_lk)
       )

     ;; node id=vkmodel0_node11, name=fl_caster_l_wheel_link, sid=node11
     (let ( b_gkmodel0_fl_caster_l_wheel_link_geom0)
       ;; define bodyset-link for fl_caster_l_wheel_link : vkmodel0_node11
       (setq b_gkmodel0_fl_caster_l_wheel_link_geom0 (instance pr2_gkmodel0_fl_caster_l_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_fl_caster_l_wheel_link_geom0,domNode=fl_caster_l_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_fl_caster_l_wheel_link_geom0 :transform localcds :world)
       )
       (setq fl_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_fl_caster_l_wheel_link_geom0)
                       :name "fl_caster_l_wheel_link"))
       (send fl_caster_l_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.2459999999999999e+02 2.7360000000000002e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (fl_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (fl_caster_l_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=fl_caster_l_wheel_link_lk,domNode=fl_caster_l_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send fl_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fl_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node12, name=fl_caster_r_wheel_link, sid=node12
     (let ( b_gkmodel0_fl_caster_r_wheel_link_geom0)
       ;; define bodyset-link for fl_caster_r_wheel_link : vkmodel0_node12
       (setq b_gkmodel0_fl_caster_r_wheel_link_geom0 (instance pr2_gkmodel0_fl_caster_r_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_fl_caster_r_wheel_link_geom0,domNode=fl_caster_r_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_fl_caster_r_wheel_link_geom0 :transform localcds :world)
       )
       (setq fl_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_fl_caster_r_wheel_link_geom0)
                       :name "fl_caster_r_wheel_link"))
       (send fl_caster_r_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.2459999999999999e+02 1.7559999999999999e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (fl_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (fl_caster_r_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=fl_caster_r_wheel_link_lk,domNode=fl_caster_r_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send fl_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fl_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node13, name=fl_caster_rotation_link, sid=node13
     (let ( b_gkmodel0_fl_caster_rotation_link_geom0)
       ;; define bodyset-link for fl_caster_rotation_link : vkmodel0_node13
       (setq b_gkmodel0_fl_caster_rotation_link_geom0 (instance pr2_gkmodel0_fl_caster_rotation_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_fl_caster_rotation_link_geom0,domNode=fl_caster_rotation_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_fl_caster_rotation_link_geom0 :transform localcds :world)
       )
       (setq fl_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_fl_caster_rotation_link_geom0)
                       :name "fl_caster_rotation_link"))
       (send fl_caster_rotation_link_lk :weight 3473.082)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.2459999999999999e+02 2.2459999999999999e+02 1.4919999999999999e+02) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (fl_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (fl_caster_rotation_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=fl_caster_rotation_link_lk,domNode=fl_caster_rotation_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send fl_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fl_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector 2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=fl_caster_l_wheel_link_lk,domNode=fl_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fl_caster_l_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=fl_caster_l_wheel_link_lk,domNode=fl_caster_rotation_link,targetCount=1,parent=fl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send fl_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) fl_caster_rotation_link_lk)

       ;; writeTransform(name=fl_caster_l_wheel_link_lk,domNode=fl_caster_rotation_link,targetCount=2,parent=fl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send fl_caster_rotation_link_lk :assoc fl_caster_l_wheel_link_lk)

       ;; writeTransform(name=fl_caster_r_wheel_link_lk,domNode=fl_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.2459999999999999e+02 2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fl_caster_r_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=fl_caster_r_wheel_link_lk,domNode=fl_caster_rotation_link,targetCount=1,parent=fl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send fl_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) fl_caster_rotation_link_lk)

       ;; writeTransform(name=fl_caster_r_wheel_link_lk,domNode=fl_caster_rotation_link,targetCount=2,parent=fl_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send fl_caster_rotation_link_lk :assoc fl_caster_r_wheel_link_lk)
       )

     ;; node id=vkmodel0_node14, name=fr_caster_l_wheel_link, sid=node14
     (let ( b_gkmodel0_fr_caster_l_wheel_link_geom0)
       ;; define bodyset-link for fr_caster_l_wheel_link : vkmodel0_node14
       (setq b_gkmodel0_fr_caster_l_wheel_link_geom0 (instance pr2_gkmodel0_fr_caster_l_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_fr_caster_l_wheel_link_geom0,domNode=fr_caster_l_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_fr_caster_l_wheel_link_geom0 :transform localcds :world)
       )
       (setq fr_caster_l_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_fr_caster_l_wheel_link_geom0)
                       :name "fr_caster_l_wheel_link"))
       (send fr_caster_l_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.2459999999999999e+02 -1.7559999999999999e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (fr_caster_l_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (fr_caster_l_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=fr_caster_l_wheel_link_lk,domNode=fr_caster_l_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send fr_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fr_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node15, name=fr_caster_r_wheel_link, sid=node15
     (let ( b_gkmodel0_fr_caster_r_wheel_link_geom0)
       ;; define bodyset-link for fr_caster_r_wheel_link : vkmodel0_node15
       (setq b_gkmodel0_fr_caster_r_wheel_link_geom0 (instance pr2_gkmodel0_fr_caster_r_wheel_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_fr_caster_r_wheel_link_geom0,domNode=fr_caster_r_wheel_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_fr_caster_r_wheel_link_geom0 :transform localcds :world)
       )
       (setq fr_caster_r_wheel_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_fr_caster_r_wheel_link_geom0)
                       :name "fr_caster_r_wheel_link"))
       (send fr_caster_r_wheel_link_lk :weight 440.360)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.2459999999999999e+02 -2.7360000000000002e+02 7.9199999999999989e+01) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (fr_caster_r_wheel_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (fr_caster_r_wheel_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=fr_caster_r_wheel_link_lk,domNode=fr_caster_r_wheel_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send fr_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fr_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -4.9000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node16, name=fr_caster_rotation_link, sid=node16
     (let ( b_gkmodel0_fr_caster_rotation_link_geom0)
       ;; define bodyset-link for fr_caster_rotation_link : vkmodel0_node16
       (setq b_gkmodel0_fr_caster_rotation_link_geom0 (instance pr2_gkmodel0_fr_caster_rotation_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_fr_caster_rotation_link_geom0,domNode=fr_caster_rotation_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_fr_caster_rotation_link_geom0 :transform localcds :world)
       )
       (setq fr_caster_rotation_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_fr_caster_rotation_link_geom0)
                       :name "fr_caster_rotation_link"))
       (send fr_caster_rotation_link_lk :weight 3473.082)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.2459999999999999e+02 -2.2459999999999999e+02 1.4919999999999999e+02) :rot (matrix-exponent (scale 1.6287877870904515e+00 (float-vector 9.1138501203707201e-01 3.8312337282203113e-01 1.5031247796393091e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (fr_caster_rotation_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2544593986297460e+07 1.1456840427869651e+07 1.5392469553832879e+07))) (transpose (send tmp-c :worldrot))))
         (setq (fr_caster_rotation_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=fr_caster_rotation_link_lk,domNode=fr_caster_rotation_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send fr_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fr_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector 2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=fr_caster_l_wheel_link_lk,domNode=fr_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fr_caster_l_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=fr_caster_l_wheel_link_lk,domNode=fr_caster_rotation_link,targetCount=1,parent=fr_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send fr_caster_l_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) fr_caster_rotation_link_lk)

       ;; writeTransform(name=fr_caster_l_wheel_link_lk,domNode=fr_caster_rotation_link,targetCount=2,parent=fr_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send fr_caster_rotation_link_lk :assoc fr_caster_l_wheel_link_lk)

       ;; writeTransform(name=fr_caster_r_wheel_link_lk,domNode=fr_caster_rotation_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.2459999999999999e+02 -2.2459999999999999e+02 2.8199999999999999e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fr_caster_r_wheel_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=fr_caster_r_wheel_link_lk,domNode=fr_caster_rotation_link,targetCount=1,parent=fr_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send fr_caster_r_wheel_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) fr_caster_rotation_link_lk)

       ;; writeTransform(name=fr_caster_r_wheel_link_lk,domNode=fr_caster_rotation_link,targetCount=2,parent=fr_caster_rotation_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send fr_caster_rotation_link_lk :assoc fr_caster_r_wheel_link_lk)
       )

     ;; node id=vkmodel0_node17, name=head_chain_cb_link, sid=node17
     (let ()
       ;; define cascaded-coords for head_chain_cb_link
       (setq head_chain_cb_link_lk (instance bodyset-link :init (make-cascoords) :name "head_chain_cb_link"))
        (progn (send head_chain_cb_link_lk :weight 0.0) (send head_chain_cb_link_lk :centroid (float-vector 0 0 0)) (send head_chain_cb_link_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=head_chain_cb_link_lk,domNode=head_chain_cb_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_chain_cb_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node19, name=head_mount_kinect_ir_optical_frame, sid=node19
     (let ()
       ;; define cascaded-coords for head_mount_kinect_ir_optical_frame
       (setq head_mount_kinect_ir_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "head_mount_kinect_ir_optical_frame"))
        (progn (send head_mount_kinect_ir_optical_frame_lk :weight 0.0) (send head_mount_kinect_ir_optical_frame_lk :centroid (float-vector 0 0 0)) (send head_mount_kinect_ir_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=head_mount_kinect_ir_optical_frame_lk,domNode=head_mount_kinect_ir_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send head_mount_kinect_ir_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node21, name=head_mount_kinect_rgb_optical_frame, sid=node21
     (let ()
       ;; define cascaded-coords for head_mount_kinect_rgb_optical_frame
       (setq head_mount_kinect_rgb_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "head_mount_kinect_rgb_optical_frame"))
        (progn (send head_mount_kinect_rgb_optical_frame_lk :weight 0.0) (send head_mount_kinect_rgb_optical_frame_lk :centroid (float-vector 0 0 0)) (send head_mount_kinect_rgb_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=head_mount_kinect_rgb_optical_frame_lk,domNode=head_mount_kinect_rgb_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send head_mount_kinect_rgb_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node20, name=head_mount_kinect_rgb_link, sid=node20
     (let ( b_gkmodel0_head_mount_kinect_rgb_link_geom0)
       ;; define bodyset-link for head_mount_kinect_rgb_link : vkmodel0_node20
       (setq b_gkmodel0_head_mount_kinect_rgb_link_geom0 (instance pr2_gkmodel0_head_mount_kinect_rgb_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_mount_kinect_rgb_link_geom0,domNode=head_mount_kinect_rgb_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_mount_kinect_rgb_link_geom0 :transform localcds :world)
       )
       (setq head_mount_kinect_rgb_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_mount_kinect_rgb_link_geom0)
                       :name "head_mount_kinect_rgb_link"))
       (send head_mount_kinect_rgb_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -1.6450399138460000e+02 -8.7223001369000013e+00 1.4421910357032000e+03) :rot (matrix-exponent (scale 5.1150493128436600e-02 (float-vector -2.1898583126967591e-01 -9.5285105422441974e-01 -2.1004779019675701e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_mount_kinect_rgb_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (head_mount_kinect_rgb_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_mount_kinect_rgb_link_lk,domNode=head_mount_kinect_rgb_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_kinect_rgb_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_kinect_rgb_link_lk :transform
             (make-coords :pos (float-vector -1.8366991384599999e+01 -2.1222300136900000e+01 -2.1886964296799999e+01)
                          :angle 5.1150493128436600e-02 :axis (float-vector -2.1898583126967591e-01 -9.5285105422441974e-01 -2.1004779019675701e-01)) :local)
       ;;1;

       ;; writeTransform(name=head_mount_kinect_rgb_optical_frame_lk,domNode=head_mount_kinect_rgb_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -1.8366991384599999e+01 -2.1222300136900000e+01 -2.1886964296799999e+01)
                          :angle 5.1150493128436600e-02 :axis (float-vector -2.1898583126967591e-01 -9.5285105422441974e-01 -2.1004779019675701e-01)) :local)
       (send head_mount_kinect_rgb_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_kinect_rgb_optical_frame_lk,domNode=head_mount_kinect_rgb_link,targetCount=1,parent=head_mount_kinect_rgb_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_kinect_rgb_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_mount_kinect_rgb_link_lk)

       ;; writeTransform(name=head_mount_kinect_rgb_optical_frame_lk,domNode=head_mount_kinect_rgb_link,targetCount=2,parent=head_mount_kinect_rgb_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_mount_kinect_rgb_link_lk :assoc head_mount_kinect_rgb_optical_frame_lk)
       )

     ;; node id=vkmodel0_node18, name=head_mount_kinect_ir_link, sid=node18
     (let ( b_gkmodel0_head_mount_kinect_ir_link_geom0)
       ;; define bodyset-link for head_mount_kinect_ir_link : vkmodel0_node18
       (setq b_gkmodel0_head_mount_kinect_ir_link_geom0 (instance pr2_gkmodel0_head_mount_kinect_ir_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_mount_kinect_ir_link_geom0,domNode=head_mount_kinect_ir_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_mount_kinect_ir_link_geom0 :transform localcds :world)
       )
       (setq head_mount_kinect_ir_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_mount_kinect_ir_link_geom0)
                       :name "head_mount_kinect_ir_link"))
       (send head_mount_kinect_ir_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -1.4613700000000000e+02 1.2500000000000000e+01 1.4640780000000000e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_mount_kinect_ir_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (head_mount_kinect_ir_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_mount_kinect_ir_link_lk,domNode=head_mount_kinect_ir_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_kinect_ir_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_kinect_ir_link_lk :transform
             (make-coords :pos (float-vector -3.2266999999999996e+01 1.2500000000000000e+01 1.3645300000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_mount_kinect_ir_optical_frame_lk,domNode=head_mount_kinect_ir_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -3.2266999999999996e+01 1.2500000000000000e+01 1.3645300000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_kinect_ir_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_kinect_ir_optical_frame_lk,domNode=head_mount_kinect_ir_link,targetCount=1,parent=head_mount_kinect_ir_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_kinect_ir_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_mount_kinect_ir_link_lk)

       ;; writeTransform(name=head_mount_kinect_ir_optical_frame_lk,domNode=head_mount_kinect_ir_link,targetCount=2,parent=head_mount_kinect_ir_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_mount_kinect_ir_link_lk :assoc head_mount_kinect_ir_optical_frame_lk)

       ;; writeTransform(name=head_mount_kinect_rgb_link_lk,domNode=head_mount_kinect_ir_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -3.2266999999999996e+01 1.2500000000000000e+01 1.3645300000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_kinect_rgb_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_kinect_rgb_link_lk,domNode=head_mount_kinect_ir_link,targetCount=1,parent=head_mount_kinect_ir_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_kinect_rgb_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_mount_kinect_ir_link_lk)

       ;; writeTransform(name=head_mount_kinect_rgb_link_lk,domNode=head_mount_kinect_ir_link,targetCount=2,parent=head_mount_kinect_ir_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_mount_kinect_ir_link_lk :assoc head_mount_kinect_rgb_link_lk)
       )

     ;; node id=vkmodel0_node24, name=head_mount_prosilica_optical_frame, sid=node24
     (let ()
       ;; define cascaded-coords for head_mount_prosilica_optical_frame
       (setq head_mount_prosilica_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "head_mount_prosilica_optical_frame"))
        (progn (send head_mount_prosilica_optical_frame_lk :weight 0.0) (send head_mount_prosilica_optical_frame_lk :centroid (float-vector 0 0 0)) (send head_mount_prosilica_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=head_mount_prosilica_optical_frame_lk,domNode=head_mount_prosilica_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send head_mount_prosilica_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node23, name=head_mount_prosilica_link, sid=node23
     (let ( b_gkmodel0_head_mount_prosilica_link_geom0)
       ;; define bodyset-link for head_mount_prosilica_link : vkmodel0_node23
       (setq b_gkmodel0_head_mount_prosilica_link_geom0 (instance pr2_gkmodel0_head_mount_prosilica_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_mount_prosilica_link_geom0,domNode=head_mount_prosilica_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_mount_prosilica_link_geom0 :transform localcds :world)
       )
       (setq head_mount_prosilica_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_mount_prosilica_link_geom0)
                       :name "head_mount_prosilica_link"))
       (send head_mount_prosilica_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -1.6032700000000000e+02 1.2500000000000000e+01 1.4165460000000000e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_mount_prosilica_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (head_mount_prosilica_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_mount_prosilica_link_lk,domNode=head_mount_prosilica_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_prosilica_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_prosilica_link_lk :transform
             (make-coords :pos (float-vector -4.6457000000000001e+01 1.2500000000000000e+01 8.8921000000000006e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_mount_prosilica_optical_frame_lk,domNode=head_mount_prosilica_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -4.6457000000000001e+01 1.2500000000000000e+01 8.8921000000000006e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_prosilica_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_prosilica_optical_frame_lk,domNode=head_mount_prosilica_link,targetCount=1,parent=head_mount_prosilica_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_prosilica_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_mount_prosilica_link_lk)

       ;; writeTransform(name=head_mount_prosilica_optical_frame_lk,domNode=head_mount_prosilica_link,targetCount=2,parent=head_mount_prosilica_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_mount_prosilica_link_lk :assoc head_mount_prosilica_optical_frame_lk)
       )

     ;; node id=vkmodel0_node22, name=head_mount_link, sid=node22
     (let ( b_gkmodel0_head_mount_link_geom0)
       ;; define bodyset-link for head_mount_link : vkmodel0_node22
       (setq b_gkmodel0_head_mount_link_geom0 (instance pr2_gkmodel0_head_mount_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_mount_link_geom0,domNode=head_mount_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_mount_link_geom0 :transform localcds :world)
       )
       (setq head_mount_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_mount_link_geom0)
                       :name "head_mount_link"))
       (send head_mount_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -1.1387000000000000e+02 0.0000000000000000e+00 1.3276250000000000e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_mount_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (head_mount_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_mount_link_lk,domNode=head_mount_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_link_lk :transform
             (make-coords :pos (float-vector -1.3800000000000000e+02 0.0000000000000000e+00 9.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_mount_kinect_ir_link_lk,domNode=head_mount_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -1.3800000000000000e+02 0.0000000000000000e+00 9.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_kinect_ir_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_kinect_ir_link_lk,domNode=head_mount_link,targetCount=1,parent=head_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_kinect_ir_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_mount_link_lk)

       ;; writeTransform(name=head_mount_kinect_ir_link_lk,domNode=head_mount_link,targetCount=2,parent=head_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_mount_link_lk :assoc head_mount_kinect_ir_link_lk)

       ;; writeTransform(name=head_mount_prosilica_link_lk,domNode=head_mount_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -1.3800000000000000e+02 0.0000000000000000e+00 9.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_prosilica_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_prosilica_link_lk,domNode=head_mount_link,targetCount=1,parent=head_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_prosilica_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_mount_link_lk)

       ;; writeTransform(name=head_mount_prosilica_link_lk,domNode=head_mount_link,targetCount=2,parent=head_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_mount_link_lk :assoc head_mount_prosilica_link_lk)
       )

     ;; node id=vkmodel0_node63, name=projector_wg6802418_child_frame, sid=node63
     (let ()
       ;; define cascaded-coords for projector_wg6802418_child_frame
       (setq projector_wg6802418_child_frame_lk (instance bodyset-link :init (make-cascoords) :name "projector_wg6802418_child_frame"))
       (send projector_wg6802418_child_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.4129999999999999e+01 1.1000000000000000e+02 1.2912250000000001e+03) :rot (matrix-exponent (scale 1.5707963267900003e+00 (float-vector 0.0000000000000000e+00 -1.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (projector_wg6802418_child_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (projector_wg6802418_child_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=projector_wg6802418_child_frame_lk,domNode=projector_wg6802418_child_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 1.5707963267900003e+00 :axis (float-vector 0.0000000000000000e+00 -1.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send projector_wg6802418_child_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node64, name=projector_wg6802418_frame, sid=node64
     (let ()
       ;; define bodyset-link for projector_wg6802418_frame_lk
       (setq projector_wg6802418_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "projector_wg6802418_frame"))
       (send projector_wg6802418_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.4129999999999999e+01 1.1000000000000000e+02 1.2912250000000001e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (projector_wg6802418_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (projector_wg6802418_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=projector_wg6802418_frame_lk,domNode=projector_wg6802418_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send projector_wg6802418_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send projector_wg6802418_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 1.1000000000000000e+02 5.4600000000000001e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=projector_wg6802418_child_frame_lk,domNode=projector_wg6802418_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 1.1000000000000000e+02 5.4600000000000001e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send projector_wg6802418_child_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=projector_wg6802418_child_frame_lk,domNode=projector_wg6802418_frame,targetCount=1,parent=projector_wg6802418_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send projector_wg6802418_child_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) projector_wg6802418_frame_lk)

       ;; writeTransform(name=projector_wg6802418_child_frame_lk,domNode=projector_wg6802418_frame,targetCount=2,parent=projector_wg6802418_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send projector_wg6802418_frame_lk :assoc projector_wg6802418_child_frame_lk)
       )

     ;; node id=vkmodel0_node58, name=narrow_stereo_l_stereo_camera_optical_frame, sid=node58
     (let ()
       ;; define cascaded-coords for narrow_stereo_l_stereo_camera_optical_frame
       (setq narrow_stereo_l_stereo_camera_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "narrow_stereo_l_stereo_camera_optical_frame"))
        (progn (send narrow_stereo_l_stereo_camera_optical_frame_lk :weight 0.0) (send narrow_stereo_l_stereo_camera_optical_frame_lk :centroid (float-vector 0 0 0)) (send narrow_stereo_l_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_optical_frame_lk,domNode=narrow_stereo_l_stereo_camera_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send narrow_stereo_l_stereo_camera_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node62, name=narrow_stereo_r_stereo_camera_optical_frame, sid=node62
     (let ()
       ;; define cascaded-coords for narrow_stereo_r_stereo_camera_optical_frame
       (setq narrow_stereo_r_stereo_camera_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "narrow_stereo_r_stereo_camera_optical_frame"))
        (progn (send narrow_stereo_r_stereo_camera_optical_frame_lk :weight 0.0) (send narrow_stereo_r_stereo_camera_optical_frame_lk :centroid (float-vector 0 0 0)) (send narrow_stereo_r_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_optical_frame_lk,domNode=narrow_stereo_r_stereo_camera_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send narrow_stereo_r_stereo_camera_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node61, name=narrow_stereo_r_stereo_camera_frame, sid=node61
     (let ()
       ;; define bodyset-link for narrow_stereo_r_stereo_camera_frame_lk
       (setq narrow_stereo_r_stereo_camera_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "narrow_stereo_r_stereo_camera_frame"))
       (send narrow_stereo_r_stereo_camera_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.6882539335745214e+01 -2.9358342299091682e+01 1.2816386387348691e+03) :rot (matrix-exponent (scale 1.8189603032039571e-02 (float-vector -5.5360838623877118e-01 -6.0706099694982807e-01 -5.7008306470933201e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (narrow_stereo_r_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (narrow_stereo_r_stereo_camera_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_frame_lk,domNode=narrow_stereo_r_stereo_camera_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_r_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_r_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_optical_frame_lk,domNode=narrow_stereo_r_stereo_camera_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_r_stereo_camera_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_optical_frame_lk,domNode=narrow_stereo_r_stereo_camera_frame,targetCount=1,parent=narrow_stereo_r_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_r_stereo_camera_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) narrow_stereo_r_stereo_camera_frame_lk)

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_optical_frame_lk,domNode=narrow_stereo_r_stereo_camera_frame,targetCount=2,parent=narrow_stereo_r_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send narrow_stereo_r_stereo_camera_frame_lk :assoc narrow_stereo_r_stereo_camera_optical_frame_lk)
       )

     ;; node id=vkmodel0_node57, name=narrow_stereo_l_stereo_camera_frame, sid=node57
     (let ()
       ;; define bodyset-link for narrow_stereo_l_stereo_camera_frame_lk
       (setq narrow_stereo_l_stereo_camera_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "narrow_stereo_l_stereo_camera_frame"))
       (send narrow_stereo_l_stereo_camera_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.7820754083899999e+01 6.0632256042200005e+01 1.2807375486935000e+03) :rot (matrix-exponent (scale 1.8189603032039571e-02 (float-vector -5.5360838623877118e-01 -6.0706099694982807e-01 -5.7008306470933201e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (narrow_stereo_l_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (narrow_stereo_l_stereo_camera_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_l_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_l_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_optical_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_l_stereo_camera_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_optical_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=1,parent=narrow_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_l_stereo_camera_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) narrow_stereo_l_stereo_camera_frame_lk)

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_optical_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=2,parent=narrow_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send narrow_stereo_l_stereo_camera_frame_lk :assoc narrow_stereo_l_stereo_camera_optical_frame_lk)

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_r_stereo_camera_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=1,parent=narrow_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_r_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) narrow_stereo_l_stereo_camera_frame_lk)

       ;; writeTransform(name=narrow_stereo_r_stereo_camera_frame_lk,domNode=narrow_stereo_l_stereo_camera_frame,targetCount=2,parent=narrow_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send narrow_stereo_l_stereo_camera_frame_lk :assoc narrow_stereo_r_stereo_camera_frame_lk)
       )

     ;; node id=vkmodel0_node60, name=narrow_stereo_optical_frame, sid=node60
     (let ()
       ;; define cascaded-coords for narrow_stereo_optical_frame
       (setq narrow_stereo_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "narrow_stereo_optical_frame"))
        (progn (send narrow_stereo_optical_frame_lk :weight 0.0) (send narrow_stereo_optical_frame_lk :centroid (float-vector 0 0 0)) (send narrow_stereo_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=narrow_stereo_optical_frame_lk,domNode=narrow_stereo_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send narrow_stereo_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node59, name=narrow_stereo_link, sid=node59
     (let ()
       ;; define bodyset-link for narrow_stereo_link_lk
       (setq narrow_stereo_link_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "narrow_stereo_link"))
       (send narrow_stereo_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.7820754083899999e+01 6.0632256042200005e+01 1.2807375486935000e+03) :rot (matrix-exponent (scale 1.8189603032039571e-02 (float-vector -5.5360838623877118e-01 -6.0706099694982807e-01 -5.7008306470933201e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (narrow_stereo_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (narrow_stereo_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=narrow_stereo_link_lk,domNode=narrow_stereo_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_link_lk :transform
             (make-coords :pos (float-vector 1.0000000000000000e+01 -0.0000000000000000e+00 -2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_link_lk :transform
             (make-coords :pos (float-vector 3.3690754083900003e+01 6.0632256042200005e+01 4.4112548693500003e+01)
                          :angle 1.8189603032039571e-02 :axis (float-vector -5.5360838623877118e-01 -6.0706099694982807e-01 -5.7008306470933201e-01)) :local)
       ;;1;

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_frame_lk,domNode=narrow_stereo_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 1.0000000000000000e+01 -0.0000000000000000e+00 -2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 3.3690754083900003e+01 6.0632256042200005e+01 4.4112548693500003e+01)
                          :angle 1.8189603032039571e-02 :axis (float-vector -5.5360838623877118e-01 -6.0706099694982807e-01 -5.7008306470933201e-01)) :local)
       (send narrow_stereo_l_stereo_camera_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_frame_lk,domNode=narrow_stereo_link,targetCount=1,parent=narrow_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_l_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) narrow_stereo_link_lk)

       ;; writeTransform(name=narrow_stereo_l_stereo_camera_frame_lk,domNode=narrow_stereo_link,targetCount=2,parent=narrow_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send narrow_stereo_link_lk :assoc narrow_stereo_l_stereo_camera_frame_lk)

       ;; writeTransform(name=narrow_stereo_optical_frame_lk,domNode=narrow_stereo_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 1.0000000000000000e+01 -0.0000000000000000e+00 -2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 3.3690754083900003e+01 6.0632256042200005e+01 4.4112548693500003e+01)
                          :angle 1.8189603032039571e-02 :axis (float-vector -5.5360838623877118e-01 -6.0706099694982807e-01 -5.7008306470933201e-01)) :local)
       (send narrow_stereo_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=narrow_stereo_optical_frame_lk,domNode=narrow_stereo_link,targetCount=1,parent=narrow_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) narrow_stereo_link_lk)

       ;; writeTransform(name=narrow_stereo_optical_frame_lk,domNode=narrow_stereo_link,targetCount=2,parent=narrow_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send narrow_stereo_link_lk :assoc narrow_stereo_optical_frame_lk)
       )

     ;; node id=vkmodel0_node93, name=wide_stereo_l_stereo_camera_optical_frame, sid=node93
     (let ()
       ;; define cascaded-coords for wide_stereo_l_stereo_camera_optical_frame
       (setq wide_stereo_l_stereo_camera_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "wide_stereo_l_stereo_camera_optical_frame"))
        (progn (send wide_stereo_l_stereo_camera_optical_frame_lk :weight 0.0) (send wide_stereo_l_stereo_camera_optical_frame_lk :centroid (float-vector 0 0 0)) (send wide_stereo_l_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=wide_stereo_l_stereo_camera_optical_frame_lk,domNode=wide_stereo_l_stereo_camera_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send wide_stereo_l_stereo_camera_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node97, name=wide_stereo_r_stereo_camera_optical_frame, sid=node97
     (let ()
       ;; define cascaded-coords for wide_stereo_r_stereo_camera_optical_frame
       (setq wide_stereo_r_stereo_camera_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "wide_stereo_r_stereo_camera_optical_frame"))
        (progn (send wide_stereo_r_stereo_camera_optical_frame_lk :weight 0.0) (send wide_stereo_r_stereo_camera_optical_frame_lk :centroid (float-vector 0 0 0)) (send wide_stereo_r_stereo_camera_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=wide_stereo_r_stereo_camera_optical_frame_lk,domNode=wide_stereo_r_stereo_camera_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send wide_stereo_r_stereo_camera_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node96, name=wide_stereo_r_stereo_camera_frame, sid=node96
     (let ()
       ;; define bodyset-link for wide_stereo_r_stereo_camera_frame_lk
       (setq wide_stereo_r_stereo_camera_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "wide_stereo_r_stereo_camera_frame"))
       (send wide_stereo_r_stereo_camera_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.8487477843992181e+01 -5.9412626369381428e+01 1.2813791146042822e+03) :rot (matrix-exponent (scale 1.6578770553785212e-02 (float-vector -4.4726399073674111e-01 -7.4956463541355667e-01 -4.8796288785888853e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (wide_stereo_r_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (wide_stereo_r_stereo_camera_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=wide_stereo_r_stereo_camera_frame_lk,domNode=wide_stereo_r_stereo_camera_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_r_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_r_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=wide_stereo_r_stereo_camera_optical_frame_lk,domNode=wide_stereo_r_stereo_camera_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -9.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_r_stereo_camera_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=wide_stereo_r_stereo_camera_optical_frame_lk,domNode=wide_stereo_r_stereo_camera_frame,targetCount=1,parent=wide_stereo_r_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_r_stereo_camera_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) wide_stereo_r_stereo_camera_frame_lk)

       ;; writeTransform(name=wide_stereo_r_stereo_camera_optical_frame_lk,domNode=wide_stereo_r_stereo_camera_frame,targetCount=2,parent=wide_stereo_r_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send wide_stereo_r_stereo_camera_frame_lk :assoc wide_stereo_r_stereo_camera_optical_frame_lk)
       )

     ;; node id=vkmodel0_node92, name=wide_stereo_l_stereo_camera_frame, sid=node92
     (let ()
       ;; define bodyset-link for wide_stereo_l_stereo_camera_frame_lk
       (setq wide_stereo_l_stereo_camera_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "wide_stereo_l_stereo_camera_frame"))
       (send wide_stereo_l_stereo_camera_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.9219675205800002e+01 3.0581954459599999e+01 1.2807163111346999e+03) :rot (matrix-exponent (scale 1.6578770553785212e-02 (float-vector -4.4726399073674111e-01 -7.4956463541355667e-01 -4.8796288785888853e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (wide_stereo_l_stereo_camera_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (wide_stereo_l_stereo_camera_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=wide_stereo_l_stereo_camera_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_l_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_l_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=wide_stereo_l_stereo_camera_optical_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_l_stereo_camera_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=wide_stereo_l_stereo_camera_optical_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=1,parent=wide_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_l_stereo_camera_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) wide_stereo_l_stereo_camera_frame_lk)

       ;; writeTransform(name=wide_stereo_l_stereo_camera_optical_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=2,parent=wide_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send wide_stereo_l_stereo_camera_frame_lk :assoc wide_stereo_l_stereo_camera_optical_frame_lk)

       ;; writeTransform(name=wide_stereo_r_stereo_camera_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_r_stereo_camera_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=wide_stereo_r_stereo_camera_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=1,parent=wide_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_r_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) wide_stereo_l_stereo_camera_frame_lk)

       ;; writeTransform(name=wide_stereo_r_stereo_camera_frame_lk,domNode=wide_stereo_l_stereo_camera_frame,targetCount=2,parent=wide_stereo_l_stereo_camera_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send wide_stereo_l_stereo_camera_frame_lk :assoc wide_stereo_r_stereo_camera_frame_lk)
       )

     ;; node id=vkmodel0_node95, name=wide_stereo_optical_frame, sid=node95
     (let ()
       ;; define cascaded-coords for wide_stereo_optical_frame
       (setq wide_stereo_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "wide_stereo_optical_frame"))
        (progn (send wide_stereo_optical_frame_lk :weight 0.0) (send wide_stereo_optical_frame_lk :centroid (float-vector 0 0 0)) (send wide_stereo_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=wide_stereo_optical_frame_lk,domNode=wide_stereo_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send wide_stereo_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node94, name=wide_stereo_link, sid=node94
     (let ()
       ;; define bodyset-link for wide_stereo_link_lk
       (setq wide_stereo_link_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "wide_stereo_link"))
       (send wide_stereo_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.9219675205800002e+01 3.0581954459599999e+01 1.2807163111346999e+03) :rot (matrix-exponent (scale 1.6578770553785212e-02 (float-vector -4.4726399073674111e-01 -7.4956463541355667e-01 -4.8796288785888853e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (wide_stereo_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (wide_stereo_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=wide_stereo_link_lk,domNode=wide_stereo_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_link_lk :transform
             (make-coords :pos (float-vector 1.0000000000000000e+01 -0.0000000000000000e+00 -2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_link_lk :transform
             (make-coords :pos (float-vector 3.5089675205800006e+01 3.0581954459599999e+01 4.4091311134700000e+01)
                          :angle 1.6578770553785212e-02 :axis (float-vector -4.4726399073674111e-01 -7.4956463541355667e-01 -4.8796288785888853e-01)) :local)
       ;;1;

       ;; writeTransform(name=wide_stereo_l_stereo_camera_frame_lk,domNode=wide_stereo_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 1.0000000000000000e+01 -0.0000000000000000e+00 -2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 3.5089675205800006e+01 3.0581954459599999e+01 4.4091311134700000e+01)
                          :angle 1.6578770553785212e-02 :axis (float-vector -4.4726399073674111e-01 -7.4956463541355667e-01 -4.8796288785888853e-01)) :local)
       (send wide_stereo_l_stereo_camera_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=wide_stereo_l_stereo_camera_frame_lk,domNode=wide_stereo_link,targetCount=1,parent=wide_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_l_stereo_camera_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) wide_stereo_link_lk)

       ;; writeTransform(name=wide_stereo_l_stereo_camera_frame_lk,domNode=wide_stereo_link,targetCount=2,parent=wide_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send wide_stereo_link_lk :assoc wide_stereo_l_stereo_camera_frame_lk)

       ;; writeTransform(name=wide_stereo_optical_frame_lk,domNode=wide_stereo_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 1.0000000000000000e+01 -0.0000000000000000e+00 -2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 3.5089675205800006e+01 3.0581954459599999e+01 4.4091311134700000e+01)
                          :angle 1.6578770553785212e-02 :axis (float-vector -4.4726399073674111e-01 -7.4956463541355667e-01 -4.8796288785888853e-01)) :local)
       (send wide_stereo_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=wide_stereo_optical_frame_lk,domNode=wide_stereo_link,targetCount=1,parent=wide_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) wide_stereo_link_lk)

       ;; writeTransform(name=wide_stereo_optical_frame_lk,domNode=wide_stereo_link,targetCount=2,parent=wide_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send wide_stereo_link_lk :assoc wide_stereo_optical_frame_lk)
       )

     ;; node id=vkmodel0_node10, name=double_stereo_link, sid=node10
     (let ( b_gkmodel0_double_stereo_link_geom0)
       ;; define bodyset-link for double_stereo_link : vkmodel0_node10
       (setq b_gkmodel0_double_stereo_link_geom0 (instance pr2_gkmodel0_double_stereo_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_double_stereo_link_geom0,domNode=double_stereo_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -1.0000000000000000e+01 0.0000000000000000e+00 2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_double_stereo_link_geom0 :transform localcds :world)
       )
       (setq double_stereo_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_double_stereo_link_geom0)
                       :name "double_stereo_link"))
       (send double_stereo_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.4129999999999999e+01 0.0000000000000000e+00 1.2366250000000000e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (double_stereo_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (double_stereo_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=double_stereo_link_lk,domNode=double_stereo_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send double_stereo_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send double_stereo_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=narrow_stereo_link_lk,domNode=double_stereo_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send narrow_stereo_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=narrow_stereo_link_lk,domNode=double_stereo_link,targetCount=1,parent=double_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send narrow_stereo_link_lk :transform
             (make-coords :pos (float-vector -1.0000000000000000e+01 0.0000000000000000e+00 2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) double_stereo_link_lk)

       ;; writeTransform(name=narrow_stereo_link_lk,domNode=double_stereo_link,targetCount=2,parent=double_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send double_stereo_link_lk :assoc narrow_stereo_link_lk)

       ;; writeTransform(name=wide_stereo_link_lk,domNode=double_stereo_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send wide_stereo_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=wide_stereo_link_lk,domNode=double_stereo_link,targetCount=1,parent=double_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send wide_stereo_link_lk :transform
             (make-coords :pos (float-vector -1.0000000000000000e+01 0.0000000000000000e+00 2.5000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) double_stereo_link_lk)

       ;; writeTransform(name=wide_stereo_link_lk,domNode=double_stereo_link,targetCount=2,parent=double_stereo_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send double_stereo_link_lk :assoc wide_stereo_link_lk)
       )

     ;; node id=vkmodel0_node29, name=high_def_optical_frame, sid=node29
     (let ()
       ;; define cascaded-coords for high_def_optical_frame
       (setq high_def_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "high_def_optical_frame"))
       (send high_def_optical_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.7640579288500000e+01 -1.0750883907600000e+02 1.2866355484245998e+03) :rot (matrix-exponent (scale 2.0830015521432586e+00 (float-vector -5.7399236127280828e-01 5.7587403919013991e-01 -5.8215278079495536e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (high_def_optical_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (high_def_optical_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=high_def_optical_frame_lk,domNode=high_def_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send high_def_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node28, name=high_def_frame, sid=node28
     (let ()
       ;; define bodyset-link for high_def_frame_lk
       (setq high_def_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "high_def_frame"))
       (send high_def_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.7640579288500000e+01 -1.0750883907600000e+02 1.2866355484245998e+03) :rot (matrix-exponent (scale 1.5459898749864526e-02 (float-vector 2.6241560076007681e-01 -9.6353678731335879e-01 5.2296385836683182e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (high_def_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (high_def_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=high_def_frame_lk,domNode=high_def_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send high_def_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send high_def_frame_lk :transform
             (make-coords :pos (float-vector 2.3510579288499997e+01 -1.0750883907600000e+02 5.0010548424600003e+01)
                          :angle 1.5459898749864526e-02 :axis (float-vector 2.6241560076007681e-01 -9.6353678731335879e-01 5.2296385836683182e-02)) :local)
       ;;1;

       ;; writeTransform(name=high_def_optical_frame_lk,domNode=high_def_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.3510579288499997e+01 -1.0750883907600000e+02 5.0010548424600003e+01)
                          :angle 1.5459898749864526e-02 :axis (float-vector 2.6241560076007681e-01 -9.6353678731335879e-01 5.2296385836683182e-02)) :local)
       (send high_def_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=high_def_optical_frame_lk,domNode=high_def_frame,targetCount=1,parent=high_def_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send high_def_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) high_def_frame_lk)

       ;; writeTransform(name=high_def_optical_frame_lk,domNode=high_def_frame,targetCount=2,parent=high_def_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send high_def_frame_lk :assoc high_def_optical_frame_lk)
       )

     ;; node id=vkmodel0_node89, name=sensor_mount_link, sid=node89
     (let ( b_gkmodel0_sensor_mount_link_geom0)
       ;; define bodyset-link for sensor_mount_link : vkmodel0_node89
       (setq b_gkmodel0_sensor_mount_link_geom0 (instance pr2_gkmodel0_sensor_mount_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_sensor_mount_link_geom0,domNode=sensor_mount_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_sensor_mount_link_geom0 :transform localcds :world)
       )
       (setq sensor_mount_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_sensor_mount_link_geom0)
                       :name "sensor_mount_link"))
       (send sensor_mount_link_lk :weight 50.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.4129999999999999e+01 0.0000000000000000e+00 1.2366250000000000e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (sensor_mount_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (sensor_mount_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=sensor_mount_link_lk,domNode=sensor_mount_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send sensor_mount_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send sensor_mount_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=double_stereo_link_lk,domNode=sensor_mount_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send double_stereo_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=double_stereo_link_lk,domNode=sensor_mount_link,targetCount=1,parent=sensor_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send double_stereo_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) sensor_mount_link_lk)

       ;; writeTransform(name=double_stereo_link_lk,domNode=sensor_mount_link,targetCount=2,parent=sensor_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send sensor_mount_link_lk :assoc double_stereo_link_lk)

       ;; writeTransform(name=high_def_frame_lk,domNode=sensor_mount_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send high_def_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=high_def_frame_lk,domNode=sensor_mount_link,targetCount=1,parent=sensor_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send high_def_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) sensor_mount_link_lk)

       ;; writeTransform(name=high_def_frame_lk,domNode=sensor_mount_link,targetCount=2,parent=sensor_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send sensor_mount_link_lk :assoc high_def_frame_lk)
       )

     ;; node id=vkmodel0_node26, name=head_plate_frame, sid=node26
     (let ( b_gkmodel0_head_plate_frame_geom0)
       ;; define bodyset-link for head_plate_frame : vkmodel0_node26
       (setq b_gkmodel0_head_plate_frame_geom0 (instance pr2_gkmodel0_head_plate_frame_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_plate_frame_geom0,domNode=head_plate_frame,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_plate_frame_geom0 :transform localcds :world)
       )
       (setq head_plate_frame_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_plate_frame_geom0)
                       :name "head_plate_frame"))
       (send head_plate_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.4129999999999999e+01 0.0000000000000000e+00 1.2366250000000000e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_plate_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (head_plate_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_plate_frame_lk,domNode=head_plate_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_plate_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_plate_frame_lk :transform
             (make-coords :pos (float-vector 2.3199999999999999e+01 0.0000000000000000e+00 6.4500000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_mount_link_lk,domNode=head_plate_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.3199999999999999e+01 0.0000000000000000e+00 6.4500000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_mount_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_mount_link_lk,domNode=head_plate_frame,targetCount=1,parent=head_plate_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_mount_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_plate_frame_lk)

       ;; writeTransform(name=head_mount_link_lk,domNode=head_plate_frame,targetCount=2,parent=head_plate_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_plate_frame_lk :assoc head_mount_link_lk)

       ;; writeTransform(name=projector_wg6802418_frame_lk,domNode=head_plate_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.3199999999999999e+01 0.0000000000000000e+00 6.4500000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send projector_wg6802418_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=projector_wg6802418_frame_lk,domNode=head_plate_frame,targetCount=1,parent=head_plate_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send projector_wg6802418_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_plate_frame_lk)

       ;; writeTransform(name=projector_wg6802418_frame_lk,domNode=head_plate_frame,targetCount=2,parent=head_plate_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_plate_frame_lk :assoc projector_wg6802418_frame_lk)

       ;; writeTransform(name=sensor_mount_link_lk,domNode=head_plate_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 2.3199999999999999e+01 0.0000000000000000e+00 6.4500000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send sensor_mount_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=sensor_mount_link_lk,domNode=head_plate_frame,targetCount=1,parent=head_plate_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send sensor_mount_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_plate_frame_lk)

       ;; writeTransform(name=sensor_mount_link_lk,domNode=head_plate_frame,targetCount=2,parent=head_plate_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_plate_frame_lk :assoc sensor_mount_link_lk)
       )

     ;; node id=vkmodel0_node27, name=head_tilt_link, sid=node27
     (let ( b_gkmodel0_head_tilt_link_geom0)
       ;; define bodyset-link for head_tilt_link : vkmodel0_node27
       (setq b_gkmodel0_head_tilt_link_geom0 (instance pr2_gkmodel0_head_tilt_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_tilt_link_geom0,domNode=head_tilt_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_tilt_link_geom0 :transform localcds :world)
       )
       (setq head_tilt_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_tilt_link_geom0)
                       :name "head_tilt_link"))
       (send head_tilt_link_lk :weight 4479.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.6459999999999999e+00 -1.9556000000000001e+01 1.2271270000000002e+03) :rot (matrix-exponent (scale 2.1024989740774000e-01 (float-vector 9.9499278898660082e-01 6.7290737177335153e-03 9.9719955031914734e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_tilt_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 2.4210046119098920e+07 5.4142523398749791e+07 6.7900115482151285e+07))) (transpose (send tmp-c :worldrot))))
         (setq (head_tilt_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_tilt_link_lk,domNode=head_tilt_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_tilt_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_tilt_link_lk :transform
             (make-coords :pos (float-vector 6.8000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_chain_cb_link_lk,domNode=head_tilt_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 6.8000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_chain_cb_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_chain_cb_link_lk,domNode=head_tilt_link,targetCount=1,parent=head_tilt_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_chain_cb_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_tilt_link_lk)

       ;; writeTransform(name=head_chain_cb_link_lk,domNode=head_tilt_link,targetCount=2,parent=head_tilt_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_tilt_link_lk :assoc head_chain_cb_link_lk)

       ;; writeTransform(name=head_plate_frame_lk,domNode=head_tilt_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 6.8000000000000000e+01 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_plate_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_plate_frame_lk,domNode=head_tilt_link,targetCount=1,parent=head_tilt_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_plate_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_tilt_link_lk)

       ;; writeTransform(name=head_plate_frame_lk,domNode=head_tilt_link,targetCount=2,parent=head_tilt_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_tilt_link_lk :assoc head_plate_frame_lk)
       )

     ;; node id=vkmodel0_node25, name=head_pan_link, sid=node25
     (let ( b_gkmodel0_head_pan_link_geom0)
       ;; define bodyset-link for head_pan_link : vkmodel0_node25
       (setq b_gkmodel0_head_pan_link_geom0 (instance pr2_gkmodel0_head_pan_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_head_pan_link_geom0,domNode=head_pan_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_head_pan_link_geom0 :transform localcds :world)
       )
       (setq head_pan_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_head_pan_link_geom0)
                       :name "head_pan_link"))
       (send head_pan_link_lk :weight 6339.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -5.6162999999999997e+01 3.1692999999999998e+01 1.2626320000000001e+03) :rot (matrix-exponent (scale 2.3128589563762811e-01 (float-vector -8.4414835472481764e-01 -4.3468798032689138e-01 3.1378322927573971e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (head_pan_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2179798694053229e+07 4.6122618877570637e+07 5.8393525428376131e+07))) (transpose (send tmp-c :worldrot))))
         (setq (head_pan_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=head_pan_link_lk,domNode=head_pan_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send head_pan_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_pan_link_lk :transform
             (make-coords :pos (float-vector -1.7069999999999997e+01 0.0000000000000000e+00 3.8144999999999999e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_tilt_link_lk,domNode=head_pan_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -1.7069999999999997e+01 0.0000000000000000e+00 3.8144999999999999e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_tilt_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_tilt_link_lk,domNode=head_pan_link,targetCount=1,parent=head_pan_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send head_tilt_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) head_pan_link_lk)

       ;; writeTransform(name=head_tilt_link_lk,domNode=head_pan_link,targetCount=2,parent=head_pan_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send head_pan_link_lk :assoc head_tilt_link_lk)
       )

     ;; node id=vkmodel0_node30, name=imu_link, sid=node30
     (let ()
       ;; define cascaded-coords for imu_link
       (setq imu_link_lk (instance bodyset-link :init (make-cascoords) :name "imu_link"))
       (send imu_link_lk :weight 1.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -7.9770000000000010e+01 -1.4969999999999999e+02 9.5467500000000007e+02) :rot (matrix-exponent (scale 3.1415926535895875e+00 (float-vector -0.0000000000000000e+00 -1.0000000000000000e+00 -0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (imu_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+05 1.0000000000000000e+03 1.0000000000000000e+05))) (transpose (send tmp-c :worldrot))))
         (setq (imu_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=imu_link_lk,domNode=imu_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -2.9770000000000000e+01 -1.4969999999999999e+02 1.6400000000000000e+02)
                          :angle 3.1415926535895875e+00 :axis (float-vector 0.0000000000000000e+00 -1.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send imu_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node33, name=l_forearm_cam_optical_frame, sid=node33
     (let ()
       ;; define cascaded-coords for l_forearm_cam_optical_frame
       (setq l_forearm_cam_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "l_forearm_cam_optical_frame"))
        (progn (send l_forearm_cam_optical_frame_lk :weight 0.0) (send l_forearm_cam_optical_frame_lk :centroid (float-vector 0 0 0)) (send l_forearm_cam_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=l_forearm_cam_optical_frame_lk,domNode=l_forearm_cam_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send l_forearm_cam_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node32, name=l_forearm_cam_frame, sid=node32
     (let ()
       ;; define bodyset-link for l_forearm_cam_frame_lk
       (setq l_forearm_cam_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "l_forearm_cam_frame"))
       (send l_forearm_cam_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.8888260177999996e+02 2.0468654474639999e+02 8.3695536614599996e+02) :rot (matrix-exponent (scale 1.5802239628030832e+00 (float-vector -9.2931522451557047e-01 -2.4145871543610370e-01 -2.7941170738450000e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_forearm_cam_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (l_forearm_cam_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_forearm_cam_frame_lk,domNode=l_forearm_cam_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_cam_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_forearm_cam_frame_lk :transform
             (make-coords :pos (float-vector 1.3888260178000002e+02 1.6686544746399999e+01 4.6280366145999999e+01)
                          :angle 1.5802239628030832e+00 :axis (float-vector -9.2931522451557047e-01 -2.4145871543610370e-01 -2.7941170738450000e-01)) :local)
       ;;1;

       ;; writeTransform(name=l_forearm_cam_optical_frame_lk,domNode=l_forearm_cam_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.3888260178000002e+02 1.6686544746399999e+01 4.6280366145999999e+01)
                          :angle 1.5802239628030832e+00 :axis (float-vector -9.2931522451557047e-01 -2.4145871543610370e-01 -2.7941170738450000e-01)) :local)
       (send l_forearm_cam_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_forearm_cam_optical_frame_lk,domNode=l_forearm_cam_frame,targetCount=1,parent=l_forearm_cam_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_cam_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_forearm_cam_frame_lk)

       ;; writeTransform(name=l_forearm_cam_optical_frame_lk,domNode=l_forearm_cam_frame,targetCount=2,parent=l_forearm_cam_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_forearm_cam_frame_lk :assoc l_forearm_cam_optical_frame_lk)
       )

     ;; node id=vkmodel0_node38, name=l_gripper_l_finger_tip_link, sid=node38
     (let ( b_gkmodel0_l_gripper_l_finger_tip_link_geom0)
       ;; define bodyset-link for l_gripper_l_finger_tip_link : vkmodel0_node38
       (setq b_gkmodel0_l_gripper_l_finger_tip_link_geom0 (instance pr2_gkmodel0_l_gripper_l_finger_tip_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_gripper_l_finger_tip_link_geom0,domNode=l_gripper_l_finger_tip_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_gripper_l_finger_tip_link_geom0 :transform localcds :world)
       )
       (setq l_gripper_l_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_gripper_l_finger_tip_link_geom0)
                       :name "l_gripper_l_finger_tip_link"))
       (send l_gripper_l_finger_tip_link_lk :weight 44.190)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.4350999999999999e+02 2.0578999999999999e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 7.2148713900874673e-01 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_l_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2362449620368520e+03 1.5004895037963150e+04 1.5417679999999998e+04))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_l_finger_tip_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_l_finger_tip_link_lk,domNode=l_gripper_l_finger_tip_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_l_finger_tip_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_l_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 9.1370000000000005e+01 4.9500000000000002e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node36, name=l_gripper_l_finger_link, sid=node36
     (let ( b_gkmodel0_l_gripper_l_finger_link_geom0)
       ;; define bodyset-link for l_gripper_l_finger_link : vkmodel0_node36
       (setq b_gkmodel0_l_gripper_l_finger_link_geom0 (instance pr2_gkmodel0_l_gripper_l_finger_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_gripper_l_finger_link_geom0,domNode=l_gripper_l_finger_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_gripper_l_finger_link_geom0 :transform localcds :world)
       )
       (setq l_gripper_l_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_gripper_l_finger_link_geom0)
                       :name "l_gripper_l_finger_link"))
       (send l_gripper_l_finger_link_lk :weight 171.260)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.8388999999999999e+02 2.1529999999999998e+02 7.8903500000000008e+02) :rot (matrix-exponent (scale 1.7717054301322330e+00 (float-vector 9.9815325492233042e-01 3.3280713286308203e-02 5.0818046116628178e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_l_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 7.6623944609730534e+04 1.8133591439139261e+05 1.9773963099887679e+05))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_l_finger_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_l_finger_link_lk,domNode=l_gripper_l_finger_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_l_finger_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_l_finger_link_lk :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_gripper_l_finger_tip_link_lk,domNode=l_gripper_l_finger_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_l_finger_tip_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_l_finger_tip_link_lk,domNode=l_gripper_l_finger_link,targetCount=1,parent=l_gripper_l_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_l_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_l_finger_link_lk)

       ;; writeTransform(name=l_gripper_l_finger_tip_link_lk,domNode=l_gripper_l_finger_link,targetCount=2,parent=l_gripper_l_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_l_finger_link_lk :assoc l_gripper_l_finger_tip_link_lk)
       )

     ;; node id=vkmodel0_node39, name=l_gripper_led_frame, sid=node39
     (let ()
       ;; define cascaded-coords for l_gripper_led_frame
       (setq l_gripper_led_frame_lk (instance bodyset-link :init (make-cascoords) :name "l_gripper_led_frame"))
        (progn (send l_gripper_led_frame_lk :weight 0.0) (send l_gripper_led_frame_lk :centroid (float-vector 0 0 0)) (send l_gripper_led_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=l_gripper_led_frame_lk,domNode=l_gripper_led_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 5.1299999999999997e+01 0.0000000000000000e+00 2.4400000000000002e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_led_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node40, name=l_gripper_motor_accelerometer_link, sid=node40
     (let ( b_gkmodel0_l_gripper_motor_accelerometer_link_geom0)
       ;; define bodyset-link for l_gripper_motor_accelerometer_link : vkmodel0_node40
       (setq b_gkmodel0_l_gripper_motor_accelerometer_link_geom0 (instance pr2_gkmodel0_l_gripper_motor_accelerometer_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_gripper_motor_accelerometer_link_geom0,domNode=l_gripper_motor_accelerometer_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_gripper_motor_accelerometer_link_geom0 :transform localcds :world)
       )
       (setq l_gripper_motor_accelerometer_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_gripper_motor_accelerometer_link_geom0)
                       :name "l_gripper_motor_accelerometer_link"))
       (send l_gripper_motor_accelerometer_link_lk :weight 1.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_motor_accelerometer_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_motor_accelerometer_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_motor_accelerometer_link_lk,domNode=l_gripper_motor_accelerometer_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_motor_accelerometer_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_motor_accelerometer_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node41, name=l_gripper_motor_screw_link, sid=node41
     (let ()
       ;; define cascaded-coords for l_gripper_motor_screw_link
       (setq l_gripper_motor_screw_link_lk (instance bodyset-link :init (make-cascoords) :name "l_gripper_motor_screw_link"))
       (send l_gripper_motor_screw_link_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.3927999999999997e+02 1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_motor_screw_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+05 1.0000000000000000e+05 1.0000000000000000e+05))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_motor_screw_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_motor_screw_link_lk,domNode=l_gripper_motor_screw_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_motor_screw_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node42, name=l_gripper_motor_slider_link, sid=node42
     (let ()
       ;; define bodyset-link for l_gripper_motor_slider_link_lk
       (setq l_gripper_motor_slider_link_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "l_gripper_motor_slider_link"))
       (send l_gripper_motor_slider_link_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.3927999999999997e+02 1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_motor_slider_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_motor_slider_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_motor_slider_link_lk,domNode=l_gripper_motor_slider_link,targetCount=0,parent=:local), translateCount=4, rotateCount=3, matrixCount=0
       (send l_gripper_motor_slider_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_motor_slider_link_lk :transform
             (make-coords :pos (float-vector 1.6828000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_gripper_motor_screw_link_lk,domNode=l_gripper_motor_slider_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.6828000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_motor_screw_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_motor_screw_link_lk,domNode=l_gripper_motor_slider_link,targetCount=1,parent=l_gripper_motor_slider_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send l_gripper_motor_screw_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_motor_slider_link_lk)

       ;; writeTransform(name=l_gripper_motor_screw_link_lk,domNode=l_gripper_motor_slider_link,targetCount=2,parent=l_gripper_motor_slider_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=l_gripper_motor_screw_link_lk,domNode=l_gripper_motor_slider_link,targetCount=3,parent=l_gripper_motor_slider_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send l_gripper_motor_slider_link_lk :assoc l_gripper_motor_screw_link_lk)
       )

     ;; node id=vkmodel0_node37, name=l_gripper_l_finger_tip_frame, sid=node37
     (let ()
       ;; define cascaded-coords for l_gripper_l_finger_tip_frame
       (setq l_gripper_l_finger_tip_frame_lk (instance bodyset-link :init (make-cascoords) :name "l_gripper_l_finger_tip_frame"))
        (progn (send l_gripper_l_finger_tip_frame_lk :weight 0.0) (send l_gripper_l_finger_tip_frame_lk :centroid (float-vector 0 0 0)) (send l_gripper_l_finger_tip_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=l_gripper_l_finger_tip_frame_lk,domNode=l_gripper_l_finger_tip_frame,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 -0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_l_finger_tip_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node45, name=l_gripper_r_finger_tip_link, sid=node45
     (let ( b_gkmodel0_l_gripper_r_finger_tip_link_geom0)
       ;; define bodyset-link for l_gripper_r_finger_tip_link : vkmodel0_node45
       (setq b_gkmodel0_l_gripper_r_finger_tip_link_geom0 (instance pr2_gkmodel0_l_gripper_r_finger_tip_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_gripper_r_finger_tip_link_geom0,domNode=l_gripper_r_finger_tip_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_gripper_r_finger_tip_link_geom0 :transform localcds :world)
       )
       (setq l_gripper_r_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_gripper_r_finger_tip_link_geom0)
                       :name "l_gripper_r_finger_tip_link"))
       (send l_gripper_r_finger_tip_link_lk :weight 44.190)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.4350999999999999e+02 1.7021000000000001e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 7.2148713900874673e-01 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_r_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2362449620368520e+03 1.5004895037963150e+04 1.5417679999999998e+04))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_r_finger_tip_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_r_finger_tip_link_lk,domNode=l_gripper_r_finger_tip_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_r_finger_tip_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 -0.0000000000000000e+00)) :local)
       (send l_gripper_r_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 9.1370000000000005e+01 -4.9500000000000002e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_gripper_l_finger_tip_frame_lk,domNode=l_gripper_r_finger_tip_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 -0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 9.1370000000000005e+01 -4.9500000000000002e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_l_finger_tip_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_l_finger_tip_frame_lk,domNode=l_gripper_r_finger_tip_link,targetCount=1,parent=l_gripper_r_finger_tip_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_l_finger_tip_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_r_finger_tip_link_lk)

       ;; writeTransform(name=l_gripper_l_finger_tip_frame_lk,domNode=l_gripper_r_finger_tip_link,targetCount=2,parent=l_gripper_r_finger_tip_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_r_finger_tip_link_lk :assoc l_gripper_l_finger_tip_frame_lk)
       )

     ;; node id=vkmodel0_node44, name=l_gripper_r_finger_link, sid=node44
     (let ( b_gkmodel0_l_gripper_r_finger_link_geom0)
       ;; define bodyset-link for l_gripper_r_finger_link : vkmodel0_node44
       (setq b_gkmodel0_l_gripper_r_finger_link_geom0 (instance pr2_gkmodel0_l_gripper_r_finger_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_gripper_r_finger_link_geom0,domNode=l_gripper_r_finger_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_gripper_r_finger_link_geom0 :transform localcds :world)
       )
       (setq l_gripper_r_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_gripper_r_finger_link_geom0)
                       :name "l_gripper_r_finger_link"))
       (send l_gripper_r_finger_link_lk :weight 173.890)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.8366999999999996e+02 1.6064000000000001e+02 7.8972500000000002e+02) :rot (matrix-exponent (scale 1.4218414509258943e+00 (float-vector 9.9806971201230776e-01 5.3984491916526822e-02 3.0700563450585590e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_r_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 7.6684670622283287e+04 1.8134000171817749e+05 1.9890313765953921e+05))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_r_finger_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_r_finger_link_lk,domNode=l_gripper_r_finger_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_r_finger_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_r_finger_link_lk :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 -1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_gripper_r_finger_tip_link_lk,domNode=l_gripper_r_finger_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 -1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_r_finger_tip_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_r_finger_tip_link_lk,domNode=l_gripper_r_finger_link,targetCount=1,parent=l_gripper_r_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_r_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_r_finger_link_lk)

       ;; writeTransform(name=l_gripper_r_finger_tip_link_lk,domNode=l_gripper_r_finger_link,targetCount=2,parent=l_gripper_r_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_r_finger_link_lk :assoc l_gripper_r_finger_tip_link_lk)
       )

     ;; node id=vkmodel0_node46, name=l_gripper_tool_frame, sid=node46
     (let ()
       ;; define cascaded-coords for l_gripper_tool_frame
       (setq l_gripper_tool_frame_lk (instance bodyset-link :init (make-cascoords) :name "l_gripper_tool_frame"))
        (progn (send l_gripper_tool_frame_lk :weight 0.0) (send l_gripper_tool_frame_lk :centroid (float-vector 0 0 0)) (send l_gripper_tool_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=l_gripper_tool_frame_lk,domNode=l_gripper_tool_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.8000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_tool_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node43, name=l_gripper_palm_link, sid=node43
     (let ( b_gkmodel0_l_gripper_palm_link_geom0)
       ;; define bodyset-link for l_gripper_palm_link : vkmodel0_node43
       (setq b_gkmodel0_l_gripper_palm_link_geom0 (instance pr2_gkmodel0_l_gripper_palm_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_gripper_palm_link_geom0,domNode=l_gripper_palm_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_gripper_palm_link_geom0 :transform localcds :world)
       )
       (setq l_gripper_palm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_gripper_palm_link_geom0)
                       :name "l_gripper_palm_link"))
       (send l_gripper_palm_link_lk :weight 580.070)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.3723000000000002e+02 1.8853000000000000e+02 7.8948500000000001e+02) :rot (matrix-exponent (scale 3.1386128378982598e+00 (float-vector 9.9970610705088270e-01 2.4226413985424290e-02 8.8339717915143713e-04))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_gripper_palm_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.5147110342667857e+05 6.7817787266766978e+05 8.6563651390565163e+05))) (transpose (send tmp-c :worldrot))))
         (setq (l_gripper_palm_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_gripper_palm_link_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_palm_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_palm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_gripper_l_finger_link_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_l_finger_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_l_finger_link_lk,domNode=l_gripper_palm_link,targetCount=1,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_l_finger_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_palm_link_lk)

       ;; writeTransform(name=l_gripper_l_finger_link_lk,domNode=l_gripper_palm_link,targetCount=2,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_palm_link_lk :assoc l_gripper_l_finger_link_lk)

       ;; writeTransform(name=l_gripper_led_frame_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_led_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_led_frame_lk,domNode=l_gripper_palm_link,targetCount=1,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_led_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_palm_link_lk)

       ;; writeTransform(name=l_gripper_led_frame_lk,domNode=l_gripper_palm_link,targetCount=2,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_palm_link_lk :assoc l_gripper_led_frame_lk)

       ;; writeTransform(name=l_gripper_motor_accelerometer_link_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_motor_accelerometer_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_motor_accelerometer_link_lk,domNode=l_gripper_palm_link,targetCount=1,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_motor_accelerometer_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_palm_link_lk)

       ;; writeTransform(name=l_gripper_motor_accelerometer_link_lk,domNode=l_gripper_palm_link,targetCount=2,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_palm_link_lk :assoc l_gripper_motor_accelerometer_link_lk)

       ;; writeTransform(name=l_gripper_motor_slider_link_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_motor_slider_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_motor_slider_link_lk,domNode=l_gripper_palm_link,targetCount=1,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_motor_slider_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_palm_link_lk)

       ;; writeTransform(name=l_gripper_motor_slider_link_lk,domNode=l_gripper_palm_link,targetCount=2,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_palm_link_lk :assoc l_gripper_motor_slider_link_lk)

       ;; writeTransform(name=l_gripper_r_finger_link_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_r_finger_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_r_finger_link_lk,domNode=l_gripper_palm_link,targetCount=1,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_r_finger_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_palm_link_lk)

       ;; writeTransform(name=l_gripper_r_finger_link_lk,domNode=l_gripper_palm_link,targetCount=2,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_palm_link_lk :assoc l_gripper_r_finger_link_lk)

       ;; writeTransform(name=l_gripper_tool_frame_lk,domNode=l_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_tool_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_tool_frame_lk,domNode=l_gripper_palm_link,targetCount=1,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_tool_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_gripper_palm_link_lk)

       ;; writeTransform(name=l_gripper_tool_frame_lk,domNode=l_gripper_palm_link,targetCount=2,parent=l_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_gripper_palm_link_lk :assoc l_gripper_tool_frame_lk)
       )

     ;; node id=vkmodel0_node56, name=left_arm_chain_cb_link, sid=node56
     (let ()
       ;; define cascaded-coords for left_arm_chain_cb_link
       (setq left_arm_chain_cb_link_lk (instance bodyset-link :init (make-cascoords) :name "left_arm_chain_cb_link"))
        (progn (send left_arm_chain_cb_link_lk :weight 0.0) (send left_arm_chain_cb_link_lk :centroid (float-vector 0 0 0)) (send left_arm_chain_cb_link_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=left_arm_chain_cb_link_lk,domNode=left_arm_chain_cb_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send left_arm_chain_cb_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node53, name=l_wrist_roll_link, sid=node53
     (let ( b_gkmodel0_l_wrist_roll_link_geom0)
       ;; define bodyset-link for l_wrist_roll_link : vkmodel0_node53
       (setq b_gkmodel0_l_wrist_roll_link_geom0 (instance pr2_gkmodel0_l_wrist_roll_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_wrist_roll_link_geom0,domNode=l_wrist_roll_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_wrist_roll_link_geom0 :transform localcds :world)
       )
       (setq l_wrist_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_wrist_roll_link_geom0)
                       :name "l_wrist_roll_link"))
       (send l_wrist_roll_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.7100000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_wrist_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (l_wrist_roll_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_wrist_roll_link_lk,domNode=l_wrist_roll_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_wrist_roll_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_wrist_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_gripper_palm_link_lk,domNode=l_wrist_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_gripper_palm_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_gripper_palm_link_lk,domNode=l_wrist_roll_link,targetCount=1,parent=l_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_gripper_palm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_wrist_roll_link_lk)

       ;; writeTransform(name=l_gripper_palm_link_lk,domNode=l_wrist_roll_link,targetCount=2,parent=l_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_wrist_roll_link_lk :assoc l_gripper_palm_link_lk)

       ;; writeTransform(name=left_arm_chain_cb_link_lk,domNode=l_wrist_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send left_arm_chain_cb_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=left_arm_chain_cb_link_lk,domNode=l_wrist_roll_link,targetCount=1,parent=l_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send left_arm_chain_cb_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_wrist_roll_link_lk)

       ;; writeTransform(name=left_arm_chain_cb_link_lk,domNode=l_wrist_roll_link,targetCount=2,parent=l_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_wrist_roll_link_lk :assoc left_arm_chain_cb_link_lk)
       )

     ;; node id=vkmodel0_node52, name=l_wrist_flex_link, sid=node52
     (let ( b_gkmodel0_l_wrist_flex_link_geom0)
       ;; define bodyset-link for l_wrist_flex_link : vkmodel0_node52
       (setq b_gkmodel0_l_wrist_flex_link_geom0 (instance pr2_gkmodel0_l_wrist_flex_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_wrist_flex_link_geom0,domNode=l_wrist_flex_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_wrist_flex_link_geom0 :transform localcds :world)
       )
       (setq l_wrist_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_wrist_flex_link_geom0)
                       :name "l_wrist_flex_link"))
       (send l_wrist_flex_link_lk :weight 614.020)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.6943000000000006e+02 1.8800000000000000e+02 7.8992499999999995e+02) :rot (matrix-exponent (scale 1.6020364257483304e+00 (float-vector -9.6984440751447565e-01 1.7207315992342950e-01 -1.7260548324680050e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_wrist_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.5277143381554517e+05 6.4339106681473507e+05 1.9824412936971989e+05))) (transpose (send tmp-c :worldrot))))
         (setq (l_wrist_flex_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_wrist_flex_link_lk,domNode=l_wrist_flex_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_wrist_flex_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_wrist_flex_link_lk :transform
             (make-coords :pos (float-vector 3.2100000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_wrist_roll_link_lk,domNode=l_wrist_flex_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 3.2100000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_wrist_roll_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_wrist_roll_link_lk,domNode=l_wrist_flex_link,targetCount=1,parent=l_wrist_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_wrist_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_wrist_flex_link_lk)

       ;; writeTransform(name=l_wrist_roll_link_lk,domNode=l_wrist_flex_link,targetCount=2,parent=l_wrist_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_wrist_flex_link_lk :assoc l_wrist_roll_link_lk)
       )

     ;; node id=vkmodel0_node34, name=l_forearm_link, sid=node34
     (let ( b_gkmodel0_l_forearm_link_geom0)
       ;; define bodyset-link for l_forearm_link : vkmodel0_node34
       (setq b_gkmodel0_l_forearm_link_geom0 (instance pr2_gkmodel0_l_forearm_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_forearm_link_geom0,domNode=l_forearm_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_forearm_link_geom0 :transform localcds :world)
       )
       (setq l_forearm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_forearm_link_geom0)
                       :name "l_forearm_link"))
       (send l_forearm_link_lk :weight 2579.680)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 6.3790999999999997e+02 1.8782999999999998e+02 7.8155499999999995e+02) :rot (matrix-exponent (scale 1.5779985754811521e+00 (float-vector -9.9924263837171390e-01 -2.5028657373233270e-02 2.9794562759500778e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_forearm_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.6089171216999060e+06 1.6632586642306661e+07 1.5077544915993441e+07))) (transpose (send tmp-c :worldrot))))
         (setq (l_forearm_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_forearm_link_lk,domNode=l_forearm_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_forearm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_wrist_flex_link_lk,domNode=l_forearm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_wrist_flex_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_wrist_flex_link_lk,domNode=l_forearm_link,targetCount=1,parent=l_forearm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_wrist_flex_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_forearm_link_lk)

       ;; writeTransform(name=l_wrist_flex_link_lk,domNode=l_forearm_link,targetCount=2,parent=l_forearm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_forearm_link_lk :assoc l_wrist_flex_link_lk)
       )

     ;; node id=vkmodel0_node35, name=l_forearm_roll_link, sid=node35
     (let ( b_gkmodel0_l_forearm_roll_link_geom0)
       ;; define bodyset-link for l_forearm_roll_link : vkmodel0_node35
       (setq b_gkmodel0_l_forearm_roll_link_geom0 (instance pr2_gkmodel0_l_forearm_roll_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_forearm_roll_link_geom0,domNode=l_forearm_roll_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_forearm_roll_link_geom0 :transform localcds :world)
       )
       (setq l_forearm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_forearm_roll_link_geom0)
                       :name "l_forearm_roll_link"))
       (send l_forearm_roll_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.5000000000000000e+02 1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_forearm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (l_forearm_roll_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_forearm_roll_link_lk,domNode=l_forearm_roll_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_roll_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_forearm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_forearm_cam_frame_lk,domNode=l_forearm_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_forearm_cam_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_forearm_cam_frame_lk,domNode=l_forearm_roll_link,targetCount=1,parent=l_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_cam_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_forearm_roll_link_lk)

       ;; writeTransform(name=l_forearm_cam_frame_lk,domNode=l_forearm_roll_link,targetCount=2,parent=l_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_forearm_roll_link_lk :assoc l_forearm_cam_frame_lk)

       ;; writeTransform(name=l_forearm_link_lk,domNode=l_forearm_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_forearm_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_forearm_link_lk,domNode=l_forearm_roll_link,targetCount=1,parent=l_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_forearm_roll_link_lk)

       ;; writeTransform(name=l_forearm_link_lk,domNode=l_forearm_roll_link,targetCount=2,parent=l_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_forearm_roll_link_lk :assoc l_forearm_link_lk)
       )

     ;; node id=vkmodel0_node31, name=l_elbow_flex_link, sid=node31
     (let ( b_gkmodel0_l_elbow_flex_link_geom0)
       ;; define bodyset-link for l_elbow_flex_link : vkmodel0_node31
       (setq b_gkmodel0_l_elbow_flex_link_geom0 (instance pr2_gkmodel0_l_elbow_flex_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_elbow_flex_link_geom0,domNode=l_elbow_flex_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_elbow_flex_link_geom0 :transform localcds :world)
       )
       (setq l_elbow_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_elbow_flex_link_geom0)
                       :name "l_elbow_flex_link"))
       (send l_elbow_flex_link_lk :weight 1903.270)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.6013999999999999e+02 1.8831999999999999e+02 7.7856500000000005e+02) :rot (matrix-exponent (scale 1.6725322467090611e+00 (float-vector -8.8216660002903247e-01 -3.1469906779613738e-01 3.5035208936362727e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_elbow_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.0897687844015122e+06 3.9647676565655996e+06 4.4185162390328888e+06))) (transpose (send tmp-c :worldrot))))
         (setq (l_elbow_flex_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_elbow_flex_link_lk,domNode=l_elbow_flex_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_elbow_flex_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_elbow_flex_link_lk :transform
             (make-coords :pos (float-vector 4.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_forearm_roll_link_lk,domNode=l_elbow_flex_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 4.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_forearm_roll_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_forearm_roll_link_lk,domNode=l_elbow_flex_link,targetCount=1,parent=l_elbow_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_forearm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_elbow_flex_link_lk)

       ;; writeTransform(name=l_forearm_roll_link_lk,domNode=l_elbow_flex_link,targetCount=2,parent=l_elbow_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_elbow_flex_link_lk :assoc l_forearm_roll_link_lk)
       )

     ;; node id=vkmodel0_node50, name=l_upper_arm_link, sid=node50
     (let ( b_gkmodel0_l_upper_arm_link_geom0)
       ;; define bodyset-link for l_upper_arm_link : vkmodel0_node50
       (setq b_gkmodel0_l_upper_arm_link_geom0 (instance pr2_gkmodel0_l_upper_arm_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_upper_arm_link_geom0,domNode=l_upper_arm_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_upper_arm_link_geom0 :transform localcds :world)
       )
       (setq l_upper_arm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_upper_arm_link_geom0)
                       :name "l_upper_arm_link"))
       (send l_upper_arm_link_lk :weight 6017.690)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.6405000000000001e+02 2.0458000000000001e+02 7.9010500000000002e+02) :rot (matrix-exponent (scale 2.9396688916327878e+00 (float-vector 9.9958039678309218e-01 2.7905178662063941e-02 -7.7673271332098217e-03))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_upper_arm_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.5107107160877610e+07 7.4882121073444739e+07 7.6069696785677627e+07))) (transpose (send tmp-c :worldrot))))
         (setq (l_upper_arm_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_upper_arm_link_lk,domNode=l_upper_arm_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_upper_arm_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_upper_arm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_elbow_flex_link_lk,domNode=l_upper_arm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_elbow_flex_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_elbow_flex_link_lk,domNode=l_upper_arm_link,targetCount=1,parent=l_upper_arm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_elbow_flex_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_upper_arm_link_lk)

       ;; writeTransform(name=l_elbow_flex_link_lk,domNode=l_upper_arm_link,targetCount=2,parent=l_upper_arm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_upper_arm_link_lk :assoc l_elbow_flex_link_lk)
       )

     ;; node id=vkmodel0_node51, name=l_upper_arm_roll_link, sid=node51
     (let ( b_gkmodel0_l_upper_arm_roll_link_geom0)
       ;; define bodyset-link for l_upper_arm_roll_link : vkmodel0_node51
       (setq b_gkmodel0_l_upper_arm_roll_link_geom0 (instance pr2_gkmodel0_l_upper_arm_roll_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_upper_arm_roll_link_geom0,domNode=l_upper_arm_roll_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_upper_arm_roll_link_geom0 :transform localcds :world)
       )
       (setq l_upper_arm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_upper_arm_roll_link_geom0)
                       :name "l_upper_arm_roll_link"))
       (send l_upper_arm_roll_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.0000000000000000e+01 1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_upper_arm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (l_upper_arm_roll_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_upper_arm_roll_link_lk,domNode=l_upper_arm_roll_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_upper_arm_roll_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_upper_arm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_upper_arm_link_lk,domNode=l_upper_arm_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_upper_arm_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_upper_arm_link_lk,domNode=l_upper_arm_roll_link,targetCount=1,parent=l_upper_arm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_upper_arm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_upper_arm_roll_link_lk)

       ;; writeTransform(name=l_upper_arm_link_lk,domNode=l_upper_arm_roll_link,targetCount=2,parent=l_upper_arm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_upper_arm_roll_link_lk :assoc l_upper_arm_link_lk)
       )

     ;; node id=vkmodel0_node47, name=l_shoulder_lift_link, sid=node47
     (let ( b_gkmodel0_l_shoulder_lift_link_geom0)
       ;; define bodyset-link for l_shoulder_lift_link : vkmodel0_node47
       (setq b_gkmodel0_l_shoulder_lift_link_geom0 (instance pr2_gkmodel0_l_shoulder_lift_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_shoulder_lift_link_geom0,domNode=l_shoulder_lift_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_shoulder_lift_link_geom0 :transform localcds :world)
       )
       (setq l_shoulder_lift_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_shoulder_lift_link_geom0)
                       :name "l_shoulder_lift_link"))
       (send l_shoulder_lift_link_lk :weight 2749.880)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.1950000000000003e+01 1.6136000000000001e+02 7.5940499999999997e+02) :rot (matrix-exponent (scale 2.5410867772154906e+00 (float-vector 2.5017691190252062e-01 -5.0040076428166858e-01 8.2886101842060378e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_shoulder_lift_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 2.6187368693981059e+07 2.0730163313329030e+07 1.5168089652689921e+07))) (transpose (send tmp-c :worldrot))))
         (setq (l_shoulder_lift_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_shoulder_lift_link_lk,domNode=l_shoulder_lift_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_shoulder_lift_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_shoulder_lift_link_lk :transform
             (make-coords :pos (float-vector 1.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_upper_arm_roll_link_lk,domNode=l_shoulder_lift_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_upper_arm_roll_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_upper_arm_roll_link_lk,domNode=l_shoulder_lift_link,targetCount=1,parent=l_shoulder_lift_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_upper_arm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_shoulder_lift_link_lk)

       ;; writeTransform(name=l_upper_arm_roll_link_lk,domNode=l_shoulder_lift_link,targetCount=2,parent=l_shoulder_lift_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_shoulder_lift_link_lk :assoc l_upper_arm_roll_link_lk)
       )

     ;; node id=vkmodel0_node48, name=l_shoulder_pan_link, sid=node48
     (let ( b_gkmodel0_l_shoulder_pan_link_geom0)
       ;; define bodyset-link for l_shoulder_pan_link : vkmodel0_node48
       (setq b_gkmodel0_l_shoulder_pan_link_geom0 (instance pr2_gkmodel0_l_shoulder_pan_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_l_shoulder_pan_link_geom0,domNode=l_shoulder_pan_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_l_shoulder_pan_link_geom0 :transform localcds :world)
       )
       (setq l_shoulder_pan_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_l_shoulder_pan_link_geom0)
                       :name "l_shoulder_pan_link"))
       (send l_shoulder_pan_link_lk :weight 25799.322)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -5.1201000000000001e+01 2.1251300000000001e+02 6.9244400000000007e+02) :rot (matrix-exponent (scale 7.6635123664586935e-01 (float-vector 2.3445760813806441e-01 -1.9808997642959120e-01 9.5172999911965683e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_shoulder_pan_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 9.3420134354104972e+08 8.3770052521175265e+08 2.4203263939719772e+08))) (transpose (send tmp-c :worldrot))))
         (setq (l_shoulder_pan_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_shoulder_pan_link_lk,domNode=l_shoulder_pan_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send l_shoulder_pan_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_shoulder_pan_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 1.8800000000000000e+02 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=l_shoulder_lift_link_lk,domNode=l_shoulder_pan_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 1.8800000000000000e+02 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_shoulder_lift_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_shoulder_lift_link_lk,domNode=l_shoulder_pan_link,targetCount=1,parent=l_shoulder_pan_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send l_shoulder_lift_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) l_shoulder_pan_link_lk)

       ;; writeTransform(name=l_shoulder_lift_link_lk,domNode=l_shoulder_pan_link,targetCount=2,parent=l_shoulder_pan_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send l_shoulder_pan_link_lk :assoc l_shoulder_lift_link_lk)
       )

     ;; node id=vkmodel0_node49, name=l_torso_lift_side_plate_link, sid=node49
     (let ()
       ;; define cascaded-coords for l_torso_lift_side_plate_link
       (setq l_torso_lift_side_plate_link_lk (instance bodyset-link :init (make-cascoords) :name "l_torso_lift_side_plate_link"))
       (send l_torso_lift_side_plate_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -5.9000000000000000e+01 2.0928500000000000e+02 1.0173000000000001e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (l_torso_lift_side_plate_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (l_torso_lift_side_plate_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=l_torso_lift_side_plate_link_lk,domNode=l_torso_lift_side_plate_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 5.3500000000000000e+01 2.0928500000000000e+02 1.7662500000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_torso_lift_side_plate_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node54, name=laser_tilt_link, sid=node54
     (let ()
       ;; define cascaded-coords for laser_tilt_link
       (setq laser_tilt_link_lk (instance bodyset-link :init (make-cascoords) :name "laser_tilt_link"))
       (send laser_tilt_link_lk :weight 1.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.8930000000000000e+01 0.0000000000000000e+00 1.0468768892414998e+03) :rot (matrix-exponent (scale 1.0309330508599999e-02 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (laser_tilt_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+05 1.0000000000000000e+03 1.0000000000000000e+05))) (transpose (send tmp-c :worldrot))))
         (setq (laser_tilt_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=laser_tilt_link_lk,domNode=laser_tilt_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 2.9201889241499998e+01)
                          :angle 1.0309330508599999e-02 :axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00)) :local)
       (send laser_tilt_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node55, name=laser_tilt_mount_link, sid=node55
     (let ( b_gkmodel0_laser_tilt_mount_link_geom0)
       ;; define bodyset-link for laser_tilt_mount_link : vkmodel0_node55
       (setq b_gkmodel0_laser_tilt_mount_link_geom0 (instance pr2_gkmodel0_laser_tilt_mount_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_laser_tilt_mount_link_geom0,domNode=laser_tilt_mount_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_laser_tilt_mount_link_geom0 :transform localcds :world)
       )
       (setq laser_tilt_mount_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_laser_tilt_mount_link_geom0)
                       :name "laser_tilt_mount_link"))
       (send laser_tilt_mount_link_lk :weight 591.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.7794000000000004e+01 1.6700000000000002e+00 1.0105450000000001e+03) :rot (matrix-exponent (scale 2.6421957325871837e-01 (float-vector -3.8030945532861110e-01 3.6775231954706861e-01 -8.4860058311045594e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (laser_tilt_mount_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.2045714172574710e+06 1.0817501043531031e+06 7.8792147838942648e+05))) (transpose (send tmp-c :worldrot))))
         (setq (laser_tilt_mount_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=laser_tilt_mount_link_lk,domNode=laser_tilt_mount_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send laser_tilt_mount_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send laser_tilt_mount_link_lk :transform
             (make-coords :pos (float-vector 9.8930000000000007e+01 0.0000000000000000e+00 2.2700000000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=laser_tilt_link_lk,domNode=laser_tilt_mount_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 9.8930000000000007e+01 0.0000000000000000e+00 2.2700000000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send laser_tilt_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=laser_tilt_link_lk,domNode=laser_tilt_mount_link,targetCount=1,parent=laser_tilt_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send laser_tilt_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) laser_tilt_mount_link_lk)

       ;; writeTransform(name=laser_tilt_link_lk,domNode=laser_tilt_mount_link,targetCount=2,parent=laser_tilt_mount_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send laser_tilt_mount_link_lk :assoc laser_tilt_link_lk)
       )

     ;; node id=vkmodel0_node67, name=r_forearm_cam_optical_frame, sid=node67
     (let ()
       ;; define cascaded-coords for r_forearm_cam_optical_frame
       (setq r_forearm_cam_optical_frame_lk (instance bodyset-link :init (make-cascoords) :name "r_forearm_cam_optical_frame"))
        (progn (send r_forearm_cam_optical_frame_lk :weight 0.0) (send r_forearm_cam_optical_frame_lk :centroid (float-vector 0 0 0)) (send r_forearm_cam_optical_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=r_forearm_cam_optical_frame_lk,domNode=r_forearm_cam_optical_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 2.0943951023875425e+00 :axis (float-vector -5.7735026919056809e-01 5.7735026918774102e-01 -5.7735026919056809e-01)) :local)
       (send r_forearm_cam_optical_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node66, name=r_forearm_cam_frame, sid=node66
     (let ()
       ;; define bodyset-link for r_forearm_cam_frame_lk
       (setq r_forearm_cam_frame_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "r_forearm_cam_frame"))
       (send r_forearm_cam_frame_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.9278174482800000e+02 -2.0033502870120000e+02 8.2942074642509999e+02) :rot (matrix-exponent (scale 1.6466871642612548e+00 (float-vector 9.2520917047178552e-01 -2.6280242140047289e-01 2.7372043800373880e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_forearm_cam_frame_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (r_forearm_cam_frame_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_forearm_cam_frame_lk,domNode=r_forearm_cam_frame,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_cam_frame_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_forearm_cam_frame_lk :transform
             (make-coords :pos (float-vector 1.4278174482800000e+02 -1.2335028701200001e+01 3.8745746425100002e+01)
                          :angle 1.6466871642612548e+00 :axis (float-vector 9.2520917047178552e-01 -2.6280242140047289e-01 2.7372043800373880e-01)) :local)
       ;;1;

       ;; writeTransform(name=r_forearm_cam_optical_frame_lk,domNode=r_forearm_cam_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.4278174482800000e+02 -1.2335028701200001e+01 3.8745746425100002e+01)
                          :angle 1.6466871642612548e+00 :axis (float-vector 9.2520917047178552e-01 -2.6280242140047289e-01 2.7372043800373880e-01)) :local)
       (send r_forearm_cam_optical_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_forearm_cam_optical_frame_lk,domNode=r_forearm_cam_frame,targetCount=1,parent=r_forearm_cam_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_cam_optical_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_forearm_cam_frame_lk)

       ;; writeTransform(name=r_forearm_cam_optical_frame_lk,domNode=r_forearm_cam_frame,targetCount=2,parent=r_forearm_cam_frame_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_forearm_cam_frame_lk :assoc r_forearm_cam_optical_frame_lk)
       )

     ;; node id=vkmodel0_node72, name=r_gripper_l_finger_tip_link, sid=node72
     (let ( b_gkmodel0_r_gripper_l_finger_tip_link_geom0)
       ;; define bodyset-link for r_gripper_l_finger_tip_link : vkmodel0_node72
       (setq b_gkmodel0_r_gripper_l_finger_tip_link_geom0 (instance pr2_gkmodel0_r_gripper_l_finger_tip_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_gripper_l_finger_tip_link_geom0,domNode=r_gripper_l_finger_tip_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_gripper_l_finger_tip_link_geom0 :transform localcds :world)
       )
       (setq r_gripper_l_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_gripper_l_finger_tip_link_geom0)
                       :name "r_gripper_l_finger_tip_link"))
       (send r_gripper_l_finger_tip_link_lk :weight 44.190)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.4350999999999999e+02 -1.7021000000000001e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 7.2148713900874673e-01 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_l_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2362449620368520e+03 1.5004895037963150e+04 1.5417679999999998e+04))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_l_finger_tip_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_l_finger_tip_link_lk,domNode=r_gripper_l_finger_tip_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_l_finger_tip_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_l_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 9.1370000000000005e+01 4.9500000000000002e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node70, name=r_gripper_l_finger_link, sid=node70
     (let ( b_gkmodel0_r_gripper_l_finger_link_geom0)
       ;; define bodyset-link for r_gripper_l_finger_link : vkmodel0_node70
       (setq b_gkmodel0_r_gripper_l_finger_link_geom0 (instance pr2_gkmodel0_r_gripper_l_finger_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_gripper_l_finger_link_geom0,domNode=r_gripper_l_finger_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_gripper_l_finger_link_geom0 :transform localcds :world)
       )
       (setq r_gripper_l_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_gripper_l_finger_link_geom0)
                       :name "r_gripper_l_finger_link"))
       (send r_gripper_l_finger_link_lk :weight 171.260)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.8388999999999999e+02 -1.6070000000000002e+02 7.8903500000000008e+02) :rot (matrix-exponent (scale 1.7717054301322330e+00 (float-vector 9.9815325492233042e-01 3.3280713286308203e-02 5.0818046116628178e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_l_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 7.6623944609730534e+04 1.8133591439139261e+05 1.9773963099887679e+05))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_l_finger_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_l_finger_link_lk,domNode=r_gripper_l_finger_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_l_finger_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_l_finger_link_lk :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_gripper_l_finger_tip_link_lk,domNode=r_gripper_l_finger_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_l_finger_tip_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_l_finger_tip_link_lk,domNode=r_gripper_l_finger_link,targetCount=1,parent=r_gripper_l_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_l_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_l_finger_link_lk)

       ;; writeTransform(name=r_gripper_l_finger_tip_link_lk,domNode=r_gripper_l_finger_link,targetCount=2,parent=r_gripper_l_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_l_finger_link_lk :assoc r_gripper_l_finger_tip_link_lk)
       )

     ;; node id=vkmodel0_node73, name=r_gripper_led_frame, sid=node73
     (let ()
       ;; define cascaded-coords for r_gripper_led_frame
       (setq r_gripper_led_frame_lk (instance bodyset-link :init (make-cascoords) :name "r_gripper_led_frame"))
        (progn (send r_gripper_led_frame_lk :weight 0.0) (send r_gripper_led_frame_lk :centroid (float-vector 0 0 0)) (send r_gripper_led_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=r_gripper_led_frame_lk,domNode=r_gripper_led_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 5.1299999999999997e+01 0.0000000000000000e+00 2.4400000000000002e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_led_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node74, name=r_gripper_motor_accelerometer_link, sid=node74
     (let ( b_gkmodel0_r_gripper_motor_accelerometer_link_geom0)
       ;; define bodyset-link for r_gripper_motor_accelerometer_link : vkmodel0_node74
       (setq b_gkmodel0_r_gripper_motor_accelerometer_link_geom0 (instance pr2_gkmodel0_r_gripper_motor_accelerometer_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_gripper_motor_accelerometer_link_geom0,domNode=r_gripper_motor_accelerometer_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_gripper_motor_accelerometer_link_geom0 :transform localcds :world)
       )
       (setq r_gripper_motor_accelerometer_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_gripper_motor_accelerometer_link_geom0)
                       :name "r_gripper_motor_accelerometer_link"))
       (send r_gripper_motor_accelerometer_link_lk :weight 1.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_motor_accelerometer_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_motor_accelerometer_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_motor_accelerometer_link_lk,domNode=r_gripper_motor_accelerometer_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_motor_accelerometer_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_motor_accelerometer_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;
       )

     ;; node id=vkmodel0_node75, name=r_gripper_motor_screw_link, sid=node75
     (let ()
       ;; define cascaded-coords for r_gripper_motor_screw_link
       (setq r_gripper_motor_screw_link_lk (instance bodyset-link :init (make-cascoords) :name "r_gripper_motor_screw_link"))
       (send r_gripper_motor_screw_link_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.3927999999999997e+02 -1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_motor_screw_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+05 1.0000000000000000e+05 1.0000000000000000e+05))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_motor_screw_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_motor_screw_link_lk,domNode=r_gripper_motor_screw_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_motor_screw_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node76, name=r_gripper_motor_slider_link, sid=node76
     (let ()
       ;; define bodyset-link for r_gripper_motor_slider_link_lk
       (setq r_gripper_motor_slider_link_lk (instance bodyset-link :init (make-cascoords) :bodies (list (make-cube 10 10 10)) :name "r_gripper_motor_slider_link"))
       (send r_gripper_motor_slider_link_lk :weight 10.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.3927999999999997e+02 -1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_motor_slider_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_motor_slider_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_motor_slider_link_lk,domNode=r_gripper_motor_slider_link,targetCount=0,parent=:local), translateCount=4, rotateCount=3, matrixCount=0
       (send r_gripper_motor_slider_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_motor_slider_link_lk :transform
             (make-coords :pos (float-vector 1.6828000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_gripper_motor_screw_link_lk,domNode=r_gripper_motor_slider_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.6828000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_motor_screw_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_motor_screw_link_lk,domNode=r_gripper_motor_slider_link,targetCount=1,parent=r_gripper_motor_slider_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send r_gripper_motor_screw_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_motor_slider_link_lk)

       ;; writeTransform(name=r_gripper_motor_screw_link_lk,domNode=r_gripper_motor_slider_link,targetCount=2,parent=r_gripper_motor_slider_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=r_gripper_motor_screw_link_lk,domNode=r_gripper_motor_slider_link,targetCount=3,parent=r_gripper_motor_slider_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send r_gripper_motor_slider_link_lk :assoc r_gripper_motor_screw_link_lk)
       )

     ;; node id=vkmodel0_node71, name=r_gripper_l_finger_tip_frame, sid=node71
     (let ()
       ;; define cascaded-coords for r_gripper_l_finger_tip_frame
       (setq r_gripper_l_finger_tip_frame_lk (instance bodyset-link :init (make-cascoords) :name "r_gripper_l_finger_tip_frame"))
        (progn (send r_gripper_l_finger_tip_frame_lk :weight 0.0) (send r_gripper_l_finger_tip_frame_lk :centroid (float-vector 0 0 0)) (send r_gripper_l_finger_tip_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=r_gripper_l_finger_tip_frame_lk,domNode=r_gripper_l_finger_tip_frame,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 -0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_l_finger_tip_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node79, name=r_gripper_r_finger_tip_link, sid=node79
     (let ( b_gkmodel0_r_gripper_r_finger_tip_link_geom0)
       ;; define bodyset-link for r_gripper_r_finger_tip_link : vkmodel0_node79
       (setq b_gkmodel0_r_gripper_r_finger_tip_link_geom0 (instance pr2_gkmodel0_r_gripper_r_finger_tip_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_gripper_r_finger_tip_link_geom0,domNode=r_gripper_r_finger_tip_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_gripper_r_finger_tip_link_geom0 :transform localcds :world)
       )
       (setq r_gripper_r_finger_tip_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_gripper_r_finger_tip_link_geom0)
                       :name "r_gripper_r_finger_tip_link"))
       (send r_gripper_r_finger_tip_link_lk :weight 44.190)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 9.4350999999999999e+02 -2.0578999999999999e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 7.2148713900874673e-01 (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_r_finger_tip_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.2362449620368520e+03 1.5004895037963150e+04 1.5417679999999998e+04))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_r_finger_tip_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_r_finger_tip_link_lk,domNode=r_gripper_r_finger_tip_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_r_finger_tip_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 -0.0000000000000000e+00)) :local)
       (send r_gripper_r_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 9.1370000000000005e+01 -4.9500000000000002e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_gripper_l_finger_tip_frame_lk,domNode=r_gripper_r_finger_tip_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 -0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 9.1370000000000005e+01 -4.9500000000000002e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_l_finger_tip_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_l_finger_tip_frame_lk,domNode=r_gripper_r_finger_tip_link,targetCount=1,parent=r_gripper_r_finger_tip_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_l_finger_tip_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_r_finger_tip_link_lk)

       ;; writeTransform(name=r_gripper_l_finger_tip_frame_lk,domNode=r_gripper_r_finger_tip_link,targetCount=2,parent=r_gripper_r_finger_tip_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_r_finger_tip_link_lk :assoc r_gripper_l_finger_tip_frame_lk)
       )

     ;; node id=vkmodel0_node78, name=r_gripper_r_finger_link, sid=node78
     (let ( b_gkmodel0_r_gripper_r_finger_link_geom0)
       ;; define bodyset-link for r_gripper_r_finger_link : vkmodel0_node78
       (setq b_gkmodel0_r_gripper_r_finger_link_geom0 (instance pr2_gkmodel0_r_gripper_r_finger_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_gripper_r_finger_link_geom0,domNode=r_gripper_r_finger_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_gripper_r_finger_link_geom0 :transform localcds :world)
       )
       (setq r_gripper_r_finger_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_gripper_r_finger_link_geom0)
                       :name "r_gripper_r_finger_link"))
       (send r_gripper_r_finger_link_lk :weight 173.890)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.8366999999999996e+02 -2.1535999999999999e+02 7.8972500000000002e+02) :rot (matrix-exponent (scale 1.4218414509258943e+00 (float-vector 9.9806971201230776e-01 5.3984491916526822e-02 3.0700563450585590e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_r_finger_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 7.6684670622283287e+04 1.8134000171817749e+05 1.9890313765953921e+05))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_r_finger_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_r_finger_link_lk,domNode=r_gripper_r_finger_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_r_finger_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_r_finger_link_lk :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 -1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_gripper_r_finger_tip_link_lk,domNode=r_gripper_r_finger_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 7.6910000000000011e+01 -1.0000000000000000e+01 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_r_finger_tip_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_r_finger_tip_link_lk,domNode=r_gripper_r_finger_link,targetCount=1,parent=r_gripper_r_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_r_finger_tip_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 3.1415926535895875e+00 :axis (float-vector -1.0000000000000000e+00 -0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_r_finger_link_lk)

       ;; writeTransform(name=r_gripper_r_finger_tip_link_lk,domNode=r_gripper_r_finger_link,targetCount=2,parent=r_gripper_r_finger_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_r_finger_link_lk :assoc r_gripper_r_finger_tip_link_lk)
       )

     ;; node id=vkmodel0_node80, name=r_gripper_tool_frame, sid=node80
     (let ()
       ;; define cascaded-coords for r_gripper_tool_frame
       (setq r_gripper_tool_frame_lk (instance bodyset-link :init (make-cascoords) :name "r_gripper_tool_frame"))
        (progn (send r_gripper_tool_frame_lk :weight 0.0) (send r_gripper_tool_frame_lk :centroid (float-vector 0 0 0)) (send r_gripper_tool_frame_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=r_gripper_tool_frame_lk,domNode=r_gripper_tool_frame,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.8000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_tool_frame_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node77, name=r_gripper_palm_link, sid=node77
     (let ( b_gkmodel0_r_gripper_palm_link_geom0)
       ;; define bodyset-link for r_gripper_palm_link : vkmodel0_node77
       (setq b_gkmodel0_r_gripper_palm_link_geom0 (instance pr2_gkmodel0_r_gripper_palm_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_gripper_palm_link_geom0,domNode=r_gripper_palm_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_gripper_palm_link_geom0 :transform localcds :world)
       )
       (setq r_gripper_palm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_gripper_palm_link_geom0)
                       :name "r_gripper_palm_link"))
       (send r_gripper_palm_link_lk :weight 580.070)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 8.3723000000000002e+02 -1.8747000000000000e+02 7.8948500000000001e+02) :rot (matrix-exponent (scale 3.1386128378982598e+00 (float-vector 9.9970610705088270e-01 2.4226413985424290e-02 8.8339717915143713e-04))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_gripper_palm_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.5147110342667857e+05 6.7817787266766978e+05 8.6563651390565163e+05))) (transpose (send tmp-c :worldrot))))
         (setq (r_gripper_palm_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_gripper_palm_link_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_palm_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_palm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_gripper_l_finger_link_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_l_finger_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_l_finger_link_lk,domNode=r_gripper_palm_link,targetCount=1,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_l_finger_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_palm_link_lk)

       ;; writeTransform(name=r_gripper_l_finger_link_lk,domNode=r_gripper_palm_link,targetCount=2,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_palm_link_lk :assoc r_gripper_l_finger_link_lk)

       ;; writeTransform(name=r_gripper_led_frame_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_led_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_led_frame_lk,domNode=r_gripper_palm_link,targetCount=1,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_led_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_palm_link_lk)

       ;; writeTransform(name=r_gripper_led_frame_lk,domNode=r_gripper_palm_link,targetCount=2,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_palm_link_lk :assoc r_gripper_led_frame_lk)

       ;; writeTransform(name=r_gripper_motor_accelerometer_link_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_motor_accelerometer_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_motor_accelerometer_link_lk,domNode=r_gripper_palm_link,targetCount=1,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_motor_accelerometer_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_palm_link_lk)

       ;; writeTransform(name=r_gripper_motor_accelerometer_link_lk,domNode=r_gripper_palm_link,targetCount=2,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_palm_link_lk :assoc r_gripper_motor_accelerometer_link_lk)

       ;; writeTransform(name=r_gripper_motor_slider_link_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_motor_slider_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_motor_slider_link_lk,domNode=r_gripper_palm_link,targetCount=1,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_motor_slider_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_palm_link_lk)

       ;; writeTransform(name=r_gripper_motor_slider_link_lk,domNode=r_gripper_palm_link,targetCount=2,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_palm_link_lk :assoc r_gripper_motor_slider_link_lk)

       ;; writeTransform(name=r_gripper_r_finger_link_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_r_finger_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_r_finger_link_lk,domNode=r_gripper_palm_link,targetCount=1,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_r_finger_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_palm_link_lk)

       ;; writeTransform(name=r_gripper_r_finger_link_lk,domNode=r_gripper_palm_link,targetCount=2,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_palm_link_lk :assoc r_gripper_r_finger_link_lk)

       ;; writeTransform(name=r_gripper_tool_frame_lk,domNode=r_gripper_palm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_tool_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_tool_frame_lk,domNode=r_gripper_palm_link,targetCount=1,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_tool_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_gripper_palm_link_lk)

       ;; writeTransform(name=r_gripper_tool_frame_lk,domNode=r_gripper_palm_link,targetCount=2,parent=r_gripper_palm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_gripper_palm_link_lk :assoc r_gripper_tool_frame_lk)
       )

     ;; node id=vkmodel0_node88, name=right_arm_chain_cb_link, sid=node88
     (let ()
       ;; define cascaded-coords for right_arm_chain_cb_link
       (setq right_arm_chain_cb_link_lk (instance bodyset-link :init (make-cascoords) :name "right_arm_chain_cb_link"))
        (progn (send right_arm_chain_cb_link_lk :weight 0.0) (send right_arm_chain_cb_link_lk :centroid (float-vector 0 0 0)) (send right_arm_chain_cb_link_lk :inertia-tensor #2f((0 0 0)(0 0 0)(0 0 0))))

       ;; writeTransform(name=right_arm_chain_cb_link_lk,domNode=right_arm_chain_cb_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send right_arm_chain_cb_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node87, name=r_wrist_roll_link, sid=node87
     (let ( b_gkmodel0_r_wrist_roll_link_geom0)
       ;; define bodyset-link for r_wrist_roll_link : vkmodel0_node87
       (setq b_gkmodel0_r_wrist_roll_link_geom0 (instance pr2_gkmodel0_r_wrist_roll_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_wrist_roll_link_geom0,domNode=r_wrist_roll_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_wrist_roll_link_geom0 :transform localcds :world)
       )
       (setq r_wrist_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_wrist_roll_link_geom0)
                       :name "r_wrist_roll_link"))
       (send r_wrist_roll_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.7100000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_wrist_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (r_wrist_roll_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_wrist_roll_link_lk,domNode=r_wrist_roll_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_wrist_roll_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_wrist_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_gripper_palm_link_lk,domNode=r_wrist_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_gripper_palm_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_gripper_palm_link_lk,domNode=r_wrist_roll_link,targetCount=1,parent=r_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_gripper_palm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_wrist_roll_link_lk)

       ;; writeTransform(name=r_gripper_palm_link_lk,domNode=r_wrist_roll_link,targetCount=2,parent=r_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_wrist_roll_link_lk :assoc r_gripper_palm_link_lk)

       ;; writeTransform(name=right_arm_chain_cb_link_lk,domNode=r_wrist_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send right_arm_chain_cb_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=right_arm_chain_cb_link_lk,domNode=r_wrist_roll_link,targetCount=1,parent=r_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send right_arm_chain_cb_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_wrist_roll_link_lk)

       ;; writeTransform(name=right_arm_chain_cb_link_lk,domNode=r_wrist_roll_link,targetCount=2,parent=r_wrist_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_wrist_roll_link_lk :assoc right_arm_chain_cb_link_lk)
       )

     ;; node id=vkmodel0_node86, name=r_wrist_flex_link, sid=node86
     (let ( b_gkmodel0_r_wrist_flex_link_geom0)
       ;; define bodyset-link for r_wrist_flex_link : vkmodel0_node86
       (setq b_gkmodel0_r_wrist_flex_link_geom0 (instance pr2_gkmodel0_r_wrist_flex_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_wrist_flex_link_geom0,domNode=r_wrist_flex_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_wrist_flex_link_geom0 :transform localcds :world)
       )
       (setq r_wrist_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_wrist_flex_link_geom0)
                       :name "r_wrist_flex_link"))
       (send r_wrist_flex_link_lk :weight 614.020)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.6943000000000006e+02 -1.8800000000000000e+02 7.8992499999999995e+02) :rot (matrix-exponent (scale 1.6020364257483304e+00 (float-vector -9.6984440751447565e-01 1.7207315992342950e-01 -1.7260548324680050e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_wrist_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.5277143381554517e+05 6.4339106681473507e+05 1.9824412936971989e+05))) (transpose (send tmp-c :worldrot))))
         (setq (r_wrist_flex_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_wrist_flex_link_lk,domNode=r_wrist_flex_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_wrist_flex_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_wrist_flex_link_lk :transform
             (make-coords :pos (float-vector 3.2100000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_wrist_roll_link_lk,domNode=r_wrist_flex_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 3.2100000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_wrist_roll_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_wrist_roll_link_lk,domNode=r_wrist_flex_link,targetCount=1,parent=r_wrist_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_wrist_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_wrist_flex_link_lk)

       ;; writeTransform(name=r_wrist_roll_link_lk,domNode=r_wrist_flex_link,targetCount=2,parent=r_wrist_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_wrist_flex_link_lk :assoc r_wrist_roll_link_lk)
       )

     ;; node id=vkmodel0_node68, name=r_forearm_link, sid=node68
     (let ( b_gkmodel0_r_forearm_link_geom0)
       ;; define bodyset-link for r_forearm_link : vkmodel0_node68
       (setq b_gkmodel0_r_forearm_link_geom0 (instance pr2_gkmodel0_r_forearm_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_forearm_link_geom0,domNode=r_forearm_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_forearm_link_geom0 :transform localcds :world)
       )
       (setq r_forearm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_forearm_link_geom0)
                       :name "r_forearm_link"))
       (send r_forearm_link_lk :weight 2579.680)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 6.3790999999999997e+02 -1.8817000000000002e+02 7.8155499999999995e+02) :rot (matrix-exponent (scale 1.5779985754811521e+00 (float-vector -9.9924263837171390e-01 -2.5028657373233270e-02 2.9794562759500778e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_forearm_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.6089171216999060e+06 1.6632586642306661e+07 1.5077544915993441e+07))) (transpose (send tmp-c :worldrot))))
         (setq (r_forearm_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_forearm_link_lk,domNode=r_forearm_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_forearm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_wrist_flex_link_lk,domNode=r_forearm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_wrist_flex_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_wrist_flex_link_lk,domNode=r_forearm_link,targetCount=1,parent=r_forearm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_wrist_flex_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_forearm_link_lk)

       ;; writeTransform(name=r_wrist_flex_link_lk,domNode=r_forearm_link,targetCount=2,parent=r_forearm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_forearm_link_lk :assoc r_wrist_flex_link_lk)
       )

     ;; node id=vkmodel0_node69, name=r_forearm_roll_link, sid=node69
     (let ( b_gkmodel0_r_forearm_roll_link_geom0)
       ;; define bodyset-link for r_forearm_roll_link : vkmodel0_node69
       (setq b_gkmodel0_r_forearm_roll_link_geom0 (instance pr2_gkmodel0_r_forearm_roll_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_forearm_roll_link_geom0,domNode=r_forearm_roll_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_forearm_roll_link_geom0 :transform localcds :world)
       )
       (setq r_forearm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_forearm_roll_link_geom0)
                       :name "r_forearm_roll_link"))
       (send r_forearm_roll_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.5000000000000000e+02 -1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_forearm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (r_forearm_roll_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_forearm_roll_link_lk,domNode=r_forearm_roll_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_roll_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_forearm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_forearm_cam_frame_lk,domNode=r_forearm_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_forearm_cam_frame_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_forearm_cam_frame_lk,domNode=r_forearm_roll_link,targetCount=1,parent=r_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_cam_frame_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_forearm_roll_link_lk)

       ;; writeTransform(name=r_forearm_cam_frame_lk,domNode=r_forearm_roll_link,targetCount=2,parent=r_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_forearm_roll_link_lk :assoc r_forearm_cam_frame_lk)

       ;; writeTransform(name=r_forearm_link_lk,domNode=r_forearm_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_forearm_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_forearm_link_lk,domNode=r_forearm_roll_link,targetCount=1,parent=r_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_forearm_roll_link_lk)

       ;; writeTransform(name=r_forearm_link_lk,domNode=r_forearm_roll_link,targetCount=2,parent=r_forearm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_forearm_roll_link_lk :assoc r_forearm_link_lk)
       )

     ;; node id=vkmodel0_node65, name=r_elbow_flex_link, sid=node65
     (let ( b_gkmodel0_r_elbow_flex_link_geom0)
       ;; define bodyset-link for r_elbow_flex_link : vkmodel0_node65
       (setq b_gkmodel0_r_elbow_flex_link_geom0 (instance pr2_gkmodel0_r_elbow_flex_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_elbow_flex_link_geom0,domNode=r_elbow_flex_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_elbow_flex_link_geom0 :transform localcds :world)
       )
       (setq r_elbow_flex_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_elbow_flex_link_geom0)
                       :name "r_elbow_flex_link"))
       (send r_elbow_flex_link_lk :weight 1903.270)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 4.6013999999999999e+02 -1.8768000000000001e+02 7.7856500000000005e+02) :rot (matrix-exponent (scale 1.6725322467090611e+00 (float-vector -8.8216660002903247e-01 -3.1469906779613738e-01 3.5035208936362727e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_elbow_flex_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 3.0897687844015122e+06 3.9647676565655996e+06 4.4185162390328888e+06))) (transpose (send tmp-c :worldrot))))
         (setq (r_elbow_flex_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_elbow_flex_link_lk,domNode=r_elbow_flex_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_elbow_flex_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_elbow_flex_link_lk :transform
             (make-coords :pos (float-vector 4.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_forearm_roll_link_lk,domNode=r_elbow_flex_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 4.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_forearm_roll_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_forearm_roll_link_lk,domNode=r_elbow_flex_link,targetCount=1,parent=r_elbow_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_forearm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_elbow_flex_link_lk)

       ;; writeTransform(name=r_forearm_roll_link_lk,domNode=r_elbow_flex_link,targetCount=2,parent=r_elbow_flex_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_elbow_flex_link_lk :assoc r_forearm_roll_link_lk)
       )

     ;; node id=vkmodel0_node84, name=r_upper_arm_link, sid=node84
     (let ( b_gkmodel0_r_upper_arm_link_geom0)
       ;; define bodyset-link for r_upper_arm_link : vkmodel0_node84
       (setq b_gkmodel0_r_upper_arm_link_geom0 (instance pr2_gkmodel0_r_upper_arm_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_upper_arm_link_geom0,domNode=r_upper_arm_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_upper_arm_link_geom0 :transform localcds :world)
       )
       (setq r_upper_arm_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_upper_arm_link_geom0)
                       :name "r_upper_arm_link"))
       (send r_upper_arm_link_lk :weight 6017.690)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 2.6398000000000002e+02 -2.0421000000000001e+02 7.9047500000000002e+02) :rot (matrix-exponent (scale 1.9973601034355085e-01 (float-vector -9.4720967440641535e-01 8.6825510450977084e-02 3.0863435234241149e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_upper_arm_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.5132686535267271e+07 7.4930655272408560e+07 7.6138485232324168e+07))) (transpose (send tmp-c :worldrot))))
         (setq (r_upper_arm_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_upper_arm_link_lk,domNode=r_upper_arm_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_upper_arm_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_upper_arm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_elbow_flex_link_lk,domNode=r_upper_arm_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_elbow_flex_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_elbow_flex_link_lk,domNode=r_upper_arm_link,targetCount=1,parent=r_upper_arm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_elbow_flex_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_upper_arm_link_lk)

       ;; writeTransform(name=r_elbow_flex_link_lk,domNode=r_upper_arm_link,targetCount=2,parent=r_upper_arm_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_upper_arm_link_lk :assoc r_elbow_flex_link_lk)
       )

     ;; node id=vkmodel0_node85, name=r_upper_arm_roll_link, sid=node85
     (let ( b_gkmodel0_r_upper_arm_roll_link_geom0)
       ;; define bodyset-link for r_upper_arm_roll_link : vkmodel0_node85
       (setq b_gkmodel0_r_upper_arm_roll_link_geom0 (instance pr2_gkmodel0_r_upper_arm_roll_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_upper_arm_roll_link_geom0,domNode=r_upper_arm_roll_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_upper_arm_roll_link_geom0 :transform localcds :world)
       )
       (setq r_upper_arm_roll_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_upper_arm_roll_link_geom0)
                       :name "r_upper_arm_roll_link"))
       (send r_upper_arm_roll_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 5.0000000000000000e+01 -1.8800000000000000e+02 7.9067500000000007e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_upper_arm_roll_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (r_upper_arm_roll_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_upper_arm_roll_link_lk,domNode=r_upper_arm_roll_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_upper_arm_roll_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_upper_arm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_upper_arm_link_lk,domNode=r_upper_arm_roll_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_upper_arm_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_upper_arm_link_lk,domNode=r_upper_arm_roll_link,targetCount=1,parent=r_upper_arm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_upper_arm_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_upper_arm_roll_link_lk)

       ;; writeTransform(name=r_upper_arm_link_lk,domNode=r_upper_arm_roll_link,targetCount=2,parent=r_upper_arm_roll_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_upper_arm_roll_link_lk :assoc r_upper_arm_link_lk)
       )

     ;; node id=vkmodel0_node81, name=r_shoulder_lift_link, sid=node81
     (let ( b_gkmodel0_r_shoulder_lift_link_geom0)
       ;; define bodyset-link for r_shoulder_lift_link : vkmodel0_node81
       (setq b_gkmodel0_r_shoulder_lift_link_geom0 (instance pr2_gkmodel0_r_shoulder_lift_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_shoulder_lift_link_geom0,domNode=r_shoulder_lift_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_shoulder_lift_link_geom0 :transform localcds :world)
       )
       (setq r_shoulder_lift_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_shoulder_lift_link_geom0)
                       :name "r_shoulder_lift_link"))
       (send r_shoulder_lift_link_lk :weight 2749.880)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 7.1950000000000003e+01 -2.1463999999999999e+02 7.5940499999999997e+02) :rot (matrix-exponent (scale 2.5410867772154906e+00 (float-vector 2.5017691190252062e-01 -5.0040076428166858e-01 8.2886101842060378e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_shoulder_lift_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 2.6187368693981059e+07 2.0730163313329030e+07 1.5168089652689921e+07))) (transpose (send tmp-c :worldrot))))
         (setq (r_shoulder_lift_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_shoulder_lift_link_lk,domNode=r_shoulder_lift_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_shoulder_lift_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_shoulder_lift_link_lk :transform
             (make-coords :pos (float-vector 1.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_upper_arm_roll_link_lk,domNode=r_shoulder_lift_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 1.0000000000000000e+02 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_upper_arm_roll_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_upper_arm_roll_link_lk,domNode=r_shoulder_lift_link,targetCount=1,parent=r_shoulder_lift_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_upper_arm_roll_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_shoulder_lift_link_lk)

       ;; writeTransform(name=r_upper_arm_roll_link_lk,domNode=r_shoulder_lift_link,targetCount=2,parent=r_shoulder_lift_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_shoulder_lift_link_lk :assoc r_upper_arm_roll_link_lk)
       )

     ;; node id=vkmodel0_node82, name=r_shoulder_pan_link, sid=node82
     (let ( b_gkmodel0_r_shoulder_pan_link_geom0)
       ;; define bodyset-link for r_shoulder_pan_link : vkmodel0_node82
       (setq b_gkmodel0_r_shoulder_pan_link_geom0 (instance pr2_gkmodel0_r_shoulder_pan_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_r_shoulder_pan_link_geom0,domNode=r_shoulder_pan_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_r_shoulder_pan_link_geom0 :transform localcds :world)
       )
       (setq r_shoulder_pan_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_r_shoulder_pan_link_geom0)
                       :name "r_shoulder_pan_link"))
       (send r_shoulder_pan_link_lk :weight 25799.322)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -5.1201000000000001e+01 -1.6348699999999999e+02 6.9244400000000007e+02) :rot (matrix-exponent (scale 7.6635123664586935e-01 (float-vector 2.3445760813806441e-01 -1.9808997642959120e-01 9.5172999911965683e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_shoulder_pan_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 9.3420134354104972e+08 8.3770052521175265e+08 2.4203263939719772e+08))) (transpose (send tmp-c :worldrot))))
         (setq (r_shoulder_pan_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_shoulder_pan_link_lk,domNode=r_shoulder_pan_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send r_shoulder_pan_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_shoulder_pan_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -1.8800000000000000e+02 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=r_shoulder_lift_link_lk,domNode=r_shoulder_pan_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 -1.8800000000000000e+02 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_shoulder_lift_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_shoulder_lift_link_lk,domNode=r_shoulder_pan_link,targetCount=1,parent=r_shoulder_pan_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send r_shoulder_lift_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) r_shoulder_pan_link_lk)

       ;; writeTransform(name=r_shoulder_lift_link_lk,domNode=r_shoulder_pan_link,targetCount=2,parent=r_shoulder_pan_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send r_shoulder_pan_link_lk :assoc r_shoulder_lift_link_lk)
       )

     ;; node id=vkmodel0_node83, name=r_torso_lift_side_plate_link, sid=node83
     (let ()
       ;; define cascaded-coords for r_torso_lift_side_plate_link
       (setq r_torso_lift_side_plate_link_lk (instance bodyset-link :init (make-cascoords) :name "r_torso_lift_side_plate_link"))
       (send r_torso_lift_side_plate_link_lk :weight 100.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -5.9000000000000000e+01 -2.0928500000000000e+02 1.0173000000000001e+03) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (r_torso_lift_side_plate_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (r_torso_lift_side_plate_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=r_torso_lift_side_plate_link_lk,domNode=r_torso_lift_side_plate_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 5.3500000000000000e+01 -2.0928500000000000e+02 1.7662500000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_torso_lift_side_plate_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node90, name=torso_lift_link, sid=node90
     (let ( b_gkmodel0_torso_lift_link_geom0)
       ;; define bodyset-link for torso_lift_link : vkmodel0_node90
       (setq b_gkmodel0_torso_lift_link_geom0 (instance pr2_gkmodel0_torso_lift_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_torso_lift_link_geom0,domNode=torso_lift_link,targetCount=1,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_torso_lift_link_geom0 :transform localcds :world)
       )
       (setq torso_lift_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_torso_lift_link_geom0)
                       :name "torso_lift_link"))
       (send torso_lift_link_lk :weight 36248.046)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -1.5000000000000000e+02 0.0000000000000000e+00 7.0217499999999995e+02) :rot (matrix-exponent (scale 1.5568240654901644e+00 (float-vector 9.9871048154980702e-01 -3.1965195938106129e-02 -3.9441099010943392e-02))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (torso_lift_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 2.7830748220493426e+09 5.1458072243189913e+08 2.5104500693077579e+09))) (transpose (send tmp-c :worldrot))))
         (setq (torso_lift_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=torso_lift_link_lk,domNode=torso_lift_link,targetCount=0,parent=:local), translateCount=4, rotateCount=3, matrixCount=0
       (send torso_lift_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send torso_lift_link_lk :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=head_pan_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send head_pan_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=head_pan_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send head_pan_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=head_pan_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=head_pan_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc head_pan_link_lk)

       ;; writeTransform(name=imu_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send imu_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=imu_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send imu_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=imu_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=imu_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc imu_link_lk)

       ;; writeTransform(name=l_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_shoulder_pan_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send l_shoulder_pan_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=l_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=l_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc l_shoulder_pan_link_lk)

       ;; writeTransform(name=l_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send l_torso_lift_side_plate_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=l_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send l_torso_lift_side_plate_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=l_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=l_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc l_torso_lift_side_plate_link_lk)

       ;; writeTransform(name=laser_tilt_mount_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send laser_tilt_mount_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=laser_tilt_mount_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send laser_tilt_mount_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=laser_tilt_mount_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=laser_tilt_mount_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc laser_tilt_mount_link_lk)

       ;; writeTransform(name=r_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_shoulder_pan_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send r_shoulder_pan_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=r_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=r_shoulder_pan_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc r_shoulder_pan_link_lk)

       ;; writeTransform(name=r_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=0,parent=:world), translateCount=4, rotateCount=3, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -5.0000000000000000e+01 0.0000000000000000e+00 7.3967499999999995e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send r_torso_lift_side_plate_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=r_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=1,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       (send r_torso_lift_side_plate_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) torso_lift_link_lk)

       ;; writeTransform(name=r_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=2,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0

       ;; writeTransform(name=r_torso_lift_side_plate_link_lk,domNode=torso_lift_link,targetCount=3,parent=torso_lift_link_lk), translateCount=4, rotateCount=3, matrixCount=0
       ;;2;
       (send torso_lift_link_lk :assoc r_torso_lift_side_plate_link_lk)
       )

     ;; node id=vkmodel0_node91, name=torso_lift_motor_screw_link, sid=node91
     (let ()
       ;; define cascaded-coords for torso_lift_motor_screw_link
       (setq torso_lift_motor_screw_link_lk (instance bodyset-link :init (make-cascoords) :name "torso_lift_motor_screw_link"))
       (send torso_lift_motor_screw_link_lk :weight 1000.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -1.5000000000000000e+02 0.0000000000000000e+00 7.5100000000000000e+02) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (torso_lift_motor_screw_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+06 1.0000000000000000e+06 1.0000000000000000e+06))) (transpose (send tmp-c :worldrot))))
         (setq (torso_lift_motor_screw_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=torso_lift_motor_screw_link_lk,domNode=torso_lift_motor_screw_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector -1.5000000000000000e+02 0.0000000000000000e+00 7.0000000000000000e+02)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send torso_lift_motor_screw_link_lk :transform localcds :world)
       )
       ;;1;
       )

     ;; node id=vkmodel0_node3, name=base_link, sid=node3
     (let ( b_gkmodel0_base_link_geom0)
       ;; define bodyset-link for base_link : vkmodel0_node3
       (setq b_gkmodel0_base_link_geom0 (instance pr2_gkmodel0_base_link_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_base_link_geom0,domNode=base_link,targetCount=1,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send b_gkmodel0_base_link_geom0 :transform localcds :world)
       )
       (setq base_link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_base_link_geom0)
                       :name "base_link"))
       (send base_link_lk :weight 116000.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector -6.1000000000000000e+01 0.0000000000000000e+00 1.9750000000000000e+02) :rot (matrix-exponent (scale 1.6263618787863550e+00 (float-vector -9.4935602358248927e-01 2.3117598361086950e-01 -2.1279286898106139e-01))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (base_link_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 6.2938848215018797e+09 3.0417723116333189e+09 5.6692450764547997e+09))) (transpose (send tmp-c :worldrot))))
         (setq (base_link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=base_link_lk,domNode=base_link,targetCount=0,parent=:local), translateCount=3, rotateCount=4, matrixCount=0
       (send base_link_lk :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send base_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=base_bellow_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send base_bellow_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=base_bellow_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send base_bellow_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=base_bellow_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc base_bellow_link_lk)

       ;; writeTransform(name=base_laser_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send base_laser_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=base_laser_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send base_laser_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=base_laser_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc base_laser_link_lk)

       ;; writeTransform(name=bl_caster_rotation_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send bl_caster_rotation_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=bl_caster_rotation_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send bl_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=bl_caster_rotation_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc bl_caster_rotation_link_lk)

       ;; writeTransform(name=br_caster_rotation_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send br_caster_rotation_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=br_caster_rotation_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send br_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=br_caster_rotation_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc br_caster_rotation_link_lk)

       ;; writeTransform(name=fl_caster_rotation_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fl_caster_rotation_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=fl_caster_rotation_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send fl_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=fl_caster_rotation_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc fl_caster_rotation_link_lk)

       ;; writeTransform(name=fr_caster_rotation_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send fr_caster_rotation_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=fr_caster_rotation_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send fr_caster_rotation_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=fr_caster_rotation_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc fr_caster_rotation_link_lk)

       ;; writeTransform(name=torso_lift_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send torso_lift_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=torso_lift_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send torso_lift_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=torso_lift_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc torso_lift_link_lk)

       ;; writeTransform(name=torso_lift_motor_screw_link_lk,domNode=base_link,targetCount=0,parent=:world), translateCount=3, rotateCount=4, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -0.0000000000000000e+00 -0.0000000000000000e+00 -0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 5.1000000000000000e+01)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send torso_lift_motor_screw_link_lk :transform localcds :world)
       )

       ;; writeTransform(name=torso_lift_motor_screw_link_lk,domNode=base_link,targetCount=1,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       (send torso_lift_motor_screw_link_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) base_link_lk)

       ;; writeTransform(name=torso_lift_motor_screw_link_lk,domNode=base_link,targetCount=2,parent=base_link_lk), translateCount=3, rotateCount=4, matrixCount=0
       ;;2;
       (send base_link_lk :assoc torso_lift_motor_screw_link_lk)
       )

     ;; node id=vkmodel0_node1, name=base_footprint, sid=node1
     (let ( b_gkmodel0_base_footprint_geom0)
       ;; define bodyset-link for base_footprint : vkmodel0_node1
       (setq b_gkmodel0_base_footprint_geom0 (instance pr2_gkmodel0_base_footprint_geom0 :init))

       ;; writeTransform(name=b_gkmodel0_base_footprint_geom0,domNode=base_footprint,targetCount=1,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_gkmodel0_base_footprint_geom0 :transform localcds :world)
       )
       (setq base_footprint_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_gkmodel0_base_footprint_geom0)
                       :name "base_footprint"))
       (send base_footprint_lk :weight 1000.000)
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00) :rot (matrix-exponent (scale 0.0000000000000000e+00 (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (base_footprint_lk . inertia-tensor)
               (m* (m* (send tmp-c :worldrot) (diagonal (float-vector 1.0000000000000000e+07 1.0000000000000000e+07 1.0000000000000000e+07))) (transpose (send tmp-c :worldrot))))
         (setq (base_footprint_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=base_footprint_lk,domNode=base_footprint,targetCount=0,parent=:local), translateCount=1, rotateCount=1, matrixCount=0
       (send base_footprint_lk :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       ;;1;

       ;; writeTransform(name=base_link_lk,domNode=base_footprint,targetCount=0,parent=:world), translateCount=1, rotateCount=1, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)
                          :angle 0.0000000000000000e+00 :axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00)) :local)
       (send base_link_lk :transform localcds :world)
       )
       ;;2;
       (send base_footprint_lk :assoc base_link_lk)
       )

     (send self :assoc base_footprint_lk)
     (setq bl_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "bl_caster_l_wheel_joint"
                     :parent-link bl_caster_rotation_link_lk :child-link bl_caster_l_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq bl_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "bl_caster_r_wheel_joint"
                     :parent-link bl_caster_rotation_link_lk :child-link bl_caster_r_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq br_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "br_caster_l_wheel_joint"
                     :parent-link br_caster_rotation_link_lk :child-link br_caster_l_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq br_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "br_caster_r_wheel_joint"
                     :parent-link br_caster_rotation_link_lk :child-link br_caster_r_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq fl_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fl_caster_l_wheel_joint"
                     :parent-link fl_caster_rotation_link_lk :child-link fl_caster_l_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq fl_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fl_caster_r_wheel_joint"
                     :parent-link fl_caster_rotation_link_lk :child-link fl_caster_r_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq fr_caster_l_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fr_caster_l_wheel_joint"
                     :parent-link fr_caster_rotation_link_lk :child-link fr_caster_l_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq fr_caster_r_wheel_joint_jt
           (instance rotational-joint :init
                     :name "fr_caster_r_wheel_joint"
                     :parent-link fr_caster_rotation_link_lk :child-link fr_caster_r_wheel_link_lk
                     :max-joint-velocity 15.000000
                     :max-joint-torque 7.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq head_mount_kinect_rgb_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_rgb_optical_frame_joint"
                     :parent-link head_mount_kinect_rgb_link_lk :child-link head_mount_kinect_rgb_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_mount_kinect_ir_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_ir_optical_frame_joint"
                     :parent-link head_mount_kinect_ir_link_lk :child-link head_mount_kinect_ir_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_mount_kinect_rgb_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_rgb_joint"
                     :parent-link head_mount_kinect_ir_link_lk :child-link head_mount_kinect_rgb_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_mount_prosilica_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_prosilica_optical_frame_joint"
                     :parent-link head_mount_prosilica_link_lk :child-link head_mount_prosilica_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_mount_kinect_ir_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_kinect_ir_joint"
                     :parent-link head_mount_link_lk :child-link head_mount_kinect_ir_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_mount_prosilica_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_prosilica_joint"
                     :parent-link head_mount_link_lk :child-link head_mount_prosilica_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq projector_wg6802418_child_frame_joint_jt
           (instance rotational-joint :init
                     :name "projector_wg6802418_child_frame_joint"
                     :parent-link projector_wg6802418_frame_lk :child-link projector_wg6802418_child_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq narrow_stereo_r_stereo_camera_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_r_stereo_camera_optical_frame_joint"
                     :parent-link narrow_stereo_r_stereo_camera_frame_lk :child-link narrow_stereo_r_stereo_camera_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq narrow_stereo_l_stereo_camera_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_l_stereo_camera_optical_frame_joint"
                     :parent-link narrow_stereo_l_stereo_camera_frame_lk :child-link narrow_stereo_l_stereo_camera_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq narrow_stereo_r_stereo_camera_frame_joint_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_r_stereo_camera_frame_joint"
                     :parent-link narrow_stereo_l_stereo_camera_frame_lk :child-link narrow_stereo_r_stereo_camera_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq narrow_stereo_l_stereo_camera_frame_joint_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_l_stereo_camera_frame_joint"
                     :parent-link narrow_stereo_link_lk :child-link narrow_stereo_l_stereo_camera_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq narrow_stereo_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_optical_frame_joint"
                     :parent-link narrow_stereo_link_lk :child-link narrow_stereo_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq wide_stereo_r_stereo_camera_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "wide_stereo_r_stereo_camera_optical_frame_joint"
                     :parent-link wide_stereo_r_stereo_camera_frame_lk :child-link wide_stereo_r_stereo_camera_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq wide_stereo_l_stereo_camera_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "wide_stereo_l_stereo_camera_optical_frame_joint"
                     :parent-link wide_stereo_l_stereo_camera_frame_lk :child-link wide_stereo_l_stereo_camera_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq wide_stereo_r_stereo_camera_frame_joint_jt
           (instance rotational-joint :init
                     :name "wide_stereo_r_stereo_camera_frame_joint"
                     :parent-link wide_stereo_l_stereo_camera_frame_lk :child-link wide_stereo_r_stereo_camera_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq wide_stereo_l_stereo_camera_frame_joint_jt
           (instance rotational-joint :init
                     :name "wide_stereo_l_stereo_camera_frame_joint"
                     :parent-link wide_stereo_link_lk :child-link wide_stereo_l_stereo_camera_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq wide_stereo_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "wide_stereo_optical_frame_joint"
                     :parent-link wide_stereo_link_lk :child-link wide_stereo_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq narrow_stereo_frame_joint_jt
           (instance rotational-joint :init
                     :name "narrow_stereo_frame_joint"
                     :parent-link double_stereo_link_lk :child-link narrow_stereo_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq wide_stereo_frame_joint_jt
           (instance rotational-joint :init
                     :name "wide_stereo_frame_joint"
                     :parent-link double_stereo_link_lk :child-link wide_stereo_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq high_def_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "high_def_optical_frame_joint"
                     :parent-link high_def_frame_lk :child-link high_def_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq double_stereo_frame_joint_jt
           (instance rotational-joint :init
                     :name "double_stereo_frame_joint"
                     :parent-link sensor_mount_link_lk :child-link double_stereo_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq high_def_frame_joint_jt
           (instance rotational-joint :init
                     :name "high_def_frame_joint"
                     :parent-link sensor_mount_link_lk :child-link high_def_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_mount_joint_jt
           (instance rotational-joint :init
                     :name "head_mount_joint"
                     :parent-link head_plate_frame_lk :child-link head_mount_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq projector_wg6802418_frame_joint_jt
           (instance rotational-joint :init
                     :name "projector_wg6802418_frame_joint"
                     :parent-link head_plate_frame_lk :child-link projector_wg6802418_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq sensor_mount_frame_joint_jt
           (instance rotational-joint :init
                     :name "sensor_mount_frame_joint"
                     :parent-link head_plate_frame_lk :child-link sensor_mount_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_chain_cb_jt
           (instance rotational-joint :init
                     :name "head_chain_cb"
                     :parent-link head_tilt_link_lk :child-link head_chain_cb_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_plate_frame_joint_jt
           (instance rotational-joint :init
                     :name "head_plate_frame_joint"
                     :parent-link head_tilt_link_lk :child-link head_plate_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq head_tilt_joint_jt
           (instance rotational-joint :init
                     :name "head_tilt_joint"
                     :parent-link head_pan_link_lk :child-link head_tilt_link_lk
                     :max-joint-velocity 5.000000
                     :max-joint-torque 18.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -21.268194 :max 74.270226
                     ))
     (setq l_forearm_cam_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "l_forearm_cam_optical_frame_joint"
                     :parent-link l_forearm_cam_frame_lk :child-link l_forearm_cam_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_gripper_l_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_l_finger_tip_joint"
                     :parent-link l_gripper_l_finger_link_lk :child-link l_gripper_l_finger_tip_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq l_gripper_motor_screw_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_motor_screw_joint"
                     :parent-link l_gripper_motor_slider_link_lk :child-link l_gripper_motor_screw_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq l_gripper_joint_jt
           (instance linear-joint :init
                     :name "l_gripper_joint"
                     :parent-link l_gripper_r_finger_tip_link_lk :child-link l_gripper_l_finger_tip_frame_lk
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -10.000000 :max 88.000000
                     ))
     (setq l_gripper_r_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_r_finger_tip_joint"
                     :parent-link l_gripper_r_finger_link_lk :child-link l_gripper_r_finger_tip_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq l_gripper_l_finger_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_l_finger_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_l_finger_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq l_gripper_led_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_led_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_led_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_gripper_motor_accelerometer_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_motor_accelerometer_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_motor_accelerometer_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_gripper_motor_slider_joint_jt
           (instance linear-joint :init
                     :name "l_gripper_motor_slider_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_motor_slider_link_lk
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -100.000000 :max 100.000000
                     ))
     (setq l_gripper_r_finger_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_r_finger_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_r_finger_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq l_gripper_tool_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_tool_joint"
                     :parent-link l_gripper_palm_link_lk :child-link l_gripper_tool_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_gripper_palm_joint_jt
           (instance rotational-joint :init
                     :name "l_gripper_palm_joint"
                     :parent-link l_wrist_roll_link_lk :child-link l_gripper_palm_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq left_arm_chain_cb_jt
           (instance rotational-joint :init
                     :name "left_arm_chain_cb"
                     :parent-link l_wrist_roll_link_lk :child-link left_arm_chain_cb_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_wrist_roll_joint_jt
           (instance rotational-joint :init
                     :name "l_wrist_roll_joint"
                     :parent-link l_wrist_flex_link_lk :child-link l_wrist_roll_link_lk
                     :max-joint-velocity 3.600000
                     :max-joint-torque 10.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq l_wrist_flex_joint_jt
           (instance rotational-joint :init
                     :name "l_wrist_flex_joint"
                     :parent-link l_forearm_link_lk :child-link l_wrist_flex_link_lk
                     :max-joint-velocity 3.078000
                     :max-joint-torque 10.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -114.591560 :max -5.729578
                     ))
     (setq l_forearm_cam_frame_joint_jt
           (instance rotational-joint :init
                     :name "l_forearm_cam_frame_joint"
                     :parent-link l_forearm_roll_link_lk :child-link l_forearm_cam_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_forearm_joint_jt
           (instance rotational-joint :init
                     :name "l_forearm_joint"
                     :parent-link l_forearm_roll_link_lk :child-link l_forearm_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_forearm_roll_joint_jt
           (instance rotational-joint :init
                     :name "l_forearm_roll_joint"
                     :parent-link l_elbow_flex_link_lk :child-link l_forearm_roll_link_lk
                     :max-joint-velocity 3.600000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq l_elbow_flex_joint_jt
           (instance rotational-joint :init
                     :name "l_elbow_flex_joint"
                     :parent-link l_upper_arm_link_lk :child-link l_elbow_flex_link_lk
                     :max-joint-velocity 3.300000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -121.541534 :max -8.594367
                     ))
     (setq l_upper_arm_joint_jt
           (instance rotational-joint :init
                     :name "l_upper_arm_joint"
                     :parent-link l_upper_arm_roll_link_lk :child-link l_upper_arm_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_upper_arm_roll_joint_jt
           (instance rotational-joint :init
                     :name "l_upper_arm_roll_joint"
                     :parent-link l_shoulder_lift_link_lk :child-link l_upper_arm_roll_link_lk
                     :max-joint-velocity 3.270000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -37.242256 :max 214.859177
                     ))
     (setq l_shoulder_lift_joint_jt
           (instance rotational-joint :init
                     :name "l_shoulder_lift_joint"
                     :parent-link l_shoulder_pan_link_lk :child-link l_shoulder_lift_link_lk
                     :max-joint-velocity 2.082000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -20.259789 :max 74.272522
                     ))
     (setq laser_tilt_joint_jt
           (instance rotational-joint :init
                     :name "laser_tilt_joint"
                     :parent-link laser_tilt_mount_link_lk :child-link laser_tilt_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_forearm_cam_optical_frame_joint_jt
           (instance rotational-joint :init
                     :name "r_forearm_cam_optical_frame_joint"
                     :parent-link r_forearm_cam_frame_lk :child-link r_forearm_cam_optical_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_gripper_l_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_l_finger_tip_joint"
                     :parent-link r_gripper_l_finger_link_lk :child-link r_gripper_l_finger_tip_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq r_gripper_motor_screw_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_motor_screw_joint"
                     :parent-link r_gripper_motor_slider_link_lk :child-link r_gripper_motor_screw_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq r_gripper_joint_jt
           (instance linear-joint :init
                     :name "r_gripper_joint"
                     :parent-link r_gripper_r_finger_tip_link_lk :child-link r_gripper_l_finger_tip_frame_lk
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -10.000000 :max 88.000000
                     ))
     (setq r_gripper_r_finger_tip_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_r_finger_tip_joint"
                     :parent-link r_gripper_r_finger_link_lk :child-link r_gripper_r_finger_tip_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq r_gripper_l_finger_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_l_finger_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_l_finger_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq r_gripper_led_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_led_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_led_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_gripper_motor_accelerometer_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_motor_accelerometer_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_motor_accelerometer_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_gripper_motor_slider_joint_jt
           (instance linear-joint :init
                     :name "r_gripper_motor_slider_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_motor_slider_link_lk
                     :max-joint-velocity 0.200000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -100.000000 :max 100.000000
                     ))
     (setq r_gripper_r_finger_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_r_finger_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_r_finger_link_lk
                     :max-joint-velocity 0.500000
                     :max-joint-torque 1000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 -1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 31.398087
                     ))
     (setq r_gripper_tool_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_tool_joint"
                     :parent-link r_gripper_palm_link_lk :child-link r_gripper_tool_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_gripper_palm_joint_jt
           (instance rotational-joint :init
                     :name "r_gripper_palm_joint"
                     :parent-link r_wrist_roll_link_lk :child-link r_gripper_palm_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq right_arm_chain_cb_jt
           (instance rotational-joint :init
                     :name "right_arm_chain_cb"
                     :parent-link r_wrist_roll_link_lk :child-link right_arm_chain_cb_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_wrist_roll_joint_jt
           (instance rotational-joint :init
                     :name "r_wrist_roll_joint"
                     :parent-link r_wrist_flex_link_lk :child-link r_wrist_roll_link_lk
                     :max-joint-velocity 3.600000
                     :max-joint-torque 10.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq r_wrist_flex_joint_jt
           (instance rotational-joint :init
                     :name "r_wrist_flex_joint"
                     :parent-link r_forearm_link_lk :child-link r_wrist_flex_link_lk
                     :max-joint-velocity 3.078000
                     :max-joint-torque 10.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -114.591560 :max -5.729578
                     ))
     (setq r_forearm_cam_frame_joint_jt
           (instance rotational-joint :init
                     :name "r_forearm_cam_frame_joint"
                     :parent-link r_forearm_roll_link_lk :child-link r_forearm_cam_frame_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_forearm_joint_jt
           (instance rotational-joint :init
                     :name "r_forearm_joint"
                     :parent-link r_forearm_roll_link_lk :child-link r_forearm_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_forearm_roll_joint_jt
           (instance rotational-joint :init
                     :name "r_forearm_roll_joint"
                     :parent-link r_elbow_flex_link_lk :child-link r_forearm_roll_link_lk
                     :max-joint-velocity 3.600000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq r_elbow_flex_joint_jt
           (instance rotational-joint :init
                     :name "r_elbow_flex_joint"
                     :parent-link r_upper_arm_link_lk :child-link r_elbow_flex_link_lk
                     :max-joint-velocity 3.300000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -121.541534 :max -8.594367
                     ))
     (setq r_upper_arm_joint_jt
           (instance rotational-joint :init
                     :name "r_upper_arm_joint"
                     :parent-link r_upper_arm_roll_link_lk :child-link r_upper_arm_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq r_upper_arm_roll_joint_jt
           (instance rotational-joint :init
                     :name "r_upper_arm_roll_joint"
                     :parent-link r_shoulder_lift_link_lk :child-link r_upper_arm_roll_link_lk
                     :max-joint-velocity 3.270000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 1.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -214.859177 :max 37.242256
                     ))
     (setq r_shoulder_lift_joint_jt
           (instance rotational-joint :init
                     :name "r_shoulder_lift_joint"
                     :parent-link r_shoulder_pan_link_lk :child-link r_shoulder_lift_link_lk
                     :max-joint-velocity 2.082000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -20.259789 :max 74.272522
                     ))
     (setq head_pan_joint_jt
           (instance rotational-joint :init
                     :name "head_pan_joint"
                     :parent-link torso_lift_link_lk :child-link head_pan_link_lk
                     :max-joint-velocity 6.000000
                     :max-joint-torque 2.645000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -163.694046 :max 163.694046
                     ))
     (setq imu_joint_jt
           (instance rotational-joint :init
                     :name "imu_joint"
                     :parent-link torso_lift_link_lk :child-link imu_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq l_shoulder_pan_joint_jt
           (instance rotational-joint :init
                     :name "l_shoulder_pan_joint"
                     :parent-link torso_lift_link_lk :child-link l_shoulder_pan_link_lk
                     :max-joint-velocity 2.088000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -32.349304 :max 122.349304
                     ))
     (setq l_torso_lift_side_plate_joint_jt
           (instance rotational-joint :init
                     :name "l_torso_lift_side_plate_joint"
                     :parent-link torso_lift_link_lk :child-link l_torso_lift_side_plate_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq laser_tilt_mount_joint_jt
           (instance rotational-joint :init
                     :name "laser_tilt_mount_joint"
                     :parent-link torso_lift_link_lk :child-link laser_tilt_mount_link_lk
                     :max-joint-velocity 10.000000
                     :max-joint-torque 0.650000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -42.135315 :max 82.135216
                     ))
     (setq r_shoulder_pan_joint_jt
           (instance rotational-joint :init
                     :name "r_shoulder_pan_joint"
                     :parent-link torso_lift_link_lk :child-link r_shoulder_pan_link_lk
                     :max-joint-velocity 2.088000
                     :max-joint-torque 30.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -122.349304 :max 32.349304
                     ))
     (setq r_torso_lift_side_plate_joint_jt
           (instance rotational-joint :init
                     :name "r_torso_lift_side_plate_joint"
                     :parent-link torso_lift_link_lk :child-link r_torso_lift_side_plate_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq base_bellow_joint_jt
           (instance rotational-joint :init
                     :name "base_bellow_joint"
                     :parent-link base_link_lk :child-link base_bellow_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq base_laser_joint_jt
           (instance rotational-joint :init
                     :name "base_laser_joint"
                     :parent-link base_link_lk :child-link base_laser_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))
     (setq bl_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "bl_caster_rotation_joint"
                     :parent-link base_link_lk :child-link bl_caster_rotation_link_lk
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq br_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "br_caster_rotation_joint"
                     :parent-link base_link_lk :child-link br_caster_rotation_link_lk
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq fl_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "fl_caster_rotation_joint"
                     :parent-link base_link_lk :child-link fl_caster_rotation_link_lk
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq fr_caster_rotation_joint_jt
           (instance rotational-joint :init
                     :name "fr_caster_rotation_joint"
                     :parent-link base_link_lk :child-link fr_caster_rotation_link_lk
                     :max-joint-velocity 10.000000
                     :max-joint-torque 6.500000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq torso_lift_joint_jt
           (instance linear-joint :init
                     :name "torso_lift_joint"
                     :parent-link base_link_lk :child-link torso_lift_link_lk
                     :max-joint-velocity 0.013000
                     :max-joint-torque 10000.000000
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 11.500000 :max 325.000000
                     ))
     (setq torso_lift_motor_screw_joint_jt
           (instance rotational-joint :init
                     :name "torso_lift_motor_screw_joint"
                     :parent-link base_link_lk :child-link torso_lift_motor_screw_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 1.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min *-inf* :max *inf*
                     ))
     (setq base_footprint_joint_jt
           (instance rotational-joint :init
                     :name "base_footprint_joint"
                     :parent-link base_footprint_lk :child-link base_link_lk
                     :axis (let ((tmp-axis (float-vector 0.0000000000000000e+00 0.0000000000000000e+00 0.0000000000000000e+00))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min 0.000000 :max 0.000000
                     ))

     ;; end coords from openrave manipulater tag
     ;; end coords from yaml file
     (setq torso-end-coords (make-cascoords :coords (send torso_lift_link_lk :copy-worldcoords) :name :torso-end-coords))
     (send torso_lift_link_lk :assoc torso-end-coords)
     (setq larm-end-coords (make-cascoords :coords (send l_gripper_tool_frame_lk :copy-worldcoords) :name :larm-end-coords))
     (send larm-end-coords :rotate 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))
     (send l_gripper_tool_frame_lk :assoc larm-end-coords)
     (setq rarm-end-coords (make-cascoords :coords (send r_gripper_tool_frame_lk :copy-worldcoords) :name :rarm-end-coords))
     (send rarm-end-coords :rotate 0.0000000000000000e+00 (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))
     (send r_gripper_tool_frame_lk :assoc rarm-end-coords)
     (setq head-end-coords (make-cascoords :coords (send head_tilt_link_lk :copy-worldcoords) :name :head-end-coords))
     (send head-end-coords :translate (float-vector 8.0000000000000000e+01 0.0000000000000000e+00 1.3000000000000000e+02))
     (send head-end-coords :rotate 1.5707963267948966e+00 (float-vector 0.0000000000000000e+00 1.0000000000000000e+00 0.0000000000000000e+00))
     (send head_tilt_link_lk :assoc head-end-coords)

     ;; limbs
     (setq torso (list torso_lift_link_lk))

     (setq torso-root-link (labels ((find-parent (l) (if (find (send l :parent) torso) (find-parent (send l :parent)) l))) (find-parent (car torso))))
     (setq larm (list l_shoulder_pan_link_lk l_shoulder_lift_link_lk l_upper_arm_roll_link_lk l_elbow_flex_link_lk l_forearm_roll_link_lk l_wrist_flex_link_lk l_wrist_roll_link_lk))

     (setq larm-root-link (labels ((find-parent (l) (if (find (send l :parent) larm) (find-parent (send l :parent)) l))) (find-parent (car larm))))
     (setq rarm (list r_shoulder_pan_link_lk r_shoulder_lift_link_lk r_upper_arm_roll_link_lk r_elbow_flex_link_lk r_forearm_roll_link_lk r_wrist_flex_link_lk r_wrist_roll_link_lk))

     (setq rarm-root-link (labels ((find-parent (l) (if (find (send l :parent) rarm) (find-parent (send l :parent)) l))) (find-parent (car rarm))))
     (setq head (list head_pan_link_lk head_tilt_link_lk))

     (setq head-root-link (labels ((find-parent (l) (if (find (send l :parent) head) (find-parent (send l :parent)) l))) (find-parent (car head))))

     ;; links
     (setq links (list base_footprint_lk torso_lift_link_lk l_shoulder_pan_link_lk l_shoulder_lift_link_lk l_upper_arm_roll_link_lk l_elbow_flex_link_lk l_forearm_roll_link_lk l_wrist_flex_link_lk l_wrist_roll_link_lk r_shoulder_pan_link_lk r_shoulder_lift_link_lk r_upper_arm_roll_link_lk r_elbow_flex_link_lk r_forearm_roll_link_lk r_wrist_flex_link_lk r_wrist_roll_link_lk head_pan_link_lk head_tilt_link_lk))
     ;; joint-list
     (setq joint-list (list torso_lift_joint_jt l_shoulder_pan_joint_jt l_shoulder_lift_joint_jt l_upper_arm_roll_joint_jt l_elbow_flex_joint_jt l_forearm_roll_joint_jt l_wrist_flex_joint_jt l_wrist_roll_joint_jt r_shoulder_pan_joint_jt r_shoulder_lift_joint_jt r_upper_arm_roll_joint_jt r_elbow_flex_joint_jt r_forearm_roll_joint_jt r_wrist_flex_joint_jt r_wrist_roll_joint_jt head_pan_joint_jt head_tilt_joint_jt))

    ;; attach_sensor
    (setq force-sensors (sort (list ) #'< #'(lambda (x) (send x :get :sensor-id))))
    (setq imu-sensors (sort (list ) #'< #'(lambda (x) (send x :get :sensor-id))))
    (setq cameras (sort (list ) #'< #'(lambda (x) (send x :get :sensor-id))))
     ;; init-ending
     (send self :init-ending)

     ;; overwrite bodies to return draw-things links not (send link :bodies)
     (setq bodies (flatten (mapcar #'(lambda (b) (if (find-method b :bodies) (send b :bodies))) (list base_bellow_link_lk base_laser_link_lk bl_caster_l_wheel_link_lk bl_caster_r_wheel_link_lk bl_caster_rotation_link_lk br_caster_l_wheel_link_lk br_caster_r_wheel_link_lk br_caster_rotation_link_lk fl_caster_l_wheel_link_lk fl_caster_r_wheel_link_lk fl_caster_rotation_link_lk fr_caster_l_wheel_link_lk fr_caster_r_wheel_link_lk fr_caster_rotation_link_lk head_chain_cb_link_lk head_mount_kinect_ir_optical_frame_lk head_mount_kinect_rgb_optical_frame_lk head_mount_kinect_rgb_link_lk head_mount_kinect_ir_link_lk head_mount_prosilica_optical_frame_lk head_mount_prosilica_link_lk head_mount_link_lk projector_wg6802418_child_frame_lk projector_wg6802418_frame_lk narrow_stereo_l_stereo_camera_optical_frame_lk narrow_stereo_r_stereo_camera_optical_frame_lk narrow_stereo_r_stereo_camera_frame_lk narrow_stereo_l_stereo_camera_frame_lk narrow_stereo_optical_frame_lk narrow_stereo_link_lk wide_stereo_l_stereo_camera_optical_frame_lk wide_stereo_r_stereo_camera_optical_frame_lk wide_stereo_r_stereo_camera_frame_lk wide_stereo_l_stereo_camera_frame_lk wide_stereo_optical_frame_lk wide_stereo_link_lk double_stereo_link_lk high_def_optical_frame_lk high_def_frame_lk sensor_mount_link_lk head_plate_frame_lk head_tilt_link_lk head_pan_link_lk imu_link_lk l_forearm_cam_optical_frame_lk l_forearm_cam_frame_lk l_gripper_l_finger_tip_link_lk l_gripper_l_finger_link_lk l_gripper_led_frame_lk l_gripper_motor_accelerometer_link_lk l_gripper_motor_screw_link_lk l_gripper_motor_slider_link_lk l_gripper_l_finger_tip_frame_lk l_gripper_r_finger_tip_link_lk l_gripper_r_finger_link_lk l_gripper_tool_frame_lk l_gripper_palm_link_lk left_arm_chain_cb_link_lk l_wrist_roll_link_lk l_wrist_flex_link_lk l_forearm_link_lk l_forearm_roll_link_lk l_elbow_flex_link_lk l_upper_arm_link_lk l_upper_arm_roll_link_lk l_shoulder_lift_link_lk l_shoulder_pan_link_lk l_torso_lift_side_plate_link_lk laser_tilt_link_lk laser_tilt_mount_link_lk r_forearm_cam_optical_frame_lk r_forearm_cam_frame_lk r_gripper_l_finger_tip_link_lk r_gripper_l_finger_link_lk r_gripper_led_frame_lk r_gripper_motor_accelerometer_link_lk r_gripper_motor_screw_link_lk r_gripper_motor_slider_link_lk r_gripper_l_finger_tip_frame_lk r_gripper_r_finger_tip_link_lk r_gripper_r_finger_link_lk r_gripper_tool_frame_lk r_gripper_palm_link_lk right_arm_chain_cb_link_lk r_wrist_roll_link_lk r_wrist_flex_link_lk r_forearm_link_lk r_forearm_roll_link_lk r_elbow_flex_link_lk r_upper_arm_link_lk r_upper_arm_roll_link_lk r_shoulder_lift_link_lk r_shoulder_pan_link_lk r_torso_lift_side_plate_link_lk torso_lift_link_lk torso_lift_motor_screw_link_lk base_link_lk base_footprint_lk))))

     (send self :reset-pose) ;; :set reset-pose

     self)) ;; :init

    ;; pre-defined pose methods
    (:reset-manip-pose () (send self :angle-vector (float-vector 300.000000 75.000000 50.000000 110.000000 -110.000000 -20.000000 -10.000000 -10.000000 -75.000000 50.000000 -110.000000 -110.000000 20.000000 -10.000000 -10.000000 0.000000 50.000000)))
    (:reset-pose () (send self :angle-vector (float-vector 50.000000 60.000000 74.000000 70.000000 -120.000000 20.000000 -30.000000 180.000000 -60.000000 74.000000 -70.000000 -120.000000 -20.000000 -30.000000 180.000000 0.000000 0.000000)))

    ;; all joints
    (:base_bellow_joint (&rest args) (forward-message-to base_bellow_joint_jt args))
    (:base_footprint_joint (&rest args) (forward-message-to base_footprint_joint_jt args))
    (:base_laser_joint (&rest args) (forward-message-to base_laser_joint_jt args))
    (:bl_caster_l_wheel_joint (&rest args) (forward-message-to bl_caster_l_wheel_joint_jt args))
    (:bl_caster_r_wheel_joint (&rest args) (forward-message-to bl_caster_r_wheel_joint_jt args))
    (:bl_caster_rotation_joint (&rest args) (forward-message-to bl_caster_rotation_joint_jt args))
    (:br_caster_l_wheel_joint (&rest args) (forward-message-to br_caster_l_wheel_joint_jt args))
    (:br_caster_r_wheel_joint (&rest args) (forward-message-to br_caster_r_wheel_joint_jt args))
    (:br_caster_rotation_joint (&rest args) (forward-message-to br_caster_rotation_joint_jt args))
    (:double_stereo_frame_joint (&rest args) (forward-message-to double_stereo_frame_joint_jt args))
    (:fl_caster_l_wheel_joint (&rest args) (forward-message-to fl_caster_l_wheel_joint_jt args))
    (:fl_caster_r_wheel_joint (&rest args) (forward-message-to fl_caster_r_wheel_joint_jt args))
    (:fl_caster_rotation_joint (&rest args) (forward-message-to fl_caster_rotation_joint_jt args))
    (:fr_caster_l_wheel_joint (&rest args) (forward-message-to fr_caster_l_wheel_joint_jt args))
    (:fr_caster_r_wheel_joint (&rest args) (forward-message-to fr_caster_r_wheel_joint_jt args))
    (:fr_caster_rotation_joint (&rest args) (forward-message-to fr_caster_rotation_joint_jt args))
    (:head_chain_cb (&rest args) (forward-message-to head_chain_cb_jt args))
    (:head_mount_joint (&rest args) (forward-message-to head_mount_joint_jt args))
    (:head_mount_kinect_ir_joint (&rest args) (forward-message-to head_mount_kinect_ir_joint_jt args))
    (:head_mount_kinect_ir_optical_frame_joint (&rest args) (forward-message-to head_mount_kinect_ir_optical_frame_joint_jt args))
    (:head_mount_kinect_rgb_joint (&rest args) (forward-message-to head_mount_kinect_rgb_joint_jt args))
    (:head_mount_kinect_rgb_optical_frame_joint (&rest args) (forward-message-to head_mount_kinect_rgb_optical_frame_joint_jt args))
    (:head_mount_prosilica_joint (&rest args) (forward-message-to head_mount_prosilica_joint_jt args))
    (:head_mount_prosilica_optical_frame_joint (&rest args) (forward-message-to head_mount_prosilica_optical_frame_joint_jt args))
    (:head_pan_joint (&rest args) (forward-message-to head_pan_joint_jt args))
    (:head_plate_frame_joint (&rest args) (forward-message-to head_plate_frame_joint_jt args))
    (:head_tilt_joint (&rest args) (forward-message-to head_tilt_joint_jt args))
    (:high_def_frame_joint (&rest args) (forward-message-to high_def_frame_joint_jt args))
    (:high_def_optical_frame_joint (&rest args) (forward-message-to high_def_optical_frame_joint_jt args))
    (:imu_joint (&rest args) (forward-message-to imu_joint_jt args))
    (:l_elbow_flex_joint (&rest args) (forward-message-to l_elbow_flex_joint_jt args))
    (:l_forearm_cam_frame_joint (&rest args) (forward-message-to l_forearm_cam_frame_joint_jt args))
    (:l_forearm_cam_optical_frame_joint (&rest args) (forward-message-to l_forearm_cam_optical_frame_joint_jt args))
    (:l_forearm_joint (&rest args) (forward-message-to l_forearm_joint_jt args))
    (:l_forearm_roll_joint (&rest args) (forward-message-to l_forearm_roll_joint_jt args))
    (:l_gripper_joint (&rest args) (forward-message-to l_gripper_joint_jt args))
    (:l_gripper_l_finger_joint (&rest args) (forward-message-to l_gripper_l_finger_joint_jt args))
    (:l_gripper_l_finger_tip_joint (&rest args) (forward-message-to l_gripper_l_finger_tip_joint_jt args))
    (:l_gripper_led_joint (&rest args) (forward-message-to l_gripper_led_joint_jt args))
    (:l_gripper_motor_accelerometer_joint (&rest args) (forward-message-to l_gripper_motor_accelerometer_joint_jt args))
    (:l_gripper_motor_screw_joint (&rest args) (forward-message-to l_gripper_motor_screw_joint_jt args))
    (:l_gripper_motor_slider_joint (&rest args) (forward-message-to l_gripper_motor_slider_joint_jt args))
    (:l_gripper_palm_joint (&rest args) (forward-message-to l_gripper_palm_joint_jt args))
    (:l_gripper_r_finger_joint (&rest args) (forward-message-to l_gripper_r_finger_joint_jt args))
    (:l_gripper_r_finger_tip_joint (&rest args) (forward-message-to l_gripper_r_finger_tip_joint_jt args))
    (:l_gripper_tool_joint (&rest args) (forward-message-to l_gripper_tool_joint_jt args))
    (:l_shoulder_lift_joint (&rest args) (forward-message-to l_shoulder_lift_joint_jt args))
    (:l_shoulder_pan_joint (&rest args) (forward-message-to l_shoulder_pan_joint_jt args))
    (:l_torso_lift_side_plate_joint (&rest args) (forward-message-to l_torso_lift_side_plate_joint_jt args))
    (:l_upper_arm_joint (&rest args) (forward-message-to l_upper_arm_joint_jt args))
    (:l_upper_arm_roll_joint (&rest args) (forward-message-to l_upper_arm_roll_joint_jt args))
    (:l_wrist_flex_joint (&rest args) (forward-message-to l_wrist_flex_joint_jt args))
    (:l_wrist_roll_joint (&rest args) (forward-message-to l_wrist_roll_joint_jt args))
    (:laser_tilt_joint (&rest args) (forward-message-to laser_tilt_joint_jt args))
    (:laser_tilt_mount_joint (&rest args) (forward-message-to laser_tilt_mount_joint_jt args))
    (:left_arm_chain_cb (&rest args) (forward-message-to left_arm_chain_cb_jt args))
    (:narrow_stereo_frame_joint (&rest args) (forward-message-to narrow_stereo_frame_joint_jt args))
    (:narrow_stereo_l_stereo_camera_frame_joint (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_frame_joint_jt args))
    (:narrow_stereo_l_stereo_camera_optical_frame_joint (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_optical_frame_joint_jt args))
    (:narrow_stereo_optical_frame_joint (&rest args) (forward-message-to narrow_stereo_optical_frame_joint_jt args))
    (:narrow_stereo_r_stereo_camera_frame_joint (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_frame_joint_jt args))
    (:narrow_stereo_r_stereo_camera_optical_frame_joint (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_optical_frame_joint_jt args))
    (:projector_wg6802418_child_frame_joint (&rest args) (forward-message-to projector_wg6802418_child_frame_joint_jt args))
    (:projector_wg6802418_frame_joint (&rest args) (forward-message-to projector_wg6802418_frame_joint_jt args))
    (:r_elbow_flex_joint (&rest args) (forward-message-to r_elbow_flex_joint_jt args))
    (:r_forearm_cam_frame_joint (&rest args) (forward-message-to r_forearm_cam_frame_joint_jt args))
    (:r_forearm_cam_optical_frame_joint (&rest args) (forward-message-to r_forearm_cam_optical_frame_joint_jt args))
    (:r_forearm_joint (&rest args) (forward-message-to r_forearm_joint_jt args))
    (:r_forearm_roll_joint (&rest args) (forward-message-to r_forearm_roll_joint_jt args))
    (:r_gripper_joint (&rest args) (forward-message-to r_gripper_joint_jt args))
    (:r_gripper_l_finger_joint (&rest args) (forward-message-to r_gripper_l_finger_joint_jt args))
    (:r_gripper_l_finger_tip_joint (&rest args) (forward-message-to r_gripper_l_finger_tip_joint_jt args))
    (:r_gripper_led_joint (&rest args) (forward-message-to r_gripper_led_joint_jt args))
    (:r_gripper_motor_accelerometer_joint (&rest args) (forward-message-to r_gripper_motor_accelerometer_joint_jt args))
    (:r_gripper_motor_screw_joint (&rest args) (forward-message-to r_gripper_motor_screw_joint_jt args))
    (:r_gripper_motor_slider_joint (&rest args) (forward-message-to r_gripper_motor_slider_joint_jt args))
    (:r_gripper_palm_joint (&rest args) (forward-message-to r_gripper_palm_joint_jt args))
    (:r_gripper_r_finger_joint (&rest args) (forward-message-to r_gripper_r_finger_joint_jt args))
    (:r_gripper_r_finger_tip_joint (&rest args) (forward-message-to r_gripper_r_finger_tip_joint_jt args))
    (:r_gripper_tool_joint (&rest args) (forward-message-to r_gripper_tool_joint_jt args))
    (:r_shoulder_lift_joint (&rest args) (forward-message-to r_shoulder_lift_joint_jt args))
    (:r_shoulder_pan_joint (&rest args) (forward-message-to r_shoulder_pan_joint_jt args))
    (:r_torso_lift_side_plate_joint (&rest args) (forward-message-to r_torso_lift_side_plate_joint_jt args))
    (:r_upper_arm_joint (&rest args) (forward-message-to r_upper_arm_joint_jt args))
    (:r_upper_arm_roll_joint (&rest args) (forward-message-to r_upper_arm_roll_joint_jt args))
    (:r_wrist_flex_joint (&rest args) (forward-message-to r_wrist_flex_joint_jt args))
    (:r_wrist_roll_joint (&rest args) (forward-message-to r_wrist_roll_joint_jt args))
    (:right_arm_chain_cb (&rest args) (forward-message-to right_arm_chain_cb_jt args))
    (:sensor_mount_frame_joint (&rest args) (forward-message-to sensor_mount_frame_joint_jt args))
    (:torso_lift_joint (&rest args) (forward-message-to torso_lift_joint_jt args))
    (:torso_lift_motor_screw_joint (&rest args) (forward-message-to torso_lift_motor_screw_joint_jt args))
    (:wide_stereo_frame_joint (&rest args) (forward-message-to wide_stereo_frame_joint_jt args))
    (:wide_stereo_l_stereo_camera_frame_joint (&rest args) (forward-message-to wide_stereo_l_stereo_camera_frame_joint_jt args))
    (:wide_stereo_l_stereo_camera_optical_frame_joint (&rest args) (forward-message-to wide_stereo_l_stereo_camera_optical_frame_joint_jt args))
    (:wide_stereo_optical_frame_joint (&rest args) (forward-message-to wide_stereo_optical_frame_joint_jt args))
    (:wide_stereo_r_stereo_camera_frame_joint (&rest args) (forward-message-to wide_stereo_r_stereo_camera_frame_joint_jt args))
    (:wide_stereo_r_stereo_camera_optical_frame_joint (&rest args) (forward-message-to wide_stereo_r_stereo_camera_optical_frame_joint_jt args))

    ;; all links forwarding
    (:links (&rest args)
     (if (null args) (return-from :links (send-super :links)))
     (let ((key (car args))
           (nargs (cdr args)))
       (unless (keywordp key)
         (return-from :links (send-super* :links args)))
       (case key
         (:base_bellow_link (forward-message-to base_bellow_link_lk nargs))
         (:base_laser_link (forward-message-to base_laser_link_lk nargs))
         (:bl_caster_l_wheel_link (forward-message-to bl_caster_l_wheel_link_lk nargs))
         (:bl_caster_r_wheel_link (forward-message-to bl_caster_r_wheel_link_lk nargs))
         (:bl_caster_rotation_link (forward-message-to bl_caster_rotation_link_lk nargs))
         (:br_caster_l_wheel_link (forward-message-to br_caster_l_wheel_link_lk nargs))
         (:br_caster_r_wheel_link (forward-message-to br_caster_r_wheel_link_lk nargs))
         (:br_caster_rotation_link (forward-message-to br_caster_rotation_link_lk nargs))
         (:fl_caster_l_wheel_link (forward-message-to fl_caster_l_wheel_link_lk nargs))
         (:fl_caster_r_wheel_link (forward-message-to fl_caster_r_wheel_link_lk nargs))
         (:fl_caster_rotation_link (forward-message-to fl_caster_rotation_link_lk nargs))
         (:fr_caster_l_wheel_link (forward-message-to fr_caster_l_wheel_link_lk nargs))
         (:fr_caster_r_wheel_link (forward-message-to fr_caster_r_wheel_link_lk nargs))
         (:fr_caster_rotation_link (forward-message-to fr_caster_rotation_link_lk nargs))
         (:head_chain_cb_link (forward-message-to head_chain_cb_link_lk nargs))
         (:head_mount_kinect_ir_optical_frame (forward-message-to head_mount_kinect_ir_optical_frame_lk nargs))
         (:head_mount_kinect_rgb_optical_frame (forward-message-to head_mount_kinect_rgb_optical_frame_lk nargs))
         (:head_mount_kinect_rgb_link (forward-message-to head_mount_kinect_rgb_link_lk nargs))
         (:head_mount_kinect_ir_link (forward-message-to head_mount_kinect_ir_link_lk nargs))
         (:head_mount_prosilica_optical_frame (forward-message-to head_mount_prosilica_optical_frame_lk nargs))
         (:head_mount_prosilica_link (forward-message-to head_mount_prosilica_link_lk nargs))
         (:head_mount_link (forward-message-to head_mount_link_lk nargs))
         (:projector_wg6802418_child_frame (forward-message-to projector_wg6802418_child_frame_lk nargs))
         (:projector_wg6802418_frame (forward-message-to projector_wg6802418_frame_lk nargs))
         (:narrow_stereo_l_stereo_camera_optical_frame (forward-message-to narrow_stereo_l_stereo_camera_optical_frame_lk nargs))
         (:narrow_stereo_r_stereo_camera_optical_frame (forward-message-to narrow_stereo_r_stereo_camera_optical_frame_lk nargs))
         (:narrow_stereo_r_stereo_camera_frame (forward-message-to narrow_stereo_r_stereo_camera_frame_lk nargs))
         (:narrow_stereo_l_stereo_camera_frame (forward-message-to narrow_stereo_l_stereo_camera_frame_lk nargs))
         (:narrow_stereo_optical_frame (forward-message-to narrow_stereo_optical_frame_lk nargs))
         (:narrow_stereo_link (forward-message-to narrow_stereo_link_lk nargs))
         (:wide_stereo_l_stereo_camera_optical_frame (forward-message-to wide_stereo_l_stereo_camera_optical_frame_lk nargs))
         (:wide_stereo_r_stereo_camera_optical_frame (forward-message-to wide_stereo_r_stereo_camera_optical_frame_lk nargs))
         (:wide_stereo_r_stereo_camera_frame (forward-message-to wide_stereo_r_stereo_camera_frame_lk nargs))
         (:wide_stereo_l_stereo_camera_frame (forward-message-to wide_stereo_l_stereo_camera_frame_lk nargs))
         (:wide_stereo_optical_frame (forward-message-to wide_stereo_optical_frame_lk nargs))
         (:wide_stereo_link (forward-message-to wide_stereo_link_lk nargs))
         (:double_stereo_link (forward-message-to double_stereo_link_lk nargs))
         (:high_def_optical_frame (forward-message-to high_def_optical_frame_lk nargs))
         (:high_def_frame (forward-message-to high_def_frame_lk nargs))
         (:sensor_mount_link (forward-message-to sensor_mount_link_lk nargs))
         (:head_plate_frame (forward-message-to head_plate_frame_lk nargs))
         (:head_tilt_link (forward-message-to head_tilt_link_lk nargs))
         (:head_pan_link (forward-message-to head_pan_link_lk nargs))
         (:imu_link (forward-message-to imu_link_lk nargs))
         (:l_forearm_cam_optical_frame (forward-message-to l_forearm_cam_optical_frame_lk nargs))
         (:l_forearm_cam_frame (forward-message-to l_forearm_cam_frame_lk nargs))
         (:l_gripper_l_finger_tip_link (forward-message-to l_gripper_l_finger_tip_link_lk nargs))
         (:l_gripper_l_finger_link (forward-message-to l_gripper_l_finger_link_lk nargs))
         (:l_gripper_led_frame (forward-message-to l_gripper_led_frame_lk nargs))
         (:l_gripper_motor_accelerometer_link (forward-message-to l_gripper_motor_accelerometer_link_lk nargs))
         (:l_gripper_motor_screw_link (forward-message-to l_gripper_motor_screw_link_lk nargs))
         (:l_gripper_motor_slider_link (forward-message-to l_gripper_motor_slider_link_lk nargs))
         (:l_gripper_l_finger_tip_frame (forward-message-to l_gripper_l_finger_tip_frame_lk nargs))
         (:l_gripper_r_finger_tip_link (forward-message-to l_gripper_r_finger_tip_link_lk nargs))
         (:l_gripper_r_finger_link (forward-message-to l_gripper_r_finger_link_lk nargs))
         (:l_gripper_tool_frame (forward-message-to l_gripper_tool_frame_lk nargs))
         (:l_gripper_palm_link (forward-message-to l_gripper_palm_link_lk nargs))
         (:left_arm_chain_cb_link (forward-message-to left_arm_chain_cb_link_lk nargs))
         (:l_wrist_roll_link (forward-message-to l_wrist_roll_link_lk nargs))
         (:l_wrist_flex_link (forward-message-to l_wrist_flex_link_lk nargs))
         (:l_forearm_link (forward-message-to l_forearm_link_lk nargs))
         (:l_forearm_roll_link (forward-message-to l_forearm_roll_link_lk nargs))
         (:l_elbow_flex_link (forward-message-to l_elbow_flex_link_lk nargs))
         (:l_upper_arm_link (forward-message-to l_upper_arm_link_lk nargs))
         (:l_upper_arm_roll_link (forward-message-to l_upper_arm_roll_link_lk nargs))
         (:l_shoulder_lift_link (forward-message-to l_shoulder_lift_link_lk nargs))
         (:l_shoulder_pan_link (forward-message-to l_shoulder_pan_link_lk nargs))
         (:l_torso_lift_side_plate_link (forward-message-to l_torso_lift_side_plate_link_lk nargs))
         (:laser_tilt_link (forward-message-to laser_tilt_link_lk nargs))
         (:laser_tilt_mount_link (forward-message-to laser_tilt_mount_link_lk nargs))
         (:r_forearm_cam_optical_frame (forward-message-to r_forearm_cam_optical_frame_lk nargs))
         (:r_forearm_cam_frame (forward-message-to r_forearm_cam_frame_lk nargs))
         (:r_gripper_l_finger_tip_link (forward-message-to r_gripper_l_finger_tip_link_lk nargs))
         (:r_gripper_l_finger_link (forward-message-to r_gripper_l_finger_link_lk nargs))
         (:r_gripper_led_frame (forward-message-to r_gripper_led_frame_lk nargs))
         (:r_gripper_motor_accelerometer_link (forward-message-to r_gripper_motor_accelerometer_link_lk nargs))
         (:r_gripper_motor_screw_link (forward-message-to r_gripper_motor_screw_link_lk nargs))
         (:r_gripper_motor_slider_link (forward-message-to r_gripper_motor_slider_link_lk nargs))
         (:r_gripper_l_finger_tip_frame (forward-message-to r_gripper_l_finger_tip_frame_lk nargs))
         (:r_gripper_r_finger_tip_link (forward-message-to r_gripper_r_finger_tip_link_lk nargs))
         (:r_gripper_r_finger_link (forward-message-to r_gripper_r_finger_link_lk nargs))
         (:r_gripper_tool_frame (forward-message-to r_gripper_tool_frame_lk nargs))
         (:r_gripper_palm_link (forward-message-to r_gripper_palm_link_lk nargs))
         (:right_arm_chain_cb_link (forward-message-to right_arm_chain_cb_link_lk nargs))
         (:r_wrist_roll_link (forward-message-to r_wrist_roll_link_lk nargs))
         (:r_wrist_flex_link (forward-message-to r_wrist_flex_link_lk nargs))
         (:r_forearm_link (forward-message-to r_forearm_link_lk nargs))
         (:r_forearm_roll_link (forward-message-to r_forearm_roll_link_lk nargs))
         (:r_elbow_flex_link (forward-message-to r_elbow_flex_link_lk nargs))
         (:r_upper_arm_link (forward-message-to r_upper_arm_link_lk nargs))
         (:r_upper_arm_roll_link (forward-message-to r_upper_arm_roll_link_lk nargs))
         (:r_shoulder_lift_link (forward-message-to r_shoulder_lift_link_lk nargs))
         (:r_shoulder_pan_link (forward-message-to r_shoulder_pan_link_lk nargs))
         (:r_torso_lift_side_plate_link (forward-message-to r_torso_lift_side_plate_link_lk nargs))
         (:torso_lift_link (forward-message-to torso_lift_link_lk nargs))
         (:torso_lift_motor_screw_link (forward-message-to torso_lift_motor_screw_link_lk nargs))
         (:base_link (forward-message-to base_link_lk nargs))
         (:base_footprint (forward-message-to base_footprint_lk nargs))
         (t (send-super* :links args)))))

    ;; all links
    (:base_bellow_link_lk (&rest args) (forward-message-to base_bellow_link_lk args))
    (:base_laser_link_lk (&rest args) (forward-message-to base_laser_link_lk args))
    (:bl_caster_l_wheel_link_lk (&rest args) (forward-message-to bl_caster_l_wheel_link_lk args))
    (:bl_caster_r_wheel_link_lk (&rest args) (forward-message-to bl_caster_r_wheel_link_lk args))
    (:bl_caster_rotation_link_lk (&rest args) (forward-message-to bl_caster_rotation_link_lk args))
    (:br_caster_l_wheel_link_lk (&rest args) (forward-message-to br_caster_l_wheel_link_lk args))
    (:br_caster_r_wheel_link_lk (&rest args) (forward-message-to br_caster_r_wheel_link_lk args))
    (:br_caster_rotation_link_lk (&rest args) (forward-message-to br_caster_rotation_link_lk args))
    (:fl_caster_l_wheel_link_lk (&rest args) (forward-message-to fl_caster_l_wheel_link_lk args))
    (:fl_caster_r_wheel_link_lk (&rest args) (forward-message-to fl_caster_r_wheel_link_lk args))
    (:fl_caster_rotation_link_lk (&rest args) (forward-message-to fl_caster_rotation_link_lk args))
    (:fr_caster_l_wheel_link_lk (&rest args) (forward-message-to fr_caster_l_wheel_link_lk args))
    (:fr_caster_r_wheel_link_lk (&rest args) (forward-message-to fr_caster_r_wheel_link_lk args))
    (:fr_caster_rotation_link_lk (&rest args) (forward-message-to fr_caster_rotation_link_lk args))
    (:head_chain_cb_link_lk (&rest args) (forward-message-to head_chain_cb_link_lk args))
    (:head_mount_kinect_ir_optical_frame_lk (&rest args) (forward-message-to head_mount_kinect_ir_optical_frame_lk args))
    (:head_mount_kinect_rgb_optical_frame_lk (&rest args) (forward-message-to head_mount_kinect_rgb_optical_frame_lk args))
    (:head_mount_kinect_rgb_link_lk (&rest args) (forward-message-to head_mount_kinect_rgb_link_lk args))
    (:head_mount_kinect_ir_link_lk (&rest args) (forward-message-to head_mount_kinect_ir_link_lk args))
    (:head_mount_prosilica_optical_frame_lk (&rest args) (forward-message-to head_mount_prosilica_optical_frame_lk args))
    (:head_mount_prosilica_link_lk (&rest args) (forward-message-to head_mount_prosilica_link_lk args))
    (:head_mount_link_lk (&rest args) (forward-message-to head_mount_link_lk args))
    (:projector_wg6802418_child_frame_lk (&rest args) (forward-message-to projector_wg6802418_child_frame_lk args))
    (:projector_wg6802418_frame_lk (&rest args) (forward-message-to projector_wg6802418_frame_lk args))
    (:narrow_stereo_l_stereo_camera_optical_frame_lk (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_optical_frame_lk args))
    (:narrow_stereo_r_stereo_camera_optical_frame_lk (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_optical_frame_lk args))
    (:narrow_stereo_r_stereo_camera_frame_lk (&rest args) (forward-message-to narrow_stereo_r_stereo_camera_frame_lk args))
    (:narrow_stereo_l_stereo_camera_frame_lk (&rest args) (forward-message-to narrow_stereo_l_stereo_camera_frame_lk args))
    (:narrow_stereo_optical_frame_lk (&rest args) (forward-message-to narrow_stereo_optical_frame_lk args))
    (:narrow_stereo_link_lk (&rest args) (forward-message-to narrow_stereo_link_lk args))
    (:wide_stereo_l_stereo_camera_optical_frame_lk (&rest args) (forward-message-to wide_stereo_l_stereo_camera_optical_frame_lk args))
    (:wide_stereo_r_stereo_camera_optical_frame_lk (&rest args) (forward-message-to wide_stereo_r_stereo_camera_optical_frame_lk args))
    (:wide_stereo_r_stereo_camera_frame_lk (&rest args) (forward-message-to wide_stereo_r_stereo_camera_frame_lk args))
    (:wide_stereo_l_stereo_camera_frame_lk (&rest args) (forward-message-to wide_stereo_l_stereo_camera_frame_lk args))
    (:wide_stereo_optical_frame_lk (&rest args) (forward-message-to wide_stereo_optical_frame_lk args))
    (:wide_stereo_link_lk (&rest args) (forward-message-to wide_stereo_link_lk args))
    (:double_stereo_link_lk (&rest args) (forward-message-to double_stereo_link_lk args))
    (:high_def_optical_frame_lk (&rest args) (forward-message-to high_def_optical_frame_lk args))
    (:high_def_frame_lk (&rest args) (forward-message-to high_def_frame_lk args))
    (:sensor_mount_link_lk (&rest args) (forward-message-to sensor_mount_link_lk args))
    (:head_plate_frame_lk (&rest args) (forward-message-to head_plate_frame_lk args))
    (:head_tilt_link_lk (&rest args) (forward-message-to head_tilt_link_lk args))
    (:head_pan_link_lk (&rest args) (forward-message-to head_pan_link_lk args))
    (:imu_link_lk (&rest args) (forward-message-to imu_link_lk args))
    (:l_forearm_cam_optical_frame_lk (&rest args) (forward-message-to l_forearm_cam_optical_frame_lk args))
    (:l_forearm_cam_frame_lk (&rest args) (forward-message-to l_forearm_cam_frame_lk args))
    (:l_gripper_l_finger_tip_link_lk (&rest args) (forward-message-to l_gripper_l_finger_tip_link_lk args))
    (:l_gripper_l_finger_link_lk (&rest args) (forward-message-to l_gripper_l_finger_link_lk args))
    (:l_gripper_led_frame_lk (&rest args) (forward-message-to l_gripper_led_frame_lk args))
    (:l_gripper_motor_accelerometer_link_lk (&rest args) (forward-message-to l_gripper_motor_accelerometer_link_lk args))
    (:l_gripper_motor_screw_link_lk (&rest args) (forward-message-to l_gripper_motor_screw_link_lk args))
    (:l_gripper_motor_slider_link_lk (&rest args) (forward-message-to l_gripper_motor_slider_link_lk args))
    (:l_gripper_l_finger_tip_frame_lk (&rest args) (forward-message-to l_gripper_l_finger_tip_frame_lk args))
    (:l_gripper_r_finger_tip_link_lk (&rest args) (forward-message-to l_gripper_r_finger_tip_link_lk args))
    (:l_gripper_r_finger_link_lk (&rest args) (forward-message-to l_gripper_r_finger_link_lk args))
    (:l_gripper_tool_frame_lk (&rest args) (forward-message-to l_gripper_tool_frame_lk args))
    (:l_gripper_palm_link_lk (&rest args) (forward-message-to l_gripper_palm_link_lk args))
    (:left_arm_chain_cb_link_lk (&rest args) (forward-message-to left_arm_chain_cb_link_lk args))
    (:l_wrist_roll_link_lk (&rest args) (forward-message-to l_wrist_roll_link_lk args))
    (:l_wrist_flex_link_lk (&rest args) (forward-message-to l_wrist_flex_link_lk args))
    (:l_forearm_link_lk (&rest args) (forward-message-to l_forearm_link_lk args))
    (:l_forearm_roll_link_lk (&rest args) (forward-message-to l_forearm_roll_link_lk args))
    (:l_elbow_flex_link_lk (&rest args) (forward-message-to l_elbow_flex_link_lk args))
    (:l_upper_arm_link_lk (&rest args) (forward-message-to l_upper_arm_link_lk args))
    (:l_upper_arm_roll_link_lk (&rest args) (forward-message-to l_upper_arm_roll_link_lk args))
    (:l_shoulder_lift_link_lk (&rest args) (forward-message-to l_shoulder_lift_link_lk args))
    (:l_shoulder_pan_link_lk (&rest args) (forward-message-to l_shoulder_pan_link_lk args))
    (:l_torso_lift_side_plate_link_lk (&rest args) (forward-message-to l_torso_lift_side_plate_link_lk args))
    (:laser_tilt_link_lk (&rest args) (forward-message-to laser_tilt_link_lk args))
    (:laser_tilt_mount_link_lk (&rest args) (forward-message-to laser_tilt_mount_link_lk args))
    (:r_forearm_cam_optical_frame_lk (&rest args) (forward-message-to r_forearm_cam_optical_frame_lk args))
    (:r_forearm_cam_frame_lk (&rest args) (forward-message-to r_forearm_cam_frame_lk args))
    (:r_gripper_l_finger_tip_link_lk (&rest args) (forward-message-to r_gripper_l_finger_tip_link_lk args))
    (:r_gripper_l_finger_link_lk (&rest args) (forward-message-to r_gripper_l_finger_link_lk args))
    (:r_gripper_led_frame_lk (&rest args) (forward-message-to r_gripper_led_frame_lk args))
    (:r_gripper_motor_accelerometer_link_lk (&rest args) (forward-message-to r_gripper_motor_accelerometer_link_lk args))
    (:r_gripper_motor_screw_link_lk (&rest args) (forward-message-to r_gripper_motor_screw_link_lk args))
    (:r_gripper_motor_slider_link_lk (&rest args) (forward-message-to r_gripper_motor_slider_link_lk args))
    (:r_gripper_l_finger_tip_frame_lk (&rest args) (forward-message-to r_gripper_l_finger_tip_frame_lk args))
    (:r_gripper_r_finger_tip_link_lk (&rest args) (forward-message-to r_gripper_r_finger_tip_link_lk args))
    (:r_gripper_r_finger_link_lk (&rest args) (forward-message-to r_gripper_r_finger_link_lk args))
    (:r_gripper_tool_frame_lk (&rest args) (forward-message-to r_gripper_tool_frame_lk args))
    (:r_gripper_palm_link_lk (&rest args) (forward-message-to r_gripper_palm_link_lk args))
    (:right_arm_chain_cb_link_lk (&rest args) (forward-message-to right_arm_chain_cb_link_lk args))
    (:r_wrist_roll_link_lk (&rest args) (forward-message-to r_wrist_roll_link_lk args))
    (:r_wrist_flex_link_lk (&rest args) (forward-message-to r_wrist_flex_link_lk args))
    (:r_forearm_link_lk (&rest args) (forward-message-to r_forearm_link_lk args))
    (:r_forearm_roll_link_lk (&rest args) (forward-message-to r_forearm_roll_link_lk args))
    (:r_elbow_flex_link_lk (&rest args) (forward-message-to r_elbow_flex_link_lk args))
    (:r_upper_arm_link_lk (&rest args) (forward-message-to r_upper_arm_link_lk args))
    (:r_upper_arm_roll_link_lk (&rest args) (forward-message-to r_upper_arm_roll_link_lk args))
    (:r_shoulder_lift_link_lk (&rest args) (forward-message-to r_shoulder_lift_link_lk args))
    (:r_shoulder_pan_link_lk (&rest args) (forward-message-to r_shoulder_pan_link_lk args))
    (:r_torso_lift_side_plate_link_lk (&rest args) (forward-message-to r_torso_lift_side_plate_link_lk args))
    (:torso_lift_link_lk (&rest args) (forward-message-to torso_lift_link_lk args))
    (:torso_lift_motor_screw_link_lk (&rest args) (forward-message-to torso_lift_motor_screw_link_lk args))
    (:base_link_lk (&rest args) (forward-message-to base_link_lk args))
    (:base_footprint_lk (&rest args) (forward-message-to base_footprint_lk args))

    ;; all manipulator

    ;; user-defined joint
    (:torso-waist-z (&rest args) (forward-message-to torso_lift_joint_jt args))
    (:larm-collar-y (&rest args) (forward-message-to l_shoulder_pan_joint_jt args))
    (:larm-shoulder-p (&rest args) (forward-message-to l_shoulder_lift_joint_jt args))
    (:larm-shoulder-r (&rest args) (forward-message-to l_upper_arm_roll_joint_jt args))
    (:larm-elbow-p (&rest args) (forward-message-to l_elbow_flex_joint_jt args))
    (:larm-elbow-r (&rest args) (forward-message-to l_forearm_roll_joint_jt args))
    (:larm-wrist-p (&rest args) (forward-message-to l_wrist_flex_joint_jt args))
    (:larm-wrist-r (&rest args) (forward-message-to l_wrist_roll_joint_jt args))
    (:rarm-collar-y (&rest args) (forward-message-to r_shoulder_pan_joint_jt args))
    (:rarm-shoulder-p (&rest args) (forward-message-to r_shoulder_lift_joint_jt args))
    (:rarm-shoulder-r (&rest args) (forward-message-to r_upper_arm_roll_joint_jt args))
    (:rarm-elbow-p (&rest args) (forward-message-to r_elbow_flex_joint_jt args))
    (:rarm-elbow-r (&rest args) (forward-message-to r_forearm_roll_joint_jt args))
    (:rarm-wrist-p (&rest args) (forward-message-to r_wrist_flex_joint_jt args))
    (:rarm-wrist-r (&rest args) (forward-message-to r_wrist_roll_joint_jt args))
    (:head-neck-y (&rest args) (forward-message-to head_pan_joint_jt args))
    (:head-neck-p (&rest args) (forward-message-to head_tilt_joint_jt args))

    ;; attach_sensor
  )

(defclass pr2_gkmodel0_base_footprint_geom0
  :super collada-body
  :slots ())
(defmethod pr2_gkmodel0_base_footprint_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 1.000000 1.000000 1.000000 1.000000))
             (list :diffuse (float-vector 1.000000 1.000000 1.000000 1.000000))
           ))
           (list :indices #i( 0 1 2 2 3 0 4 5 6 6 7 4 8 9 10 10 11 8 12 13 14 14 15 12 16 17 18 18 19 16 20 21 22 22 23 20))
           (list :vertices #2f((-2.5000000000000000e+00 -2.5000000000000000e+00 -2.5000000000000000e+00)(2.5000000000000000e+00 -2.5000000000000000e+00 -2.5000000000000000e+00)(2.5000000000000000e+00 -2.5000000000000000e+00 2.5000000000000000e+00)(-2.5000000000000000e+00 -2.5000000000000000e+00 2.5000000000000000e+00)(-2.5000000000000000e+00 2.5000000000000000e+00 2.5000000000000000e+00)(-2.5000000000000000e+00 -2.5000000000000000e+00 2.5000000000000000e+00)(2.5000000000000000e+00 -2.5000000000000000e+00 2.5000000000000000e+00)(2.5000000000000000e+00 2.5000000000000000e+00 2.5000000000000000e+00)(2.5000000000000000e+00 2.5000000000000000e+00 -2.5000000000000000e+00)(2.5000000000000000e+00 2.5000000000000000e+00 2.5000000000000000e+00)(2.5000000000000000e+00 -2.5000000000000000e+00 2.5000000000000000e+00)(2.5000000000000000e+00 -2.5000000000000000e+00 -2.5000000000000000e+00)(-2.5000000000000000e+00 -2.5000000000000000e+00 2.5000000000000000e+00)(-2.5000000000000000e+00 2.5000000000000000e+00 2.5000000000000000e+00)(-2.5000000000000000e+00 2.5000000000000000e+00 -2.5000000000000000e+00)(-2.5000000000000000e+00 -2.5000000000000000e+00 -2.5000000000000000e+00)(-2.5000000000000000e+00 -2.5000000000000000e+00 -2.5000000000000000e+00)(-2.5000000000000000e+00 2.5000000000000000e+00 -2.5000000000000000e+00)(2.5000000000000000e+00 2.5000000000000000e+00 -2.5000000000000000e+00)(2.5000000000000000e+00 -2.5000000000000000e+00 -2.5000000000000000e+00)(2.5000000000000000e+00 2.5000000000000000e+00 -2.5000000000000000e+00)(-2.5000000000000000e+00 2.5000000000000000e+00 -2.5000000000000000e+00)(-2.5000000000000000e+00 2.5000000000000000e+00 2.5000000000000000e+00)(2.5000000000000000e+00 2.5000000000000000e+00 2.5000000000000000e+00)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -2.4999999441206455e+00 -2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 -2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 -2.4999999441206455e+00 2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector -2.4999999441206455e+00 -2.4999999441206455e+00 2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 2.4999999441206455e+00 2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 -2.4999999441206455e+00 2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector 2.4999999441206455e+00 -2.4999999441206455e+00 2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 2.4999999441206455e+00 2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 2.4999999441206455e+00 -2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector 2.4999999441206455e+00 2.4999999441206455e+00 2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 -2.4999999441206455e+00 2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 -2.4999999441206455e+00 -2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector -2.4999999441206455e+00 -2.4999999441206455e+00 2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 2.4999999441206455e+00 2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 2.4999999441206455e+00 -2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector -2.4999999441206455e+00 -2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 -2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 2.4999999441206455e+00 -2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector 2.4999999441206455e+00 2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 -2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 2.4999999441206455e+00 -2.4999999441206455e+00)))
    (instance face :init :vertices (list (float-vector -2.4999999441206455e+00 2.4999999441206455e+00 -2.4999999441206455e+00) (float-vector -2.4999999441206455e+00 2.4999999441206455e+00 2.4999999441206455e+00) (float-vector 2.4999999441206455e+00 2.4999999441206455e+00 2.4999999441206455e+00)))
    ))
   )
  )

(defclass pr2_gkmodel0_base_link_geom0
  :super collada-body
  :slots ())
(defmethod pr2_gkmodel0_base_link_geom0
  (:init (&key (name "package://pr2_description/meshes/base_v0/base.dae"))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 1.000000 1.000000 1.000000 1.000000))
             (list :diffuse (float-vector 1.000000 1.000000 1.000000 1.000000))
           ))
           (list :indices #i( 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256 257 258 259 260 261 262 263 264 265 266 267 268 269 270 271 272 273 274 275 276 277 278 279 280 281 282 283 284 285 286 287 288 289 290 291 292 293 294 295 296 297 298 299 300 301 302 303 304 305 306 307 308 309 310 311 312 313 314 315 316 317 318 319 320 321 322 323 324 325 326 327 328 329 330 331 332 333 334 335 336 337 338 339 340 341 342 343 344 345 346 347 348 349 350 351 352 353 354 355 356 357 358 359 360 361 362 363 364 365 366 367 368 369 370 371 372 373 374 375 376 377 378 379 380 381 382 383 384 385 386 387 388 389 390 391 392 393 394 395 396 397 398 399 400 401 402 403 404 405 406 407 408 409 410 411 412 413 414 415 416 417 418 419 420 421 422 423 424 425 426 427 428 429 430 431 432 433 434 435 436 437 438 439 440 441 442 443 444 445 446 447 448 449 450 451 452 453 454 455 456 457 458 459 460 461 462 463 464 465 466 467 468 469 470 471 472 473 474 475 476 477 478 479 480 481 482 483 484 485 486 487 488 489 490 491 492 493 494 495 496 497 498 499 500 501 502 503 504 505 506 507 508 509 510 511 512 513 514 515 516 517 518 519 520 521 522 523 524 525 526 527 528 529 530 531 532 533 534 535 536 537 538 539 540 541 542 543 544 545 546 547 548 549 550 551 552 553 554 555 556 557 558 559 560 561 562 563 564 565 566 567 568 569 570 571 572 573 574 575 576 577 578 579 580 581 582 583 584 585 586 587 588 589 590 591 592 593 594 595 596 597 598 599 600 601 602 603 604 605 606 607 608 609 610 611 612 613 614 615 616 617 618 619 620 621 622 623 624 625 626 627 628 629 630 631 632 633 634 635 636 637 638 639 640 641 642 643 644 645 646 647 648 649 650 651 652 653 654 655 656 657 658 659 660 661 662 663 664 665 666 667 668 669 670 671 672 673 674 675 676 677 678 679 680 681 682 683 684 685 686 687 688 689 690 691 692 693 694 695 696 697 698 699 700 701 702 703 704 705 706 707 708 709 710 711 712 713 714 715 716 717 718 719 720 721 722 723 724 725 726 727 728 729 730 731 732 733 734 735 736 737 738 739 740 741 742 743 744 745 746 747 748 749 750 751 752 753 754 755 756 757 758 759 760 761 762 763 764 765 766 767 768 769 770 771 772 773 774 775 776 777 778 779 780 781 782 783 784 785 786 787 788 789 790 791 792 793 794 795 796 797 798 799 800 801 802 803 804 805 806 807 808 809 810 811 812 813 814 815 816 817 818 819 820 821 822 823 824 825 826 827 828 829 830 831 832 833 834 835 836 837 838 839 840 841 842 843 844 845 846 847 848 849 850 851 852 853 854 855 856 857 858 859 860 861 862 863 864 865 866 867 868 869 870 871 872 873 874 875 876 877 878 879 880 881 882 883 884 885 886 887 888 889 890 891 892 893 894 895 896 897 898 899 900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915 916 917 918 919 920 921 922 923 924 925 926 927 928 929 930 931 932 933 934 935 936 937 938 939 940 941 942 943 944 945 946 947 948 949 950 951 952 953 954 955 956 957 958 959 960 961 962 963 964 965 966 967 968 969 970 971 972 973 974 975 976 977 978 979 980 981 982 983 984 985 986 987 988 989 990 991 992 993 994 995 996 997 998 999 1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248 1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 1295 1296 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 1312 1313 1314 1315 1316 1317 1318 1319 1320 1321 1322 1323 1324 1325 1326 1327 1328 1329 1330 1331 1332 1333 1334 1335 1336 1337 1338 1339 1340 1341 1342 1343 1344 1345 1346 1347 1348 1349 1350 1351 1352 1353 1354 1355 1356 1357 1358 1359 1360 1361 1362 1363 1364 1365 1366 1367 1368 1369 1370 1371 1372 1373 1374 1375 1376 1377 1378 1379 1380 1381 1382 1383 1384 1385 1386 1387 1388 1389 1390 1391 1392 1393 1394 1395 1396 1397 1398 1399 1400 1401 1402 1403 1404 1405 1406 1407 1408 1409 1410 1411 1412 1413 1414 1415 1416 1417 1418 1419 1420 1421 1422 1423 1424 1425 1426 1427 1428 1429 1430 1431 1432 1433 1434 1435 1436 1437 1438 1439 1440 1441 1442 1443 1444 1445 1446 1447 1448 1449 1450 1451 1452 1453 1454 1455 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1473 1474 1475 1476 1477 1478 1479 1480 1481 1482 1483 1484 1485 1486 1487 1488 1489 1490 1491 1492 1493 1494 1495 1496 1497 1498 1499 1500 1501 1502 1503 1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1520 1521 1522 1523 1524 1525 1526 1527 1528 1529 1530 1531 1532 1533 1534 1535 1536 1537 1538 1539 1540 1541 1542 1543 1544 1545 1546 1547 1548 1549 1550 1551 1552 1553 1554 1555 1556 1557 1558 1559 1560 1561 1562 1563 1564 1565 1566 1567 1568 1569 1570 1571 1572 1573 1574 1575 1576 1577 1578 1579 1580 1581 1582 1583 1584 1585 1586 1587 1588 1589 1590 1591 1592 1593 1594 1595 1596 1597 1598 1599 1600 1601 1602 1603 1604 1605 1606 1607 1608 1609 1610 1611 1612 1613 1614 1615 1616 1617 1618 1619 1620 1621 1622 1623 1624 1625 1626 1627 1628 1629 1630 1631 1632 1633 1634 1635 1636 1637 1638 1639 1640 1641 1642 1643 1644 1645 1646 1647 1648 1649 1650 1651 1652 1653 1654 1655 1656 1657 1658 1659 1660 1661 1662 1663 1664 1665 1666 1667 1668 1669 1670 1671 1672 1673 1674 1675 1676 1677 1678 1679 1680 1681 1682 1683 1684 1685 1686 1687 1688 1689 1690 1691 1692 1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721 1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733 1734 1735 1736 1737 1738 1739 1740 1741 1742 1743 1744 1745 1746 1747 1748 1749 1750 1751 1752 1753 1754 1755 1756 1757 1758 1759 1760 1761 1762 1763 1764 1765 1766 1767 1768 1769 1770 1771 1772 1773 1774 1775 1776 1777 1778 1779 1780 1781 1782 1783 1784 1785 1786 1787 1788 1789 1790 1791 1792 1793 1794 1795 1796 1797 1798 1799 1800 1801 1802 1803 1804 1805 1806 1807 1808 1809 1810 1811 1812 1813 1814 1815 1816 1817 1818 1819 1820 1821 1822 1823 1824 1825 1826 1827 1828 1829 1830 1831 1832 1833 1834 1835 1836 1837 1838 1839 1840 1841 1842 1843 1844 1845 1846 1847 1848 1849 1850 1851 1852 1853 1854 1855 1856 1857 1858 1859 1860 1861 1862 1863 1864 1865 1866 1867 1868 1869 1870 1871 1872 1873 1874 1875 1876 1877 1878 1879 1880 1881 1882 1883 1884 1885 1886 1887 1888 1889 1890 1891 1892 1893 1894 1895 1896 1897 1898 1899 1900 1901 1902 1903 1904 1905 1906 1907 1908 1909 1910 1911 1912 1913 1914 1915 1916 1917 1918 1919 1920 1921 1922 1923 1924 1925 1926 1927 1928 1929 1930 1931 1932 1933 1934 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1961 1962 1963 1964 1965 1966 1967 1968 1969 1970 1971 1972 1973 1974 1975 1976 1977 1978 1979 1980 1981 1982 1983 1984 1985 1986 1987 1988 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 2023 2024 2025 2026 2027 2028 2029 2030 2031 2032 2033 2034 2035 2036 2037 2038 2039 2040 2041 2042 2043 2044 2045 2046 2047 2048 2049 2050 2051 2052 2053 2054 2055 2056 2057 2058 2059 2060 2061 2062 2063 2064 2065 2066 2067 2068 2069 2070 2071 2072 2073 2074 2075 2076 2077 2078 2079 2080 2081 2082 2083 2084 2085 2086 2087 2088 2089 2090 2091 2092 2093 2094 2095 2096 2097 2098 2099 2100 2101 2102 2103 2104 2105 2106 2107 2108 2109 2110 2111 2112 2113 2114 2115 2116 2117 2118 2119 2120 2121 2122 2123 2124 2125 2126 2127 2128 2129 2130 2131 2132 2133 2134 2135 2136 2137 2138 2139 2140 2141 2142 2143 2144 2145 2146 2147 2148 2149 2150 2151 2152 2153 2154 2155 2156 2157 2158 2159 2160 2161 2162 2163 2164 2165 2166 2167 2168 2169 2170 2171 2172 2173 2174 2175 2176 2177 2178 2179 2180 2181 2182 2183 2184 2185 2186 2187 2188 2189 2190 2191 2192 2193 2194 2195 2196 2197 2198 2199 2200 2201 2202 2203 2204 2205 2206 2207 2208 2209 2210 2211 2212 2213 2214 2215 2216 2217 2218 2219 2220 2221 2222 2223 2224 2225 2226 2227 2228 2229 2230 2231 2232 2233 2234 2235 2236 2237 2238 2239 2240 2241 2242 2243 2244 2245 2246 2247 2248 2249 2250 2251 2252 2253 2254 2255 2256 2257 2258 2259 2260 2261 2262 2263 2264 2265 2266 2267 2268 2269 2270 2271 2272 2273 2274 2275 2276 2277 2278 2279 2280 2281 2282 2283 2284 2285 2286 2287 2288 2289 2290 2291 2292 2293 2294 2295 2296 2297 2298 2299 2300 2301 2302 2303 2304 2305 2306 2307 2308 2309 2310 2311 2312 2313 2314 2315 2316 2317 2318 2319 2320 2321 2322 2323 2324 2325 2326 2327 2328 2329 2330 2331 2332 2333 2334 2335 2336 2337 2338 2339 2340 2341 2342 2343 2344 2345 2346 2347 2348 2349 2350 2351 2352 2353 2354 2355 2356 2357 2358 2359 2360 2361 2362 2363 2364 2365 2366 2367 2368 2369 2370 2371 2372 2373 2374 2375 2376 2377 2378 2379 2380 2381 2382 2383 2384 2385 2386 2387 2388 2389 2390 2391 2392 2393 2394 2395 2396 2397 2398 2399 2400 2401 2402 2403 2404 2405 2406 2407 2408 2409 2410 2411 2412 2413 2414 2415 2416 2417 2418 2419 2420 2421 2422 2423 2424 2425 2426 2427 2428 2429 2430 2431 2432 2433 2434 2435 2436 2437 2438 2439 2440 2441 2442 2443 2444 2445 2446 2447 2448 2449 2450 2451 2452 2453 2454 2455 2456 2457 2458 2459 2460 2461 2462 2463 2464 2465 2466 2467 2468 2469 2470 2471 2472 2473 2474 2475 2476 2477 2478 2479 2480 2481 2482 2483 2484 2485 2486 2487 2488 2489 2490 2491 2492 2493 2494 2495 2496 2497 2498 2499 2500 2501 2502 2503 2504 2505 2506 2507 2508 2509 2510 2511 2512 2513 2514 2515 2516 2517 2518 2519 2520 2521 2522 2523 2524 2525 2526 2527 2528 2529 2530 2531 2532 2533 2534 2535 2536 2537 2538 2539 2540 2541 2542 2543 2544 2545 2546 2547 2548 2549 2550 2551 2552 2553 2554 2555 2556 2557 2558 2559 2560 2561 2562 2563 2564 2565 2566 2567 2568 2569 2570 2571 2572 2573 2574 2575 2576 2577 2578 2579 2580 2581 2582 2583 2584 2585 2586 2587 2588 2589 2590 2591 2592 2593 2594 2595 2596 2597 2598 2599 2600 2601 2602 2603 2604 2605 2606 2607 2608 2609 2610 2611 2612 2613 2614 2615 2616 2617 2618 2619 2620 2621 2622 2623 2624 2625 2626 2627 2628 2629 2630 2631 2632 2633 2634 2635 2636 2637 2638 2639 2640 2641 2642 2643 2644 2645 2646 2647 2648 2649 2650 2651 2652 2653 2654 2655 2656 2657 2658 2659 2660 2661 2662 2663 2664 2665 2666 2667 2668 2669 2670 2671 2672 2673 2674 2675 2676 2677 2678 2679 2680 2681 2682 2683 2684 2685 2686 2687 2688 2689 2690 2691 2692 2693 2694 2695 2696 2697 2698 2699 2700 2701 2702 2703 2704 2705 2706 2707 2708 2709 2710 2711 2712 2713 2714 2715 2716 2717 2718 2719 2720 2721 2722 2723 2724 2725 2726 2727 2728 2729 2730 2731 2732 2733 2734 2735 2736 2737 2738 2739 2740 2741 2742 2743 2744 2745 2746 2747 2748 2749 2750 2751 2752 2753 2754 2755 2756 2757 2758 2759 2760 2761 2762 2763 2764 2765 2766 2767 2768 2769 2770 2771 2772 2773 2774 2775 2776 2777 2778 2779 2780 2781 2782 2783 2784 2785 2786 2787 2788 2789 2790 2791 2792 2793 2794 2795 2796 2797 2798 2799 2800 2801 2802 2803 2804 2805 2806 2807 2808 2809 2810 2811 2812 2813 2814 2815 2816 2817 2818 2819 2820 2821 2822 2823 2824 2825 2826 2827 2828 2829 2830 2831 2832 2833 2834 2835 2836 2837 2838 2839 2840 2841 2842 2843 2844 2845 2846 2847 2848 2849 2850 2851 2852 2853 2854 2855 2856 2857 2858 2859 2860 2861 2862 2863 2864 2865 2866 2867 2868 2869 2870 2871 2872 2873 2874 2875 2876 2877 2878 2879 2880 2881 2882 2883 2884 2885 2886 2887 2888 2889 2890 2891 2892 2893 2894 2895 2896 2897 2898 2899 2900 2901 2902 2903 2904 2905 2906 2907 2908 2909 2910 2911 2912 2913 2914 2915 2916 2917 2918 2919 2920 2921 2922 2923 2924 2925 2926 2927 2928 2929 2930 2931 2932 2933 2934 2935 2936 2937 2938 2939 2940 2941 2942 2943 2944 2945 2946 2947 2948 2949 2950 2951 2952 2953 2954 2955 2956 2957 2958 2959 2960 2961 2962 2963 2964 2965 2966 2967 2968 2969 2970 2971 2972 2973 2974 2975 2976 2977 2978 2979 2980 2981 2982 2983 2984 2985 2986 2987 2988 2989 2990 2991 2992 2993 2994 2995 2996 2997 2998 2999 3000 3001 3002 3003 3004 3005 3006 3007 3008 3009 3010 3011 3012 3013 3014 3015 3016 3017 3018 3019 3020 3021 3022 3023 3024 3025 3026 3027 3028 3029 3030 3031 3032 3033 3034 3035 3036 3037 3038 3039 3040 3041 3042 3043 3044 3045 3046 3047 3048 3049 3050 3051 3052 3053 3054 3055 3056 3057 3058 3059 3060 3061 3062 3063 3064 3065 3066 3067 3068 3069 3070 3071 3072 3073 3074 3075 3076 3077 3078 3079 3080 3081 3082 3083 3084 3085 3086 3087 3088 3089 3090 3091 3092 3093 3094 3095 3096 3097 3098 3099 3100 3101 3102 3103 3104 3105 3106 3107 3108 3109 3110 3111 3112 3113 3114 3115 3116 3117 3118 3119 3120 3121 3122 3123 3124 3125 3126 3127 3128 3129 3130 3131 3132 3133 3134 3135 3136 3137 3138 3139 3140 3141 3142 3143 3144 3145 3146 3147 3148 3149 3150 3151 3152 3153 3154 3155 3156 3157 3158 3159 3160 3161 3162 3163 3164 3165 3166 3167 3168 3169 3170 3171 3172 3173 3174 3175 3176 3177 3178 3179 3180 3181 3182 3183 3184 3185 3186 3187 3188 3189 3190 3191 3192 3193 3194 3195 3196 3197 3198 3199 3200 3201 3202 3203 3204 3205 3206 3207 3208 3209 3210 3211 3212 3213 3214 3215 3216 3217 3218 3219 3220 3221 3222 3223 3224 3225 3226 3227 3228 3229 3230 3231 3232 3233 3234 3235 3236 3237 3238 3239 3240 3241 3242 3243 3244 3245 3246 3247 3248 3249 3250 3251 3252 3253 3254 3255 3256 3257 3258 3259 3260 3261 3262 3263 3264 3265 3266 3267 3268 3269 3270 3271 3272 3273 3274 3275 3276 3277 3278 3279 3280 3281 3282 3283 3284 3285 3286 3287 3288 3289 3290 3291 3292 3293 3294 3295 3296 3297 3298 3299 3300 3301 3302 3303 3304 3305 3306 3307 3308 3309 3310 3311 3312 3313 3314 3315 3316 3317 3318 3319 3320 3321 3322 3323 3324 3325 3326 3327 3328 3329 3330 3331 3332 3333 3334 3335 3336 3337 3338 3339 3340 3341 3342 3343 3344 3345 3346 3347 3348 3349 3350 3351 3352 3353 3354 3355 3356 3357 3358 3359 3360 3361 3362 3363 3364 3365 3366 3367 3368 3369 3370 3371 3372 3373 3374 3375 3376 3377 3378 3379 3380 3381 3382 3383 3384 3385 3386 3387 3388 3389 3390 3391 3392 3393 3394 3395 3396 3397 3398 3399 3400 3401 3402 3403 3404 3405 3406 3407 3408 3409 3410 3411 3412 3413 3414 3415 3416 3417 3418 3419 3420 3421 3422 3423 3424 3425 3426 3427 3428 3429 3430 3431 3432 3433 3434 3435 3436 3437 3438 3439 3440 3441 3442 3443 3444 3445 3446 3447 3448 3449 3450 3451 3452 3453 3454 3455 3456 3457 3458 3459 3460 3461 3462 3463 3464 3465 3466 3467 3468 3469 3470 3471 3472 3473 3474 3475 3476 3477 3478 3479 3480 3481 3482 3483 3484 3485 3486 3487 3488 3489 3490 3491 3492 3493 3494 3495 3496 3497 3498 3499 3500 3501 3502 3503 3504 3505 3506 3507 3508 3509 3510 3511 3512 3513 3514 3515 3516 3517 3518 3519 3520 3521 3522 3523 3524 3525 3526 3527 3528 3529 3530 3531 3532 3533 3534 3535 3536 3537 3538 3539 3540 3541 3542 3543 3544 3545 3546 3547 3548 3549 3550 3551 3552 3553 3554 3555 3556 3557 3558 3559 3560 3561 3562 3563 3564 3565 3566 3567 3568 3569 3570 3571 3572 3573 3574 3575 3576 3577 3578 3579 3580 3581 3582 3583 3584 3585 3586 3587 3588 3589 3590 3591 3592 3593 3594 3595 3596 3597 3598 3599))
           (list :vertices #2f((3.0023101806640625e+02 -2.9510543823242188e+02 8.9796104431152344e+01)(2.9685311889648438e+02 -2.9019723510742188e+02 2.0282299804687500e+02)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.3932618713378906e+02 -3.2802960205078125e+02 9.5508102416992188e+01)(2.3239700317382812e+02 -3.2586651611328125e+02 2.0497380065917969e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(2.9685311889648438e+02 -2.9019723510742188e+02 2.0282299804687500e+02)(3.0023101806640625e+02 -2.9510543823242188e+02 8.9796104431152344e+01)(3.1445388793945312e+02 -2.7596820068359375e+02 8.8462303161621094e+01)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.3239700317382812e+02 -3.2586651611328125e+02 2.0497380065917969e+02)(2.3932618713378906e+02 -3.2802960205078125e+02 9.5508102416992188e+01)(2.9685311889648438e+02 -2.9019723510742188e+02 2.0282299804687500e+02)(2.7943020629882812e+02 -3.0593048095703125e+02 2.0310668945312500e+02)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.6038513183593750e+02 -3.1690469360351562e+02 2.0475199890136719e+02)(2.3239700317382812e+02 -3.2586651611328125e+02 2.0497380065917969e+02)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.1106390380859375e+02 -2.6823260498046875e+02 2.0371539306640625e+02)(3.1445388793945312e+02 -2.7596820068359375e+02 8.8462303161621094e+01)(2.9685311889648438e+02 -2.9019723510742188e+02 2.0282299804687500e+02)(3.1445388793945312e+02 -2.7596820068359375e+02 8.8462303161621094e+01)(3.1106390380859375e+02 -2.6823260498046875e+02 2.0371539306640625e+02)(3.1945962524414062e+02 -2.4776422119140625e+02 2.0187261962890625e+02)(3.1106390380859375e+02 -2.6823260498046875e+02 2.0371539306640625e+02)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.1945962524414062e+02 -2.4776422119140625e+02 2.0187261962890625e+02)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.7943020629882812e+02 -3.0593048095703125e+02 2.0310668945312500e+02)(2.6038513183593750e+02 -3.1690469360351562e+02 2.0475199890136719e+02)(2.0341001892089844e+02 -3.2873802185058594e+01 2.8613092041015625e+02)(2.1236601257324219e+02 -3.3848201751708984e+01 2.8970831298828125e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(1.8414239501953125e+02 2.4342498779296875e+01 2.6370303344726562e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(2.0572431945800781e+02 3.4897899627685547e+01 2.8684948730468750e+02)(1.8414239501953125e+02 2.4342498779296875e+01 2.6370303344726562e+02)(1.8070700073242188e+02 -3.2239003181457520e+00 2.6211441040039062e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(1.6318861389160156e+02 2.1084100723266602e+01 2.3087869262695312e+02)(1.8414239501953125e+02 2.4342498779296875e+01 2.6370303344726562e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(1.6318861389160156e+02 2.1084100723266602e+01 2.3087869262695312e+02)(1.8070700073242188e+02 -3.2239003181457520e+00 2.6211441040039062e+02)(1.8414239501953125e+02 2.4342498779296875e+01 2.6370303344726562e+02)(1.8070700073242188e+02 -3.2239003181457520e+00 2.6211441040039062e+02)(1.6318861389160156e+02 2.1084100723266602e+01 2.3087869262695312e+02)(1.6247010803222656e+02 -1.6208400726318359e+01 2.3121670532226562e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(1.8414239501953125e+02 2.4342498779296875e+01 2.6370303344726562e+02)(2.0572431945800781e+02 3.4897899627685547e+01 2.8684948730468750e+02)(2.0341001892089844e+02 -3.2873802185058594e+01 2.8613092041015625e+02)(1.8070700073242188e+02 -3.2239003181457520e+00 2.6211441040039062e+02)(1.9430111694335938e+02 -3.7104000091552734e+01 2.7371371459960938e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(1.8070700073242188e+02 -3.2239003181457520e+00 2.6211441040039062e+02)(2.0341001892089844e+02 -3.2873802185058594e+01 2.8613092041015625e+02)(1.9430111694335938e+02 -3.7104000091552734e+01 2.7371371459960938e+02)(1.6247010803222656e+02 -1.6208400726318359e+01 2.3121670532226562e+02)(1.6974850463867188e+02 -4.1104999542236328e+01 2.3073179626464844e+02)(1.6247010803222656e+02 -1.6208400726318359e+01 2.3121670532226562e+02)(1.9430111694335938e+02 -3.7104000091552734e+01 2.7371371459960938e+02)(1.8070700073242188e+02 -3.2239003181457520e+00 2.6211441040039062e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(1.6974850463867188e+02 -4.1104999542236328e+01 2.3073179626464844e+02)(1.9430111694335938e+02 -3.7104000091552734e+01 2.7371371459960938e+02)(1.6974850463867188e+02 -4.1104999542236328e+01 2.3073179626464844e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.0341001892089844e+02 -3.2873802185058594e+01 2.8613092041015625e+02)(1.9430111694335938e+02 -3.7104000091552734e+01 2.7371371459960938e+02)(2.1236601257324219e+02 -3.3848201751708984e+01 2.8970831298828125e+02)(2.0341001892089844e+02 -3.2873802185058594e+01 2.8613092041015625e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.1236601257324219e+02 -3.3848201751708984e+01 2.8970831298828125e+02)(2.4219799804687500e+02 -3.8239101409912109e+01 2.8896481323242188e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.1236601257324219e+02 -3.3848201751708984e+01 2.8970831298828125e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.4219799804687500e+02 -3.8239101409912109e+01 2.8896481323242188e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(2.4219799804687500e+02 -3.8239101409912109e+01 2.8896481323242188e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(2.3372630310058594e+02 1.3878700256347656e+01 2.9442251586914062e+02)(2.0572431945800781e+02 3.4897899627685547e+01 2.8684948730468750e+02)(2.3372630310058594e+02 1.3878700256347656e+01 2.9442251586914062e+02)(2.4475959777832031e+02 3.6303901672363281e+01 2.9160040283203125e+02)(2.0572431945800781e+02 3.4897899627685547e+01 2.8684948730468750e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.3372630310058594e+02 1.3878700256347656e+01 2.9442251586914062e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.0356951904296875e+02 1.1938899993896484e+01 2.8872341918945312e+02)(2.1236601257324219e+02 -3.3848201751708984e+01 2.8970831298828125e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(2.0504789733886719e+02 -4.2515098571777344e+01 2.5409611511230469e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(1.9998240661621094e+02 -4.3613300323486328e+01 2.3669989013671875e+02)(2.0504789733886719e+02 -4.2515098571777344e+01 2.5409611511230469e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(2.0852438354492188e+02 -3.9552600860595703e+01 2.8390798950195312e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(2.0504789733886719e+02 -4.2515098571777344e+01 2.5409611511230469e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(2.0038250732421875e+02 -4.3849502563476562e+01 2.3306179809570312e+02)(1.9998240661621094e+02 -4.3613300323486328e+01 2.3669989013671875e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(2.6420819091796875e+02 -1.1748100280761719e+01 2.9402301025390625e+02)(2.9603591918945312e+02 -3.2186901092529297e+01 2.9027291870117188e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.6420819091796875e+02 -1.1748100280761719e+01 2.9402301025390625e+02)(2.3372630310058594e+02 1.3878700256347656e+01 2.9442251586914062e+02)(2.6420819091796875e+02 -1.1748100280761719e+01 2.9402301025390625e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.9603591918945312e+02 -3.2186901092529297e+01 2.9027291870117188e+02)(2.6420819091796875e+02 -1.1748100280761719e+01 2.9402301025390625e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(2.3372630310058594e+02 1.3878700256347656e+01 2.9442251586914062e+02)(2.3372630310058594e+02 1.3878700256347656e+01 2.9442251586914062e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(2.4475959777832031e+02 3.6303901672363281e+01 2.9160040283203125e+02)(2.9394741821289062e+02 3.9552101135253906e+01 2.8417849731445312e+02)(2.0685661315917969e+02 3.9679103851318359e+01 2.8336538696289062e+02)(2.4475959777832031e+02 3.6303901672363281e+01 2.9160040283203125e+02)(2.4475959777832031e+02 3.6303901672363281e+01 2.9160040283203125e+02)(2.0685661315917969e+02 3.9679103851318359e+01 2.8336538696289062e+02)(2.0572431945800781e+02 3.4897899627685547e+01 2.8684948730468750e+02)(2.9394741821289062e+02 3.9552101135253906e+01 2.8417849731445312e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.0685661315917969e+02 3.9679103851318359e+01 2.8336538696289062e+02)(2.0000270080566406e+02 4.3601001739501953e+01 2.3701631164550781e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.0685661315917969e+02 3.9679103851318359e+01 2.8336538696289062e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.0000270080566406e+02 4.3601001739501953e+01 2.3701631164550781e+02)(2.0004101562500000e+02 4.3783702850341797e+01 2.3365600585937500e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.0572431945800781e+02 3.4897899627685547e+01 2.8684948730468750e+02)(2.0685661315917969e+02 3.9679103851318359e+01 2.8336538696289062e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(2.0685661315917969e+02 3.9679103851318359e+01 2.8336538696289062e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(1.7663949584960938e+02 -4.7864299774169922e+01 2.3029220581054688e+02)(2.9806121826171875e+02 -1.2864790344238281e+02 2.2609260559082031e+02)(2.9769631958007812e+02 -6.7902099609375000e+01 2.2685220336914062e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(2.2196319580078125e+02 -2.5503752136230469e+02 2.2738389587402344e+02)(2.6352502441406250e+02 -1.3535369873046875e+02 2.2748069763183594e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(2.2196319580078125e+02 -2.5503752136230469e+02 2.2738389587402344e+02)(1.6247010803222656e+02 -1.6208400726318359e+01 2.3121670532226562e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(-9.6139999389648438e+01 -2.4160598754882812e+01 2.3190240478515625e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(-9.6139999389648438e+01 -2.4160598754882812e+01 2.3190240478515625e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(6.9552398681640625e+01 -3.0918200683593750e+02 2.2882481384277344e+02)(2.2196319580078125e+02 -2.5503752136230469e+02 2.2738389587402344e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(6.9552398681640625e+01 -3.0918200683593750e+02 2.2882481384277344e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(-9.6139999389648438e+01 -2.4160598754882812e+01 2.3190240478515625e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(2.6352502441406250e+02 -1.3535369873046875e+02 2.2748069763183594e+02)(2.9806121826171875e+02 -1.2864790344238281e+02 2.2609260559082031e+02)(1.7663949584960938e+02 -4.7864299774169922e+01 2.3029220581054688e+02)(1.6974850463867188e+02 -4.1104999542236328e+01 2.3073179626464844e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(1.6247010803222656e+02 -1.6208400726318359e+01 2.3121670532226562e+02)(7.8551795959472656e+01 -1.3927780151367188e+02 2.3148970031738281e+02)(1.6974850463867188e+02 -4.1104999542236328e+01 2.3073179626464844e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(1.6974850463867188e+02 -4.1104999542236328e+01 2.3073179626464844e+02)(1.7663949584960938e+02 -4.7864299774169922e+01 2.3029220581054688e+02)(1.9998240661621094e+02 -4.3613300323486328e+01 2.3669989013671875e+02)(2.0038250732421875e+02 -4.3849502563476562e+01 2.3306179809570312e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0000270080566406e+02 4.3601001739501953e+01 2.3701631164550781e+02)(2.0504789733886719e+02 -4.2515098571777344e+01 2.5409611511230469e+02)(1.9998240661621094e+02 -4.3613300323486328e+01 2.3669989013671875e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.0504789733886719e+02 -4.2515098571777344e+01 2.5409611511230469e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.4542260742187500e+02 -1.5419300079345703e+01 2.6382940673828125e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.3913789367675781e+02 6.2230002880096436e-01 2.6383630371093750e+02)(2.5926229858398438e+02 -2.3050600051879883e+01 2.6383670043945312e+02)(2.9569934082031250e+02 -3.9568901062011719e+01 2.6384588623046875e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.3913789367675781e+02 6.2230002880096436e-01 2.6383630371093750e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.4542260742187500e+02 -1.5419300079345703e+01 2.6382940673828125e+02)(2.5926229858398438e+02 -2.3050600051879883e+01 2.6383670043945312e+02)(2.5926229858398438e+02 -2.3050600051879883e+01 2.6383670043945312e+02)(2.7478561401367188e+02 -1.9590099334716797e+01 2.6383279418945312e+02)(2.9569934082031250e+02 -3.9568901062011719e+01 2.6384588623046875e+02)(2.7478561401367188e+02 -1.9590099334716797e+01 2.6383279418945312e+02)(2.8245910644531250e+02 -1.1313299179077148e+01 2.6383190917968750e+02)(2.9569934082031250e+02 -3.9568901062011719e+01 2.6384588623046875e+02)(2.8245910644531250e+02 -1.1313299179077148e+01 2.6383190917968750e+02)(2.8575000000000000e+02 1.5033000707626343e+00 2.6383493041992188e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(2.8245910644531250e+02 -1.1313299179077148e+01 2.6383190917968750e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(2.9569934082031250e+02 -3.9568901062011719e+01 2.6384588623046875e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(2.1288310241699219e+02 -4.1764999389648438e+01 2.6288610839843750e+02)(2.9569934082031250e+02 -3.9568901062011719e+01 2.6384588623046875e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.3130610656738281e+02 -4.3458599090576172e+01 2.3095520019531250e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(2.0768621826171875e+02 -4.6056400299072266e+01 2.2998071289062500e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(1.7663949584960938e+02 -4.7864299774169922e+01 2.3029220581054688e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(2.0038250732421875e+02 -4.3849502563476562e+01 2.3306179809570312e+02)(1.7928419494628906e+02 -4.4960498809814453e+01 2.3207600402832031e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(2.3130610656738281e+02 -4.3458599090576172e+01 2.3095520019531250e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.0768621826171875e+02 -4.6056400299072266e+01 2.2998071289062500e+02)(2.0768621826171875e+02 -4.6056400299072266e+01 2.2998071289062500e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(2.0768621826171875e+02 -4.6056400299072266e+01 2.2998071289062500e+02)(1.7663949584960938e+02 -4.7864299774169922e+01 2.3029220581054688e+02)(2.3130610656738281e+02 -4.3458599090576172e+01 2.3095520019531250e+02)(2.0768621826171875e+02 -4.6056400299072266e+01 2.2998071289062500e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(2.0768621826171875e+02 -4.6056400299072266e+01 2.2998071289062500e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(1.7663949584960938e+02 -4.7864299774169922e+01 2.3029220581054688e+02)(2.9603591918945312e+02 -3.2186901092529297e+01 2.9027291870117188e+02)(3.0025479125976562e+02 -3.3223201751708984e+01 2.8501821899414062e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(2.9603591918945312e+02 -3.2186901092529297e+01 2.9027291870117188e+02)(2.3323519897460938e+02 -3.3860904693603516e+01 2.9295523071289062e+02)(2.4219799804687500e+02 -3.8239101409912109e+01 2.8896481323242188e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(2.9603591918945312e+02 -3.2186901092529297e+01 2.9027291870117188e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(3.0025479125976562e+02 -3.3223201751708984e+01 2.8501821899414062e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(3.0025479125976562e+02 -3.3223201751708984e+01 2.8501821899414062e+02)(3.0006298828125000e+02 3.3962200164794922e+01 2.8493591308593750e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(3.0006298828125000e+02 3.3962200164794922e+01 2.8493591308593750e+02)(2.9394741821289062e+02 3.9552101135253906e+01 2.8417849731445312e+02)(2.9394741821289062e+02 3.9552101135253906e+01 2.8417849731445312e+02)(2.4475959777832031e+02 3.6303901672363281e+01 2.9160040283203125e+02)(2.9490811157226562e+02 3.3810501098632812e+01 2.9029711914062500e+02)(2.9394741821289062e+02 3.9552101135253906e+01 2.8417849731445312e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.0504789733886719e+02 -4.2515098571777344e+01 2.5409611511230469e+02)(2.0000270080566406e+02 4.3601001739501953e+01 2.3701631164550781e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(1.9998240661621094e+02 -4.3613300323486328e+01 2.3669989013671875e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0000270080566406e+02 4.3601001739501953e+01 2.3701631164550781e+02)(2.0000270080566406e+02 4.3601001739501953e+01 2.3701631164550781e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0004101562500000e+02 4.3783702850341797e+01 2.3365600585937500e+02)(2.1501679992675781e+02 4.7756103515625000e+01 2.2940098571777344e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.2939761352539062e+02 4.5011501312255859e+01 2.2961730957031250e+02)(1.9177980041503906e+02 4.6298797607421875e+01 2.3043708801269531e+02)(2.0243080139160156e+02 4.4678501129150391e+01 2.3132861328125000e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.1501679992675781e+02 4.7756103515625000e+01 2.2940098571777344e+02)(1.9177980041503906e+02 4.6298797607421875e+01 2.3043708801269531e+02)(1.9177980041503906e+02 4.6298797607421875e+01 2.3043708801269531e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.0074470520019531e+02 4.4034297943115234e+01 2.3251431274414062e+02)(2.2939761352539062e+02 4.5011501312255859e+01 2.2961730957031250e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.2939761352539062e+02 4.5011501312255859e+01 2.2961730957031250e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.1501679992675781e+02 4.7756103515625000e+01 2.2940098571777344e+02)(2.1501679992675781e+02 4.7756103515625000e+01 2.2940098571777344e+02)(1.7758988952636719e+02 4.7441703796386719e+01 2.3028540039062500e+02)(1.9177980041503906e+02 4.6298797607421875e+01 2.3043708801269531e+02)(1.9177980041503906e+02 4.6298797607421875e+01 2.3043708801269531e+02)(1.7758988952636719e+02 4.7441703796386719e+01 2.3028540039062500e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.0004101562500000e+02 4.3783702850341797e+01 2.3365600585937500e+02)(2.0074470520019531e+02 4.4034297943115234e+01 2.3251431274414062e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.0074470520019531e+02 4.4034297943115234e+01 2.3251431274414062e+02)(2.0243080139160156e+02 4.4678501129150391e+01 2.3132861328125000e+02)(1.9177980041503906e+02 4.6298797607421875e+01 2.3043708801269531e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.2939761352539062e+02 4.5011501312255859e+01 2.2961730957031250e+02)(2.8575000000000000e+02 1.5033000707626343e+00 2.6383493041992188e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(2.7846041870117188e+02 1.7165800094604492e+01 2.6383120727539062e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(2.8575000000000000e+02 1.5033000707626343e+00 2.6383493041992188e+02)(2.3913789367675781e+02 6.2230002880096436e-01 2.6383630371093750e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.4873919677734375e+02 1.8789199829101562e+01 2.6383450317382812e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(2.1043960571289062e+02 4.1785999298095703e+01 2.6215090942382812e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.4873919677734375e+02 1.8789199829101562e+01 2.6383450317382812e+02)(2.7846041870117188e+02 1.7165800094604492e+01 2.6383120727539062e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(3.0166012573242188e+02 3.2466899871826172e+01 2.6383511352539062e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(1.7758988952636719e+02 4.7441703796386719e+01 2.3028540039062500e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(1.7970800781250000e+02 4.4697601318359375e+01 2.3276960754394531e+02)(2.9717562866210938e+02 6.7286697387695312e+01 2.2681999206542969e+02)(2.9814712524414062e+02 1.2812881469726562e+02 2.2612480163574219e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(2.1501679992675781e+02 4.7756103515625000e+01 2.2940098571777344e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(1.6247010803222656e+02 -1.6208400726318359e+01 2.3121670532226562e+02)(1.6318861389160156e+02 2.1084100723266602e+01 2.3087869262695312e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(1.6318861389160156e+02 2.1084100723266602e+01 2.3087869262695312e+02)(1.7758988952636719e+02 4.7441703796386719e+01 2.3028540039062500e+02)(2.1501679992675781e+02 4.7756103515625000e+01 2.2940098571777344e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(1.7758988952636719e+02 4.7441703796386719e+01 2.3028540039062500e+02)(1.6983828735351562e+02 4.1547397613525391e+01 2.3090670776367188e+02)(1.7758988952636719e+02 4.7441703796386719e+01 2.3028540039062500e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(2.9814712524414062e+02 1.2812881469726562e+02 2.2612480163574219e+02)(2.5811578369140625e+02 1.3580661010742188e+02 2.2769219970703125e+02)(2.5811578369140625e+02 1.3580661010742188e+02 2.2769219970703125e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(1.3860140991210938e+02 2.9823742675781250e+02 2.2803620910644531e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-9.6139999389648438e+01 -2.4160598754882812e+01 2.3190240478515625e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(-9.6139999389648438e+01 -2.4160598754882812e+01 2.3190240478515625e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-9.6139999389648438e+01 -2.4160598754882812e+01 2.3190240478515625e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(5.8946800231933594e+01 1.1198600006103516e+02 2.3182690429687500e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-1.8581750488281250e+02 3.1222161865234375e+02 2.2724290466308594e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.7920019531250000e+02 3.2491400146484375e+02 2.1865101623535156e+02)(-1.7917858886718750e+02 3.2491470336914062e+02 2.1865110778808594e+02)(-2.1599200439453125e+02 3.2079220581054688e+02 2.2274580383300781e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.7984759521484375e+02 3.2392370605468750e+02 2.1987449645996094e+02)(-1.7920019531250000e+02 3.2491400146484375e+02 2.1865101623535156e+02)(-1.7917880249023438e+02 3.2491430664062500e+02 2.1865161132812500e+02)(-1.7917858886718750e+02 3.2491470336914062e+02 2.1865110778808594e+02)(-1.7917880249023438e+02 3.2491430664062500e+02 2.1865161132812500e+02)(-1.7915769958496094e+02 3.2491461181640625e+02 2.1865211486816406e+02)(-1.7917858886718750e+02 3.2491470336914062e+02 2.1865110778808594e+02)(-1.7984759521484375e+02 3.2392370605468750e+02 2.1987449645996094e+02)(-1.7920019531250000e+02 3.2491400146484375e+02 2.1865101623535156e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-2.1599200439453125e+02 3.2079220581054688e+02 2.2274580383300781e+02)(1.3860140991210938e+02 2.9823742675781250e+02 2.2803620910644531e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(4.5053401947021484e+01 3.2668801879882812e+02 2.1503500366210938e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(1.1757089996337891e+02 3.2356838989257812e+02 2.1658210754394531e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(1.1757089996337891e+02 3.2356838989257812e+02 2.1658210754394531e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.1809220123291016e+02 3.1984771728515625e+02 2.2572091674804688e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-1.1809220123291016e+02 3.1984771728515625e+02 2.2572091674804688e+02)(-3.8491699218750000e+01 3.2399050903320312e+02 2.2180728149414062e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-1.7984759521484375e+02 3.2392370605468750e+02 2.1987449645996094e+02)(4.5053401947021484e+01 3.2668801879882812e+02 2.1503500366210938e+02)(-3.8491699218750000e+01 3.2399050903320312e+02 2.2180728149414062e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-3.8491699218750000e+01 3.2399050903320312e+02 2.2180728149414062e+02)(4.5053401947021484e+01 3.2668801879882812e+02 2.1503500366210938e+02)(1.1757089996337891e+02 3.2356838989257812e+02 2.1658210754394531e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(4.5053401947021484e+01 3.2668801879882812e+02 2.1503500366210938e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.7984759521484375e+02 3.2392370605468750e+02 2.1987449645996094e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-6.1780399322509766e+01 3.1545999145507812e+02 2.2834980773925781e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(-3.8491699218750000e+01 3.2399050903320312e+02 2.2180728149414062e+02)(-6.1780399322509766e+01 3.1545999145507812e+02 2.2834980773925781e+02)(-1.1809220123291016e+02 3.1984771728515625e+02 2.2572091674804688e+02)(-1.8468299865722656e+02 3.1623611450195312e+02 2.2652400207519531e+02)(-6.1780399322509766e+01 3.1545999145507812e+02 2.2834980773925781e+02)(-1.8468299865722656e+02 3.1623611450195312e+02 2.2652400207519531e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8581750488281250e+02 3.1222161865234375e+02 2.2724290466308594e+02)(-1.8468299865722656e+02 3.1623611450195312e+02 2.2652400207519531e+02)(-1.1809220123291016e+02 3.1984771728515625e+02 2.2572091674804688e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.8468299865722656e+02 3.1623611450195312e+02 2.2652400207519531e+02)(-6.1780399322509766e+01 3.1545999145507812e+02 2.2834980773925781e+02)(-3.8491699218750000e+01 3.2399050903320312e+02 2.2180728149414062e+02)(-1.1809220123291016e+02 3.1984771728515625e+02 2.2572091674804688e+02)(1.3860140991210938e+02 2.9823742675781250e+02 2.2803620910644531e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(3.0917001724243164e+01 3.1327340698242188e+02 2.2838130187988281e+02)(-6.1780399322509766e+01 3.1545999145507812e+02 2.2834980773925781e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(3.1376998901367188e+01 3.0716741943359375e+02 2.2949829101562500e+02)(-6.1780399322509766e+01 3.1545999145507812e+02 2.2834980773925781e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-1.3077709960937500e+02 3.1197000122070312e+02 2.2824389648437500e+02)(-1.8468299865722656e+02 3.1623611450195312e+02 2.2652400207519531e+02)(-1.8581750488281250e+02 3.1222161865234375e+02 2.2724290466308594e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8468299865722656e+02 3.1623611450195312e+02 2.2652400207519531e+02)(-1.8583778381347656e+02 3.1261669921875000e+02 2.2723329162597656e+02)(-1.8581750488281250e+02 3.1222161865234375e+02 2.2724290466308594e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8571310424804688e+02 3.1323199462890625e+02 2.2720379638671875e+02)(-1.8583778381347656e+02 3.1261669921875000e+02 2.2723329162597656e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8554510498046875e+02 3.1391714477539062e+02 2.2713389587402344e+02)(-1.8571310424804688e+02 3.1323199462890625e+02 2.2720379638671875e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8543910217285156e+02 3.1431002807617188e+02 2.2708110046386719e+02)(-1.8568811035156250e+02 3.1324450683593750e+02 2.2717379760742188e+02)(-1.8554510498046875e+02 3.1391714477539062e+02 2.2713389587402344e+02)(-1.8554510498046875e+02 3.1391714477539062e+02 2.2713389587402344e+02)(-1.8568811035156250e+02 3.1324450683593750e+02 2.2717379760742188e+02)(-1.8571310424804688e+02 3.1323199462890625e+02 2.2720379638671875e+02)(-1.8568811035156250e+02 3.1324450683593750e+02 2.2717379760742188e+02)(-1.8583778381347656e+02 3.1261669921875000e+02 2.2723329162597656e+02)(-1.8571310424804688e+02 3.1323199462890625e+02 2.2720379638671875e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.8513011169433594e+02 3.1524722290039062e+02 2.2687580871582031e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8513011169433594e+02 3.1524722290039062e+02 2.2687580871582031e+02)(-1.8554510498046875e+02 3.1391714477539062e+02 2.2713389587402344e+02)(-1.8542941284179688e+02 3.1414810180664062e+02 2.2702821350097656e+02)(-1.8513011169433594e+02 3.1524722290039062e+02 2.2687580871582031e+02)(-1.8543910217285156e+02 3.1431002807617188e+02 2.2708110046386719e+02)(-1.8554510498046875e+02 3.1391714477539062e+02 2.2713389587402344e+02)(2.5339132690429688e+02 2.8096206665039062e+02 2.1868049621582031e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(2.8237301635742188e+02 2.1796321105957031e+02 2.2080059814453125e+02)(2.8237301635742188e+02 2.1796321105957031e+02 2.2080059814453125e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(2.5339132690429688e+02 2.8096206665039062e+02 2.1868049621582031e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(2.5339132690429688e+02 2.8096206665039062e+02 2.1868049621582031e+02)(2.0117221069335938e+02 3.0224661254882812e+02 2.2086889648437500e+02)(2.5339132690429688e+02 2.8096206665039062e+02 2.1868049621582031e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(2.7186331176757812e+02 3.0599160766601562e+02 2.0894079589843750e+02)(2.0117221069335938e+02 3.0224661254882812e+02 2.2086889648437500e+02)(2.5339132690429688e+02 2.8096206665039062e+02 2.1868049621582031e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(2.7186331176757812e+02 3.0599160766601562e+02 2.0894079589843750e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(2.5339132690429688e+02 2.8096206665039062e+02 2.1868049621582031e+02)(2.0117221069335938e+02 3.0224661254882812e+02 2.2086889648437500e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(1.3860140991210938e+02 2.9823742675781250e+02 2.2803620910644531e+02)(1.3860140991210938e+02 2.9823742675781250e+02 2.2803620910644531e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(2.0117221069335938e+02 3.0224661254882812e+02 2.2086889648437500e+02)(2.8237301635742188e+02 2.1796321105957031e+02 2.2080059814453125e+02)(3.1493850708007812e+02 2.4053039550781250e+02 2.1067491149902344e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-2.1599200439453125e+02 3.2079220581054688e+02 2.2274580383300781e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.8513011169433594e+02 3.1524722290039062e+02 2.2687580871582031e+02)(-1.8568811035156250e+02 3.1324450683593750e+02 2.2717379760742188e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.8583778381347656e+02 3.1261669921875000e+02 2.2723329162597656e+02)(-1.8543910217285156e+02 3.1431002807617188e+02 2.2708110046386719e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.8568811035156250e+02 3.1324450683593750e+02 2.2717379760742188e+02)(-1.8513011169433594e+02 3.1524722290039062e+02 2.2687580871582031e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.8543910217285156e+02 3.1431002807617188e+02 2.2708110046386719e+02)(-1.8271119689941406e+02 3.2019580078125000e+02 2.2450450134277344e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-3.0009750366210938e+02 2.5403889465332031e+02 2.2467581176757812e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-2.4089520263671875e+02 2.8654281616210938e+02 2.2672879028320312e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-3.0009750366210938e+02 2.5403889465332031e+02 2.2467581176757812e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-1.8581750488281250e+02 3.1222161865234375e+02 2.2724290466308594e+02)(-1.8583778381347656e+02 3.1261669921875000e+02 2.2723329162597656e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.8581750488281250e+02 3.1222161865234375e+02 2.2724290466308594e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-1.8853668212890625e+02 3.1477261352539062e+02 2.2696171569824219e+02)(-1.7915769958496094e+02 3.2491461181640625e+02 2.1865211486816406e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.7917858886718750e+02 3.2491470336914062e+02 2.1865110778808594e+02)(-1.7917880249023438e+02 3.2491430664062500e+02 2.1865161132812500e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.7915769958496094e+02 3.2491461181640625e+02 2.1865211486816406e+02)(-1.7920019531250000e+02 3.2491400146484375e+02 2.1865101623535156e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.7917880249023438e+02 3.2491430664062500e+02 2.1865161132812500e+02)(-1.7984759521484375e+02 3.2392370605468750e+02 2.1987449645996094e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.7920019531250000e+02 3.2491400146484375e+02 2.1865101623535156e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(-7.8173202514648438e+01 3.2863009643554688e+02 1.2400050354003906e+02)(-2.2846400451660156e+02 3.2837481689453125e+02 1.3746459960937500e+02)(-7.8173202514648438e+01 3.2863009643554688e+02 1.2400050354003906e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(-2.1326700210571289e+01 3.2871890258789062e+02 1.1890970611572266e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(4.5053401947021484e+01 3.2668801879882812e+02 2.1503500366210938e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(-2.1326700210571289e+01 3.2871890258789062e+02 1.1890970611572266e+02)(1.5932330322265625e+02 3.2900131225585938e+02 1.0273200225830078e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(2.3917280578613281e+02 3.2810919189453125e+02 9.5524398803710938e+01)(9.9946403503417969e+01 3.2890850830078125e+02 1.0804940795898438e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(1.5932330322265625e+02 3.2900131225585938e+02 1.0273200225830078e+02)(9.9946403503417969e+01 3.2890850830078125e+02 1.0804940795898438e+02)(-2.1326700210571289e+01 3.2871890258789062e+02 1.1890970611572266e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(4.5053401947021484e+01 3.2668801879882812e+02 2.1503500366210938e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(-1.5924639892578125e+02 3.2662411499023438e+02 2.1635360717773438e+02)(-1.7919709777832031e+02 3.2483227539062500e+02 2.1859040832519531e+02)(-1.7911700439453125e+02 3.2547943115234375e+02 2.1779920959472656e+02)(-1.7917858886718750e+02 3.2491470336914062e+02 2.1865110778808594e+02)(1.1757089996337891e+02 3.2356838989257812e+02 2.1658210754394531e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.8766979980468750e+02 5.6536903381347656e+01 2.2371832275390625e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(3.0680761718750000e+02 3.0199001312255859e+01 2.1922468566894531e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(2.5811578369140625e+02 1.3580661010742188e+02 2.2769219970703125e+02)(3.0182479858398438e+02 1.3732719421386719e+02 2.1960531616210938e+02)(2.8237301635742188e+02 2.1796321105957031e+02 2.2080059814453125e+02)(2.8237301635742188e+02 2.1796321105957031e+02 2.2080059814453125e+02)(2.2257290649414062e+02 2.5874081420898438e+02 2.2701071166992188e+02)(2.5811578369140625e+02 1.3580661010742188e+02 2.2769219970703125e+02)(3.0182479858398438e+02 1.3732719421386719e+02 2.1960531616210938e+02)(3.1493850708007812e+02 2.4053039550781250e+02 2.1067491149902344e+02)(2.8237301635742188e+02 2.1796321105957031e+02 2.2080059814453125e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(2.8766979980468750e+02 5.6536903381347656e+01 2.2371832275390625e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(3.0680761718750000e+02 3.0199001312255859e+01 2.1922468566894531e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(3.0182479858398438e+02 1.3732719421386719e+02 2.1960531616210938e+02)(3.1875012207031250e+02 2.1195059204101562e+02 2.1065159606933594e+02)(3.1493850708007812e+02 2.4053039550781250e+02 2.1067491149902344e+02)(3.0182479858398438e+02 1.3732719421386719e+02 2.1960531616210938e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(3.1875012207031250e+02 2.1195059204101562e+02 2.1065159606933594e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(2.8766979980468750e+02 5.6536903381347656e+01 2.2371832275390625e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(2.4675010681152344e+02 3.2253088378906250e+02 2.0347200012207031e+02)(2.4675010681152344e+02 3.2253088378906250e+02 2.0347200012207031e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(2.7029971313476562e+02 3.1249310302734375e+02 2.0255000305175781e+02)(2.3786599731445312e+02 3.2063320922851562e+02 2.1018310546875000e+02)(2.7186331176757812e+02 3.0599160766601562e+02 2.0894079589843750e+02)(2.7029971313476562e+02 3.1249310302734375e+02 2.0255000305175781e+02)(2.7029971313476562e+02 3.1249310302734375e+02 2.0255000305175781e+02)(2.7186331176757812e+02 3.0599160766601562e+02 2.0894079589843750e+02)(2.8920190429687500e+02 2.9747738647460938e+02 2.0352909851074219e+02)(2.7186331176757812e+02 3.0599160766601562e+02 2.0894079589843750e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(2.8920190429687500e+02 2.9747738647460938e+02 2.0352909851074219e+02)(2.8920190429687500e+02 2.9747738647460938e+02 2.0352909851074219e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(3.0161581420898438e+02 2.8380560302734375e+02 2.0334188842773438e+02)(3.1447131347656250e+02 2.6122601318359375e+02 2.0384469604492188e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(3.1493850708007812e+02 2.4053039550781250e+02 2.1067491149902344e+02)(3.1493850708007812e+02 2.4053039550781250e+02 2.1067491149902344e+02)(3.1875012207031250e+02 2.1195059204101562e+02 2.1065159606933594e+02)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.1447131347656250e+02 2.6122601318359375e+02 2.0384469604492188e+02)(3.1493850708007812e+02 2.4053039550781250e+02 2.1067491149902344e+02)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.0161581420898438e+02 2.8380560302734375e+02 2.0334188842773438e+02)(3.0177981567382812e+02 2.7633239746093750e+02 2.0899420166015625e+02)(3.1447131347656250e+02 2.6122601318359375e+02 2.0384469604492188e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-2.5834219360351562e+02 2.6732879638671875e+02 2.2873262023925781e+02)(-2.4089520263671875e+02 2.8654281616210938e+02 2.2672879028320312e+02)(-2.9482208251953125e+02 2.6980371093750000e+02 2.2289360046386719e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-3.0009750366210938e+02 2.5403889465332031e+02 2.2467581176757812e+02)(-2.9482208251953125e+02 2.6980371093750000e+02 2.2289360046386719e+02)(-3.0009750366210938e+02 2.5403889465332031e+02 2.2467581176757812e+02)(-2.6874389648437500e+02 2.9855609130859375e+02 2.2347509765625000e+02)(-2.4317811584472656e+02 3.1462130737304688e+02 2.2338531494140625e+02)(-2.6874389648437500e+02 2.9855609130859375e+02 2.2347509765625000e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-2.6874389648437500e+02 2.9855609130859375e+02 2.2347509765625000e+02)(-3.0009750366210938e+02 2.5403889465332031e+02 2.2467581176757812e+02)(-2.1599200439453125e+02 3.2079220581054688e+02 2.2274580383300781e+02)(-2.4317811584472656e+02 3.1462130737304688e+02 2.2338531494140625e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-3.1537948608398438e+02 1.7843060302734375e+02 2.2000360107421875e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-3.0009750366210938e+02 2.5403889465332031e+02 2.2467581176757812e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-2.9707901000976562e+02 1.7267060852050781e+02 2.3008010864257812e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-2.5834219360351562e+02 2.6732879638671875e+02 2.2873262023925781e+02)(-2.6421560668945312e+02 2.6445562744140625e+02 2.2633650207519531e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-3.1386312866210938e+02 2.7184591674804688e+02 1.9502798461914062e+02)(-3.2482290649414062e+02 2.4593699645996094e+02 1.8818659973144531e+02)(-3.1386312866210938e+02 2.7184591674804688e+02 1.9502798461914062e+02)(-2.9482208251953125e+02 2.6980371093750000e+02 2.2289360046386719e+02)(-2.9955657958984375e+02 2.9183081054687500e+02 2.0019030761718750e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-2.9482208251953125e+02 2.6980371093750000e+02 2.2289360046386719e+02)(-3.1386312866210938e+02 2.7184591674804688e+02 1.9502798461914062e+02)(-2.9482208251953125e+02 2.6980371093750000e+02 2.2289360046386719e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-2.9955657958984375e+02 2.9183081054687500e+02 2.0019030761718750e+02)(-2.6874389648437500e+02 2.9855609130859375e+02 2.2347509765625000e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-2.9482208251953125e+02 2.6980371093750000e+02 2.2289360046386719e+02)(-2.4861851501464844e+02 3.2278799438476562e+02 2.1046530151367188e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-2.4317811584472656e+02 3.1462130737304688e+02 2.2338531494140625e+02)(-2.4861851501464844e+02 3.2278799438476562e+02 2.1046530151367188e+02)(-2.4317811584472656e+02 3.1462130737304688e+02 2.2338531494140625e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-2.6874389648437500e+02 2.9855609130859375e+02 2.2347509765625000e+02)(-2.4317811584472656e+02 3.1462130737304688e+02 2.2338531494140625e+02)(-2.4317811584472656e+02 3.1462130737304688e+02 2.2338531494140625e+02)(-2.1599200439453125e+02 3.2079220581054688e+02 2.2274580383300781e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-3.2482290649414062e+02 2.4593699645996094e+02 1.8818659973144531e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(-2.6111538696289062e+02 1.9584129333496094e+02 3.9933718872070312e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6111538696289062e+02 1.9584129333496094e+02 3.9933718872070312e+02)(-2.6128921508789062e+02 1.9582510375976562e+02 4.5703369140625000e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6128921508789062e+02 1.9582510375976562e+02 4.5703369140625000e+02)(-2.6150000000000000e+02 1.9600001525878906e+02 5.7025000000000000e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6132510375976562e+02 -1.9569230651855469e+02 4.1570541381835938e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-2.6132510375976562e+02 -1.9569230651855469e+02 4.1570541381835938e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.6149697875976562e+02 -1.9593290710449219e+02 5.7024890136718750e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-2.2931010437011719e+02 -1.9607441711425781e+02 2.5715029907226562e+02)(-2.5288900756835938e+02 -1.9620390319824219e+02 3.2767269897460938e+02)(-2.2931010437011719e+02 -1.9607441711425781e+02 2.5715029907226562e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-2.6132510375976562e+02 -1.9569230651855469e+02 4.1570541381835938e+02)(-2.5288900756835938e+02 -1.9620390319824219e+02 3.2767269897460938e+02)(-2.6149948120117188e+02 -1.9596800231933594e+02 2.2760580444335938e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(-2.2931010437011719e+02 -1.9607441711425781e+02 2.5715029907226562e+02)(-2.2611979675292969e+02 -1.9904460144042969e+02 2.5855142211914062e+02)(-2.2931010437011719e+02 -1.9607441711425781e+02 2.5715029907226562e+02)(-2.4024351501464844e+02 -1.9952439880371094e+02 2.9331710815429688e+02)(-2.2611979675292969e+02 -1.9904460144042969e+02 2.5855142211914062e+02)(-2.5288900756835938e+02 -1.9620390319824219e+02 3.2767269897460938e+02)(-2.4024351501464844e+02 -1.9952439880371094e+02 2.9331710815429688e+02)(-2.2931010437011719e+02 -1.9607441711425781e+02 2.5715029907226562e+02)(-2.5288900756835938e+02 -1.9620390319824219e+02 3.2767269897460938e+02)(-2.4942140197753906e+02 -1.9983990478515625e+02 3.3694860839843750e+02)(-2.4024351501464844e+02 -1.9952439880371094e+02 2.9331710815429688e+02)(-2.2611979675292969e+02 -1.9904460144042969e+02 2.5855142211914062e+02)(-2.4024351501464844e+02 -1.9952439880371094e+02 2.9331710815429688e+02)(-2.2738758850097656e+02 -2.3076911926269531e+02 2.7346810913085938e+02)(-2.4097021484375000e+02 -2.1888510131835938e+02 3.0747140502929688e+02)(-2.2738758850097656e+02 -2.3076911926269531e+02 2.7346810913085938e+02)(-2.4024351501464844e+02 -1.9952439880371094e+02 2.9331710815429688e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(-2.2611979675292969e+02 -1.9904460144042969e+02 2.5855142211914062e+02)(-1.9946269226074219e+02 -2.5894738769531250e+02 2.3576890563964844e+02)(-2.1461779785156250e+02 -2.4117341613769531e+02 2.5302061462402344e+02)(-1.9946269226074219e+02 -2.5894738769531250e+02 2.3576890563964844e+02)(-2.2611979675292969e+02 -1.9904460144042969e+02 2.5855142211914062e+02)(-2.0651181030273438e+02 -1.9753559875488281e+02 2.2880001831054688e+02)(-1.9946269226074219e+02 -2.5894738769531250e+02 2.3576890563964844e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-2.4942140197753906e+02 -1.9983990478515625e+02 3.3694860839843750e+02)(-2.4097021484375000e+02 -2.1888510131835938e+02 3.0747140502929688e+02)(-2.4024351501464844e+02 -1.9952439880371094e+02 2.9331710815429688e+02)(-2.2611979675292969e+02 -1.9904460144042969e+02 2.5855142211914062e+02)(-2.2738758850097656e+02 -2.3076911926269531e+02 2.7346810913085938e+02)(-2.1461779785156250e+02 -2.4117341613769531e+02 2.5302061462402344e+02)(-2.1461779785156250e+02 -2.4117341613769531e+02 2.5302061462402344e+02)(-2.2738758850097656e+02 -2.3076911926269531e+02 2.7346810913085938e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.2738758850097656e+02 -2.3076911926269531e+02 2.7346810913085938e+02)(-2.4097021484375000e+02 -2.1888510131835938e+02 3.0747140502929688e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.1546910095214844e+02 -2.4787750244140625e+02 2.4910250854492188e+02)(-2.1461779785156250e+02 -2.4117341613769531e+02 2.5302061462402344e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-1.9946269226074219e+02 -2.5894738769531250e+02 2.3576890563964844e+02)(-2.0363569641113281e+02 -2.6391021728515625e+02 2.3527050781250000e+02)(-2.0363569641113281e+02 -2.6391021728515625e+02 2.3527050781250000e+02)(-1.9946269226074219e+02 -2.5894738769531250e+02 2.3576890563964844e+02)(-2.1546910095214844e+02 -2.4787750244140625e+02 2.4910250854492188e+02)(-2.1546910095214844e+02 -2.4787750244140625e+02 2.4910250854492188e+02)(-1.9946269226074219e+02 -2.5894738769531250e+02 2.3576890563964844e+02)(-2.1461779785156250e+02 -2.4117341613769531e+02 2.5302061462402344e+02)(-2.4216818237304688e+02 -2.2349989318847656e+02 3.0658862304687500e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.4097021484375000e+02 -2.1888510131835938e+02 3.0747140502929688e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.6450988769531250e+02 -2.5069949340820312e+02 2.4733018493652344e+02)(-2.7506958007812500e+02 -2.3969100952148438e+02 2.6260171508789062e+02)(-2.5323692321777344e+02 -2.6886859130859375e+02 2.3238121032714844e+02)(-2.6450988769531250e+02 -2.5069949340820312e+02 2.4733018493652344e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.5323692321777344e+02 -2.6886859130859375e+02 2.3238121032714844e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.6401629638671875e+02 -2.6082760620117188e+02 2.2667971801757812e+02)(-2.4242858886718750e+02 -2.8712341308593750e+02 2.2637010192871094e+02)(-2.5323692321777344e+02 -2.6886859130859375e+02 2.3238121032714844e+02)(-2.6401629638671875e+02 -2.6082760620117188e+02 2.2667971801757812e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-2.8341870117187500e+02 -2.0654701232910156e+02 2.2732940673828125e+02)(-3.0140789794921875e+02 -1.7303390502929688e+02 2.2586230468750000e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-2.8341870117187500e+02 -2.0654701232910156e+02 2.2732940673828125e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-2.6557870483398438e+02 -2.9969332885742188e+02 2.2457940673828125e+02)(-2.6401629638671875e+02 -2.6082760620117188e+02 2.2667971801757812e+02)(-2.4242858886718750e+02 -2.8712341308593750e+02 2.2637010192871094e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-2.6401629638671875e+02 -2.6082760620117188e+02 2.2667971801757812e+02)(-2.6557870483398438e+02 -2.9969332885742188e+02 2.2457940673828125e+02)(-2.4242858886718750e+02 -2.8712341308593750e+02 2.2637010192871094e+02)(-2.6401629638671875e+02 -2.6082760620117188e+02 2.2667971801757812e+02)(-2.8341870117187500e+02 -2.0654701232910156e+02 2.2732940673828125e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-2.6557870483398438e+02 -2.9969332885742188e+02 2.2457940673828125e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-2.4242858886718750e+02 -2.8712341308593750e+02 2.2637010192871094e+02)(2.0292980957031250e+02 5.0849997997283936e-01 2.3122691345214844e+02)(2.0283010864257812e+02 -2.8047001361846924e+00 2.3125181579589844e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.0125590515136719e+02 -1.0166999816894531e+01 2.3205160522460938e+02)(2.0125590515136719e+02 8.7646007537841797e+00 2.3205160522460938e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0125590515136719e+02 -1.0166999816894531e+01 2.3205160522460938e+02)(2.0188351440429688e+02 -1.8756401062011719e+01 2.3162829589843750e+02)(2.0187071228027344e+02 0.0000000000000000e+00 2.3163699340820312e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0080940246582031e+02 -2.6118700027465820e+01 2.3243820190429688e+02)(2.0125590515136719e+02 -1.0166999816894531e+01 2.3205160522460938e+02)(2.0080940246582031e+02 -2.6118700027465820e+01 2.3243820190429688e+02)(2.0188351440429688e+02 -1.8756401062011719e+01 2.3162829589843750e+02)(2.0125590515136719e+02 -1.0166999816894531e+01 2.3205160522460938e+02)(2.0038250732421875e+02 -4.3849502563476562e+01 2.3306179809570312e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(2.0080940246582031e+02 -2.6118700027465820e+01 2.3243820190429688e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.0283010864257812e+02 -2.8397600173950195e+01 2.3125181579589844e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(2.0080940246582031e+02 -2.6118700027465820e+01 2.3243820190429688e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(2.0188351440429688e+02 -1.8756401062011719e+01 2.3162829589843750e+02)(2.0188351440429688e+02 -1.8756401062011719e+01 2.3162829589843750e+02)(2.0283010864257812e+02 -2.8047001361846924e+00 2.3125181579589844e+02)(2.0187071228027344e+02 0.0000000000000000e+00 2.3163699340820312e+02)(2.0283010864257812e+02 -2.8397600173950195e+01 2.3125181579589844e+02)(2.0283010864257812e+02 -2.8047001361846924e+00 2.3125181579589844e+02)(2.0188351440429688e+02 -1.8756401062011719e+01 2.3162829589843750e+02)(2.0187071228027344e+02 0.0000000000000000e+00 2.3163699340820312e+02)(2.0125590515136719e+02 8.7646007537841797e+00 2.3205160522460938e+02)(2.0125590515136719e+02 -1.0166999816894531e+01 2.3205160522460938e+02)(2.0216241455078125e+02 -4.4616699218750000e+01 2.3139970397949219e+02)(2.0283010864257812e+02 -2.8397600173950195e+01 2.3125181579589844e+02)(2.0188351440429688e+02 -1.8756401062011719e+01 2.3162829589843750e+02)(2.0283010864257812e+02 -2.8397600173950195e+01 2.3125181579589844e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.0283010864257812e+02 -2.8047001361846924e+00 2.3125181579589844e+02)(2.0125590515136719e+02 8.7646007537841797e+00 2.3205160522460938e+02)(2.0004101562500000e+02 4.3783702850341797e+01 2.3365600585937500e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0038250732421875e+02 -4.3849502563476562e+01 2.3306179809570312e+02)(2.0080940246582031e+02 -2.6118700027465820e+01 2.3243820190429688e+02)(2.0022581481933594e+02 -1.2567601203918457e+01 2.3347859191894531e+02)(2.0283010864257812e+02 -2.8397600173950195e+01 2.3125181579589844e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.0283010864257812e+02 -2.8047001361846924e+00 2.3125181579589844e+02)(2.0292980957031250e+02 5.0849997997283936e-01 2.3122691345214844e+02)(2.0187071228027344e+02 0.0000000000000000e+00 2.3163699340820312e+02)(2.3685661315917969e+02 -5.2378001213073730e+00 2.3099971008300781e+02)(2.4335638427734375e+02 -1.7477600097656250e+01 2.3100057983398438e+02)(2.4542260742187500e+02 -1.5419300079345703e+01 2.6382940673828125e+02)(2.4542260742187500e+02 -1.5419300079345703e+01 2.6382940673828125e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.5926229858398438e+02 -2.3050600051879883e+01 2.6383670043945312e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.4542260742187500e+02 -1.5419300079345703e+01 2.6382940673828125e+02)(2.4335638427734375e+02 -1.7477600097656250e+01 2.3100057983398438e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.6624368286132812e+02 -2.5739301681518555e+01 2.3100070190429688e+02)(2.5926229858398438e+02 -2.3050600051879883e+01 2.6383670043945312e+02)(2.5926229858398438e+02 -2.3050600051879883e+01 2.6383670043945312e+02)(2.6624368286132812e+02 -2.5739301681518555e+01 2.3100070190429688e+02)(2.7478561401367188e+02 -1.9590099334716797e+01 2.6383279418945312e+02)(2.6624368286132812e+02 -2.5739301681518555e+01 2.3100070190429688e+02)(2.7947058105468750e+02 -2.0265100479125977e+01 2.3100720214843750e+02)(2.7478561401367188e+02 -1.9590099334716797e+01 2.6383279418945312e+02)(2.7478561401367188e+02 -1.9590099334716797e+01 2.6383279418945312e+02)(2.7947058105468750e+02 -2.0265100479125977e+01 2.3100720214843750e+02)(2.8245910644531250e+02 -1.1313299179077148e+01 2.6383190917968750e+02)(2.8245910644531250e+02 -1.1313299179077148e+01 2.6383190917968750e+02)(2.8759890747070312e+02 -7.4400005340576172e+00 2.3099819946289062e+02)(2.8575000000000000e+02 1.5033000707626343e+00 2.6383493041992188e+02)(2.7947058105468750e+02 -2.0265100479125977e+01 2.3100720214843750e+02)(2.8759890747070312e+02 -7.4400005340576172e+00 2.3099819946289062e+02)(2.8245910644531250e+02 -1.1313299179077148e+01 2.6383190917968750e+02)(2.8732092285156250e+02 9.4460010528564453e+00 2.3099360656738281e+02)(2.8575000000000000e+02 1.5033000707626343e+00 2.6383493041992188e+02)(2.8759890747070312e+02 -7.4400005340576172e+00 2.3099819946289062e+02)(2.3913789367675781e+02 6.2230002880096436e-01 2.6383630371093750e+02)(2.3685661315917969e+02 -5.2378001213073730e+00 2.3099971008300781e+02)(2.4542260742187500e+02 -1.5419300079345703e+01 2.6382940673828125e+02)(3.0025479125976562e+02 -3.3223201751708984e+01 2.8501821899414062e+02)(3.0166012573242188e+02 3.2466899871826172e+01 2.6383511352539062e+02)(3.0006298828125000e+02 3.3962200164794922e+01 2.8493591308593750e+02)(3.0025479125976562e+02 -3.3223201751708984e+01 2.8501821899414062e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(3.0166012573242188e+02 3.2466899871826172e+01 2.6383511352539062e+02)(3.0025479125976562e+02 -3.3223201751708984e+01 2.8501821899414062e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(2.9444338989257812e+02 -3.8886402130126953e+01 2.8569601440429688e+02)(2.9569934082031250e+02 -3.9568901062011719e+01 2.6384588623046875e+02)(3.0166229248046875e+02 -3.2401000976562500e+01 2.6383218383789062e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.3685661315917969e+02 -5.2378001213073730e+00 2.3099971008300781e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.3685661315917969e+02 -5.2378001213073730e+00 2.3099971008300781e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.4335638427734375e+02 -1.7477600097656250e+01 2.3100057983398438e+02)(2.7947058105468750e+02 -2.0265100479125977e+01 2.3100720214843750e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.8759890747070312e+02 -7.4400005340576172e+00 2.3099819946289062e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.6624368286132812e+02 -2.5739301681518555e+01 2.3100070190429688e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.3130610656738281e+02 -4.3458599090576172e+01 2.3095520019531250e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.4335638427734375e+02 -1.7477600097656250e+01 2.3100057983398438e+02)(2.6624368286132812e+02 -2.5739301681518555e+01 2.3100070190429688e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.7947058105468750e+02 -2.0265100479125977e+01 2.3100720214843750e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.5403919982910156e+02 -2.4762599945068359e+01 2.3099790954589844e+02)(2.3130610656738281e+02 -4.3458599090576172e+01 2.3095520019531250e+02)(2.8759890747070312e+02 -7.4400005340576172e+00 2.3099819946289062e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(2.8732092285156250e+02 9.4460010528564453e+00 2.3099360656738281e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(2.8759890747070312e+02 -7.4400005340576172e+00 2.3099819946289062e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(3.0006298828125000e+02 3.3962200164794922e+01 2.8493591308593750e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(2.9394741821289062e+02 3.9552101135253906e+01 2.8417849731445312e+02)(3.0006298828125000e+02 3.3962200164794922e+01 2.8493591308593750e+02)(3.0166012573242188e+02 3.2466899871826172e+01 2.6383511352539062e+02)(2.9554351806640625e+02 3.9623401641845703e+01 2.6384140014648438e+02)(2.0188351440429688e+02 2.1035200119018555e+01 2.3162829589843750e+02)(2.0125590515136719e+02 2.9098699569702148e+01 2.3205160522460938e+02)(2.0125590515136719e+02 8.7646007537841797e+00 2.3205160522460938e+02)(2.0292980957031250e+02 5.0849997997283936e-01 2.3122691345214844e+02)(2.0283010864257812e+02 2.8222297668457031e+01 2.3125181579589844e+02)(2.0188351440429688e+02 2.1035200119018555e+01 2.3162829589843750e+02)(2.0187071228027344e+02 0.0000000000000000e+00 2.3163699340820312e+02)(2.0188351440429688e+02 2.1035200119018555e+01 2.3162829589843750e+02)(2.0125590515136719e+02 8.7646007537841797e+00 2.3205160522460938e+02)(2.0125590515136719e+02 2.9098699569702148e+01 2.3205160522460938e+02)(2.0004101562500000e+02 4.3783702850341797e+01 2.3365600585937500e+02)(2.0125590515136719e+02 8.7646007537841797e+00 2.3205160522460938e+02)(2.0187071228027344e+02 0.0000000000000000e+00 2.3163699340820312e+02)(2.0292980957031250e+02 5.0849997997283936e-01 2.3122691345214844e+02)(2.0188351440429688e+02 2.1035200119018555e+01 2.3162829589843750e+02)(2.0004101562500000e+02 4.3783702850341797e+01 2.3365600585937500e+02)(2.0125590515136719e+02 2.9098699569702148e+01 2.3205160522460938e+02)(2.0074470520019531e+02 4.4034297943115234e+01 2.3251431274414062e+02)(2.0125590515136719e+02 2.9098699569702148e+01 2.3205160522460938e+02)(2.0243080139160156e+02 4.4678501129150391e+01 2.3132861328125000e+02)(2.0074470520019531e+02 4.4034297943115234e+01 2.3251431274414062e+02)(2.0188351440429688e+02 2.1035200119018555e+01 2.3162829589843750e+02)(2.0243080139160156e+02 4.4678501129150391e+01 2.3132861328125000e+02)(2.0125590515136719e+02 2.9098699569702148e+01 2.3205160522460938e+02)(2.0188351440429688e+02 2.1035200119018555e+01 2.3162829589843750e+02)(2.0283010864257812e+02 2.8222297668457031e+01 2.3125181579589844e+02)(2.0243080139160156e+02 4.4678501129150391e+01 2.3132861328125000e+02)(2.0283010864257812e+02 2.8222297668457031e+01 2.3125181579589844e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.0283010864257812e+02 2.8222297668457031e+01 2.3125181579589844e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.0243080139160156e+02 4.4678501129150391e+01 2.3132861328125000e+02)(2.0292980957031250e+02 5.0849997997283936e-01 2.3122691345214844e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.0283010864257812e+02 2.8222297668457031e+01 2.3125181579589844e+02)(2.3685661315917969e+02 -5.2378001213073730e+00 2.3099971008300781e+02)(2.3854981994628906e+02 1.0203200340270996e+01 2.3100057983398438e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.8732092285156250e+02 9.4460010528564453e+00 2.3099360656738281e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(2.3854981994628906e+02 1.0203200340270996e+01 2.3100057983398438e+02)(2.4909292602539062e+02 2.2630701065063477e+01 2.3100189208984375e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.7705169677734375e+02 2.1724800109863281e+01 2.3100181579589844e+02)(2.8732092285156250e+02 9.4460010528564453e+00 2.3099360656738281e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.0461560058593750e+02 -4.4860500335693359e+01 2.3100160217285156e+02)(2.0467010498046875e+02 0.0000000000000000e+00 2.3099998474121094e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.0672158813476562e+02 4.5097198486328125e+01 2.3061361694335938e+02)(2.4909292602539062e+02 2.2630701065063477e+01 2.3100189208984375e+02)(2.6431451416015625e+02 2.6104499816894531e+01 2.3100041198730469e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.6431451416015625e+02 2.6104499816894531e+01 2.3100041198730469e+02)(2.7705169677734375e+02 2.1724800109863281e+01 2.3100181579589844e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.1320901489257812e+02 4.4390499114990234e+01 2.3099819946289062e+02)(2.4909292602539062e+02 2.2630701065063477e+01 2.3100189208984375e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(2.6431451416015625e+02 2.6104499816894531e+01 2.3100041198730469e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(3.0303991699218750e+02 3.2920200347900391e+01 2.3100450134277344e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.3854981994628906e+02 1.0203200340270996e+01 2.3100057983398438e+02)(2.3913789367675781e+02 6.2230002880096436e-01 2.6383630371093750e+02)(2.4873919677734375e+02 1.8789199829101562e+01 2.6383450317382812e+02)(2.3854981994628906e+02 1.0203200340270996e+01 2.3100057983398438e+02)(2.3685661315917969e+02 -5.2378001213073730e+00 2.3099971008300781e+02)(2.3913789367675781e+02 6.2230002880096436e-01 2.6383630371093750e+02)(2.4909292602539062e+02 2.2630701065063477e+01 2.3100189208984375e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.6431451416015625e+02 2.6104499816894531e+01 2.3100041198730469e+02)(2.4909292602539062e+02 2.2630701065063477e+01 2.3100189208984375e+02)(2.4873919677734375e+02 1.8789199829101562e+01 2.6383450317382812e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.8575000000000000e+02 1.5033000707626343e+00 2.6383493041992188e+02)(2.8732092285156250e+02 9.4460010528564453e+00 2.3099360656738281e+02)(2.7846041870117188e+02 1.7165800094604492e+01 2.6383120727539062e+02)(2.7846041870117188e+02 1.7165800094604492e+01 2.6383120727539062e+02)(2.7705169677734375e+02 2.1724800109863281e+01 2.3100181579589844e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.6383789062500000e+02 2.2990901947021484e+01 2.6383090209960938e+02)(2.7705169677734375e+02 2.1724800109863281e+01 2.3100181579589844e+02)(2.6431451416015625e+02 2.6104499816894531e+01 2.3100041198730469e+02)(2.7846041870117188e+02 1.7165800094604492e+01 2.6383120727539062e+02)(2.8732092285156250e+02 9.4460010528564453e+00 2.3099360656738281e+02)(2.7705169677734375e+02 2.1724800109863281e+01 2.3100181579589844e+02)(2.3854981994628906e+02 1.0203200340270996e+01 2.3100057983398438e+02)(2.4873919677734375e+02 1.8789199829101562e+01 2.6383450317382812e+02)(2.4909292602539062e+02 2.2630701065063477e+01 2.3100189208984375e+02)(-2.6883090209960938e+02 2.4736320495605469e+02 2.5001879882812500e+02)(-2.5888940429687500e+02 2.6074282836914062e+02 2.3711720275878906e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.6883090209960938e+02 2.4736320495605469e+02 2.5001879882812500e+02)(-2.5834219360351562e+02 2.6732879638671875e+02 2.2873262023925781e+02)(-2.5888940429687500e+02 2.6074282836914062e+02 2.3711720275878906e+02)(-2.4089520263671875e+02 2.8654281616210938e+02 2.2672879028320312e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-2.5888940429687500e+02 2.6074282836914062e+02 2.3711720275878906e+02)(-2.5834219360351562e+02 2.6732879638671875e+02 2.2873262023925781e+02)(-2.2705410766601562e+02 2.3114059448242188e+02 2.7256359863281250e+02)(-2.3005400085449219e+02 2.3336019897460938e+02 2.7334652709960938e+02)(-2.3801260375976562e+02 2.2264300537109375e+02 2.9647320556640625e+02)(-2.1811781311035156e+02 2.4438890075683594e+02 2.5263182067871094e+02)(-2.1348460388183594e+02 2.4323570251464844e+02 2.5151521301269531e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-2.1811781311035156e+02 2.4438890075683594e+02 2.5263182067871094e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-2.0441310119628906e+02 2.6262561035156250e+02 2.3608819580078125e+02)(-2.0441310119628906e+02 2.6262561035156250e+02 2.3608819580078125e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-2.1348460388183594e+02 2.4323570251464844e+02 2.5151521301269531e+02)(-2.1811781311035156e+02 2.4438890075683594e+02 2.5263182067871094e+02)(-2.3005400085449219e+02 2.3336019897460938e+02 2.7334652709960938e+02)(-2.3005400085449219e+02 2.3336019897460938e+02 2.7334652709960938e+02)(-2.2705410766601562e+02 2.3114059448242188e+02 2.7256359863281250e+02)(-2.1348460388183594e+02 2.4323570251464844e+02 2.5151521301269531e+02)(-2.3801260375976562e+02 2.2264300537109375e+02 2.9647320556640625e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-2.2705410766601562e+02 2.3114059448242188e+02 2.7256359863281250e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(-2.3801260375976562e+02 2.2264300537109375e+02 2.9647320556640625e+02)(-2.3801260375976562e+02 2.2264300537109375e+02 2.9647320556640625e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-2.1348460388183594e+02 2.4323570251464844e+02 2.5151521301269531e+02)(-2.2705410766601562e+02 2.3114059448242188e+02 2.7256359863281250e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-2.1348460388183594e+02 2.4323570251464844e+02 2.5151521301269531e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-1.9161479187011719e+02 2.7025439453125000e+02 2.2807769775390625e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.5104179382324219e+02 2.0007710266113281e+02 3.4590228271484375e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-2.2318161010742188e+02 1.9609190368652344e+02 2.4623390197753906e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(-2.2318161010742188e+02 1.9609190368652344e+02 2.4623390197753906e+02)(-2.2692179870605469e+02 1.9850480651855469e+02 2.5957427978515625e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(-2.5104179382324219e+02 2.0007710266113281e+02 3.4590228271484375e+02)(-2.6111538696289062e+02 1.9584129333496094e+02 3.9933718872070312e+02)(-2.0646250915527344e+02 1.9765351867675781e+02 2.2881451416015625e+02)(-2.2318161010742188e+02 1.9609190368652344e+02 2.4623390197753906e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(-2.2318161010742188e+02 1.9609190368652344e+02 2.4623390197753906e+02)(-2.6111538696289062e+02 1.9584129333496094e+02 3.9933718872070312e+02)(-2.6150000000000000e+02 1.9598291015625000e+02 2.2722410583496094e+02)(-2.4114279174804688e+02 1.9724281311035156e+02 2.9153500366210938e+02)(2.8766979980468750e+02 5.6536903381347656e+01 2.2371832275390625e+02)(2.9717562866210938e+02 6.7286697387695312e+01 2.2681999206542969e+02)(2.5847933959960938e+02 5.9713600158691406e+01 2.2820620727539062e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(2.8756579589843750e+02 3.1275302124023438e+02 -3.8603303255513310e-04)(3.0837292480468750e+02 2.9295678710937500e+02 -1.9449001410976052e-04)(3.0837292480468750e+02 2.9295678710937500e+02 -1.9449001410976052e-04)(3.2558059692382812e+02 2.6504330444335938e+02 -1.3530200812965631e-03)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(2.6423541259765625e+02 3.2544610595703125e+02 3.6640701000578701e-04)(2.8756579589843750e+02 3.1275302124023438e+02 -3.8603303255513310e-04)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(2.6423541259765625e+02 3.2544610595703125e+02 3.6640701000578701e-04)(3.2558059692382812e+02 2.6504330444335938e+02 -1.3530200812965631e-03)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(2.6423541259765625e+02 3.2544610595703125e+02 3.6640701000578701e-04)(2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(1.7298799133300781e+02 1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(1.7298799133300781e+02 1.3168540954589844e+02 0.0000000000000000e+00)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -1.6670870971679688e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -1.6670870971679688e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3300228881835938e+02 -2.3394499206542969e+02 -2.1230601705610752e-03)(3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(3.3300228881835938e+02 -2.3394499206542969e+02 -2.1230601705610752e-03)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(3.2534170532226562e+02 -2.6543481445312500e+02 2.6465600356459618e-02)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(3.3300228881835938e+02 -2.3394499206542969e+02 -2.1230601705610752e-03)(3.2534170532226562e+02 -2.6543481445312500e+02 2.6465600356459618e-02)(3.0749468994140625e+02 -2.9423840332031250e+02 -5.0370697863399982e-04)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(3.0749468994140625e+02 -2.9423840332031250e+02 -5.0370697863399982e-04)(2.8499829101562500e+02 -2.8055630493164062e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(2.8329028320312500e+02 -3.1575170898437500e+02 3.3284700475633144e-04)(2.8499829101562500e+02 -2.8055630493164062e+02 0.0000000000000000e+00)(3.0749468994140625e+02 -2.9423840332031250e+02 -5.0370697863399982e-04)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(2.8499829101562500e+02 -2.8055630493164062e+02 0.0000000000000000e+00)(2.8329028320312500e+02 -3.1575170898437500e+02 3.3284700475633144e-04)(2.5389692687988281e+02 -3.2920571899414062e+02 -4.5005104038864374e-04)(2.2955999755859375e+02 -3.3329043579101562e+02 0.0000000000000000e+00)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(2.2955999755859375e+02 -3.3329043579101562e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(2.2955999755859375e+02 -3.3329043579101562e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(1.7298799133300781e+02 1.3168540954589844e+02 0.0000000000000000e+00)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -1.6670870971679688e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.7298809814453125e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-2.6282391357421875e+02 3.2623703002929688e+02 -1.2352400226518512e-03)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-2.8578720092773438e+02 3.1374548339843750e+02 -1.1697199079208076e-04)(-2.6282391357421875e+02 3.2623703002929688e+02 -1.2352400226518512e-03)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-3.0551489257812500e+02 2.9663409423828125e+02 -5.0049502169713378e-04)(-2.8578720092773438e+02 3.1374548339843750e+02 -1.1697199079208076e-04)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(-3.2179577636718750e+02 2.7240411376953125e+02 -5.9413403505459428e-04)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-3.2179577636718750e+02 2.7240411376953125e+02 -5.9413403505459428e-04)(-3.0551489257812500e+02 2.9663409423828125e+02 -5.0049502169713378e-04)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-3.2179577636718750e+02 2.7240411376953125e+02 -5.9413403505459428e-04)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-1.7298809814453125e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-1.3856919860839844e+02 -1.6670881652832031e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -1.6670881652832031e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -1.6670881652832031e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-1.7298809814453125e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(-3.3225051879882812e+02 -2.4223959350585938e+02 6.2873600982129574e-03)(-3.3225051879882812e+02 -2.4223959350585938e+02 6.2873600982129574e-03)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-2.4389031982421875e+02 -3.3201651000976562e+02 -2.9791999259032309e-04)(-1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-2.4389031982421875e+02 -3.3201651000976562e+02 -2.9791999259032309e-04)(-2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-2.7797930908203125e+02 -3.1890380859375000e+02 -6.7372096236795187e-04)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-2.4389031982421875e+02 -3.3201651000976562e+02 -2.9791999259032309e-04)(-2.7797930908203125e+02 -3.1890380859375000e+02 -6.7372096236795187e-04)(-2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-3.0359701538085938e+02 -2.9891659545898438e+02 3.6203698255121708e-03)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-2.7797930908203125e+02 -3.1890380859375000e+02 -6.7372096236795187e-04)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-3.2203460693359375e+02 -2.7198519897460938e+02 -3.2156897941604257e-04)(-3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-3.0359701538085938e+02 -2.9891659545898438e+02 3.6203698255121708e-03)(-3.2203460693359375e+02 -2.7198519897460938e+02 -3.2156897941604257e-04)(-3.2203460693359375e+02 -2.7198519897460938e+02 -3.2156897941604257e-04)(-3.3225051879882812e+02 -2.4223959350585938e+02 6.2873600982129574e-03)(-3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(2.8329028320312500e+02 -3.1575170898437500e+02 3.3284700475633144e-04)(2.5389692687988281e+02 -3.2920571899414062e+02 -4.5005104038864374e-04)(1.3856919860839844e+02 -1.6670870971679688e+02 0.0000000000000000e+00)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.7298799133300781e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.7298799133300781e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(2.8499829101562500e+02 -2.8055630493164062e+02 2.0000000000000000e+02)(2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(2.8499829101562500e+02 -2.8055630493164062e+02 2.0000000000000000e+02)(2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(2.8499829101562500e+02 -2.8055630493164062e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(2.8499829101562500e+02 -2.8055630493164062e+02 0.0000000000000000e+00)(2.8499829101562500e+02 -2.8055630493164062e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(1.7298799133300781e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(2.8499829101562500e+02 -2.8055630493164062e+02 2.0000000000000000e+02)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(2.8499829101562500e+02 -2.8055630493164062e+02 2.0000000000000000e+02)(2.8499829101562500e+02 -2.8055630493164062e+02 0.0000000000000000e+00)(2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -1.6670881652832031e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3337500000000000e+02 -1.6071839904785156e+02 1.5554521179199219e+02)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.3337500000000000e+02 -1.6071839904785156e+02 1.5554521179199219e+02)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.3338150024414062e+02 -2.2422570800781250e+02 8.7235099792480469e+01)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3338150024414062e+02 -2.2422570800781250e+02 8.7235099792480469e+01)(3.3300228881835938e+02 -2.3394499206542969e+02 -2.1230601705610752e-03)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3337750244140625e+02 1.4074240112304688e+02 1.6864080810546875e+02)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.3333142089843750e+02 2.0433631896972656e+02 9.5074600219726562e+01)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(3.3333142089843750e+02 2.0433631896972656e+02 9.5074600219726562e+01)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(3.3373071289062500e+02 2.2492781066894531e+02 8.7267898559570312e+01)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.3337380981445312e+02 -1.1711849975585938e+02 0.0000000000000000e+00)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.3338150024414062e+02 -2.2422570800781250e+02 8.7235099792480469e+01)(3.3044311523437500e+02 -2.4968130493164062e+02 8.7400596618652344e+01)(3.3300228881835938e+02 -2.3394499206542969e+02 -2.1230601705610752e-03)(3.3044311523437500e+02 -2.4968130493164062e+02 8.7400596618652344e+01)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(3.2534170532226562e+02 -2.6543481445312500e+02 2.6465600356459618e-02)(2.9427081298828125e+02 -3.0797940063476562e+02 9.0645606994628906e+01)(2.5936489868164062e+02 -3.2758441162109375e+02 9.3793205261230469e+01)(2.8329028320312500e+02 -3.1575170898437500e+02 3.3284700475633144e-04)(2.5936489868164062e+02 -3.2758441162109375e+02 9.3793205261230469e+01)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(2.5389692687988281e+02 -3.2920571899414062e+02 -4.5005104038864374e-04)(3.3044311523437500e+02 -2.4968130493164062e+02 8.7400596618652344e+01)(3.2534170532226562e+02 -2.6543481445312500e+02 2.6465600356459618e-02)(3.3300228881835938e+02 -2.3394499206542969e+02 -2.1230601705610752e-03)(3.0749468994140625e+02 -2.9423840332031250e+02 -5.0370697863399982e-04)(3.2534170532226562e+02 -2.6543481445312500e+02 2.6465600356459618e-02)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(2.8329028320312500e+02 -3.1575170898437500e+02 3.3284700475633144e-04)(3.0749468994140625e+02 -2.9423840332031250e+02 -5.0370697863399982e-04)(2.9427081298828125e+02 -3.0797940063476562e+02 9.0645606994628906e+01)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(2.2955999755859375e+02 -3.3329043579101562e+02 0.0000000000000000e+00)(2.5389692687988281e+02 -3.2920571899414062e+02 -4.5005104038864374e-04)(2.5936489868164062e+02 -3.2758441162109375e+02 9.3793205261230469e+01)(2.5389692687988281e+02 -3.2920571899414062e+02 -4.5005104038864374e-04)(2.8329028320312500e+02 -3.1575170898437500e+02 3.3284700475633144e-04)(3.0749468994140625e+02 -2.9423840332031250e+02 -5.0370697863399982e-04)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(2.9427081298828125e+02 -3.0797940063476562e+02 9.0645606994628906e+01)(-2.2999981689453125e+02 -3.3321920776367188e+02 1.3758790588378906e+02)(-2.4389031982421875e+02 -3.3201651000976562e+02 -2.9791999259032309e-04)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-2.2999981689453125e+02 -3.3321920776367188e+02 1.3758790588378906e+02)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-1.0266629791259766e+02 -3.3337500000000000e+02 1.2619400024414062e+02)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(-4.4490000605583191e-01 -3.3337500000000000e+02 1.1703989410400391e+02)(-1.0266629791259766e+02 -3.3337500000000000e+02 1.2619400024414062e+02)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(1.2655520629882812e+02 -3.3337500000000000e+02 1.0566669464111328e+02)(-4.4490000605583191e-01 -3.3337500000000000e+02 1.1703989410400391e+02)(1.2655520629882812e+02 -3.3337500000000000e+02 1.0566669464111328e+02)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(-1.0734449768066406e+02 -3.3337500000000000e+02 0.0000000000000000e+00)(2.2955999755859375e+02 -3.3329043579101562e+02 0.0000000000000000e+00)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(-1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670881652832031e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670881652832031e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 -2.8055621337890625e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 -2.8055621337890625e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 -1.6670870971679688e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 -2.8055621337890625e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 -2.8055621337890625e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 -2.9789968872070312e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 -2.9789968872070312e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 -2.8055621337890625e+02 0.0000000000000000e+00)(-2.5181379699707031e+02 -3.2976950073242188e+02 1.3954969787597656e+02)(-2.4389031982421875e+02 -3.3201651000976562e+02 -2.9791999259032309e-04)(-2.2999981689453125e+02 -3.3321920776367188e+02 1.3758790588378906e+02)(-3.3258459472656250e+02 -2.3938159179687500e+02 1.4679800415039062e+02)(-3.3225051879882812e+02 -2.4223959350585938e+02 6.2873600982129574e-03)(-3.2442251586914062e+02 -2.6655001831054688e+02 1.4605419921875000e+02)(-3.2203460693359375e+02 -2.7198519897460938e+02 -3.2156897941604257e-04)(-3.1073141479492188e+02 -2.9012582397460938e+02 1.4482130432128906e+02)(-3.2442251586914062e+02 -2.6655001831054688e+02 1.4605419921875000e+02)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-3.0359701538085938e+02 -2.9891659545898438e+02 3.6203698255121708e-03)(-2.7797930908203125e+02 -3.1890380859375000e+02 -6.7372096236795187e-04)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-2.7797930908203125e+02 -3.1890380859375000e+02 -6.7372096236795187e-04)(-2.5181379699707031e+02 -3.2976950073242188e+02 1.3954969787597656e+02)(-2.5181379699707031e+02 -3.2976950073242188e+02 1.3954969787597656e+02)(-2.7797930908203125e+02 -3.1890380859375000e+02 -6.7372096236795187e-04)(-2.4389031982421875e+02 -3.3201651000976562e+02 -2.9791999259032309e-04)(-3.2203460693359375e+02 -2.7198519897460938e+02 -3.2156897941604257e-04)(-3.2442251586914062e+02 -2.6655001831054688e+02 1.4605419921875000e+02)(-3.3225051879882812e+02 -2.4223959350585938e+02 6.2873600982129574e-03)(-3.1073141479492188e+02 -2.9012582397460938e+02 1.4482130432128906e+02)(-3.0359701538085938e+02 -2.9891659545898438e+02 3.6203698255121708e-03)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-3.1073141479492188e+02 -2.9012582397460938e+02 1.4482130432128906e+02)(-3.2203460693359375e+02 -2.7198519897460938e+02 -3.2156897941604257e-04)(-3.0359701538085938e+02 -2.9891659545898438e+02 3.6203698255121708e-03)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-3.3337500000000000e+02 1.6147799682617188e+02 1.4692230224609375e+02)(-3.3301791381835938e+02 2.3431101989746094e+02 1.4681500244140625e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.3337500000000000e+02 1.6147799682617188e+02 1.4692230224609375e+02)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.3337561035156250e+02 1.0433460998535156e+02 1.8682940673828125e+02)(-3.3335760498046875e+02 1.2336430358886719e+02 1.8009201049804688e+02)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3337561035156250e+02 1.0433460998535156e+02 1.8682940673828125e+02)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3337500000000000e+02 1.6147799682617188e+02 1.4692230224609375e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.3337500000000000e+02 1.2175200462341309e+01 1.8685450744628906e+02)(-3.3337561035156250e+02 1.0433460998535156e+02 1.8682940673828125e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3337500000000000e+02 1.2175200462341309e+01 1.8685450744628906e+02)(-3.3337500000000000e+02 -1.0636940002441406e+02 1.8665480041503906e+02)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3337500000000000e+02 -1.4438999938964844e+02 1.5344360351562500e+02)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.3337500000000000e+02 -1.4438999938964844e+02 1.5344360351562500e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3337509155273438e+02 -1.6136839294433594e+02 1.4694731140136719e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3258459472656250e+02 -2.3938159179687500e+02 1.4679800415039062e+02)(-3.3337509155273438e+02 -1.6136839294433594e+02 1.4694731140136719e+02)(-3.3337561035156250e+02 -1.0389200210571289e+01 0.0000000000000000e+00)(-3.3225051879882812e+02 -2.4223959350585938e+02 6.2873600982129574e-03)(-3.3258459472656250e+02 -2.3938159179687500e+02 1.4679800415039062e+02)(-3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -2.2474110412597656e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -2.2474110412597656e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 -1.3168540954589844e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055630493164062e+02 2.0000000000000000e+02)(3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(1.7298799133300781e+02 1.3168540954589844e+02 0.0000000000000000e+00)(3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(1.7298799133300781e+02 1.3168540954589844e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(1.7298799133300781e+02 1.3168540954589844e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 0.0000000000000000e+00)(2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055621337890625e+02 0.0000000000000000e+00)(2.8499829101562500e+02 2.8055630493164062e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(-1.7298809814453125e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-1.7298809814453125e+02 1.3168540954589844e+02 0.0000000000000000e+00)(2.2822010803222656e+02 3.3336099243164062e+02 9.6564002990722656e+01)(2.5065159606933594e+02 3.3002069091796875e+02 9.4569000244140625e+01)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(2.7867611694335938e+02 3.1863848876953125e+02 9.2054397583007812e+01)(3.0261358642578125e+02 2.9948519897460938e+02 8.9896102905273438e+01)(2.8756579589843750e+02 3.1275302124023438e+02 -3.8603303255513310e-04)(3.1850311279296875e+02 2.7859292602539062e+02 8.8477302551269531e+01)(3.0837292480468750e+02 2.9295678710937500e+02 -1.9449001410976052e-04)(3.0261358642578125e+02 2.9948519897460938e+02 8.9896102905273438e+01)(3.1850311279296875e+02 2.7859292602539062e+02 8.8477302551269531e+01)(3.2872680664062500e+02 2.5509283447265625e+02 8.7569602966308594e+01)(3.2558059692382812e+02 2.6504330444335938e+02 -1.3530200812965631e-03)(3.3373071289062500e+02 2.2492781066894531e+02 8.7267898559570312e+01)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(3.2872680664062500e+02 2.5509283447265625e+02 8.7569602966308594e+01)(2.7867611694335938e+02 3.1863848876953125e+02 9.2054397583007812e+01)(2.8756579589843750e+02 3.1275302124023438e+02 -3.8603303255513310e-04)(2.6423541259765625e+02 3.2544610595703125e+02 3.6640701000578701e-04)(2.6423541259765625e+02 3.2544610595703125e+02 3.6640701000578701e-04)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(2.5065159606933594e+02 3.3002069091796875e+02 9.4569000244140625e+01)(3.0261358642578125e+02 2.9948519897460938e+02 8.9896102905273438e+01)(3.0837292480468750e+02 2.9295678710937500e+02 -1.9449001410976052e-04)(2.8756579589843750e+02 3.1275302124023438e+02 -3.8603303255513310e-04)(3.0837292480468750e+02 2.9295678710937500e+02 -1.9449001410976052e-04)(3.1850311279296875e+02 2.7859292602539062e+02 8.8477302551269531e+01)(3.2558059692382812e+02 2.6504330444335938e+02 -1.3530200812965631e-03)(3.2558059692382812e+02 2.6504330444335938e+02 -1.3530200812965631e-03)(3.2872680664062500e+02 2.5509283447265625e+02 8.7569602966308594e+01)(3.3315081787109375e+02 2.3254238891601562e+02 -1.9630900351330638e-04)(2.5065159606933594e+02 3.3002069091796875e+02 9.4569000244140625e+01)(2.7867611694335938e+02 3.1863848876953125e+02 9.2054397583007812e+01)(2.6423541259765625e+02 3.2544610595703125e+02 3.6640701000578701e-04)(-1.3309899902343750e+02 3.3337500000000000e+02 1.2891929626464844e+02)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-2.2697041320800781e+02 3.3336151123046875e+02 1.3732460021972656e+02)(-1.2736399650573730e+01 3.3337500000000000e+02 1.1814060211181641e+02)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(-1.3309899902343750e+02 3.3337500000000000e+02 1.2891929626464844e+02)(-1.3309899902343750e+02 3.3337500000000000e+02 1.2891929626464844e+02)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-1.2736399650573730e+01 3.3337500000000000e+02 1.1814060211181641e+02)(5.6024497985839844e+01 3.3337500000000000e+02 1.1198289489746094e+02)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(1.3019029235839844e+02 3.3337500000000000e+02 1.0534119415283203e+02)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(5.6024497985839844e+01 3.3337500000000000e+02 1.1198289489746094e+02)(2.2822010803222656e+02 3.3336099243164062e+02 9.6564002990722656e+01)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(1.3019029235839844e+02 3.3337500000000000e+02 1.0534119415283203e+02)(2.3840849304199219e+02 3.3261022949218750e+02 -1.3229099567979574e-03)(8.4165596008300781e+01 3.3337500000000000e+02 0.0000000000000000e+00)(5.6024497985839844e+01 3.3337500000000000e+02 1.1198289489746094e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.3337500000000000e+02 -1.6071839904785156e+02 1.5554521179199219e+02)(3.2628161621093750e+02 -1.3295109558105469e+02 1.6949569702148438e+02)(3.2519812011718750e+02 -1.4426939392089844e+02 1.6764410400390625e+02)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.2519812011718750e+02 -1.4426939392089844e+02 1.6764410400390625e+02)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.2633560180664062e+02 -6.9561103820800781e+01 1.6952090454101562e+02)(3.2628161621093750e+02 -1.3295109558105469e+02 1.6949569702148438e+02)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.2644128417968750e+02 -1.6672700881958008e+01 1.6950199890136719e+02)(3.2633560180664062e+02 -6.9561103820800781e+01 1.6952090454101562e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.2644128417968750e+02 -1.6672700881958008e+01 1.6950199890136719e+02)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.3337750244140625e+02 1.4074240112304688e+02 1.6864080810546875e+02)(3.2642541503906250e+02 1.2969680786132812e+02 1.6949861145019531e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.2633560180664062e+02 -6.9561103820800781e+01 1.6952090454101562e+02)(3.3336041259765625e+02 -1.4279119873046875e+02 1.6829330444335938e+02)(3.3337750244140625e+02 1.4074240112304688e+02 1.6864080810546875e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.3337500000000000e+02 -3.9860401153564453e+01 1.6950170898437500e+02)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.2684503173828125e+02 1.5598458862304688e+02 1.6139340209960938e+02)(3.3337750244140625e+02 1.4074240112304688e+02 1.6864080810546875e+02)(3.2684503173828125e+02 1.5598458862304688e+02 1.6139340209960938e+02)(3.2605511474609375e+02 1.3662341308593750e+02 1.6908020019531250e+02)(3.3337750244140625e+02 1.4074240112304688e+02 1.6864080810546875e+02)(3.3337750244140625e+02 1.4074240112304688e+02 1.6864080810546875e+02)(3.2605511474609375e+02 1.3662341308593750e+02 1.6908020019531250e+02)(3.2642541503906250e+02 1.2969680786132812e+02 1.6949861145019531e+02)(3.2896600341796875e+02 1.9909230041503906e+02 1.0106680297851562e+02)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.3333142089843750e+02 2.0433631896972656e+02 9.5074600219726562e+01)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.2782641601562500e+02 1.7954679870605469e+02 1.2886880493164062e+02)(3.2684503173828125e+02 1.5598458862304688e+02 1.6139340209960938e+02)(3.2896600341796875e+02 1.9909230041503906e+02 1.0106680297851562e+02)(3.2782641601562500e+02 1.7954679870605469e+02 1.2886880493164062e+02)(3.3337500000000000e+02 1.5934320068359375e+02 1.5747549438476562e+02)(3.3333142089843750e+02 2.0433631896972656e+02 9.5074600219726562e+01)(3.2861883544921875e+02 2.2239151000976562e+02 8.7643493652343750e+01)(3.2831091308593750e+02 2.0663359069824219e+02 9.4131401062011719e+01)(3.2831091308593750e+02 2.0663359069824219e+02 9.4131401062011719e+01)(3.2896600341796875e+02 1.9909230041503906e+02 1.0106680297851562e+02)(3.3333142089843750e+02 2.0433631896972656e+02 9.5074600219726562e+01)(3.3373071289062500e+02 2.2492781066894531e+02 8.7267898559570312e+01)(3.2861883544921875e+02 2.2239151000976562e+02 8.7643493652343750e+01)(3.3333142089843750e+02 2.0433631896972656e+02 9.5074600219726562e+01)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(3.3338150024414062e+02 -2.2422570800781250e+02 8.7235099792480469e+01)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.2897482299804688e+02 -1.9821269226074219e+02 1.0209870147705078e+02)(3.2830627441406250e+02 -2.0621910095214844e+02 9.4482208251953125e+01)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.2830627441406250e+02 -2.0621910095214844e+02 9.4482208251953125e+01)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.3337500000000000e+02 -1.6071839904785156e+02 1.5554521179199219e+02)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.2897482299804688e+02 -1.9821269226074219e+02 1.0209870147705078e+02)(3.3335491943359375e+02 -2.0438900756835938e+02 9.5105308532714844e+01)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.1445388793945312e+02 -2.7596820068359375e+02 8.8462303161621094e+01)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(2.3932618713378906e+02 -3.2802960205078125e+02 9.5508102416992188e+01)(2.5936489868164062e+02 -3.2758441162109375e+02 9.3793205261230469e+01)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.9427081298828125e+02 -3.0797940063476562e+02 9.0645606994628906e+01)(3.0023101806640625e+02 -2.9510543823242188e+02 8.9796104431152344e+01)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(3.3044311523437500e+02 -2.4968130493164062e+02 8.7400596618652344e+01)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.3338150024414062e+02 -2.2422570800781250e+02 8.7235099792480469e+01)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(2.9427081298828125e+02 -3.0797940063476562e+02 9.0645606994628906e+01)(2.7438543701171875e+02 -3.1605062866210938e+02 9.2262405395507812e+01)(2.5936489868164062e+02 -3.2758441162109375e+02 9.3793205261230469e+01)(3.3044311523437500e+02 -2.4968130493164062e+02 8.7400596618652344e+01)(3.3338150024414062e+02 -2.2422570800781250e+02 8.7235099792480469e+01)(3.2601971435546875e+02 -2.4838049316406250e+02 8.7334800720214844e+01)(3.0023101806640625e+02 -2.9510543823242188e+02 8.9796104431152344e+01)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(3.1445388793945312e+02 -2.7596820068359375e+02 8.8462303161621094e+01)(2.5936489868164062e+02 -3.2758441162109375e+02 9.3793205261230469e+01)(2.3932618713378906e+02 -3.2802960205078125e+02 9.5508102416992188e+01)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(2.9427081298828125e+02 -3.0797940063476562e+02 9.0645606994628906e+01)(3.1859121704101562e+02 -2.7849011230468750e+02 8.8449699401855469e+01)(3.0023101806640625e+02 -2.9510543823242188e+02 8.9796104431152344e+01)(-1.0266629791259766e+02 -3.3337500000000000e+02 1.2619400024414062e+02)(-1.4276521301269531e+02 -3.2852908325195312e+02 1.2978489685058594e+02)(-2.2999981689453125e+02 -3.3321920776367188e+02 1.3758790588378906e+02)(1.2655520629882812e+02 -3.3337500000000000e+02 1.0566669464111328e+02)(6.1352401733398438e+01 -3.2884820556640625e+02 1.1150560760498047e+02)(-4.4490000605583191e-01 -3.3337500000000000e+02 1.1703989410400391e+02)(-4.4490000605583191e-01 -3.3337500000000000e+02 1.1703989410400391e+02)(-5.5821697235107422e+01 -3.2866497802734375e+02 1.2199890899658203e+02)(-1.0266629791259766e+02 -3.3337500000000000e+02 1.2619400024414062e+02)(-4.4490000605583191e-01 -3.3337500000000000e+02 1.1703989410400391e+02)(6.1352401733398438e+01 -3.2884820556640625e+02 1.1150560760498047e+02)(-5.5821697235107422e+01 -3.2866497802734375e+02 1.2199890899658203e+02)(1.2655520629882812e+02 -3.3337500000000000e+02 1.0566669464111328e+02)(2.0085839843750000e+02 -3.2906631469726562e+02 9.9012397766113281e+01)(6.1352401733398438e+01 -3.2884820556640625e+02 1.1150560760498047e+02)(2.3932618713378906e+02 -3.2802960205078125e+02 9.5508102416992188e+01)(2.0085839843750000e+02 -3.2906631469726562e+02 9.9012397766113281e+01)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(2.3212730407714844e+02 -3.3318969726562500e+02 9.6215095520019531e+01)(2.0085839843750000e+02 -3.2906631469726562e+02 9.9012397766113281e+01)(1.2655520629882812e+02 -3.3337500000000000e+02 1.0566669464111328e+02)(-1.0266629791259766e+02 -3.3337500000000000e+02 1.2619400024414062e+02)(-5.5821697235107422e+01 -3.2866497802734375e+02 1.2199890899658203e+02)(-1.4276521301269531e+02 -3.2852908325195312e+02 1.2978489685058594e+02)(-1.4276521301269531e+02 -3.2852908325195312e+02 1.2978489685058594e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.2999981689453125e+02 -3.3321920776367188e+02 1.3758790588378906e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-3.2832461547851562e+02 -2.3432460021972656e+02 1.4680950927734375e+02)(-3.3258459472656250e+02 -2.3938159179687500e+02 1.4679800415039062e+02)(-3.2442251586914062e+02 -2.6655001831054688e+02 1.4605419921875000e+02)(-3.1073141479492188e+02 -2.9012582397460938e+02 1.4482130432128906e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-2.8053140258789062e+02 -3.1139001464843750e+02 1.4237069702148438e+02)(-3.0475650024414062e+02 -2.8972198486328125e+02 1.4465420532226562e+02)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.8053140258789062e+02 -3.1139001464843750e+02 1.4237069702148438e+02)(-3.2442251586914062e+02 -2.6655001831054688e+02 1.4605419921875000e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-3.3258459472656250e+02 -2.3938159179687500e+02 1.4679800415039062e+02)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-3.0475650024414062e+02 -2.8972198486328125e+02 1.4465420532226562e+02)(-3.1073141479492188e+02 -2.9012582397460938e+02 1.4482130432128906e+02)(-2.5181379699707031e+02 -3.2976950073242188e+02 1.3954969787597656e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.8527233886718750e+02 -3.1483761596679688e+02 1.4254910278320312e+02)(-2.2999981689453125e+02 -3.3321920776367188e+02 1.3758790588378906e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.5181379699707031e+02 -3.2976950073242188e+02 1.3954969787597656e+02)(-3.0475650024414062e+02 -2.8972198486328125e+02 1.4465420532226562e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-3.1073141479492188e+02 -2.9012582397460938e+02 1.4482130432128906e+02)(-3.2779809570312500e+02 2.5799807739257812e+02 1.4635411071777344e+02)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-3.3301791381835938e+02 2.3431101989746094e+02 1.4681500244140625e+02)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-2.3978089904785156e+02 3.3222409057617188e+02 1.3846380615234375e+02)(-2.2697041320800781e+02 3.3336151123046875e+02 1.3732460021972656e+02)(-2.9361590576171875e+02 3.0790051269531250e+02 1.4328730773925781e+02)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-2.8578720092773438e+02 3.1374548339843750e+02 -1.1697199079208076e-04)(-2.3978089904785156e+02 3.3222409057617188e+02 1.3846380615234375e+02)(-2.6282391357421875e+02 3.2623703002929688e+02 -1.2352400226518512e-03)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-3.2779809570312500e+02 2.5799807739257812e+02 1.4635411071777344e+02)(-3.2179577636718750e+02 2.7240411376953125e+02 -5.9413403505459428e-04)(-3.3221191406250000e+02 2.4176589965820312e+02 1.7532501369714737e-03)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-2.9361590576171875e+02 3.0790051269531250e+02 1.4328730773925781e+02)(-3.0551489257812500e+02 2.9663409423828125e+02 -5.0049502169713378e-04)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-3.0551489257812500e+02 2.9663409423828125e+02 -5.0049502169713378e-04)(-3.2179577636718750e+02 2.7240411376953125e+02 -5.9413403505459428e-04)(-2.9361590576171875e+02 3.0790051269531250e+02 1.4328730773925781e+02)(-2.8578720092773438e+02 3.1374548339843750e+02 -1.1697199079208076e-04)(-3.0551489257812500e+02 2.9663409423828125e+02 -5.0049502169713378e-04)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-2.6282391357421875e+02 3.2623703002929688e+02 -1.2352400226518512e-03)(-2.8578720092773438e+02 3.1374548339843750e+02 -1.1697199079208076e-04)(-2.3978089904785156e+02 3.3222409057617188e+02 1.3846380615234375e+02)(-2.3388290405273438e+02 3.3305523681640625e+02 -1.8764499691314995e-04)(-2.6282391357421875e+02 3.2623703002929688e+02 -1.2352400226518512e-03)(-3.2179577636718750e+02 2.7240411376953125e+02 -5.9413403505459428e-04)(-3.2779809570312500e+02 2.5799807739257812e+02 1.4635411071777344e+02)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-3.2881723022460938e+02 1.5969020080566406e+02 1.4697540283203125e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.3301791381835938e+02 2.3431101989746094e+02 1.4681500244140625e+02)(-3.3337500000000000e+02 1.6147799682617188e+02 1.4692230224609375e+02)(-3.2881723022460938e+02 1.5969020080566406e+02 1.4697540283203125e+02)(-3.3301791381835938e+02 2.3431101989746094e+02 1.4681500244140625e+02)(-3.2866641235351562e+02 1.4169609069824219e+02 1.5581219482421875e+02)(-3.2881723022460938e+02 1.5969020080566406e+02 1.4697540283203125e+02)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.2881723022460938e+02 1.5969020080566406e+02 1.4697540283203125e+02)(-3.3337500000000000e+02 1.6147799682617188e+02 1.4692230224609375e+02)(-3.2936868286132812e+02 1.2512789916992188e+02 1.7853860473632812e+02)(-3.2866641235351562e+02 1.4169609069824219e+02 1.5581219482421875e+02)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.3335760498046875e+02 1.2336430358886719e+02 1.8009201049804688e+02)(-3.2936868286132812e+02 1.2512789916992188e+02 1.7853860473632812e+02)(-3.3334811401367188e+02 1.4255760192871094e+02 1.5445460510253906e+02)(-3.3335760498046875e+02 1.2336430358886719e+02 1.8009201049804688e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.2936868286132812e+02 1.2512789916992188e+02 1.7853860473632812e+02)(-3.3337561035156250e+02 1.0433460998535156e+02 1.8682940673828125e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.3335760498046875e+02 1.2336430358886719e+02 1.8009201049804688e+02)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.2820089721679688e+02 -5.1091701507568359e+01 1.8707220458984375e+02)(-3.2851681518554688e+02 -4.4033002853393555e+00 1.8685450744628906e+02)(-3.3337561035156250e+02 1.0433460998535156e+02 1.8682940673828125e+02)(-3.2851879882812500e+02 6.1788200378417969e+01 1.8685330200195312e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.3337500000000000e+02 1.2175200462341309e+01 1.8685450744628906e+02)(-3.2851879882812500e+02 6.1788200378417969e+01 1.8685330200195312e+02)(-3.3337561035156250e+02 1.0433460998535156e+02 1.8682940673828125e+02)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.2851681518554688e+02 -4.4033002853393555e+00 1.8685450744628906e+02)(-3.3337500000000000e+02 1.2175200462341309e+01 1.8685450744628906e+02)(-3.3337500000000000e+02 -1.0636940002441406e+02 1.8665480041503906e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.2820089721679688e+02 -5.1091701507568359e+01 1.8707220458984375e+02)(-3.3337500000000000e+02 -3.6560604095458984e+01 1.8686691284179688e+02)(-3.3337500000000000e+02 1.2175200462341309e+01 1.8685450744628906e+02)(-3.2851681518554688e+02 -4.4033002853393555e+00 1.8685450744628906e+02)(-3.2851879882812500e+02 6.1788200378417969e+01 1.8685330200195312e+02)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.3337500000000000e+02 -1.0636940002441406e+02 1.8665480041503906e+02)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.2872268676757812e+02 -1.2441740417480469e+02 1.7931520080566406e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.2875030517578125e+02 -1.4176580810546875e+02 1.5545831298828125e+02)(-3.2872268676757812e+02 -1.2441740417480469e+02 1.7931520080566406e+02)(-3.3337500000000000e+02 -1.4438999938964844e+02 1.5344360351562500e+02)(-3.2880389404296875e+02 -1.5834950256347656e+02 1.4735920715332031e+02)(-3.2875030517578125e+02 -1.4176580810546875e+02 1.5545831298828125e+02)(-3.3337500000000000e+02 -1.4438999938964844e+02 1.5344360351562500e+02)(-3.2875030517578125e+02 -1.4176580810546875e+02 1.5545831298828125e+02)(-3.3335470581054688e+02 -1.2448749542236328e+02 1.7886950683593750e+02)(-3.3337509155273438e+02 -1.6136839294433594e+02 1.4694731140136719e+02)(-3.2880389404296875e+02 -1.5834950256347656e+02 1.4735920715332031e+02)(-3.3337500000000000e+02 -1.4438999938964844e+02 1.5344360351562500e+02)(-3.3258459472656250e+02 -2.3938159179687500e+02 1.4679800415039062e+02)(-3.2832461547851562e+02 -2.3432460021972656e+02 1.4680950927734375e+02)(-3.3337509155273438e+02 -1.6136839294433594e+02 1.4694731140136719e+02)(-3.3337509155273438e+02 -1.6136839294433594e+02 1.4694731140136719e+02)(-3.2832461547851562e+02 -2.3432460021972656e+02 1.4680950927734375e+02)(-3.2880389404296875e+02 -1.5834950256347656e+02 1.4735920715332031e+02)(-2.8499829101562500e+02 2.8055621337890625e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 2.8055621337890625e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 2.8055621337890625e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 2.8055630493164062e+02 0.0000000000000000e+00)(-2.2517819213867188e+02 2.9789968872070312e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-1.7298809814453125e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 1.3168540954589844e+02 0.0000000000000000e+00)(-3.0478341674804688e+02 2.2474110412597656e+02 0.0000000000000000e+00)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055630493164062e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(2.8499829101562500e+02 2.8055630493164062e+02 2.0000000000000000e+02)(3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(1.3856919860839844e+02 1.6670870971679688e+02 2.0000000000000000e+02)(3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-1.7298799133300781e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 1.3168540954589844e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(-2.8499829101562500e+02 2.8055621337890625e+02 2.0000000000000000e+02)(-2.2517819213867188e+02 2.9789968872070312e+02 2.0000000000000000e+02)(-1.3856919860839844e+02 1.6670881652832031e+02 2.0000000000000000e+02)(-3.0478341674804688e+02 2.2474110412597656e+02 2.0000000000000000e+02)(2.2822010803222656e+02 3.3336099243164062e+02 9.6564002990722656e+01)(2.3917280578613281e+02 3.2810919189453125e+02 9.5524398803710938e+01)(2.5065159606933594e+02 3.3002069091796875e+02 9.4569000244140625e+01)(2.7867611694335938e+02 3.1863848876953125e+02 9.2054397583007812e+01)(2.6558251953125000e+02 3.1989309692382812e+02 9.3066200256347656e+01)(2.8560290527343750e+02 3.0813241577148438e+02 9.1175903320312500e+01)(2.7867611694335938e+02 3.1863848876953125e+02 9.2054397583007812e+01)(2.8560290527343750e+02 3.0813241577148438e+02 9.1175903320312500e+01)(3.0261358642578125e+02 2.9948519897460938e+02 8.9896102905273438e+01)(3.2064602661132812e+02 2.6342208862304688e+02 8.7899795532226562e+01)(3.1850311279296875e+02 2.7859292602539062e+02 8.8477302551269531e+01)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(3.0261358642578125e+02 2.9948519897460938e+02 8.9896102905273438e+01)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(3.1850311279296875e+02 2.7859292602539062e+02 8.8477302551269531e+01)(3.3373071289062500e+02 2.2492781066894531e+02 8.7267898559570312e+01)(3.2872680664062500e+02 2.5509283447265625e+02 8.7569602966308594e+01)(3.2740530395507812e+02 2.4039630126953125e+02 8.7170707702636719e+01)(2.3917280578613281e+02 3.2810919189453125e+02 9.5524398803710938e+01)(2.6558251953125000e+02 3.1989309692382812e+02 9.3066200256347656e+01)(2.5065159606933594e+02 3.3002069091796875e+02 9.4569000244140625e+01)(2.8560290527343750e+02 3.0813241577148438e+02 9.1175903320312500e+01)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(3.0261358642578125e+02 2.9948519897460938e+02 8.9896102905273438e+01)(3.2064602661132812e+02 2.6342208862304688e+02 8.7899795532226562e+01)(3.2740530395507812e+02 2.4039630126953125e+02 8.7170707702636719e+01)(3.2872680664062500e+02 2.5509283447265625e+02 8.7569602966308594e+01)(3.1850311279296875e+02 2.7859292602539062e+02 8.8477302551269531e+01)(3.2064602661132812e+02 2.6342208862304688e+02 8.7899795532226562e+01)(3.2872680664062500e+02 2.5509283447265625e+02 8.7569602966308594e+01)(2.5065159606933594e+02 3.3002069091796875e+02 9.4569000244140625e+01)(2.6558251953125000e+02 3.1989309692382812e+02 9.3066200256347656e+01)(2.7867611694335938e+02 3.1863848876953125e+02 9.2054397583007812e+01)(3.2740530395507812e+02 2.4039630126953125e+02 8.7170707702636719e+01)(3.2861883544921875e+02 2.2239151000976562e+02 8.7643493652343750e+01)(3.3373071289062500e+02 2.2492781066894531e+02 8.7267898559570312e+01)(1.5932330322265625e+02 3.2900131225585938e+02 1.0273200225830078e+02)(1.3019029235839844e+02 3.3337500000000000e+02 1.0534119415283203e+02)(9.9946403503417969e+01 3.2890850830078125e+02 1.0804940795898438e+02)(-7.8173202514648438e+01 3.2863009643554688e+02 1.2400050354003906e+02)(-1.3309899902343750e+02 3.3337500000000000e+02 1.2891929626464844e+02)(-2.2846400451660156e+02 3.2837481689453125e+02 1.3746459960937500e+02)(-2.1326700210571289e+01 3.2871890258789062e+02 1.1890970611572266e+02)(-1.2736399650573730e+01 3.3337500000000000e+02 1.1814060211181641e+02)(-7.8173202514648438e+01 3.2863009643554688e+02 1.2400050354003906e+02)(5.6024497985839844e+01 3.3337500000000000e+02 1.1198289489746094e+02)(-1.2736399650573730e+01 3.3337500000000000e+02 1.1814060211181641e+02)(-2.1326700210571289e+01 3.2871890258789062e+02 1.1890970611572266e+02)(9.9946403503417969e+01 3.2890850830078125e+02 1.0804940795898438e+02)(5.6024497985839844e+01 3.3337500000000000e+02 1.1198289489746094e+02)(-2.1326700210571289e+01 3.2871890258789062e+02 1.1890970611572266e+02)(9.9946403503417969e+01 3.2890850830078125e+02 1.0804940795898438e+02)(1.3019029235839844e+02 3.3337500000000000e+02 1.0534119415283203e+02)(5.6024497985839844e+01 3.3337500000000000e+02 1.1198289489746094e+02)(2.3917280578613281e+02 3.2810919189453125e+02 9.5524398803710938e+01)(2.2822010803222656e+02 3.3336099243164062e+02 9.6564002990722656e+01)(1.5932330322265625e+02 3.2900131225585938e+02 1.0273200225830078e+02)(1.5932330322265625e+02 3.2900131225585938e+02 1.0273200225830078e+02)(2.2822010803222656e+02 3.3336099243164062e+02 9.6564002990722656e+01)(1.3019029235839844e+02 3.3337500000000000e+02 1.0534119415283203e+02)(-7.8173202514648438e+01 3.2863009643554688e+02 1.2400050354003906e+02)(-1.2736399650573730e+01 3.3337500000000000e+02 1.1814060211181641e+02)(-1.3309899902343750e+02 3.3337500000000000e+02 1.2891929626464844e+02)(-2.2846400451660156e+02 3.2837481689453125e+02 1.3746459960937500e+02)(-1.3309899902343750e+02 3.3337500000000000e+02 1.2891929626464844e+02)(-2.2697041320800781e+02 3.3336151123046875e+02 1.3732460021972656e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.2453042602539062e+02 2.4608699798583984e+01 1.7106109619140625e+02)(3.2644128417968750e+02 -1.6672700881958008e+01 1.6950199890136719e+02)(3.2642541503906250e+02 1.2969680786132812e+02 1.6949861145019531e+02)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2448699951171875e+02 8.4366401672363281e+01 1.7114210510253906e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.2448699951171875e+02 8.4366401672363281e+01 1.7114210510253906e+02)(3.2447790527343750e+02 5.4313999176025391e+01 1.7105578613281250e+02)(3.2633560180664062e+02 -6.9561103820800781e+01 1.6952090454101562e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2628161621093750e+02 -1.3295109558105469e+02 1.6949569702148438e+02)(3.2644128417968750e+02 -1.6672700881958008e+01 1.6950199890136719e+02)(3.2445431518554688e+02 -2.7274501800537109e+01 1.7129049682617188e+02)(3.2633560180664062e+02 -6.9561103820800781e+01 1.6952090454101562e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.2447790527343750e+02 5.4313999176025391e+01 1.7105578613281250e+02)(3.2453042602539062e+02 2.4608699798583984e+01 1.7106109619140625e+02)(3.2642541503906250e+02 1.2969680786132812e+02 1.6949861145019531e+02)(3.2448699951171875e+02 8.4366401672363281e+01 1.7114210510253906e+02)(3.2646008300781250e+02 5.3080600738525391e+01 1.6949879455566406e+02)(3.2684503173828125e+02 1.5598458862304688e+02 1.6139340209960938e+02)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2605511474609375e+02 1.3662341308593750e+02 1.6908020019531250e+02)(3.2605511474609375e+02 1.3662341308593750e+02 1.6908020019531250e+02)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2642541503906250e+02 1.2969680786132812e+02 1.6949861145019531e+02)(3.2831091308593750e+02 2.0663359069824219e+02 9.4131401062011719e+01)(3.2495730590820312e+02 1.5911430358886719e+02 1.6115341186523438e+02)(3.2782641601562500e+02 1.7954679870605469e+02 1.2886880493164062e+02)(3.2782641601562500e+02 1.7954679870605469e+02 1.2886880493164062e+02)(3.2495730590820312e+02 1.5911430358886719e+02 1.6115341186523438e+02)(3.2684503173828125e+02 1.5598458862304688e+02 1.6139340209960938e+02)(3.2896600341796875e+02 1.9909230041503906e+02 1.0106680297851562e+02)(3.2831091308593750e+02 2.0663359069824219e+02 9.4131401062011719e+01)(3.2782641601562500e+02 1.7954679870605469e+02 1.2886880493164062e+02)(3.2861883544921875e+02 2.2239151000976562e+02 8.7643493652343750e+01)(3.2495730590820312e+02 1.5911430358886719e+02 1.6115341186523438e+02)(3.2831091308593750e+02 2.0663359069824219e+02 9.4131401062011719e+01)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.2495730590820312e+02 1.5911430358886719e+02 1.6115341186523438e+02)(3.2861883544921875e+02 2.2239151000976562e+02 8.7643493652343750e+01)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2495730590820312e+02 1.5911430358886719e+02 1.6115341186523438e+02)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2453042602539062e+02 2.4608699798583984e+01 1.7106109619140625e+02)(3.2447790527343750e+02 5.4313999176025391e+01 1.7105578613281250e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2447790527343750e+02 5.4313999176025391e+01 1.7105578613281250e+02)(3.2448699951171875e+02 8.4366401672363281e+01 1.7114210510253906e+02)(3.2830627441406250e+02 -2.0621910095214844e+02 9.4482208251953125e+01)(3.2713409423828125e+02 -1.8976231384277344e+02 1.1786899566650391e+02)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(3.2713409423828125e+02 -1.8976231384277344e+02 1.1786899566650391e+02)(3.2521972656250000e+02 -1.6357580566406250e+02 1.5534880065917969e+02)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2445431518554688e+02 -2.7274501800537109e+01 1.7129049682617188e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2199200439453125e+02 -8.0251098632812500e+01 2.1042601013183594e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2199200439453125e+02 -8.0251098632812500e+01 2.1042601013183594e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.2519812011718750e+02 -1.4426939392089844e+02 1.6764410400390625e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.2519812011718750e+02 -1.4426939392089844e+02 1.6764410400390625e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.2521972656250000e+02 -1.6357580566406250e+02 1.5534880065917969e+02)(3.2521972656250000e+02 -1.6357580566406250e+02 1.5534880065917969e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.2864031982421875e+02 -2.1992309570312500e+02 8.7972404479980469e+01)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2448699951171875e+02 8.4366401672363281e+01 1.7114210510253906e+02)(3.2453042602539062e+02 2.4608699798583984e+01 1.7106109619140625e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2445431518554688e+02 -2.7274501800537109e+01 1.7129049682617188e+02)(3.2713409423828125e+02 -1.8976231384277344e+02 1.1786899566650391e+02)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.2521972656250000e+02 -1.6357580566406250e+02 1.5534880065917969e+02)(3.2897482299804688e+02 -1.9821269226074219e+02 1.0209870147705078e+02)(3.2713409423828125e+02 -1.8976231384277344e+02 1.1786899566650391e+02)(3.2830627441406250e+02 -2.0621910095214844e+02 9.4482208251953125e+01)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.2713409423828125e+02 -1.8976231384277344e+02 1.1786899566650391e+02)(3.2897482299804688e+02 -1.9821269226074219e+02 1.0209870147705078e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-1.4276521301269531e+02 -3.2852908325195312e+02 1.2978489685058594e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(-1.4276521301269531e+02 -3.2852908325195312e+02 1.2978489685058594e+02)(-5.5821697235107422e+01 -3.2866497802734375e+02 1.2199890899658203e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(6.1352401733398438e+01 -3.2884820556640625e+02 1.1150560760498047e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(-5.5821697235107422e+01 -3.2866497802734375e+02 1.2199890899658203e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(6.1352401733398438e+01 -3.2884820556640625e+02 1.1150560760498047e+02)(2.0085839843750000e+02 -3.2906631469726562e+02 9.9012397766113281e+01)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(-5.5821697235107422e+01 -3.2866497802734375e+02 1.2199890899658203e+02)(-4.2555404663085938e+01 -3.2706671142578125e+02 2.1332569885253906e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(-1.7616009521484375e+02 -3.2709820556640625e+02 2.1171620178222656e+02)(-4.2555404663085938e+01 -3.2706671142578125e+02 2.1332569885253906e+02)(-1.1189570617675781e+02 -3.2708422851562500e+02 2.1284759521484375e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(-4.2555404663085938e+01 -3.2706671142578125e+02 2.1332569885253906e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(-9.1366004943847656e+00 -3.2699130249023438e+02 2.1430249023437500e+02)(-4.2555404663085938e+01 -3.2706671142578125e+02 2.1332569885253906e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(-9.1366004943847656e+00 -3.2699130249023438e+02 2.1430249023437500e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(6.8765602111816406e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(7.2230705261230469e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(7.0861503601074219e+01 -3.2713638305664062e+02 2.0957080078125000e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(7.2230705261230469e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(2.3239700317382812e+02 -3.2586651611328125e+02 2.0497380065917969e+02)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(2.3932618713378906e+02 -3.2802960205078125e+02 9.5508102416992188e+01)(2.1941439819335938e+02 -3.2823980712890625e+02 1.4635340881347656e+02)(2.0085839843750000e+02 -3.2906631469726562e+02 9.9012397766113281e+01)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(7.2053703308105469e+01 -3.2713732910156250e+02 2.0952041625976562e+02)(7.2230705261230469e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(7.2230705261230469e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(7.2053703308105469e+01 -3.2713732910156250e+02 2.0952041625976562e+02)(7.0861503601074219e+01 -3.2713638305664062e+02 2.0957080078125000e+02)(-4.2555404663085938e+01 -3.2706671142578125e+02 2.1332569885253906e+02)(-6.9020706176757812e+01 -3.2690301513671875e+02 2.1566651916503906e+02)(-1.1189570617675781e+02 -3.2708422851562500e+02 2.1284759521484375e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(-1.1189570617675781e+02 -3.2708422851562500e+02 2.1284759521484375e+02)(-1.7616009521484375e+02 -3.2709820556640625e+02 2.1171620178222656e+02)(6.7366706848144531e+01 -3.2713397216796875e+02 2.0971630859375000e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(6.8765602111816406e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(6.7366706848144531e+01 -3.2713397216796875e+02 2.0971630859375000e+02)(5.5040596008300781e+01 -3.2728091430664062e+02 2.0129339599609375e+02)(7.2230705261230469e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(6.8765602111816406e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(7.0861503601074219e+01 -3.2713638305664062e+02 2.0957080078125000e+02)(6.7366706848144531e+01 -3.2713397216796875e+02 2.0971630859375000e+02)(6.8765602111816406e+01 -3.2713873291015625e+02 2.0944090270996094e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-3.1965682983398438e+02 -2.6117581176757812e+02 1.9195700073242188e+02)(-3.2832461547851562e+02 -2.3432460021972656e+02 1.4680950927734375e+02)(-3.2832461547851562e+02 -2.3432460021972656e+02 1.4680950927734375e+02)(-3.1965682983398438e+02 -2.6117581176757812e+02 1.9195700073242188e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-3.0475650024414062e+02 -2.8972198486328125e+02 1.4465420532226562e+02)(-3.0651879882812500e+02 -2.8348971557617188e+02 1.9757209777832031e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.6593640136718750e+02 -3.1660049438476562e+02 2.0808671569824219e+02)(-2.8053140258789062e+02 -3.1139001464843750e+02 1.4237069702148438e+02)(-2.8053140258789062e+02 -3.1139001464843750e+02 1.4237069702148438e+02)(-2.9085711669921875e+02 -3.0013900756835938e+02 2.0292480468750000e+02)(-3.0475650024414062e+02 -2.8972198486328125e+02 1.4465420532226562e+02)(-2.8053140258789062e+02 -3.1139001464843750e+02 1.4237069702148438e+02)(-2.6593640136718750e+02 -3.1660049438476562e+02 2.0808671569824219e+02)(-2.9085711669921875e+02 -3.0013900756835938e+02 2.0292480468750000e+02)(-3.0475650024414062e+02 -2.8972198486328125e+02 1.4465420532226562e+02)(-2.9085711669921875e+02 -3.0013900756835938e+02 2.0292480468750000e+02)(-3.0651879882812500e+02 -2.8348971557617188e+02 1.9757209777832031e+02)(-3.0651879882812500e+02 -2.8348971557617188e+02 1.9757209777832031e+02)(-3.1965682983398438e+02 -2.6117581176757812e+02 1.9195700073242188e+02)(-3.2123873901367188e+02 -2.6225372314453125e+02 1.4617700195312500e+02)(-2.6593640136718750e+02 -3.1660049438476562e+02 2.0808671569824219e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-2.4555230712890625e+02 -3.2663409423828125e+02 1.3908009338378906e+02)(-2.2170999145507812e+02 -3.2744290161132812e+02 1.9200559997558594e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-3.3301791381835938e+02 2.3431101989746094e+02 1.4681500244140625e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-3.2779809570312500e+02 2.5799807739257812e+02 1.4635411071777344e+02)(-3.1331671142578125e+02 2.7737429809570312e+02 1.4543829345703125e+02)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-3.1331671142578125e+02 2.7737429809570312e+02 1.4543829345703125e+02)(-2.9361590576171875e+02 3.0790051269531250e+02 1.4328730773925781e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-2.3978089904785156e+02 3.3222409057617188e+02 1.3846380615234375e+02)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.3978089904785156e+02 3.3222409057617188e+02 1.3846380615234375e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.2697041320800781e+02 3.3336151123046875e+02 1.3732460021972656e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.2846400451660156e+02 3.2837481689453125e+02 1.3746459960937500e+02)(-2.2697041320800781e+02 3.3336151123046875e+02 1.3732460021972656e+02)(-2.7051611328125000e+02 3.1705651855468750e+02 1.4141200256347656e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-3.3301791381835938e+02 2.3431101989746094e+02 1.4681500244140625e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-2.6799160766601562e+02 3.2413922119140625e+02 1.4099200439453125e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-2.7051611328125000e+02 3.1705651855468750e+02 1.4141200256347656e+02)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-2.9361590576171875e+02 3.0790051269531250e+02 1.4328730773925781e+02)(-3.2779809570312500e+02 2.5799807739257812e+02 1.4635411071777344e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-3.1370639038085938e+02 2.8636669921875000e+02 1.4508250427246094e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.2880389404296875e+02 -1.5834950256347656e+02 1.4735920715332031e+02)(-3.2832461547851562e+02 -2.3432460021972656e+02 1.4680950927734375e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.2872268676757812e+02 -1.2441740417480469e+02 1.7931520080566406e+02)(-3.2880389404296875e+02 -1.5834950256347656e+02 1.4735920715332031e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.2872268676757812e+02 -1.2441740417480469e+02 1.7931520080566406e+02)(-3.2756658935546875e+02 1.2531520080566406e+02 1.8381430053710938e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2866641235351562e+02 1.4169609069824219e+02 1.5581219482421875e+02)(-3.2724078369140625e+02 1.5401570129394531e+02 1.9027749633789062e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2756658935546875e+02 1.2531520080566406e+02 1.8381430053710938e+02)(-3.2724078369140625e+02 1.5401570129394531e+02 1.9027749633789062e+02)(-3.2756658935546875e+02 1.2531520080566406e+02 1.8381430053710938e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2760021972656250e+02 -2.7569299697875977e+01 1.8900709533691406e+02)(-3.2820089721679688e+02 -5.1091701507568359e+01 1.8707220458984375e+02)(-3.2881723022460938e+02 1.5969020080566406e+02 1.4697540283203125e+02)(-3.2866641235351562e+02 1.4169609069824219e+02 1.5581219482421875e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2820089721679688e+02 -5.1091701507568359e+01 1.8707220458984375e+02)(-3.2880389404296875e+02 -1.5834950256347656e+02 1.4735920715332031e+02)(-3.2872268676757812e+02 -1.2441740417480469e+02 1.7931520080566406e+02)(-3.2875030517578125e+02 -1.4176580810546875e+02 1.5545831298828125e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2724078369140625e+02 1.5401570129394531e+02 1.9027749633789062e+02)(-3.2741320800781250e+02 1.8479171752929688e+02 1.8718878173828125e+02)(-3.2741320800781250e+02 1.8479171752929688e+02 1.8718878173828125e+02)(-3.2749368286132812e+02 2.2315060424804688e+02 1.8486270141601562e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2866641235351562e+02 1.4169609069824219e+02 1.5581219482421875e+02)(-3.2936868286132812e+02 1.2512789916992188e+02 1.7853860473632812e+02)(-3.2756658935546875e+02 1.2531520080566406e+02 1.8381430053710938e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.2756658935546875e+02 1.2531520080566406e+02 1.8381430053710938e+02)(-3.2936868286132812e+02 1.2512789916992188e+02 1.7853860473632812e+02)(-3.2851681518554688e+02 -4.4033002853393555e+00 1.8685450744628906e+02)(-3.2746530151367188e+02 1.9822200775146484e+01 1.8910960388183594e+02)(-3.2851879882812500e+02 6.1788200378417969e+01 1.8685330200195312e+02)(-3.2820089721679688e+02 -5.1091701507568359e+01 1.8707220458984375e+02)(-3.2760021972656250e+02 -2.7569299697875977e+01 1.8900709533691406e+02)(-3.2851681518554688e+02 -4.4033002853393555e+00 1.8685450744628906e+02)(-3.2760021972656250e+02 -2.7569299697875977e+01 1.8900709533691406e+02)(-3.2746530151367188e+02 1.9822200775146484e+01 1.8910960388183594e+02)(-3.2851681518554688e+02 -4.4033002853393555e+00 1.8685450744628906e+02)(3.2740530395507812e+02 2.4039630126953125e+02 8.7170707702636719e+01)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.2861883544921875e+02 2.2239151000976562e+02 8.7643493652343750e+01)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(2.8560290527343750e+02 3.0813241577148438e+02 9.1175903320312500e+01)(2.8920190429687500e+02 2.9747738647460938e+02 2.0352909851074219e+02)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(3.1447131347656250e+02 2.6122601318359375e+02 2.0384469604492188e+02)(3.2064602661132812e+02 2.6342208862304688e+02 8.7899795532226562e+01)(3.2740530395507812e+02 2.4039630126953125e+02 8.7170707702636719e+01)(3.2064602661132812e+02 2.6342208862304688e+02 8.7899795532226562e+01)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.1447131347656250e+02 2.6122601318359375e+02 2.0384469604492188e+02)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(3.0161581420898438e+02 2.8380560302734375e+02 2.0334188842773438e+02)(2.6558251953125000e+02 3.1989309692382812e+02 9.3066200256347656e+01)(2.7029971313476562e+02 3.1249310302734375e+02 2.0255000305175781e+02)(2.8560290527343750e+02 3.0813241577148438e+02 9.1175903320312500e+01)(2.3917280578613281e+02 3.2810919189453125e+02 9.5524398803710938e+01)(2.4675010681152344e+02 3.2253088378906250e+02 2.0347200012207031e+02)(2.6558251953125000e+02 3.1989309692382812e+02 9.3066200256347656e+01)(3.2064602661132812e+02 2.6342208862304688e+02 8.7899795532226562e+01)(3.1447131347656250e+02 2.6122601318359375e+02 2.0384469604492188e+02)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.0614550781250000e+02 2.8867910766601562e+02 8.9240501403808594e+01)(2.8920190429687500e+02 2.9747738647460938e+02 2.0352909851074219e+02)(3.0161581420898438e+02 2.8380560302734375e+02 2.0334188842773438e+02)(2.8560290527343750e+02 3.0813241577148438e+02 9.1175903320312500e+01)(2.7029971313476562e+02 3.1249310302734375e+02 2.0255000305175781e+02)(2.8920190429687500e+02 2.9747738647460938e+02 2.0352909851074219e+02)(2.2307360839843750e+02 3.2685241699218750e+02 2.0513059997558594e+02)(2.4675010681152344e+02 3.2253088378906250e+02 2.0347200012207031e+02)(2.3917280578613281e+02 3.2810919189453125e+02 9.5524398803710938e+01)(2.7029971313476562e+02 3.1249310302734375e+02 2.0255000305175781e+02)(2.6558251953125000e+02 3.1989309692382812e+02 9.3066200256347656e+01)(2.4675010681152344e+02 3.2253088378906250e+02 2.0347200012207031e+02)(3.2519812011718750e+02 -1.4426939392089844e+02 1.6764410400390625e+02)(3.2521972656250000e+02 -1.6357580566406250e+02 1.5534880065917969e+02)(3.2678439331054688e+02 -1.5887330627441406e+02 1.5785751342773438e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2519812011718750e+02 -1.4426939392089844e+02 1.6764410400390625e+02)(3.2628161621093750e+02 -1.3295109558105469e+02 1.6949569702148438e+02)(3.2453042602539062e+02 2.4608699798583984e+01 1.7106109619140625e+02)(3.2445431518554688e+02 -2.7274501800537109e+01 1.7129049682617188e+02)(3.2644128417968750e+02 -1.6672700881958008e+01 1.6950199890136719e+02)(3.2633560180664062e+02 -6.9561103820800781e+01 1.6952090454101562e+02)(3.2445431518554688e+02 -2.7274501800537109e+01 1.7129049682617188e+02)(3.2445108032226562e+02 -1.1847410583496094e+02 1.7140031433105469e+02)(3.2452059936523438e+02 1.3579580688476562e+02 1.7096101379394531e+02)(3.2684503173828125e+02 1.5598458862304688e+02 1.6139340209960938e+02)(3.2495730590820312e+02 1.5911430358886719e+02 1.6115341186523438e+02)(3.2199200439453125e+02 -8.0251098632812500e+01 2.1042601013183594e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.2199200439453125e+02 -8.0251098632812500e+01 2.1042601013183594e+02)(3.1488082885742188e+02 -1.0623159027099609e+02 2.1626119995117188e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(3.2199200439453125e+02 -8.0251098632812500e+01 2.1042601013183594e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(3.1488082885742188e+02 -1.0623159027099609e+02 2.1626119995117188e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.1488082885742188e+02 -1.0623159027099609e+02 2.1626119995117188e+02)(3.2175451660156250e+02 2.3548789978027344e+02 2.0370260620117188e+02)(3.1875012207031250e+02 2.1195059204101562e+02 2.1065159606933594e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.1875012207031250e+02 2.1195059204101562e+02 2.1065159606933594e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(3.2234451293945312e+02 8.5601203918457031e+01 2.0827589416503906e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(3.2199200439453125e+02 -8.0251098632812500e+01 2.1042601013183594e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(3.1875012207031250e+02 2.1195059204101562e+02 2.1065159606933594e+02)(3.1945962524414062e+02 -2.4776422119140625e+02 2.0187261962890625e+02)(3.1378131103515625e+02 -2.5191200256347656e+02 2.0938130187988281e+02)(3.1106390380859375e+02 -2.6823260498046875e+02 2.0371539306640625e+02)(3.1106390380859375e+02 -2.6823260498046875e+02 2.0371539306640625e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(2.9685311889648438e+02 -2.9019723510742188e+02 2.0282299804687500e+02)(3.1378131103515625e+02 -2.5191200256347656e+02 2.0938130187988281e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(3.1106390380859375e+02 -2.6823260498046875e+02 2.0371539306640625e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(3.1378131103515625e+02 -2.5191200256347656e+02 2.0938130187988281e+02)(3.1945962524414062e+02 -2.4776422119140625e+02 2.0187261962890625e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(3.1378131103515625e+02 -2.5191200256347656e+02 2.0938130187988281e+02)(3.2252859497070312e+02 -2.2448121643066406e+02 2.0453309631347656e+02)(2.6038513183593750e+02 -3.1690469360351562e+02 2.0475199890136719e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(2.3239700317382812e+02 -3.2586651611328125e+02 2.0497380065917969e+02)(2.7943020629882812e+02 -3.0593048095703125e+02 2.0310668945312500e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(2.6038513183593750e+02 -3.1690469360351562e+02 2.0475199890136719e+02)(2.9685311889648438e+02 -2.9019723510742188e+02 2.0282299804687500e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(2.7943020629882812e+02 -3.0593048095703125e+02 2.0310668945312500e+02)(2.6038513183593750e+02 -3.1690469360351562e+02 2.0475199890136719e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(-2.0237501525878906e+02 -3.2555831909179688e+02 2.1667819213867188e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-1.7616009521484375e+02 -3.2709820556640625e+02 2.1171620178222656e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(-1.7932771301269531e+02 -3.2473132324218750e+02 2.1893060302734375e+02)(-2.0237501525878906e+02 -3.2555831909179688e+02 2.1667819213867188e+02)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(7.2053703308105469e+01 -3.2713732910156250e+02 2.0952041625976562e+02)(-1.1189570617675781e+02 -3.2708422851562500e+02 2.1284759521484375e+02)(-1.5150909423828125e+02 -3.2680599975585938e+02 2.1496119689941406e+02)(-1.7616009521484375e+02 -3.2709820556640625e+02 2.1171620178222656e+02)(-1.5150909423828125e+02 -3.2680599975585938e+02 2.1496119689941406e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(-1.5150909423828125e+02 -3.2680599975585938e+02 2.1496119689941406e+02)(-6.9020706176757812e+01 -3.2690301513671875e+02 2.1566651916503906e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(-9.1366004943847656e+00 -3.2699130249023438e+02 2.1430249023437500e+02)(-6.9020706176757812e+01 -3.2690301513671875e+02 2.1566651916503906e+02)(-4.2555404663085938e+01 -3.2706671142578125e+02 2.1332569885253906e+02)(-9.1366004943847656e+00 -3.2699130249023438e+02 2.1430249023437500e+02)(-8.8503999710083008e+00 -3.2523031616210938e+02 2.1904960632324219e+02)(-6.9020706176757812e+01 -3.2690301513671875e+02 2.1566651916503906e+02)(-8.8503999710083008e+00 -3.2523031616210938e+02 2.1904960632324219e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(-6.9020706176757812e+01 -3.2690301513671875e+02 2.1566651916503906e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(-8.8503999710083008e+00 -3.2523031616210938e+02 2.1904960632324219e+02)(-9.1366004943847656e+00 -3.2699130249023438e+02 2.1430249023437500e+02)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(1.3582800292968750e+02 -3.2717129516601562e+02 2.0749421691894531e+02)(2.3239700317382812e+02 -3.2586651611328125e+02 2.0497380065917969e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(-1.7616009521484375e+02 -3.2709820556640625e+02 2.1171620178222656e+02)(-1.5150909423828125e+02 -3.2680599975585938e+02 2.1496119689941406e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(-1.1189570617675781e+02 -3.2708422851562500e+02 2.1284759521484375e+02)(-6.9020706176757812e+01 -3.2690301513671875e+02 2.1566651916503906e+02)(-1.5150909423828125e+02 -3.2680599975585938e+02 2.1496119689941406e+02)(7.2053703308105469e+01 -3.2713732910156250e+02 2.0952041625976562e+02)(6.7366706848144531e+01 -3.2713397216796875e+02 2.0971630859375000e+02)(7.0861503601074219e+01 -3.2713638305664062e+02 2.0957080078125000e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(6.7366706848144531e+01 -3.2713397216796875e+02 2.0971630859375000e+02)(7.2053703308105469e+01 -3.2713732910156250e+02 2.0952041625976562e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-2.2261718750000000e+02 3.2789633178710938e+02 1.6602929687500000e+02)(-2.2846400451660156e+02 3.2837481689453125e+02 1.3746459960937500e+02)(-2.7051611328125000e+02 3.1705651855468750e+02 1.4141200256347656e+02)(-2.4861851501464844e+02 3.2278799438476562e+02 2.1046530151367188e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-2.2846400451660156e+02 3.2837481689453125e+02 1.3746459960937500e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.7051611328125000e+02 3.1705651855468750e+02 1.4141200256347656e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-2.9955657958984375e+02 2.9183081054687500e+02 2.0019030761718750e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-3.1331671142578125e+02 2.7737429809570312e+02 1.4543829345703125e+02)(-2.9955657958984375e+02 2.9183081054687500e+02 2.0019030761718750e+02)(-2.9489089965820312e+02 3.0032690429687500e+02 1.4371800231933594e+02)(-3.1331671142578125e+02 2.7737429809570312e+02 1.4543829345703125e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-3.1386312866210938e+02 2.7184591674804688e+02 1.9502798461914062e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2482290649414062e+02 2.4593699645996094e+02 1.8818659973144531e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-3.2749368286132812e+02 2.2315060424804688e+02 1.8486270141601562e+02)(-3.2482290649414062e+02 2.4593699645996094e+02 1.8818659973144531e+02)(-3.2881008911132812e+02 2.2753028869628906e+02 1.4685598754882812e+02)(-3.2446722412109375e+02 2.5293180847167969e+02 1.4646940612792969e+02)(-3.2482290649414062e+02 2.4593699645996094e+02 1.8818659973144531e+02)(-3.1386312866210938e+02 2.7184591674804688e+02 1.9502798461914062e+02)(-2.4774209594726562e+02 3.2546279907226562e+02 1.3928300476074219e+02)(-2.4861851501464844e+02 3.2278799438476562e+02 2.1046530151367188e+02)(-2.3092730712890625e+02 3.2662890625000000e+02 2.1151649475097656e+02)(-2.7051611328125000e+02 3.1705651855468750e+02 1.4141200256347656e+02)(-2.7596267700195312e+02 3.1145101928710938e+02 2.0609970092773438e+02)(-2.4861851501464844e+02 3.2278799438476562e+02 2.1046530151367188e+02)(-3.1331671142578125e+02 2.7737429809570312e+02 1.4543829345703125e+02)(-3.1386312866210938e+02 2.7184591674804688e+02 1.9502798461914062e+02)(-2.9955657958984375e+02 2.9183081054687500e+02 2.0019030761718750e+02)(-3.2746530151367188e+02 1.9822200775146484e+01 1.8910960388183594e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2851879882812500e+02 6.1788200378417969e+01 1.8685330200195312e+02)(-3.2851879882812500e+02 6.1788200378417969e+01 1.8685330200195312e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.2724078369140625e+02 1.5401570129394531e+02 1.9027749633789062e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-3.2741320800781250e+02 1.8479171752929688e+02 1.8718878173828125e+02)(-3.2741320800781250e+02 1.8479171752929688e+02 1.8718878173828125e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-3.2749368286132812e+02 2.2315060424804688e+02 1.8486270141601562e+02)(-3.2746530151367188e+02 1.9822200775146484e+01 1.8910960388183594e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2814559936523438e+02 1.0685399627685547e+02 1.8693750000000000e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2724078369140625e+02 1.5401570129394531e+02 1.9027749633789062e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.2760021972656250e+02 -2.7569299697875977e+01 1.8900709533691406e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2746530151367188e+02 1.9822200775146484e+01 1.8910960388183594e+02)(2.5544079589843750e+02 -2.6166702270507812e+02 2.2152439880371094e+02)(2.6352502441406250e+02 -1.3535369873046875e+02 2.2748069763183594e+02)(2.2196319580078125e+02 -2.5503752136230469e+02 2.2738389587402344e+02)(2.5544079589843750e+02 -2.6166702270507812e+02 2.2152439880371094e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(2.6352502441406250e+02 -1.3535369873046875e+02 2.2748069763183594e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(3.1488082885742188e+02 -1.0623159027099609e+02 2.1626119995117188e+02)(2.9760189819335938e+02 -4.2628700256347656e+01 2.2169010925292969e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(3.0507888793945312e+02 -1.3638999938964844e+02 2.1868379211425781e+02)(2.6352502441406250e+02 -1.3535369873046875e+02 2.2748069763183594e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(3.1488082885742188e+02 -1.0623159027099609e+02 2.1626119995117188e+02)(3.0507888793945312e+02 -1.3638999938964844e+02 2.1868379211425781e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(2.9760189819335938e+02 -4.2628700256347656e+01 2.2169010925292969e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(3.0680761718750000e+02 3.0199001312255859e+01 2.1922468566894531e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.1838403320312500e+02 4.9684299468994141e+01 2.1528959655761719e+02)(6.9552398681640625e+01 -3.0918200683593750e+02 2.2882481384277344e+02)(2.1387100219726562e+02 -2.9993801879882812e+02 2.2031620788574219e+02)(2.2196319580078125e+02 -2.5503752136230469e+02 2.2738389587402344e+02)(2.5544079589843750e+02 -2.6166702270507812e+02 2.2152439880371094e+02)(2.2196319580078125e+02 -2.5503752136230469e+02 2.2738389587402344e+02)(2.1387100219726562e+02 -2.9993801879882812e+02 2.2031620788574219e+02)(6.9552398681640625e+01 -3.0918200683593750e+02 2.2882481384277344e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(2.1387100219726562e+02 -2.9993801879882812e+02 2.2031620788574219e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(2.5544079589843750e+02 -2.6166702270507812e+02 2.2152439880371094e+02)(3.1641433715820312e+02 -2.2644979858398438e+02 2.1191839599609375e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(3.1378131103515625e+02 -2.5191200256347656e+02 2.0938130187988281e+02)(2.5544079589843750e+02 -2.6166702270507812e+02 2.2152439880371094e+02)(2.1387100219726562e+02 -2.9993801879882812e+02 2.2031620788574219e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(2.8745349121093750e+02 -2.9413299560546875e+02 2.0908908081054688e+02)(2.1387100219726562e+02 -2.9993801879882812e+02 2.2031620788574219e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(-2.0237501525878906e+02 -3.2555831909179688e+02 2.1667819213867188e+02)(-2.2204629516601562e+02 -3.2106842041015625e+02 2.2179721069335938e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-2.0237501525878906e+02 -3.2555831909179688e+02 2.1667819213867188e+02)(-1.8054609680175781e+02 -3.2292050170898438e+02 2.2131828308105469e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-1.7932771301269531e+02 -3.2473132324218750e+02 2.1893060302734375e+02)(-1.8054609680175781e+02 -3.2292050170898438e+02 2.2131828308105469e+02)(-2.0237501525878906e+02 -3.2555831909179688e+02 2.1667819213867188e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-2.2204629516601562e+02 -3.2106842041015625e+02 2.2179721069335938e+02)(-2.0237501525878906e+02 -3.2555831909179688e+02 2.1667819213867188e+02)(-8.8503999710083008e+00 -3.2523031616210938e+02 2.1904960632324219e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(-8.8503999710083008e+00 -3.2523031616210938e+02 2.1904960632324219e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-1.8002938842773438e+02 -3.2363980102539062e+02 2.2021101379394531e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(6.9552398681640625e+01 -3.0918200683593750e+02 2.2882481384277344e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(2.2658561706542969e+02 -3.2358798217773438e+02 2.1032901000976562e+02)(-1.3496791076660156e+02 -3.2525738525390625e+02 2.1934989929199219e+02)(-1.8002938842773438e+02 -3.2363980102539062e+02 2.2021101379394531e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(6.9552398681640625e+01 -3.0918200683593750e+02 2.2882481384277344e+02)(-7.2508506774902344e+01 -3.1709658813476562e+02 2.2815699768066406e+02)(5.1523696899414062e+01 -3.2613000488281250e+02 2.1640661621093750e+02)(-2.9085711669921875e+02 -3.0013900756835938e+02 2.0292480468750000e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-3.0651879882812500e+02 -2.8348971557617188e+02 1.9757209777832031e+02)(-2.6557870483398438e+02 -2.9969332885742188e+02 2.2457940673828125e+02)(-2.9085711669921875e+02 -3.0013900756835938e+02 2.0292480468750000e+02)(-2.6593640136718750e+02 -3.1660049438476562e+02 2.0808671569824219e+02)(-3.0651879882812500e+02 -2.8348971557617188e+02 1.9757209777832031e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-3.1965682983398438e+02 -2.6117581176757812e+02 1.9195700073242188e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-2.6593640136718750e+02 -3.1660049438476562e+02 2.0808671569824219e+02)(-2.6593640136718750e+02 -3.1660049438476562e+02 2.0808671569824219e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-2.6557870483398438e+02 -2.9969332885742188e+02 2.2457940673828125e+02)(-2.3522238159179688e+02 -3.2596951293945312e+02 2.1154521179199219e+02)(-2.2204629516601562e+02 -3.2106842041015625e+02 2.2179721069335938e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-2.6557870483398438e+02 -2.9969332885742188e+02 2.2457940673828125e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-2.9085711669921875e+02 -3.0013900756835938e+02 2.0292480468750000e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-3.1016549682617188e+02 -2.3015089416503906e+02 2.2075520324707031e+02)(-3.1965682983398438e+02 -2.6117581176757812e+02 1.9195700073242188e+02)(-3.1965682983398438e+02 -2.6117581176757812e+02 1.9195700073242188e+02)(-3.1016549682617188e+02 -2.3015089416503906e+02 2.2075520324707031e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.2749368286132812e+02 2.2315060424804688e+02 1.8486270141601562e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-3.2482290649414062e+02 2.4593699645996094e+02 1.8818659973144531e+02)(-3.2724078369140625e+02 1.5401570129394531e+02 1.9027749633789062e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-3.1537948608398438e+02 1.7843060302734375e+02 2.2000360107421875e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.1537948608398438e+02 1.7843060302734375e+02 2.2000360107421875e+02)(-3.1003121948242188e+02 2.3203681945800781e+02 2.2080819702148438e+02)(-3.2710650634765625e+02 2.2128439331054688e+02 1.8785128784179688e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.1016549682617188e+02 -2.3015089416503906e+02 2.2075520324707031e+02)(-3.1407638549804688e+02 -1.7473860168457031e+02 2.2188189697265625e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.2819531250000000e+02 -1.0958290100097656e+02 1.8666661071777344e+02)(-3.1407638549804688e+02 -1.7473860168457031e+02 2.2188189697265625e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.2693161010742188e+02 -2.3180671691894531e+02 1.8750929260253906e+02)(3.0680761718750000e+02 3.0199001312255859e+01 2.1922468566894531e+02)(3.0492138671875000e+02 1.0516300201416016e+01 2.2076010131835938e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.0492138671875000e+02 1.0516300201416016e+01 2.2076010131835938e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(3.0332830810546875e+02 -3.3155097961425781e+01 2.2265670776367188e+02)(3.0492138671875000e+02 1.0516300201416016e+01 2.2076010131835938e+02)(3.0332830810546875e+02 -3.3155097961425781e+01 2.2265670776367188e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.1488082885742188e+02 -1.0623159027099609e+02 2.1626119995117188e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(3.0507888793945312e+02 -1.3638999938964844e+02 2.1868379211425781e+02)(2.9415930175781250e+02 -4.1012100219726562e+01 2.2549040222167969e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(2.9760189819335938e+02 -4.2628700256347656e+01 2.2169010925292969e+02)(2.9415930175781250e+02 -4.1012100219726562e+01 2.2549040222167969e+02)(2.6123593139648438e+02 -4.4348899841308594e+01 2.2813301086425781e+02)(3.0332830810546875e+02 -3.3155097961425781e+01 2.2265670776367188e+02)(2.9760189819335938e+02 -4.2628700256347656e+01 2.2169010925292969e+02)(3.0612222290039062e+02 -2.9491699218750000e+01 2.1955358886718750e+02)(3.0332830810546875e+02 -3.3155097961425781e+01 2.2265670776367188e+02)(2.9415930175781250e+02 -4.1012100219726562e+01 2.2549040222167969e+02)(2.9760189819335938e+02 -4.2628700256347656e+01 2.2169010925292969e+02)(3.0492138671875000e+02 1.0516300201416016e+01 2.2076010131835938e+02)(3.0680761718750000e+02 3.0199001312255859e+01 2.1922468566894531e+02)(3.0460058593750000e+02 2.9287099838256836e+01 2.2110108947753906e+02)(3.0460058593750000e+02 2.9287099838256836e+01 2.2110108947753906e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(3.0492138671875000e+02 1.0516300201416016e+01 2.2076010131835938e+02)(3.0680761718750000e+02 3.0199001312255859e+01 2.1922468566894531e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(3.0460058593750000e+02 2.9287099838256836e+01 2.2110108947753906e+02)(3.0460058593750000e+02 2.9287099838256836e+01 2.2110108947753906e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(2.9919158935546875e+02 3.8502799987792969e+01 2.2404229736328125e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(2.8874819946289062e+02 4.1856201171875000e+01 2.2558660888671875e+02)(2.9919158935546875e+02 3.8502799987792969e+01 2.2404229736328125e+02)(2.8874819946289062e+02 4.1856201171875000e+01 2.2558660888671875e+02)(2.9748413085937500e+02 4.2789798736572266e+01 2.2161309814453125e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(-1.7932771301269531e+02 -3.2473132324218750e+02 2.1893060302734375e+02)(-1.7785830688476562e+02 -3.2652670288085938e+02 2.1583590698242188e+02)(-1.8002938842773438e+02 -3.2363980102539062e+02 2.2021101379394531e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-2.3391090393066406e+02 -3.1607028198242188e+02 2.2503559875488281e+02)(-2.2204629516601562e+02 -3.2106842041015625e+02 2.2179721069335938e+02)(-1.8054609680175781e+02 -3.2292050170898438e+02 2.2131828308105469e+02)(-1.8002938842773438e+02 -3.2363980102539062e+02 2.2021101379394531e+02)(-1.8126658630371094e+02 -3.2193652343750000e+02 2.2245469665527344e+02)(-1.7932771301269531e+02 -3.2473132324218750e+02 2.1893060302734375e+02)(-1.8002938842773438e+02 -3.2363980102539062e+02 2.2021101379394531e+02)(-1.8054609680175781e+02 -3.2292050170898438e+02 2.2131828308105469e+02)(-3.0493301391601562e+02 -2.2846310424804688e+02 2.2458110046386719e+02)(-3.1016549682617188e+02 -2.3015089416503906e+02 2.2075520324707031e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-3.0493301391601562e+02 -2.2846310424804688e+02 2.2458110046386719e+02)(-2.9611279296875000e+02 -2.6439999389648438e+02 2.2390599060058594e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-3.1537948608398438e+02 1.7843060302734375e+02 2.2000360107421875e+02)(-3.1627551269531250e+02 1.6320208740234375e+02 2.1155778503417969e+02)(-3.1537948608398438e+02 1.7843060302734375e+02 2.2000360107421875e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.1627551269531250e+02 1.6320208740234375e+02 2.1155778503417969e+02)(-3.1537948608398438e+02 1.7843060302734375e+02 2.2000360107421875e+02)(-3.1627551269531250e+02 1.6320208740234375e+02 2.1155778503417969e+02)(-3.0509829711914062e+02 1.6375740051269531e+02 2.1538340759277344e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.2194909667968750e+02 2.4537300109863281e+01 2.0501600646972656e+02)(-3.1455709838867188e+02 1.9115900039672852e+01 2.0818190002441406e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2194909667968750e+02 2.4537300109863281e+01 2.0501600646972656e+02)(-3.2386169433593750e+02 1.5032771301269531e+02 2.0152890014648438e+02)(-3.2194909667968750e+02 2.4537300109863281e+01 2.0501600646972656e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.2194909667968750e+02 2.4537300109863281e+01 2.0501600646972656e+02)(-3.2593878173828125e+02 -3.3571403503417969e+01 1.9855021667480469e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.2194909667968750e+02 2.4537300109863281e+01 2.0501600646972656e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.1630700683593750e+02 -1.5177200317382812e+02 2.0741670227050781e+02)(-3.1061279296875000e+02 -1.2055299377441406e+02 2.0839579772949219e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.1061279296875000e+02 -1.2055299377441406e+02 2.0839579772949219e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.1630700683593750e+02 -1.5177200317382812e+02 2.0741670227050781e+02)(-3.2293722534179688e+02 -1.5748690795898438e+02 2.0346401977539062e+02)(-3.1407638549804688e+02 -1.7473860168457031e+02 2.2188189697265625e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.1407638549804688e+02 -1.7473860168457031e+02 2.2188189697265625e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-3.1407638549804688e+02 -1.7473860168457031e+02 2.2188189697265625e+02)(-3.0493301391601562e+02 -2.2846310424804688e+02 2.2458110046386719e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-3.1016549682617188e+02 -2.3015089416503906e+02 2.2075520324707031e+02)(-3.0493301391601562e+02 -2.2846310424804688e+02 2.2458110046386719e+02)(-3.1407638549804688e+02 -1.7473860168457031e+02 2.2188189697265625e+02)(3.0460058593750000e+02 2.9287099838256836e+01 2.2110108947753906e+02)(3.0303991699218750e+02 3.2920200347900391e+01 2.3100450134277344e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(3.0507888793945312e+02 -1.3638999938964844e+02 2.1868379211425781e+02)(2.9806121826171875e+02 -1.2864790344238281e+02 2.2609260559082031e+02)(2.6352502441406250e+02 -1.3535369873046875e+02 2.2748069763183594e+02)(2.9806121826171875e+02 -1.2864790344238281e+02 2.2609260559082031e+02)(3.0507888793945312e+02 -1.3638999938964844e+02 2.1868379211425781e+02)(2.9769631958007812e+02 -6.7902099609375000e+01 2.2685220336914062e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(2.9769631958007812e+02 -6.7902099609375000e+01 2.2685220336914062e+02)(3.0507888793945312e+02 -1.3638999938964844e+02 2.1868379211425781e+02)(2.9769631958007812e+02 -6.7902099609375000e+01 2.2685220336914062e+02)(3.0282321166992188e+02 -5.8106300354003906e+01 2.2034690856933594e+02)(2.6283041381835938e+02 -5.5588699340820312e+01 2.2765100097656250e+02)(2.9415930175781250e+02 -4.1012100219726562e+01 2.2549040222167969e+02)(3.0332830810546875e+02 -3.3155097961425781e+01 2.2265670776367188e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(2.9357150268554688e+02 -4.1024501800537109e+01 2.3081100463867188e+02)(2.9415930175781250e+02 -4.1012100219726562e+01 2.2549040222167969e+02)(3.0267849731445312e+02 -3.3678901672363281e+01 2.3088970947265625e+02)(3.0303991699218750e+02 3.2920200347900391e+01 2.3100450134277344e+02)(2.9919158935546875e+02 3.8502799987792969e+01 2.2404229736328125e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.9919158935546875e+02 3.8502799987792969e+01 2.2404229736328125e+02)(3.0303991699218750e+02 3.2920200347900391e+01 2.3100450134277344e+02)(3.0460058593750000e+02 2.9287099838256836e+01 2.2110108947753906e+02)(2.9919158935546875e+02 3.8502799987792969e+01 2.2404229736328125e+02)(2.8874819946289062e+02 4.1856201171875000e+01 2.2558660888671875e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.9382058715820312e+02 4.1014904022216797e+01 2.3100041198730469e+02)(2.8874819946289062e+02 4.1856201171875000e+01 2.2558660888671875e+02)(2.4777301025390625e+02 4.3880802154541016e+01 2.3022042846679688e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(2.9814712524414062e+02 1.2812881469726562e+02 2.2612480163574219e+02)(2.9717562866210938e+02 6.7286697387695312e+01 2.2681999206542969e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(2.9717562866210938e+02 6.7286697387695312e+01 2.2681999206542969e+02)(2.8766979980468750e+02 5.6536903381347656e+01 2.2371832275390625e+02)(2.9814712524414062e+02 1.2812881469726562e+02 2.2612480163574219e+02)(3.0510501098632812e+02 6.0503700256347656e+01 2.1967039489746094e+02)(3.0182479858398438e+02 1.3732719421386719e+02 2.1960531616210938e+02)(2.5811578369140625e+02 1.3580661010742188e+02 2.2769219970703125e+02)(2.9814712524414062e+02 1.2812881469726562e+02 2.2612480163574219e+02)(3.0182479858398438e+02 1.3732719421386719e+02 2.1960531616210938e+02)(-3.0509829711914062e+02 1.6375740051269531e+02 2.1538340759277344e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-3.0819461059570312e+02 1.7200090026855469e+02 2.2502091979980469e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.1627551269531250e+02 1.6320208740234375e+02 2.1155778503417969e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.0509829711914062e+02 1.6375740051269531e+02 2.1538340759277344e+02)(-3.1627551269531250e+02 1.6320208740234375e+02 2.1155778503417969e+02)(-3.1233938598632812e+02 -2.0917699813842773e+01 2.1261611938476562e+02)(-3.1180560302734375e+02 5.4337799072265625e+01 2.1334611511230469e+02)(-3.1247982788085938e+02 1.5646901130676270e+01 2.1102510070800781e+02)(-3.1455709838867188e+02 1.9115900039672852e+01 2.0818190002441406e+02)(-3.1247982788085938e+02 1.5646901130676270e+01 2.1102510070800781e+02)(-3.1203091430664062e+02 5.8979301452636719e+01 2.1025851440429688e+02)(-3.1203091430664062e+02 5.8979301452636719e+01 2.1025851440429688e+02)(-3.1236761474609375e+02 9.6297599792480469e+01 2.0831730651855469e+02)(-3.1455709838867188e+02 1.9115900039672852e+01 2.0818190002441406e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.1455709838867188e+02 1.9115900039672852e+01 2.0818190002441406e+02)(-3.1236761474609375e+02 9.6297599792480469e+01 2.0831730651855469e+02)(-3.1180560302734375e+02 5.4337799072265625e+01 2.1334611511230469e+02)(-3.0872070312500000e+02 1.1442890167236328e+02 2.1150540161132812e+02)(-3.1203091430664062e+02 5.8979301452636719e+01 2.1025851440429688e+02)(-3.0872070312500000e+02 1.1442890167236328e+02 2.1150540161132812e+02)(-3.1236761474609375e+02 9.6297599792480469e+01 2.0831730651855469e+02)(-3.1203091430664062e+02 5.8979301452636719e+01 2.1025851440429688e+02)(-3.1247982788085938e+02 1.5646901130676270e+01 2.1102510070800781e+02)(-3.1180560302734375e+02 5.4337799072265625e+01 2.1334611511230469e+02)(-3.1203091430664062e+02 5.8979301452636719e+01 2.1025851440429688e+02)(-3.1630700683593750e+02 -1.5177200317382812e+02 2.0741670227050781e+02)(-3.0471368408203125e+02 -1.5420411682128906e+02 2.0957839965820312e+02)(-3.1061279296875000e+02 -1.2055299377441406e+02 2.0839579772949219e+02)(-3.1455709838867188e+02 1.9115900039672852e+01 2.0818190002441406e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.1247982788085938e+02 1.5646901130676270e+01 2.1102510070800781e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.1455709838867188e+02 1.9115900039672852e+01 2.0818190002441406e+02)(-3.2194909667968750e+02 2.4537300109863281e+01 2.0501600646972656e+02)(-3.1247982788085938e+02 1.5646901130676270e+01 2.1102510070800781e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.1233938598632812e+02 -2.0917699813842773e+01 2.1261611938476562e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.1233938598632812e+02 -2.0917699813842773e+01 2.1261611938476562e+02)(-3.0140789794921875e+02 -1.7303390502929688e+02 2.2586230468750000e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-3.0822561645507812e+02 -1.7281111145019531e+02 2.2508950805664062e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.0471368408203125e+02 -1.5420411682128906e+02 2.0957839965820312e+02)(-3.1630700683593750e+02 -1.5177200317382812e+02 2.0741670227050781e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-3.0524288940429688e+02 -1.6322529602050781e+02 2.1486000061035156e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.1427310180664062e+02 -1.6215930175781250e+02 2.1166279602050781e+02)(-3.0524288940429688e+02 -1.6322529602050781e+02 2.1486000061035156e+02)(-3.0471368408203125e+02 -1.5420411682128906e+02 2.0957839965820312e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-2.8341870117187500e+02 -2.0654701232910156e+02 2.2732940673828125e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-3.0140789794921875e+02 -1.7303390502929688e+02 2.2586230468750000e+02)(-2.8341870117187500e+02 -2.0654701232910156e+02 2.2732940673828125e+02)(-2.6401629638671875e+02 -2.6082760620117188e+02 2.2667971801757812e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.8341870117187500e+02 -2.0654701232910156e+02 2.2732940673828125e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-3.0509829711914062e+02 1.6375740051269531e+02 2.1538340759277344e+02)(-3.0170251464843750e+02 1.6335310363769531e+02 2.2339399719238281e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.1236761474609375e+02 9.6297599792480469e+01 2.0831730651855469e+02)(-3.0872070312500000e+02 1.1442890167236328e+02 2.1150540161132812e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.1827819824218750e+02 1.5213981628417969e+02 2.0673881530761719e+02)(-3.1236761474609375e+02 9.6297599792480469e+01 2.0831730651855469e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.0872070312500000e+02 1.1442890167236328e+02 2.1150540161132812e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-3.0872070312500000e+02 1.1442890167236328e+02 2.1150540161132812e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.1772372436523438e+02 3.2468299865722656e+01 2.7400622558593750e+02)(-3.1180560302734375e+02 5.4337799072265625e+01 2.1334611511230469e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.0872070312500000e+02 1.1442890167236328e+02 2.1150540161132812e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.1180560302734375e+02 5.4337799072265625e+01 2.1334611511230469e+02)(-3.1772372436523438e+02 3.2468299865722656e+01 2.7400622558593750e+02)(-3.1233938598632812e+02 -2.0917699813842773e+01 2.1261611938476562e+02)(-3.1772372436523438e+02 3.2468299865722656e+01 2.7400622558593750e+02)(-3.1180560302734375e+02 5.4337799072265625e+01 2.1334611511230469e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-3.0170251464843750e+02 1.6335310363769531e+02 2.2339399719238281e+02)(-3.0350772094726562e+02 1.5475469970703125e+02 2.1061781311035156e+02)(-3.1061279296875000e+02 -1.2055299377441406e+02 2.0839579772949219e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.1270901489257812e+02 -4.9305702209472656e+01 2.0928810119628906e+02)(-3.1061279296875000e+02 -1.2055299377441406e+02 2.0839579772949219e+02)(-3.0471368408203125e+02 -1.5420411682128906e+02 2.0957839965820312e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.0471368408203125e+02 -1.5420411682128906e+02 2.0957839965820312e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.0471368408203125e+02 -1.5420411682128906e+02 2.0957839965820312e+02)(-3.0524288940429688e+02 -1.6322529602050781e+02 2.1486000061035156e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-2.0363569641113281e+02 -2.6391021728515625e+02 2.3527050781250000e+02)(-2.0276020812988281e+02 -2.6726800537109375e+02 2.3576710510253906e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-2.1546910095214844e+02 -2.4787750244140625e+02 2.4910250854492188e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.0276020812988281e+02 -2.6726800537109375e+02 2.3576710510253906e+02)(-2.4216818237304688e+02 -2.2349989318847656e+02 3.0658862304687500e+02)(-2.3953071594238281e+02 -2.2955619812011719e+02 2.9798672485351562e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.4216818237304688e+02 -2.2349989318847656e+02 3.0658862304687500e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-2.3953071594238281e+02 -2.2955619812011719e+02 2.9798672485351562e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.3953071594238281e+02 -2.2955619812011719e+02 2.9798672485351562e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.1546910095214844e+02 -2.4787750244140625e+02 2.4910250854492188e+02)(-2.0276020812988281e+02 -2.6726800537109375e+02 2.3576710510253906e+02)(-2.0363569641113281e+02 -2.6391021728515625e+02 2.3527050781250000e+02)(-2.2911701965332031e+02 -2.3447389221191406e+02 2.7092871093750000e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.1546910095214844e+02 -2.4787750244140625e+02 2.4910250854492188e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.5269299316406250e+02 -2.1032249450683594e+02 4.0986929321289062e+02)(-2.5269299316406250e+02 -2.1032249450683594e+02 4.0986929321289062e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.4942140197753906e+02 -1.9983990478515625e+02 3.3694860839843750e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.4097021484375000e+02 -2.1888510131835938e+02 3.0747140502929688e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.4942140197753906e+02 -1.9983990478515625e+02 3.3694860839843750e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.4942140197753906e+02 -1.9983990478515625e+02 3.3694860839843750e+02)(-2.5288900756835938e+02 -1.9620390319824219e+02 3.2767269897460938e+02)(-2.6132510375976562e+02 -1.9569230651855469e+02 4.1570541381835938e+02)(-2.5721429443359375e+02 -1.9676870727539062e+02 4.6841870117187500e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.6132510375976562e+02 -1.9569230651855469e+02 4.1570541381835938e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.5288900756835938e+02 -1.9620390319824219e+02 3.2767269897460938e+02)(-2.5721429443359375e+02 -1.9676870727539062e+02 4.6841870117187500e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.5513151550292969e+02 -1.9814979553222656e+02 4.0015832519531250e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.6149697875976562e+02 -1.9593290710449219e+02 5.7024890136718750e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.5500000000000000e+02 -1.5934260559082031e+02 5.7054760742187500e+02)(-2.5721429443359375e+02 -1.9676870727539062e+02 4.6841870117187500e+02)(-2.5823168945312500e+02 -1.9617970275878906e+02 5.1132797241210938e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-2.5823168945312500e+02 -1.9617970275878906e+02 5.1132797241210938e+02)(-2.5721429443359375e+02 -1.9676870727539062e+02 4.6841870117187500e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.5823168945312500e+02 -1.9617970275878906e+02 5.1132797241210938e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.5823168945312500e+02 -1.9617970275878906e+02 5.1132797241210938e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.5329130554199219e+02 -2.0433750915527344e+02 5.7056744384765625e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-2.5721429443359375e+02 -1.9676870727539062e+02 4.6841870117187500e+02)(-2.6132510375976562e+02 -1.9569230651855469e+02 4.1570541381835938e+02)(-2.6149697875976562e+02 -1.9593290710449219e+02 5.7024890136718750e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.6148568725585938e+02 -1.9573591613769531e+02 5.0909472656250000e+02)(-3.1909899902343750e+02 -1.9309640502929688e+02 6.5615765380859375e+02)(-3.0545648193359375e+02 -2.0641780090332031e+02 6.5615686035156250e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-3.0545648193359375e+02 -2.0641780090332031e+02 6.5615686035156250e+02)(-2.5500000000000000e+02 -2.0825691223144531e+02 6.5618072509765625e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-3.2934991455078125e+02 1.7470600891113281e+02 6.5616778564453125e+02)(-3.3431469726562500e+02 8.5528099060058594e+01 6.5616815185546875e+02)(-3.1781671142578125e+02 1.9390710449218750e+02 6.5617004394531250e+02)(-3.2934991455078125e+02 1.7470600891113281e+02 6.5616778564453125e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-3.0496319580078125e+02 2.0630851745605469e+02 6.5617242431640625e+02)(-3.1781671142578125e+02 1.9390710449218750e+02 6.5617004394531250e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-2.5500000000000000e+02 2.0825119018554688e+02 6.5618341064453125e+02)(-3.0496319580078125e+02 2.0630851745605469e+02 6.5617242431640625e+02)(-3.2984332275390625e+02 -1.7271240234375000e+02 6.5617297363281250e+02)(-3.1909899902343750e+02 -1.9309640502929688e+02 6.5615765380859375e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-3.3431469726562500e+02 8.5528099060058594e+01 6.5616815185546875e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-3.2984332275390625e+02 -1.7271240234375000e+02 6.5617297363281250e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-2.6150000000000000e+02 1.9600001525878906e+02 5.7025000000000000e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.5500000000000000e+02 1.5934260559082031e+02 5.7054760742187500e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.5548741149902344e+02 1.9827250671386719e+02 4.3452691650390625e+02)(-2.5636898803710938e+02 1.9681010437011719e+02 5.2687152099609375e+02)(-2.6128921508789062e+02 1.9582510375976562e+02 4.5703369140625000e+02)(-2.5548741149902344e+02 1.9827250671386719e+02 4.3452691650390625e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)(-2.5636898803710938e+02 1.9681010437011719e+02 5.2687152099609375e+02)(-2.5636898803710938e+02 1.9681010437011719e+02 5.2687152099609375e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.6150000000000000e+02 1.9600001525878906e+02 5.7025000000000000e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.5636898803710938e+02 1.9681010437011719e+02 5.2687152099609375e+02)(-2.6128921508789062e+02 1.9582510375976562e+02 4.5703369140625000e+02)(-2.5636898803710938e+02 1.9681010437011719e+02 5.2687152099609375e+02)(-2.6150000000000000e+02 1.9600001525878906e+02 5.7025000000000000e+02)(-2.6111538696289062e+02 1.9584129333496094e+02 3.9933718872070312e+02)(-2.5104179382324219e+02 2.0007710266113281e+02 3.4590228271484375e+02)(-2.5548741149902344e+02 1.9827250671386719e+02 4.3452691650390625e+02)(-2.6128921508789062e+02 1.9582510375976562e+02 4.5703369140625000e+02)(-2.6111538696289062e+02 1.9584129333496094e+02 3.9933718872070312e+02)(-2.5548741149902344e+02 1.9827250671386719e+02 4.3452691650390625e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.5104179382324219e+02 2.0007710266113281e+02 3.4590228271484375e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)(-2.5548741149902344e+02 1.9827250671386719e+02 4.3452691650390625e+02)(-2.5104179382324219e+02 2.0007710266113281e+02 3.4590228271484375e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.5548741149902344e+02 1.9827250671386719e+02 4.3452691650390625e+02)(-2.0441310119628906e+02 2.6262561035156250e+02 2.3608819580078125e+02)(-2.0922000122070312e+02 2.5864749145507812e+02 2.4209570312500000e+02)(-2.1811781311035156e+02 2.4438890075683594e+02 2.5263182067871094e+02)(-2.1811781311035156e+02 2.4438890075683594e+02 2.5263182067871094e+02)(-2.2512860107421875e+02 2.4139070129394531e+02 2.6529360961914062e+02)(-2.3005400085449219e+02 2.3336019897460938e+02 2.7334652709960938e+02)(-2.2512860107421875e+02 2.4139070129394531e+02 2.6529360961914062e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.3005400085449219e+02 2.3336019897460938e+02 2.7334652709960938e+02)(-2.3801260375976562e+02 2.2264300537109375e+02 2.9647320556640625e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.3005400085449219e+02 2.3336019897460938e+02 2.7334652709960938e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.3801260375976562e+02 2.2264300537109375e+02 2.9647320556640625e+02)(-2.0922000122070312e+02 2.5864749145507812e+02 2.4209570312500000e+02)(-2.2512860107421875e+02 2.4139070129394531e+02 2.6529360961914062e+02)(-2.1811781311035156e+02 2.4438890075683594e+02 2.5263182067871094e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-1.9598950195312500e+02 2.7671389770507812e+02 2.3185638427734375e+02)(-2.0441310119628906e+02 2.6262561035156250e+02 2.3608819580078125e+02)(-2.0441310119628906e+02 2.6262561035156250e+02 2.3608819580078125e+02)(-1.9598950195312500e+02 2.7671389770507812e+02 2.3185638427734375e+02)(-2.0922000122070312e+02 2.5864749145507812e+02 2.4209570312500000e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-3.0140789794921875e+02 -1.7303390502929688e+02 2.2586230468750000e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-3.0971228027343750e+02 -1.6624609375000000e+02 2.8153292846679688e+02)(-3.0113549804687500e+02 -2.1763050842285156e+02 3.5814602661132812e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-2.7903759765625000e+02 -2.1911099243164062e+02 2.4431900024414062e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-2.9717510986328125e+02 -2.0201321411132812e+02 2.9640341186523438e+02)(-3.0971228027343750e+02 -1.6624609375000000e+02 2.8153292846679688e+02)(-2.9717510986328125e+02 -2.0201321411132812e+02 2.9640341186523438e+02)(-3.0113549804687500e+02 -2.1763050842285156e+02 3.5814602661132812e+02)(-2.9717510986328125e+02 -2.0201321411132812e+02 2.9640341186523438e+02)(-3.0971228027343750e+02 -1.6624609375000000e+02 2.8153292846679688e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-2.7903759765625000e+02 -2.1911099243164062e+02 2.4431900024414062e+02)(-2.9717510986328125e+02 -2.0201321411132812e+02 2.9640341186523438e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-2.7903759765625000e+02 -2.1911099243164062e+02 2.4431900024414062e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.7903759765625000e+02 -2.1911099243164062e+02 2.4431900024414062e+02)(-3.0971228027343750e+02 -1.6624609375000000e+02 2.8153292846679688e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-2.9724731445312500e+02 -1.7182679748535156e+02 2.2968891906738281e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.0441201782226562e+02 1.9688571166992188e+02 3.2667379760742188e+02)(-3.0441201782226562e+02 1.9688571166992188e+02 3.2667379760742188e+02)(-2.9479119873046875e+02 2.2127371215820312e+02 3.1309182739257812e+02)(-2.8853112792968750e+02 2.2532501220703125e+02 2.8727407836914062e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-3.0441201782226562e+02 1.9688571166992188e+02 3.2667379760742188e+02)(-3.0441201782226562e+02 1.9688571166992188e+02 3.2667379760742188e+02)(-2.8853112792968750e+02 2.2532501220703125e+02 2.8727407836914062e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-2.8853112792968750e+02 2.2532501220703125e+02 2.8727407836914062e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-2.9707901000976562e+02 1.7267060852050781e+02 2.3008010864257812e+02)(-3.0170251464843750e+02 1.6335310363769531e+02 2.2339399719238281e+02)(-2.9707901000976562e+02 1.7267060852050781e+02 2.3008010864257812e+02)(-3.1284710693359375e+02 1.6672970581054688e+02 3.0302758789062500e+02)(-2.7793179321289062e+02 2.1571020507812500e+02 2.2939511108398438e+02)(-3.0170251464843750e+02 1.6335310363769531e+02 2.2339399719238281e+02)(-2.9707901000976562e+02 1.7267060852050781e+02 2.3008010864257812e+02)(-3.0256390380859375e+02 1.7047119140625000e+02 2.2508331298828125e+02)(-3.0971228027343750e+02 -1.6624609375000000e+02 2.8153292846679688e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-3.2213012695312500e+02 -9.9647499084472656e+01 3.4815429687500000e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.2213012695312500e+02 -9.9647499084472656e+01 3.4815429687500000e+02)(-3.3085272216796875e+02 -4.5833801269531250e+01 4.8528829956054688e+02)(-3.1772372436523438e+02 3.2468299865722656e+01 2.7400622558593750e+02)(-3.2213012695312500e+02 -9.9647499084472656e+01 3.4815429687500000e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.1772372436523438e+02 3.2468299865722656e+01 2.7400622558593750e+02)(-3.1233938598632812e+02 -2.0917699813842773e+01 2.1261611938476562e+02)(-3.2213012695312500e+02 -9.9647499084472656e+01 3.4815429687500000e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.2213012695312500e+02 -9.9647499084472656e+01 3.4815429687500000e+02)(-3.1233938598632812e+02 -2.0917699813842773e+01 2.1261611938476562e+02)(-3.0895022583007812e+02 -1.1543418884277344e+02 2.1211419677734375e+02)(-3.0157281494140625e+02 -1.6569239807128906e+02 2.2282409667968750e+02)(-3.0971228027343750e+02 -1.6624609375000000e+02 2.8153292846679688e+02)(-3.2934991455078125e+02 1.7470600891113281e+02 6.5616778564453125e+02)(-3.2891421508789062e+02 1.7582830810546875e+02 5.4998040771484375e+02)(-3.3431469726562500e+02 8.5528099060058594e+01 6.5616815185546875e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.3085272216796875e+02 -4.5833801269531250e+01 4.8528829956054688e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-3.3431469726562500e+02 8.5528099060058594e+01 6.5616815185546875e+02)(-3.3431469726562500e+02 8.5528099060058594e+01 6.5616815185546875e+02)(-3.2891421508789062e+02 1.7582830810546875e+02 5.4998040771484375e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.2953128051757812e+02 8.2005996704101562e+01 4.6353680419921875e+02)(-3.2891421508789062e+02 1.7582830810546875e+02 5.4998040771484375e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-2.7506958007812500e+02 -2.3969100952148438e+02 2.6260171508789062e+02)(-2.6450988769531250e+02 -2.5069949340820312e+02 2.4733018493652344e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.9340371704101562e+02 -2.2323350524902344e+02 3.2401782226562500e+02)(-2.3953071594238281e+02 -2.2955619812011719e+02 2.9798672485351562e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.8329980468750000e+02 -2.2965000915527344e+02 2.8934860229492188e+02)(-2.7506958007812500e+02 -2.3969100952148438e+02 2.6260171508789062e+02)(-2.3953071594238281e+02 -2.2955619812011719e+02 2.9798672485351562e+02)(-2.8329980468750000e+02 -2.2965000915527344e+02 2.8934860229492188e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.0276020812988281e+02 -2.6726800537109375e+02 2.3576710510253906e+02)(-2.2279380798339844e+02 -2.4315341186523438e+02 2.6099072265625000e+02)(-2.6450988769531250e+02 -2.5069949340820312e+02 2.4733018493652344e+02)(-2.5323692321777344e+02 -2.6886859130859375e+02 2.3238121032714844e+02)(-2.4242858886718750e+02 -2.8712341308593750e+02 2.2637010192871094e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-2.6450988769531250e+02 -2.5069949340820312e+02 2.4733018493652344e+02)(-2.5323692321777344e+02 -2.6886859130859375e+02 2.3238121032714844e+02)(-2.0276020812988281e+02 -2.6726800537109375e+02 2.3576710510253906e+02)(-1.9201400756835938e+02 -2.8525430297851562e+02 2.2802369689941406e+02)(-2.0276020812988281e+02 -2.6726800537109375e+02 2.3576710510253906e+02)(-2.5323692321777344e+02 -2.6886859130859375e+02 2.3238121032714844e+02)(-2.3953071594238281e+02 -2.2955619812011719e+02 2.9798672485351562e+02)(-2.9340371704101562e+02 -2.2323350524902344e+02 3.2401782226562500e+02)(-2.8329980468750000e+02 -2.2965000915527344e+02 2.8934860229492188e+02)(-2.5477859497070312e+02 -2.1310140991210938e+02 4.1839654541015625e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.5269299316406250e+02 -2.1032249450683594e+02 4.0986929321289062e+02)(-2.4097021484375000e+02 -2.1888510131835938e+02 3.0747140502929688e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.4216818237304688e+02 -2.2349989318847656e+02 3.0658862304687500e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-2.4216818237304688e+02 -2.2349989318847656e+02 3.0658862304687500e+02)(-2.5477859497070312e+02 -2.1310140991210938e+02 4.1839654541015625e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-2.4970869445800781e+02 -2.1475401306152344e+02 3.5550991821289062e+02)(-2.5477859497070312e+02 -2.1310140991210938e+02 4.1839654541015625e+02)(-2.5486022949218750e+02 -2.1820759582519531e+02 4.2155017089843750e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.5323060607910156e+02 -2.0838220214843750e+02 4.7045349121093750e+02)(-2.5269299316406250e+02 -2.1032249450683594e+02 4.0986929321289062e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5500000000000000e+02 -1.5934561157226562e+02 6.5618621826171875e+02)(-2.5500000000000000e+02 -2.0825691223144531e+02 6.5618072509765625e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.5500000000000000e+02 -1.5934260559082031e+02 5.7054760742187500e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5500000000000000e+02 -1.5934561157226562e+02 6.5618621826171875e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5500000000000000e+02 -1.5934260559082031e+02 5.7054760742187500e+02)(-2.5490078735351562e+02 -2.0725320434570312e+02 5.7055432128906250e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-2.5500000000000000e+02 -1.5934561157226562e+02 6.5618621826171875e+02)(-2.5500000000000000e+02 -1.5934260559082031e+02 5.7054760742187500e+02)(-2.6150000000000000e+02 -1.5934289550781250e+02 5.7025000000000000e+02)(-2.5500000000000000e+02 -1.5934561157226562e+02 6.5618621826171875e+02)(-2.5490078735351562e+02 -2.0725320434570312e+02 5.7055432128906250e+02)(-2.5329130554199219e+02 -2.0433750915527344e+02 5.7056744384765625e+02)(-2.5502999877929688e+02 -1.9741380310058594e+02 5.7054840087890625e+02)(-3.2811242675781250e+02 -1.7760290527343750e+02 5.2930346679687500e+02)(-3.2433160400390625e+02 -1.8688801574707031e+02 5.9237664794921875e+02)(-3.2984332275390625e+02 -1.7271240234375000e+02 6.5617297363281250e+02)(-3.2984332275390625e+02 -1.7271240234375000e+02 6.5617297363281250e+02)(-3.2433160400390625e+02 -1.8688801574707031e+02 5.9237664794921875e+02)(-3.1909899902343750e+02 -1.9309640502929688e+02 6.5615765380859375e+02)(-3.2433160400390625e+02 -1.8688801574707031e+02 5.9237664794921875e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-3.1909899902343750e+02 -1.9309640502929688e+02 6.5615765380859375e+02)(-3.2811242675781250e+02 -1.7760290527343750e+02 5.2930346679687500e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-3.2433160400390625e+02 -1.8688801574707031e+02 5.9237664794921875e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-3.0545648193359375e+02 -2.0641780090332031e+02 6.5615686035156250e+02)(-3.1909899902343750e+02 -1.9309640502929688e+02 6.5615765380859375e+02)(-3.3085272216796875e+02 -4.5833801269531250e+01 4.8528829956054688e+02)(-3.3335650634765625e+02 -8.7930503845214844e+01 5.8962292480468750e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-3.2984332275390625e+02 -1.7271240234375000e+02 6.5617297363281250e+02)(-3.3568103027343750e+02 -1.2105299949645996e+01 6.5616040039062500e+02)(-3.3335650634765625e+02 -8.7930503845214844e+01 5.8962292480468750e+02)(-3.2984332275390625e+02 -1.7271240234375000e+02 6.5617297363281250e+02)(-3.3335650634765625e+02 -8.7930503845214844e+01 5.8962292480468750e+02)(-3.2811242675781250e+02 -1.7760290527343750e+02 5.2930346679687500e+02)(-3.3085272216796875e+02 -4.5833801269531250e+01 4.8528829956054688e+02)(-3.2811242675781250e+02 -1.7760290527343750e+02 5.2930346679687500e+02)(-3.3335650634765625e+02 -8.7930503845214844e+01 5.8962292480468750e+02)(-3.2811242675781250e+02 -1.7760290527343750e+02 5.2930346679687500e+02)(-3.3085272216796875e+02 -4.5833801269531250e+01 4.8528829956054688e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-3.2213012695312500e+02 -9.9647499084472656e+01 3.4815429687500000e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-3.3085272216796875e+02 -4.5833801269531250e+01 4.8528829956054688e+02)(-3.2280969238281250e+02 1.8986770629882812e+02 5.6836761474609375e+02)(-3.2934991455078125e+02 1.7470600891113281e+02 6.5616778564453125e+02)(-3.1781671142578125e+02 1.9390710449218750e+02 6.5617004394531250e+02)(-3.2280969238281250e+02 1.8986770629882812e+02 5.6836761474609375e+02)(-3.2891421508789062e+02 1.7582830810546875e+02 5.4998040771484375e+02)(-3.2934991455078125e+02 1.7470600891113281e+02 6.5616778564453125e+02)(-3.2891421508789062e+02 1.7582830810546875e+02 5.4998040771484375e+02)(-3.2085760498046875e+02 1.8414109802246094e+02 4.2986614990234375e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.2280969238281250e+02 1.8986770629882812e+02 5.6836761474609375e+02)(-3.2085760498046875e+02 1.8414109802246094e+02 4.2986614990234375e+02)(-3.2891421508789062e+02 1.7582830810546875e+02 5.4998040771484375e+02)(-3.1781671142578125e+02 1.9390710449218750e+02 6.5617004394531250e+02)(-3.0456701660156250e+02 2.1263919067382812e+02 5.1154190063476562e+02)(-3.2280969238281250e+02 1.8986770629882812e+02 5.6836761474609375e+02)(-3.0496319580078125e+02 2.0630851745605469e+02 6.5617242431640625e+02)(-3.0566320800781250e+02 2.0894561767578125e+02 5.8862792968750000e+02)(-3.1781671142578125e+02 1.9390710449218750e+02 6.5617004394531250e+02)(-3.2280969238281250e+02 1.8986770629882812e+02 5.6836761474609375e+02)(-3.0456701660156250e+02 2.1263919067382812e+02 5.1154190063476562e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-3.2280969238281250e+02 1.8986770629882812e+02 5.6836761474609375e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-3.2085760498046875e+02 1.8414109802246094e+02 4.2986614990234375e+02)(-3.1781671142578125e+02 1.9390710449218750e+02 6.5617004394531250e+02)(-3.0566320800781250e+02 2.0894561767578125e+02 5.8862792968750000e+02)(-3.0456701660156250e+02 2.1263919067382812e+02 5.1154190063476562e+02)(-3.0277929687500000e+02 2.1115820312500000e+02 5.5772204589843750e+02)(-3.0456701660156250e+02 2.1263919067382812e+02 5.1154190063476562e+02)(-3.0566320800781250e+02 2.0894561767578125e+02 5.8862792968750000e+02)(-3.0566320800781250e+02 2.0894561767578125e+02 5.8862792968750000e+02)(-3.0196942138671875e+02 2.0997979736328125e+02 5.8483612060546875e+02)(-3.0277929687500000e+02 2.1115820312500000e+02 5.5772204589843750e+02)(-3.0566320800781250e+02 2.0894561767578125e+02 5.8862792968750000e+02)(-3.0496319580078125e+02 2.0630851745605469e+02 6.5617242431640625e+02)(-3.0196942138671875e+02 2.0997979736328125e+02 5.8483612060546875e+02)(-3.0277929687500000e+02 2.1115820312500000e+02 5.5772204589843750e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-3.0456701660156250e+02 2.1263919067382812e+02 5.1154190063476562e+02)(-2.5500000000000000e+02 2.0825119018554688e+02 6.5618341064453125e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-3.0496319580078125e+02 2.0630851745605469e+02 6.5617242431640625e+02)(-3.0277929687500000e+02 2.1115820312500000e+02 5.5772204589843750e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-3.0456701660156250e+02 2.1263919067382812e+02 5.1154190063476562e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-2.5244628906250000e+02 2.2112980651855469e+02 3.6706671142578125e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-2.5244628906250000e+02 2.2112980651855469e+02 3.6706671142578125e+02)(-3.0196942138671875e+02 2.0997979736328125e+02 5.8483612060546875e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-3.0277929687500000e+02 2.1115820312500000e+02 5.5772204589843750e+02)(-3.0496319580078125e+02 2.0630851745605469e+02 6.5617242431640625e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-3.0196942138671875e+02 2.0997979736328125e+02 5.8483612060546875e+02)(-2.5500000000000000e+02 1.5934390258789062e+02 6.5618621826171875e+02)(-2.5500000000000000e+02 2.0825119018554688e+02 6.5618341064453125e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-2.6150000000000000e+02 -1.5932890319824219e+02 6.5617498779296875e+02)(-2.5500000000000000e+02 -2.0825691223144531e+02 6.5618072509765625e+02)(-2.5500000000000000e+02 -1.5934561157226562e+02 6.5618621826171875e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5500000000000000e+02 -2.0825691223144531e+02 6.5618072509765625e+02)(-3.0545648193359375e+02 -2.0641780090332031e+02 6.5615686035156250e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-2.5486022949218750e+02 -2.1820759582519531e+02 4.2155017089843750e+02)(-3.0545648193359375e+02 -2.0641780090332031e+02 6.5615686035156250e+02)(-2.9340371704101562e+02 -2.2323350524902344e+02 3.2401782226562500e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-3.0545648193359375e+02 -2.0641780090332031e+02 6.5615686035156250e+02)(-2.5486022949218750e+02 -2.1820759582519531e+02 4.2155017089843750e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5486022949218750e+02 -2.1820759582519531e+02 4.2155017089843750e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-2.5017961120605469e+02 -2.2291529846191406e+02 3.4508041381835938e+02)(-2.5500000000000000e+02 1.5934260559082031e+02 5.7054760742187500e+02)(-2.5500000000000000e+02 1.5934390258789062e+02 6.5618621826171875e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.6144488525390625e+02 1.5934660339355469e+02 5.7025079345703125e+02)(-2.5500000000000000e+02 1.5934390258789062e+02 6.5618621826171875e+02)(-2.6150000000000000e+02 1.5932469177246094e+02 6.5618438720703125e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.5428581237792969e+02 2.0588610839843750e+02 5.7052178955078125e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5500000000000000e+02 1.5934260559082031e+02 5.7054760742187500e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.5500000000000000e+02 2.0825119018554688e+02 6.5618341064453125e+02)(-2.5500000000000000e+02 1.5934390258789062e+02 6.5618621826171875e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5500000000000000e+02 1.5934390258789062e+02 6.5618621826171875e+02)(-2.5500000000000000e+02 1.5934260559082031e+02 5.7054760742187500e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)(-2.5428581237792969e+02 2.0588610839843750e+02 5.7052178955078125e+02)(-2.5495329284667969e+02 1.9707821655273438e+02 5.7056445312500000e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.5233122253417969e+02 2.1589819335937500e+02 3.7277612304687500e+02)(-2.5244628906250000e+02 2.2112980651855469e+02 3.6706671142578125e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.5233122253417969e+02 2.1589819335937500e+02 3.7277612304687500e+02)(-2.5244628906250000e+02 2.2112980651855469e+02 3.6706671142578125e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.5244628906250000e+02 2.2112980651855469e+02 3.6706671142578125e+02)(-2.5233122253417969e+02 2.1589819335937500e+02 3.7277612304687500e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.5244628906250000e+02 2.2112980651855469e+02 3.6706671142578125e+02)(-2.4677000427246094e+02 2.1743350219726562e+02 3.3303808593750000e+02)(-2.8729553222656250e+02 2.2629321289062500e+02 3.0603237915039062e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.2512860107421875e+02 2.4139070129394531e+02 2.6529360961914062e+02)(-2.0922000122070312e+02 2.5864749145507812e+02 2.4209570312500000e+02)(-2.6883090209960938e+02 2.4736320495605469e+02 2.5001879882812500e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.2512860107421875e+02 2.4139070129394531e+02 2.6529360961914062e+02)(-2.6883090209960938e+02 2.4736320495605469e+02 2.5001879882812500e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.2512860107421875e+02 2.4139070129394531e+02 2.6529360961914062e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.6883090209960938e+02 2.4736320495605469e+02 2.5001879882812500e+02)(-2.0922000122070312e+02 2.5864749145507812e+02 2.4209570312500000e+02)(-2.5888940429687500e+02 2.6074282836914062e+02 2.3711720275878906e+02)(-2.0922000122070312e+02 2.5864749145507812e+02 2.4209570312500000e+02)(-1.9598950195312500e+02 2.7671389770507812e+02 2.3185638427734375e+02)(-2.5888940429687500e+02 2.6074282836914062e+02 2.3711720275878906e+02)(-2.5888940429687500e+02 2.6074282836914062e+02 2.3711720275878906e+02)(-1.9598950195312500e+02 2.7671389770507812e+02 2.3185638427734375e+02)(-2.4089520263671875e+02 2.8654281616210938e+02 2.2672879028320312e+02)(-1.9598950195312500e+02 2.7671389770507812e+02 2.3185638427734375e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-2.4089520263671875e+02 2.8654281616210938e+02 2.2672879028320312e+02)(-1.9309339904785156e+02 2.8225778198242188e+02 2.2805050659179688e+02)(-2.3655441284179688e+02 3.1402832031250000e+02 2.2571330261230469e+02)(-2.4089520263671875e+02 2.8654281616210938e+02 2.2672879028320312e+02)(-2.3936788940429688e+02 2.2954141235351562e+02 2.9631442260742188e+02)(-2.8729553222656250e+02 2.2629321289062500e+02 3.0603237915039062e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-3.2811242675781250e+02 -1.7760290527343750e+02 5.2930346679687500e+02)(-3.0113549804687500e+02 -2.1763050842285156e+02 3.5814602661132812e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-3.2332272338867188e+02 -1.7587080383300781e+02 4.1620849609375000e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-3.0113549804687500e+02 -2.1763050842285156e+02 3.5814602661132812e+02)(-2.9717510986328125e+02 -2.0201321411132812e+02 2.9640341186523438e+02)(-2.7506958007812500e+02 -2.3969100952148438e+02 2.6260171508789062e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-2.6229461669921875e+02 -2.5929312133789062e+02 2.3134329223632812e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-2.8329980468750000e+02 -2.2965000915527344e+02 2.8934860229492188e+02)(-2.9340371704101562e+02 -2.2323350524902344e+02 3.2401782226562500e+02)(-2.8329980468750000e+02 -2.2965000915527344e+02 2.8934860229492188e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-2.7506958007812500e+02 -2.3969100952148438e+02 2.6260171508789062e+02)(-2.8853112792968750e+02 2.2532501220703125e+02 2.8727407836914062e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.6491421508789062e+02 2.5324790954589844e+02 2.3056059265136719e+02)(-2.8853112792968750e+02 2.2532501220703125e+02 2.8727407836914062e+02)(-2.9479119873046875e+02 2.2127371215820312e+02 3.1309182739257812e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.8729553222656250e+02 2.2629321289062500e+02 3.0603237915039062e+02)(-2.7971621704101562e+02 2.3434710693359375e+02 2.7460522460937500e+02)(-2.9479119873046875e+02 2.2127371215820312e+02 3.1309182739257812e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-2.8729553222656250e+02 2.2629321289062500e+02 3.0603237915039062e+02)(-2.9479119873046875e+02 2.2127371215820312e+02 3.1309182739257812e+02)(-3.2143258666992188e+02 1.7361032104492188e+02 3.8849099731445312e+02)(-3.2085760498046875e+02 1.8414109802246094e+02 4.2986614990234375e+02)(-3.0441201782226562e+02 1.9688571166992188e+02 3.2667379760742188e+02)(-3.2085760498046875e+02 1.8414109802246094e+02 4.2986614990234375e+02)(-3.0058889770507812e+02 2.1900680541992188e+02 3.5762530517578125e+02)(-2.9479119873046875e+02 2.2127371215820312e+02 3.1309182739257812e+02)(-3.2085760498046875e+02 1.8414109802246094e+02 4.2986614990234375e+02)(-2.9479119873046875e+02 2.2127371215820312e+02 3.1309182739257812e+02)(-3.0441201782226562e+02 1.9688571166992188e+02 3.2667379760742188e+02)(-2.5480982971191406e+02 -2.0962619018554688e+02 5.1108370971679688e+02)(-2.5323060607910156e+02 -2.0838220214843750e+02 4.7045349121093750e+02)(-2.5329130554199219e+02 -2.0433750915527344e+02 5.7056744384765625e+02)(-2.5323060607910156e+02 -2.0838220214843750e+02 4.7045349121093750e+02)(-2.5477859497070312e+02 -2.1310140991210938e+02 4.1839654541015625e+02)(-2.5269299316406250e+02 -2.1032249450683594e+02 4.0986929321289062e+02)(-2.5446638488769531e+02 -1.9991090393066406e+02 4.5304281616210938e+02)(-2.5329130554199219e+02 -2.0433750915527344e+02 5.7056744384765625e+02)(-2.5323060607910156e+02 -2.0838220214843750e+02 4.7045349121093750e+02)(-2.5329130554199219e+02 -2.0433750915527344e+02 5.7056744384765625e+02)(-2.5490078735351562e+02 -2.0725320434570312e+02 5.7055432128906250e+02)(-2.5480982971191406e+02 -2.0962619018554688e+02 5.1108370971679688e+02)(-2.5480982971191406e+02 -2.0962619018554688e+02 5.1108370971679688e+02)(-2.5477859497070312e+02 -2.1310140991210938e+02 4.1839654541015625e+02)(-2.5323060607910156e+02 -2.0838220214843750e+02 4.7045349121093750e+02)(-2.5480982971191406e+02 -2.0962619018554688e+02 5.1108370971679688e+02)(-2.5486022949218750e+02 -2.1820759582519531e+02 4.2155017089843750e+02)(-2.5477859497070312e+02 -2.1310140991210938e+02 4.1839654541015625e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5486022949218750e+02 -2.1820759582519531e+02 4.2155017089843750e+02)(-2.5480982971191406e+02 -2.0962619018554688e+02 5.1108370971679688e+02)(-2.5490078735351562e+02 -2.0725320434570312e+02 5.7055432128906250e+02)(-2.5497698974609375e+02 -2.1187500000000000e+02 5.7982714843750000e+02)(-2.5480982971191406e+02 -2.0962619018554688e+02 5.1108370971679688e+02)(-2.9198971557617188e+02 -2.2284852600097656e+02 2.9840460205078125e+02)(-2.9340371704101562e+02 -2.2323350524902344e+02 3.2401782226562500e+02)(-3.0113549804687500e+02 -2.1763050842285156e+02 3.5814602661132812e+02)(-3.0113549804687500e+02 -2.1763050842285156e+02 3.5814602661132812e+02)(-2.9340371704101562e+02 -2.2323350524902344e+02 3.2401782226562500e+02)(-3.0391619873046875e+02 -2.1531729125976562e+02 4.2680978393554688e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-2.5498780822753906e+02 2.1765550231933594e+02 4.3579840087890625e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)(-2.5370979309082031e+02 2.1019850158691406e+02 4.2148800659179688e+02)(-2.5557890319824219e+02 2.1074359130859375e+02 5.9178143310546875e+02)(-2.5428581237792969e+02 2.0588610839843750e+02 5.7052178955078125e+02)(-2.5358560180664062e+02 2.0324099731445312e+02 5.1523583984375000e+02)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 3600 -> 77 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (nreverse (list (float-vector 2.2307360172271729e+02 3.2685241103172302e+02 2.0513060688972473e+02) (float-vector -2.5499999523162842e+02 2.0825119316577911e+02 6.5618342161178589e+02) (float-vector -3.0496320128440857e+02 2.0630851387977600e+02 6.5617245435714722e+02) (float-vector -2.3092730343341827e+02 3.2662889361381531e+02 2.1151649951934814e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02) (float-vector 2.3239700496196747e+02 -3.2586652040481567e+02 2.0497380197048187e+02) (float-vector -2.3522238433361053e+02 -3.2596951723098755e+02 2.1154521405696869e+02) (float-vector -3.0545648932456970e+02 -2.0641779899597168e+02 6.5615683794021606e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.3337751030921936e+02 1.4074240624904633e+02 1.6864080727100372e+02) (float-vector 3.3373069763183594e+02 2.2492781281471252e+02 8.7267898023128510e+01) (float-vector 3.3315080404281616e+02 2.3254239559173584e+02 -1.9630900283118535e-04) (float-vector 3.3300229907035828e+02 -2.3394499719142914e+02 -2.1230600850685732e-03) (float-vector 3.3044311404228210e+02 -2.4968130886554718e+02 8.7400600314140320e+01) (float-vector 3.3336040377616882e+02 -1.4279119670391083e+02 1.6829329729080200e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.2534170150756836e+02 -2.6543480157852173e+02 2.6465600967640057e-02) (float-vector 3.3044311404228210e+02 -2.4968130886554718e+02 8.7400600314140320e+01) (float-vector 3.3300229907035828e+02 -2.3394499719142914e+02 -2.1230600850685732e-03))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1378132104873657e+02 -2.5191199779510498e+02 2.0938129723072052e+02) (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02) (float-vector 2.9603591561317444e+02 -3.2186899334192276e+01 2.9027292132377625e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.1370639801025391e+02 2.8636670112609863e+02 1.4508250355720520e+02) (float-vector -2.9361590743064880e+02 3.0790051817893982e+02 1.4328730106353760e+02) (float-vector -2.7596268057823181e+02 3.1145101785659790e+02 2.0609970390796661e+02) (float-vector -3.0496320128440857e+02 2.0630851387977600e+02 6.5617245435714722e+02) (float-vector -3.1781670451164246e+02 1.9390709698200226e+02 6.5617007017135620e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.0006298422813416e+02 3.3962201327085495e+01 2.8493592143058777e+02) (float-vector 2.9490810632705688e+02 3.3810500055551529e+01 2.9029712080955505e+02) (float-vector 3.2175451517105103e+02 2.3548789322376251e+02 2.0370259881019592e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.9490810632705688e+02 3.3810500055551529e+01 2.9029712080955505e+02) (float-vector 3.0006298422813416e+02 3.3962201327085495e+01 2.8493592143058777e+02) (float-vector 2.9603591561317444e+02 -3.2186899334192276e+01 2.9027292132377625e+02) (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02) (float-vector -2.5499999523162842e+02 2.0825119316577911e+02 6.5618342161178589e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.2252860069274902e+02 -2.2448121011257172e+02 2.0453310012817383e+02) (float-vector 2.9603591561317444e+02 -3.2186899334192276e+01 2.9027292132377625e+02) (float-vector 3.0006298422813416e+02 3.3962201327085495e+01 2.8493592143058777e+02) (float-vector 3.2175451517105103e+02 2.3548789322376251e+02 2.0370259881019592e+02) (float-vector 3.3337751030921936e+02 1.4074240624904633e+02 1.6864080727100372e+02) (float-vector 3.3336040377616882e+02 -1.4279119670391083e+02 1.6829329729080200e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.2558059692382812e+02 2.6504331827163696e+02 -1.3530200249078916e-03) (float-vector 3.2872679829597473e+02 2.5509282946586609e+02 8.7569601833820343e+01) (float-vector 3.1850311160087585e+02 2.7859291434288025e+02 8.8477306067943573e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1447130441665649e+02 2.6122599840164185e+02 2.0384469628334045e+02) (float-vector 3.2872679829597473e+02 2.5509282946586609e+02 8.7569601833820343e+01) (float-vector 3.2175451517105103e+02 2.3548789322376251e+02 2.0370259881019592e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.3373069763183594e+02 2.2492781281471252e+02 8.7267898023128510e+01) (float-vector 3.2872679829597473e+02 2.5509282946586609e+02 8.7569601833820343e+01) (float-vector 3.2558059692382812e+02 2.6504331827163696e+02 -1.3530200249078916e-03) (float-vector 3.3315080404281616e+02 2.3254239559173584e+02 -1.9630900283118535e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 3.2175451517105103e+02 2.3548789322376251e+02 2.0370259881019592e+02) (float-vector 3.2872679829597473e+02 2.5509282946586609e+02 8.7569601833820343e+01) (float-vector 3.3373069763183594e+02 2.2492781281471252e+02 8.7267898023128510e+01) (float-vector 3.3337751030921936e+02 1.4074240624904633e+02 1.6864080727100372e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.3522238433361053e+02 -3.2596951723098755e+02 2.1154521405696869e+02) (float-vector -2.6593640446662903e+02 -3.1660050153732300e+02 2.0808671414852142e+02) (float-vector -3.0545648932456970e+02 -2.0641779899597168e+02 6.5615683794021606e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.6593640446662903e+02 -3.1660050153732300e+02 2.0808671414852142e+02) (float-vector -2.8527233004570007e+02 -3.1483760476112366e+02 1.4254909753799438e+02) (float-vector -3.0545648932456970e+02 -2.0641779899597168e+02 6.5615683794021606e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.2999981045722961e+02 -3.3321920037269592e+02 1.3758790493011475e+02) (float-vector -2.3522238433361053e+02 -3.2596951723098755e+02 2.1154521405696869e+02) (float-vector 2.3239700496196747e+02 -3.2586652040481567e+02 2.0497380197048187e+02) (float-vector 2.3212730884552002e+02 -3.3318969607353210e+02 9.6215099096298218e+01))))
    (instance face :init :vertices (nreverse (list (float-vector -2.4389031529426575e+02 -3.3201649785041809e+02 -2.9791999622830190e-04) (float-vector -2.2999981045722961e+02 -3.3321920037269592e+02 1.3758790493011475e+02) (float-vector 2.3212730884552002e+02 -3.3318969607353210e+02 9.6215099096298218e+01) (float-vector 2.2956000268459320e+02 -3.3329042792320251e+02 0.0000000000000000e+00))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1859120726585388e+02 -2.7849012613296509e+02 8.8449701666831970e+01) (float-vector 3.2534170150756836e+02 -2.6543480157852173e+02 2.6465600967640057e-02) (float-vector 3.0749469995498657e+02 -2.9423841834068298e+02 -5.0370698545521009e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 3.2534170150756836e+02 -2.6543480157852173e+02 2.6465600967640057e-02) (float-vector 3.1859120726585388e+02 -2.7849012613296509e+02 8.8449701666831970e+01) (float-vector 3.3044311404228210e+02 -2.4968130886554718e+02 8.7400600314140320e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 2.5936490297317505e+02 -3.2758441567420959e+02 9.3793205916881561e+01) (float-vector 2.5389692187309265e+02 -3.2920572161674500e+02 -4.5005103288531245e-04) (float-vector 2.2956000268459320e+02 -3.3329042792320251e+02 0.0000000000000000e+00) (float-vector 2.3212730884552002e+02 -3.3318969607353210e+02 9.6215099096298218e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1378132104873657e+02 -2.5191199779510498e+02 2.0938129723072052e+02) (float-vector 3.1945961713790894e+02 -2.4776421487331390e+02 2.0187261700630188e+02) (float-vector 3.1106391549110413e+02 -2.6823261380195618e+02 2.0371539890766144e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1106391549110413e+02 -2.6823261380195618e+02 2.0371539890766144e+02) (float-vector 3.1945961713790894e+02 -2.4776421487331390e+02 2.0187261700630188e+02) (float-vector 3.3044311404228210e+02 -2.4968130886554718e+02 8.7400600314140320e+01) (float-vector 3.1859120726585388e+02 -2.7849012613296509e+02 8.8449701666831970e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1945961713790894e+02 -2.4776421487331390e+02 2.0187261700630188e+02) (float-vector 3.1378132104873657e+02 -2.5191199779510498e+02 2.0938129723072052e+02) (float-vector 2.9603591561317444e+02 -3.2186899334192276e+01 2.9027292132377625e+02) (float-vector 3.2252860069274902e+02 -2.2448121011257172e+02 2.0453310012817383e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1945961713790894e+02 -2.4776421487331390e+02 2.0187261700630188e+02) (float-vector 3.2252860069274902e+02 -2.2448121011257172e+02 2.0453310012817383e+02) (float-vector 3.3336040377616882e+02 -1.4279119670391083e+02 1.6829329729080200e+02) (float-vector 3.3044311404228210e+02 -2.4968130886554718e+02 8.7400600314140320e+01))))
    (instance face :init :vertices (nreverse (list (float-vector -3.1370639801025391e+02 2.8636670112609863e+02 1.4508250355720520e+02) (float-vector -3.2179579138755798e+02 2.7240410447120667e+02 -5.9413400776975323e-04) (float-vector -3.0551490187644958e+02 2.9663410782814026e+02 -5.0049504807248013e-04))))
    (instance face :init :vertices (nreverse (list (float-vector -3.0551490187644958e+02 2.9663410782814026e+02 -5.0049504807248013e-04) (float-vector -2.8578719496726990e+02 3.1374549865722656e+02 -1.1697198942783871e-04) (float-vector -2.9361590743064880e+02 3.0790051817893982e+02 1.4328730106353760e+02) (float-vector -3.1370639801025391e+02 2.8636670112609863e+02 1.4508250355720520e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.6799160242080688e+02 3.2413920760154724e+02 1.4099200069904327e+02) (float-vector -2.7596268057823181e+02 3.1145101785659790e+02 2.0609970390796661e+02) (float-vector -2.9361590743064880e+02 3.0790051817893982e+02 1.4328730106353760e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.2697041928768158e+02 3.3336150646209717e+02 1.3732460141181946e+02) (float-vector -2.6799160242080688e+02 3.2413920760154724e+02 1.4099200069904327e+02) (float-vector -2.6282390952110291e+02 3.2623702287673950e+02 -1.2352400062809465e-03) (float-vector -2.3388290405273438e+02 3.3305522799491882e+02 -1.8764499998269457e-04))))
    (instance face :init :vertices (nreverse (list (float-vector -2.6282390952110291e+02 3.2623702287673950e+02 -1.2352400062809465e-03) (float-vector -2.6799160242080688e+02 3.2413920760154724e+02 1.4099200069904327e+02) (float-vector -2.9361590743064880e+02 3.0790051817893982e+02 1.4328730106353760e+02) (float-vector -2.8578719496726990e+02 3.1374549865722656e+02 -1.1697198942783871e-04))))
    (instance face :init :vertices (nreverse (list (float-vector -2.4861851334571838e+02 3.2278800010681152e+02 2.1046529710292816e+02) (float-vector -2.3092730343341827e+02 3.2662889361381531e+02 2.1151649951934814e+02) (float-vector -3.0496320128440857e+02 2.0630851387977600e+02 6.5617245435714722e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.7596268057823181e+02 3.1145101785659790e+02 2.0609970390796661e+02) (float-vector -2.4861851334571838e+02 3.2278800010681152e+02 2.1046529710292816e+02) (float-vector -3.0496320128440857e+02 2.0630851387977600e+02 6.5617245435714722e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.6799160242080688e+02 3.2413920760154724e+02 1.4099200069904327e+02) (float-vector -2.4861851334571838e+02 3.2278800010681152e+02 2.1046529710292816e+02) (float-vector -2.7596268057823181e+02 3.1145101785659790e+02 2.0609970390796661e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.3092730343341827e+02 3.2662889361381531e+02 2.1151649951934814e+02) (float-vector -2.4861851334571838e+02 3.2278800010681152e+02 2.1046529710292816e+02) (float-vector -2.6799160242080688e+02 3.2413920760154724e+02 1.4099200069904327e+02) (float-vector -2.2697041928768158e+02 3.3336150646209717e+02 1.3732460141181946e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.6423540711402893e+02 3.2544609904289246e+02 3.6640702205659181e-04) (float-vector 2.5065159797668457e+02 3.3002069592475891e+02 9.4568997621536255e+01) (float-vector 2.3840849101543427e+02 3.3261021971702576e+02 -1.3229099522504839e-03))))
    (instance face :init :vertices (nreverse (list (float-vector 2.6423540711402893e+02 3.2544609904289246e+02 3.6640702205659181e-04) (float-vector 2.8756579756736755e+02 3.1275302171707153e+02 -3.8603303664785926e-04) (float-vector 2.7867612242698669e+02 3.1863850355148315e+02 9.2054396867752075e+01) (float-vector 2.5065159797668457e+02 3.3002069592475891e+02 9.4568997621536255e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 2.2307360172271729e+02 3.2685241103172302e+02 2.0513060688972473e+02) (float-vector -2.3092730343341827e+02 3.2662889361381531e+02 2.1151649951934814e+02) (float-vector -2.2697041928768158e+02 3.3336150646209717e+02 1.3732460141181946e+02) (float-vector 2.2822010517120361e+02 3.3336099982261658e+02 9.6564002335071564e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 2.5065159797668457e+02 3.3002069592475891e+02 9.4568997621536255e+01) (float-vector 2.2822010517120361e+02 3.3336099982261658e+02 9.6564002335071564e+01) (float-vector -2.2697041928768158e+02 3.3336150646209717e+02 1.3732460141181946e+02) (float-vector -2.3388290405273438e+02 3.3305522799491882e+02 -1.8764499998269457e-04) (float-vector 2.3840849101543427e+02 3.3261021971702576e+02 -1.3229099522504839e-03))))
    (instance face :init :vertices (nreverse (list (float-vector -3.0496320128440857e+02 2.0630851387977600e+02 6.5617245435714722e+02) (float-vector -2.5499999523162842e+02 2.0825119316577911e+02 6.5618342161178589e+02) (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02) (float-vector -3.0545648932456970e+02 -2.0641779899597168e+02 6.5615683794021606e+02) (float-vector -3.1909900903701782e+02 -1.9309639930725098e+02 6.5615767240524292e+02) (float-vector -3.2984331250190735e+02 -1.7271240055561066e+02 6.5617299079895020e+02) (float-vector -3.3568102121353149e+02 -1.2105300091207027e+01 6.5616041421890259e+02) (float-vector -3.2934990525245667e+02 1.7470601201057434e+02 6.5616780519485474e+02) (float-vector -3.1781670451164246e+02 1.9390709698200226e+02 6.5617007017135620e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.8527233004570007e+02 -3.1483760476112366e+02 1.4254909753799438e+02) (float-vector -3.1073141098022461e+02 -2.9012581706047058e+02 1.4482130110263824e+02) (float-vector -3.1909900903701782e+02 -1.9309639930725098e+02 6.5615767240524292e+02) (float-vector -3.0545648932456970e+02 -2.0641779899597168e+02 6.5615683794021606e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2442250847816467e+02 -2.6655000448226929e+02 1.4605419337749481e+02) (float-vector -3.2984331250190735e+02 -1.7271240055561066e+02 6.5617299079895020e+02) (float-vector -3.1909900903701782e+02 -1.9309639930725098e+02 6.5615767240524292e+02) (float-vector -3.1073141098022461e+02 -2.9012581706047058e+02 1.4482130110263824e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.5181379914283752e+02 -3.2976949214935303e+02 1.3954970240592957e+02) (float-vector -2.2999981045722961e+02 -3.3321920037269592e+02 1.3758790493011475e+02) (float-vector -2.4389031529426575e+02 -3.3201649785041809e+02 -2.9791999622830190e-04))))
    (instance face :init :vertices (nreverse (list (float-vector -2.5181379914283752e+02 -3.2976949214935303e+02 1.3954970240592957e+02) (float-vector -2.6593640446662903e+02 -3.1660050153732300e+02 2.0808671414852142e+02) (float-vector -2.3522238433361053e+02 -3.2596951723098755e+02 2.1154521405696869e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.6593640446662903e+02 -3.1660050153732300e+02 2.0808671414852142e+02) (float-vector -2.5181379914283752e+02 -3.2976949214935303e+02 1.3954970240592957e+02) (float-vector -2.8527233004570007e+02 -3.1483760476112366e+02 1.4254909753799438e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.2999981045722961e+02 -3.3321920037269592e+02 1.3758790493011475e+02) (float-vector -2.5181379914283752e+02 -3.2976949214935303e+02 1.3954970240592957e+02) (float-vector -2.3522238433361053e+02 -3.2596951723098755e+02 2.1154521405696869e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.8527233004570007e+02 -3.1483760476112366e+02 1.4254909753799438e+02) (float-vector -2.5181379914283752e+02 -3.2976949214935303e+02 1.3954970240592957e+02) (float-vector -2.4389031529426575e+02 -3.3201649785041809e+02 -2.9791999622830190e-04) (float-vector -2.7797931432723999e+02 -3.1890380382537842e+02 -6.7372099010754027e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 2.9685312509536743e+02 -2.9019722342491150e+02 2.0282299816608429e+02) (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02) (float-vector 3.1378132104873657e+02 -2.5191199779510498e+02 2.0938129723072052e+02) (float-vector 3.1106391549110413e+02 -2.6823261380195618e+02 2.0371539890766144e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2179579138755798e+02 2.7240410447120667e+02 -5.9413400776975323e-04) (float-vector -3.2779809832572937e+02 2.5799807906150818e+02 1.4635410904884338e+02) (float-vector -3.3221191167831421e+02 2.4176590144634247e+02 1.7532501033201697e-03))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2779809832572937e+02 2.5799807906150818e+02 1.4635410904884338e+02) (float-vector -3.2179579138755798e+02 2.7240410447120667e+02 -5.9413400776975323e-04) (float-vector -3.1370639801025391e+02 2.8636670112609863e+02 1.4508250355720520e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2934990525245667e+02 1.7470601201057434e+02 6.5616780519485474e+02) (float-vector -3.2779809832572937e+02 2.5799807906150818e+02 1.4635410904884338e+02) (float-vector -3.1370639801025391e+02 2.8636670112609863e+02 1.4508250355720520e+02) (float-vector -3.1781670451164246e+02 1.9390709698200226e+02 6.5617007017135620e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.3221191167831421e+02 2.4176590144634247e+02 1.7532501033201697e-03) (float-vector -3.2779809832572937e+02 2.5799807906150818e+02 1.4635410904884338e+02) (float-vector -3.2934990525245667e+02 1.7470601201057434e+02 6.5616780519485474e+02) (float-vector -3.3568102121353149e+02 -1.2105300091207027e+01 6.5616041421890259e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.0837291479110718e+02 2.9295679926872253e+02 -1.9449001342763950e-04) (float-vector 3.0261358618736267e+02 2.9948520660400391e+02 8.9896105229854584e+01) (float-vector 2.7867612242698669e+02 3.1863850355148315e+02 9.2054396867752075e+01) (float-vector 2.8756579756736755e+02 3.1275302171707153e+02 -3.8603303664785926e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1850311160087585e+02 2.7859291434288025e+02 8.8477306067943573e+01) (float-vector 3.0261358618736267e+02 2.9948520660400391e+02 8.9896105229854584e+01) (float-vector 3.0837291479110718e+02 2.9295679926872253e+02 -1.9449001342763950e-04) (float-vector 3.2558059692382812e+02 2.6504331827163696e+02 -1.3530200249078916e-03))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2442250847816467e+02 -2.6655000448226929e+02 1.4605419337749481e+02) (float-vector -3.3258458971977234e+02 -2.3938159644603729e+02 1.4679799973964691e+02) (float-vector -3.2984331250190735e+02 -1.7271240055561066e+02 6.5617299079895020e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2984331250190735e+02 -1.7271240055561066e+02 6.5617299079895020e+02) (float-vector -3.3258458971977234e+02 -2.3938159644603729e+02 1.4679799973964691e+02) (float-vector -3.3568102121353149e+02 -1.2105300091207027e+01 6.5616041421890259e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.3568102121353149e+02 -1.2105300091207027e+01 6.5616041421890259e+02) (float-vector -3.3258458971977234e+02 -2.3938159644603729e+02 1.4679799973964691e+02) (float-vector -3.3225050568580627e+02 -2.4223959445953369e+02 6.2873600654711481e-03) (float-vector -3.3221191167831421e+02 2.4176590144634247e+02 1.7532501033201697e-03))))
    (instance face :init :vertices (nreverse (list (float-vector -3.0359700322151184e+02 -2.9891660809516907e+02 3.6203698527970118e-03) (float-vector -3.1073141098022461e+02 -2.9012581706047058e+02 1.4482130110263824e+02) (float-vector -2.8527233004570007e+02 -3.1483760476112366e+02 1.4254909753799438e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -3.0359700322151184e+02 -2.9891660809516907e+02 3.6203698527970118e-03) (float-vector -2.8527233004570007e+02 -3.1483760476112366e+02 1.4254909753799438e+02) (float-vector -2.7797931432723999e+02 -3.1890380382537842e+02 -6.7372099010754027e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 2.6038512587547302e+02 -3.1690469384193420e+02 2.0475199818611145e+02) (float-vector 2.3239700496196747e+02 -3.2586652040481567e+02 2.0497380197048187e+02) (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.3239700496196747e+02 -3.2586652040481567e+02 2.0497380197048187e+02) (float-vector 2.6038512587547302e+02 -3.1690469384193420e+02 2.0475199818611145e+02) (float-vector 2.5936490297317505e+02 -3.2758441567420959e+02 9.3793205916881561e+01) (float-vector 2.3212730884552002e+02 -3.3318969607353210e+02 9.6215099096298218e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 2.9427081346511841e+02 -3.0797940492630005e+02 9.0645603835582733e+01) (float-vector 3.1859120726585388e+02 -2.7849012613296509e+02 8.8449701666831970e+01) (float-vector 3.0749469995498657e+02 -2.9423841834068298e+02 -5.0370698545521009e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 2.8329029679298401e+02 -3.1575170159339905e+02 3.3284700862168393e-04) (float-vector 2.9427081346511841e+02 -3.0797940492630005e+02 9.0645603835582733e+01) (float-vector 3.0749469995498657e+02 -2.9423841834068298e+02 -5.0370698545521009e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 2.5936490297317505e+02 -3.2758441567420959e+02 9.3793205916881561e+01) (float-vector 2.9427081346511841e+02 -3.0797940492630005e+02 9.0645603835582733e+01) (float-vector 2.8329029679298401e+02 -3.1575170159339905e+02 3.3284700862168393e-04) (float-vector 2.5389692187309265e+02 -3.2920572161674500e+02 -4.5005103288531245e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1106391549110413e+02 -2.6823261380195618e+02 2.0371539890766144e+02) (float-vector 3.1859120726585388e+02 -2.7849012613296509e+02 8.8449701666831970e+01) (float-vector 2.9427081346511841e+02 -3.0797940492630005e+02 9.0645603835582733e+01) (float-vector 2.9685312509536743e+02 -2.9019722342491150e+02 2.0282299816608429e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.4675010144710541e+02 3.2253089547157288e+02 2.0347200334072113e+02) (float-vector 2.2307360172271729e+02 3.2685241103172302e+02 2.0513060688972473e+02) (float-vector 2.2822010517120361e+02 3.3336099982261658e+02 9.6564002335071564e+01) (float-vector 2.5065159797668457e+02 3.3002069592475891e+02 9.4568997621536255e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 2.4675010144710541e+02 3.2253089547157288e+02 2.0347200334072113e+02) (float-vector 2.7029970288276672e+02 3.1249311566352844e+02 2.0255000889301300e+02) (float-vector -2.5499999523162842e+02 2.0825119316577911e+02 6.5618342161178589e+02) (float-vector 2.2307360172271729e+02 3.2685241103172302e+02 2.0513060688972473e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.7029970288276672e+02 3.1249311566352844e+02 2.0255000889301300e+02) (float-vector 2.4675010144710541e+02 3.2253089547157288e+02 2.0347200334072113e+02) (float-vector 2.5065159797668457e+02 3.3002069592475891e+02 9.4568997621536255e+01) (float-vector 2.7867612242698669e+02 3.1863850355148315e+02 9.2054396867752075e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 3.0161580443382263e+02 2.8380560874938965e+02 2.0334188640117645e+02) (float-vector 3.0261358618736267e+02 2.9948520660400391e+02 8.9896105229854584e+01) (float-vector 3.1850311160087585e+02 2.7859291434288025e+02 8.8477306067943573e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 2.7029970288276672e+02 3.1249311566352844e+02 2.0255000889301300e+02) (float-vector 3.0161580443382263e+02 2.8380560874938965e+02 2.0334188640117645e+02) (float-vector -2.5499999523162842e+02 2.0825119316577911e+02 6.5618342161178589e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.7867612242698669e+02 3.1863850355148315e+02 9.2054396867752075e+01) (float-vector 3.0261358618736267e+02 2.9948520660400391e+02 8.9896105229854584e+01) (float-vector 3.0161580443382263e+02 2.8380560874938965e+02 2.0334188640117645e+02) (float-vector 2.7029970288276672e+02 3.1249311566352844e+02 2.0255000889301300e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.1850311160087585e+02 2.7859291434288025e+02 8.8477306067943573e+01) (float-vector 3.2872679829597473e+02 2.5509282946586609e+02 8.7569601833820343e+01) (float-vector 3.1447130441665649e+02 2.6122599840164185e+02 2.0384469628334045e+02) (float-vector 3.0161580443382263e+02 2.8380560874938965e+02 2.0334188640117645e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 3.0161580443382263e+02 2.8380560874938965e+02 2.0334188640117645e+02) (float-vector 3.1447130441665649e+02 2.6122599840164185e+02 2.0384469628334045e+02) (float-vector 3.2175451517105103e+02 2.3548789322376251e+02 2.0370259881019592e+02) (float-vector 2.9490810632705688e+02 3.3810500055551529e+01 2.9029712080955505e+02) (float-vector -2.5499999523162842e+02 2.0825119316577911e+02 6.5618342161178589e+02))))
    (instance face :init :vertices (nreverse (list (float-vector -2.3388290405273438e+02 3.3305522799491882e+02 -1.8764499998269457e-04) (float-vector -2.6282390952110291e+02 3.2623702287673950e+02 -1.2352400062809465e-03) (float-vector -2.8578719496726990e+02 3.1374549865722656e+02 -1.1697198942783871e-04) (float-vector -3.0551490187644958e+02 2.9663410782814026e+02 -5.0049504807248013e-04) (float-vector -3.2179579138755798e+02 2.7240410447120667e+02 -5.9413400776975323e-04) (float-vector -3.3221191167831421e+02 2.4176590144634247e+02 1.7532501033201697e-03) (float-vector -3.3225050568580627e+02 -2.4223959445953369e+02 6.2873600654711481e-03) (float-vector -3.2203459739685059e+02 -2.7198520302772522e+02 -3.2156899010260531e-04) (float-vector -3.0359700322151184e+02 -2.9891660809516907e+02 3.6203698527970118e-03) (float-vector -2.7797931432723999e+02 -3.1890380382537842e+02 -6.7372099010754027e-04) (float-vector -2.4389031529426575e+02 -3.3201649785041809e+02 -2.9791999622830190e-04) (float-vector 2.2956000268459320e+02 -3.3329042792320251e+02 0.0000000000000000e+00) (float-vector 2.5389692187309265e+02 -3.2920572161674500e+02 -4.5005103288531245e-04) (float-vector 2.8329029679298401e+02 -3.1575170159339905e+02 3.3284700862168393e-04) (float-vector 3.0749469995498657e+02 -2.9423841834068298e+02 -5.0370698545521009e-04) (float-vector 3.2534170150756836e+02 -2.6543480157852173e+02 2.6465600967640057e-02) (float-vector 3.3300229907035828e+02 -2.3394499719142914e+02 -2.1230600850685732e-03) (float-vector 3.3315080404281616e+02 2.3254239559173584e+02 -1.9630900283118535e-04) (float-vector 3.2558059692382812e+02 2.6504331827163696e+02 -1.3530200249078916e-03) (float-vector 3.0837291479110718e+02 2.9295679926872253e+02 -1.9449001342763950e-04) (float-vector 2.8756579756736755e+02 3.1275302171707153e+02 -3.8603303664785926e-04) (float-vector 2.6423540711402893e+02 3.2544609904289246e+02 3.6640702205659181e-04) (float-vector 2.3840849101543427e+02 3.3261021971702576e+02 -1.3229099522504839e-03))))
    (instance face :init :vertices (nreverse (list (float-vector -3.3258458971977234e+02 -2.3938159644603729e+02 1.4679799973964691e+02) (float-vector -3.2442250847816467e+02 -2.6655000448226929e+02 1.4605419337749481e+02) (float-vector -3.2203459739685059e+02 -2.7198520302772522e+02 -3.2156899010260531e-04) (float-vector -3.3225050568580627e+02 -2.4223959445953369e+02 6.2873600654711481e-03))))
    (instance face :init :vertices (nreverse (list (float-vector -3.2442250847816467e+02 -2.6655000448226929e+02 1.4605419337749481e+02) (float-vector -3.1073141098022461e+02 -2.9012581706047058e+02 1.4482130110263824e+02) (float-vector -3.0359700322151184e+02 -2.9891660809516907e+02 3.6203698527970118e-03) (float-vector -3.2203459739685059e+02 -2.7198520302772522e+02 -3.2156899010260531e-04))))
    (instance face :init :vertices (nreverse (list (float-vector 2.9427081346511841e+02 -3.0797940492630005e+02 9.0645603835582733e+01) (float-vector 2.7943021059036255e+02 -3.0593049526214600e+02 2.0310668647289276e+02) (float-vector 2.9685312509536743e+02 -2.9019722342491150e+02 2.0282299816608429e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.7943021059036255e+02 -3.0593049526214600e+02 2.0310668647289276e+02) (float-vector 2.9427081346511841e+02 -3.0797940492630005e+02 9.0645603835582733e+01) (float-vector 2.5936490297317505e+02 -3.2758441567420959e+02 9.3793205916881561e+01) (float-vector 2.6038512587547302e+02 -3.1690469384193420e+02 2.0475199818611145e+02))))
    (instance face :init :vertices (nreverse (list (float-vector 2.7943021059036255e+02 -3.0593049526214600e+02 2.0310668647289276e+02) (float-vector 2.6038512587547302e+02 -3.1690469384193420e+02 2.0475199818611145e+02) (float-vector -2.5499999523162842e+02 -2.0825691521167755e+02 6.5618073940277100e+02) (float-vector 2.9685312509536743e+02 -2.9019722342491150e+02 2.0282299816608429e+02))))
    ))
   )
  )

(defclass pr2_gkmodel0_base_bellow_link_geom0
  :super collada-body
  :slots ())
(defmethod pr2_gkmodel0_base_bellow_link_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.100000 0.100000 0.100000 1.000000))
             (list :diffuse (float-vector 0.100000 0.100000 0.100000 1.000000))
           ))
           (list :indices #i( 0 1 2 2 3 0 4 5 6 6 7 4 8 9 10 10 11 8 12 13 14 14 15 12 16 17 18 18 19 16 20 21 22 22 23 20))
           (list :vertices #2f((-1.2500000000000000e+01 -9.2500000000000000e+01 -7.5000000000000000e+01)(1.2500000000000000e+01 -9.2500000000000000e+01 -7.5000000000000000e+01)(1.2500000000000000e+01 -9.2500000000000000e+01 7.5000000000000000e+01)(-1.2500000000000000e+01 -9.2500000000000000e+01 7.5000000000000000e+01)(-1.2500000000000000e+01 9.2500000000000000e+01 7.5000000000000000e+01)(-1.2500000000000000e+01 -9.2500000000000000e+01 7.5000000000000000e+01)(1.2500000000000000e+01 -9.2500000000000000e+01 7.5000000000000000e+01)(1.2500000000000000e+01 9.2500000000000000e+01 7.5000000000000000e+01)(1.2500000000000000e+01 9.2500000000000000e+01 -7.5000000000000000e+01)(1.2500000000000000e+01 9.2500000000000000e+01 7.5000000000000000e+01)(1.2500000000000000e+01 -9.2500000000000000e+01 7.5000000000000000e+01)(1.2500000000000000e+01 -9.2500000000000000e+01 -7.5000000000000000e+01)(-1.2500000000000000e+01 -9.2500000000000000e+01 7.5000000000000000e+01)(-1.2500000000000000e+01 9.2500000000000000e+01 7.5000000000000000e+01)(-1.2500000000000000e+01 9.2500000000000000e+01 -7.5000000000000000e+01)(-1.2500000000000000e+01 -9.2500000000000000e+01 -7.5000000000000000e+01)(-1.2500000000000000e+01 -9.2500000000000000e+01 -7.5000000000000000e+01)(-1.2500000000000000e+01 9.2500000000000000e+01 -7.5000000000000000e+01)(1.2500000000000000e+01 9.2500000000000000e+01 -7.5000000000000000e+01)(1.2500000000000000e+01 -9.2500000000000000e+01 -7.5000000000000000e+01)(1.2500000000000000e+01 9.2500000000000000e+01 -7.5000000000000000e+01)(-1.2500000000000000e+01 9.2500000000000000e+01 -7.5000000000000000e+01)(-1.2500000000000000e+01 9.2500000000000000e+01 7.5000000000000000e+01)(1.2500000000000000e+01 9.2500000000000000e+01 7.5000000000000000e+01)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 24 -> 6 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (nreverse (list (float-vector -1.2500000186264515e+01 -9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 -9.2500001192092896e+01 7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 -9.2500001192092896e+01 7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 -9.2500001192092896e+01 -7.5000002980232239e+01))))
    (instance face :init :vertices (nreverse (list (float-vector -1.2500000186264515e+01 9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 9.2500001192092896e+01 7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 -9.2500001192092896e+01 7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 -9.2500001192092896e+01 -7.5000002980232239e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 1.2500000186264515e+01 9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 -9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 -9.2500001192092896e+01 -7.5000002980232239e+01))))
    (instance face :init :vertices (nreverse (list (float-vector -1.2500000186264515e+01 9.2500001192092896e+01 7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 9.2500001192092896e+01 7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 -9.2500001192092896e+01 7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 -9.2500001192092896e+01 7.5000002980232239e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 1.2500000186264515e+01 9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 9.2500001192092896e+01 7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 9.2500001192092896e+01 7.5000002980232239e+01) (float-vector -1.2500000186264515e+01 9.2500001192092896e+01 -7.5000002980232239e+01))))
    (instance face :init :vertices (nreverse (list (float-vector 1.2500000186264515e+01 9.2500001192092896e+01 7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 -9.2500001192092896e+01 -7.5000002980232239e+01) (float-vector 1.2500000186264515e+01 -9.2500001192092896e+01 7.5000002980232239e+01))))
    ))
   )
  )

(defclass pr2_gkmodel0_bl_caster_rotation_link_geom0
  :super collada-body
  :slots ())
(defmethod pr2_gkmodel0_bl_caster_rotation_link_geom0
  (:init (&key (name "package://pr2_description/meshes/base_v0/caster.stl"))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.000000 0.000000 0.000000 1.000000))
             (list :diffuse (float-vector 0.000000 0.000000 0.000000 1.000000))
           ))
           (list :indices #i( 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256 257 258 259 260 261 262 263 264 265 266 267 268 269 270 271 272 273 274 275 276 277 278 279 280 281 282 283 284 285 286 287 288 289 290 291 292 293 294 295 296 297 298 299 300 301 302 303 304 305 306 307 308 309 310 311 312 313 314 315 316 317 318 319 320 321 322 323 324 325 326 327 328 329 330 331 332 333 334 335 336 337 338 339 340 341 342 343 344 345 346 347 348 349 350 351 352 353 354 355 356 357 358 359 360 361 362 363 364 365 366 367 368 369 370 371 372 373 374 375 376 377 378 379 380 381 382 383 384 385 386 387 388 389 390 391 392 393 394 395 396 397 398 399 400 401 402 403 404 405 406 407 408 409 410 411 412 413 414 415 416 417 418 419 420 421 422 423 424 425 426 427 428 429 430 431 432 433 434 435 436 437 438 439 440 441 442 443 444 445 446 447 448 449 450 451 452 453 454 455 456 457 458 459 460 461 462 463 464 465 466 467 468 469 470 471 472 473 474 475 476 477 478 479 480 481 482 483 484 485 486 487 488 489 490 491 492 493 494 495 496 497 498 499 500 501 502 503 504 505 506 507 508 509 510 511 512 513 514 515 516 517 518 519 520 521 522 523 524 525 526 527 528 529 530 531 532 533 534 535 536 537 538 539 540 541 542 543 544 545 546 547 548 549 550 551 552 553 554 555 556 557 558 559 560 561 562 563 564 565 566 567 568 569 570 571 572 573 574 575 576 577 578 579 580 581 582 583 584 585 586 587 588 589 590 591 592 593 594 595 596 597 598 599 600 601 602 603 604 605 606 607 608 609 610 611 612 613 614 615 616 617 618 619 620 621 622 623 624 625 626 627 628 629 630 631 632 633 634 635 636 637 638 639 640 641 642 643 644 645 646 647 648 649 650 651 652 653 654 655 656 657 658 659 660 661 662 663 664 665 666 667 668 669 670 671 672 673 674 675 676 677 678 679 680 681 682 683 684 685 686 687 688 689 690 691 692 693 694 695 696 697 698 699 700 701 702 703 704 705 706 707 708 709 710 711 712 713 714 715 716 717 718 719 720 721 722 723 724 725 726 727 728 729 730 731 732 733 734 735 736 737 738 739 740 741 742 743 744 745 746 747 748 749 750 751 752 753 754 755 756 757 758 759 760 761 762 763 764 765 766 767 768 769 770 771 772 773 774 775 776 777 778 779 780 781 782 783 784 785 786 787 788 789 790 791 792 793 794 795 796 797 798 799 800 801 802 803 804 805 806 807 808 809 810 811 812 813 814 815 816 817 818 819 820 821 822 823 824 825 826 827 828 829 830 831 832 833 834 835 836 837 838 839 840 841 842 843 844 845 846 847 848 849 850 851 852 853 854 855 856 857 858 859 860 861 862 863 864 865 866 867 868 869 870 871 872 873 874 875 876 877 878 879 880 881 882 883 884 885 886 887 888 889 890 891 892 893 894 895 896 897 898 899 900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915 916 917 918 919 920 921 922 923 924 925 926 927 928 929 930 931 932 933 934 935 936 937 938 939 940 941 942 943 944 945 946 947 948 949 950 951 952 953 954 955 956 957 958 959 960 961 962 963 964 965 966 967 968 969 970 971 972 973 974 975 976 977 978 979 980 981 982 983 984 985 986 987 988 989 990 991 992 993 994 995 996 997 998 999 1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248 1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 1295 1296 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 1312 1313 1314 1315 1316 1317 1318 1319 1320 1321 1322 1323 1324 1325 1326 1327 1328 1329 1330 1331 1332 1333 1334 1335 1336 1337 1338 1339 1340 1341 1342 1343 1344 1345 1346 1347 1348 1349 1350 1351 1352 1353 1354 1355 1356 1357 1358 1359 1360 1361 1362 1363 1364 1365 1366 1367 1368 1369 1370 1371 1372 1373 1374 1375 1376 1377 1378 1379 1380 1381 1382 1383 1384 1385 1386 1387 1388 1389 1390 1391 1392 1393 1394 1395 1396 1397 1398 1399 1400 1401 1402 1403 1404 1405 1406 1407 1408 1409 1410 1411 1412 1413 1414 1415 1416 1417 1418 1419 1420 1421 1422 1423 1424 1425 1426 1427 1428 1429 1430 1431 1432 1433 1434 1435 1436 1437 1438 1439 1440 1441 1442 1443 1444 1445 1446 1447 1448 1449 1450 1451 1452 1453 1454 1455 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1473 1474 1475 1476 1477 1478 1479 1480 1481 1482 1483 1484 1485 1486 1487 1488 1489 1490 1491 1492 1493 1494 1495 1496 1497 1498 1499 1500 1501 1502 1503 1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1520 1521 1522 1523 1524 1525 1526 1527 1528 1529 1530 1531 1532 1533 1534 1535 1536 1537 1538 1539 1540 1541 1542 1543 1544 1545 1546 1547 1548 1549 1550 1551 1552 1553 1554 1555 1556 1557 1558 1559 1560 1561 1562 1563 1564 1565 1566 1567 1568 1569 1570 1571 1572 1573 1574 1575 1576 1577 1578 1579 1580 1581 1582 1583 1584 1585 1586 1587 1588 1589 1590 1591 1592 1593 1594 1595 1596 1597 1598 1599 1600 1601 1602 1603 1604 1605 1606 1607 1608 1609 1610 1611 1612 1613 1614 1615 1616 1617 1618 1619 1620 1621 1622 1623 1624 1625 1626 1627 1628 1629 1630 1631 1632 1633 1634 1635 1636 1637 1638 1639 1640 1641 1642 1643 1644 1645 1646 1647 1648 1649 1650 1651 1652 1653 1654 1655 1656 1657 1658 1659 1660 1661 1662 1663 1664 1665 1666 1667 1668 1669 1670 1671 1672 1673 1674 1675 1676 1677 1678 1679 1680 1681 1682 1683 1684 1685 1686 1687 1688 1689 1690 1691 1692 1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721 1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733 1734 1735 1736 1737 1738 1739 1740 1741 1742 1743 1744 1745 1746 1747 1748 1749 1750 1751 1752 1753 1754 1755 1756 1757 1758 1759 1760 1761 1762 1763 1764 1765 1766 1767 1768 1769 1770 1771 1772 1773 1774 1775 1776 1777 1778 1779 1780 1781 1782 1783 1784 1785 1786 1787 1788 1789 1790 1791 1792 1793 1794 1795 1796 1797 1798 1799 1800 1801 1802 1803 1804 1805 1806 1807 1808 1809 1810 1811 1812 1813 1814 1815 1816 1817 1818 1819 1820 1821 1822 1823 1824 1825 1826 1827 1828 1829 1830 1831 1832 1833 1834 1835 1836 1837 1838 1839 1840 1841 1842 1843 1844 1845 1846 1847 1848 1849 1850 1851 1852 1853 1854 1855 1856 1857 1858 1859 1860 1861 1862 1863 1864 1865 1866 1867 1868 1869 1870 1871 1872 1873 1874 1875 1876 1877 1878 1879 1880 1881 1882 1883 1884 1885 1886 1887 1888 1889 1890 1891 1892 1893 1894 1895 1896 1897 1898 1899 1900 1901 1902 1903 1904 1905 1906 1907 1908 1909 1910 1911 1912 1913 1914 1915 1916 1917 1918 1919 1920 1921 1922 1923 1924 1925 1926 1927 1928 1929 1930 1931 1932 1933 1934 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1961 1962 1963 1964 1965 1966 1967 1968 1969 1970 1971 1972 1973 1974 1975 1976 1977 1978 1979 1980 1981 1982 1983 1984 1985 1986 1987 1988 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 2023 2024 2025 2026 2027 2028 2029 2030 2031 2032 2033 2034 2035 2036 2037 2038 2039 2040 2041 2042 2043 2044 2045 2046 2047 2048 2049 2050 2051 2052 2053 2054 2055 2056 2057 2058 2059 2060 2061 2062 2063 2064 2065 2066 2067 2068 2069 2070 2071 2072 2073 2074 2075 2076 2077 2078 2079 2080 2081 2082 2083 2084 2085 2086 2087 2088 2089 2090 2091 2092 2093 2094 2095 2096 2097 2098 2099 2100 2101 2102 2103 2104 2105 2106 2107 2108 2109 2110 2111 2112 2113 2114 2115 2116 2117 2118 2119 2120 2121 2122 2123 2124 2125 2126 2127 2128 2129 2130 2131 2132 2133 2134 2135 2136 2137 2138 2139 2140 2141 2142 2143 2144 2145 2146 2147 2148 2149 2150 2151 2152 2153 2154 2155 2156 2157 2158 2159 2160 2161 2162 2163 2164 2165 2166 2167 2168 2169 2170 2171 2172 2173 2174 2175 2176 2177 2178 2179 2180 2181 2182 2183 2184 2185 2186 2187 2188 2189 2190 2191 2192 2193 2194 2195 2196 2197 2198 2199 2200 2201 2202 2203 2204 2205 2206 2207 2208 2209 2210 2211 2212 2213 2214 2215 2216 2217 2218 2219 2220 2221 2222 2223 2224 2225 2226 2227 2228 2229 2230 2231 2232 2233 2234 2235 2236 2237 2238 2239 2240 2241 2242 2243 2244 2245 2246 2247 2248 2249 2250 2251 2252 2253 2254 2255 2256 2257 2258 2259 2260 2261 2262 2263 2264 2265 2266 2267 2268 2269 2270 2271 2272 2273 2274 2275 2276 2277 2278 2279 2280 2281 2282 2283 2284 2285 2286 2287 2288 2289 2290 2291 2292 2293 2294 2295 2296 2297 2298 2299 2300 2301 2302 2303 2304 2305 2306 2307 2308 2309 2310 2311 2312 2313 2314 2315 2316 2317 2318 2319 2320 2321 2322 2323 2324 2325 2326 2327 2328 2329 2330 2331 2332 2333 2334 2335 2336 2337 2338 2339 2340 2341 2342 2343 2344 2345 2346 2347 2348 2349 2350 2351 2352 2353 2354 2355 2356 2357 2358 2359 2360 2361 2362 2363 2364 2365 2366 2367 2368 2369 2370 2371 2372 2373 2374 2375 2376 2377 2378 2379 2380 2381 2382 2383 2384 2385 2386 2387 2388 2389 2390 2391 2392 2393 2394 2395 2396 2397 2398 2399 2400 2401 2402 2403 2404 2405 2406 2407 2408 2409 2410 2411 2412 2413 2414 2415 2416 2417 2418 2419 2420 2421 2422 2423 2424 2425 2426 2427 2428 2429 2430 2431 2432 2433 2434 2435 2436 2437 2438 2439 2440 2441 2442 2443 2444 2445 2446 2447 2448 2449 2450 2451 2452 2453 2454 2455 2456 2457 2458 2459 2460 2461 2462 2463 2464 2465 2466 2467 2468 2469 2470 2471 2472 2473 2474 2475 2476 2477 2478 2479 2480 2481 2482 2483 2484 2485 2486 2487 2488 2489 2490 2491 2492 2493 2494 2495 2496 2497 2498 2499 2500 2501 2502 2503 2504 2505 2506 2507 2508 2509 2510 2511 2512 2513 2514 2515 2516 2517 2518 2519 2520 2521 2522 2523 2524 2525 2526 2527 2528 2529 2530 2531 2532 2533 2534 2535 2536 2537 2538 2539 2540 2541 2542 2543 2544 2545 2546 2547 2548 2549 2550 2551 2552 2553 2554 2555 2556 2557 2558 2559 2560 2561 2562 2563 2564 2565 2566 2567 2568 2569 2570 2571 2572 2573 2574 2575 2576 2577 2578 2579 2580 2581 2582 2583 2584 2585 2586 2587 2588 2589 2590 2591 2592 2593 2594 2595 2596 2597 2598 2599 2600 2601 2602 2603 2604 2605 2606 2607 2608 2609 2610 2611 2612 2613 2614 2615 2616 2617 2618 2619 2620 2621 2622 2623 2624 2625 2626 2627 2628 2629 2630 2631 2632 2633 2634 2635 2636 2637 2638 2639 2640 2641 2642 2643 2644 2645 2646 2647 2648 2649 2650 2651 2652 2653 2654 2655 2656 2657 2658 2659 2660 2661 2662 2663 2664 2665 2666 2667 2668 2669 2670 2671 2672 2673 2674 2675 2676 2677 2678 2679 2680 2681 2682 2683 2684 2685 2686 2687 2688 2689 2690 2691 2692 2693 2694 2695 2696 2697 2698 2699 2700 2701 2702 2703 2704 2705 2706 2707 2708 2709 2710 2711 2712 2713 2714 2715 2716 2717 2718 2719 2720 2721 2722 2723 2724 2725 2726 2727 2728 2729 2730 2731 2732 2733 2734 2735 2736 2737 2738 2739 2740 2741 2742 2743 2744 2745 2746 2747 2748 2749 2750 2751 2752 2753 2754 2755 2756 2757 2758 2759 2760 2761 2762 2763 2764 2765 2766 2767 2768 2769 2770 2771 2772 2773 2774 2775 2776 2777 2778 2779 2780 2781 2782 2783 2784 2785 2786 2787 2788 2789 2790 2791 2792 2793 2794 2795 2796 2797 2798 2799 2800 2801 2802 2803 2804 2805 2806 2807 2808 2809 2810 2811 2812 2813 2814 2815 2816 2817 2818 2819 2820 2821 2822 2823 2824 2825 2826 2827 2828 2829 2830 2831 2832 2833 2834 2835 2836 2837 2838 2839 2840 2841 2842 2843 2844 2845 2846 2847 2848 2849 2850 2851 2852 2853 2854 2855 2856 2857 2858 2859 2860 2861 2862 2863 2864 2865 2866 2867 2868 2869 2870 2871 2872 2873 2874 2875 2876 2877 2878 2879 2880 2881 2882 2883 2884 2885 2886 2887 2888 2889 2890 2891 2892 2893 2894 2895 2896 2897 2898 2899 2900 2901 2902 2903 2904 2905 2906 2907 2908 2909 2910 2911 2912 2913 2914 2915 2916 2917 2918 2919 2920 2921 2922 2923 2924 2925 2926 2927 2928 2929 2930 2931 2932 2933 2934 2935 2936 2937 2938 2939 2940 2941 2942 2943 2944 2945 2946 2947 2948 2949 2950 2951 2952 2953 2954 2955 2956 2957 2958 2959 2960 2961 2962 2963 2964 2965 2966 2967 2968 2969 2970 2971 2972 2973 2974 2975 2976 2977 2978 2979 2980 2981 2982 2983 2984 2985 2986 2987 2988 2989 2990 2991 2992 2993 2994 2995 2996 2997 2998 2999))
           (list :vertices #2f((-7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-5.7104511260986328e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(3.3114341735839844e+01 6.7340042114257812e+01 1.6125001525878906e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(3.4291679382324219e+01 6.6874122619628906e+01 1.6774981689453125e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-4.1857151031494141e+01 3.2210327148437500e+01 1.6124998474121094e+02)(-4.7847377777099609e+01 2.2162990570068359e+01 1.6124998474121094e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(9.2097923278808594e+01 -1.5517567634582520e+01 1.3049993896484375e+02)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(-8.2111740112304688e+01 -2.5678712844848633e+01 3.0747336149215698e-01)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(7.1031112670898438e+00 -8.3500007629394531e+01 -2.6709621429443359e+01)(4.3381810188293457e+00 -8.6500015258789062e+01 -2.7369834899902344e+01)(-4.1763257980346680e+00 -8.3499992370605469e+01 -2.7412359237670898e+01)(-3.8026851654052734e+01 6.5685386657714844e+01 1.3050004577636719e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.3050000000000000e+02)(-2.8861297607421875e+01 5.4849514007568359e+01 1.3050000000000000e+02)(-4.1763257980346680e+00 -8.3499992370605469e+01 -2.7412359237670898e+01)(4.3381810188293457e+00 -8.6500015258789062e+01 -2.7369834899902344e+01)(-7.4371280670166016e+00 -8.6499816894531250e+01 -2.6638793945312500e+01)(-4.0644512176513672e+01 6.3066162109375000e+01 1.6774998474121094e+02)(-3.1505632400512695e+01 6.8185791015625000e+01 1.6774995422363281e+02)(-4.1010608673095703e+01 6.2885150909423828e+01 1.6125006103515625e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(6.2567764282226562e+01 -4.1499729156494141e+01 1.6774975585937500e+02)(6.7764801025390625e+01 -3.2242206573486328e+01 1.6774996948242188e+02)(7.4046676635742188e+01 1.4005400657653809e+01 -1.4996746063232422e+01)(7.3850120544433594e+01 1.6310745239257812e+01 -3.0784076690673828e+01)(7.3756309509277344e+01 1.6941520690917969e+01 1.8675678253173828e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-8.3488998413085938e+01 2.5188650131225586e+01 1.3050068664550781e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.3050000000000000e+02)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(-5.9516044616699219e+01 -4.5807617187500000e+01 1.6775001525878906e+02)(-4.7637077331542969e+01 -5.8130901336669922e+01 1.6774990844726562e+02)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 4.1612411499023438e+01)(-9.0112968444824219e+01 -1.8593845367431641e+01 6.5114234924316406e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 1.3050000000000000e+02)(-9.3238922119140625e+01 5.9731507301330566e+00 1.3050001525878906e+02)(-9.1357238769531250e+01 1.9070823669433594e+01 1.3049990844726562e+02)(1.9489873886108398e+01 8.6499641418457031e+01 -1.9362747192382812e+01)(2.7500000000000000e+01 8.6500000000000000e+01 -1.1368683772161603e-13)(2.5842729568481445e+01 8.6500991821289062e+01 -1.0067432403564453e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-1.8142257690429688e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(7.0318603515625000e+01 -2.2694311141967773e+01 1.3049975585937500e+02)(8.8046340942382812e+01 -3.1130365371704102e+01 1.3049987792968750e+02)(6.6933624267578125e+01 -2.5024982452392578e+01 1.3050001525878906e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-4.9750961303710938e+01 6.2188003540039062e+01 1.3050000000000000e+02)(7.4068229675292969e+01 -1.4006268501281738e+01 1.0571428537368774e+00)(7.4046676635742188e+01 -2.1977169513702393e+00 9.4352531433105469e+00)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.4046676635742188e+01 1.4005400657653809e+01 3.6297683715820312e+01)(7.4046676635742188e+01 -2.1977169513702393e+00 9.4352531433105469e+00)(7.4046676635742188e+01 1.4005400657653809e+01 1.2649586677551270e+01)(6.2293994903564453e+01 -4.1157024383544922e+01 1.5720001220703125e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(6.6161926269531250e+01 -3.4574485778808594e+01 1.5720005798339844e+02)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(6.7951301574707031e+01 2.4542978286743164e+01 -3.1770818710327148e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 1.3050000000000000e+02)(-9.0747459411621094e+01 1.6444686889648438e+01 1.3050000000000000e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 1.2425885772705078e+02)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(-8.5705986022949219e+01 2.4004983901977539e+01 6.3944019317626953e+01)(-8.7431739807128906e+01 2.2651365280151367e+01 1.2877049255371094e+02)(-8.7511779785156250e+01 -2.2489559173583984e+01 8.8908607482910156e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 6.0335853576660156e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 1.0792460632324219e+02)(-8.7535324096679688e+01 2.2457002639770508e+01 -3.1769830703735352e+01)(-8.9515121459960938e+01 1.9935207366943359e+01 -3.1769947052001953e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 -1.1735793352127075e+00)(-8.5023956298828125e+01 -2.4399049758911133e+01 7.9142021179199219e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 1.0670562744140625e+02)(-8.5021507263183594e+01 -2.4398166656494141e+01 1.3050000000000000e+02)(-8.7431739807128906e+01 2.2651365280151367e+01 1.2877049255371094e+02)(-8.5705986022949219e+01 2.4004983901977539e+01 6.3944019317626953e+01)(-8.8356018066406250e+01 2.1567317962646484e+01 8.0790237426757812e+01)(6.8042007446289062e+01 2.4402191162109375e+01 4.8799829483032227e+00)(6.6635116577148438e+01 2.5095191955566406e+01 3.4834915161132812e+01)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 8.6714447021484375e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 7.4841636657714844e+01)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 1.4843739509582520e+01)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.0446272277832031e+02)(-8.0589691162109375e+01 2.5904277801513672e+01 8.6714447021484375e+01)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(7.2823318481445312e+01 1.9345205307006836e+01 3.9796138763427734e+01)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.8246543407440186e+00)(-8.5023956298828125e+01 -2.4399051666259766e+01 -2.5528682708740234e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(6.6635116577148438e+01 2.5095191955566406e+01 7.6718864440917969e+01)(6.8042015075683594e+01 2.4402191162109375e+01 1.0512095642089844e+02)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(6.8199630737304688e+01 -2.4393993377685547e+01 1.2817570495605469e+02)(6.4828872680664062e+01 -2.5737499237060547e+01 6.9435493469238281e+01)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(5.6568344116210938e+01 -4.8854415893554688e+01 1.3346562194824219e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 9.8720527648925781e+01)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(-2.7500000000000000e+01 8.6500000000000000e+01 2.3751937866210938e+01)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-3.8026851654052734e+01 6.5685386657714844e+01 1.3050004577636719e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3050000000000000e+02)(7.0774162292480469e+01 -2.2258674621582031e+01 -3.1769689559936523e+01)(7.3644508361816406e+01 -1.7455656051635742e+01 -3.1769245147705078e+01)(7.2512092590332031e+01 -1.9999502182006836e+01 -3.1132726669311523e+01)(5.7097816467285156e+01 4.8688312530517578e+01 1.6774993896484375e+02)(5.1484649658203125e+01 5.4627273559570312e+01 1.6125001525878906e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(9.6112070083618164e+00 5.1957012176513672e+01 1.6125001525878906e+02)(3.3114341735839844e+01 6.7340042114257812e+01 1.6125001525878906e+02)(7.0053070068359375e+01 2.5780675888061523e+01 1.3346554565429688e+02)(6.8471626281738281e+01 2.9723161697387695e+01 1.5719995117187500e+02)(7.1889564514160156e+01 2.0188781738281250e+01 1.5719985961914062e+02)(8.1439865112304688e+01 4.6165725708007812e+01 1.3346539306640625e+02)(7.4986404418945312e+01 5.7029747009277344e+01 1.3346551513671875e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(8.0546951293945312e+00 -7.4603233337402344e+01 1.6125000000000000e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(7.5782341003417969e+01 5.5891242980957031e+01 1.3050004577636719e+02)(7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(7.4986404418945312e+01 5.7029747009277344e+01 1.3346551513671875e+02)(3.6877834320068359e+01 6.4938354492187500e+01 1.3050019836425781e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.3050000000000000e+02)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(-4.8890350341796875e+01 5.6930206298828125e+01 1.6775000000000000e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-4.0644512176513672e+01 6.3066162109375000e+01 1.6774998474121094e+02)(-7.8516853332519531e+01 5.1479923248291016e+01 1.3346551513671875e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-2.1306856155395508e+01 7.1962928771972656e+01 1.6774993896484375e+02)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-2.1266397476196289e+01 7.2026412963867188e+01 1.6125006103515625e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(7.8696449279785156e+01 -5.1277267456054688e+01 1.3049996948242188e+02)(8.1294532775878906e+01 -4.6588893890380859e+01 1.3346530151367188e+02)(-9.0644447326660156e+01 1.7214775085449219e+01 -2.9394233703613281e+01)(-8.9419967651367188e+01 2.0000736236572266e+01 9.4558744430541992e+00)(-8.9515121459960938e+01 1.9935207366943359e+01 -3.1769947052001953e+01)(1.4429249763488770e+01 -5.0916908264160156e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.5719999694824219e+02)(4.1793392181396484e+01 -6.1974334716796875e+01 1.5719990539550781e+02)(6.8085754394531250e+01 -3.0548526763916016e+01 1.3435859680175781e+02)(7.0440612792968750e+01 -2.4795007705688477e+01 1.5719992065429688e+02)(6.6161926269531250e+01 -3.4574485778808594e+01 1.5720005798339844e+02)(-8.9594100952148438e+01 -2.6176630020141602e+01 1.3346551513671875e+02)(-8.9825271606445312e+01 -2.5200748443603516e+01 1.3050000000000000e+02)(-8.5401557922363281e+01 -3.7751152038574219e+01 1.3050007629394531e+02)(-5.7104511260986328e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-6.6067413330078125e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(1.6159154891967773e+01 -8.3500167846679688e+01 -2.2321565628051758e+01)(7.1031112670898438e+00 -8.3500007629394531e+01 -2.6709621429443359e+01)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-5.7789394378662109e+01 5.2736637115478516e+01 1.5719996643066406e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(-8.4838142395019531e+01 3.8973972320556641e+01 1.3346549987792969e+02)(-7.8516853332519531e+01 5.1479923248291016e+01 1.3346551513671875e+02)(-8.5377494812011719e+01 1.4220652580261230e+01 1.3346554565429688e+02)(-8.5449035644531250e+01 1.3931497573852539e+01 1.5719975280761719e+02)(-8.2037071228027344e+01 2.2562515258789062e+01 1.5719989013671875e+02)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(-2.6133790969848633e+01 8.3499389648437500e+01 -9.0429000854492188e+00)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(-2.7500000000000000e+01 8.3500000000000000e+01 3.2684965844964609e-13)(-8.5866577148437500e+01 -1.2403345108032227e+01 1.5719999694824219e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(-8.6333305358886719e+01 -1.0644967079162598e+01 1.3346554565429688e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(7.0521041870117188e+01 -2.4467180252075195e+01 1.3346548461914062e+02)(8.9427154541015625e+01 -2.6915592193603516e+01 1.3346551513671875e+02)(5.6568344116210938e+01 -4.8854415893554688e+01 1.3346562194824219e+02)(5.6767070770263672e+01 -4.8697395324707031e+01 1.5720005798339844e+02)(4.8286041259765625e+01 -5.7161788940429688e+01 1.3346569824218750e+02)(4.3381810188293457e+00 -8.6500015258789062e+01 -2.7369834899902344e+01)(-1.6159154891967773e+01 -8.6499969482421875e+01 -2.2321565628051758e+01)(-7.4371280670166016e+00 -8.6499816894531250e+01 -2.6638793945312500e+01)(5.6767070770263672e+01 -4.8697395324707031e+01 1.5720005798339844e+02)(5.6568344116210938e+01 -4.8854415893554688e+01 1.3346562194824219e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(-7.3600654602050781e+01 -3.6235103607177734e+01 1.5719989013671875e+02)(-6.8931365966796875e+01 -4.1853664398193359e+01 1.5719999694824219e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(6.9582809448242188e+01 2.3433988571166992e+01 -2.7056911468505859e+01)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(-8.9336181640625000e+01 2.6993732452392578e+01 1.3346551513671875e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(-8.5377494812011719e+01 1.4220652580261230e+01 1.3346554565429688e+02)(9.3551139831542969e+01 2.4151535034179688e+00 1.3050006103515625e+02)(9.3040290832519531e+01 8.5211200714111328e+00 1.3346542358398438e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(-3.1974423109204508e-13 -7.5000000000000000e+01 1.6125000000000000e+02)(8.0546951293945312e+00 -7.4603233337402344e+01 1.6125000000000000e+02)(-2.0086696520503489e-13 -7.5000000000000000e+01 1.6775000000000000e+02)(-5.9516044616699219e+01 -4.5807617187500000e+01 1.6775001525878906e+02)(-6.6849647521972656e+01 -3.4149829864501953e+01 1.6775000000000000e+02)(-6.6812088012695312e+01 -3.4464725494384766e+01 1.6125024414062500e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 6.4571784973144531e+01)(-9.0820014953613281e+01 1.6348896026611328e+01 9.7063537597656250e+01)(-9.0635910034179688e+01 1.7232580184936523e+01 5.5033313751220703e+01)(1.9489873886108398e+01 8.6499641418457031e+01 -1.9362747192382812e+01)(2.2083520889282227e+01 8.3499839782714844e+01 -1.6511587142944336e+01)(1.4446233749389648e+01 8.3500373840332031e+01 -2.3352657318115234e+01)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(-4.7637077331542969e+01 -5.8130901336669922e+01 1.6774990844726562e+02)(-3.8157699584960938e+01 -6.4664611816406250e+01 1.6124998474121094e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.0446272277832031e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 8.6714447021484375e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 1.0231732177734375e+02)(7.3222488403320312e+01 -1.8595720291137695e+01 6.2816463470458984e+01)(6.9582809448242188e+01 2.3433988571166992e+01 -2.7056911468505859e+01)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(6.8042007446289062e+01 2.4402191162109375e+01 4.8799829483032227e+00)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(6.3611633300781250e+01 2.5904483795166016e+01 1.0519409179687500e+02)(6.5149871826171875e+01 2.5598823547363281e+01 1.0546226501464844e+02)(-9.0616600036621094e+01 -1.7108596801757812e+01 1.2893971252441406e+02)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(-9.0112968444824219e+01 -1.8593845367431641e+01 1.0339002227783203e+02)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 2.6005401611328125e+01 1.1820683479309082e+01)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(-8.6330505371093750e+01 -2.3525917053222656e+01 6.0335853576660156e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-8.5023956298828125e+01 -2.4399049758911133e+01 7.9142021179199219e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 4.4208824157714844e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 6.4571784973144531e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(-2.7031339645385742e+01 -4.5309486389160156e+01 1.5720002746582031e+02)(-3.0599491119384766e+01 -4.2939529418945312e+01 1.6125004577636719e+02)(-3.6651382446289062e+01 -3.7997226715087891e+01 1.5719999694824219e+02)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(-9.0607328414916992e+00 -7.4531417846679688e+01 1.6774998474121094e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(-2.6133790969848633e+01 8.3499389648437500e+01 -9.0429000854492188e+00)(-2.4658794403076172e+01 8.6499664306640625e+01 -1.2483454704284668e+01)(-1.8946477890014648e+01 8.3499221801757812e+01 -1.9983108520507812e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(-8.1325523376464844e+01 2.4076435089111328e+01 1.3346548461914062e+02)(-8.9336181640625000e+01 2.6993732452392578e+01 1.3346551513671875e+02)(-8.5377494812011719e+01 1.4220652580261230e+01 1.3346554565429688e+02)(-5.7104511260986328e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(7.5782341003417969e+01 5.5891242980957031e+01 1.3050004577636719e+02)(7.4986404418945312e+01 5.7029747009277344e+01 1.3346551513671875e+02)(8.1439865112304688e+01 4.6165725708007812e+01 1.3346539306640625e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 -6.9758973121643066e+00)(7.1889564514160156e+01 2.0188781738281250e+01 1.5719985961914062e+02)(7.2840324401855469e+01 1.6688291549682617e+01 1.3346591186523438e+02)(7.0053070068359375e+01 2.5780675888061523e+01 1.3346554565429688e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 6.1463169097900391e+01)(-2.7500000000000000e+01 8.3500000000000000e+01 3.2684965844964609e-13)(2.7500000000000000e+01 8.3500000000000000e+01 -8.5265128291212022e-14)(-8.1410614013671875e+01 -2.5793256759643555e+01 1.2857640075683594e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-8.3610725402832031e+01 -2.5091253280639648e+01 1.3050000000000000e+02)(-4.7847377777099609e+01 2.2162990570068359e+01 1.6124998474121094e+02)(-4.4190227508544922e+01 2.8773574829101562e+01 1.5719999694824219e+02)(-4.9812393188476562e+01 1.7215398788452148e+01 1.5719989013671875e+02)(-2.7711166694643907e-13 7.5000000000000000e+01 1.6125000000000000e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(8.3348693847656250e+00 7.4622276306152344e+01 1.6124992370605469e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(7.4096588134765625e+01 -1.1731911659240723e+01 1.6774995422363281e+02)(7.4476074218750000e+01 9.6094312667846680e+00 1.6775006103515625e+02)(9.3040290832519531e+01 8.5211200714111328e+00 1.3346542358398438e+02)(9.3551139831542969e+01 2.4151535034179688e+00 1.3050006103515625e+02)(9.0297088623046875e+01 2.3851243972778320e+01 1.3050001525878906e+02)(-5.2769325256347656e+01 -1.2287213802337646e+00 1.6124995422363281e+02)(-5.2768165588378906e+01 -1.1368683772161603e-13 1.5719999694824219e+02)(-5.1959529876708984e+01 -9.1832647323608398e+00 1.5720005798339844e+02)(7.1889564514160156e+01 2.0188781738281250e+01 1.5719985961914062e+02)(4.1449623107910156e+01 3.2505737304687500e+01 1.5720005798339844e+02)(7.4012634277343750e+01 1.0421646118164062e+01 1.5719998168945312e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.3050000000000000e+02)(-2.6133790969848633e+01 8.3499389648437500e+01 -9.0429000854492188e+00)(-1.8946477890014648e+01 8.3499221801757812e+01 -1.9983108520507812e+01)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(4.5799865722656250e+01 -5.9457805633544922e+01 1.6774998474121094e+02)(3.3510765075683594e+01 -6.7240554809570312e+01 1.6774996948242188e+02)(3.5773017883300781e+01 -6.6016731262207031e+01 1.6125003051757812e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 2.3751937866210938e+01)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(-2.7500000000000000e+01 8.6500000000000000e+01 3.5527136788005009e-13)(-9.1023178100585938e+01 1.4005400657653809e+01 6.4571784973144531e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 1.2425885772705078e+02)(-9.0820014953613281e+01 1.6348896026611328e+01 9.7063537597656250e+01)(5.6568344116210938e+01 -4.8854415893554688e+01 1.3346562194824219e+02)(4.8286041259765625e+01 -5.7161788940429688e+01 1.3346569824218750e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 7.6523834228515625e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(6.4828872680664062e+01 -2.5737499237060547e+01 6.9435493469238281e+01)(-3.6651382446289062e+01 -3.7997226715087891e+01 1.5719999694824219e+02)(-4.3893966674804688e+01 -2.9079030990600586e+01 1.5720005798339844e+02)(-5.4540454864501953e+01 -5.5304397583007812e+01 1.5719999694824219e+02)(9.6112070083618164e+00 5.1957012176513672e+01 1.6125001525878906e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(-4.2277292777725961e-13 5.2680000305175781e+01 1.5719999694824219e+02)(4.9515712738037109e+01 5.5933147430419922e+01 1.5719999694824219e+02)(4.3751384735107422e+01 6.0545715332031250e+01 1.5719996643066406e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(-5.1334136962890625e+01 -1.2050828933715820e+01 1.6125003051757812e+02)(-6.6812088012695312e+01 -3.4464725494384766e+01 1.6125024414062500e+02)(-7.1687973022460938e+01 -2.2238489151000977e+01 1.6125004577636719e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 9.8720527648925781e+01)(2.7500000000000000e+01 8.6500000000000000e+01 7.7052558898925781e+01)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-2.2035116195678711e+01 -7.1864418029785156e+01 1.6124995422363281e+02)(-3.0599491119384766e+01 -4.2939529418945312e+01 1.6125004577636719e+02)(-1.4446232795715332e+01 8.6499740600585938e+01 -2.3352657318115234e+01)(-1.8946477890014648e+01 8.3499221801757812e+01 -1.9983108520507812e+01)(-2.0128026962280273e+01 8.6499954223632812e+01 -1.8719894409179688e+01)(-7.3863143920898438e+01 -1.3130586624145508e+01 1.6125001525878906e+02)(-5.1334136962890625e+01 -1.2050828933715820e+01 1.6125003051757812e+02)(-7.1687973022460938e+01 -2.2238489151000977e+01 1.6125004577636719e+02)(7.1929275512695312e+01 2.1703926086425781e+01 1.6125033569335938e+02)(4.9453201293945312e+01 1.8237962722778320e+01 1.6124995422363281e+02)(4.4417877197265625e+01 2.8603290557861328e+01 1.6125006103515625e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(7.4961767196655273e+00 -7.4684196472167969e+01 1.6775001525878906e+02)(8.0546951293945312e+00 -7.4603233337402344e+01 1.6125000000000000e+02)(3.8522853851318359e+01 -6.3928745269775391e+01 1.3584690856933594e+02)(3.3190704345703125e+01 -6.6912818908691406e+01 1.3050000000000000e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-2.5388035857637492e-13 7.5000000000000000e+01 1.6775000000000000e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(-2.7711166694643907e-13 7.5000000000000000e+01 1.6125000000000000e+02)(-7.4968612670898438e+01 -3.4747965335845947e+00 1.6125009155273438e+02)(-7.3863143920898438e+01 -1.3130586624145508e+01 1.6125001525878906e+02)(-7.4802711486816406e+01 -6.3990607261657715e+00 1.6774998474121094e+02)(2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 8.8271492004394531e+01)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(-7.0092063903808594e+01 -4.0707054138183594e+01 1.3346559143066406e+02)(-8.2998054504394531e+01 -4.3143230438232422e+01 1.3346554565429688e+02)(-3.1974423109204508e-13 -7.5000000000000000e+01 1.6125000000000000e+02)(-2.0086696520503489e-13 -7.5000000000000000e+01 1.6775000000000000e+02)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-1.4446232795715332e+01 8.6499740600585938e+01 -2.3352657318115234e+01)(-8.1101541519165039e+00 8.3499954223632812e+01 -2.6377056121826172e+01)(-1.8946477890014648e+01 8.3499221801757812e+01 -1.9983108520507812e+01)(9.0933486938476562e+01 2.1264158248901367e+01 1.3346549987792969e+02)(9.3040290832519531e+01 8.5211200714111328e+00 1.3346542358398438e+02)(9.0297088623046875e+01 2.3851243972778320e+01 1.3050001525878906e+02)(-3.4647197723388672e+01 -6.7212234497070312e+01 1.5719995117187500e+02)(-2.7031339645385742e+01 -4.5309486389160156e+01 1.5720002746582031e+02)(-3.6651382446289062e+01 -3.7997226715087891e+01 1.5719999694824219e+02)(8.1439865112304688e+01 4.6165725708007812e+01 1.3346539306640625e+02)(8.3728973388671875e+01 4.1508079528808594e+01 1.3050010681152344e+02)(7.5782341003417969e+01 5.5891242980957031e+01 1.3050004577636719e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(3.8522853851318359e+01 -6.3928745269775391e+01 1.3584690856933594e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(9.0297088623046875e+01 2.3851243972778320e+01 1.3050001525878906e+02)(8.6536094665527344e+01 3.4835777282714844e+01 1.3346551513671875e+02)(9.0933486938476562e+01 2.1264158248901367e+01 1.3346549987792969e+02)(-8.1325523376464844e+01 2.4076435089111328e+01 1.3346548461914062e+02)(-8.5377494812011719e+01 1.4220652580261230e+01 1.3346554565429688e+02)(-8.2037071228027344e+01 2.2562515258789062e+01 1.5719989013671875e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-6.3077995300292969e+01 4.0631622314453125e+01 1.6774984741210938e+02)(-6.7835960388183594e+01 3.2077857971191406e+01 1.6774998474121094e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-4.4923904418945312e+01 -6.1877056121826172e+01 1.5719998168945312e+02)(-4.8918796539306641e+01 -5.9330558776855469e+01 1.3346546936035156e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(-5.9879058837890625e+01 -5.0929645538330078e+01 1.3346559143066406e+02)(-7.0092063903808594e+01 -4.0707054138183594e+01 1.3346559143066406e+02)(-1.8142257690429688e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 8.4837234497070312e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.1820683479309082e+01)(-8.1801506042480469e+01 -2.3221632003784180e+01 1.5719999694824219e+02)(-7.8303855895996094e+01 -2.9375566482543945e+01 1.3346548461914062e+02)(-7.3600654602050781e+01 -3.6235103607177734e+01 1.5719989013671875e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 -1.4210854715202004e-13)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(2.7500000000000000e+01 -8.6500000000000000e+01 3.4884891510009766e+01)(-7.2402847290039062e+01 -2.0073417663574219e+01 1.6775000000000000e+02)(-7.4802711486816406e+01 -6.3990607261657715e+00 1.6774998474121094e+02)(-7.3863143920898438e+01 -1.3130586624145508e+01 1.6125001525878906e+02)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(4.3381810188293457e+00 -8.6500015258789062e+01 -2.7369834899902344e+01)(1.3515126228332520e+01 -8.6500030517578125e+01 -2.3961565017700195e+01)(5.2745903015136719e+01 -3.9014687538146973e+00 1.6124996948242188e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(4.9716709136962891e+01 -1.7735923767089844e+01 1.6125000000000000e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(7.3951889038085938e+01 -1.5548828125000000e+01 1.2715247344970703e+02)(-8.2998054504394531e+01 -4.3143230438232422e+01 1.3346554565429688e+02)(-8.0403465270996094e+01 -4.7990089416503906e+01 1.3049998474121094e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(7.4476074218750000e+01 9.6094312667846680e+00 1.6775006103515625e+02)(7.5009902954101562e+01 -2.8366594314575195e+00 1.6775000000000000e+02)(7.4678085327148438e+01 7.8352298736572266e+00 1.6124992370605469e+02)(-6.3077995300292969e+01 4.0631622314453125e+01 1.6774984741210938e+02)(-5.7060512542724609e+01 4.8739387512207031e+01 1.6774998474121094e+02)(-6.2900997161865234e+01 4.1064804077148438e+01 1.6125006103515625e+02)(-5.4540454864501953e+01 -5.5304397583007812e+01 1.5719999694824219e+02)(-4.4923904418945312e+01 -6.1877056121826172e+01 1.5719998168945312e+02)(-3.6651382446289062e+01 -3.7997226715087891e+01 1.5719999694824219e+02)(7.1186248779296875e+01 -2.1818662643432617e+01 1.2777687835693359e+02)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(7.0318603515625000e+01 -2.2694311141967773e+01 1.3049975585937500e+02)(-5.7800388336181641e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-4.9750961303710938e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-4.7847377777099609e+01 2.2162990570068359e+01 1.6124998474121094e+02)(3.1197740554809570e+01 6.7802062988281250e+01 1.5719993591308594e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.5719999694824219e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(8.9427154541015625e+01 -2.6915592193603516e+01 1.3346551513671875e+02)(8.1294532775878906e+01 -4.6588893890380859e+01 1.3346530151367188e+02)(8.8046340942382812e+01 -3.1130365371704102e+01 1.3049987792968750e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(5.5273727416992188e+01 5.0349800109863281e+01 1.3346554565429688e+02)(6.1565635681152344e+01 4.2239334106445312e+01 1.3346557617187500e+02)(-4.4190227508544922e+01 2.8773574829101562e+01 1.5719999694824219e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(-4.9812393188476562e+01 1.7215398788452148e+01 1.5719989013671875e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(-8.7486099243164062e+01 -3.1490042209625244e+00 1.3346559143066406e+02)(-8.6333305358886719e+01 -1.0644967079162598e+01 1.3346554565429688e+02)(3.4291679382324219e+01 6.6874122619628906e+01 1.6774981689453125e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(2.2981338500976562e+01 7.1454238891601562e+01 1.6774993896484375e+02)(7.1680549621582031e+01 2.1239969253540039e+01 7.7994125366210938e+01)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(7.2823318481445312e+01 1.9345205307006836e+01 3.9796138763427734e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(6.4391571044921875e+01 -2.5801553726196289e+01 -1.7952758789062500e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(7.4068229675292969e+01 -1.4006268501281738e+01 1.0571428537368774e+00)(7.3644508361816406e+01 -1.7455656051635742e+01 -3.1769245147705078e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.3050000000000000e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.0417015838623047e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.1235576629638672e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 -3.0209545135498047e+01)(-8.6321174621582031e+01 -2.3537843704223633e+01 -2.8051286697387695e+01)(-8.5844612121582031e+01 -2.3929893493652344e+01 -3.1769815444946289e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 -2.5528682708740234e+01)(7.2502433776855469e+01 -2.0005266189575195e+01 9.4783348083496094e+01)(7.3639289855957031e+01 -1.7111631393432617e+01 9.8489746093750000e+01)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(6.7951301574707031e+01 2.4542978286743164e+01 -3.1770818710327148e+01)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(6.9582809448242188e+01 2.3433988571166992e+01 -2.7056911468505859e+01)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(-9.0112968444824219e+01 -1.8593845367431641e+01 1.0339002227783203e+02)(-8.9419967651367188e+01 -2.0000736236572266e+01 7.7060180664062500e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-8.2111740112304688e+01 -2.5678712844848633e+01 3.0747336149215698e-01)(-8.2073081970214844e+01 -2.5667484283447266e+01 3.7937202453613281e+01)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(-8.7431739807128906e+01 2.2651365280151367e+01 1.2877049255371094e+02)(-8.3488998413085938e+01 2.5188650131225586e+01 1.3050068664550781e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 -6.9758973121643066e+00)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 6.5488034486770630e-01)(-9.0714019775390625e+01 1.7007638931274414e+01 1.3307831764221191e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-8.9419967651367188e+01 2.0000736236572266e+01 9.4558744430541992e+00)(-9.0112968444824219e+01 -1.8593845367431641e+01 6.5114234924316406e+01)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-8.9419967651367188e+01 -2.0000736236572266e+01 7.7060180664062500e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 5.6142581939697266e+01)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-8.5705986022949219e+01 2.4004983901977539e+01 6.3944019317626953e+01)(7.3644508361816406e+01 -1.7455656051635742e+01 -3.1769245147705078e+01)(7.3639289855957031e+01 -1.7111631393432617e+01 -1.1437340736389160e+01)(7.2512092590332031e+01 -1.9999502182006836e+01 -3.1132726669311523e+01)(-4.1010608673095703e+01 6.2885150909423828e+01 1.6125006103515625e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-4.8890350341796875e+01 5.6930206298828125e+01 1.6775000000000000e+02)(-8.7273971557617188e+01 -2.2735280990600586e+01 1.3049960327148438e+02)(-8.6330505371093750e+01 -2.3525917053222656e+01 1.0792460632324219e+02)(-8.5021507263183594e+01 -2.4398166656494141e+01 1.3050000000000000e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(9.2097923278808594e+01 -1.5517567634582520e+01 1.3049993896484375e+02)(9.3551139831542969e+01 2.4151535034179688e+00 1.3050006103515625e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(-2.7500000000000000e+01 -8.3500000000000000e+01 5.8841522216796875e+01)(-2.7500000000000000e+01 -8.6500000000000000e+01 3.2684965844964609e-13)(4.3751384735107422e+01 6.0545715332031250e+01 1.5719996643066406e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3346551513671875e+02)(3.6877834320068359e+01 6.4938354492187500e+01 1.3050019836425781e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 5.8841522216796875e+01)(-2.7500000000000000e+01 -8.3500000000000000e+01 3.1974423109204508e-13)(-2.7500000000000000e+01 -8.6500000000000000e+01 3.2684965844964609e-13)(-8.9336181640625000e+01 2.6993732452392578e+01 1.3346551513671875e+02)(-8.8347320556640625e+01 3.0021541595458984e+01 1.3049998474121094e+02)(-9.1357238769531250e+01 1.9070823669433594e+01 1.3049990844726562e+02)(-9.1244758605957031e+01 -1.9413391113281250e+01 1.3050000000000000e+02)(-8.9594100952148438e+01 -2.6176630020141602e+01 1.3346551513671875e+02)(-9.2873863220214844e+01 -1.0607085227966309e+01 1.3049984741210938e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(-8.1801506042480469e+01 -2.3221632003784180e+01 1.5719999694824219e+02)(7.2502433776855469e+01 -2.0005266189575195e+01 9.4783348083496094e+01)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(7.1186248779296875e+01 -2.1818662643432617e+01 1.2777687835693359e+02)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(6.8042015075683594e+01 2.4402191162109375e+01 1.0512095642089844e+02)(6.6629837036132812e+01 2.5092590332031250e+01 1.3050000000000000e+02)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-8.8907424926757812e+01 -2.0866981506347656e+01 -2.8244312286376953e+01)(-9.0714019775390625e+01 1.7007638931274414e+01 1.3307831764221191e+01)(-9.0635910034179688e+01 1.7232580184936523e+01 5.5033313751220703e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-5.7800388336181641e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-5.3076999664306641e+01 5.6438434600830078e+01 1.3346563720703125e+02)(-7.1687973022460938e+01 -2.2238489151000977e+01 1.6125004577636719e+02)(-6.6812088012695312e+01 -3.4464725494384766e+01 1.6125024414062500e+02)(-7.2402847290039062e+01 -2.0073417663574219e+01 1.6775000000000000e+02)(-7.8516853332519531e+01 5.1479923248291016e+01 1.3346551513671875e+02)(-8.4838142395019531e+01 3.8973972320556641e+01 1.3346549987792969e+02)(-7.5526336669921875e+01 3.3584129333496094e+01 1.3346542358398438e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.3050000000000000e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.2425885772705078e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 -6.9758973121643066e+00)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(7.1929275512695312e+01 2.1703926086425781e+01 1.6125033569335938e+02)(7.4476074218750000e+01 9.6094312667846680e+00 1.6775006103515625e+02)(7.4678085327148438e+01 7.8352298736572266e+00 1.6124992370605469e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(-4.2277292777725961e-13 5.2680000305175781e+01 1.5719999694824219e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 5.8841522216796875e+01)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(-8.6333305358886719e+01 -1.0644967079162598e+01 1.3346554565429688e+02)(-8.9594100952148438e+01 -2.6176630020141602e+01 1.3346551513671875e+02)(-8.3394485473632812e+01 -1.9708364486694336e+01 1.3346574401855469e+02)(6.5599250793457031e+01 3.5677104949951172e+01 1.3346554565429688e+02)(6.3920379638671875e+01 3.8730957031250000e+01 1.5720005798339844e+02)(6.8471626281738281e+01 2.9723161697387695e+01 1.5719995117187500e+02)(2.7500000000000000e+01 8.3500000000000000e+01 6.1924388885498047e+01)(2.7500000000000000e+01 8.6500000000000000e+01 7.7052558898925781e+01)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 6.1463169097900391e+01)(2.7500000000000000e+01 8.3500000000000000e+01 -8.5265128291212022e-14)(2.7500000000000000e+01 8.3500000000000000e+01 6.1924388885498047e+01)(4.9232200622558594e+01 -1.8984346389770508e+01 1.5720007324218750e+02)(5.4976158142089844e+01 -3.7404087066650391e+01 1.5719999694824219e+02)(7.0440612792968750e+01 -2.4795007705688477e+01 1.5719992065429688e+02)(9.0297088623046875e+01 2.3851243972778320e+01 1.3050001525878906e+02)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(8.3728973388671875e+01 4.1508079528808594e+01 1.3050010681152344e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.5719999694824219e+02)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(-8.7273971557617188e+01 -2.2735280990600586e+01 1.3049960327148438e+02)(-8.9825271606445312e+01 -2.5200748443603516e+01 1.3050000000000000e+02)(-8.9336181640625000e+01 2.6993732452392578e+01 1.3346551513671875e+02)(-9.1357238769531250e+01 1.9070823669433594e+01 1.3049990844726562e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(2.2981338500976562e+01 7.1454238891601562e+01 1.6774993896484375e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(-8.0403465270996094e+01 -4.7990089416503906e+01 1.3049998474121094e+02)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(7.0521041870117188e+01 -2.4467180252075195e+01 1.3346548461914062e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(7.2606910705566406e+01 -1.7419267654418945e+01 1.3346551513671875e+02)(-2.4810487747192383e+01 -8.3499771118164062e+01 -1.2105969429016113e+01)(-2.6530216217041016e+01 -8.6500022888183594e+01 -7.6352477073669434e+00)(-2.7169082641601562e+01 -8.3500198364257812e+01 -4.6480736732482910e+00)(1.9489873886108398e+01 8.6499641418457031e+01 -1.9362747192382812e+01)(1.4446233749389648e+01 8.3500373840332031e+01 -2.3352657318115234e+01)(1.2767145156860352e+01 8.6499855041503906e+01 -2.4439380645751953e+01)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-2.5388035857637492e-13 7.5000000000000000e+01 1.6775000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(6.3611633300781250e+01 2.5904483795166016e+01 1.0519409179687500e+02)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(-9.2873863220214844e+01 -1.0607085227966309e+01 1.3049984741210938e+02)(-9.2919418334960938e+01 -1.0094609260559082e+01 1.3346545410156250e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(4.9493560791015625e+01 -5.5952938079833984e+01 1.5719999694824219e+02)(2.6551660537719727e+01 -4.5650089263916016e+01 1.5719999694824219e+02)(4.1793392181396484e+01 -6.1974334716796875e+01 1.5719990539550781e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.3050000000000000e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(-4.4139652252197266e+01 5.3079219818115234e+01 1.3050000000000000e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.2649586677551270e+01)(7.4046676635742188e+01 -2.1977169513702393e+00 9.4352531433105469e+00)(7.4046676635742188e+01 1.4005400657653809e+01 -1.4996746063232422e+01)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(7.8696449279785156e+01 -5.1277267456054688e+01 1.3049996948242188e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 -6.9758973121643066e+00)(-9.1023178100585938e+01 -1.4005400657653809e+01 4.4208824157714844e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(6.1233039855957031e+01 4.3551002502441406e+01 1.6125006103515625e+02)(5.1484649658203125e+01 5.4627273559570312e+01 1.6125001525878906e+02)(5.7097816467285156e+01 4.8688312530517578e+01 1.6774993896484375e+02)(5.2745903015136719e+01 -3.9014687538146973e+00 1.6124996948242188e+02)(5.1936588287353516e+01 -9.3247003555297852e+00 1.5720001220703125e+02)(5.2768165588378906e+01 -1.5276668818842154e-13 1.5719999694824219e+02)(-6.6067413330078125e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-2.8861297607421875e+01 5.4849514007568359e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.3050000000000000e+02)(-4.4139652252197266e+01 5.3079219818115234e+01 1.3050000000000000e+02)(7.2122238159179688e+01 -2.0990419387817383e+01 1.6774984741210938e+02)(6.7764801025390625e+01 -3.2242206573486328e+01 1.6774996948242188e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(9.0297088623046875e+01 2.3851243972778320e+01 1.3050001525878906e+02)(9.3551139831542969e+01 2.4151535034179688e+00 1.3050006103515625e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.3050000000000000e+02)(-6.9660385131835938e+01 4.1024261474609375e+01 1.3346549987792969e+02)(-7.8516853332519531e+01 5.1479923248291016e+01 1.3346551513671875e+02)(-7.5526336669921875e+01 3.3584129333496094e+01 1.3346542358398438e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(6.2046672821044922e+01 2.6005401611328125e+01 4.6390792846679688e+01)(4.3751384735107422e+01 6.0545715332031250e+01 1.5719996643066406e+02)(4.8824459075927734e+01 5.6570331573486328e+01 1.3346582031250000e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-6.3029327392578125e+01 4.7988216400146484e+01 1.3346551513671875e+02)(-6.5878494262695312e+01 4.5136981964111328e+01 1.5719998168945312e+02)(-5.7789394378662109e+01 5.2736637115478516e+01 1.5719996643066406e+02)(-4.4923904418945312e+01 -6.1877056121826172e+01 1.5719998168945312e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-3.6399375915527344e+01 -6.6452644348144531e+01 1.3050004577636719e+02)(6.1565635681152344e+01 4.2239334106445312e+01 1.3346557617187500e+02)(6.3920379638671875e+01 3.8730957031250000e+01 1.5720005798339844e+02)(6.5599250793457031e+01 3.5677104949951172e+01 1.3346554565429688e+02)(-4.9812393188476562e+01 1.7215398788452148e+01 1.5719989013671875e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(4.5452251434326172e+01 -2.6775592803955078e+01 1.6124998474121094e+02)(4.3855422973632812e+01 -2.9152513504028320e+01 1.5720021057128906e+02)(4.9232200622558594e+01 -1.8984346389770508e+01 1.5720007324218750e+02)(9.3040290832519531e+01 8.5211200714111328e+00 1.3346542358398438e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(-4.8890350341796875e+01 5.6930206298828125e+01 1.6775000000000000e+02)(-4.0644512176513672e+01 6.3066162109375000e+01 1.6774998474121094e+02)(-4.1010608673095703e+01 6.2885150909423828e+01 1.6125006103515625e+02)(-8.1801506042480469e+01 -2.3221632003784180e+01 1.5719999694824219e+02)(-8.3394485473632812e+01 -1.9708364486694336e+01 1.3346574401855469e+02)(-7.8303855895996094e+01 -2.9375566482543945e+01 1.3346548461914062e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(7.4448554992675781e+01 -6.6282186508178711e+00 1.3346574401855469e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(2.3315935134887695e+01 -8.3500228881835938e+01 -1.4633216857910156e+01)(1.6159154891967773e+01 -8.3500167846679688e+01 -2.2321565628051758e+01)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(3.4075340270996094e+01 4.0295608520507812e+01 1.5719999694824219e+02)(5.6196445465087891e+01 4.9302890777587891e+01 1.5719982910156250e+02)(4.9515712738037109e+01 5.5933147430419922e+01 1.5719999694824219e+02)(-3.4073406219482422e+01 4.0245048522949219e+01 1.6124998474121094e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-4.1010608673095703e+01 6.2885150909423828e+01 1.6125006103515625e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(3.3114341735839844e+01 6.7340042114257812e+01 1.6125001525878906e+02)(3.4291679382324219e+01 6.6874122619628906e+01 1.6774981689453125e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(-1.1993492126464844e+01 5.1369159698486328e+01 1.6124972534179688e+02)(-9.1191358566284180e+00 7.4532142639160156e+01 1.6125006103515625e+02)(-3.8157699584960938e+01 -6.4664611816406250e+01 1.6124998474121094e+02)(-2.2035116195678711e+01 -7.1864418029785156e+01 1.6124995422363281e+02)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(-6.3029327392578125e+01 4.7988216400146484e+01 1.3346551513671875e+02)(-6.9660385131835938e+01 4.1024261474609375e+01 1.3346549987792969e+02)(-6.5878494262695312e+01 4.5136981964111328e+01 1.5719998168945312e+02)(8.1439865112304688e+01 4.6165725708007812e+01 1.3346539306640625e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(6.5599250793457031e+01 3.5677104949951172e+01 1.3346554565429688e+02)(-3.8026851654052734e+01 6.5685386657714844e+01 1.3050004577636719e+02)(-4.5176086425781250e+01 6.1726181030273438e+01 1.5719996643066406e+02)(-3.4890045166015625e+01 6.7120681762695312e+01 1.5719998168945312e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(-6.5878494262695312e+01 4.5136981964111328e+01 1.5719998168945312e+02)(-7.1289993286132812e+01 3.9113079071044922e+01 1.5719992065429688e+02)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 -1.4210854715202004e-13)(2.7500000000000000e+01 -8.6500000000000000e+01 3.4884891510009766e+01)(-3.4073406219482422e+01 4.0245048522949219e+01 1.6124998474121094e+02)(-4.1010608673095703e+01 6.2885150909423828e+01 1.6125006103515625e+02)(-3.0879575729370117e+01 6.8372200012207031e+01 1.6125003051757812e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.5719999694824219e+02)(-1.5631938831469488e-13 -5.2680000305175781e+01 1.5719999694824219e+02)(-6.0711631774902344e+00 -5.2393779754638672e+01 1.5720002746582031e+02)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(7.3644508361816406e+01 -1.7455656051635742e+01 -3.1769245147705078e+01)(7.0774162292480469e+01 -2.2258674621582031e+01 -3.1769689559936523e+01)(4.8824459075927734e+01 5.6570331573486328e+01 1.3346582031250000e+02)(4.3751384735107422e+01 6.0545715332031250e+01 1.5719996643066406e+02)(4.9515712738037109e+01 5.5933147430419922e+01 1.5719999694824219e+02)(5.1869064331054688e+01 9.6966800689697266e+00 1.6124987792968750e+02)(5.2745903015136719e+01 -3.9014687538146973e+00 1.6124996948242188e+02)(5.2768165588378906e+01 -1.5276668818842154e-13 1.5719999694824219e+02)(8.1294532775878906e+01 -4.6588893890380859e+01 1.3346530151367188e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-6.6812088012695312e+01 -3.4464725494384766e+01 1.6125024414062500e+02)(-4.6785579681396484e+01 -2.4622884750366211e+01 1.6125015258789062e+02)(-3.8757396697998047e+01 -3.5818653106689453e+01 1.6125001525878906e+02)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(2.7500000000000000e+01 8.6500000000000000e+01 7.7052558898925781e+01)(2.7500000000000000e+01 8.3500000000000000e+01 6.1924388885498047e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-8.5401557922363281e+01 -3.7751152038574219e+01 1.3050007629394531e+02)(-8.3610725402832031e+01 -2.5091253280639648e+01 1.3050000000000000e+02)(-3.4073406219482422e+01 4.0245048522949219e+01 1.6124998474121094e+02)(-4.1857151031494141e+01 3.2210327148437500e+01 1.6124998474121094e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(9.6112070083618164e+00 5.1957012176513672e+01 1.6125001525878906e+02)(-2.9842794901924208e-13 5.2680000305175781e+01 1.6125000000000000e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(7.1535766601562500e+01 -2.1445131301879883e+01 -6.0370934009552002e-01)(6.8767593383789062e+01 -2.3979000091552734e+01 2.7362794876098633e+00)(7.0774162292480469e+01 -2.2258674621582031e+01 -3.1769689559936523e+01)(-5.9879058837890625e+01 -5.0929645538330078e+01 1.3346559143066406e+02)(-4.8918796539306641e+01 -5.9330558776855469e+01 1.3346546936035156e+02)(-5.4540454864501953e+01 -5.5304397583007812e+01 1.5719999694824219e+02)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(8.8046340942382812e+01 -3.1130365371704102e+01 1.3049987792968750e+02)(7.0318603515625000e+01 -2.2694311141967773e+01 1.3049975585937500e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(3.5303173065185547e+01 3.9258464813232422e+01 1.6124998474121094e+02)(2.4536960601806641e+01 4.6794597625732422e+01 1.6124983215332031e+02)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(6.4391571044921875e+01 -2.5801553726196289e+01 -1.7952758789062500e+01)(2.7500000000000000e+01 -8.3500000000000000e+01 8.8128768920898438e+01)(-2.7500000000000000e+01 -8.3500000000000000e+01 5.8841522216796875e+01)(-2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(4.5799865722656250e+01 -5.9457805633544922e+01 1.6774998474121094e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(4.1449623107910156e+01 3.2505737304687500e+01 1.5720005798339844e+02)(4.7567695617675781e+01 2.2686857223510742e+01 1.5719992065429688e+02)(7.4012634277343750e+01 1.0421646118164062e+01 1.5719998168945312e+02)(-6.6849647521972656e+01 -3.4149829864501953e+01 1.6775000000000000e+02)(-7.2402847290039062e+01 -2.0073417663574219e+01 1.6775000000000000e+02)(-6.6812088012695312e+01 -3.4464725494384766e+01 1.6125024414062500e+02)(-7.4802711486816406e+01 -6.3990607261657715e+00 1.6774998474121094e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-7.4968612670898438e+01 -3.4747965335845947e+00 1.6125009155273438e+02)(7.3272308349609375e+01 1.8382198333740234e+01 1.3050190734863281e+02)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(9.0297088623046875e+01 2.3851243972778320e+01 1.3050001525878906e+02)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(7.0774162292480469e+01 -2.2258674621582031e+01 -3.1769689559936523e+01)(6.8507911682128906e+01 -2.4144041061401367e+01 -2.4222715377807617e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 6.0335853576660156e+01)(-8.5023956298828125e+01 -2.4399049758911133e+01 7.9142021179199219e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 1.0792460632324219e+02)(6.9349021911621094e+01 2.3529741287231445e+01 8.0851188659667969e+01)(6.8042015075683594e+01 2.4402191162109375e+01 1.0512095642089844e+02)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(7.3127746582031250e+01 1.8871967315673828e+01 -3.1769943237304688e+01)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(7.3850120544433594e+01 1.6310745239257812e+01 -3.0784076690673828e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 8.8908607482910156e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 1.0792460632324219e+02)(-8.7273971557617188e+01 -2.2735280990600586e+01 1.3049960327148438e+02)(-8.7511779785156250e+01 2.2489559173583984e+01 6.0274906158447266e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 3.2153171539306641e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-8.8356018066406250e+01 2.1567317962646484e+01 8.0790237426757812e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-8.9781906127929688e+01 1.9380043029785156e+01 8.1771514892578125e+01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-8.7511779785156250e+01 -2.2489559173583984e+01 9.0658025741577148e+00)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.2869000434875488e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 -3.0209545135498047e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 -2.6119689941406250e+00)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.5705986022949219e+01 2.4004983901977539e+01 6.3944019317626953e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 6.0274906158447266e+01)(-8.8356018066406250e+01 2.1567317962646484e+01 8.0790237426757812e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 -1.1735793352127075e+00)(-8.8547523498535156e+01 2.1307743072509766e+01 3.2153171539306641e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 1.4843739509582520e+01)(6.5149871826171875e+01 2.5598823547363281e+01 8.1229072570800781e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.0546226501464844e+02)(6.6635116577148438e+01 2.5095191955566406e+01 7.6718864440917969e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 8.8908607482910156e+01)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 6.0335853576660156e+01)(7.2823318481445312e+01 1.9345205307006836e+01 3.9796138763427734e+01)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 -2.5528682708740234e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.8246543407440186e+00)(-8.6321174621582031e+01 -2.3537843704223633e+01 -2.8051286697387695e+01)(7.3945549011230469e+01 1.5571919441223145e+01 8.4393829345703125e+01)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(7.3639289855957031e+01 1.7111631393432617e+01 1.0599861907958984e+02)(-8.7511779785156250e+01 -2.2489559173583984e+01 9.0658025741577148e+00)(-8.7477874755859375e+01 -2.2527986526489258e+01 -2.7026269912719727e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.8246543407440186e+00)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(6.9582809448242188e+01 2.3433988571166992e+01 -2.7056911468505859e+01)(6.8042007446289062e+01 2.4402191162109375e+01 4.8799829483032227e+00)(7.1680549621582031e+01 2.1239969253540039e+01 7.7994125366210938e+01)(6.9349021911621094e+01 2.3529741287231445e+01 8.0851188659667969e+01)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.0231732177734375e+02)(7.3639289855957031e+01 -1.7111631393432617e+01 9.8489746093750000e+01)(7.3222488403320312e+01 -1.8595720291137695e+01 6.2816463470458984e+01)(6.9349021911621094e+01 2.3529741287231445e+01 8.0851188659667969e+01)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(-8.6321174621582031e+01 -2.3537843704223633e+01 -2.8051286697387695e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.8246543407440186e+00)(-8.7477874755859375e+01 -2.2527986526489258e+01 -2.7026269912719727e+01)(-8.9419967651367188e+01 2.0000736236572266e+01 9.4558744430541992e+00)(-8.8547523498535156e+01 2.1307743072509766e+01 3.2153171539306641e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 -1.1735793352127075e+00)(7.3951889038085938e+01 -1.5548828125000000e+01 1.2715247344970703e+02)(7.3166748046875000e+01 -1.8728326797485352e+01 1.3049955749511719e+02)(7.3639289855957031e+01 -1.7111631393432617e+01 9.8489746093750000e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 -2.6119689941406250e+00)(-8.2129409790039062e+01 2.5598011016845703e+01 -3.0209545135498047e+01)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.0546226501464844e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(6.6629837036132812e+01 2.5092590332031250e+01 1.3050000000000000e+02)(6.4391159057617188e+01 -2.5801763534545898e+01 1.0273176574707031e+02)(6.6933624267578125e+01 -2.5024982452392578e+01 1.3050001525878906e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-8.3615974426269531e+01 2.5093389511108398e+01 5.6142581939697266e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 3.0410037994384766e+01)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 3.0410037994384766e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 5.6142581939697266e+01)(-9.0820014953613281e+01 1.6348896026611328e+01 9.7063537597656250e+01)(-9.0747459411621094e+01 1.6444686889648438e+01 1.3050000000000000e+02)(-8.9908714294433594e+01 1.9126947402954102e+01 1.2754798126220703e+02)(-8.2073081970214844e+01 -2.5667484283447266e+01 3.7937202453613281e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 5.9458190917968750e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-9.0820014953613281e+01 1.6348896026611328e+01 9.7063537597656250e+01)(-8.9781906127929688e+01 1.9380043029785156e+01 8.1771514892578125e+01)(-9.0635910034179688e+01 1.7232580184936523e+01 5.5033313751220703e+01)(-8.2073081970214844e+01 -2.5667484283447266e+01 3.7937202453613281e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 8.4837234497070312e+01)(-8.1370376586914062e+01 -2.5801153182983398e+01 8.5519851684570312e+01)(7.3644508361816406e+01 -1.7455656051635742e+01 -3.1769245147705078e+01)(7.4068229675292969e+01 -1.4006268501281738e+01 1.0571428537368774e+00)(7.3639289855957031e+01 -1.7111631393432617e+01 -1.1437340736389160e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 5.6142581939697266e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 7.4841636657714844e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(-9.0635910034179688e+01 1.7232580184936523e+01 5.5033313751220703e+01)(-9.0714019775390625e+01 1.7007638931274414e+01 1.3307831764221191e+01)(7.3272308349609375e+01 1.8382198333740234e+01 1.3050190734863281e+02)(7.3639289855957031e+01 1.7111631393432617e+01 1.0599861907958984e+02)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.5270380020141602e+01)(6.5149871826171875e+01 2.5598823547363281e+01 5.2388145446777344e+01)(6.6635116577148438e+01 2.5095191955566406e+01 3.4834915161132812e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.0446272277832031e+02)(-8.3488998413085938e+01 2.5188650131225586e+01 1.3050068664550781e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.3050000000000000e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.0417015838623047e+02)(7.3272308349609375e+01 1.8382198333740234e+01 1.3050190734863281e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.3050000000000000e+02)(6.6635116577148438e+01 2.5095191955566406e+01 7.6718864440917969e+01)(6.6629837036132812e+01 2.5092590332031250e+01 1.3050000000000000e+02)(6.8042015075683594e+01 2.4402191162109375e+01 1.0512095642089844e+02)(6.5149871826171875e+01 2.5598823547363281e+01 1.5270380020141602e+01)(6.6635116577148438e+01 2.5095191955566406e+01 3.4834915161132812e+01)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(-9.0112968444824219e+01 -1.8593845367431641e+01 6.5114234924316406e+01)(-8.9419967651367188e+01 -2.0000736236572266e+01 7.7060180664062500e+01)(-9.0112968444824219e+01 -1.8593845367431641e+01 1.0339002227783203e+02)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(6.6635116577148438e+01 2.5095191955566406e+01 3.4834915161132812e+01)(6.8042007446289062e+01 2.4402191162109375e+01 4.8799829483032227e+00)(6.5149871826171875e+01 2.5598823547363281e+01 1.0546226501464844e+02)(6.6629837036132812e+01 2.5092590332031250e+01 1.3050000000000000e+02)(6.6635116577148438e+01 2.5095191955566406e+01 7.6718864440917969e+01)(-9.0635910034179688e+01 1.7232580184936523e+01 5.5033313751220703e+01)(-8.9781906127929688e+01 1.9380043029785156e+01 8.1771514892578125e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(-9.0112968444824219e+01 -1.8593845367431641e+01 6.5114234924316406e+01)(-9.0112968444824219e+01 -1.8593845367431641e+01 1.0339002227783203e+02)(-9.0112968444824219e+01 -1.8593845367431641e+01 1.0339002227783203e+02)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(-9.0616600036621094e+01 -1.7108596801757812e+01 1.2893971252441406e+02)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.2869000434875488e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 9.0658025741577148e+00)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 4.1612411499023438e+01)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-9.0112968444824219e+01 -1.8593845367431641e+01 6.5114234924316406e+01)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.8507911682128906e+01 -2.4144041061401367e+01 -2.4222715377807617e+01)(6.8767593383789062e+01 -2.3979000091552734e+01 2.7362794876098633e+00)(6.4391159057617188e+01 -2.5801763534545898e+01 1.0273176574707031e+02)(6.4828872680664062e+01 -2.5737499237060547e+01 6.9435493469238281e+01)(6.8199630737304688e+01 -2.4393993377685547e+01 1.2817570495605469e+02)(-8.7511779785156250e+01 2.2489559173583984e+01 1.4843739509582520e+01)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(-8.7535324096679688e+01 2.2457002639770508e+01 -3.1769830703735352e+01)(6.4828872680664062e+01 -2.5737499237060547e+01 6.9435493469238281e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.5149871826171875e+01 2.5598823547363281e+01 8.1229072570800781e+01)(6.6635116577148438e+01 2.5095191955566406e+01 6.7844734191894531e+01)(6.5149871826171875e+01 2.5598823547363281e+01 5.2388145446777344e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 4.1612411499023438e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 6.5488034486770630e-01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-9.1023178100585938e+01 1.4005400657653809e+01 1.2425885772705078e+02)(-9.0747459411621094e+01 1.6444686889648438e+01 1.3050000000000000e+02)(-9.0820014953613281e+01 1.6348896026611328e+01 9.7063537597656250e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 6.4571784973144531e+01)(-9.0635910034179688e+01 1.7232580184936523e+01 5.5033313751220703e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(-9.1023178100585938e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(-9.0644447326660156e+01 1.7214775085449219e+01 -2.9394233703613281e+01)(-8.9515121459960938e+01 1.9935207366943359e+01 -3.1769947052001953e+01)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(6.5149871826171875e+01 2.5598823547363281e+01 1.0546226501464844e+02)(6.3611633300781250e+01 2.5904483795166016e+01 1.0519409179687500e+02)(-4.5176086425781250e+01 6.1726181030273438e+01 1.5719996643066406e+02)(-5.7789394378662109e+01 5.2736637115478516e+01 1.5719996643066406e+02)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(-5.2769325256347656e+01 -1.2287213802337646e+00 1.6124995422363281e+02)(-7.4968612670898438e+01 -3.4747965335845947e+00 1.6125009155273438e+02)(-7.3578536987304688e+01 1.4789866447448730e+01 1.6125001525878906e+02)(-7.2009666442871094e+01 2.1281465530395508e+01 1.6774993896484375e+02)(-6.9965950012207031e+01 2.7403331756591797e+01 1.6125001525878906e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 4.6390792846679688e+01)(6.2046672821044922e+01 2.6005401611328125e+01 1.1820683479309082e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.0446272277832031e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.1235576629638672e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.0446272277832031e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.3050000000000000e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(-1.8142257690429688e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(-2.7169082641601562e+01 -8.3500198364257812e+01 -4.6480736732482910e+00)(-2.7500000000000000e+01 -8.3500000000000000e+01 3.1974423109204508e-13)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(1.9489873886108398e+01 8.6499641418457031e+01 -1.9362747192382812e+01)(2.5842729568481445e+01 8.6500991821289062e+01 -1.0067432403564453e+01)(2.2083520889282227e+01 8.3499839782714844e+01 -1.6511587142944336e+01)(-5.1205204010009766e+01 -5.4992069244384766e+01 1.6125010681152344e+02)(-3.8157699584960938e+01 -6.4664611816406250e+01 1.6124998474121094e+02)(-4.7637077331542969e+01 -5.8130901336669922e+01 1.6774990844726562e+02)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(-1.3478947877883911e+00 8.3500511169433594e+01 -2.7524913787841797e+01)(-8.1101541519165039e+00 8.3499954223632812e+01 -2.6377056121826172e+01)(-9.0607328414916992e+00 -7.4531417846679688e+01 1.6774998474121094e+02)(-2.0086696520503489e-13 -7.5000000000000000e+01 1.6775000000000000e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(-7.2009666442871094e+01 2.1281465530395508e+01 1.6774993896484375e+02)(-6.7835960388183594e+01 3.2077857971191406e+01 1.6774998474121094e+02)(-6.9965950012207031e+01 2.7403331756591797e+01 1.6125001525878906e+02)(-4.8890350341796875e+01 5.6930206298828125e+01 1.6775000000000000e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-5.7060512542724609e+01 4.8739387512207031e+01 1.6774998474121094e+02)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(-7.0092063903808594e+01 -4.0707054138183594e+01 1.3346559143066406e+02)(-5.9879058837890625e+01 -5.0929645538330078e+01 1.3346559143066406e+02)(-6.2738201141357422e+01 -4.8272773742675781e+01 1.5719996643066406e+02)(-8.5844612121582031e+01 -2.3929893493652344e+01 -3.1769815444946289e+01)(-8.6321174621582031e+01 -2.3537843704223633e+01 -2.8051286697387695e+01)(-8.7477874755859375e+01 -2.2527986526489258e+01 -2.7026269912719727e+01)(-1.1993492126464844e+01 5.1369159698486328e+01 1.6124972534179688e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(-2.9842794901924208e-13 5.2680000305175781e+01 1.6125000000000000e+02)(-7.7384971618652344e+01 3.0844591140747070e+01 1.5719984436035156e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(5.2745903015136719e+01 -3.9014687538146973e+00 1.6124996948242188e+02)(7.4929084777832031e+01 -4.1990342140197754e+00 1.6125000000000000e+02)(7.3615806579589844e+01 -1.4678483009338379e+01 1.6125006103515625e+02)(-2.7711166694643907e-13 -5.2680000305175781e+01 1.6125000000000000e+02)(8.0546951293945312e+00 -7.4603233337402344e+01 1.6125000000000000e+02)(-3.1974423109204508e-13 -7.5000000000000000e+01 1.6125000000000000e+02)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 6.1463169097900391e+01)(2.7500000000000000e+01 8.3500000000000000e+01 6.1924388885498047e+01)(3.3473291397094727e+00 8.6500320434570312e+01 -2.7408464431762695e+01)(1.2767145156860352e+01 8.6499855041503906e+01 -2.4439380645751953e+01)(7.9875130653381348e+00 8.3499725341796875e+01 -2.6395942687988281e+01)(5.1484649658203125e+01 5.4627273559570312e+01 1.6125001525878906e+02)(6.1233039855957031e+01 4.3551002502441406e+01 1.6125006103515625e+02)(4.4417877197265625e+01 2.8603290557861328e+01 1.6125006103515625e+02)(5.7353664398193359e+01 -4.8390903472900391e+01 1.6125001525878906e+02)(4.6363193511962891e+01 -5.9140903472900391e+01 1.6125004577636719e+02)(3.0666088104248047e+01 -4.2930080413818359e+01 1.6125003051757812e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.1820683479309082e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.5270380020141602e+01)(6.5910034179687500e+01 2.5394439697265625e+01 -8.8531160354614258e+00)(2.4404411315917969e+01 4.6824039459228516e+01 1.5719995117187500e+02)(3.4075340270996094e+01 4.0295608520507812e+01 1.5719999694824219e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.5719999694824219e+02)(-8.7038528442382812e+01 6.9375810623168945e+00 1.5719927978515625e+02)(-8.5449035644531250e+01 1.3931497573852539e+01 1.5719975280761719e+02)(-8.5377494812011719e+01 1.4220652580261230e+01 1.3346554565429688e+02)(7.4046676635742188e+01 -2.1977169513702393e+00 9.4352531433105469e+00)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -1.4996746063232422e+01)(5.7097816467285156e+01 4.8688312530517578e+01 1.6774993896484375e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(6.1233039855957031e+01 4.3551002502441406e+01 1.6125006103515625e+02)(-3.4073406219482422e+01 4.0245048522949219e+01 1.6124998474121094e+02)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-4.1857151031494141e+01 3.2210327148437500e+01 1.6124998474121094e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 1.3050000000000000e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(-9.3238922119140625e+01 5.9731507301330566e+00 1.3050001525878906e+02)(-8.2037071228027344e+01 2.2562515258789062e+01 1.5719989013671875e+02)(-8.5449035644531250e+01 1.3931497573852539e+01 1.5719975280761719e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-8.5844612121582031e+01 -2.3929893493652344e+01 -3.1769815444946289e+01)(-8.8907424926757812e+01 -2.0866981506347656e+01 -2.8244312286376953e+01)(7.4046676635742188e+01 -2.1977169513702393e+00 9.4352531433105469e+00)(7.4046676635742188e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(-8.7257682800292969e+01 5.3665590286254883e+00 1.3346563720703125e+02)(-8.7560592651367188e+01 1.7757962644100189e-01 1.5720011901855469e+02)(-8.7038528442382812e+01 6.9375810623168945e+00 1.5719927978515625e+02)(-2.7711166694643907e-13 -5.2680000305175781e+01 1.6125000000000000e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(8.0546951293945312e+00 -7.4603233337402344e+01 1.6125000000000000e+02)(-2.1266397476196289e+01 7.2026412963867188e+01 1.6125006103515625e+02)(-9.1191358566284180e+00 7.4532142639160156e+01 1.6125006103515625e+02)(-1.1993492126464844e+01 5.1369159698486328e+01 1.6124972534179688e+02)(7.3172996520996094e+01 -1.4904995918273926e+01 1.5719995117187500e+02)(7.2606910705566406e+01 -1.7419267654418945e+01 1.3346551513671875e+02)(7.3826629638671875e+01 -1.1329031944274902e+01 1.4933326721191406e+02)(4.1793392181396484e+01 -6.1974334716796875e+01 1.5719990539550781e+02)(3.8522853851318359e+01 -6.3928745269775391e+01 1.3584690856933594e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(5.6767070770263672e+01 -4.8697395324707031e+01 1.5720005798339844e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(6.2293994903564453e+01 -4.1157024383544922e+01 1.5720001220703125e+02)(7.4448554992675781e+01 -6.6282186508178711e+00 1.3346574401855469e+02)(7.4703033447265625e+01 -3.2683925628662109e+00 1.5720013427734375e+02)(7.3826629638671875e+01 -1.1329031944274902e+01 1.4933326721191406e+02)(6.6161926269531250e+01 -3.4574485778808594e+01 1.5720005798339844e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(6.8085754394531250e+01 -3.0548526763916016e+01 1.3435859680175781e+02)(5.6196445465087891e+01 4.9302890777587891e+01 1.5719982910156250e+02)(5.5273727416992188e+01 5.0349800109863281e+01 1.3346554565429688e+02)(4.9515712738037109e+01 5.5933147430419922e+01 1.5719999694824219e+02)(-3.6399375915527344e+01 -6.6452644348144531e+01 1.3050004577636719e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-3.1266868591308594e+01 -6.2015098571777344e+01 1.3050000000000000e+02)(-2.5388035857637492e-13 7.5000000000000000e+01 1.6775000000000000e+02)(-2.7711166694643907e-13 7.5000000000000000e+01 1.6125000000000000e+02)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-7.7384971618652344e+01 3.0844591140747070e+01 1.5719984436035156e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(-7.1289993286132812e+01 3.9113079071044922e+01 1.5719992065429688e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.0231732177734375e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(-4.9750961303710938e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-5.7800388336181641e+01 6.2188003540039062e+01 1.3346551513671875e+02)(2.4536960601806641e+01 4.6794597625732422e+01 1.6124983215332031e+02)(2.4404411315917969e+01 4.6824039459228516e+01 1.5719995117187500e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(6.7764801025390625e+01 -3.2242206573486328e+01 1.6774996948242188e+02)(6.2567764282226562e+01 -4.1499729156494141e+01 1.6774975585937500e+02)(6.4919387817382812e+01 -3.7795818328857422e+01 1.6125027465820312e+02)(8.9427154541015625e+01 -2.6915592193603516e+01 1.3346551513671875e+02)(9.2097923278808594e+01 -1.5517567634582520e+01 1.3049993896484375e+02)(9.3224205017089844e+01 -7.9539341926574707e+00 1.3346553039550781e+02)(3.3814022064208984e+01 -5.9495456695556641e+01 1.3050000000000000e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(3.3190704345703125e+01 -6.6912818908691406e+01 1.3050000000000000e+02)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(7.2512092590332031e+01 -1.9999502182006836e+01 -3.1132726669311523e+01)(7.3639289855957031e+01 -1.7111631393432617e+01 -1.1437340736389160e+01)(-1.9986772537231445e+01 -8.3500122070312500e+01 -1.8907535552978516e+01)(-2.4810487747192383e+01 -8.3499771118164062e+01 -1.2105969429016113e+01)(-2.7169082641601562e+01 -8.3500198364257812e+01 -4.6480736732482910e+00)(8.8046340942382812e+01 -3.1130365371704102e+01 1.3049987792968750e+02)(7.8696449279785156e+01 -5.1277267456054688e+01 1.3049996948242188e+02)(6.6933624267578125e+01 -2.5024982452392578e+01 1.3050001525878906e+02)(-5.1959529876708984e+01 -9.1832647323608398e+00 1.5720005798339844e+02)(-5.2768165588378906e+01 -1.1368683772161603e-13 1.5719999694824219e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(-3.0879575729370117e+01 6.8372200012207031e+01 1.6125003051757812e+02)(-1.1993492126464844e+01 5.1369159698486328e+01 1.6124972534179688e+02)(-2.5185577392578125e+01 4.6444450378417969e+01 1.6124961853027344e+02)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-2.1306856155395508e+01 7.1962928771972656e+01 1.6774993896484375e+02)(-3.1505632400512695e+01 6.8185791015625000e+01 1.6774995422363281e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.3050000000000000e+02)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.5719999694824219e+02)(5.1869064331054688e+01 9.6966800689697266e+00 1.6124987792968750e+02)(5.2768165588378906e+01 -1.5276668818842154e-13 1.5719999694824219e+02)(5.1381282806396484e+01 1.1961022377014160e+01 1.5720007324218750e+02)(-6.7835960388183594e+01 3.2077857971191406e+01 1.6774998474121094e+02)(-6.3077995300292969e+01 4.0631622314453125e+01 1.6774984741210938e+02)(-6.2900997161865234e+01 4.1064804077148438e+01 1.6125006103515625e+02)(7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(7.1506225585937500e+01 6.2188003540039062e+01 1.3050000000000000e+02)(6.5464729309082031e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-7.2009666442871094e+01 2.1281465530395508e+01 1.6774993896484375e+02)(-7.3578536987304688e+01 1.4789866447448730e+01 1.6125001525878906e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(4.8824459075927734e+01 5.6570331573486328e+01 1.3346582031250000e+02)(5.5273727416992188e+01 5.0349800109863281e+01 1.3346554565429688e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 1.3050000000000000e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 1.2425885772705078e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(4.9716709136962891e+01 -1.7735923767089844e+01 1.6125000000000000e+02)(4.9232200622558594e+01 -1.8984346389770508e+01 1.5720007324218750e+02)(5.1936588287353516e+01 -9.3247003555297852e+00 1.5720001220703125e+02)(4.6363193511962891e+01 -5.9140903472900391e+01 1.6125004577636719e+02)(5.7353664398193359e+01 -4.8390903472900391e+01 1.6125001525878906e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(-9.1357238769531250e+01 1.9070823669433594e+01 1.3049990844726562e+02)(-9.3238922119140625e+01 5.9731507301330566e+00 1.3050001525878906e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(7.0409965515136719e+01 2.6376106262207031e+01 1.6774998474121094e+02)(6.7167518615722656e+01 3.3453254699707031e+01 1.6125001525878906e+02)(-6.2900997161865234e+01 4.1064804077148438e+01 1.6125006103515625e+02)(-6.9965950012207031e+01 2.7403331756591797e+01 1.6125001525878906e+02)(-6.7835960388183594e+01 3.2077857971191406e+01 1.6774998474121094e+02)(-6.8931365966796875e+01 -4.1853664398193359e+01 1.5719999694824219e+02)(-7.0092063903808594e+01 -4.0707054138183594e+01 1.3346559143066406e+02)(-6.2738201141357422e+01 -4.8272773742675781e+01 1.5719996643066406e+02)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(-1.8946477890014648e+01 8.3499221801757812e+01 -1.9983108520507812e+01)(-8.1101541519165039e+00 8.3499954223632812e+01 -2.6377056121826172e+01)(-4.1857151031494141e+01 3.2210327148437500e+01 1.6124998474121094e+02)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-4.4190227508544922e+01 2.8773574829101562e+01 1.5719999694824219e+02)(7.4703033447265625e+01 -3.2683925628662109e+00 1.5720013427734375e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(7.4012634277343750e+01 1.0421646118164062e+01 1.5719998168945312e+02)(4.5799865722656250e+01 -5.9457805633544922e+01 1.6774998474121094e+02)(4.6363193511962891e+01 -5.9140903472900391e+01 1.6125004577636719e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(4.5452251434326172e+01 -2.6775592803955078e+01 1.6124998474121094e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(4.0172702789306641e+01 -3.4223472595214844e+01 1.6125001525878906e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 7.6523834228515625e+01)(6.4391159057617188e+01 -2.5801763534545898e+01 1.0273176574707031e+02)(-3.0879575729370117e+01 6.8372200012207031e+01 1.6125003051757812e+02)(-4.1010608673095703e+01 6.2885150909423828e+01 1.6125006103515625e+02)(-3.1505632400512695e+01 6.8185791015625000e+01 1.6774995422363281e+02)(4.3381810188293457e+00 -8.6500015258789062e+01 -2.7369834899902344e+01)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(-1.6159154891967773e+01 -8.6499969482421875e+01 -2.2321565628051758e+01)(-5.7104511260986328e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-6.6067413330078125e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(6.3920379638671875e+01 3.8730957031250000e+01 1.5720005798339844e+02)(3.4075340270996094e+01 4.0295608520507812e+01 1.5719999694824219e+02)(4.1449623107910156e+01 3.2505737304687500e+01 1.5720005798339844e+02)(-8.1801506042480469e+01 -2.3221632003784180e+01 1.5719999694824219e+02)(-7.3600654602050781e+01 -3.6235103607177734e+01 1.5719989013671875e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(-2.7169082641601562e+01 -8.3500198364257812e+01 -4.6480736732482910e+00)(7.1031112670898438e+00 -8.3500007629394531e+01 -2.6709621429443359e+01)(-4.1763257980346680e+00 -8.3499992370605469e+01 -2.7412359237670898e+01)(-6.6812088012695312e+01 -3.4464725494384766e+01 1.6125024414062500e+02)(-5.9612304687500000e+01 -4.5636425018310547e+01 1.6125013732910156e+02)(-5.9516044616699219e+01 -4.5807617187500000e+01 1.6775001525878906e+02)(-2.2035116195678711e+01 -7.1864418029785156e+01 1.6124995422363281e+02)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-9.0607328414916992e+00 -7.4531417846679688e+01 1.6774998474121094e+02)(-8.2998054504394531e+01 -4.3143230438232422e+01 1.3346554565429688e+02)(-8.3394485473632812e+01 -1.9708364486694336e+01 1.3346574401855469e+02)(-8.9594100952148438e+01 -2.6176630020141602e+01 1.3346551513671875e+02)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(2.6533561706542969e+01 -8.3500000000000000e+01 -7.6685323715209961e+00)(2.3315935134887695e+01 -8.3500228881835938e+01 -1.4633216857910156e+01)(-7.5526336669921875e+01 3.3584129333496094e+01 1.3346542358398438e+02)(-8.4838142395019531e+01 3.8973972320556641e+01 1.3346549987792969e+02)(-8.1325523376464844e+01 2.4076435089111328e+01 1.3346548461914062e+02)(-5.3076999664306641e+01 5.6438434600830078e+01 1.3346563720703125e+02)(-4.5176086425781250e+01 6.1726181030273438e+01 1.5719996643066406e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-3.1505632400512695e+01 6.8185791015625000e+01 1.6774995422363281e+02)(7.1889564514160156e+01 2.0188781738281250e+01 1.5719985961914062e+02)(6.8471626281738281e+01 2.9723161697387695e+01 1.5719995117187500e+02)(4.1449623107910156e+01 3.2505737304687500e+01 1.5720005798339844e+02)(2.7500000000000000e+01 8.6500000000000000e+01 7.7052558898925781e+01)(2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(4.0172702789306641e+01 -3.4223472595214844e+01 1.6125001525878906e+02)(3.6033199310302734e+01 -3.8540302276611328e+01 1.5719999694824219e+02)(4.3855422973632812e+01 -2.9152513504028320e+01 1.5720021057128906e+02)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 1.4843739509582520e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 6.0274906158447266e+01)(-8.4838142395019531e+01 3.8973972320556641e+01 1.3346549987792969e+02)(-8.8347320556640625e+01 3.0021541595458984e+01 1.3049998474121094e+02)(-8.9336181640625000e+01 2.6993732452392578e+01 1.3346551513671875e+02)(6.7167518615722656e+01 3.3453254699707031e+01 1.6125001525878906e+02)(4.4417877197265625e+01 2.8603290557861328e+01 1.6125006103515625e+02)(6.1233039855957031e+01 4.3551002502441406e+01 1.6125006103515625e+02)(-2.0128026962280273e+01 8.6499954223632812e+01 -1.8719894409179688e+01)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(-1.4446232795715332e+01 8.6499740600585938e+01 -2.3352657318115234e+01)(1.4446233749389648e+01 8.3500373840332031e+01 -2.3352657318115234e+01)(2.2083520889282227e+01 8.3499839782714844e+01 -1.6511587142944336e+01)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(-8.7431739807128906e+01 2.2651365280151367e+01 1.2877049255371094e+02)(-8.9039299011230469e+01 2.1004236221313477e+01 1.3050039672851562e+02)(-8.3488998413085938e+01 2.5188650131225586e+01 1.3050068664550781e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(-9.2873863220214844e+01 -1.0607085227966309e+01 1.3049984741210938e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.0417015838623047e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.4046676635742188e+01 1.4005400657653809e+01 6.5748100280761719e+01)(6.2567764282226562e+01 -4.1499729156494141e+01 1.6774975585937500e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(5.7353664398193359e+01 -4.8390903472900391e+01 1.6125001525878906e+02)(-8.5449035644531250e+01 1.3931497573852539e+01 1.5719975280761719e+02)(-8.7038528442382812e+01 6.9375810623168945e+00 1.5719927978515625e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 9.8720527648925781e+01)(-8.3394485473632812e+01 -1.9708364486694336e+01 1.3346574401855469e+02)(-8.5866577148437500e+01 -1.2403345108032227e+01 1.5719999694824219e+02)(-8.6333305358886719e+01 -1.0644967079162598e+01 1.3346554565429688e+02)(4.5452251434326172e+01 -2.6775592803955078e+01 1.6124998474121094e+02)(4.9232200622558594e+01 -1.8984346389770508e+01 1.5720007324218750e+02)(4.9716709136962891e+01 -1.7735923767089844e+01 1.6125000000000000e+02)(5.1484649658203125e+01 5.4627273559570312e+01 1.6125001525878906e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(-3.0599491119384766e+01 -4.2939529418945312e+01 1.6125004577636719e+02)(-3.8157699584960938e+01 -6.4664611816406250e+01 1.6124998474121094e+02)(-5.1205204010009766e+01 -5.4992069244384766e+01 1.6125010681152344e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 9.8720527648925781e+01)(-2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(1.3515126228332520e+01 -8.6500030517578125e+01 -2.3961565017700195e+01)(4.3381810188293457e+00 -8.6500015258789062e+01 -2.7369834899902344e+01)(7.1031112670898438e+00 -8.3500007629394531e+01 -2.6709621429443359e+01)(9.0933486938476562e+01 2.1264158248901367e+01 1.3346549987792969e+02)(7.0053070068359375e+01 2.5780675888061523e+01 1.3346554565429688e+02)(7.2840324401855469e+01 1.6688291549682617e+01 1.3346591186523438e+02)(-8.5401557922363281e+01 -3.7751152038574219e+01 1.3050007629394531e+02)(-8.5021507263183594e+01 -2.4398166656494141e+01 1.3050000000000000e+02)(-8.3610725402832031e+01 -2.5091253280639648e+01 1.3050000000000000e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(4.5452251434326172e+01 -2.6775592803955078e+01 1.6124998474121094e+02)(4.9716709136962891e+01 -1.7735923767089844e+01 1.6125000000000000e+02)(6.8199630737304688e+01 -2.4393993377685547e+01 1.2817570495605469e+02)(7.0318603515625000e+01 -2.2694311141967773e+01 1.3049975585937500e+02)(6.6933624267578125e+01 -2.5024982452392578e+01 1.3050001525878906e+02)(-5.2547960281372070e+00 5.2463558197021484e+01 1.5720002746582031e+02)(-4.2277292777725961e-13 5.2680000305175781e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(3.6877834320068359e+01 6.4938354492187500e+01 1.3050019836425781e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(2.7500000000000000e+01 8.6500000000000000e+01 -1.1368683772161603e-13)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(2.7500000000000000e+01 8.3500000000000000e+01 -8.5265128291212022e-14)(7.3127746582031250e+01 1.8871967315673828e+01 -3.1769943237304688e+01)(6.7951301574707031e+01 2.4542978286743164e+01 -3.1770818710327148e+01)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(-1.3478947877883911e+00 8.3500511169433594e+01 -2.7524913787841797e+01)(7.9875130653381348e+00 8.3499725341796875e+01 -2.6395942687988281e+01)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(-8.9039299011230469e+01 2.1004236221313477e+01 1.3050039672851562e+02)(-9.1357238769531250e+01 1.9070823669433594e+01 1.3049990844726562e+02)(-8.8347320556640625e+01 3.0021541595458984e+01 1.3049998474121094e+02)(5.1936588287353516e+01 -9.3247003555297852e+00 1.5720001220703125e+02)(4.9232200622558594e+01 -1.8984346389770508e+01 1.5720007324218750e+02)(7.0440612792968750e+01 -2.4795007705688477e+01 1.5719992065429688e+02)(-4.9750961303710938e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-4.4139652252197266e+01 5.3079219818115234e+01 1.3050000000000000e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(3.0666088104248047e+01 -4.2930080413818359e+01 1.6125003051757812e+02)(3.5773017883300781e+01 -6.6016731262207031e+01 1.6125003051757812e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(2.4404411315917969e+01 4.6824039459228516e+01 1.5719995117187500e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(9.6112070083618164e+00 5.1957012176513672e+01 1.6125001525878906e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(2.4536960601806641e+01 4.6794597625732422e+01 1.6124983215332031e+02)(-7.1687973022460938e+01 -2.2238489151000977e+01 1.6125004577636719e+02)(-7.2402847290039062e+01 -2.0073417663574219e+01 1.6775000000000000e+02)(-7.3863143920898438e+01 -1.3130586624145508e+01 1.6125001525878906e+02)(-1.6670688629150391e+01 -5.0302070617675781e+01 1.5719995117187500e+02)(-1.8078422546386719e+01 -4.9675231933593750e+01 1.6124993896484375e+02)(-2.7031339645385742e+01 -4.5309486389160156e+01 1.5720002746582031e+02)(1.0787144660949707e+01 -5.1746307373046875e+01 1.6124987792968750e+02)(-1.5631938831469488e-13 -5.2680000305175781e+01 1.5719999694824219e+02)(1.4429249763488770e+01 -5.0916908264160156e+01 1.5719999694824219e+02)(2.2079833984375000e+01 -4.7860900878906250e+01 1.6125001525878906e+02)(1.4429249763488770e+01 -5.0916908264160156e+01 1.5719999694824219e+02)(2.6551660537719727e+01 -4.5650089263916016e+01 1.5719999694824219e+02)(-3.8026851654052734e+01 6.5685386657714844e+01 1.3050004577636719e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-4.5176086425781250e+01 6.1726181030273438e+01 1.5719996643066406e+02)(-3.8757396697998047e+01 -3.5818653106689453e+01 1.6125001525878906e+02)(-4.6785579681396484e+01 -2.4622884750366211e+01 1.6125015258789062e+02)(-4.3893966674804688e+01 -2.9079030990600586e+01 1.5720005798339844e+02)(6.5464729309082031e+01 6.2188003540039062e+01 1.3050000000000000e+02)(7.5782341003417969e+01 5.5891242980957031e+01 1.3050004577636719e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3050000000000000e+02)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(7.3127746582031250e+01 1.8871967315673828e+01 -3.1769943237304688e+01)(7.3850120544433594e+01 1.6310745239257812e+01 -3.0784076690673828e+01)(5.7353664398193359e+01 -4.8390903472900391e+01 1.6125001525878906e+02)(6.4919387817382812e+01 -3.7795818328857422e+01 1.6125027465820312e+02)(6.2567764282226562e+01 -4.1499729156494141e+01 1.6774975585937500e+02)(-8.7257682800292969e+01 5.3665590286254883e+00 1.3346563720703125e+02)(-8.7486099243164062e+01 -3.1490042209625244e+00 1.3346559143066406e+02)(-8.7560592651367188e+01 1.7757962644100189e-01 1.5720011901855469e+02)(7.4096588134765625e+01 -1.1731911659240723e+01 1.6774995422363281e+02)(7.2122238159179688e+01 -2.0990419387817383e+01 1.6774984741210938e+02)(7.3615806579589844e+01 -1.4678483009338379e+01 1.6125006103515625e+02)(-6.9660385131835938e+01 4.1024261474609375e+01 1.3346549987792969e+02)(-7.1289993286132812e+01 3.9113079071044922e+01 1.5719992065429688e+02)(-6.5878494262695312e+01 4.5136981964111328e+01 1.5719998168945312e+02)(-9.0747459411621094e+01 1.6444686889648438e+01 1.3050000000000000e+02)(-8.9039299011230469e+01 2.1004236221313477e+01 1.3050039672851562e+02)(-8.9908714294433594e+01 1.9126947402954102e+01 1.2754798126220703e+02)(7.5009902954101562e+01 -2.8366594314575195e+00 1.6775000000000000e+02)(7.4096588134765625e+01 -1.1731911659240723e+01 1.6774995422363281e+02)(7.4929084777832031e+01 -4.1990342140197754e+00 1.6125000000000000e+02)(-2.1266397476196289e+01 7.2026412963867188e+01 1.6125006103515625e+02)(-3.0879575729370117e+01 6.8372200012207031e+01 1.6125003051757812e+02)(-3.1505632400512695e+01 6.8185791015625000e+01 1.6774995422363281e+02)(-2.1198894500732422e+01 -7.2015518188476562e+01 1.6774996948242188e+02)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(-2.2035116195678711e+01 -7.1864418029785156e+01 1.6124995422363281e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(3.5773017883300781e+01 -6.6016731262207031e+01 1.6125003051757812e+02)(3.3510765075683594e+01 -6.7240554809570312e+01 1.6774996948242188e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-6.7835960388183594e+01 3.2077857971191406e+01 1.6774998474121094e+02)(-7.2009666442871094e+01 2.1281465530395508e+01 1.6774993896484375e+02)(-3.6651382446289062e+01 -3.7997226715087891e+01 1.5719999694824219e+02)(-4.4923904418945312e+01 -6.1877056121826172e+01 1.5719998168945312e+02)(-3.4647197723388672e+01 -6.7212234497070312e+01 1.5719995117187500e+02)(-2.0086696520503489e-13 -7.5000000000000000e+01 1.6775000000000000e+02)(8.0546951293945312e+00 -7.4603233337402344e+01 1.6125000000000000e+02)(7.4961767196655273e+00 -7.4684196472167969e+01 1.6775001525878906e+02)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-2.0086696520503489e-13 -7.5000000000000000e+01 1.6775000000000000e+02)(-9.0607328414916992e+00 -7.4531417846679688e+01 1.6774998474121094e+02)(-2.7711166694643907e-13 7.5000000000000000e+01 1.6125000000000000e+02)(-9.1191358566284180e+00 7.4532142639160156e+01 1.6125006103515625e+02)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-7.1289993286132812e+01 3.9113079071044922e+01 1.5719992065429688e+02)(-7.5526336669921875e+01 3.3584129333496094e+01 1.3346542358398438e+02)(-7.7384971618652344e+01 3.0844591140747070e+01 1.5719984436035156e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(-2.5388035857637492e-13 7.5000000000000000e+01 1.6775000000000000e+02)(-2.7711166694643907e-13 -5.2680000305175781e+01 1.6125000000000000e+02)(-3.1974423109204508e-13 -7.5000000000000000e+01 1.6125000000000000e+02)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.5719999694824219e+02)(-3.4647197723388672e+01 -6.7212234497070312e+01 1.5719995117187500e+02)(-6.2738201141357422e+01 -4.8272773742675781e+01 1.5719996643066406e+02)(-5.9879058837890625e+01 -5.0929645538330078e+01 1.3346559143066406e+02)(-5.4540454864501953e+01 -5.5304397583007812e+01 1.5719999694824219e+02)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-6.2900997161865234e+01 4.1064804077148438e+01 1.6125006103515625e+02)(-5.7060512542724609e+01 4.8739387512207031e+01 1.6774998474121094e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(4.8286041259765625e+01 -5.7161788940429688e+01 1.3346569824218750e+02)(4.3855422973632812e+01 -2.9152513504028320e+01 1.5720021057128906e+02)(3.6033199310302734e+01 -3.8540302276611328e+01 1.5719999694824219e+02)(5.4976158142089844e+01 -3.7404087066650391e+01 1.5719999694824219e+02)(-3.4073406219482422e+01 4.0245048522949219e+01 1.6124998474121094e+02)(-2.5185577392578125e+01 4.6444450378417969e+01 1.6124961853027344e+02)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-7.7384971618652344e+01 3.0844591140747070e+01 1.5719984436035156e+02)(-8.1325523376464844e+01 2.4076435089111328e+01 1.3346548461914062e+02)(-8.2037071228027344e+01 2.2562515258789062e+01 1.5719989013671875e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(7.3615806579589844e+01 -1.4678483009338379e+01 1.6125006103515625e+02)(7.2122238159179688e+01 -2.0990419387817383e+01 1.6774984741210938e+02)(-1.4446232795715332e+01 8.6499740600585938e+01 -2.3352657318115234e+01)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(-8.1101541519165039e+00 8.3499954223632812e+01 -2.6377056121826172e+01)(1.2767145156860352e+01 8.6499855041503906e+01 -2.4439380645751953e+01)(1.4446233749389648e+01 8.3500373840332031e+01 -2.3352657318115234e+01)(7.9875130653381348e+00 8.3499725341796875e+01 -2.6395942687988281e+01)(-2.7711166694643907e-13 -5.2680000305175781e+01 1.6125000000000000e+02)(-6.0711631774902344e+00 -5.2393779754638672e+01 1.5720002746582031e+02)(-1.5631938831469488e-13 -5.2680000305175781e+01 1.5719999694824219e+02)(2.7500000000000000e+01 8.3500000000000000e+01 -8.5265128291212022e-14)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(2.7500000000000000e+01 8.3500000000000000e+01 6.1924388885498047e+01)(-2.7500000000000000e+01 8.6500000000000000e+01 2.3751937866210938e+01)(-2.7500000000000000e+01 8.3500000000000000e+01 3.2684965844964609e-13)(-2.7500000000000000e+01 8.3500000000000000e+01 6.1463169097900391e+01)(-1.3970300674438477e+01 -8.3499824523925781e+01 -2.3669649124145508e+01)(-7.4371280670166016e+00 -8.6499816894531250e+01 -2.6638793945312500e+01)(-1.6159154891967773e+01 -8.6499969482421875e+01 -2.2321565628051758e+01)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(-3.4890045166015625e+01 6.7120681762695312e+01 1.5719998168945312e+02)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-4.7847377777099609e+01 2.2162990570068359e+01 1.6124998474121094e+02)(-4.9812393188476562e+01 1.7215398788452148e+01 1.5719989013671875e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(3.4291679382324219e+01 6.6874122619628906e+01 1.6774981689453125e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(-6.9965950012207031e+01 2.7403331756591797e+01 1.6125001525878906e+02)(-6.2900997161865234e+01 4.1064804077148438e+01 1.6125006103515625e+02)(6.1565635681152344e+01 4.2239334106445312e+01 1.3346557617187500e+02)(6.5599250793457031e+01 3.5677104949951172e+01 1.3346554565429688e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(-2.7500000000000000e+01 8.6500000000000000e+01 9.8720527648925781e+01)(-2.7500000000000000e+01 8.6500000000000000e+01 2.3751937866210938e+01)(-2.7500000000000000e+01 8.3500000000000000e+01 6.1463169097900391e+01)(5.4976158142089844e+01 -3.7404087066650391e+01 1.5719999694824219e+02)(3.6033199310302734e+01 -3.8540302276611328e+01 1.5719999694824219e+02)(2.6551660537719727e+01 -4.5650089263916016e+01 1.5719999694824219e+02)(-1.5251138687133789e+01 5.0588748931884766e+01 1.5719985961914062e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(-2.4782356262207031e+01 4.6653167724609375e+01 1.5720001220703125e+02)(8.8046340942382812e+01 -3.1130365371704102e+01 1.3049987792968750e+02)(8.1294532775878906e+01 -4.6588893890380859e+01 1.3346530151367188e+02)(7.8696449279785156e+01 -5.1277267456054688e+01 1.3049996948242188e+02)(-5.2547960281372070e+00 5.2463558197021484e+01 1.5720002746582031e+02)(-2.9842794901924208e-13 5.2680000305175781e+01 1.6125000000000000e+02)(-4.2277292777725961e-13 5.2680000305175781e+01 1.5719999694824219e+02)(-3.6651382446289062e+01 -3.7997226715087891e+01 1.5719999694824219e+02)(-3.8757396697998047e+01 -3.5818653106689453e+01 1.6125001525878906e+02)(-4.3893966674804688e+01 -2.9079030990600586e+01 1.5720005798339844e+02)(5.6767070770263672e+01 -4.8697395324707031e+01 1.5720005798339844e+02)(5.4976158142089844e+01 -3.7404087066650391e+01 1.5719999694824219e+02)(2.6551660537719727e+01 -4.5650089263916016e+01 1.5719999694824219e+02)(2.2079833984375000e+01 -4.7860900878906250e+01 1.6125001525878906e+02)(2.6551660537719727e+01 -4.5650089263916016e+01 1.5719999694824219e+02)(3.0666088104248047e+01 -4.2930080413818359e+01 1.6125003051757812e+02)(-5.2769325256347656e+01 -1.2287213802337646e+00 1.6124995422363281e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(-5.2768165588378906e+01 -1.1368683772161603e-13 1.5719999694824219e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.3050000000000000e+02)(-3.6399375915527344e+01 -6.6452644348144531e+01 1.3050004577636719e+02)(-3.1266868591308594e+01 -6.2015098571777344e+01 1.3050000000000000e+02)(-2.4658794403076172e+01 8.6499664306640625e+01 -1.2483454704284668e+01)(-2.7218658447265625e+01 8.6500053405761719e+01 -4.2035999298095703e+00)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(4.5799865722656250e+01 -5.9457805633544922e+01 1.6774998474121094e+02)(3.5773017883300781e+01 -6.6016731262207031e+01 1.6125003051757812e+02)(4.6363193511962891e+01 -5.9140903472900391e+01 1.6125004577636719e+02)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(-2.7218658447265625e+01 8.6500053405761719e+01 -4.2035999298095703e+00)(-1.6159154891967773e+01 -8.6499969482421875e+01 -2.2321565628051758e+01)(-1.9986772537231445e+01 -8.3500122070312500e+01 -1.8907535552978516e+01)(-1.3970300674438477e+01 -8.3499824523925781e+01 -2.3669649124145508e+01)(-7.2402847290039062e+01 -2.0073417663574219e+01 1.6775000000000000e+02)(-6.6849647521972656e+01 -3.4149829864501953e+01 1.6775000000000000e+02)(-7.4802711486816406e+01 -6.3990607261657715e+00 1.6774998474121094e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(4.3751384735107422e+01 6.0545715332031250e+01 1.5719996643066406e+02)(3.7757694244384766e+01 6.4393600463867188e+01 1.5720001220703125e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3050000000000000e+02)(7.5782341003417969e+01 5.5891242980957031e+01 1.3050004577636719e+02)(8.3728973388671875e+01 4.1508079528808594e+01 1.3050010681152344e+02)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(7.3644508361816406e+01 -1.7455656051635742e+01 -3.1769245147705078e+01)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.5719999694824219e+02)(-1.6670688629150391e+01 -5.0302070617675781e+01 1.5719995117187500e+02)(-3.4647197723388672e+01 -6.7212234497070312e+01 1.5719995117187500e+02)(-1.8078422546386719e+01 -4.9675231933593750e+01 1.6124993896484375e+02)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-3.0599491119384766e+01 -4.2939529418945312e+01 1.6125004577636719e+02)(-9.2873863220214844e+01 -1.0607085227966309e+01 1.3049984741210938e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(-9.3238922119140625e+01 5.9731507301330566e+00 1.3050001525878906e+02)(7.4678085327148438e+01 7.8352298736572266e+00 1.6124992370605469e+02)(7.5009902954101562e+01 -2.8366594314575195e+00 1.6775000000000000e+02)(7.4929084777832031e+01 -4.1990342140197754e+00 1.6125000000000000e+02)(1.2767145156860352e+01 8.6499855041503906e+01 -2.4439380645751953e+01)(3.3473291397094727e+00 8.6500320434570312e+01 -2.7408464431762695e+01)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(6.6629837036132812e+01 2.5092590332031250e+01 1.3050000000000000e+02)(8.3728973388671875e+01 4.1508079528808594e+01 1.3050010681152344e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(7.0440612792968750e+01 -2.4795007705688477e+01 1.5719992065429688e+02)(7.3172996520996094e+01 -1.4904995918273926e+01 1.5719995117187500e+02)(5.2768165588378906e+01 -1.5276668818842154e-13 1.5719999694824219e+02)(3.0666088104248047e+01 -4.2930080413818359e+01 1.6125003051757812e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(2.2079833984375000e+01 -4.7860900878906250e+01 1.6125001525878906e+02)(9.3040290832519531e+01 8.5211200714111328e+00 1.3346542358398438e+02)(9.0933486938476562e+01 2.1264158248901367e+01 1.3346549987792969e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(7.4929084777832031e+01 -4.1990342140197754e+00 1.6125000000000000e+02)(7.4096588134765625e+01 -1.1731911659240723e+01 1.6774995422363281e+02)(7.3615806579589844e+01 -1.4678483009338379e+01 1.6125006103515625e+02)(-7.4888923645019531e+01 4.7028226852416992e+00 1.6125001525878906e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-7.3578536987304688e+01 1.4789866447448730e+01 1.6125001525878906e+02)(1.3515126228332520e+01 -8.6500030517578125e+01 -2.3961565017700195e+01)(1.6159154891967773e+01 -8.3500167846679688e+01 -2.2321565628051758e+01)(1.9986772537231445e+01 -8.6499794006347656e+01 -1.8907535552978516e+01)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(-1.8142257690429688e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 7.6523834228515625e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(6.2046672821044922e+01 -2.6006364822387695e+01 1.6714866638183594e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 8.4837234497070312e+01)(-5.3076999664306641e+01 5.6438434600830078e+01 1.3346563720703125e+02)(-6.3029327392578125e+01 4.7988216400146484e+01 1.3346551513671875e+02)(-5.7789394378662109e+01 5.2736637115478516e+01 1.5719996643066406e+02)(-4.3893966674804688e+01 -2.9079030990600586e+01 1.5720005798339844e+02)(-4.6785579681396484e+01 -2.4622884750366211e+01 1.6125015258789062e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(-8.1101541519165039e+00 8.3499954223632812e+01 -2.6377056121826172e+01)(-1.3478947877883911e+00 8.3500511169433594e+01 -2.7524913787841797e+01)(-8.9039299011230469e+01 2.1004236221313477e+01 1.3050039672851562e+02)(-8.8347320556640625e+01 3.0021541595458984e+01 1.3049998474121094e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(-7.4968612670898438e+01 -3.4747965335845947e+00 1.6125009155273438e+02)(-5.1334136962890625e+01 -1.2050828933715820e+01 1.6125003051757812e+02)(-7.3863143920898438e+01 -1.3130586624145508e+01 1.6125001525878906e+02)(-8.9825271606445312e+01 -2.5200748443603516e+01 1.3050000000000000e+02)(-8.9594100952148438e+01 -2.6176630020141602e+01 1.3346551513671875e+02)(-9.1244758605957031e+01 -1.9413391113281250e+01 1.3050000000000000e+02)(7.2122238159179688e+01 -2.0990419387817383e+01 1.6774984741210938e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(6.7764801025390625e+01 -3.2242206573486328e+01 1.6774996948242188e+02)(4.3039344787597656e+01 6.1510375976562500e+01 1.6125001525878906e+02)(5.1484649658203125e+01 5.4627273559570312e+01 1.6125001525878906e+02)(3.5303173065185547e+01 3.9258464813232422e+01 1.6124998474121094e+02)(7.0409965515136719e+01 2.6376106262207031e+01 1.6774998474121094e+02)(7.4476074218750000e+01 9.6094312667846680e+00 1.6775006103515625e+02)(7.1929275512695312e+01 2.1703926086425781e+01 1.6125033569335938e+02)(-6.0711631774902344e+00 -5.2393779754638672e+01 1.5720002746582031e+02)(-1.6670688629150391e+01 -5.0302070617675781e+01 1.5719995117187500e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.5719999694824219e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 3.4884891510009766e+01)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(-3.8757396697998047e+01 -3.5818653106689453e+01 1.6125001525878906e+02)(-5.1205204010009766e+01 -5.4992069244384766e+01 1.6125010681152344e+02)(-5.9612304687500000e+01 -4.5636425018310547e+01 1.6125013732910156e+02)(-5.2768165588378906e+01 -1.1368683772161603e-13 1.5719999694824219e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(7.1186248779296875e+01 -2.1818662643432617e+01 1.2777687835693359e+02)(7.0318603515625000e+01 -2.2694311141967773e+01 1.3049975585937500e+02)(6.8199630737304688e+01 -2.4393993377685547e+01 1.2817570495605469e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(3.0666088104248047e+01 -4.2930080413818359e+01 1.6125003051757812e+02)(4.0172702789306641e+01 -3.4223472595214844e+01 1.6125001525878906e+02)(8.3728973388671875e+01 4.1508079528808594e+01 1.3050010681152344e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.3050000000000000e+02)(-2.8861297607421875e+01 5.4849514007568359e+01 1.3050000000000000e+02)(2.7500000000000000e+01 -8.3500000000000000e+01 8.8128768920898438e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 8.8271492004394531e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 3.4884891510009766e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 8.8271492004394531e+01)(-2.7500000000000000e+01 8.6500000000000000e+01 2.3751937866210938e+01)(-2.7500000000000000e+01 8.6500000000000000e+01 3.5527136788005009e-13)(-2.7500000000000000e+01 8.3500000000000000e+01 3.2684965844964609e-13)(7.1031112670898438e+00 -8.3500007629394531e+01 -2.6709621429443359e+01)(-2.7169082641601562e+01 -8.3500198364257812e+01 -4.6480736732482910e+00)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(-8.5401557922363281e+01 -3.7751152038574219e+01 1.3050007629394531e+02)(-8.0403465270996094e+01 -4.7990089416503906e+01 1.3049998474121094e+02)(-8.2998054504394531e+01 -4.3143230438232422e+01 1.3346554565429688e+02)(-4.3893966674804688e+01 -2.9079030990600586e+01 1.5720005798339844e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(-5.4540454864501953e+01 -5.5304397583007812e+01 1.5719999694824219e+02)(5.1869064331054688e+01 9.6966800689697266e+00 1.6124987792968750e+02)(7.4678085327148438e+01 7.8352298736572266e+00 1.6124992370605469e+02)(5.2745903015136719e+01 -3.9014687538146973e+00 1.6124996948242188e+02)(-1.6159154891967773e+01 -8.6499969482421875e+01 -2.2321565628051758e+01)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(-2.7500000000000000e+01 -8.6500000000000000e+01 3.2684965844964609e-13)(2.7500000000000000e+01 8.6500000000000000e+01 -1.1368683772161603e-13)(-7.9875040054321289e+00 8.6500000000000000e+01 -2.6395946502685547e+01)(2.7500000000000000e+01 8.6500000000000000e+01 3.2219860076904297e+01)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(7.1680549621582031e+01 2.1239969253540039e+01 7.7994125366210938e+01)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(7.2502433776855469e+01 -2.0005266189575195e+01 9.4783348083496094e+01)(7.1379814147949219e+01 -2.1636556625366211e+01 4.7111511230468750e+01)(7.3222488403320312e+01 -1.8595720291137695e+01 6.2816463470458984e+01)(7.1186248779296875e+01 -2.1818662643432617e+01 1.2777687835693359e+02)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(7.2502433776855469e+01 -2.0005266189575195e+01 9.4783348083496094e+01)(7.2823318481445312e+01 1.9345205307006836e+01 3.9796138763427734e+01)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(7.1680549621582031e+01 2.1239969253540039e+01 7.7994125366210938e+01)(-8.8907424926757812e+01 -2.0866981506347656e+01 -2.8244312286376953e+01)(-8.7477874755859375e+01 -2.2527986526489258e+01 -2.7026269912719727e+01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-8.9419967651367188e+01 -2.0000736236572266e+01 7.7060180664062500e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 6.7015830993652344e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.0392636108398438e+02)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.0392636108398438e+02)(-8.8547523498535156e+01 -2.1307743072509766e+01 6.7015830993652344e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 8.8908607482910156e+01)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 6.7015830993652344e+01)(-8.7431739807128906e+01 2.2651365280151367e+01 1.2877049255371094e+02)(-8.8356018066406250e+01 2.1567317962646484e+01 8.0790237426757812e+01)(-8.9781906127929688e+01 1.9380043029785156e+01 8.1771514892578125e+01)(7.1379814147949219e+01 -2.1636556625366211e+01 4.7111511230468750e+01)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(6.8767593383789062e+01 -2.3979000091552734e+01 2.7362794876098633e+00)(-8.5705986022949219e+01 2.4004983901977539e+01 6.3944019317626953e+01)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 6.0274906158447266e+01)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.5473192214965820e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 6.0335853576660156e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 6.0335853576660156e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.5473192214965820e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.2869000434875488e+01)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.5473192214965820e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 9.0658025741577148e+00)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.8246543407440186e+00)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.5473192214965820e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.8246543407440186e+00)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.0392636108398438e+02)(-8.7273971557617188e+01 -2.2735280990600586e+01 1.3049960327148438e+02)(6.8767593383789062e+01 -2.3979000091552734e+01 2.7362794876098633e+00)(6.8507911682128906e+01 -2.4144041061401367e+01 -2.4222715377807617e+01)(7.0774162292480469e+01 -2.2258674621582031e+01 -3.1769689559936523e+01)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(-8.2111740112304688e+01 -2.5678712844848633e+01 3.0747336149215698e-01)(-8.5023956298828125e+01 -2.4399051666259766e+01 -2.5528682708740234e+01)(-8.1410614013671875e+01 -2.5793256759643555e+01 1.2857640075683594e+02)(-8.3610725402832031e+01 -2.5091253280639648e+01 1.3050000000000000e+02)(-8.3615974426269531e+01 -2.5093389511108398e+01 1.0670562744140625e+02)(-8.3615974426269531e+01 -2.5093389511108398e+01 1.0670562744140625e+02)(-8.3610725402832031e+01 -2.5091253280639648e+01 1.3050000000000000e+02)(-8.5021507263183594e+01 -2.4398166656494141e+01 1.3050000000000000e+02)(-8.1370376586914062e+01 -2.5801153182983398e+01 8.5519851684570312e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 1.0670562744140625e+02)(-8.3615974426269531e+01 -2.5093389511108398e+01 5.9458190917968750e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 1.0670562744140625e+02)(-8.5023956298828125e+01 -2.4399049758911133e+01 7.9142021179199219e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 5.9458190917968750e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 -2.6119689941406250e+00)(-8.3615974426269531e+01 2.5093389511108398e+01 3.0410037994384766e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 3.0410037994384766e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 -2.6119689941406250e+00)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(-8.3615974426269531e+01 2.5093389511108398e+01 5.6142581939697266e+01)(-8.5705986022949219e+01 2.4004983901977539e+01 6.3944019317626953e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 7.4841636657714844e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 5.6142581939697266e+01)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(7.3756309509277344e+01 1.6941520690917969e+01 1.8675678253173828e+01)(7.2823318481445312e+01 1.9345205307006836e+01 3.9796138763427734e+01)(7.2512092590332031e+01 -1.9999502182006836e+01 -3.1132726669311523e+01)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(7.1535766601562500e+01 -2.1445131301879883e+01 -6.0370934009552002e-01)(7.4046676635742188e+01 1.4005400657653809e+01 1.0417015838623047e+02)(7.3945549011230469e+01 1.5571919441223145e+01 8.4393829345703125e+01)(7.3639289855957031e+01 1.7111631393432617e+01 1.0599861907958984e+02)(7.4046676635742188e+01 1.4005400657653809e+01 6.5748100280761719e+01)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(7.3945549011230469e+01 1.5571919441223145e+01 8.4393829345703125e+01)(7.3945549011230469e+01 1.5571919441223145e+01 8.4393829345703125e+01)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.2649586677551270e+01)(7.3756309509277344e+01 1.6941520690917969e+01 1.8675678253173828e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 1.0231732177734375e+02)(7.3951889038085938e+01 -1.5548828125000000e+01 1.2715247344970703e+02)(7.3639289855957031e+01 -1.7111631393432617e+01 9.8489746093750000e+01)(7.4068229675292969e+01 -1.4006268501281738e+01 1.0571428537368774e+00)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 3.4347324371337891e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.1235576629638672e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 5.7641921997070312e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 7.4841636657714844e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 8.6714447021484375e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 5.7641921997070312e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 8.6714447021484375e+01)(-8.1370376586914062e+01 -2.5801153182983398e+01 8.5519851684570312e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 8.4837234497070312e+01)(-8.1410614013671875e+01 -2.5793256759643555e+01 1.2857640075683594e+02)(-8.2111740112304688e+01 -2.5678712844848633e+01 3.0747336149215698e-01)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(-8.2073081970214844e+01 -2.5667484283447266e+01 3.7937202453613281e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 5.7641921997070312e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 3.4347324371337891e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 5.7641921997070312e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 3.4347324371337891e+01)(6.5149871826171875e+01 2.5598823547363281e+01 5.2388145446777344e+01)(6.6635116577148438e+01 2.5095191955566406e+01 6.7844734191894531e+01)(6.6635116577148438e+01 2.5095191955566406e+01 3.4834915161132812e+01)(6.6635116577148438e+01 2.5095191955566406e+01 3.4834915161132812e+01)(6.6635116577148438e+01 2.5095191955566406e+01 6.7844734191894531e+01)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(6.4391159057617188e+01 -2.5801763534545898e+01 1.0273176574707031e+02)(6.8199630737304688e+01 -2.4393993377685547e+01 1.2817570495605469e+02)(6.6933624267578125e+01 -2.5024982452392578e+01 1.3050001525878906e+02)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(6.4828872680664062e+01 -2.5737499237060547e+01 6.9435493469238281e+01)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.4391571044921875e+01 -2.5801553726196289e+01 -1.7952758789062500e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(6.8507911682128906e+01 -2.4144041061401367e+01 -2.4222715377807617e+01)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(6.5149871826171875e+01 2.5598823547363281e+01 8.1229072570800781e+01)(6.6635116577148438e+01 2.5095191955566406e+01 7.6718864440917969e+01)(6.6635116577148438e+01 2.5095191955566406e+01 6.7844734191894531e+01)(6.6635116577148438e+01 2.5095191955566406e+01 6.7844734191894531e+01)(6.6635116577148438e+01 2.5095191955566406e+01 7.6718864440917969e+01)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(-9.0820014953613281e+01 1.6348896026611328e+01 9.7063537597656250e+01)(-8.9908714294433594e+01 1.9126947402954102e+01 1.2754798126220703e+02)(-8.9781906127929688e+01 1.9380043029785156e+01 8.1771514892578125e+01)(-9.0644447326660156e+01 1.7214775085449219e+01 -2.9394233703613281e+01)(-9.0714019775390625e+01 1.7007638931274414e+01 1.3307831764221191e+01)(-8.9419967651367188e+01 2.0000736236572266e+01 9.4558744430541992e+00)(-9.0616600036621094e+01 -1.7108596801757812e+01 4.1612411499023438e+01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 4.4208824157714844e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 -6.9758973121643066e+00)(-9.0616600036621094e+01 -1.7108596801757812e+01 6.5488034486770630e-01)(-9.1023178100585938e+01 -1.4005400657653809e+01 7.4975730895996094e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 4.4208824157714844e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 7.4975730895996094e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(-9.0644447326660156e+01 1.7214775085449219e+01 -2.9394233703613281e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(-9.0714019775390625e+01 1.7007638931274414e+01 1.3307831764221191e+01)(6.2046672821044922e+01 2.6005401611328125e+01 1.1820683479309082e+01)(6.2046672821044922e+01 2.6005401611328125e+01 4.6390792846679688e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.5270380020141602e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(6.6393997192382812e+01 -2.5252225875854492e+01 -3.1769874572753906e+01)(6.4391571044921875e+01 -2.5801553726196289e+01 -1.7952758789062500e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 7.6523834228515625e+01)(6.4828872680664062e+01 -2.5737499237060547e+01 6.9435493469238281e+01)(6.4391159057617188e+01 -2.5801763534545898e+01 1.0273176574707031e+02)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(6.5149871826171875e+01 2.5598823547363281e+01 5.2388145446777344e+01)(6.2046672821044922e+01 2.6005401611328125e+01 4.6390792846679688e+01)(3.5303173065185547e+01 3.9258464813232422e+01 1.6124998474121094e+02)(4.1449623107910156e+01 3.2505737304687500e+01 1.5720005798339844e+02)(3.4075340270996094e+01 4.0295608520507812e+01 1.5719999694824219e+02)(-1.8078422546386719e+01 -4.9675231933593750e+01 1.6124993896484375e+02)(-3.0599491119384766e+01 -4.2939529418945312e+01 1.6125004577636719e+02)(-2.7031339645385742e+01 -4.5309486389160156e+01 1.5720002746582031e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-5.7099235534667969e+01 2.5740236282348633e+01 1.5719999694824219e+02)(-4.4190227508544922e+01 2.8773574829101562e+01 1.5719999694824219e+02)(-3.4358688354492188e+01 4.0060527801513672e+01 1.5720005798339844e+02)(-9.1191358566284180e+00 7.4532142639160156e+01 1.6125006103515625e+02)(-2.1266397476196289e+01 7.2026412963867188e+01 1.6125006103515625e+02)(-1.0214221000671387e+01 7.4392318725585938e+01 1.6775001525878906e+02)(-9.0607328414916992e+00 -7.4531417846679688e+01 1.6774998474121094e+02)(-2.1198894500732422e+01 -7.2015518188476562e+01 1.6774996948242188e+02)(-2.2035116195678711e+01 -7.1864418029785156e+01 1.6124995422363281e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 -3.0209545135498047e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(-9.0616600036621094e+01 -1.7108596801757812e+01 1.2893971252441406e+02)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(6.7951301574707031e+01 2.4542978286743164e+01 -3.1770818710327148e+01)(6.9582809448242188e+01 2.3433988571166992e+01 -2.7056911468505859e+01)(-8.8907424926757812e+01 -2.0866981506347656e+01 -2.8244312286376953e+01)(-8.5844612121582031e+01 -2.3929893493652344e+01 -3.1769815444946289e+01)(-8.7477874755859375e+01 -2.2527986526489258e+01 -2.7026269912719727e+01)(-8.5844612121582031e+01 -2.3929893493652344e+01 -3.1769815444946289e+01)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 -2.5528682708740234e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 -2.5528682708740234e+01)(-8.2111740112304688e+01 -2.5678712844848633e+01 3.0747336149215698e-01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-8.9642395019531250e+01 -1.9637180328369141e+01 1.3050077819824219e+02)(-8.9419967651367188e+01 -2.0000736236572266e+01 7.7060180664062500e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.0392636108398438e+02)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.0546226501464844e+02)(6.5149871826171875e+01 2.5598823547363281e+01 8.1229072570800781e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 1.2893971252441406e+02)(-8.7511779785156250e+01 2.2489559173583984e+01 6.0274906158447266e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-8.8356018066406250e+01 2.1567317962646484e+01 8.0790237426757812e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.0446272277832031e+02)(-8.3741844177246094e+01 2.5108713150024414e+01 1.0346186065673828e+02)(-8.3488998413085938e+01 2.5188650131225586e+01 1.3050068664550781e+02)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.0392636108398438e+02)(-8.7511779785156250e+01 -2.2489559173583984e+01 8.8908607482910156e+01)(-8.7273971557617188e+01 -2.2735280990600586e+01 1.3049960327148438e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 1.1235576629638672e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 -3.0209545135498047e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 4.4208824157714844e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 6.5488034486770630e-01)(-9.0616600036621094e+01 -1.7108596801757812e+01 4.1612411499023438e+01)(7.1379814147949219e+01 -2.1636556625366211e+01 4.7111511230468750e+01)(6.8767593383789062e+01 -2.3979000091552734e+01 2.7362794876098633e+00)(7.1535766601562500e+01 -2.1445131301879883e+01 -6.0370934009552002e-01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-8.7477874755859375e+01 -2.2527986526489258e+01 -2.7026269912719727e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 9.0658025741577148e+00)(7.4068229675292969e+01 -1.4006268501281738e+01 1.0571428537368774e+00)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(7.3639289855957031e+01 -1.7111631393432617e+01 -1.1437340736389160e+01)(7.2512092590332031e+01 -1.9999502182006836e+01 -3.1132726669311523e+01)(7.1535766601562500e+01 -2.1445131301879883e+01 -6.0370934009552002e-01)(7.0774162292480469e+01 -2.2258674621582031e+01 -3.1769689559936523e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 -1.1735793352127075e+00)(-8.7511779785156250e+01 2.2489559173583984e+01 1.4843739509582520e+01)(-8.7535324096679688e+01 2.2457002639770508e+01 -3.1769830703735352e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.0417015838623047e+02)(7.3639289855957031e+01 1.7111631393432617e+01 1.0599861907958984e+02)(7.3272308349609375e+01 1.8382198333740234e+01 1.3050190734863281e+02)(6.8042015075683594e+01 2.4402191162109375e+01 1.0512095642089844e+02)(6.9349021911621094e+01 2.3529741287231445e+01 8.0851188659667969e+01)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(-8.5023956298828125e+01 -2.4399051666259766e+01 3.0641633987426758e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 5.9458190917968750e+01)(-8.5023956298828125e+01 -2.4399049758911133e+01 7.9142021179199219e+01)(-8.9419967651367188e+01 2.0000736236572266e+01 9.4558744430541992e+00)(-8.8547523498535156e+01 2.1307743072509766e+01 -1.1735793352127075e+00)(-8.9515121459960938e+01 1.9935207366943359e+01 -3.1769947052001953e+01)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(6.6250129699707031e+01 -2.5284011840820312e+01 1.7463008880615234e+01)(6.8767593383789062e+01 -2.3979000091552734e+01 2.7362794876098633e+00)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(7.3222488403320312e+01 -1.8595720291137695e+01 6.2816463470458984e+01)(7.1379814147949219e+01 -2.1636556625366211e+01 4.7111511230468750e+01)(7.3756309509277344e+01 1.6941520690917969e+01 1.8675678253173828e+01)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(7.2823318481445312e+01 1.9345205307006836e+01 3.9796138763427734e+01)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(7.1379814147949219e+01 -2.1636556625366211e+01 4.7111511230468750e+01)(7.1535766601562500e+01 -2.1445131301879883e+01 -6.0370934009552002e-01)(6.2046672821044922e+01 2.6005401611328125e+01 4.6390792846679688e+01)(6.5149871826171875e+01 2.5598823547363281e+01 5.2388145446777344e+01)(6.5149871826171875e+01 2.5598823547363281e+01 1.5270380020141602e+01)(6.2046672821044922e+01 2.6005401611328125e+01 7.4695365905761719e+01)(6.5149871826171875e+01 2.5598823547363281e+01 8.1229072570800781e+01)(6.5149871826171875e+01 2.5598823547363281e+01 5.2388145446777344e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 6.0274906158447266e+01)(-8.7511779785156250e+01 2.2489559173583984e+01 1.4843739509582520e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 3.2153171539306641e+01)(-8.2073081970214844e+01 -2.5667484283447266e+01 3.7937202453613281e+01)(-8.1370376586914062e+01 -2.5801153182983398e+01 8.5519851684570312e+01)(-8.3615974426269531e+01 -2.5093389511108398e+01 5.9458190917968750e+01)(-8.6330505371093750e+01 -2.3525917053222656e+01 1.0792460632324219e+02)(-8.5023956298828125e+01 -2.4399049758911133e+01 7.9142021179199219e+01)(-8.5021507263183594e+01 -2.4398166656494141e+01 1.3050000000000000e+02)(-8.0589691162109375e+01 2.5904277801513672e+01 5.7641921997070312e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 2.7569828033447266e+01)(-8.2129409790039062e+01 2.5598011016845703e+01 7.4841636657714844e+01)(-8.9781906127929688e+01 1.9380043029785156e+01 8.1771514892578125e+01)(-8.9908714294433594e+01 1.9126947402954102e+01 1.2754798126220703e+02)(-8.7431739807128906e+01 2.2651365280151367e+01 1.2877049255371094e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.0231732177734375e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.2425885772705078e+02)(7.3951889038085938e+01 -1.5548828125000000e+01 1.2715247344970703e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.0417015838623047e+02)(7.4046676635742188e+01 1.4005400657653809e+01 6.5748100280761719e+01)(7.3945549011230469e+01 1.5571919441223145e+01 8.4393829345703125e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(7.4046676635742188e+01 -2.1977169513702393e+00 9.4352531433105469e+00)(7.4068229675292969e+01 -1.4006268501281738e+01 1.0571428537368774e+00)(-7.9023178100585938e+01 2.6005401611328125e+01 6.2481246948242188e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.1235576629638672e+01)(-8.0589691162109375e+01 2.5904277801513672e+01 3.4347324371337891e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.2649586677551270e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -1.4996746063232422e+01)(7.3756309509277344e+01 1.6941520690917969e+01 1.8675678253173828e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(7.3850120544433594e+01 1.6310745239257812e+01 -3.0784076690673828e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -1.4996746063232422e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(7.3951889038085938e+01 -1.5548828125000000e+01 1.2715247344970703e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.2425885772705078e+02)(-7.9023185729980469e+01 -2.6007728576660156e+01 1.1790208816528320e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 8.4837234497070312e+01)(-8.2073081970214844e+01 -2.5667484283447266e+01 3.7937202453613281e+01)(7.4046676635742188e+01 1.4005400657653809e+01 6.5748100280761719e+01)(7.4046676635742188e+01 1.4005400657653809e+01 3.6297683715820312e+01)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(7.4046676635742188e+01 1.4005400657653809e+01 3.6297683715820312e+01)(7.4046676635742188e+01 1.4005400657653809e+01 1.2649586677551270e+01)(7.3842453002929688e+01 1.6352560043334961e+01 3.2640762329101562e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 8.4837234497070312e+01)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-8.1410614013671875e+01 -2.5793256759643555e+01 1.2857640075683594e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(-9.1028137207031250e+01 1.4005443572998047e+01 9.1023721694946289e+00)(-9.0644447326660156e+01 1.7214775085449219e+01 -2.9394233703613281e+01)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(-8.8547523498535156e+01 -2.1307743072509766e+01 1.2869000434875488e+01)(7.3272308349609375e+01 1.8382198333740234e+01 1.3050190734863281e+02)(7.3186988830566406e+01 1.8607654571533203e+01 9.3047019958496094e+01)(7.0145812988281250e+01 2.2963018417358398e+01 1.3049995422363281e+02)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(6.8042007446289062e+01 2.4402191162109375e+01 4.8799829483032227e+00)(6.8042007446289062e+01 2.4402191162109375e+01 5.8726818084716797e+01)(-8.9419967651367188e+01 -2.0000736236572266e+01 7.7060180664062500e+01)(-8.9801719665527344e+01 -1.9341281890869141e+01 4.3038616180419922e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 6.7015830993652344e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 4.4208824157714844e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 4.1612411499023438e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 8.5714897155761719e+01)(7.3222488403320312e+01 -1.8595720291137695e+01 6.2816463470458984e+01)(7.3639289855957031e+01 -1.7111631393432617e+01 9.8489746093750000e+01)(7.2502433776855469e+01 -2.0005266189575195e+01 9.4783348083496094e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 6.9185600280761719e+01)(7.3222488403320312e+01 -1.8595720291137695e+01 6.2816463470458984e+01)(7.3421592712402344e+01 -1.7911386489868164e+01 2.8508438110351562e+01)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 9.0658025741577148e+00)(-8.6330505371093750e+01 -2.3525917053222656e+01 2.5473192214965820e+01)(-8.8547523498535156e+01 -2.1307743072509766e+01 6.7015830993652344e+01)(-8.7983680725097656e+01 -2.2025215148925781e+01 4.1770877838134766e+01)(-8.7511779785156250e+01 -2.2489559173583984e+01 8.8908607482910156e+01)(7.1680549621582031e+01 2.1239969253540039e+01 7.7994125366210938e+01)(7.0301490783691406e+01 2.2780668258666992e+01 2.3175428390502930e+01)(6.9349021911621094e+01 2.3529741287231445e+01 8.0851188659667969e+01)(-8.9032020568847656e+01 2.0674293518066406e+01 5.0998508453369141e+01)(-8.8547523498535156e+01 2.1307743072509766e+01 3.2153171539306641e+01)(-8.9419967651367188e+01 2.0000736236572266e+01 9.4558744430541992e+00)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(7.1186248779296875e+01 -2.1818662643432617e+01 1.2777687835693359e+02)(6.8199630737304688e+01 -2.4393993377685547e+01 1.2817570495605469e+02)(-8.1410614013671875e+01 -2.5793256759643555e+01 1.2857640075683594e+02)(-8.3615974426269531e+01 -2.5093389511108398e+01 1.0670562744140625e+02)(-8.1370376586914062e+01 -2.5801153182983398e+01 8.5519851684570312e+01)(7.2502433776855469e+01 -2.0005266189575195e+01 9.4783348083496094e+01)(6.9195892333984375e+01 -2.3701536178588867e+01 6.1189132690429688e+01)(7.1379814147949219e+01 -2.1636556625366211e+01 4.7111511230468750e+01)(-9.0616600036621094e+01 -1.7108596801757812e+01 6.5488034486770630e-01)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-8.9560356140136719e+01 -1.9873533248901367e+01 -1.5758405923843384e+00)(7.3756309509277344e+01 1.6941520690917969e+01 1.8675678253173828e+01)(7.3850120544433594e+01 1.6310745239257812e+01 -3.0784076690673828e+01)(7.2436782836914062e+01 2.0139514923095703e+01 -2.8579622268676758e+01)(-8.5644157409667969e+01 2.4045246124267578e+01 1.5285170555114746e+01)(-8.3615974426269531e+01 2.5093389511108398e+01 -2.6119689941406250e+00)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(6.4919387817382812e+01 -3.7795818328857422e+01 1.6125027465820312e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(6.7764801025390625e+01 -3.2242206573486328e+01 1.6774996948242188e+02)(2.4536960601806641e+01 4.6794597625732422e+01 1.6124983215332031e+02)(3.4075340270996094e+01 4.0295608520507812e+01 1.5719999694824219e+02)(2.4404411315917969e+01 4.6824039459228516e+01 1.5719995117187500e+02)(-8.7560592651367188e+01 1.7757962644100189e-01 1.5720011901855469e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(-5.2769325256347656e+01 -1.2287213802337646e+00 1.6124995422363281e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(-5.2412345886230469e+01 6.5029921531677246e+00 1.5719999694824219e+02)(6.7951301574707031e+01 2.4542978286743164e+01 -3.1770818710327148e+01)(7.3127746582031250e+01 1.8871967315673828e+01 -3.1769943237304688e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-2.7500000000000000e+01 8.3500000000000000e+01 3.2684965844964609e-13)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(2.7500000000000000e+01 8.3500000000000000e+01 -8.5265128291212022e-14)(-5.1931579589843750e+01 5.4333858489990234e+01 1.6125000000000000e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(-6.2900997161865234e+01 4.1064804077148438e+01 1.6125006103515625e+02)(-2.3315937042236328e+01 -8.6499832153320312e+01 -1.4633215904235840e+01)(-1.6159154891967773e+01 -8.6499969482421875e+01 -2.2321565628051758e+01)(-2.6530216217041016e+01 -8.6500022888183594e+01 -7.6352477073669434e+00)(6.2293994903564453e+01 -4.1157024383544922e+01 1.5720001220703125e+02)(6.6161926269531250e+01 -3.4574485778808594e+01 1.5720005798339844e+02)(5.4976158142089844e+01 -3.7404087066650391e+01 1.5719999694824219e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(-4.8918796539306641e+01 -5.9330558776855469e+01 1.3346546936035156e+02)(-5.9879058837890625e+01 -5.0929645538330078e+01 1.3346559143066406e+02)(-8.5377494812011719e+01 1.4220652580261230e+01 1.3346554565429688e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(-8.7257682800292969e+01 5.3665590286254883e+00 1.3346563720703125e+02)(9.0933486938476562e+01 2.1264158248901367e+01 1.3346549987792969e+02)(7.2840324401855469e+01 1.6688291549682617e+01 1.3346591186523438e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(8.3348693847656250e+00 7.4622276306152344e+01 1.6124992370605469e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(8.1294532775878906e+01 -4.6588893890380859e+01 1.3346530151367188e+02)(7.0521041870117188e+01 -2.4467180252075195e+01 1.3346548461914062e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(7.3127746582031250e+01 1.8871967315673828e+01 -3.1769943237304688e+01)(7.4046676635742188e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.3050000000000000e+02)(6.2046672821044922e+01 2.6005401611328125e+01 1.3050000000000000e+02)(-4.4139652252197266e+01 5.3079219818115234e+01 1.3050000000000000e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-3.8026851654052734e+01 6.5685386657714844e+01 1.3050004577636719e+02)(4.1449623107910156e+01 3.2505737304687500e+01 1.5720005798339844e+02)(6.8471626281738281e+01 2.9723161697387695e+01 1.5719995117187500e+02)(6.3920379638671875e+01 3.8730957031250000e+01 1.5720005798339844e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(3.3814022064208984e+01 -5.9495456695556641e+01 1.3050000000000000e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.3050000000000000e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-6.3029327392578125e+01 4.7988216400146484e+01 1.3346551513671875e+02)(-5.7800388336181641e+01 6.2188003540039062e+01 1.3346551513671875e+02)(7.4703033447265625e+01 -3.2683925628662109e+00 1.5720013427734375e+02)(7.4012634277343750e+01 1.0421646118164062e+01 1.5719998168945312e+02)(5.2768165588378906e+01 -1.5276668818842154e-13 1.5719999694824219e+02)(-6.8931365966796875e+01 -4.1853664398193359e+01 1.5719999694824219e+02)(-6.2738201141357422e+01 -4.8272773742675781e+01 1.5719996643066406e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-8.0403465270996094e+01 -4.7990089416503906e+01 1.3049998474121094e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-8.5866577148437500e+01 -1.2403345108032227e+01 1.5719999694824219e+02)(-8.3394485473632812e+01 -1.9708364486694336e+01 1.3346574401855469e+02)(-8.1801506042480469e+01 -2.3221632003784180e+01 1.5719999694824219e+02)(-3.8026851654052734e+01 6.5685386657714844e+01 1.3050004577636719e+02)(-3.4890045166015625e+01 6.7120681762695312e+01 1.5719998168945312e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.5719999694824219e+02)(-3.6399375915527344e+01 -6.6452644348144531e+01 1.3050004577636719e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.3050000000000000e+02)(-3.4647197723388672e+01 -6.7212234497070312e+01 1.5719995117187500e+02)(3.3510765075683594e+01 -6.7240554809570312e+01 1.6774996948242188e+02)(4.5799865722656250e+01 -5.9457805633544922e+01 1.6774998474121094e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(5.5023292541503906e+01 -5.1138046264648438e+01 1.6774993896484375e+02)(7.0409965515136719e+01 2.6376106262207031e+01 1.6774998474121094e+02)(-2.7711166694643907e-13 -5.2680000305175781e+01 1.6125000000000000e+02)(-8.8923892974853516e+00 -7.4528411865234375e+01 1.6124995422363281e+02)(-1.8078422546386719e+01 -4.9675231933593750e+01 1.6124993896484375e+02)(-6.0711631774902344e+00 -5.2393779754638672e+01 1.5720002746582031e+02)(-1.8078422546386719e+01 -4.9675231933593750e+01 1.6124993896484375e+02)(-1.6670688629150391e+01 -5.0302070617675781e+01 1.5719995117187500e+02)(-8.4838142395019531e+01 3.8973972320556641e+01 1.3346549987792969e+02)(-8.2037712097167969e+01 4.5078964233398438e+01 1.3049998474121094e+02)(-8.8347320556640625e+01 3.0021541595458984e+01 1.3049998474121094e+02)(2.7500000000000000e+01 -8.6500000000000000e+01 3.4884891510009766e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 8.8271492004394531e+01)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(2.7500000000000000e+01 6.9362617492675781e+01 1.3050000000000000e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.5719999694824219e+02)(3.1197740554809570e+01 6.7802062988281250e+01 1.5719993591308594e+02)(-8.9594100952148438e+01 -2.6176630020141602e+01 1.3346551513671875e+02)(-9.2919418334960938e+01 -1.0094609260559082e+01 1.3346545410156250e+02)(-9.2873863220214844e+01 -1.0607085227966309e+01 1.3049984741210938e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.3050000000000000e+02)(3.1197740554809570e+01 6.7802062988281250e+01 1.5719993591308594e+02)(3.6877834320068359e+01 6.4938354492187500e+01 1.3050019836425781e+02)(3.1197740554809570e+01 6.7802062988281250e+01 1.5719993591308594e+02)(3.7757694244384766e+01 6.4393600463867188e+01 1.5720001220703125e+02)(3.6877834320068359e+01 6.4938354492187500e+01 1.3050019836425781e+02)(5.2768165588378906e+01 -1.5276668818842154e-13 1.5719999694824219e+02)(5.1936588287353516e+01 -9.3247003555297852e+00 1.5720001220703125e+02)(7.0440612792968750e+01 -2.4795007705688477e+01 1.5719992065429688e+02)(-2.5185577392578125e+01 4.6444450378417969e+01 1.6124961853027344e+02)(-1.5251138687133789e+01 5.0588748931884766e+01 1.5719985961914062e+02)(-2.4782356262207031e+01 4.6653167724609375e+01 1.5720001220703125e+02)(7.4012634277343750e+01 1.0421646118164062e+01 1.5719998168945312e+02)(7.2840324401855469e+01 1.6688291549682617e+01 1.3346591186523438e+02)(7.1889564514160156e+01 2.0188781738281250e+01 1.5719985961914062e+02)(3.7757694244384766e+01 6.4393600463867188e+01 1.5720001220703125e+02)(4.3751384735107422e+01 6.0545715332031250e+01 1.5719996643066406e+02)(3.6877834320068359e+01 6.4938354492187500e+01 1.3050019836425781e+02)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(2.7500000000000000e+01 -8.3500000000000000e+01 8.8128768920898438e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 3.4884891510009766e+01)(-8.5844612121582031e+01 -2.3929893493652344e+01 -3.1769815444946289e+01)(-9.0190704345703125e+01 -1.8723707199096680e+01 -3.1769975662231445e+01)(-8.2176124572753906e+01 -2.5651206970214844e+01 -3.1769256591796875e+01)(4.1793392181396484e+01 -6.1974334716796875e+01 1.5719990539550781e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(4.8286041259765625e+01 -5.7161788940429688e+01 1.3346569824218750e+02)(7.4012634277343750e+01 1.0421646118164062e+01 1.5719998168945312e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(7.2840324401855469e+01 1.6688291549682617e+01 1.3346591186523438e+02)(6.1565635681152344e+01 4.2239334106445312e+01 1.3346557617187500e+02)(5.5273727416992188e+01 5.0349800109863281e+01 1.3346554565429688e+02)(5.6196445465087891e+01 4.9302890777587891e+01 1.5719982910156250e+02)(7.4448554992675781e+01 -6.6282186508178711e+00 1.3346574401855469e+02)(7.4670478820800781e+01 3.8160169124603271e+00 1.3346557617187500e+02)(7.4703033447265625e+01 -3.2683925628662109e+00 1.5720013427734375e+02)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(4.8286041259765625e+01 -5.7161788940429688e+01 1.3346569824218750e+02)(5.6767070770263672e+01 -4.8697395324707031e+01 1.5720005798339844e+02)(4.9493560791015625e+01 -5.5952938079833984e+01 1.5719999694824219e+02)(8.9427154541015625e+01 -2.6915592193603516e+01 1.3346551513671875e+02)(8.8046340942382812e+01 -3.1130365371704102e+01 1.3049987792968750e+02)(9.2097923278808594e+01 -1.5517567634582520e+01 1.3049993896484375e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 5.8841522216796875e+01)(2.7500000000000000e+01 -8.3500000000000000e+01 8.8128768920898438e+01)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(-2.7500000000000000e+01 8.3500000000000000e+01 6.1463169097900391e+01)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 3.1974423109204508e-13)(-2.7500000000000000e+01 -8.3500000000000000e+01 5.8841522216796875e+01)(2.7500000000000000e+01 -8.3500000000000000e+01 -1.0658141036401503e-13)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-7.1506225585937500e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-6.6067413330078125e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(-2.7711166694643907e-13 -5.2680000305175781e+01 1.6125000000000000e+02)(1.0787144660949707e+01 -5.1746307373046875e+01 1.6124987792968750e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(-2.0086696520503489e-13 -7.5000000000000000e+01 1.6775000000000000e+02)(7.4961767196655273e+00 -7.4684196472167969e+01 1.6775001525878906e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(-6.2738201141357422e+01 -4.8272773742675781e+01 1.5719996643066406e+02)(-5.4540454864501953e+01 -5.5304397583007812e+01 1.5719999694824219e+02)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-1.8142257690429688e+01 -2.6005401611328125e+01 -3.1769830703735352e+01)(4.1298755645751953e+01 6.2188003540039062e+01 1.3346551513671875e+02)(6.5464729309082031e+01 6.2188003540039062e+01 1.3050000000000000e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(-2.8861297607421875e+01 5.4849514007568359e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 7.0010139465332031e+01 1.3050000000000000e+02)(-1.7509630918502808e+00 2.6005401611328125e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -7.0010139465332031e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(2.7500000000000000e+01 8.3500000000000000e+01 1.3050000000000000e+02)(2.7500000000000000e+01 8.6500000000000000e+01 1.5719999694824219e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.5719999694824219e+02)(8.9427154541015625e+01 -2.6915592193603516e+01 1.3346551513671875e+02)(7.0521041870117188e+01 -2.4467180252075195e+01 1.3346548461914062e+02)(8.1294532775878906e+01 -4.6588893890380859e+01 1.3346530151367188e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(3.4291679382324219e+01 6.6874122619628906e+01 1.6774981689453125e+02)(2.2981338500976562e+01 7.1454238891601562e+01 1.6774993896484375e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(2.7500000000000000e+01 -6.9362617492675781e+01 1.3050000000000000e+02)(2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(-3.1266868591308594e+01 -6.2015098571777344e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(-7.9023178100585938e+01 2.6005401611328125e+01 1.1235576629638672e+01)(6.2046672821044922e+01 2.6005401611328125e+01 -3.1769830703735352e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 7.6523834228515625e+01)(6.2046672821044922e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-1.1993492126464844e+01 5.1369159698486328e+01 1.6124972534179688e+02)(-3.0879575729370117e+01 6.8372200012207031e+01 1.6125003051757812e+02)(-2.1266397476196289e+01 7.2026412963867188e+01 1.6125006103515625e+02)(-7.3578536987304688e+01 1.4789866447448730e+01 1.6125001525878906e+02)(-7.4968612670898438e+01 -3.4747965335845947e+00 1.6125009155273438e+02)(-7.4888923645019531e+01 4.7028226852416992e+00 1.6125001525878906e+02)(9.6112070083618164e+00 5.1957012176513672e+01 1.6125001525878906e+02)(2.4536960601806641e+01 4.6794597625732422e+01 1.6124983215332031e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(-8.9515121459960938e+01 1.9935207366943359e+01 -3.1769947052001953e+01)(-8.5202804565429688e+01 2.4371303558349609e+01 -3.1769815444946289e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(-6.3029327392578125e+01 4.7988216400146484e+01 1.3346551513671875e+02)(-7.8516853332519531e+01 5.1479923248291016e+01 1.3346551513671875e+02)(-6.9660385131835938e+01 4.1024261474609375e+01 1.3346549987792969e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(4.7890579223632812e+01 5.7901737213134766e+01 1.6774998474121094e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(5.1484649658203125e+01 5.4627273559570312e+01 1.6125001525878906e+02)(4.4417877197265625e+01 2.8603290557861328e+01 1.6125006103515625e+02)(3.5303173065185547e+01 3.9258464813232422e+01 1.6124998474121094e+02)(8.1439865112304688e+01 4.6165725708007812e+01 1.3346539306640625e+02)(8.6536094665527344e+01 3.4835777282714844e+01 1.3346551513671875e+02)(8.3728973388671875e+01 4.1508079528808594e+01 1.3050010681152344e+02)(2.2981338500976562e+01 7.1454238891601562e+01 1.6774993896484375e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(1.1500982284545898e+01 7.4240890502929688e+01 1.6775001525878906e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-4.9750961303710938e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-4.9750961303710938e+01 6.2188003540039062e+01 1.3050000000000000e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-4.4312145233154297e+01 6.2188003540039062e+01 1.3050000000000000e+02)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(7.1506225585937500e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(-9.1191358566284180e+00 7.4532142639160156e+01 1.6125006103515625e+02)(-2.7711166694643907e-13 7.5000000000000000e+01 1.6125000000000000e+02)(-3.3511653900146484e+01 -6.7201721191406250e+01 1.6775006103515625e+02)(-2.1198894500732422e+01 -7.2015518188476562e+01 1.6774996948242188e+02)(-9.0607328414916992e+00 -7.4531417846679688e+01 1.6774998474121094e+02)(6.3744419097900391e+01 -3.9105220794677734e+01 1.3346539306640625e+02)(7.0521041870117188e+01 -2.4467180252075195e+01 1.3346548461914062e+02)(6.8085754394531250e+01 -3.0548526763916016e+01 1.3435859680175781e+02)(2.0353624343872070e+01 7.2285522460937500e+01 1.6124996948242188e+02)(-2.7711166694643907e-13 7.5000000000000000e+01 1.6125000000000000e+02)(8.3348693847656250e+00 7.4622276306152344e+01 1.6124992370605469e+02)(-3.1505632400512695e+01 6.8185791015625000e+01 1.6774995422363281e+02)(-2.1306856155395508e+01 7.1962928771972656e+01 1.6774993896484375e+02)(-2.1266397476196289e+01 7.2026412963867188e+01 1.6125006103515625e+02)(3.3510765075683594e+01 -6.7240554809570312e+01 1.6774996948242188e+02)(1.8422235488891602e+01 -7.2828826904296875e+01 1.6774990844726562e+02)(2.1243343353271484e+01 -7.2030403137207031e+01 1.6124998474121094e+02)(-7.3578536987304688e+01 1.4789866447448730e+01 1.6125001525878906e+02)(-6.9965950012207031e+01 2.7403331756591797e+01 1.6125001525878906e+02)(-5.1388313293457031e+01 1.2026908874511719e+01 1.6125000000000000e+02)(-5.7060512542724609e+01 4.8739387512207031e+01 1.6774998474121094e+02)(-6.3077995300292969e+01 4.0631622314453125e+01 1.6774984741210938e+02)(-4.8890350341796875e+01 5.6930206298828125e+01 1.6775000000000000e+02)(-3.8157699584960938e+01 -6.4664611816406250e+01 1.6124998474121094e+02)(-3.0599491119384766e+01 -4.2939529418945312e+01 1.6125004577636719e+02)(-2.2035116195678711e+01 -7.1864418029785156e+01 1.6124995422363281e+02)(6.7167518615722656e+01 3.3453254699707031e+01 1.6125001525878906e+02)(6.1233039855957031e+01 4.3551002502441406e+01 1.6125006103515625e+02)(6.3444847106933594e+01 4.0103900909423828e+01 1.6774978637695312e+02)(-8.9039299011230469e+01 2.1004236221313477e+01 1.3050039672851562e+02)(-9.0747459411621094e+01 1.6444686889648438e+01 1.3050000000000000e+02)(-9.1357238769531250e+01 1.9070823669433594e+01 1.3049990844726562e+02)(-1.3970300674438477e+01 -8.3499824523925781e+01 -2.3669649124145508e+01)(-2.7169082641601562e+01 -8.3500198364257812e+01 -4.6480736732482910e+00)(-4.1763257980346680e+00 -8.3499992370605469e+01 -2.7412359237670898e+01)(7.2606910705566406e+01 -1.7419267654418945e+01 1.3346551513671875e+02)(7.4448554992675781e+01 -6.6282186508178711e+00 1.3346574401855469e+02)(7.3826629638671875e+01 -1.1329031944274902e+01 1.4933326721191406e+02)(7.0053070068359375e+01 2.5780675888061523e+01 1.3346554565429688e+02)(6.5599250793457031e+01 3.5677104949951172e+01 1.3346554565429688e+02)(6.8471626281738281e+01 2.9723161697387695e+01 1.5719995117187500e+02)(7.1929275512695312e+01 2.1703926086425781e+01 1.6125033569335938e+02)(6.7167518615722656e+01 3.3453254699707031e+01 1.6125001525878906e+02)(7.0409965515136719e+01 2.6376106262207031e+01 1.6774998474121094e+02)(5.1869064331054688e+01 9.6966800689697266e+00 1.6124987792968750e+02)(7.1929275512695312e+01 2.1703926086425781e+01 1.6125033569335938e+02)(7.4678085327148438e+01 7.8352298736572266e+00 1.6124992370605469e+02)(-5.1959529876708984e+01 -9.1832647323608398e+00 1.5720005798339844e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(-4.8973659515380859e+01 -1.9622596740722656e+01 1.5720005798339844e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(7.1506225585937500e+01 6.2188003540039062e+01 1.3346551513671875e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3346551513671875e+02)(-8.5866577148437500e+01 -1.2403345108032227e+01 1.5719999694824219e+02)(-8.1801506042480469e+01 -2.3221632003784180e+01 1.5719999694824219e+02)(-8.7256286621093750e+01 -5.4364528656005859e+00 1.5719989013671875e+02)(1.0787144660949707e+01 -5.1746307373046875e+01 1.6124987792968750e+02)(1.4429249763488770e+01 -5.0916908264160156e+01 1.5719999694824219e+02)(2.2079833984375000e+01 -4.7860900878906250e+01 1.6125001525878906e+02)(-9.1023178100585938e+01 -1.4005400657653809e+01 7.4975730895996094e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 1.3050000000000000e+02)(-9.1023178100585938e+01 1.4005400657653809e+01 1.2425885772705078e+02)(-8.0403465270996094e+01 -4.7990089416503906e+01 1.3049998474121094e+02)(-8.5401557922363281e+01 -3.7751152038574219e+01 1.3050007629394531e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-6.9660385131835938e+01 4.1024261474609375e+01 1.3346549987792969e+02)(-7.5526336669921875e+01 3.3584129333496094e+01 1.3346542358398438e+02)(-7.1289993286132812e+01 3.9113079071044922e+01 1.5719992065429688e+02)(-5.7104511260986328e+01 -6.2188003540039062e+01 1.3346551513671875e+02)(-4.8918796539306641e+01 -5.9330558776855469e+01 1.3346546936035156e+02)(-7.4969779968261719e+01 -5.7055526733398438e+01 1.3346551513671875e+02)(-7.4968612670898438e+01 -3.4747965335845947e+00 1.6125009155273438e+02)(-7.4721839904785156e+01 7.6030898094177246e+00 1.6775006103515625e+02)(-7.4888923645019531e+01 4.7028226852416992e+00 1.6125001525878906e+02)(8.1439865112304688e+01 4.6165725708007812e+01 1.3346539306640625e+02)(7.0053070068359375e+01 2.5780675888061523e+01 1.3346554565429688e+02)(9.0933486938476562e+01 2.1264158248901367e+01 1.3346549987792969e+02)(4.9453201293945312e+01 1.8237962722778320e+01 1.6124995422363281e+02)(5.1869064331054688e+01 9.6966800689697266e+00 1.6124987792968750e+02)(5.1381282806396484e+01 1.1961022377014160e+01 1.5720007324218750e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(2.7500000000000000e+01 6.9362617492675781e+01 1.5719999694824219e+02)(1.3835906982421875e+01 5.1038253784179688e+01 1.5719999694824219e+02)(2.5842729568481445e+01 8.6500991821289062e+01 -1.0067432403564453e+01)(2.6825448989868164e+01 8.3500007629394531e+01 -7.1016974449157715e+00)(2.2083520889282227e+01 8.3499839782714844e+01 -1.6511587142944336e+01)(-2.7218658447265625e+01 8.6500053405761719e+01 -4.2035999298095703e+00)(-2.4658794403076172e+01 8.6499664306640625e+01 -1.2483454704284668e+01)(-2.6133790969848633e+01 8.3499389648437500e+01 -9.0429000854492188e+00)(-2.7500000000000000e+01 -8.6500000000000000e+01 1.5719999694824219e+02)(-2.7500000000000000e+01 -8.3500000000000000e+01 1.3050000000000000e+02)(-2.7500000000000000e+01 -8.6500000000000000e+01 9.5855155944824219e+01)(3.0666088104248047e+01 -4.2930080413818359e+01 1.6125003051757812e+02)(7.1105758666992188e+01 -2.4090614318847656e+01 1.6125004577636719e+02)(6.4919387817382812e+01 -3.7795818328857422e+01 1.6125027465820312e+02)(-9.3285728454589844e+01 7.6760721206665039e+00 1.3346549987792969e+02)(-9.2919418334960938e+01 -1.0094609260559082e+01 1.3346545410156250e+02)(-8.6333305358886719e+01 -1.0644967079162598e+01 1.3346554565429688e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(3.3814022064208984e+01 -5.9495456695556641e+01 1.3050000000000000e+02)(4.1298755645751953e+01 6.2188003540039062e+01 1.3346551513671875e+02)(4.8824459075927734e+01 5.6570331573486328e+01 1.3346582031250000e+02)(6.5840560913085938e+01 4.9969528198242188e+01 1.3346551513671875e+02)(1.6159154891967773e+01 -8.3500167846679688e+01 -2.2321565628051758e+01)(1.3515126228332520e+01 -8.6500030517578125e+01 -2.3961565017700195e+01)(7.1031112670898438e+00 -8.3500007629394531e+01 -2.6709621429443359e+01)(7.4046676635742188e+01 -1.4005400657653809e+01 1.0231732177734375e+02)(7.4046676635742188e+01 1.4005400657653809e+01 1.3050000000000000e+02)(7.4046676635742188e+01 -1.4005400657653809e+01 1.2425885772705078e+02)(-7.9023178100585938e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(-3.1266868591308594e+01 -6.2015098571777344e+01 1.3050000000000000e+02)(-4.4312145233154297e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(3.1197740554809570e+01 6.7802062988281250e+01 1.5719993591308594e+02)(2.8469144821166992e+01 5.3159366607666016e+01 1.5719999694824219e+02)(3.7757694244384766e+01 6.4393600463867188e+01 1.5720001220703125e+02)(2.7169080734252930e+01 -8.6499954223632812e+01 -4.6480798721313477e+00)(2.7500000000000000e+01 -8.6500000000000000e+01 -1.4210854715202004e-13)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(2.6533561706542969e+01 -8.3500000000000000e+01 -7.6685323715209961e+00)(2.4910627365112305e+01 -8.6500000000000000e+01 -1.1930105209350586e+01)(2.3315935134887695e+01 -8.3500228881835938e+01 -1.4633216857910156e+01)(-2.4810487747192383e+01 -8.3499771118164062e+01 -1.2105969429016113e+01)(-2.3315937042236328e+01 -8.6499832153320312e+01 -1.4633215904235840e+01)(-2.6530216217041016e+01 -8.6500022888183594e+01 -7.6352477073669434e+00)(6.7167518615722656e+01 3.3453254699707031e+01 1.6125001525878906e+02)(7.1929275512695312e+01 2.1703926086425781e+01 1.6125033569335938e+02)(4.4417877197265625e+01 2.8603290557861328e+01 1.6125006103515625e+02)(-8.7273971557617188e+01 -2.2735280990600586e+01 1.3049960327148438e+02)(-8.5021507263183594e+01 -2.4398166656494141e+01 1.3050000000000000e+02)(-8.9825271606445312e+01 -2.5200748443603516e+01 1.3050000000000000e+02)(-7.5364570617675781e+01 -7.2461426258087158e-01 -3.1769830703735352e+01)(-9.1023178100585938e+01 -1.4005400657653809e+01 -3.1769830703735352e+01)(-9.1023178100585938e+01 1.4005400657653809e+01 -3.1769830703735352e+01)(4.1298755645751953e+01 -6.2188003540039062e+01 1.3050000000000000e+02)(6.2046672821044922e+01 -2.6005401611328125e+01 1.3050000000000000e+02)(6.6933624267578125e+01 -2.5024982452392578e+01 1.3050001525878906e+02)(7.4929084777832031e+01 -4.1990342140197754e+00 1.6125000000000000e+02)(5.2