# Try to find shared object of the urdf library

SET (URDF_FOUND FALSE)

FIND_PROGRAM(ROSPACK rospack)
IF(NOT ROSPACK)
	MESSAGE(FATAL_ERROR "failed to find the rospack binary. Is ROS installed?")
ENDIF()

EXEC_PROGRAM("${ROSPACK} find ${PKG}" OUTPUT_VARIABLE ${PKG}_ROS_PREFIX)
IF(NOT ${PKG}_ROS_PREFIX)
  MESSAGE(FATAL_ERROR "Failed to detect ${PKG}.")
ENDIF()

EXEC_PROGRAM("${ROSPACK} find urdf" OUTPUT_VARIABLE URDF_FULL_PATH)

FIND_PATH (URDF_INCLUDE_DIR urdf/model.h ${URDF_FULL_PATH}/include)
FIND_LIBRARY (URDF_LIBRARY urdf ${URDF_FULL_PATH}/lib)

IF (URDF_INCLUDE_DIR AND URDF_LIBRARY)
	SET (URDF_FOUND TRUE)
ENDIF (URDF_INCLUDE_DIR AND URDF_LIBRARY)

IF (URDF_FOUND)
   IF (NOT URDF_FIND_QUIETLY)
      MESSAGE(STATUS "Found URDF: ${URDF_LIBRARY}")
   ENDIF (NOT URDF_FIND_QUIETLY)
ELSE (URDF_FOUND)
   IF (URDF_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find URDF")
   ENDIF (URDF_FIND_REQUIRED)
ENDIF (URDF_FOUND)

MARK_AS_ADVANCED (
	URDF_INCLUDE_DIR
	URDF_LIBRARY
	)
