/*
 * This file is part of rostune
 * https://github.com/roboskel/rostune
 *
 * BSD 3-Clause License
 * Copyright (c) 2017, NCSR "Demokritos"
 * All rights reserved.
 *
 * Authors:
 * Georgios Stavrinos, https://github.com/gstavrinos
 * Stasinos Konstantopoulos, https://github.com/stasinos
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the conditions at the
 * bottom of this file are met.
 */


// %Tag(FULLTEXT)%
// %Tag(ROS_HEADER)%
#include "ros/ros.h"
// %EndTag(ROS_HEADER)%

#include <sstream>

#include <sys/sysinfo.h>

#include "ros/master.h"
#include "ros/xmlrpc_manager.h"

namespace nodestats {

  class NodeStats
  {
    public:

    std::string name;
    uint64_t  prevcputimes;
    uint64_t prevwalltimes;
    
    NodeStats();
    NodeStats( const std::string );
    ~NodeStats() { }

    bool operator==(const NodeStats&) const;
    bool operator==(const std::string&) const;
    
    void copy( const NodeStats& that )
    {
      name = that.name;
      prevcputimes = that.prevcputimes;
      prevwalltimes = that.prevwalltimes;
    }

  };

  void cpuload( int, uint64_t&, uint64_t&, double&, uint64_t&, double& );

  int getPid( std::string nodeName );

  bool execute_at( const std::string url,
           const std::string& method, const XmlRpc::XmlRpcValue& request,
           XmlRpc::XmlRpcValue& response, XmlRpc::XmlRpcValue& payload,
           bool wait_for_master, ros::WallDuration g_retry_timeout );

  void parseUrl( std::string url, std::string& host, uint32_t& port );

  unsigned long getTotalRAM();

}


/*
BSD 3-Clause License
Copyright (c) 2017, NCSR "Demokritos"
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

 * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in
   the documentation and/or other materials provided with the
   distribution.

 * Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
