/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp;

import de.csmp.jeiscp.EiscpConnectorSocketReaderThread;
import de.csmp.jeiscp.EiscpListener;
import de.csmp.jeiscp.EiscpProtocolHelper;
import de.csmp.jeiscp.eiscp.EiscpCommandsParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EiscpConnector {
    private static final Log log = LogFactory.getLog(EiscpConnector.class);
    private Socket socket;
    private BufferedOutputStream socketOut;
    private BufferedInputStream socketIn;
    private EiscpConnectorSocketReaderThread t = null;
    private Thread lt = null;
    boolean closed = false;

    public static EiscpConnector autodiscover() throws Exception {
        String queryDatagramString = "!xECNQSTN";
        byte[] queryDatagram = EiscpProtocolHelper.iscpToEiscpMessage(queryDatagramString);
        int port = 60128;
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.setBroadcast(true);
        log.debug((Object)("send autodiscover datagram: " + queryDatagramString));
        DatagramPacket p = new DatagramPacket(queryDatagram, queryDatagram.length);
        p.setAddress(InetAddress.getByAddress(new byte[]{-1, -1, -1, -1}));
        p.setPort(port);
        datagramSocket.send(p);
        while (true) {
            try {
                log.info((Object)"wait for autodiscover answere");
                return EiscpConnector.receiveAutodiscoverAnswere(datagramSocket);
            }
            catch (Exception ex) {
                log.warn((Object)ex);
                continue;
            }
            break;
        }
    }

    public static EiscpConnector receiveAutodiscoverAnswere(DatagramSocket datagramSocket) throws Exception {
        byte[] buf = new byte[256];
        DatagramPacket pct = new DatagramPacket(buf, buf.length);
        datagramSocket.receive(pct);
        byte[] receivedMessage = new byte[pct.getLength()];
        System.arraycopy(buf, 0, receivedMessage, 0, receivedMessage.length);
        log.debug((Object)("answere from " + pct.getSocketAddress()));
        String responseString = EiscpProtocolHelper.interpreteEiscpResponse(receivedMessage);
        String address = pct.getAddress().getHostAddress().toString();
        EiscpConnector conn = new EiscpConnector(address, responseString);
        return conn;
    }

    public EiscpConnector(String address, String autodiscoverResponse) throws UnknownHostException, IOException {
        log.debug((Object)("autodiscovered: " + autodiscoverResponse));
        this.init(address, 60128);
    }

    public EiscpConnector(String address) throws UnknownHostException, IOException {
        this.init(address, 60128);
    }

    public EiscpConnector(String address, int port) throws UnknownHostException, IOException {
        this.init(address, port);
    }

    public void attachListener(EiscpListener listener) {
        if (this.lt == null) {
            this.t = new EiscpConnectorSocketReaderThread(this, this.socketIn, listener);
            this.lt = new Thread(this.t);
            this.lt.start();
        }
    }

    private void init(String address, int port) throws UnknownHostException, IOException {
        log.debug((Object)("connect to " + address + ":" + port));
        this.socket = new Socket(address, port);
        this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
        this.socketIn = new BufferedInputStream(this.socket.getInputStream());
        log.debug((Object)"connected");
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
        super.finalize();
    }

    public int available() throws IOException {
        return this.socketIn.available();
    }

    public byte[] readMessage() throws IOException {
        int a = this.socketIn.available();
        if (a <= 0) {
            return null;
        }
        byte[] res = new byte[a];
        int readBytes = this.socketIn.read(res);
        if (readBytes < a) {
            throw new IOException("read too less bytes");
        }
        return res;
    }

    public void sendIscpCommand(String command) throws IOException {
        log.debug((Object)("sendIscpCommand: " + command));
        String message = "!1" + command;
        this.sendIscpMessage(message);
    }

    public void sendCommand(String commandId) throws IOException {
        log.debug((Object)("sendCommand: " + commandId));
        String iscpCommand = EiscpCommandsParser.getIscpCommand(commandId);
        this.sendIscpCommand(iscpCommand);
    }

    public void sendIscpMessage(String message) throws IOException {
        byte[] eiscpMessage = EiscpProtocolHelper.iscpToEiscpMessage(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendIscpMessage: " + message + " - eISCP message: " + eiscpMessage.length + " bytes - " + EiscpProtocolHelper.convertToHexString(eiscpMessage)));
        }
        this.socketOut.write(eiscpMessage);
        this.socketOut.flush();
    }

    public String responseIscpMessage(String message) throws Exception {
        String result = null;
        this.sendIscpMessage(message);
        Thread.sleep(200L);
        byte[] response = this.readMessage();
        if (response != null) {
            result = EiscpProtocolHelper.interpreteEiscpResponse(response);
        }
        return result;
    }

    public void close() {
        log.debug((Object)"-- close");
        if (this.t != null) {
            this.t.quit();
        }
        try {
            this.socketOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

