/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp;

import de.csmp.jeiscp.EiscpConnector;
import de.csmp.jeiscp.EiscpListener;
import de.csmp.jeiscp.EiscpMessageFormatException;
import de.csmp.jeiscp.EiscpProtocolHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EiscpConnectorSocketReaderThread
implements Runnable {
    private static final Log log = LogFactory.getLog(EiscpConnectorSocketReaderThread.class);
    EiscpConnector conn;
    BufferedInputStream socketIn;
    EiscpListener listener;
    private boolean quit = false;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);

    public EiscpConnectorSocketReaderThread(EiscpConnector conn, BufferedInputStream socketIn, EiscpListener listener) {
        this.conn = conn;
        this.socketIn = socketIn;
        this.listener = listener;
    }

    @Override
    public void run() {
        byte[] response = new byte[4];
        while (!this.quit) {
            log.trace((Object)"readLoop");
            try {
                do {
                    response[0] = (byte)this.socketIn.read();
                } while (EiscpProtocolHelper.isEofMarker(response[0]));
                if (response[0] != 73) {
                    throw new EiscpMessageFormatException("First byte not valid for begin of message: " + EiscpProtocolHelper.convertToHexString(response[0]));
                }
                response[1] = (byte)this.socketIn.read();
                response[2] = (byte)this.socketIn.read();
                response[3] = (byte)this.socketIn.read();
                EiscpProtocolHelper.validateIscpSignature(response, 0);
                this.blockedReadQuadrupel(response);
                EiscpProtocolHelper.validateHeaderLengthSignature(response, 0);
                this.blockedReadQuadrupel(response);
                int messageSize = EiscpProtocolHelper.readMessageSize(response, 0);
                this.blockedReadQuadrupel(response);
                EiscpProtocolHelper.validateEiscpVersion(response, 0);
                this.buffer.reset();
                for (int i = 0; i < messageSize; ++i) {
                    this.buffer.write(this.socketIn.read());
                }
                byte[] iscpMessage = this.buffer.toByteArray();
                String res = EiscpProtocolHelper.parseIscpMessage(iscpMessage);
                this.listener.receivedIscpMessage(res);
            }
            catch (EiscpMessageFormatException ex) {
                log.warn((Object)(ex.getMessage() + " - " + EiscpProtocolHelper.convertToHexString(response)));
                log.debug((Object)"skip bytes until EOF/CR");
                if (this.isEofMarkerfInArray(response)) {
                    log.debug((Object)"found eof in response block");
                    continue;
                }
                boolean eofFound = false;
                try {
                    while (!eofFound) {
                        byte b = (byte)this.socketIn.read();
                        if (b == -1) {
                            log.debug((Object)"end of stream");
                            this.quit();
                            eofFound = true;
                            continue;
                        }
                        log.debug((Object)("discard " + EiscpProtocolHelper.convertToHexString(new byte[]{b})));
                        eofFound = EiscpProtocolHelper.isEofMarker(b);
                    }
                    log.trace((Object)"found EOF");
                }
                catch (Exception ex2) {
                    log.error((Object)"not handled", (Throwable)ex2);
                }
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
                ex.printStackTrace();
                this.quit();
            }
        }
    }

    public boolean isEofMarkerfInArray(byte[] response) {
        boolean eofFound = false;
        for (int i = 0; i < response.length; ++i) {
            eofFound = eofFound || EiscpProtocolHelper.isEofMarker(response[i]);
        }
        return eofFound;
    }

    private void blockedReadQuadrupel(byte[] bb) throws IOException {
        bb[0] = (byte)this.socketIn.read();
        bb[1] = (byte)this.socketIn.read();
        bb[2] = (byte)this.socketIn.read();
        bb[3] = (byte)this.socketIn.read();
    }

    public void quit() {
        this.quit = true;
    }
}

