/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp;

import de.csmp.jeiscp.eiscp.Command;
import de.csmp.jeiscp.eiscp.EiscpCommandsParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EiscpDevice {
    private static final String FALLBACK_DEVICE_TYPE = "TX-NR709";
    String autodiscoverString;
    String deviceType;
    String ipAddress;
    Integer port;
    List<String> capableEiscpParserModelsets;
    private static final Log log = LogFactory.getLog(EiscpDevice.class);

    public EiscpDevice() {
        this.initModelsets();
    }

    public EiscpDevice(String autodiscoverString) {
        this.initByAutodiscoverString(autodiscoverString);
        this.initModelsets();
    }

    public EiscpDevice(String autodiscoverString, String ipAddress) {
        this.initByAutodiscoverString(autodiscoverString);
        this.initModelsets();
        this.ipAddress = ipAddress;
    }

    protected void initByAutodiscoverString(String autodiscoverString) {
        this.autodiscoverString = autodiscoverString;
        if (autodiscoverString.startsWith("ECN")) {
            int endOfDeviceType = autodiscoverString.indexOf("/", 3);
            this.deviceType = autodiscoverString.substring(3, endOfDeviceType);
            int endOfPort = autodiscoverString.indexOf("/", endOfDeviceType + 1);
            String port = autodiscoverString.substring(endOfDeviceType + 1, endOfPort);
            this.port = Integer.parseInt(port);
        } else {
            log.error((Object)("wrong autodiscover message: " + autodiscoverString));
        }
    }

    protected void initModelsets() {
        Map<String, List<String>> modelSets = EiscpCommandsParser.getModelsets();
        List<String> regognizedModelSets = this.regognizeModelSets(modelSets, this.deviceType);
        if (regognizedModelSets.size() == 0) {
            log.warn((Object)("no recognized device capabilities for " + this.deviceType + " - fallback to " + FALLBACK_DEVICE_TYPE));
            regognizedModelSets = this.regognizeModelSets(modelSets, FALLBACK_DEVICE_TYPE);
        }
        this.capableEiscpParserModelsets = regognizedModelSets;
        log.debug((Object)("capable modelsets: " + regognizedModelSets.size()));
    }

    protected List<String> regognizeModelSets(Map<String, List<String>> modelSets, String forDeviceType) {
        LinkedList<String> recognizedModelSets = new LinkedList<String>();
        for (String setId : modelSets.keySet()) {
            List<String> modelIds = modelSets.get(setId);
            if (!modelIds.contains(forDeviceType)) continue;
            recognizedModelSets.add(setId);
        }
        return recognizedModelSets;
    }

    public String toString() {
        return "EiscpDevice " + this.deviceType + " @" + (this.ipAddress != null ? this.ipAddress : "") + ":" + this.port;
    }

    public boolean isCapable(Command cmd) {
        return this.capableEiscpParserModelsets.contains(cmd.getModels());
    }

    public String getAutodiscoverString() {
        return this.autodiscoverString;
    }

    public void setAutodiscoverString(String autodiscoverString) {
        this.autodiscoverString = autodiscoverString;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public List<String> getCapableEiscpParserModelsets() {
        return this.capableEiscpParserModelsets;
    }

    public void setCapableEiscpParserModelsets(List<String> eiscpParserModelsets) {
        this.capableEiscpParserModelsets = eiscpParserModelsets;
    }
}

