/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp.eiscp;

import de.csmp.jeiscp.eiscp.Command;
import de.csmp.jeiscp.eiscp.CommandBlock;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yaml.snakeyaml.Yaml;

public class EiscpCommandsParser {
    private static final String YAML_MODELS = "models";
    private static final String YAML_DESCRIPTION = "description";
    private static final String YAML_NAME = "name";
    private static final String YAML_VALUES = "values";
    private static final String EISCP_COMMANDS_YAML = "miracle2k-onkyo-eiscp/eiscp-commands.yaml";
    private static final Log log = LogFactory.getLog(EiscpCommandsParser.class);
    private static Map<String, List<String>> modelsets = null;
    private static Map<String, Object> ec = null;
    private static List<CommandBlock> mainCommandBlocks = null;
    private static Map<String, Command> idToCommandMap = null;
    private static Map<String, CommandBlock> idToCommandBlockMap = null;
    private static Map<String, Command> iscpToCommandMap = null;
    private static Map<String, CommandBlock> iscpToCommandBlockMap = null;
    private static Map<String, List<String>> keysetForModel = new HashMap<String, List<String>>();
    public static Command MASTER_VOLUME_QUERY_CMD;

    public static Map<String, Command> getIscpToCommandMap() {
        if (iscpToCommandMap == null) {
            HashMap<String, Command> map = new HashMap<String, Command>();
            for (CommandBlock cmdBlock : EiscpCommandsParser.getMainCommandBlocks()) {
                for (Command cmd : cmdBlock.getValues()) {
                    map.put(cmd.getIscpCommand(), cmd);
                }
            }
            iscpToCommandMap = map;
        }
        return iscpToCommandMap;
    }

    public static Map<String, Command> getIdToCommandMap() {
        if (idToCommandMap == null) {
            idToCommandMap = new HashMap<String, Command>();
            for (CommandBlock cmdBlock : EiscpCommandsParser.getMainCommandBlocks()) {
                for (Command cmd : cmdBlock.getValues()) {
                    idToCommandMap.put(cmd.getIdentifier(), cmd);
                }
            }
        }
        return idToCommandMap;
    }

    public static Map<String, CommandBlock> getIdToCommandBlockMap() {
        if (idToCommandBlockMap == null) {
            idToCommandBlockMap = new HashMap<String, CommandBlock>();
            for (CommandBlock cmdBlock : EiscpCommandsParser.getMainCommandBlocks()) {
                idToCommandBlockMap.put(cmdBlock.getName(), cmdBlock);
            }
        }
        return idToCommandBlockMap;
    }

    public static Command getCommand(String commandId) {
        return EiscpCommandsParser.getIdToCommandMap().get(commandId);
    }

    public static Command getCommandByIscp(String command) {
        return EiscpCommandsParser.getIscpToCommandMap().get(command);
    }

    public static String getIscpCommand(String commandId) {
        return EiscpCommandsParser.getCommand(commandId).getIscpCommand();
    }

    public static List<CommandBlock> getMainCommandBlocks() {
        if (mainCommandBlocks == null) {
            Map main = (Map)EiscpCommandsParser.getEiscpCommands().get("main");
            LinkedList<CommandBlock> mc = new LinkedList<CommandBlock>();
            for (String mainCommand : main.keySet()) {
                Map cmdMap = (Map)main.get(mainCommand);
                CommandBlock cmdBlock = new CommandBlock();
                cmdBlock.setCommand(mainCommand);
                cmdBlock.setName((String)cmdMap.get(YAML_NAME));
                cmdBlock.setDescription((String)cmdMap.get(YAML_DESCRIPTION));
                mc.add(cmdBlock);
                Map subCmdMap = (Map)cmdMap.get(YAML_VALUES);
                Set subCmdMapKeyset = subCmdMap.keySet();
                for (Object subCommandKeyO : subCmdMapKeyset) {
                    Map subcommandO = (Map)subCmdMap.get(subCommandKeyO);
                    if (subCommandKeyO instanceof String) {
                        String subCommand = (String)subCommandKeyO;
                        Command subC = new Command(cmdBlock);
                        subC.setCommand(subCommand);
                        String name = null;
                        Object nameO = subcommandO.get(YAML_NAME);
                        if (nameO != null) {
                            name = nameO instanceof String ? (String)nameO : (String)((ArrayList)nameO).get(0);
                        }
                        subC.setName(name);
                        subC.setDescription((String)subcommandO.get(YAML_DESCRIPTION));
                        subC.setModels((String)subcommandO.get(YAML_MODELS));
                        cmdBlock.getValues().add(subC);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("subCommandKey unhandeled: " + subCommandKeyO.getClass().getName() + " - " + subCommandKeyO + " for " + cmdBlock));
                }
            }
            mainCommandBlocks = mc;
        }
        return mainCommandBlocks;
    }

    public static Map<String, Object> getEiscpCommands() {
        if (ec == null) {
            InputStream is = EiscpCommandsParser.class.getClassLoader().getResourceAsStream(EISCP_COMMANDS_YAML);
            Yaml y = new Yaml();
            ec = (Map)y.load(is);
            log.debug((Object)"parsed YAML");
        }
        return ec;
    }

    public static Map<String, List<String>> getModelsets() {
        if (modelsets == null) {
            Map yamlModelsets = (Map)EiscpCommandsParser.getEiscpCommands().get("modelsets");
            log.debug((Object)("loaded " + yamlModelsets.size() + " modelsets"));
            for (String setId : yamlModelsets.keySet()) {
                List modelset = (List)yamlModelsets.get(setId);
                LinkedList<String> reworkedModelset = new LinkedList<String>(modelset);
                for (String model : modelset) {
                    String derivedModelName;
                    int cDelim = model.indexOf("(");
                    if (cDelim == -1 || modelset.contains(derivedModelName = model.substring(0, cDelim))) continue;
                    log.debug((Object)("assign " + model + " as equal to " + derivedModelName));
                    reworkedModelset.add(derivedModelName);
                }
                yamlModelsets.put(setId, reworkedModelset);
            }
            modelsets = yamlModelsets;
        }
        return modelsets;
    }

    public static List<String> getKeysetForModel(String model) {
        if (!keysetForModel.containsKey(model)) {
            log.debug((Object)("build keyset for model " + model));
            LinkedList<String> keysetList = new LinkedList<String>();
            Map<String, List<String>> modelsets = EiscpCommandsParser.getModelsets();
            for (String keyset : modelsets.keySet()) {
                List<String> modelList = modelsets.get(keyset);
                if (!modelList.contains(model)) continue;
                keysetList.add(keyset);
            }
            keysetForModel.put(model, keysetList);
            return keysetList;
        }
        return keysetForModel.get(model);
    }
}

