/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.wrapper.IDownload;

public class Download
implements IDownload {
    private static final int PROGRESS_CHUNK = 20000;
    private static final int BUFFER_SIZE = 10000;

    public Download() {
        this.configureProxyAuthentication();
    }

    private void configureProxyAuthentication() {
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        }
    }

    public void download(URI uRI, File file) throws Exception {
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        this.downloadInternal(uRI, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInternal(URI uRI, File file) throws Exception {
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            URL uRL = uRI.toURL();
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[10000];
            long l = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                if ((l += (long)n) / 20000L > 0L) {
                    System.out.print(".");
                    l -= 20000L;
                }
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            System.out.println("");
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword", "").toCharArray());
        }
    }
}

