##################################################################################################
# 
# CMake script for finding DepthSenseSDK.
# 
# Input variables:
# 
# - DepthSenseSDK_ROOT_DIR (optional): When specified, header files and libraries will be searched for in
#     ${DepthSenseSDK_ROOT_DIR}/include
#     ${DepthSenseSDK_ROOT_DIR}/libs
#   respectively, and the default CMake search order will be ignored. When unspecified, the default
#   CMake search order is used.
#   This variable can be specified either as a CMake or environment variable. If both are set,
#   preference is given to the CMake variable.
#   Use this variable for finding packages installed in a nonstandard location, or for enforcing
#   that one of multiple package installations is picked up.
# 
# 
# Cache variables (not intended to be used in CMakeLists.txt files)
# 
# - DepthSenseSDK_INCLUDE_DIR: Absolute path to package headers.
# - DepthSenseSDK_LIBRARY: Absolute path to library.
# 
# 
# Output variables:
# 
# - DepthSenseSDK_FOUND: Boolean that indicates if the package was found
# - DepthSenseSDK_INCLUDE_DIRS: Paths to the necessary header files
# - DepthSenseSDK_LIBRARIES: Package libraries
# 
# 
# Example usage:
# 
#  find_package(DepthSenseSDK)
#  if(NOT DepthSenseSDK_FOUND)
#    # Error handling
#  endif()
#  ...
#  include_directories(${DepthSenseSDK_INCLUDE_DIRS} ...)
#  ...
#  target_link_libraries(my_target ${DepthSenseSDK_LIBRARIES})
# 
##################################################################################################

# Get package location hint from environment variable (if any)
if(NOT DepthSenseSDK_ROOT_DIR AND DEFINED ENV{DepthSenseSDK_ROOT_DIR})
  set(DepthSenseSDK_ROOT_DIR "$ENV{DepthSenseSDK_ROOT_DIR}" CACHE PATH
    "DepthSenseSDK base directory location (optional, used for nonstandard installation paths)")
endif()

# Search path for nonstandard package locations
if(DepthSenseSDK_ROOT_DIR)
  set(DepthSenseSDK_INCLUDE_PATH PATHS "${DepthSenseSDK_ROOT_DIR}/include" NO_DEFAULT_PATH)
  set(DepthSenseSDK_LIBRARY_PATH PATHS "${DepthSenseSDK_ROOT_DIR}/lib"     NO_DEFAULT_PATH)
endif()

# Find headers and libraries
find_path(DepthSenseSDK_INCLUDE_DIR
  NAMES DepthSense.hxx
  HINTS "/opt/softkinetic"
  PATH_SUFFIXES "DepthSenseSDK/include"
  ${DepthSenseSDK_INCLUDE_PATH})

find_library(DepthSenseSDK_LIBRARY
  NAMES DepthSense
  HINTS "/opt/softkinetic"
  PATH_SUFFIXES "DepthSenseSDK/lib"
  ${DepthSenseSDK_LIBRARY_PATH})

mark_as_advanced(DepthSenseSDK_INCLUDE_DIR
                 DepthSenseSDK_LIBRARY)

# Output variables generation
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(DepthSenseSDK DEFAULT_MSG DepthSenseSDK_LIBRARY
                                                      DepthSenseSDK_INCLUDE_DIR)

set(DepthSenseSDK_FOUND ${DEPTHSENSESDK_FOUND}) # Enforce case-correctness: Set appropriately cased variable...
unset(DEPTHSENSESDK_FOUND) # ...and unset uppercase variable generated by find_package_handle_standard_args

if(DepthSenseSDK_FOUND)
  set(DepthSenseSDK_INCLUDE_DIRS ${DepthSenseSDK_INCLUDE_DIR})
  set(DepthSenseSDK_LIBRARIES ${DepthSenseSDK_LIBRARY})
endif()
