#!/bin/bash

# Software License Agreement (BSD License)
#
# Copyright (c) 2015, Tamagawa University All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above
#    copyright notice, this list of conditions and the following
#    disclaimer in the documentation and/or other materials provided
#    with the distribution.
#  * Neither the name of the association nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

DATE=`date`
joints="fr_rotation_joint br_rotation_joint bl_rotation_joint fl_rotation_joint fr_wheel_joint br_wheel_joint bl_wheel_joint fl_wheel_joint larm_elbow_p_joint larm_shoulder_p_joint larm_shoulder_r_joint larm_shoulder_y_joint larm_wrist_p_joint larm_wrist_r_joint rarm_elbow_p_joint rarm_shoulder_p_joint rarm_shoulder_r_joint rarm_shoulder_y_joint rarm_wrist_p_joint rarm_wrist_r_joint"

cat <<EOF
###
### THIS FILE IS AUTOMATICALLY GENERATED by $0 ${PWD} ${DATE}
###

joint_state_publisher:
   controller:
       package: dynamixel_controllers
       module: joint_state_publisher
       type: JointStatePublisher

EOF

# echo -n "joints: ["
# for joint in ${joints}; do
#     echo -n "${joint}"
#     if [[ "${joint}" != "rarm_wrist_r_joint" ]] ; then ##???
#         echo -n ", "
#     fi
# done
# echo "]"

id=1
for joint in ${joints}; do
    if [[ "bl_wheel_joint br_wheel_joint fl_wheel_joint fr_wheel_joint" =~ $joint ]] ; then
    cat <<EOF

# ${joint}
${joint}_velocity_controller:
    controller:
        package: dynamixel_controllers
        module: joint_torque_controller
        type: JointTorqueController
    joint_name: ${joint}
    joint_speed: 2.0
    motor:
        id: ${id}
        init: 0 
        min: -1024 
        max: 1024
EOF
    else
        cat <<EOF

# ${joint}
${joint}_position_controller:
    controller:
        package: dynamixel_controllers
        module: joint_position_controller
        type: JointPositionController
    joint_name: ${joint}
    joint_speed: 2.0
    motor:
        id: ${id}
        init: 2048
        min: 0
        max: 4095
EOF
   fi
   id=`expr ${id} + 1`
done
