;;base_link z 877.04
(setq romeooffset (float-vector 500 0 877.04))

(defun move-to-room (goal room &optional (retry 3))
  (send *romeo* :move-to goal :world)
  (send *romeo* :translate romeooffset)
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  (unix::sleep 1)
  t)

(defun pick (obj &key (arm :larm))
  (send *romeo* :head :look-at (send obj :worldpos) :world)
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  (unix::sleep 1)
;;  (send *ri* :move-end-coords-plan (send *romeo* :transformation (send (send (send obj :handle-handle0) :copy-worldcoords) :translate #f(-100 0 0) :local)) :move-arm arm :use-torso use-torso)
  (send *romeo* :inverse-kinematics (send *romeo* :transformation (send (send (send obj :handle-handle0) :copy-worldcoords) :translate #f(-100 0 0) :local)) :move-target (send *romeo* arm :end-coords) :link-list (send *romeo* :link-list (send *romeo* arm :end-coords :parent) (send *romeo* :torso_link)))
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  (unix::sleep 1)
;;  (send *ri* :move-gripper arm 0.08 :wait t)
  (send *romeo* :inverse-kinematics (send obj :handle-handle0) :move-target (send *romeo* arm :end-coords) :link-list (send *romeo* :link-list (send *romeo* arm :end-coords :parent) (send *romeo* :torso_link)) :rotation-axis t)
  (send *romeo* arm :end-coords :assoc obj)
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  (unix::sleep 1)
;;  (send *ri* :move-gripper arm 0 :wait t)
  (send *romeo* :reset-pose)
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  (unix::sleep 1)
  t)

(defun release (coords &rest args &key (arm :larm) &allow-other-keys)
  (let ((obj (car (send *romeo* arm :end-coords :descendants))))
    (send *romeo* :head :look-at (send coords :worldpos) :world)
    (send *irtviewer* :draw-objects)
    (x::window-main-one)

    (send *romeo* :inverse-kinematics coords :move-target (send *romeo* arm :end-coords) :link-list (send *romeo* :link-list (send *romeo* arm :end-coords :parent) (send *romeo* :torso_link)) :rotation-axis nil)

    (send *romeo* :inverse-kinematics (send *romeo* :transformation (send *romeo* arm :end-coords)) :move-target (send *romeo* arm :end-coords) :link-list (send *romeo* :link-list (send *romeo* arm :end-coords :parent) (send *romeo* :torso_link)) :rotation-axis nil)
    (send *irtviewer* :draw-objects)
    (x::window-main-one)
    (unix::sleep 1)
;;    (send *ri* :move-gripper arm 0.08 :wait nil)
    (send *romeo* arm :end-coords :dissoc obj)
    (dotimes (i 30)
      (send obj :translate (float-vector 0 0 (- 0 i)) :world)
      (send *irtviewer* :draw-objects)
      (x::window-main-one)
      )
    (unix::sleep 1)
;;    (send *ri* :move-gripper arm 0.005 :wait nil)
    (send *romeo* :reset-pose)
    (send *irtviewer* :draw-objects)
    (x::window-main-one)
    (unix::sleep 1)
    t))

(defun move-chair (chair x y &optional (d 0) &key (direct :x))
  (let ((cds-list '(nil nil)) (rc-chair-pos nil))
    (send *romeo* :head :look-at (vector-mean (send-all (send chair :handle) :worldpos)) :world)
    (send *irtviewer* :draw-objects)
    (x::window-main-one)
    (unix::sleep 1)
    (send *romeo* :larm :inverse-kinematics (send chair :handle-larm) :rotation-axis nil)
    (send *romeo* :rarm :inverse-kinematics (send chair :handle-rarm) :rotation-axis nil)
    (send *irtviewer* :draw-objects)
    (x::window-main-one)
    (unix::sleep 1)
    (send *romeo* :larm :end-coords :assoc chair)
    (if (eq direct :x)
    	(progn
 	  (send *romeo* :translate (float-vector (* x 1000) 0 0))
	  (send *irtviewer* :draw-objects)
	  (x::window-main-one)
	  (unix::sleep 1)
	  (send *romeo* :rotate (deg2rad d) :z)
	  (send *irtviewer* :draw-objects)
	  (x::window-main-one)
	  (unix::sleep 1)
	  (send *romeo* :translate (float-vector 0 (* y 1000) 0))
	  (send *irtviewer* :draw-objects)
	  (x::window-main-one)
	  (unix::sleep 1))
      (progn
	(send *romeo* :rotate (deg2rad d) :z)
	(send *irtviewer* :draw-objects)
	(x::window-main-one)
	(unix::sleep 1)
	(send *romeo* :translate (float-vector 0 (* y 1000) 0))
	(send *irtviewer* :draw-objects)
	(x::window-main-one)
	(unix::sleep 1)
	(send *romeo* :translate (float-vector (* x 1000) 0 0))
	(send *irtviewer* :draw-objects)
	(x::window-main-one)
	(unix::sleep 1)))
    (send *romeo* :larm :end-coords :dissoc chair)
    (send *romeo* :reset-pose)
    (send *irtviewer* :draw-objects)
    (x::window-main-one)
    (unix::sleep 1)
    (send (send *room73b2* :spot "/eng2/7f/room73B2-chair-back") :move-to (send (send *romeo* :copy-worldcoords) :translate (scale -1 romeooffset)) :world)
    t))

(defun wipe-table4 (&rest args)
  (send *romeo* :larm :angle-vector (float-vector 65 10 -90 0 0 0 0))
  (send *romeo* :head :look-at (send *romeo* :larm :end-coords :worldpos))
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  (dotimes (i 3)
    (send *romeo* :inverse-kinematics (send (send *romeo* :larm :end-coords :copy-worldcoords) :translate (float-vector 50 0 0) :world) :move-target (send *romeo* :larm :end-coords) :link-list (send *romeo* :link-list (send *romeo* :larm :end-coords :parent) (send *romeo* :torso_link)) :rotation-axis nil)
    (send *romeo* :head :look-at (send *romeo* :larm :end-coords :worldpos))
    (send *irtviewer* :draw-objects)
    (x::window-main-one)
    (dotimes (j 10)
      (send *romeo* :inverse-kinematics (send (send *romeo* :larm :end-coords :copy-worldcoords) :translate (float-vector 0 30 0) :world) :move-target (send *romeo* :larm :end-coords) :link-list (send *romeo* :link-list (send *romeo* :larm :end-coords :parent) (send *romeo* :torso_link)) :rotation-axis nil)
      (send *romeo* :head :look-at (send *romeo* :larm :end-coords :worldpos))
      (send *irtviewer* :draw-objects)
      (x::window-main-one))
    (dotimes (j 10)
      (send *romeo* :inverse-kinematics (send (send *romeo* :larm :end-coords :copy-worldcoords) :translate (float-vector 0 -30 0) :world) :move-target (send *romeo* :larm :end-coords) :link-list (send *romeo* :link-list (send *romeo* :larm :end-coords :parent) (send *romeo* :torso_link)) :rotation-axis nil)
      (send *romeo* :head :look-at (send *romeo* :larm :end-coords :worldpos))
      (send *irtviewer* :draw-objects)
      (x::window-main-one)))
  (send *romeo* :reset-pose)
  (send *irtviewer* :draw-objects)
  (x::window-main-one)
  t)
