/*
 *    This file is part of ACADO Toolkit.
 *
 *    ACADO Toolkit -- A Toolkit for Automatic Control and Dynamic Optimization.
 *    Copyright (C) 2008-2014 by Boris Houska, Hans Joachim Ferreau,
 *    Milan Vukov, Rien Quirynen, KU Leuven.
 *    Developed within the Optimization in Engineering Center (OPTEC)
 *    under supervision of Moritz Diehl. All rights reserved.
 *
 *    ACADO Toolkit is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    ACADO Toolkit is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with ACADO Toolkit; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


/**
 *    \file src/conic_solver/dense_cp_solver.cpp
 *    \author Boris Houska, Hans Joachim Ferreau
 *
 */

#include <acado/conic_solver/dense_cp_solver.hpp>


BEGIN_NAMESPACE_ACADO


//
// PUBLIC MEMBER FUNCTIONS:
//

DenseCPsolver::DenseCPsolver( ) : AlgorithmicBase( )
{
	setupOptions( );
	setupLogging( );
}


DenseCPsolver::DenseCPsolver( UserInteraction* _userInteraction ) : AlgorithmicBase( _userInteraction )
{
	// setup options and loggings for stand-alone instances
	if ( _userInteraction == 0 )
	{
		setupOptions( );
		setupLogging( );
	}
}


DenseCPsolver::DenseCPsolver( const DenseCPsolver& rhs ) : AlgorithmicBase( rhs )
{
}


DenseCPsolver::~DenseCPsolver( )
{

}


DenseCPsolver& DenseCPsolver::operator=( const DenseCPsolver& rhs )
{
    if ( this != &rhs )
	{
		AlgorithmicBase::operator=( rhs );
    }

    return *this;
}


//
// PROTECTED MEMBER FUNCTIONS:
//

returnValue DenseCPsolver::setupOptions( )
{
	return SUCCESSFUL_RETURN;
}


returnValue DenseCPsolver::setupLogging( )
{
	return SUCCESSFUL_RETURN;
}

CLOSE_NAMESPACE_ACADO

// end of file.
