# Key Features of ACADO Toolkit {#md_features}

[TOC]
 
## Nonlinear Optimal Control {#md_feat_noc}

One of the basic problem classes which can be solved with ACADO toolkit are standard optimal control problems \[1\]. These problems typically consist of a dynamic system with differential states and possibly also algebraic states, the objective can usually be written as a sum of a Lagrange and a Mayer term. Moreover, ACADO toolkit tackles several types of constraints, such as control and state bounds, terminal constraints, general nonlinear path constraints, periodic boundary conditions, etc.

## Multi-Objective Optimal Control {#md_feat_mooc}

As an extension, ACADO toolkit offers systematic and advanced tools for solving general optimal control problems with multiple and conflicting objectives \[2\]. Pareto frontiers (or trade-off surfaces) can automatically and efficiently be generated by several scalarization approaches, which convert the original multi-objective optimal control problem into a series of parametric single objective optimal control problems. The available scalarization approaches involve the classic convex Weighted Sum as well as recent techniques as Normal Boundary Intersection and Normalized Normal Boundary Intersection. Typical algorithmic features include smart re-initialization strategies for computational speed-ups and post-processing tools as Pareto filter algorithms.

## State and Parameter Estimation {#md_feat_spe}

An important class of optimal control problems, which obtains a special attention within ACADO toolkit, are state and parameter estimation problems. This subclass of optimal control problems can theoretically also be transformed into a standard nonlinear optimal control problem. However, state and parameter estimation problems have often a certain structure, which can be used by the algorithms. In ACADO Toolkit Gauss-Newton algorithms are implemented to deal with the least-squares terms, which typically occur within this class of optimization problems. Moreover, a-posteriori analysis tools are available such as a variance-covariance compuation for the estimated states and parameters.

## Model Predictive Control {#md_feat_mpc}

Another highlight of ACADO Toolkit are its model based feedback control algorithms. The corresponding problems can be divided into two kinds of online dynamic optimization problems: the Model Predictive %Control (MPC) problem of finding (approximately) optimal control actions to be fed back to the controlled process \[3\], and the Moving Horizon Estimation (MHE) problem of estimating the current process states using measurements of its outputs.

## Code Generation for Fast NMPC and MHE {#md_feat_codegen}

The ACADO Code Generation tool can automatically generate Gauss-Newton real-time iteration algorithms for fast nonlinear MPC  and MHE applications \[4, 5\]. Based on the symbolic syntax of the ACADO Toolkit, it allows the user to export highly efficient and self-contained C code that is tailored to each respective MPC or MHE problem formulations. Computational speed is increased by hard-coding all problem dimensions, avoiding dynamic memory allocations, loop unrolling, symbolic simplifications and the use of a fixed-step integrator. This can lead to significant speed-ups compared to generic implementations. 

The first experimental validation of the Code Generation Tool on an overhead crane is described in \[6\].

Comparison between condensing based NMPC solver that employs qpOASES QP solver and an NMPC solver based on structure exploiting QP solver FORCES can be found in \[7\].

# References #
 
1.    Boris Houska, Hans Joachim Ferreau, Moritz Diehl. ACADO Toolkit - An Open-Source Framework for Automatic Control and Dynamic Optimization. Optimal Control Methods and Application, 32 (3), pp. 298-312, 2011.
2.    Filip Logist, Boris Houska, Moritz Diehl, Jan van Impe. Fast Pareto set generation for nonlinear optimal control problems with multiple objectives. Structural and Multidisciplinary Optimization, 42(4), pp:591-603, 2010.
3.    Hans Joachim Ferreau, Boris Houska, Moritz Diehl. Numerical Methods for Embedded Optimisation and their Implementation within the ACADO Toolkit. In: 7th Conference - Computer Methods and Systems (CMS'09); R. Tadeusiewicz, A. Ligeza, W. Mitkowski, M. Szymkat (eds.), pp. 13-29, Oprogramowanie Naukowo- Techniczne, 2009.
4.    B. Houska, H.J. Ferreau, M. Diehl. An Auto-Generated Real-Time Iteration Algorithm for Nonlinear MPC in the Microsecond Range. Automatica, 47(10), pp:2279-2285, 2011.
5.    H.J. Ferreau, T. Kraus, M. Vukov, W. Saeys, M. Diehl. High-Speed Moving Horizon Estimation based on Automatic Code Generation, Proceedings of the 51th IEEE Conference on Decision and Control, 2012.
6.    M. Vukov, W. Van Loock, B. Houska, H.J. Ferreau, J. Swevers, M. Diehl. Experimental Validation of Nonlinear MPC on an Overhead Crane using Automatic Code Generation, The 2012 American Control Conference, Montreal, Canada.
7.    Vukov, M., Domahidi, A., Ferreau, H. J., Morari, M., Diehl, M. Auto-generated Algorithms for Nonlinear Model Predictive Control on Long and on Short Horizons, Proceedings of the 52nd Conference on Decision and Control (CDC), 2013.

Please consult [this](@ref md_citing) page on how to cite the toolkit.
