function make_sfunction( name )

	% Output file name, and also function name
	if (nargin == 1)
		fileOut = name;
	else
		fileOut = 'sfunction_robot';
	end;
		
	% Root folder of code generation
	CGRoot = '.';	
	
	% qpOASES embedded source files
	qpOASESSources = [ ...
		'CGRoot/qpoases/SRC/QProblem.cpp ' ...
		'CGRoot/qpoases/SRC/QProblemB.cpp ' ...
		'CGRoot/qpoases/SRC/Bounds.cpp ' ...
		'CGRoot/qpoases/SRC/Constraints.cpp ' ...
		'CGRoot/qpoases/SRC/SubjectTo.cpp ' ...
		'CGRoot/qpoases/SRC/Indexlist.cpp ' ...
		'CGRoot/qpoases/SRC/CyclingManager.cpp ' ...
		'CGRoot/qpoases/SRC/Utils.cpp ' ...
		'CGRoot/qpoases/SRC/MessageHandling.cpp ' ...
		'CGRoot/qpoases/SRC/EXTRAS/SolutionAnalysis.cpp ' ...
		];
		
	% Auto-generated files
	CGSources = [ ...
		'CGRoot/acado_solver.c ' ...
		'CGRoot/acado_integrator.c ' ...
		'CGRoot/acado_auxiliary_functions.c ' ...
		'CGRoot/acado_qpoases_interface.cpp ' ...
        'sfunction_robot.cpp '
		];
		
	% Adding additional linker flags for Linux
	ldFlags = '';
	if (isunix() && ~ismac())
		ldFlags = '-lrt';
	end;

	% Recipe for compilation
	CGRecipe = [ ...
		'mex -O' ...
		' -I. -I''CGRoot'' -I''CGRoot/qpoases'' -I''CGRoot/qpoases/INCLUDE'' -I''CGRoot/qpoases/SRC''' ...
		' ldFlags' ...
		' -O CGSources qpOASESSources -output %s.%s' ...
		];

% Compilation
qpOASESSources = regexprep(qpOASESSources, 'CGRoot', CGRoot);
CGSources = regexprep(CGSources, 'CGRoot', CGRoot);

CGRecipe = regexprep(CGRecipe, 'CGRoot', CGRoot);
CGRecipe = regexprep(CGRecipe, 'CGSources', CGSources);
CGRecipe = regexprep(CGRecipe, 'qpOASESSources', qpOASESSources);
CGRecipe = regexprep(CGRecipe, 'ldFlags', ldFlags);

% disp( sprintf( CGRecipe, fileOut, mexext ) ); 
fprintf( 'compiling... ' );
eval( sprintf(CGRecipe, fileOut, mexext) );
fprintf( ['done! --> ' fileOut '.' mexext '\n'] );
