# Migrating Old Bag Files

```
rosbag fix old.bag new.bag
```

# Creating Bag Migration Rules

http://wiki.ros.org/rosbag/migration#migrating

Create folder structure
```
roscd dataspeed_pds_msgs/bmr
mkdir x.x.x-y.y.y && cd x.x.x-y.y.y
```

Checkout old message version, build, and save
```
rosrun rosbag savemsg.py dataspeed_pds_msgs/MyMsg > MyMsg.saved
```

Checkout new message version, build, and generate rule
```
rosrun rosbag makerule.py MyMsg.saved MyMsg.bmr
```

Edit the generated rule:

* ```order = X``` # Index number of this folder
* ```valid = True```
* Remove autogenerated comments and modify as needed

Export the rule in [package.xml](../package.xml):
```xml
<export>
  <rosbag_migration_rule rule_file="bmr/x.x.x-y.y.y/MyMsg.bmr"/>
</export>
```

