/**
 * @file /include/ecl/errors.hpp
 *
 * @brief Macros for error-checking and program termination.
 *
 * @date April, 2009
 **/
/*****************************************************************************
** Ifdefs
*****************************************************************************/

#ifndef ECL_ERRORS_HPP_
#define ECL_ERRORS_HPP_

/*****************************************************************************
** Includes
*****************************************************************************/

#include "errors/macros.hpp"
#include "errors/handlers.hpp"
#include "errors/compile_time_assert.hpp"
#include "errors/run_time_functions.hpp"

/*****************************************************************************
** Doxygen
*****************************************************************************/

/**
 * @defgroup Macros Macros
 *
 * Macros that characterise the platform's time implementation.
**/

#endif /* ECL_ERRORS_HPP_*/
