##
## define macros
##
macro(get_export_collada_option _export_collada_option_ret)
  set(_arg_list ${ARGV})
  set(_export_collada_option "")
  foreach(anarg ${ARGV})
    # for collada manipulator
    if ("${anarg}" STREQUAL "-a")
      if (NOT DEFINED _export_collada_option)
        set(_export_collada_option ${ARGV1})
      endif (NOT DEFINED _export_collada_option)
      list(GET _arg_list 1 _collada_arg_manipulator)
      set(_export_collada_option ${_export_collada_option} -a ${_collada_arg_manipulator})
    endif ("${anarg}" STREQUAL "-a")
    list(REMOVE_AT _arg_list 0)
  endforeach(anarg ${ARGV})
  set(${_export_collada_option_ret} ${_export_collada_option})
endmacro(get_export_collada_option _export_collada_option_ret)

macro(get_option_from_args _option_ret _option_name _separator _quater _ret_add_str)
  set(_arg_list ${ARGV})
  set(_arg_list2 ${ARGV})
  # remove arguments of this macro
  list(REMOVE_AT _arg_list 0 1 2)
  list(REMOVE_AT _arg_list2 0 1 2)
  set(_tmp_option "")
  foreach(anarg ${_arg_list2})
    if ("${anarg}" STREQUAL "${_option_name}")
      if (NOT "${_tmp_option}" STREQUAL "")
        list(GET _arg_list 1 _tmp_option2)
        string(REPLACE " " "\\\\ " _tmp_option2 ${_tmp_option2})
        set(_tmp_option "${_tmp_option}\ ${_separator}${_tmp_option2}")
      else(NOT "${_tmp_option}" STREQUAL "")
        list(GET _arg_list 1 _tmp_option2)
        string(REPLACE " " "\\\\ " _tmp_option2 ${_tmp_option2})
        set(_tmp_option "${_separator}${_tmp_option2}")
      endif (NOT "${_tmp_option}" STREQUAL "")
    endif ("${anarg}" STREQUAL "${_option_name}")
    list(REMOVE_AT _arg_list 0)
  endforeach(anarg ${_arg_list2})
  if (NOT "${_tmp_option}" STREQUAL "" AND NOT "${_ret_add_str}" STREQUAL "")
    set(_tmp_option "${_ret_add_str}\\\"${_tmp_option}\\\"")
  endif (NOT "${_tmp_option}" STREQUAL "" AND NOT "${_ret_add_str}" STREQUAL "")
  set(${_option_ret} "${_tmp_option}")
endmacro(get_option_from_args _option_ret _option_name)

macro(get_conf_file_option _conf_file_option_ret _robothardware_conf_file_option_ret _conf_dt_option_ret _simulation_timestep_option_ret _simulation_joint_properties_option_ret)
  get_option_from_args(${_conf_file_option_ret} "--conf-file-option" "--conf-file-option\ " ' "CONF_FILE_OPTION:=" ${ARGV})
  get_option_from_args(${_robothardware_conf_file_option_ret} "--robothardware-conf-file-option" "--robothardware-conf-file-option\ " ' "ROBOTHARDWARE_CONF_FILE_OPTION:=" ${ARGV})
  get_option_from_args(${_conf_dt_option_ret} "--conf-dt-option" "--dt\ " ' "CONF_DT_OPTION:=" ${ARGV})
  get_option_from_args(${_simulation_timestep_option_ret} "--simulation-timestep-option" "--timestep\ " ' "SIMULATION_TIMESTEP_OPTION:=" ${ARGV})
  get_option_from_args(${_simulation_joint_properties_option_ret} "--simulation-joint-properties-option" "--joint-properties\ " ' "SIMULATION_JOINT_PROPERTIES_OPTION:=" ${ARGV})
endmacro()

macro(get_proj_file_root_option _proj_file_root_option_ret)
  get_option_from_args(${_proj_file_root_option_ret} "--proj-file-root-option" "" "" "," ${ARGV})
endmacro()

macro(get_euscollada_option _euscollada_option_ret)
  get_option_from_args(${_euscollada_option_ret} "--euscollada-option" "" "" "" ${ARGV})
endmacro()

# this code removes generated .xml files since every time we call cmake, it changes the corb_port and custom_commnad(OUTPUT robot.xml) has changed. This lead to removing robot.xml when cmake is inovked, this is why we use cache to keep previous variable
if (_corba_port_${PROJECT_NAME})
  set(_corba_port ${_corba_port_${PROJECT_NAME}})
  message(STATUS "using corba port ${_corba_port} (using cache _corba_port_${PROJECT_NAME})")
else()
  set(_corba_port 2890)
  string(RANDOM LENGTH 1 ALPHABET 123456789 _corba_port_offset)
  math(EXPR _corba_port "${_corba_port}+${_corba_port_offset}*10") ## set start point randomly
  message(STATUS "using corba port ${_corba_port} (using offset ${_corba_port_offset})")
  set(_corba_port_${PROJECT_NAME} ${_corba_port} CACHE _corba_port_${PROJECT_NAME} ${_corba_port})
endif()

# helper macros

# get_rtm_naming_exe
# set path of rtm-naming to _rtm_naming_exe variable
macro(get_rtm_naming_exe _rtm_naming_exe)
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(openrtm_aist)
    set(ENV{PKG_CONFIG_PATH} ${openrtm_aist_PACKAGE_PATH}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH})
  endif()
  if (EXISTS ${openrtm_aist_PACKAGE_PATH}/bin/rtm-naming)
    set(${_rtm_naming_exe} ${openrtm_aist_PACKAGE_PATH}/bin/rtm-naming)
  else()
    find_package(PkgConfig)
    pkg_check_modules(openrtm_aist openrtm-aist REQUIRED)
    set(openrtm_aist_PACKAGE_PATH ${openrtm_aist_SOURCE_DIR})
    if (EXISTS ${openrtm_aist_PREFIX}/lib/openrtm_aist/bin/rtm-naming)
      set(${_rtm_naming_exe} ${openrtm_aist_PREFIX}/lib/openrtm_aist/bin/rtm-naming)
    else()
      set(${_rtm_naming_exe} ${openrtm_aist_PREFIX}/bin/rtm-naming)
    endif()
  endif()
endmacro(get_rtm_naming_exe)

macro(get_controller_config_converter _controller_config_converter)
    if(${USE_ROSBUILD})
    rosbuild_find_ros_package(hrpsys_ros_bridge)
  else()
    find_package(hrpsys_ros_bridge)
    if(hrpsys_ros_bridge_SOURCE_DIR)
      set(hrpsys_ros_bridge_PACKAGE_PATH ${hrpsys_ros_bridge_SOURCE_DIR})
    elseif(hrpsys_ros_bridge_SOURCE_PREFIX)
      set(hrpsys_ros_bridge_PACKAGE_PATH ${hrpsys_ros_bridge_SOURCE_PREFIX})
    else(hrpsys_ros_bridge_SOURCE_PREFIX)
      set(hrpsys_ros_bridge_PACKAGE_PATH ${hrpsys_ros_bridge_PREFIX}/share/hrpsys_ros_bridge)
    endif()
  endif()
  set(${_controller_config_converter}
    ${hrpsys_ros_bridge_PACKAGE_PATH}/scripts/controller_config_converter.py)
endmacro(get_controller_config_converter _controller_config_converter)

# convert OpenHRP3 vrml file into collada file, urdf+mesh file and euslisp file
macro(compile_openhrp_model wrlfile)
  math(EXPR _corba_port "${_corba_port}+1")
  message("compile openhrp model ${wrlfile} at port ${_corba_port}")
  set(_workdir ${PROJECT_SOURCE_DIR}/models)
  if(NOT EXISTS ${_workdir})
    file(MAKE_DIRECTORY ${_workdir})
  endif(NOT EXISTS ${_workdir})
  if("${ARGN}" STREQUAL "")
    get_filename_component(_name ${wrlfile} NAME_WE)
    set(_export_collada_option "")
    set(_conf_file_option "")
    set(_robothardware_conf_file_option "")
    set(_conf_dt_option "")
    set(_simulation_timestep_option "")
    set(_simulation_joint_properties_option "")
  else()
    set(_name ${ARGV1})
    get_export_collada_option(_export_collada_option ${ARGV})
    get_conf_file_option(_conf_file_option _robothardware_conf_file_option _conf_dt_option _simulation_timestep_option _simulation_joint_properties_option ${ARGV})
  endif()
  set(_daefile "${_workdir}/${_name}.dae")
  set(_xmlfile "${_workdir}/${_name}.xml")
  set(_xmlfile_nosim "${_workdir}/${_name}_nosim.xml")
  set(_controller_config "${_workdir}/${_name}_controller_config.yaml")
  # this command should depends on the LATEST compile_robots, in order to prevent
  # parallel execution of rostest
  if (compile_robots)
    list(LENGTH compile_robots _compile_robot_length)
    math(EXPR _compile_robot_latest_index "${_compile_robot_length} - 1")
    list(GET compile_robots ${_compile_robot_latest_index} _latest_robot)
  endif(compile_robots)
  if (EXISTS ${_controller_config})
    execute_process(COMMAND sh -c "grep 'auto generated' ${_controller_config} | wc -l" OUTPUT_VARIABLE _auto_generated)
    if (${_auto_generated} LESS 1)
      unset(_controller_config)
    endif()
  endif()
  string(TOLOWER ${_name} _sname)
  set(_yamlfile "${_workdir}/${_sname}.yaml")
  set(_lispfile "${_workdir}/${_sname}.l")
  set(_urdffile "${_workdir}/${_name}.urdf")
  # rtm-naming
  get_rtm_naming_exe(_rtm_naming_exe)
  # use euscollada
  get_collada2eus(_collada2eus_exe _collada2eus_option _euscollada_dep_files)
  # use collad_to_urdf
  get_collada_to_urdf(_collada_to_urdf_exe)
  # use controller_config_converter
  get_controller_config_converter(_controller_config_converter)
  # check if binary exists
  if(NOT EXISTS ${_rtm_naming_exe})
    message(FATAL_ERROR "-- ${_rtm_naming_exe} not found")
  endif()
  if(NOT EXISTS ${_collada2eus_exe})
    message(AUTHOR_WARNING "-- ${_collada2eus_exe} not found")
  else()
    #
    set(_euscollada_dep_files ${_collada2eus_exe} ${euscollada_PACKAGE_PATH}/src/euscollada-robot.l)
    if(${USE_ROSBUILD})
      set(_collada2eus_option "")
    else()
      set(_collada2eus_option ROS_PACKAGE_PATH=${euscollada_PACKAGE_PATH}/..:$ENV{ROS_PACKAGE_PATH})
    endif()
    if(EXISTS ${_yamlfile})
      add_custom_command(OUTPUT ${_lispfile}
        COMMAND ${_collada2eus_option} ${_collada2eus_exe} ${_daefile} ${_yamlfile} ${_lispfile}
        DEPENDS ${_daefile} ${_yamlfile} ${_euscollada_dep_files})
    else(EXISTS ${_yamlfile})
      add_custom_command(OUTPUT ${_lispfile}
        COMMAND ${_collada2eus_option} ${_collada2eus_exe} ${_daefile} ${_lispfile}
        DEPENDS ${_daefile} ${_euscollada_dep_files})
    endif(EXISTS ${_yamlfile})
  endif()
  if(NOT EXISTS ${_collada_to_urdf_exe})
    message(AUTHOR_WARNING "-- ${_collada_to_urdf_exe} not found")
  else()
    set(_mesh_dir "${_workdir}/${_name}_meshes")
    if(PROJECT_NAME)
      set(_mesh_prefix "package://${PROJECT_NAME}/models/${_name}_meshes")
    else()
      set(_mesh_prefix "file://${_workdir}/${_name}_meshes") ## set absolute file path
    endif()
    #Depends on _lispfile in order to avoid parallel computation
    # collada_to_urdf fails if it run in parallel
    if(NOT EXISTS ${_collada2eus_exe})
      set(_lisp_deps_for_urdf)
    else(NOT EXISTS ${_collada2eus_exe})
      set(_lisp_deps_for_urdf ${_lispfile})
    endif(NOT EXISTS ${_collada2eus_exe})
    add_custom_command(OUTPUT ${_urdffile} ${_mesh_dir}
      COMMAND ${_collada_to_urdf_exe} ${_daefile} --output_file ${_urdffile} -G -A --mesh_output_dir ${_mesh_dir} --mesh_prefix ${_mesh_prefix}
      DEPENDS ${_daefile} ${_lisp_deps_for_urdf})
  endif()
  if(_controller_config)
    if(EXISTS ${_controller_config_converter} AND EXISTS ${_yamlfile})
      add_custom_command(OUTPUT ${_controller_config}
        COMMAND ${_controller_config_converter} ${_yamlfile} ${_controller_config}
        DEPENDS ${_yamlfile})
    else()
      add_custom_command(OUTPUT ${_controller_config}
        COMMAND ${_controller_config_converter} ${_controller_config})
    endif()
  endif()
  # use export-collada
  get_export_collada_exe(_export_collada_exe)
  if(EXISTS ${_export_collada_exe})
    if(${USE_ROSBUILD})
      add_custom_command(OUTPUT ${_daefile}
        COMMAND ${_export_collada_exe} -i ${wrlfile} -o ${_daefile} ${_export_collada_option}
        DEPENDS ${wrlfile} ${_export_collada_exe} ${_latest_robot})
    else()                      #when catkin, appending LD_LIBRARY_PATH
      add_custom_command(OUTPUT ${_daefile}
        COMMAND LD_LIBRARY_PATH=$ENV{LD_LIBRARY_PATH}:${CATKIN_DEVEL_PREFIX}/lib ${_export_collada_exe} -i ${wrlfile} -o ${_daefile} ${_export_collada_option}
        DEPENDS ${wrlfile} ${_export_collada_exe} ${_latest_robot})
    endif()
  endif()
  # use _gen_project.launch
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(hrpsys)
    rosbuild_find_ros_package(hrpsys_tools)
  else()
    find_package(hrpsys_tools)
    if(EXISTS ${openhrp3_SOURCE_DIR})
      set(openhrp3_PACKAGE_PATH ${openhrp3_SOURCE_DIR})
    else()
      set(openhrp3_PACKAGE_PATH ${openhrp3_PREFIX}/share/openhrp3)
    endif()
    if(EXISTS ${hrpsys_SOURCE_DIR})
      set(hrpsys_PACKAGE_PATH ${hrpsys_SOURCE_DIR})
    else()
      set(hrpsys_PACKAGE_PATH ${hrpsys_PREFIX}/share/hrpsys)
    endif()
    if(EXISTS ${hrpsys_tools_SOURCE_DIR})
      set(hrpsys_tools_PACKAGE_PATH ${hrpsys_tools_SOURCE_DIR})
    elseif(EXISTS ${hrpsys_tools_SOURCE_PREFIX})
      set(hrpsys_tools_PACKAGE_PATH ${hrpsys_tools_SOURCE_PREFIX})
    else()
      set(hrpsys_tools_PACKAGE_PATH ${hrpsys_tools_PREFIX}/share/hrpsys_tools)
    endif()
  endif()
  if(EXISTS ${hrpsys_PACKAGE_PATH}/bin/ProjectGenerator)
    set(_gen_project_dep_files ${hrpsys_PACKAGE_PATH}/bin/ProjectGenerator ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch)
  elseif(EXISTS ${hrpsys_PREFIX}/lib/hrpsys/ProjectGenerator)
    set(_gen_project_dep_files ${hrpsys_PREFIX}/lib/hrpsys/ProjectGenerator ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch)
  else()
    # when hrpsys is catkin installed
    set(_gen_project_dep_files)
    message("assuming hrpsys/ProjectGenerator is already compiled")
  endif()
  message("compile_openhrp3_model ${wrlfile}")
  message("  hrpsys_tools_PACKAGE_PATH = ${hrpsys_tools_PACKAGE_PATH}")
  message("  hrpsys_PACKAGE_PATH       = ${hrpsys_PACKAGE_PATH}")
  message("  openhrp3_PACKAGE_PATH     = ${openhrp3_PACKAGE_PATH}")
  set(_CMAKE_PREFIX_PATH "")
  foreach(_PATH ${CMAKE_PREFIX_PATH})
    set(_CMAKE_PREFIX_PATH "${_CMAKE_PREFIX_PATH}:${_PATH}")
  endforeach()
  if(EXISTS ${openhrp3_PREFIX}/share/OpenHRP-3.1/sample/model/longfloor.wrl)
    set(_conf_file_option "${_conf_file_option} OBJECT_MODELS:=${openhrp3_PREFIX}/share/OpenHRP-3.1/sample/model/longfloor.wrl,0,0,0,0,0,1,0")
  endif()
  add_custom_command(OUTPUT ${_xmlfile}
    COMMAND ${_rtm_naming_exe} ${_corba_port} || echo "fail to run rtm_naming, but try to continue"
    COMMAND sh -c "CMAKE_PREFIX_PATH=${_CMAKE_PREFIX_PATH} ROS_PACKAGE_PATH=${hrpsys_tools_PACKAGE_PATH}:${hrpsys_PACKAGE_PATH}:${openhrp3_PACKAGE_PATH}:$ENV{ROS_PACKAGE_PATH} rostest -t ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch CORBA_PORT:=${_corba_port} INPUT:=${wrlfile} OUTPUT:=${_xmlfile} ${_conf_file_option} ${_robothardware_conf_file_option} ${_conf_dt_option} ${_simulation_timestep_option} ${_simulation_joint_properties_option}"
    COMMAND pkill -KILL -f "omniNames -start ${_corba_port}" || echo "no process to kill"
    DEPENDS ${daefile} ${_gen_project_dep_files})
  add_custom_command(OUTPUT ${_xmlfile_nosim}
    COMMAND ${_rtm_naming_exe} ${_corba_port} || echo "fail to run rtm_naming, but try to continue"
    COMMAND sh -c "CMAKE_PREFIX_PATH=${_CMAKE_PREFIX_PATH} ROS_PACKAGE_PATH=${hrpsys_tools_PACKAGE_PATH}:${hrpsys_PACKAGE_PATH}:${openhrp3_PACKAGE_PATH}:$ENV{ROS_PACKAGE_PATH} rostest -t ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch CORBA_PORT:=${_corba_port} INPUT:=${wrlfile} OUTPUT:=${_xmlfile_nosim} INTEGRATE:=false ${_conf_file_option} ${_robothardware_conf_file_option} ${_conf_dt_option} ${_simulation_timestep_option} ${_simulation_joint_properties_option}"
    COMMAND pkill -KILL -f "omniNames -start ${_corba_port}" || echo "no process to kill"
    DEPENDS ${daefile} ${_gen_project_dep_files} ${_xmlfile})
  if(_controller_config)
    list(APPEND _depends_files ${_xmlfile} ${_xmlfile_nosim} ${_controller_config})
  else()
    list(APPEND _depends_files ${_xmlfile} ${_xmlfile_nosim})
  endif()
  if(EXISTS ${_export_collada_exe})
    list(APPEND _depends_files ${_daefile})
    if(EXISTS ${_collada2eus_exe})
      list(APPEND _depends_files ${_lispfile})
    endif()
    if(EXISTS ${_collada_to_urdf_exe})
      list(APPEND _depends_files ${_urdffile})
    endif()
  endif()
  add_custom_target(${_sname}_${PROJECT_NAME}_compile DEPENDS ${_depends_files})
  ## make sure to kill nameserver
  add_custom_command(OUTPUT ${_sname}_${PROJECT_NAME}_compile_cleanup
    COMMAND echo "pkill -KILL -f omniNames -start ${_corba_port} for compile_openhrp_model"
    COMMAND echo "pkill -KILL -f omniNames\\ -start\\ ${_corba_port}" >  ./pkill-omninames-${_corba_port}.sh
    COMMAND sh ./pkill-omninames-${_corba_port}.sh || echo "no process to kill"
    COMMAND ps -C omniNames || true
    DEPENDS  ${_sname}_${PROJECT_NAME}_compile
    VERBATIM)
  add_custom_target(${_sname}_${PROJECT_NAME}_compile_all ALL DEPENDS ${_sname}_${PROJECT_NAME}_compile_cleanup)
  get_directory_property(_current_directory_properties ADDITIONAL_MAKE_CLEAN_FILES)
  set_directory_properties(PROPERTIES ADDITIONAL_MAKE_CLEAN_FILES
    "${_workdir}/${_name}.conf;${_workdir}/${_name}.RobotHardware.conf;${_workdir}/${_name}_nosim.conf;${_workdir}/${_name}_nosim.RobotHardware.conf;${_current_directory_properties}")
  list(APPEND compile_robots ${_sname}_${PROJECT_NAME}_compile_all)
  set(compile_robots ${compile_robots} PARENT_SCOPE)
endmacro(compile_openhrp_model)

# get path, option and dependending files to collada2eus 
macro(get_collada2eus _collada2eus_exe _collada2eus_option _euscollada_dep_files)
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(euscollada)
    set(${_collada2eus_exe} ${euscollada_PACKAGE_PATH}/bin/collada2eus)
    set(${_euscollada_dep_files} ${euscollada_PACKAGE_PATH}/bin/collada2eus ${euscollada_PACKAGE_PATH}/src/euscollada-robot.l)
  else()
    find_package(euscollada)
    if(euscollada_SOURCE_DIR)
      set(euscollada_PACKAGE_PATH ${euscollada_SOURCE_DIR})
    elseif(euscollada_SOURCE_PREFIX)
      set(euscollada_PACKAGE_PATH ${euscollada_SOURCE_PREFIX})
    else()
      set(euscollada_PACKAGE_PATH ${euscollada_PREFIX}/share/euscollada)
    endif()
    set(${_collada2eus_exe} ${euscollada_PREFIX}/lib/euscollada/collada2eus)
  endif()
  if(${USE_ROSBUILD})
    set(${_collada2eus_option} "")
  else()
    set(${_collada2eus_option} ROS_PACKAGE_PATH=${euscollada_PACKAGE_PATH}/..:$ENV{ROS_PACKAGE_PATH})
  endif()
endmacro(get_collada2eus _collada2eus_exe _collada2eus_option _euscollada_dep_files)

# get path to collada_to_urdf
macro(get_collada_to_urdf _collada_to_urdf_exe)
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(collada_tools)
    set(${_collada_to_urdf_exe} ${collada_tools_PACKAGE_PATH}/bin/collada_to_urdf)
  else()
    find_package(collada_urdf)
    set(${_collada_to_urdf_exe} ${collada_urdf_PREFIX}/lib/collada_urdf/collada_to_urdf)
  endif()
endmacro(get_collada_to_urdf _collada_to_urdf_exe)

macro(get_export_collada_exe _export_collada_exe)
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(openhrp3)
    set(ENV{PKG_CONFIG_PATH} ${openhrp3_PACKAGE_PATH}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH})
  endif()
  if (EXISTS ${openhrp3_PACKAGE_PATH}/bin/export-collada)
    set(${_export_collada_exe} ${openhrp3_PACKAGE_PATH}/bin/export-collada)
  else()
    find_package(openhrp3 QUIET)
    if(NOT openhrp3_FOUND)
      find_package(PkgConfig)
      pkg_check_modules(openhrp3 openhrp3.1 REQUIRED)
    endif()
    set(openhrp3_PACKAGE_PATH ${openhrp3_SOURCE_DIR})
    if(EXISTS ${openhrp3_PREFIX}/bin/export-collada)
      set(${_export_collada_exe} ${openhrp3_PREFIX}/bin/export-collada)
    else()
      set(${_export_collada_exe} ${openhrp3_PREFIX}/lib/openhrp3/export-collada)
    endif()
  endif()
  if(EXISTS ${${_export_collada_exe}})
    message("using export-collada to convert models ${${_export_collada_exe}}")
  else()
    # when openhrp3 is catkin installed
    message(FATAL_ERROR "assuming export-collada(${${_export_collada_exe}}) is already compiled")
    set(${_export_collada_exe})
  endif()
endmacro(get_export_collada_exe _export_collada_exe)

macro(compile_collada_model daefile)
  math(EXPR _corba_port "${_corba_port}+1")
  message("compile collada model ${daefile} at port ${_corba_port}")
  set(_workdir ${PROJECT_SOURCE_DIR}/models)
  if(NOT EXISTS ${_workdir})
    file(MAKE_DIRECTORY ${_workdir})
  endif(NOT EXISTS ${_workdir})
  get_filename_component(_name ${daefile} NAME_WE)
  if("${ARGN}" STREQUAL "")
    set(_conf_file_option "")
    set(_robothardware_conf_file_option "")
    set(_conf_dt_option "")
    set(_simulation_timestep_option "")
    set(_simulation_joint_properties_option "")
    set(_proj_file_root_option "")
    set(_euscollada_option "")
  else()
    get_conf_file_option(_conf_file_option _robothardware_conf_file_option _conf_dt_option _simulation_timestep_option _simulation_joint_properties_option ${ARGV})
    get_proj_file_root_option(_proj_file_root_option ${ARGV})
    get_euscollada_option(_euscollada_option ${ARGV})
  endif()
  set(_xmlfile "${_workdir}/${_name}.xml")
  set(_xmlfile_nosim "${_workdir}/${_name}_nosim.xml")
  set(_controller_config "${_workdir}/${_name}_controller_config.yaml")
  if (EXISTS ${_controller_config})
    execute_process(COMMAND sh -c "grep 'auto generated' ${_controller_config} | wc -l" OUTPUT_VARIABLE _auto_generated)
    if (${_auto_generated} LESS 1)
      unset(_controller_config)
    endif()
  endif()
  string(TOLOWER ${_name} _sname)
  set(_yamlfile "${_workdir}/${_sname}.yaml")
  set(_lispfile "${_workdir}/${_sname}.l")
  set(_urdffile "${_workdir}/${_name}.urdf")
  # rtm-naming
  get_rtm_naming_exe(_rtm_naming_exe)
  # use collada2eus
  get_collada2eus(_collada2eus_exe _collada2eus_option _euscollada_dep_files)
  # use collad_to_urdf
  get_collada_to_urdf(_collada_to_urdf_exe)
  # use controller_config_converter
  get_controller_config_converter(_controller_config_converter)
  # check if binary exists
  if(NOT EXISTS ${_rtm_naming_exe})
    message(FATAL_ERROR "-- ${_rtm_naming_exe} not found")
  endif()
  if(NOT EXISTS ${_collada2eus_exe})
    message(AUTHOR_WARNING "-- ${_collada2eus_exe} not found")
  else()
    if(EXISTS ${_yamlfile})
      add_custom_command(OUTPUT ${_lispfile}
        COMMAND ${_collada2eus_option} ${_collada2eus_exe} ${daefile} ${_yamlfile} ${_lispfile} ${_euscollada_option} ||  echo "[WARNING] ### Did not run collada2eus for ${_lispfile}"
        DEPENDS ${daefile} ${_euscollada_dep_files})
    else(EXISTS ${_yamlfile})
      add_custom_command(OUTPUT ${_lispfile}
        COMMAND ${_collada2eus_option} ${_collada2eus_exe} ${daefile} ${_lispfile} ${_euscollada_option} || echo "[WARNING] ### Did not run collada2eus $for {_lispfile}"
        DEPENDS ${daefile} ${_euscollada_dep_files})
    endif(EXISTS ${_yamlfile})
  endif()
  if(NOT EXISTS ${_collada_to_urdf_exe})
    message(AUTHOR_WARNING "-- ${_collada_to_urdf_exe} not found")
  else()
    set(_mesh_dir "${_workdir}/${_name}_meshes")
    if(PROJECT_NAME)
      set(_mesh_prefix "package://${PROJECT_NAME}/models/${_name}_meshes")
    else()
      set(_mesh_prefix "file://${_workdir}/${_name}_meshes") ## set absolute file path
    endif()
    add_custom_command(OUTPUT ${_urdffile} ${_mesh_dir}
      COMMAND ${_collada_to_urdf_exe} ${daefile} --output_file ${_urdffile} -G -A --mesh_output_dir ${_mesh_dir} --mesh_prefix ${_mesh_prefix}
      DEPENDS ${daefile})
  endif()
  if(_controller_config)
    if(EXISTS ${_controller_config_converter} AND EXISTS ${_yamlfile})
      add_custom_command(OUTPUT ${_controller_config}
        COMMAND ${_controller_config_converter} ${_yamlfile} ${_controller_config}
        DEPENDS ${_yamlfile})
    else()
      add_custom_command(OUTPUT ${_controller_config}
        COMMAND ${_controller_config_converter} ${_controller_config})
    endif()
  endif()
  # use _gen_project.launch
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(hrpsys)
    rosbuild_find_ros_package(hrpsys_tools)
  else()
    find_package(hrpsys)
    find_package(hrpsys_tools)
    if(EXISTS ${openhrp3_SOURCE_DIR})
      set(openhrp3_PACKAGE_PATH ${openhrp3_SOURCE_DIR})
    else()
      set(openhrp3_PACKAGE_PATH ${openhrp3_PREFIX}/share/openhrp3)
    endif()
    if(EXISTS ${hrpsys_SOURCE_DIR})
      set(hrpsys_PACKAGE_PATH ${hrpsys_SOURCE_DIR})
    else()
      set(hrpsys_PACKAGE_PATH ${hrpsys_PREFIX}/share/hrpsys)
    endif()
    if(EXISTS ${hrpsys_tools_SOURCE_DIR})
      set(hrpsys_tools_PACKAGE_PATH ${hrpsys_tools_SOURCE_DIR})
    elseif(EXISTS ${hrpsys_tools_SOURCE_PREFIX})
      set(hrpsys_tools_PACKAGE_PATH ${hrpsys_tools_SOURCE_PREFIX})
    else()
      set(hrpsys_tools_PACKAGE_PATH ${hrpsys_tools_PREFIX}/share/hrpsys_tools)
    endif()
  endif()
  if(EXISTS ${hrpsys_PACKAGE_PATH}/bin/ProjectGenerator)
    set(_gen_project_dep_files ${hrpsys_PACKAGE_PATH}/bin/ProjectGenerator ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch)
  elseif(EXISTS ${hrpsys_PREFIX}/lib/hrpsys/ProjectGenerator)
    set(_gen_project_dep_files ${hrpsys_PREFIX}/lib/hrpsys/ProjectGenerator ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch)
  else()
    # when hrpsys is catkin installed
    set(_gen_project_dep_files)
    message("assuming hrpsys/ProjectGenerator is already compiled")
  endif()
  # this command should depends on the LATEST compile_robots, in order to prevent
  # parallel execution of rostest
  if (compile_robots)
    list(LENGTH compile_robots _compile_robot_length)
    math(EXPR _compile_robot_latest_index "${_compile_robot_length} - 1")
    list(GET compile_robots ${_compile_robot_latest_index} _latest_robot)
  endif(compile_robots)
  message("compile_collada_model ${daefile}")
  message("  hrpsys_tools_PACKAGE_PATH = ${hrpsys_tools_PACKAGE_PATH}")
  message("  hrpsys_PACKAGE_PATH       = ${hrpsys_PACKAGE_PATH}")
  message("  openhrp3_PACKAGE_PATH     = ${openhrp3_PACKAGE_PATH}")
  set(_CMAKE_PREFIX_PATH "")
  foreach(_PATH ${CMAKE_PREFIX_PATH})
    set(_CMAKE_PREFIX_PATH "${_CMAKE_PREFIX_PATH}:${_PATH}")
  endforeach()
  if(EXISTS ${openhrp3_PREFIX}/share/OpenHRP-3.1/sample/model/longfloor.wrl)
    set(_conf_file_option "${_conf_file_option} OBJECT_MODELS:=${openhrp3_PREFIX}/share/OpenHRP-3.1/sample/model/longfloor.wrl,0,0,0,0,0,1,0")
  endif()
  add_custom_command(OUTPUT ${_xmlfile}
    COMMAND ${_rtm_naming_exe} ${_corba_port} || echo "fail to run rtm_naming, but try to continue"
    COMMAND sh -c "CMAKE_PREFIX_PATH=${_CMAKE_PREFIX_PATH} ROS_PACKAGE_PATH=${hrpsys_tools_PACKAGE_PATH}:${hrpsys_PACKAGE_PATH}:${openhrp3_PACKAGE_PATH}:$ENV{ROS_PACKAGE_PATH} rostest -t ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch CORBA_PORT:=${_corba_port} INPUT:=${daefile}${_proj_file_root_option} OUTPUT:=${_xmlfile} ${_conf_file_option} ${_robothardware_conf_file_option} ${_conf_dt_option} ${_simulation_timestep_option} ${_simulation_joint_properties_option}"
    COMMAND pkill -KILL -f "omniNames -start ${_corba_port}" || echo "no process to kill"
    DEPENDS ${daefile} ${_gen_project_dep_files} ${_latest_robot})
  add_custom_command(OUTPUT ${_xmlfile_nosim}
    COMMAND ${_rtm_naming_exe} ${_corba_port} || echo "fail to run rtm_naming, but try to continue"
    COMMAND sh -c "CMAKE_PREFIX_PATH=${_CMAKE_PREFIX_PATH} ROS_PACKAGE_PATH=${hrpsys_tools_PACKAGE_PATH}:${hrpsys_PACKAGE_PATH}:${openhrp3_PACKAGE_PATH}:$ENV{ROS_PACKAGE_PATH} rostest -t ${hrpsys_tools_PACKAGE_PATH}/launch/_gen_project.launch CORBA_PORT:=${_corba_port} INPUT:=${daefile}${_proj_file_root_option} OUTPUT:=${_xmlfile_nosim} INTEGRATE:=false ${_conf_file_option} ${_robothardware_conf_file_option} ${_conf_dt_option} ${_simulation_timestep_option} ${_simulation_joint_properties_option}"
    COMMAND pkill -KILL -f "omniNames -start ${_corba_port}" || echo "no process to kill"
    DEPENDS ${daefile} ${_gen_project_dep_files} ${_xmlfile})
  if(_controller_config)
    list(APPEND _depends_files ${_xmlfile} ${_xmlfile_nosim} ${_controller_config})
  else()
    list(APPEND _depends_files ${_xmlfile} ${_xmlfile_nosim})
  endif()
  if(EXISTS ${_collada2eus_exe})
    list(APPEND _depends_files ${_lispfile})
  endif()
  if(EXISTS ${_collada_to_urdf_exe})
    list(APPEND _depends_files ${_urdffile})
  endif()
  add_custom_target(${_sname}_${PROJECT_NAME}_compile DEPENDS ${_depends_files})
  ## make sure to kill nameserver
  add_custom_command(OUTPUT ${_sname}_${PROJECT_NAME}_compile_cleanup
    COMMAND echo "pkill -KILL -f omniNames -start ${_corba_port} for compile_collada_model"
    COMMAND echo "pkill -KILL -f omniNames\\ -start\\ ${_corba_port}" >  ./pkill-omninames-${_corba_port}.sh
    COMMAND sh ./pkill-omninames-${_corba_port}.sh || echo "no process to kill"
    COMMAND ps -C omniNames || true
    DEPENDS  ${_sname}_${PROJECT_NAME}_compile
    VERBATIM)
  add_custom_target(${_sname}_${PROJECT_NAME}_compile_all ALL DEPENDS ${_sname}_${PROJECT_NAME}_compile_cleanup)
  get_directory_property(_current_directory_properties ADDITIONAL_MAKE_CLEAN_FILES)
  set_directory_properties(PROPERTIES ADDITIONAL_MAKE_CLEAN_FILES
    "${_workdir}/${_name}.conf;${_workdir}/${_name}.RobotHardware.conf;${_workdir}/${_name}_nosim.conf;${_workdir}/${_name}_nosim.RobotHardware.conf;${_current_directory_properties}")
  list(APPEND compile_robots ${_sname}_${PROJECT_NAME}_compile_all)
  set(compile_robots ${compile_robots} PARENT_SCOPE)
endmacro(compile_collada_model daefile)

macro (generate_default_launch_eusinterface_files wrlfile project_pkg_name)
  if("${ARGN}" STREQUAL "")
    get_filename_component(_name ${wrlfile} NAME_WE)
  else()
    set(_name ${ARGV2})
  endif()
  string(TOLOWER ${_name} _sname)
  set(PROJECT_PKG_NAME ${project_pkg_name})
  set(MODEL_FILE ${wrlfile})
  set(ROBOT ${_name})
  set(robot ${_sname})
  if(${USE_ROSBUILD})
    rosbuild_find_ros_package(hrpsys_ros_bridge)
  elseif(EXISTS ${hrpsys_ros_bridge_SOURCE_DIR}/scripts)
    set(hrpsys_ros_bridge_PACKAGE_PATH ${hrpsys_ros_bridge_SOURCE_DIR})
  elseif(EXISTS ${hrpsys_ros_bridge_PREFIX}/share/hrpsys_ros_bridge/scripts)
    set(hrpsys_ros_bridge_PACKAGE_PATH ${hrpsys_ros_bridge_PREFIX}/share/hrpsys_ros_bridge)
  else()
    execute_process(COMMAND rospack find hrpsys_ros_bridge OUTPUT_VARIABLE hrpsys_ros_bridge_PACKAGE_PATH
      OUTPUT_STRIP_TRAILING_WHITESPACE)
  endif()
  message("Generate launch files for ${ROBOT}")
  message("  PROJECT_PKG_NAME = ${PROJECT_PKG_NAME}")
  message("        MODEL_FILE = ${MODEL_FILE}")
  message("             ROBOT = ${ROBOT}")
  message("hrpsys_ros_bridge_PACKAGE_PATH = ${hrpsys_ros_bridge_PACKAGE_PATH}")
  if(NOT EXISTS ${hrpsys_ros_bridge_PACKAGE_PATH}/scripts)
    message(FATAL_ERROR "hrpsys_ros_bridge_PACKAGE_PATH could not found")
  endif()

  # generate files
  set(${_sname}_generated_launch_euslisp_files)
  #   generate hrpsys_config.py to use unstable RTCs
  set(ROSBRIDGE_ARGS "    <arg name=\"BASE_LINK\" default=\"WAIST_LINK0\" />\n")
  if ("${ARGV3}" STREQUAL "--use-unstable-hrpsys-config")
    set(ROSBRIDGE_ARGS "    <arg name=\"USE_WALKING\" default=\"true\" />\n    <arg name=\"USE_IMPEDANCECONTROLLER\" default=\"true\" />${ROSBRIDGE_ARGS}")
    set(STARTUP_ARGS "    <arg name=\"HRPSYS_PY_ARGS\" default=\"--use-unstable-rtc\" />")
  elseif ("${ARGV3}" STREQUAL "--use-robot-hrpsys-config")
    set(ROSBRIDGE_ARGS "    <arg name=\"USE_WALKING\" default=\"true\" />\n    <arg name=\"USE_IMPEDANCECONTROLLER\" default=\"true\" />${ROSBRIDGE_ARGS}")
    set(STARTUP_ARGS "    <arg name=\"HRPSYS_PY_PKG\" default=\"${PROJECT_PKG_NAME}\" />\n    <arg name=\"HRPSYS_PY_NAME\" default=\"${_sname}_hrpsys_config.py\" />")
  endif()
  #  generate startup.launch
  configure_file(${hrpsys_ros_bridge_PACKAGE_PATH}/scripts/default_robot_startup.launch.in ${PROJECT_SOURCE_DIR}/launch/${_sname}_startup.launch)
  list(APPEND ${_sname}_generated_launch_euslisp_files ${PROJECT_SOURCE_DIR}/launch/${_sname}_startup.launch)
  #  generate ros_bridge.launch
  configure_file(${hrpsys_ros_bridge_PACKAGE_PATH}/scripts/default_robot_ros_bridge.launch.in ${PROJECT_SOURCE_DIR}/launch/${_sname}_ros_bridge.launch)
  list(APPEND ${_sname}_generated_launch_euslisp_files ${PROJECT_SOURCE_DIR}/launch/${_sname}_ros_bridge.launch)
  #  generate toplevel launch which includes ros_bridge.launch and startup.launch
  if (NOT "${ARGV3}" STREQUAL "--no-toplevel-launch")
    configure_file(${hrpsys_ros_bridge_PACKAGE_PATH}/scripts/default_robot.launch.in ${PROJECT_SOURCE_DIR}/launch/${_sname}.launch)
    configure_file(${hrpsys_ros_bridge_PACKAGE_PATH}/scripts/default_robot_nosim.launch.in ${PROJECT_SOURCE_DIR}/launch/${_sname}_nosim.launch)
    list(APPEND ${_sname}_generated_launch_euslisp_files ${PROJECT_SOURCE_DIR}/launch/${_sname}.launch)
    list(APPEND ${_sname}_generated_launch_euslisp_files ${PROJECT_SOURCE_DIR}/launch/${_sname}_nosim.launch)
  endif()
  #  generate euslisp robot-interface file
  if (NOT "${ARGV3}" STREQUAL "--no-euslisp")
    configure_file(${hrpsys_ros_bridge_PACKAGE_PATH}/scripts/default-robot-interface.l.in ${PROJECT_SOURCE_DIR}/build/${_sname}-interface.l)
    list(APPEND ${_sname}_generated_launch_euslisp_files ${PROJECT_SOURCE_DIR}/build/${_sname}-interface.l)
  endif()
  get_directory_property(_current_directory_properties ADDITIONAL_MAKE_CLEAN_FILES)
  set_directory_properties(PROPERTIES ADDITIONAL_MAKE_CLEAN_FILES "${${_sname}_generated_launch_euslisp_files};${_current_directory_properties}")
endmacro ()
