/**
 * @file imu.h
 *
 * Copyright 2013
 * Carnegie Robotics, LLC
 * 4501 Hatfield Street, Pittsburgh, PA 15201
 * http://www.carnegierobotics.com
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Carnegie Robotics, LLC nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL CARNEGIE ROBOTICS, LLC BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **/

#ifndef MULTISENSE_ROS_IMU_H
#define MULTISENSE_ROS_IMU_H

#include <boost/shared_ptr.hpp>
#include <boost/thread.hpp>
#include <ros/ros.h>

#include <sensor_msgs/Imu.h>
#include <geometry_msgs/Vector3Stamped.h>

#include <multisense_lib/MultiSenseChannel.hh>

namespace multisense_ros {

class Imu {
public:

    Imu(crl::multisense::Channel* driver, std::string tf_prefix);
    ~Imu();

    void imuCallback(const crl::multisense::imu::Header& header);

private:

    //
    // CRL sensor API

    crl::multisense::Channel* driver_;

    //
    // Driver nodes

    ros::NodeHandle device_nh_;
    ros::NodeHandle imu_nh_;

    //
    // multisense_ros/RawImuData publishers

    ros::Publisher accelerometer_pub_;
    ros::Publisher gyroscope_pub_;
    ros::Publisher magnetometer_pub_;

    //
    // sensor_msgs/Imu publisher
    ros::Publisher imu_pub_;

    //
    // geometry_msgs/Vector3Stamped publishers
    ros::Publisher accelerometer_vector_pub_;
    ros::Publisher gyroscope_vector_pub_;
    ros::Publisher magnetometer_vector_pub_;

    //
    // IMU message
    sensor_msgs::Imu imu_message_;

    //
    // Publish control

    boost::mutex sub_lock_;
    int32_t total_subscribers_;
    void startStreams();
    void stopStreams();

    //
    // TF prefix and frame ID's
    const std::string tf_prefix_;
    const std::string accel_frameId_;
    const std::string gyro_frameId_;
    const std::string mag_frameId_;

};

}

#endif
