Vision Transfer Library 4.1.2
-----------------------------

The given library provides functionally for receiving and transmitting
image pairs over a computer network. It is typically used for receiving
the processing results of the SP1 stereo vision system. However, the
library also provides functionality for transmitting image pairs. It can
thus be used for emulating the SP1 when performing systems development,
or for transmitting image data to the SP1 when using network image input.

Images can be transmitted with a bit depth of either 8 or 12 bits. In
case of 12-bit images the library inflates the images internally to
16 bits, in order to allow for more efficient processing.

When receiving data from the SP1 stereo vision system, the first image
of an image pair is usually the rectified image of the left camera, with
a bit depth of 8 bits. The second image is a disparity map with subpixel
resolution, which is transmitted as a 12-bit image. Each value in the
disparity map has to be divided by 16 in order to receive disparietes
at the correct scale.

There exist three possible ways for receiving and transmitting image
pairs:

* `ImageProtocol` is the most low-level interface. This class allows for the
  encoding and decoding of image pairs to / from network messages.
  You will have to handle all network communication yourself.

* `ImageTransfer` opens up a network socket for sending and receiving
  image pairs. This class is single-threaded and will thus block when
  receiving or transmitting data.

* `AsyncTransfer` allows for the asynchronous reception or transmission of
  image pairs. This class creates one or more threads that handle all
  network communication.

Further, the library includes the class `Reconstruct3D`, which can be used
for transforming a received disparity map into a set of 3D points.

[Changelog](CHANGELOG.md)
