/*******************************************************************************
 * Copyright (c) 2017 Nerian Vision Technologies
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/
 
#include <iostream>
#include <fstream>
#include <stdexcept>
#include "visiontransfer/imagepair.h"

#ifdef _WIN32
#include <winsock2.h>
#else
#include <arpa/inet.h>
#endif

void ImagePair::writePgmFile(int imageNumber, const char* fileName) {
    if(imageNumber < 0 || imageNumber >1) {
        throw std::runtime_error("Illegal image number!");
    }

    std::fstream strm(fileName, std::ios::out);

    // Write PGM header
    int maxVal, bytesPixel;
    if(formats[imageNumber] == FORMAT_8_BIT) {
        maxVal = 255;
        bytesPixel = 1;
    } else { // 12 bit
        maxVal = 4095;
        bytesPixel = 2;
    }

    strm << "P5 " << width << " " << height << " " << maxVal << std::endl;

    // Write image data
    for(int y = 0; y < height; y++) {
        for(int x = 0; x < width; x++) {
            unsigned char* pixel = &data[imageNumber][y*rowStride[imageNumber] + x*bytesPixel];
            if(bytesPixel == 2) {
                // Swap endianess
                *reinterpret_cast<unsigned short*>(pixel)
                    = htons(*reinterpret_cast<unsigned short*>(pixel));
            }
            strm.write(reinterpret_cast<char*>(pixel), bytesPixel);
        }
    }
}
