SpCom Sample Application
========================

The SpCom application can be compiled for Windows or Linux. For Windows,
precompiled packages are also available. Before compiling SpCom, make
sure that you have the libraries OpenCV and Qt installed.

SpCom provides the following features:

* Receive and display images and disparity maps from SP1.
* Perform color-coding of disparity maps.
* Write received data to files as images or 3D point clouds.
* Transmit image pairs to SP1.
* Simulate SP1 by transmitting images and disparity maps.

SpCom comes with a GUI that provides access to all important functions.
More advanced features are available through command line options. The
command line options can also be used for automating data recording or
playback.

Unless SpCom is run in non-graphical mode, it opens a GUI window that
displays the received image pair. The currently displayed image pair can
be written to disk by pressing the `space` key or by clicking the camera
icon in the toolbar. When pressing the `enter` key or clicking the
recording icon, all subsequent images will be saved.

By default, SpCom listens to incoming network packets on UDP port 7681.
The network settings can be modified through the connection preferences
dialog, or through the command line options. When closing SpCom, it will
save its current settings, which will be automatically re-loaded when
SpCom is launched the next time.

The following command line options are available:

* `--help` Displays information about the available command line
  options.
* `-c color-scheme` Select a color coding scheme for received disparity
  maps (0 = no color, 1 = red / blue, 2 = rainbow).
* `-s directory` Send the images from the given directory. If not
  specified, only image reception will be active.
* `-f fps` Limits the frame rate to the given value. This option can be
  used for controlling the frame rate when transmitting images.
* `-d` Disable image reception. Use this option if you want to transmit
  images only.
* `-n` Non-graphical mode. No GUI window will be opened.
* `-w directory` Immediately start writing all received images to the
  given directory.
* `-3 max.-distance` Whenever capturing a frame, also write a 3D point
  cloud with distances up to the given maximum (0 = off).
* `-h hostname` Use the given remote hostname for communication. Only
  required for TCP communication and for transmitting images through
  UDP.
* `-p port` Use the given remote port number for communication.  Only
  required for TCP communication and for transmitting images through
  UDP.
* `-H hostname` Use the given hostname as local interface address. If
  0.0.0.0 is specified, the default interface will be used.
* `-P port` Use the given local port number for communication. Only
  necessary for receiving images through UDP.
* `-t on/off` Activate / deactivate the usage of TCP as underlying
  network protocol. If TCP is not selected, UDP is used instad.
* `-r on/off` Output the disparity map (right image) as raw 16-bit image
   without bit-depth conversion.
* `-i 0/1` Only displays the left (0) or right (1) image.
* `-T` Print frame timestamps to the console.
* `-z percent` Set zoom factor to the given percentage.
* `-F` Run in fullscreen mode.


SpCom contains icons from the Tango icon theme. For more details please
see: http://tango.freedesktop.org/
