/*******************************************************************************
 * Copyright (c) 2017 Nerian Vision Technologies
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#ifndef DISPLAYWIDGET_H
#define DISPLAYWIDGET_H

#include <QWidget>
#include <QPainter>
#include <opencv2/opencv.hpp>
#include <memory>
#include <mutex>

class SpCom;

class DisplayWidget: public QWidget {
public:
    DisplayWidget(QWidget * parent = nullptr);

    void setImagesToDisplay(bool displayLeft, bool displayRight);
    void setSpCom(std::shared_ptr<SpCom> spcom);
    void setDisplayFrame(const cv::Mat_<cv::Vec3b>& left,
        const cv::Mat_<cv::Vec3b>& right, bool resize);
    void setZoom(int percent);
    virtual void paintEvent(QPaintEvent *) override;

private:
    static constexpr int IMAGE_PADDING = 5;

    bool resizeWidget;
    bool displayLeft;
    bool displayRight;
    int zoomPercent;

    std::shared_ptr<SpCom> spcom;
    cv::Mat_<cv::Vec3b> displayLeftFrame;
    cv::Mat_<cv::Vec3b> displayRightFrame;
    QPainter painter;
};

#endif
