#!/usr/bin/env python3

from setuptools import setup
from distutils.extension import Extension
from Cython.Build import cythonize

import numpy as np
import os

# default to CMake build based directory structure
srcbase = os.getenv("LIBVISIONTRANSFER_SRCDIR", "../..")
libbase = os.getenv("LIBVISIONTRANSFER_LIBDIR", "../..")
libname = os.getenv("LIBVISIONTRANSFER_LIB", "/libvisiontransfer-static.a")
extra_libs_str = os.getenv("LIBVISIONTRANSFER_EXTRA_LIBS", "")
extra_libs = [s.strip() for s in extra_libs_str.split(',') if s.strip()!='']

print('libvisiontransfer src dir:  '+srcbase)
print('libvisiontransfer lib dir:  '+libbase)
print('libvisiontransfer lib name: '+libname)

incdir = srcbase
libdir = libbase

setup(
    name="visiontransfer",
    author="Nerian Vision GmbH",
    author_email="service@nerian.com",
    version="8.3.0",
    packages=["visiontransfer"],
    ext_modules=cythonize(
        Extension(
            name="visiontransfer",
            sources=["visiontransfer/visiontransfer.pyx"],
            include_dirs=[np.get_include(), incdir],
            libraries=[*extra_libs],
            extra_objects=[libbase + libname],
            language="c++",
            define_macros=[("VISIONTRANSFER_NO_DEPRECATION_WARNINGS", "1")], # silently wrap anything we want
            #define_macros=[("NPY_NO_DEPRECATED_API", "NPY_1_7_API_VERSION")], # for numpy; Cython>=3.0 only
        )
    , compiler_directives = { 'embedsignature': True })
)
