/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import _SDOPackage.InvalidParameter;
import _SDOPackage.NVListHolder;
import _SDOPackage.SDOService;
import _SDOPackage.SDOServiceHolder;
import _SDOPackage.ServiceProfile;
import _SDOPackage.ServiceProfileListHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import jp.go.aist.rtm.RTC.FactoryGlobal;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.SdoServiceConsumerBase;
import jp.go.aist.rtm.RTC.SdoServiceConsumerFactory;
import jp.go.aist.rtm.RTC.SdoServiceProviderBase;
import jp.go.aist.rtm.RTC.SdoServiceProviderFactory;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;

public class SdoServiceAdmin {
    private RTObject_impl m_rtobj;
    private List<String> m_consumerTypes = new ArrayList<String>();
    private boolean m_allConsumerEnabled;
    private Vector<SdoServiceProviderBase> m_providers = new Vector();
    private String m_provider_mutex = new String();
    private Vector<SdoServiceConsumerBase> m_consumers = new Vector();
    private String m_consumer_mutex = new String();
    protected Logbuf rtcout;

    public SdoServiceAdmin(RTObject_impl rTObject_impl) {
        Object object;
        this.m_rtobj = rTObject_impl;
        this.m_allConsumerEnabled = true;
        this.rtcout = new Logbuf("SdoServiceAdmin");
        this.rtcout.println(2, "SdoServiceAdmin.SdoServiceAdmin(" + rTObject_impl.getProperties().getProperty("instance_name") + ")");
        Properties properties = this.m_rtobj.getProperties();
        String[] stringArray = properties.getProperty("sdo.service.provider.enabled_services").split(",");
        this.rtcout.println(3, "sdo.service.provider.enabled_services:" + properties.getProperty("sdo.service.provider.enabled_services"));
        Set set = SdoServiceProviderFactory.instance().getIdentifiers();
        properties.setProperty("sdo.service.provider.available_services", StringUtil.flatten(set));
        this.rtcout.println(3, "sdo.service.provider.available_services:" + properties.getProperty("sdo.service.provider.available_services"));
        Set<Object> set2 = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).toLowerCase().equals("all")) {
                set2 = set;
                this.rtcout.println(3, "sdo.service.provider.enabled_services: ALL");
                break;
            }
            for (String string : set) {
                if (!string.equals(object)) continue;
                set2.add(string);
            }
        }
        SdoServiceProviderFactory sdoServiceProviderFactory = SdoServiceProviderFactory.instance();
        for (String string : set2) {
            SdoServiceProviderBase sdoServiceProviderBase = (SdoServiceProviderBase)sdoServiceProviderFactory.createObject(string);
            ServiceProfile serviceProfile = new ServiceProfile();
            serviceProfile.id = string;
            serviceProfile.interface_type = string;
            serviceProfile.service = (SDOService)((Object)sdoServiceProviderBase);
            String string2 = this.ifrToKey(string);
            NVListHolder nVListHolder = new NVListHolder(serviceProfile.properties);
            NVUtil.copyFromProperties(nVListHolder, properties.getNode(string2));
            serviceProfile.properties = nVListHolder.value;
            sdoServiceProviderBase.init(rTObject_impl, serviceProfile);
            this.m_providers.add(sdoServiceProviderBase);
        }
        object = properties.getProperty("sdo.service.consumer.enabled_services");
        this.m_consumerTypes = Arrays.asList(((String)object).split(","));
        this.rtcout.println(3, "sdo.service.consumer.enabled_services:" + (String)object);
        properties.setProperty("sdo.service.consumer.available_services", StringUtil.flatten(SdoServiceConsumerFactory.instance().getIdentifiers()));
        this.rtcout.println(3, "sdo.service.consumer.available_services:" + properties.getProperty("sdo.service.consumer.available_services"));
        for (String string : this.m_consumerTypes) {
            if (!string.toLowerCase().equals("all")) continue;
            this.m_allConsumerEnabled = true;
            this.rtcout.println(3, "sdo.service.consumer.enabled_services: ALL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceProfile[] getServiceProviderProfiles() {
        ServiceProfileListHolder serviceProfileListHolder = new ServiceProfileListHolder();
        ServiceProfileListHolder serviceProfileListHolder2 = new ServiceProfileListHolder();
        String string = this.m_provider_mutex;
        synchronized (string) {
            for (SdoServiceProviderBase sdoServiceProviderBase : this.m_providers) {
                CORBA_SeqUtil.push_back(serviceProfileListHolder2, sdoServiceProviderBase.getProfile());
            }
        }
        return serviceProfileListHolder.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceProfile getServiceProviderProfile(String string) throws InvalidParameter {
        String string2 = string;
        String string3 = this.m_provider_mutex;
        synchronized (string3) {
            for (SdoServiceProviderBase sdoServiceProviderBase : this.m_providers) {
                if (!string2.equals(sdoServiceProviderBase.getProfile().id)) continue;
                return sdoServiceProviderBase.getProfile();
            }
        }
        throw new InvalidParameter();
    }

    public SDOService getServiceProvider(String string) {
        try {
            ServiceProfile serviceProfile = this.getServiceProviderProfile(string);
            SDOServiceHolder sDOServiceHolder = new SDOServiceHolder(serviceProfile.service);
            return sDOServiceHolder.value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSdoServiceProvider(ServiceProfile serviceProfile, SdoServiceProviderBase sdoServiceProviderBase) {
        this.rtcout.println(2, "SdoServiceAdmin.addSdoServiceProvider(if=" + serviceProfile.interface_type + ")");
        String string = this.m_provider_mutex;
        synchronized (string) {
            String string2 = serviceProfile.id;
            for (SdoServiceProviderBase sdoServiceProviderBase2 : this.m_providers) {
                if (!string2.equals(sdoServiceProviderBase2.getProfile().id)) continue;
                this.rtcout.println(6, "SDO service(id=" + serviceProfile.id + ", ifr=" + serviceProfile.interface_type + ") already exists");
                return false;
            }
            this.m_providers.add(sdoServiceProviderBase);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSdoServiceProvider(String string) {
        this.rtcout.println(2, "removeSdoServiceProvider(" + string + ")");
        String string2 = this.m_provider_mutex;
        synchronized (string2) {
            String string3 = string;
            for (SdoServiceProviderBase sdoServiceProviderBase : this.m_providers) {
                if (!string3.equals(sdoServiceProviderBase.getProfile().id)) continue;
                sdoServiceProviderBase.finalize();
                SdoServiceProviderFactory sdoServiceProviderFactory = SdoServiceProviderFactory.instance();
                sdoServiceProviderFactory.deleteObject(sdoServiceProviderBase);
                this.m_providers.remove(sdoServiceProviderBase);
                this.rtcout.println(4, "SDO service provider has been deleted: " + string);
                return true;
            }
            this.rtcout.println(5, "Specified SDO service provider not found: " + string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSdoServiceConsumer(ServiceProfile serviceProfile) {
        SdoServiceConsumerBase sdoServiceConsumerBase2;
        Object object = this.m_provider_mutex;
        synchronized (object) {
            this.rtcout.println(2, "addSdoServiceConsumer(IFR = " + serviceProfile.interface_type + ")");
            if (!this.isEnabledConsumerType(serviceProfile)) {
                return false;
            }
            if (!this.isExistingConsumerType(serviceProfile)) {
                return false;
            }
            this.rtcout.println(3, "Valid SDO service required");
            if (serviceProfile.id.length() < 1) {
                this.rtcout.println(5, "No id specified. It should be given by clients.");
                return false;
            }
            this.rtcout.println(3, "Valid ID specified");
        }
        object = serviceProfile.id;
        for (SdoServiceConsumerBase sdoServiceConsumerBase2 : this.m_consumers) {
            if (!((String)object).equals(sdoServiceConsumerBase2.getProfile().id)) continue;
            this.rtcout.println(4, "Existing consumer is reinitilized.");
            NVListHolder nVListHolder = new NVListHolder(serviceProfile.properties);
            this.rtcout.println(3, "Propeteis are: " + NVUtil.toString(nVListHolder));
            return sdoServiceConsumerBase2.reinit(serviceProfile);
        }
        this.rtcout.println(3, "SDO service properly initialized.");
        object = SdoServiceConsumerFactory.instance();
        String string = serviceProfile.interface_type;
        if (string.length() < 1) {
            return false;
        }
        sdoServiceConsumerBase2 = (SdoServiceConsumerBase)((FactoryGlobal)object).createObject(string);
        if (sdoServiceConsumerBase2 == null) {
            this.rtcout.println(6, "Hmm... consumer must be created.");
            return false;
        }
        this.rtcout.println(3, "An SDO service consumer created.");
        if (!sdoServiceConsumerBase2.init(this.m_rtobj, serviceProfile)) {
            this.rtcout.println(5, "SDO service initialization was failed.");
            this.rtcout.println(3, "id:         " + serviceProfile.id);
            this.rtcout.println(3, "IFR:        " + serviceProfile.interface_type);
            NVListHolder nVListHolder = new NVListHolder(serviceProfile.properties);
            this.rtcout.println(3, "properties: " + NVUtil.toString(nVListHolder));
            ((FactoryGlobal)object).deleteObject(sdoServiceConsumerBase2);
            this.rtcout.println(4, "SDO consumer was deleted by initialization failure");
            return false;
        }
        this.rtcout.println(3, "An SDO service consumer initialized.");
        this.rtcout.println(3, "id:         " + serviceProfile.id);
        this.rtcout.println(3, "IFR:        " + serviceProfile.interface_type);
        NVListHolder nVListHolder = new NVListHolder(serviceProfile.properties);
        this.rtcout.println(3, "properties: " + NVUtil.toString(nVListHolder));
        this.m_consumers.add(sdoServiceConsumerBase2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSdoServiceConsumer(String string) {
        String string2 = this.m_consumer_mutex;
        synchronized (string2) {
            if (string.length() < 1) {
                this.rtcout.println(6, "removeSdoServiceConsumer(): id is invalid.");
                return false;
            }
            this.rtcout.println(2, "removeSdoServiceConsumer(id = " + string + ")");
            String string3 = string;
            for (SdoServiceConsumerBase sdoServiceConsumerBase : this.m_consumers) {
                if (!string3.equals(sdoServiceConsumerBase.getProfile().id)) continue;
                sdoServiceConsumerBase.finalize();
                SdoServiceConsumerFactory sdoServiceConsumerFactory = SdoServiceConsumerFactory.instance();
                sdoServiceConsumerFactory.deleteObject(sdoServiceConsumerBase);
                this.m_consumers.remove(sdoServiceConsumerBase);
                this.rtcout.println(4, "SDO service has been deleted: " + string);
                return true;
            }
        }
        this.rtcout.println(5, "Specified SDO consumer not found: " + string);
        return false;
    }

    protected boolean isEnabledConsumerType(ServiceProfile serviceProfile) {
        if (this.m_allConsumerEnabled) {
            return true;
        }
        for (String string : this.m_consumerTypes) {
            if (!string.equals(serviceProfile.interface_type)) continue;
            this.rtcout.println(3, serviceProfile.interface_type + " is supported SDO service.");
            return true;
        }
        this.rtcout.println(5, "Consumer type is not supported: " + serviceProfile.interface_type);
        return false;
    }

    protected boolean isExistingConsumerType(ServiceProfile serviceProfile) {
        SdoServiceConsumerFactory sdoServiceConsumerFactory = SdoServiceConsumerFactory.instance();
        Set set = sdoServiceConsumerFactory.getIdentifiers();
        for (String string : set) {
            if (!string.equals(serviceProfile.interface_type)) continue;
            this.rtcout.println(3, serviceProfile.interface_type + " exists in the SDO service factory.");
            this.rtcout.println(0, "Available SDO serices in the factory: " + StringUtil.flatten(set));
            return true;
        }
        this.rtcout.println(5, "No available SDO service in the factory: " + serviceProfile.interface_type);
        return false;
    }

    final String getUUID() {
        return UUID.randomUUID().toString();
    }

    private String ifrToKey(String string) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[1].toLowerCase();
        string2 = string2.replace(".", "_");
        string2 = string2.replace("/", ".");
        return string2;
    }
}

