/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static boolean isEscaped(String str, int pos) {
        --pos;
        int i = 0;
        while (pos >= 0 && str.charAt(pos) == '\\') {
            --pos;
            ++i;
        }
        return i % 2 == 1;
    }

    public static String escape(String str) {
        StringBuffer escapedStr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\t': {
                    escapedStr.append("\\t");
                    break;
                }
                case '\n': {
                    escapedStr.append("\\n");
                    break;
                }
                case '\f': {
                    escapedStr.append("\\f");
                    break;
                }
                case '\r': {
                    escapedStr.append("\\r");
                    break;
                }
                default: {
                    escapedStr.append(c);
                }
            }
            ++i;
        }
        return escapedStr.toString();
    }

    public static String unescape(String str) {
        StringBuffer unescaped_str = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (++count % 2 == 0) {
                    unescaped_str.append(c);
                }
            } else if (count > 0 && count % 2 != 0) {
                count = 0;
                if (c == 't') {
                    unescaped_str.append('\t');
                } else if (c == 'n') {
                    unescaped_str.append('\n');
                } else if (c == 'f') {
                    unescaped_str.append('\f');
                } else if (c == 'r') {
                    unescaped_str.append('\r');
                } else if (c == '\"') {
                    unescaped_str.append('\"');
                } else if (c == '\'') {
                    unescaped_str.append('\'');
                } else {
                    unescaped_str.append(c);
                }
            } else {
                count = 0;
                unescaped_str.append(c);
            }
            ++i;
        }
        return unescaped_str.toString();
    }

    public static boolean toBool(String target, String yes, String no, boolean default_value) {
        if (target.toUpperCase().contains(yes.toUpperCase())) {
            return true;
        }
        if (target.toUpperCase().contains(no.toUpperCase())) {
            return false;
        }
        return default_value;
    }

    public static Vector<String> unique_sv(String[] sv) {
        Vector<String> str = new Vector<String>();
        int intIdx = 0;
        while (intIdx < sv.length) {
            if (!sv[intIdx].trim().equals("") && !str.contains(sv[intIdx])) {
                str.add(sv[intIdx]);
            }
            ++intIdx;
        }
        return str;
    }

    public static String flatten(Vector<String> sv) {
        if (sv.size() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int intIdx = 0;
        while (intIdx < sv.size() - 1) {
            str.append(String.valueOf(sv.elementAt(intIdx)) + ", ");
            ++intIdx;
        }
        str.append(sv.lastElement());
        return str.toString();
    }

    public static Vector<String> split(String input, String delimiter) {
        Vector<String> result = new Vector<String>();
        if (input == null || input.equals("")) {
            return result;
        }
        String[] splitted = input.split(delimiter);
        int intIdx = 0;
        while (intIdx < splitted.length) {
            if (!splitted[intIdx].trim().equals("")) {
                result.add(splitted[intIdx].trim());
            }
            ++intIdx;
        }
        return result;
    }
}

