/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import RTC.RTObject;
import RTC.ReturnCode_t;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import jp.go.aist.rtm.RTC.CorbaObjectManager;
import jp.go.aist.rtm.RTC.FactoryBase;
import jp.go.aist.rtm.RTC.FactoryInit;
import jp.go.aist.rtm.RTC.FactoryJava;
import jp.go.aist.rtm.RTC.ManagerConfig;
import jp.go.aist.rtm.RTC.ManagerServant;
import jp.go.aist.rtm.RTC.ModuleInitProc;
import jp.go.aist.rtm.RTC.ModuleManager;
import jp.go.aist.rtm.RTC.NamingManager;
import jp.go.aist.rtm.RTC.ObjectManager;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.RtcDeleteFunc;
import jp.go.aist.rtm.RTC.RtcNewFunc;
import jp.go.aist.rtm.RTC.executionContext.ECFactoryBase;
import jp.go.aist.rtm.RTC.executionContext.ECFactoryJava;
import jp.go.aist.rtm.RTC.executionContext.ExecutionContextBase;
import jp.go.aist.rtm.RTC.executionContext.ExtTrigExecutionContext;
import jp.go.aist.rtm.RTC.executionContext.OpenHRPExecutionContext;
import jp.go.aist.rtm.RTC.executionContext.PeriodicECSharedComposite;
import jp.go.aist.rtm.RTC.executionContext.PeriodicExecutionContext;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.RTCUtil;
import jp.go.aist.rtm.RTC.util.StringUtil;
import jp.go.aist.rtm.RTC.util.TimeValue;
import jp.go.aist.rtm.RTC.util.Timer;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class Manager {
    ManagerServant m_mgrservant;
    protected static Manager manager;
    protected static String manager_mutex;
    protected ORB m_pORB;
    protected POA m_pPOA;
    protected POAManager m_pPOAManager;
    protected ModuleInitProc m_initProc = null;
    protected Properties m_config = new Properties();
    protected ModuleManager m_module;
    protected NamingManager m_namingManager;
    protected CorbaObjectManager m_objManager;
    protected Timer m_timer;
    protected Logbuf rtcout;
    protected ObjectManager<String, RTObject_impl> m_compManager = new ObjectManager();
    protected ObjectManager<String, FactoryBase> m_factory = new ObjectManager();
    protected ObjectManager<String, java.lang.Object> m_ecfactory = new ObjectManager();
    protected Vector<ExecutionContextBase> m_ecs = new Vector();
    protected OrbRunner m_runner = null;
    protected Terminator m_terminator = null;
    protected int m_terminate_waiting;

    protected Manager() {
        this.rtcout = new Logbuf("Manager");
    }

    public Manager(Manager manager) {
        this.rtcout = new Logbuf("Manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager init(String[] stringArray) {
        if (manager == null) {
            String string = manager_mutex;
            synchronized (string) {
                if (manager == null) {
                    try {
                        manager = new Manager();
                        manager.initManager(stringArray);
                        manager.initLogger();
                        manager.initORB();
                        manager.initNaming();
                        manager.initFactories();
                        manager.initExecContext();
                        manager.initComposite();
                        manager.initTimer();
                        manager.initManagerServant();
                    }
                    catch (Exception exception) {
                        manager = null;
                    }
                }
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager instance() {
        if (manager == null) {
            String string = manager_mutex;
            synchronized (string) {
                if (manager == null) {
                    try {
                        manager = new Manager();
                        manager.initManager(null);
                        manager.initLogger();
                        manager.initORB();
                        manager.initNaming();
                        manager.initFactories();
                        manager.initExecContext();
                        manager.initComposite();
                        manager.initTimer();
                    }
                    catch (Exception exception) {
                        manager = null;
                    }
                }
            }
        }
        return manager;
    }

    public void terminate() {
        if (this.m_terminator != null) {
            this.m_terminator.terminate();
        }
    }

    public void shutdown() {
        this.rtcout.println(2, "Manager.shutdown()");
        this.shutdownComponents();
        this.shutdownNaming();
        this.shutdownORB();
        this.shutdownManager();
        if (this.m_runner != null) {
            try {
                this.m_runner.wait();
            }
            catch (InterruptedException interruptedException) {
                this.rtcout.println(3, "Exception: Caught InterruptedException in Manager.shutdown().");
                this.rtcout.println(3, interruptedException.getMessage());
                interruptedException.printStackTrace();
            }
        } else {
            this.join();
        }
        this.shutdownLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        this.rtcout.println(2, "Manager.join()");
        Integer n = this.m_terminate_waiting;
        synchronized (n) {
            ++this.m_terminate_waiting;
        }
        while (true) {
            n = this.m_terminate_waiting;
            synchronized (n) {
                if (this.m_terminate_waiting > 1) {
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                this.rtcout.println(3, "Exception: Caught InterruptedException in Manager.join().");
                this.rtcout.println(3, interruptedException.getMessage());
                interruptedException.printStackTrace();
            }
        }
    }

    public Properties getConfig() {
        return this.m_config;
    }

    public void setModuleInitProc(ModuleInitProc moduleInitProc) {
        this.m_initProc = moduleInitProc;
    }

    public boolean activateManager() {
        this.rtcout.println(2, "Manager.activateManager()");
        try {
            if (this.getPOAManager() == null) {
                this.rtcout.println(6, "Could not get POA manager.");
                return false;
            }
            this.getPOAManager().activate();
            this.rtcout.println(2, "POA Manager activated.");
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.activateManager().");
            this.rtcout.println(3, "POA Manager activation failed.");
            this.rtcout.println(3, exception.getMessage());
            return false;
        }
        this.bindManagerServant();
        this.preloadComponent();
        this.precreateComponent();
        if (this.m_initProc != null) {
            this.m_initProc.myModuleInit(this);
        }
        return true;
    }

    private void preloadComponent() {
        String[] stringArray = this.m_config.getProperty("manager.modules.preload").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            stringArray[i] = stringArray[i].trim();
            String[] stringArray2 = stringArray[i].split("\\.");
            try {
                this.m_module.load(stringArray[i], "registerModule");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                this.rtcout.println(6, "Module load error: " + stringArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.rtcout.println(6, "Module not found: " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "Unknown Exception");
            }
        }
    }

    private void precreateComponent() {
        String[] stringArray = this.m_config.getProperty("manager.components.precreate").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            stringArray[i] = stringArray[i].trim();
            this.createComponent(stringArray[i]);
        }
    }

    public void runManager() {
        this.runManager(false);
    }

    public void runManager(boolean bl) {
        if (bl) {
            this.rtcout.println(2, "Manager.runManager(): non-blocking mode");
            this.m_runner = new OrbRunner(this.m_pORB);
            this.m_runner.open("");
        } else {
            this.rtcout.println(2, "Manager.runManager(): blocking mode");
            this.m_pORB.run();
            this.rtcout.println(2, "Manager.runManager(): ORB was terminated");
            this.join();
        }
    }

    public String load(String string, String string2) {
        this.rtcout.println(2, "Manager.load(" + string + "," + string2 + ")");
        try {
            return this.m_module.load(string, string2);
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.load().");
            this.rtcout.println(3, exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public void unload(String string) throws Exception {
        this.rtcout.println(2, "Manager.unload(" + string + ")");
        this.m_module.unload(string);
    }

    public void unloadAll() {
        this.rtcout.println(2, "Manager.unloadAll()");
        this.m_module.unloadAll();
    }

    public Vector<Properties> getLoadedModules() {
        this.rtcout.println(2, "Manager.getLoadedModules()");
        Set<String> set = this.m_module.getLoadedModules().keySet();
        Iterator<String> iterator = set.iterator();
        Vector<Properties> vector = new Vector<Properties>();
        while (iterator.hasNext()) {
            Properties properties = new Properties(iterator.next());
            vector.add(properties);
        }
        return vector;
    }

    public Vector<Properties> getLoadableModules() {
        this.rtcout.println(2, "Manager.getLoadableModules()");
        return this.m_module.getLoadableModules();
    }

    public boolean registerFactory(Properties properties, RtcNewFunc rtcNewFunc, RtcDeleteFunc rtcDeleteFunc) {
        this.rtcout.println(2, "Manager.registerFactory(" + properties.getProperty("type_name") + ")");
        try {
            FactoryJava factoryJava = new FactoryJava(properties, rtcNewFunc, rtcDeleteFunc);
            this.m_factory.registerObject(factoryJava, new FactoryPredicate(factoryJava));
            return true;
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.registerFactory().");
            this.rtcout.println(3, exception.getMessage());
            return false;
        }
    }

    public Vector<Properties> getFactoryProfiles() {
        this.rtcout.println(2, "Manager.getFactoryProfiles()");
        Vector<FactoryBase> vector = this.m_factory.getObjects();
        Vector<Properties> vector2 = new Vector<Properties>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector2.add(vector.elementAt(i).profile());
        }
        return vector2;
    }

    public boolean registerECFactory(String string) {
        this.rtcout.println(2, "Manager.registerECFactory(" + string + ")");
        try {
            ECFactoryJava eCFactoryJava = new ECFactoryJava(string);
            if (eCFactoryJava == null) {
                return false;
            }
            if (!this.m_ecfactory.registerObject(eCFactoryJava, new ECFactoryPredicate(eCFactoryJava))) {
                eCFactoryJava = null;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.registerECFactory().");
            this.rtcout.println(3, exception.getMessage());
            return false;
        }
    }

    public Vector<String> getModulesFactories() {
        this.rtcout.println(2, "Manager.getModulesFactories()");
        Vector<String> vector = new Vector<String>();
        int n = this.m_factory.m_objects.size();
        for (int i = 0; i < n; ++i) {
            vector.add(((FactoryBase)this.m_factory.m_objects.elementAt(i)).profile().getProperty("implementation_id"));
        }
        return vector;
    }

    public void clearModulesFactories() {
        this.m_factory = new ObjectManager();
    }

    public void clearModules() {
        this.m_compManager = new ObjectManager();
    }

    public RTObject_impl createComponent(String string) {
        int n;
        this.rtcout.println(2, "Manager.createComponent(" + string + ")");
        if (string == null || string.equals("")) {
            return null;
        }
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        if (!this.procComponentArgs(string, properties, properties2)) {
            return null;
        }
        if (properties2.getProperty("exported_ports") != null && !properties2.getProperty("exported_ports").equals("")) {
            properties2.setProperty("conf.default.exported_ports", properties2.getProperty("exported_ports"));
        }
        RTObject_impl rTObject_impl = null;
        Properties properties3 = new Properties();
        int n2 = this.m_factory.m_objects.size();
        for (n = 0; n < n2; ++n) {
            FactoryBase factoryBase = (FactoryBase)this.m_factory.m_objects.elementAt(n);
            if (factoryBase == null) {
                return null;
            }
            if (!factoryBase.m_Profile.getProperty("implementation_id").equals(properties.getProperty("implementation_id"))) continue;
            properties3 = factoryBase.profile();
            Vector<String> vector = properties2.propertyNames();
            int n3 = properties2.size();
            for (int i = 0; i < n3; ++i) {
                properties3.setProperty(vector.get(i), properties2.getProperty(vector.get(i)));
            }
            String[] stringArray = new String[]{"exec_cxt.periodic.type", "exec_cxt.periodic.rate", "exec_cxt.evdriven.type", "naming.formats", "logger.enable", "logger.log_level", "naming.enable", "naming.type", "naming.formats", ""};
            n3 = 0;
            while (stringArray[n3].length() != 0) {
                System.out.println(stringArray[n3]);
                properties3.setProperty(stringArray[n3], this.m_config.getProperty(stringArray[n3]));
                ++n3;
            }
            rTObject_impl = ((FactoryBase)this.m_factory.m_objects.elementAt(n)).create(this);
            if (rTObject_impl == null) {
                this.rtcout.println(6, "RTC creation failed: " + properties.getProperty("implementaion_id"));
                return null;
            }
            this.rtcout.println(2, "RTC Created: " + properties.getProperty("implementaion_id"));
            break;
        }
        if (n == this.m_factory.m_objects.size()) {
            this.rtcout.println(6, "Factory not found: " + properties.getProperty("implementaion_id"));
            return null;
        }
        if (rTObject_impl == null) {
            return null;
        }
        this.configureComponent(rTObject_impl, properties3);
        if (rTObject_impl.initialize() != ReturnCode_t.RTC_OK) {
            this.rtcout.println(2, "RTC initialization failed: " + properties.getProperty("implementaion_id"));
            rTObject_impl.exit();
            return null;
        }
        this.rtcout.println(2, "RTC initialization succeeded: " + properties.getProperty("implementaion_id"));
        this.registerComponent(rTObject_impl);
        return rTObject_impl;
    }

    public void cleanupComponent(RTObject_impl rTObject_impl) {
        this.rtcout.println(2, "Manager.shutdownComponents()");
        this.unregisterComponent(rTObject_impl);
    }

    public boolean procComponentArgs(String string, Properties properties, Properties properties2) {
        this.rtcout.println(2, "Manager.procComponentArgs(" + string + ")");
        String[] stringArray = string.split("\\?");
        if (stringArray.length != 1 && stringArray.length != 2) {
            this.rtcout.println(6, "args devided into " + stringArray.length);
            this.rtcout.println(6, "Invalid arguments. Two or more '?' in arg : " + string);
            return false;
        }
        if (stringArray[0].indexOf(":") == -1) {
            stringArray[0] = "RTC:::".concat(stringArray[0]);
            stringArray[0] = stringArray[0].concat(":");
        }
        System.out.println("ID: " + stringArray[0]);
        String[] stringArray2 = stringArray[0].split(":", -1);
        System.out.println("id.size(): " + stringArray2.length);
        if (stringArray2.length != 5) {
            this.rtcout.println(6, "Invalid RTC id format.: " + stringArray[0]);
            return false;
        }
        String[] stringArray3 = new String[]{"RTC", "vendor", "category", "implementation_id", "version"};
        if (!stringArray2[0].trim().equals(stringArray3[0])) {
            this.rtcout.println(6, "Invalid id type: " + stringArray2[0]);
            return false;
        }
        for (int i = 1; i < 5; ++i) {
            properties.setProperty(stringArray3[i], stringArray2[i].trim());
            this.rtcout.println(2, "RTC basic propfile " + stringArray3[i] + ":" + stringArray2[i].trim());
        }
        if (stringArray.length == 2) {
            String[] stringArray4 = stringArray[1].split("&");
            int n = stringArray4.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray5 = stringArray4[i].split("=", -1);
                properties2.setProperty(stringArray5[0].trim(), stringArray5[1].trim());
                this.rtcout.println(2, "RTC property " + stringArray5[0] + ":" + stringArray5[1]);
            }
        }
        return true;
    }

    public boolean registerComponent(RTObject_impl rTObject_impl) {
        this.rtcout.println(2, "Manager.registerComponent(" + rTObject_impl.getInstanceName() + ")");
        this.m_compManager.registerObject(rTObject_impl, new InstanceName(rTObject_impl));
        String[] stringArray = rTObject_impl.getNamingNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.rtcout.println(2, "Bind name: " + stringArray[i]);
            this.m_namingManager.bindObject(stringArray[i], rTObject_impl);
        }
        return true;
    }

    public boolean unregisterComponent(RTObject_impl rTObject_impl) {
        this.rtcout.println(2, "Manager.unregisterComponent(" + rTObject_impl.getInstanceName() + ")");
        this.m_compManager.unregisterObject(new InstanceName(rTObject_impl));
        String[] stringArray = rTObject_impl.getNamingNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.rtcout.println(2, "Unbind name: " + stringArray[i]);
            this.m_namingManager.unbindObject(stringArray[i]);
        }
        return true;
    }

    public ExecutionContextBase createContext(String string) {
        this.rtcout.println(2, "Manager.createContext(" + string + ")");
        this.rtcout.println(2, "ExecutionContext type: " + this.m_config.getProperty("exec_cxt.periodic.type"));
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = new Properties();
        if (!this.procContextArgs(string, stringBuffer, properties)) {
            return null;
        }
        ECFactoryBase eCFactoryBase = (ECFactoryBase)this.m_ecfactory.find(new ECFactoryPredicate(stringBuffer.toString()));
        if (eCFactoryBase == null) {
            this.rtcout.println(6, "Factory not found: " + stringBuffer);
            return null;
        }
        ExecutionContextBase executionContextBase = eCFactoryBase.create();
        return executionContextBase;
    }

    public boolean procContextArgs(String string, StringBuffer stringBuffer, Properties properties) {
        this.rtcout.println(2, "Manager.procContextArgs(" + string + "," + stringBuffer.toString() + ")");
        String[] stringArray = string.split("\\?");
        if (stringArray.length != 1 && stringArray.length != 2) {
            this.rtcout.println(6, "Invalid arguments. Two or more '?' in arg : " + string);
            return false;
        }
        if (stringArray[0].length() == 0) {
            this.rtcout.println(6, "Empty ExecutionContext's name");
            return false;
        }
        stringBuffer.append(stringArray[0]);
        if (stringArray.length == 2) {
            String[] stringArray2 = stringArray[1].split("&");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray3 = stringArray2[i].split("=");
                properties.setProperty(stringArray3[0], stringArray3[1]);
                this.rtcout.println(2, "EC property " + stringArray3[0] + ":" + stringArray3[1]);
            }
        }
        return true;
    }

    public boolean bindExecutionContext(RTObject_impl rTObject_impl) {
        ExecutionContextBase executionContextBase;
        this.rtcout.println(2, "Manager.bindExecutionContext()");
        this.rtcout.println(2, "ExecutionContext type: " + this.m_config.getProperty("exec_cxt.periodic.type"));
        RTObject rTObject = rTObject_impl.getObjRef();
        if (RTCUtil.isDataFlowComponent(rTObject)) {
            String string = this.m_config.getProperty("exec_cxt.periodic.type");
            ECFactoryBase eCFactoryBase = (ECFactoryBase)this.m_ecfactory.find(new ECFactoryPredicate(string));
            if (eCFactoryBase == null) {
                return false;
            }
            executionContextBase = eCFactoryBase.create();
            try {
                this.m_objManager.activate(executionContextBase);
            }
            catch (ServantAlreadyActive servantAlreadyActive) {
                this.rtcout.println(3, "Exception: Caught ServantAlreadyActive Exception in Manager.bindExecutionContext() DataFlowParticipant.");
                this.rtcout.println(3, servantAlreadyActive.getMessage());
            }
            catch (WrongPolicy wrongPolicy) {
                this.rtcout.println(3, "Exception: Caught WrongPolicy Exception in Manager.bindExecutionContext() DataFlowParticipant.");
                this.rtcout.println(3, wrongPolicy.getMessage());
            }
            catch (ObjectNotActive objectNotActive) {
                this.rtcout.println(3, "Exception: Caught ObjectNotActive Exception in Manager.bindExecutionContext() DataFlowParticipant.");
                this.rtcout.println(3, objectNotActive.getMessage());
            }
            String string2 = this.m_config.getProperty("exec_cxt.periodic.rate");
            executionContextBase.set_rate(Double.valueOf(string2));
        } else {
            String string = this.m_config.getProperty("exec_cxt.evdriven.type");
            executionContextBase = ((ECFactoryBase)this.m_ecfactory.find(new ECFactoryPredicate(string))).create();
            try {
                this.m_objManager.activate(executionContextBase);
            }
            catch (ServantAlreadyActive servantAlreadyActive) {
                this.rtcout.println(3, "Exception: Caught ServantAlreadyActive Exception in Manager.bindExecutionContext() FsmParticipant.");
                this.rtcout.println(3, servantAlreadyActive.getMessage());
            }
            catch (WrongPolicy wrongPolicy) {
                this.rtcout.println(3, "Exception: Caught WrongPolicy Exception in Manager.bindExecutionContext() FsmParticipant.");
                this.rtcout.println(3, wrongPolicy.getMessage());
            }
            catch (ObjectNotActive objectNotActive) {
                this.rtcout.println(3, "Exception: Caught ObjectNotActive Exception in Manager.bindExecutionContext() FsmParticipant.");
                this.rtcout.println(3, objectNotActive.getMessage());
            }
        }
        executionContextBase.add_component(rTObject);
        executionContextBase.start();
        this.m_ecs.add(executionContextBase);
        return true;
    }

    public void deleteComponent(String string) {
        this.rtcout.println(2, "Manager.deleteComponent(" + string + ")");
        RTObject_impl rTObject_impl = null;
        rTObject_impl = this.m_compManager.find(new InstanceName(string));
        if (rTObject_impl == null) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("vendor", rTObject_impl.getProperties().getProperty("vendor"));
        properties.setProperty("category", rTObject_impl.getProperties().getProperty("category"));
        properties.setProperty("implementation_id", rTObject_impl.getProperties().getProperty("implementation_id"));
        properties.setProperty("version", rTObject_impl.getProperties().getProperty("version"));
        FactoryBase factoryBase = this.m_factory.find(new FactoryPredicate(string));
        ReturnCode_t returnCode_t = rTObject_impl.exit();
        if (factoryBase == null) {
            return;
        }
        factoryBase.destroy(rTObject_impl);
    }

    public RTObject_impl getComponent(String string) {
        this.rtcout.println(2, "Manager.getComponent(" + string + ")");
        return this.m_compManager.find(new InstanceName(string));
    }

    public Vector<RTObject_impl> getComponents() {
        this.rtcout.println(2, "Manager.getComponents()");
        return this.m_compManager.getObjects();
    }

    public ORB getORB() {
        this.rtcout.println(2, "Manager.getORB()");
        return this.m_pORB;
    }

    public POA getPOA() {
        this.rtcout.println(2, "Manager.getPOA()");
        return this.m_pPOA;
    }

    public POAManager getPOAManager() {
        this.rtcout.println(2, "Manager.getPOAManager()");
        return this.m_pPOAManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initManager(String[] stringArray) throws Exception {
        ManagerConfig managerConfig = new ManagerConfig(stringArray);
        if (this.m_config == null) {
            this.m_config = new Properties();
        }
        managerConfig.configure(this.m_config);
        this.m_config.setProperty("logger.file_name", this.formatString(this.m_config.getProperty("logger.file_name"), this.m_config));
        this.m_module = new ModuleManager(this.m_config);
        this.m_terminator = new Terminator(this);
        java.lang.Object object = this.m_terminator;
        synchronized (object) {
            this.m_terminate_waiting = 0;
        }
        if (StringUtil.toBool(this.m_config.getProperty("timer.enable"), "YES", "NO", true)) {
            object = new TimeValue(0L, 100L);
            String string = this.m_config.getProperty("timer.tick");
            if (string != null && !string.equals("")) {
                ((TimeValue)object).convert(Double.valueOf(string));
                this.m_timer = new Timer((TimeValue)object);
                this.m_timer.start();
            }
        }
    }

    protected void shutdownManager() {
        this.rtcout.println(2, "Manager.shutdownManager()");
    }

    protected boolean initLogger() {
        this.rtcout.setLevel("SILENT");
        if (StringUtil.toBool(this.m_config.getProperty("logger.enable"), "YES", "NO", true)) {
            this.rtcout.setEnabled();
            String[] stringArray = this.m_config.getProperty("logger.file_name").split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (string == null) continue;
                if (string.equals("STDOUT") || string.equals("stdout")) {
                    this.rtcout.addStream(new ConsoleHandler());
                    continue;
                }
                try {
                    this.rtcout.addStream(new FileHandler(string));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.rtcout.setDateFormat(this.m_config.getProperty("logger.date_format"));
            this.rtcout.setLevel(this.m_config.getProperty("logger.log_level"));
            this.rtcout.setLogLock(StringUtil.toBool(this.m_config.getProperty("logger.stream_lock"), "enable", "disable", false));
            this.rtcout.println(4, this.m_config.getProperty("openrtm.version"));
            this.rtcout.println(4, "Copyright (C) 2003-2008");
            this.rtcout.println(4, "  Noriaki Ando");
            this.rtcout.println(4, "  Task-intelligence Research Group,");
            this.rtcout.println(4, "  Intelligent Systems Research Institute, AIST");
            this.rtcout.println(4, "Manager starting.");
            this.rtcout.println(4, "Starting local logging.");
        } else {
            this.rtcout.setDisabled();
            this.m_config.setProperty("logger.log_level", "SILENT");
        }
        return true;
    }

    protected void shutdownLogger() {
        this.rtcout.println(2, "Manager.shutdownLogger()");
    }

    protected boolean initORB() {
        this.rtcout.println(2, "Manager.initORB()");
        try {
            String[] stringArray = this.createORBOptions().split(" ");
            java.util.Properties properties = this.createORBProperties();
            this.m_pORB = ORBUtil.getOrb(stringArray, properties);
            Object object = this.m_pORB.resolve_initial_references("RootPOA");
            this.m_pPOA = POAHelper.narrow((Object)object);
            if (this.m_pPOA == null) {
                this.rtcout.println(6, "Could not resolve RootPOA.");
                return false;
            }
            this.m_pPOAManager = this.m_pPOA.the_POAManager();
            this.m_objManager = new CorbaObjectManager(this.m_pORB, this.m_pPOA);
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.initORB().");
            this.rtcout.println(3, exception.getMessage());
            return false;
        }
        return true;
    }

    protected String createORBOptions() {
        String string = this.m_config.getProperty("corba.args");
        return string;
    }

    protected java.util.Properties createORBProperties() {
        String string = this.m_config.getProperty("corba.endpoint");
        if (string == null || string.indexOf(":") < 0) {
            return null;
        }
        java.util.Properties properties = new java.util.Properties();
        String[] stringArray = string.split(":");
        if (!stringArray[0].equals("")) {
            properties.put("com.sun.CORBA.ORBServerHost", stringArray[0]);
        }
        if (stringArray.length > 1 && !stringArray[1].equals("")) {
            properties.put("com.sun.CORBA.ORBServerPort", stringArray[1]);
        }
        return properties;
    }

    protected void shutdownORB() {
        this.rtcout.println(2, "Manager.shutdownORB()");
        try {
            while (this.m_pORB.work_pending()) {
                this.rtcout.println(0, "Pending work still exists.");
                if (!this.m_pORB.work_pending()) continue;
                this.m_pORB.perform_work();
            }
        }
        catch (Exception exception) {
            this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.shutdownORB().");
            this.rtcout.println(3, exception.getMessage());
        }
        this.rtcout.println(3, "No pending works of ORB. Shutting down POA and ORB.");
        if (this.m_pPOA != null) {
            try {
                if (this.m_pPOAManager != null) {
                    this.m_pPOAManager.deactivate(false, true);
                    this.rtcout.println(3, "POA Manager was deactivated.");
                }
                this.m_pPOA = null;
            }
            catch (SystemException systemException) {
                this.rtcout.println(6, "Caught SystemException during root POA destruction");
            }
            catch (Exception exception) {
                this.rtcout.println(6, "Caught unknown exception during POA destruction.");
            }
        }
        if (this.m_pORB != null) {
            try {
                this.m_pORB.shutdown(true);
                this.rtcout.println(3, "ORB was shutdown.");
                this.rtcout.println(3, "ORB was destroied.");
                this.m_pORB.destroy();
                this.m_pORB = null;
                ORBUtil.clearOrb();
            }
            catch (SystemException systemException) {
                this.rtcout.println(6, "Caught SystemException during ORB shutdown");
            }
            catch (Exception exception) {
                this.rtcout.println(6, "Caught unknown exception during ORB shutdown.");
            }
        }
    }

    protected boolean initNaming() {
        java.lang.Object object;
        this.rtcout.println(2, "Manager.initNaming()");
        this.m_namingManager = new NamingManager(this);
        if (!StringUtil.toBool(this.m_config.getProperty("naming.enable"), "YES", "NO", true)) {
            return true;
        }
        String[] stringArray = this.m_config.getProperty("naming.type").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.m_config.getProperty(stringArray[i] + ".nameservers").split(",");
            for (int j = 0; j < ((String[])object).length; ++j) {
                this.rtcout.println(2, "Register Naming Server: " + stringArray[i] + " " + (String)object[j]);
                String[] stringArray2 = ((String)object[j]).split(":");
                if (stringArray2.length == 1 && !stringArray2[0].equals("")) {
                    java.lang.Object object2 = object;
                    int n = j;
                    object2[n] = (String)object2[n] + ":2809";
                }
                if (((String)object[j]).equals("")) continue;
                this.m_namingManager.registerNameServer(stringArray[i], (String)object[j]);
            }
        }
        if (StringUtil.toBool(this.m_config.getProperty("naming.update.enable"), "YES", "NO", true)) {
            TimeValue timeValue = new TimeValue(10L, 0L);
            object = this.m_config.getProperty("naming.update.interval");
            if (object != null && !((String)object).equals("")) {
                timeValue.convert(Double.valueOf((String)object));
            }
            if (this.m_timer != null) {
                this.m_timer.registerListenerObj(this.m_namingManager, timeValue);
            }
        }
        return true;
    }

    protected void shutdownNaming() {
        this.rtcout.println(2, "Manager.shutdownNaming()");
        this.m_namingManager.unbindAll();
    }

    protected void shutdownComponents() {
        int n;
        this.rtcout.println(2, "Manager.shutdownComponents()");
        Vector<RTObject_impl> vector = this.m_namingManager.getObjects();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            try {
                vector.elementAt(n).exit();
                Properties properties = new Properties(vector.elementAt(n).getInstanceName());
                properties.merge(vector.elementAt(n).getProperties());
                this.rtcout.level(0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n2 = this.m_ecs.size();
        for (n = 0; n < n2; ++n) {
            try {
                this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_ecs.elementAt(n)));
                continue;
            }
            catch (Exception exception) {
                this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.shutdownComponents().");
                this.rtcout.println(3, exception.getMessage());
            }
        }
    }

    protected void configureComponent(RTObject_impl rTObject_impl, Properties properties) {
        java.lang.Object object;
        String string = rTObject_impl.getCategory();
        String string2 = rTObject_impl.getTypeName();
        String string3 = rTObject_impl.getInstanceName();
        String string4 = string + "." + string2 + ".config_file";
        String string5 = string + "." + string3 + ".config_file";
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        if (this.m_config.getProperty(string5) != null && this.m_config.getProperty(string5).length() != 0) {
            try {
                object = new BufferedReader(new FileReader(this.m_config.getProperty(string5)));
                properties3.load((BufferedReader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.rtcout.println(3, "Exception: Caught FileNotFoundException in Manager.configureComponent() name_conf.");
                this.rtcout.println(3, fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                this.rtcout.println(3, "Exception: Caught unknown in Manager.configureComponent() name_conf.");
                this.rtcout.println(3, exception.getMessage());
            }
        }
        if (this.m_config.getProperty(string4) != null && this.m_config.getProperty(string4).length() != 0) {
            try {
                object = new BufferedReader(new FileReader(this.m_config.getProperty(string4)));
                properties2.load((BufferedReader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.rtcout.println(3, "Exception: Caught FileNotFoundException in Manager.configureComponent() type_conf.");
                this.rtcout.println(3, fileNotFoundException.getMessage());
                fileNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.configureComponent() type_conf.");
                this.rtcout.println(3, exception.getMessage());
                exception.printStackTrace();
            }
        }
        rTObject_impl.getProperties().merge(properties);
        properties2.merge(properties3);
        rTObject_impl.getProperties().merge(properties2);
        object = new StringBuffer();
        Properties properties4 = rTObject_impl.getProperties();
        ((StringBuffer)object).append(this.m_config.getProperty("naming.formats"));
        ((StringBuffer)object).append(", " + properties4.getProperty("naming.formats"));
        String string6 = StringUtil.flatten(StringUtil.unique_sv(((StringBuffer)object).toString().split(",")));
        rTObject_impl.getProperties().setProperty("naming.formats", ((StringBuffer)object).toString());
        String string7 = this.formatString(string6, rTObject_impl.getProperties());
        rTObject_impl.getProperties().setProperty("naming.names", string7);
    }

    protected boolean initExecContext() {
        this.rtcout.println(2, "Manager.initExecContext()");
        PeriodicExecutionContext.PeriodicExecutionContextInit(this);
        ExtTrigExecutionContext.ExtTrigExecutionContextInit(this);
        OpenHRPExecutionContext.OpenHRPExecutionContextInit(this);
        return true;
    }

    protected boolean initComposite() {
        this.rtcout.println(2, "Manager.initComposite()");
        PeriodicECSharedComposite.PeriodicECSharedCompositeInit(this);
        return true;
    }

    protected boolean initFactories() {
        this.rtcout.println(2, "Manager.initFactories()");
        FactoryInit.init();
        return true;
    }

    protected boolean initTimer() {
        return true;
    }

    protected boolean initManagerServant() {
        this.m_mgrservant = new ManagerServant();
        return true;
    }

    protected boolean bindManagerServant() {
        java.lang.Object object;
        if (this.m_mgrservant == null) {
            this.rtcout.println(6, "ManagerServant is not created.");
            return false;
        }
        Properties properties = this.m_config.getNode("manager");
        String[] stringArray = properties.getProperty("naming_formats").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.formatString(stringArray[i], properties);
            this.m_namingManager.bindObject((String)object, this.m_mgrservant);
        }
        File file = new File(this.m_config.getProperty("manager.refstring_path"));
        if (!file.exists()) {
            try {
                object = new FileWriter(file);
                ((Writer)object).write(this.m_pORB.object_to_string((Object)this.m_mgrservant.getObjRef()));
                ((OutputStreamWriter)object).close();
            }
            catch (IOException iOException) {}
        } else {
            try {
                String string;
                object = new String();
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string = bufferedReader.readLine()) != null) {
                    object = (String)object + string;
                }
                bufferedReader.close();
                fileReader.close();
                System.out.println((String)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean mergeProperty(Properties properties, String string) {
        if (string == null) {
            this.rtcout.println(6, "Invalid configuration file name.");
            return false;
        }
        if (string.length() != 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                properties.load(bufferedReader);
                bufferedReader.close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.rtcout.println(3, "Exception: Caught FileNotFoundException in Manager.mergeProperty().");
                this.rtcout.println(3, fileNotFoundException.getMessage());
                fileNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                this.rtcout.println(3, "Exception: Caught unknown Exception in Manager.mergeProperty().");
                this.rtcout.println(3, exception.getMessage());
                exception.printStackTrace();
            }
        }
        return false;
    }

    protected String formatString(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (++n % 2 != 0) continue;
                stringBuffer.append(c);
                continue;
            }
            if (c == '$') {
                n = 0;
                if (string.charAt(++i) == '{' || string.charAt(i) == '(') {
                    ++i;
                    String string2 = "";
                    while (i < string.length() && string.charAt(i) != '}' && string.charAt(i) != ')') {
                        string2 = string2 + string.charAt(i);
                        ++i;
                    }
                    String string3 = System.getenv(string2);
                    if (string3 == null) continue;
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (n > 0 && n % 2 != 0) {
                n = 0;
                if (c == 'n') {
                    stringBuffer.append(properties.getProperty("instance_name"));
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append(properties.getProperty("type_name"));
                    continue;
                }
                if (c == 'm') {
                    stringBuffer.append(properties.getProperty("type_name"));
                    continue;
                }
                if (c == 'v') {
                    stringBuffer.append(properties.getProperty("version"));
                    continue;
                }
                if (c == 'V') {
                    stringBuffer.append(properties.getProperty("vendor"));
                    continue;
                }
                if (c == 'c') {
                    stringBuffer.append(properties.getProperty("category"));
                    continue;
                }
                if (c == 'h') {
                    stringBuffer.append(this.m_config.getProperty("manager.os.hostname"));
                    continue;
                }
                if (c == 'M') {
                    stringBuffer.append(this.m_config.getProperty("manager.name"));
                    continue;
                }
                if (c == 'p') {
                    stringBuffer.append(this.m_config.getProperty("manager.pid"));
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            n = 0;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static {
        manager_mutex = new String();
    }

    protected class Terminator
    implements Runnable {
        public Manager m_manager;

        public Terminator(Manager manager2) {
            this.m_manager = manager2;
        }

        public void terminate() {
            this.open("");
        }

        public int open(String string) {
            Thread thread = new Thread(this);
            thread.start();
            return 0;
        }

        public int svc() {
            Manager.instance().shutdown();
            return 0;
        }

        @Override
        public void run() {
            this.svc();
        }
    }

    protected class OrbRunner
    implements Runnable {
        private ORB m_pORB;

        public OrbRunner(ORB oRB) {
            this.m_pORB = oRB;
        }

        public int open(String string) {
            Thread thread = new Thread(this);
            thread.start();
            return 0;
        }

        public int svc() {
            this.m_pORB.run();
            return 0;
        }

        public int close(long l) {
            return 0;
        }

        @Override
        public void run() {
            this.svc();
        }
    }

    class ECFactoryPredicate
    implements equalFunctor {
        public String m_name;

        public ECFactoryPredicate(String string) {
            this.m_name = string;
        }

        public ECFactoryPredicate(ECFactoryBase eCFactoryBase) {
            this.m_name = eCFactoryBase.name();
        }

        @Override
        public boolean equalof(java.lang.Object object) {
            return this.m_name.equals(((ECFactoryBase)object).name());
        }
    }

    protected class FactoryPredicate
    implements equalFunctor {
        public String m_name;

        public FactoryPredicate(String string) {
            this.m_name = string;
        }

        public FactoryPredicate(FactoryBase factoryBase) {
            this.m_name = factoryBase.profile().getProperty("implementation_id");
        }

        @Override
        public boolean equalof(java.lang.Object object) {
            return this.m_name.equals(((FactoryBase)object).profile().getProperty("implementation_id"));
        }
    }

    protected class InstanceName
    implements equalFunctor {
        public String m_name;

        public InstanceName(RTObject_impl rTObject_impl) {
            this.m_name = rTObject_impl.getInstanceName();
        }

        public InstanceName(String string) {
            this.m_name = string;
        }

        @Override
        public boolean equalof(java.lang.Object object) {
            return this.m_name.equals(((RTObject_impl)object).getInstanceName());
        }
    }
}

