#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file BufferBase.py
# @brief Buffer abstract class
# @date $Date: 2007/09/12 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2006-2008
#     Noriaki Ando
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.

import OpenRTM_aist

##
# @if jp
# @class BufferBase
# @brief BufferBase ݥ饹
# 
# ΥХåեΤݥ󥿡ե饹
# ݥХåե饹ϡʲδؿμ󶡤ʤФʤʤ
# 
# public󥿡եȤưʲΤΤ󶡤롣
#  - write(): Хåե˽񤭹
#  - read(): Хåեɤ߽Ф
#  - length(): ХåեĹ֤
#  - isFull(): ХåեդǤ
#  - isEmpty(): ХåեǤ
# 
# protected󥿡եȤưʲΤΤ󶡤롣
#  - put(): Хåե˥ǡ񤭹
#  - get(): Хåեǡɤ߽Ф
# 
# @since 0.4.0
# 
# @else
# 
# @class BufferBase
# @brief BufferBase abstract class
# 
# This is the abstract interface class for various Buffer.
# 
# @since 0.4.0
# 
# @endif
class BufferBase(OpenRTM_aist.BufferStatus):
  """
  """


  ##
  # @if jp
  # @brief Хåե
  #
  # Properties Ϳץѥƥˤꡢ
  # Хåե롣
  # ѤǤ륪ץỌ̇̄ϰʲ̤
  #
  # - buffer.length:
  #     ХåեĹʳοͤꤵƤ̵뤵롣
  #     Ǥ˥ХåեѾ֤Ǥ⡢Ĺꤵ줿Τ٤Ƥ
  #     ݥ󥿤롣
  #
  # - buffer.write.full_policy:
  #     񤭤뤫ɤΥݥꥷ
  #     overwrite (), do_nothing (⤷ʤ), block (֥å)
  #     block ꤷ硢 timeout ͤꤹСָ
  #     񤭹ԲǽǤХॢȤ롣
  #     ǥեȤ  overwrite ()
  #
  # - buffer.write.timeout:
  #     ॢȻ֤ [sec] ǻꤹ롣ǥեȤ 1.0 [sec]
  #     1 sec -> 1.0, 1 ms -> 0.001, ॢȤʤ -> 0.0
  #
  # - buffer.read.empty_policy:
  #     ХåեΤȤɤ߽Фݥꥷ
  #     readback (Ǹ), do_nothing (⤷ʤ), block (֥å)
  #     block ꤷ硢 timeout ͤꤹСָ
  #     ɤ߽ФԲǽǤХॢȤ롣
  #     ǥեȤ readback (Ǹ)
  #
  # - buffer.read.timeout:
  #     ॢȻ [sec] ǻꤹ롣ǥեȤ 1.0 [sec]
  #     1sec -> 1.0, 1ms -> 0.001, ॢȤʤ -> 0.0
  #
  # @else
  #
  # @endif
  def init(self, prop):
    pass


  ##
  # @if jp
  # 
  # @brief ХåեĹ(֥饹)
  # 
  # ХåեĹ<BR>
  # ֥饹Ǥμ
  # 
  # @param self 
  # 
  # @return ХåեĹ
  # 
  # @else
  # 
  # @brief Get the buffer length
  # 
  # @return buffer length
  # 
  # @endif
  def length(self):
    pass


  ##
  # @if jp
  #
  # @brief Хåեξ֤ꥻåȤ
  # 
  # Хåեɤ߽Фݥ󥿤Ƚ񤭹ߥݥ󥿤ΰ֤ꥻåȤ롣
  # 
  # @return BUFFER_OK: ｪλ
  #         NOT_SUPPORTED: ХåեĹѹԲ
  #         BUFFER_ERROR: ۾ｪλ
  # 
  # @else
  #
  # @brief Get the buffer length
  #
  # Pure virtual function to get the buffer length.
  #
  # @return buffer length
  # 
  # @endif
  #
  def reset(self):
    pass


  ##
  # @if jp
  #
  # @brief ХåեθߤνǤΥݥ
  # 
  # ХåեθߤνǤΥݥ󥿤ޤϡnΥݥ󥿤֤
  # 
  # @param  n ߥݥ + n ΰ֤Υݥ 
  # @return ֤߰Υݥ
  # 
  # @else
  #
  # @brief Get the buffer length
  #
  # Pure virtual function to get the buffer length.
  #
  # @return buffer length
  # 
  # @endif
  def wptr(self, n=0):
    pass


  ##
  # @if jp
  #
  # @brief ߥݥ󥿤ʤ
  # 
  # ߤν񤭹֤߰Υݥ󥿤 n Ŀʤ롣
  # 
  # @param  n ߥݥ + n ΰ֤Υݥ 
  # @return BUFFER_OK: ｪλ
  #         BUFFER_ERROR: ۾ｪλ
  # 
  # @else
  #
  # @brief Get the buffer length
  #
  # Pure virtual function to get the buffer length.
  #
  # @return buffer length
  # 
  # @endif
  def advanceWptr(self, n = 1):
    pass


  ##
  # @if jp
  # 
  # @brief Хåե˥ǡǼ(֥饹)
  # 
  # ХåեؤΥǡǼѴؿ<BR>
  # ֥饹Ǥμ
  # 
  # @param self 
  # @param data оݥǡ
  # 
  # @else
  # 
  # @brief Write data into the buffer
  # 
  # @endif
  def put(self, data):
    pass


  ##
  # @if jp
  # 
  # @brief Хåե˥ǡ񤭹(֥饹)
  # 
  # Хåե˥ǡ񤭹<BR>
  # ֥饹Ǥμ
  # 
  # @param self 
  # @param value 񤭹оݥǡ
  # 
  # @return ǡ񤭹߷(true:񤭹false:񤭹߼)
  # 
  # @else
  # 
  # @brief Write data into the buffer
  # 
  # @endif
  def write(self, value, sec=-1, nsec=-1):
    pass


  ##
  # @if jp
  #
  # @brief Хåե˽߲ǽǿ
  # 
  # Хåե˽߲ǽǿ֤
  # 
  # @return 񤭹߲ǽǿ
  #
  # @return BUFFER_OK: ｪλ
  #         BUFFER_ERROR: ۾ｪλ
  # 
  # @else
  #
  # @brief Write data into the buffer
  #
  # Pure virtual function to write data into the buffer.
  #
  # @param value Target data to write.
  #
  # @return Result of having written in data (true:Successful, false:Failed)
  #
  # @endif
  def writable(self):
    pass


  ##
  # @if jp
  #
  # @brief Хåեfullå
  # 
  # Хåեfullåѽ貾۴ؿ
  #
  # @return fullå(true:Хåեfullfalse:Хåե)
  # 
  # @else
  #
  # @brief Check on whether the buffer is full.
  #
  # Pure virtual function to check on whether the buffer is full.
  #
  # @return True if the buffer is full, else false.
  #
  # @endif
  def full(self):
    pass


  ##
  # @if jp
  #
  # @brief Хåեθߤɤ߽ФǤΥݥ
  # 
  # Хåեθߤɤ߽ФǤΥݥ󥿤ޤϡnΥݥ󥿤֤
  # 
  # @param  n ɤ߽Фݥ + n ΰ֤Υݥ 
  # @return ɤ߽Ф֤Υݥ
  # 
  # @else
  #
  # @brief Get the buffer length
  #
  # Pure virtual function to get the buffer length.
  #
  # @return buffer length
  # 
  # @endif
  def rptr(self, n = 0):
    pass

  ##
  # @if jp
  #
  # @brief ɤ߽Фݥ󥿤ʤ
  # 
  # ߤɤ߽Ф֤Υݥ󥿤 n Ŀʤ롣
  # 
  # @param  n ɤ߽Фݥ + n ΰ֤Υݥ 
  # @return BUFFER_OK: ｪλ
  #         BUFFER_ERROR: ۾ｪλ
  # 
  # @else
  #
  # @brief Get the buffer length
  #
  # Pure virtual function to get the buffer length.
  #
  # @return buffer length
  # 
  # @endif
  def advanceRptr(self, n = 1):
    pass


  ##
  # @if jp
  # 
  # @brief Хåեǡ(֥饹)
  # 
  # Хåե˳Ǽ줿ǡѴؿ<BR>
  # ֥饹Ǥμ
  # 
  # @param self 
  # 
  # @return ǡ
  # 
  # @else
  # 
  # @brief Get data from the buffer
  # 
  # @endif
  def get(self):
    pass


  ##
  # @if jp
  # 
  # @brief Хåեǡɤ߽Ф(֥饹)
  # 
  # Хåեǡɤ߽Ф<BR>
  # ֥饹Ǥμ
  # 
  # @param self 
  # @param value ɤ߽Фǡ
  # 
  # @return ǡɤ߽Ф(true:ɤ߽Фfalse:ɤ߽Ф)
  # 
  # @else
  # 
  # @brief Read data from the buffer
  # 
  # @endif
  def read(self, value, sec = -1, nsec = -1):
    pass


  ##
  # @if jp
  #
  # @brief Хåեɤ߽Фǽǿ
  # 
  # Хåեɤ߽Фǽǿ֤
  # 
  # @return ɤ߽Фǽǿ
  #
  # @return BUFFER_OK: ｪλ
  #         BUFFER_ERROR: ۾ｪλ
  # 
  # @else
  #
  # @brief Write data into the buffer
  #
  # Pure virtual function to write data into the buffer.
  #
  # @param value Target data to write.
  #
  # @return Result of having written in data (true:Successful, false:Failed)
  #
  # @endif
  def readable(self):
    pass


  ##
  # @if jp
  #
  # @brief Хåեemptyå
  # 
  # Хåեemptyåѽ貾۴ؿ
  #
  # @return emptyå(true:Хåեemptyfalse:Хåեǡ)
  # 
  # @else
  #
  # @brief Check on whether the buffer is empty.
  #
  # Pure virtual function to check on whether the buffer is empty.
  #
  # @return True if the buffer is empty, else false.
  #
  # @endif
  def empty(self):
    pass



##
# @if jp
# @class NullBuffer
# @brief ߡХåե饹
# 
# ХåեĹΥߡХåե饹
# 
# @param DataType Хåե˳Ǽǡ
# 
# @since 0.4.0
# 
# @else
# 
# @endif
class NullBuffer(BufferBase):
  """
  """



  ##
  # @if jp
  # 
  # @brief 󥹥ȥ饯
  # 
  # 󥹥ȥ饯
  # ХåեĹ()ǽ롣
  # 
  # @param self 
  # @param size ХåեĹ(ǥե:None̵)
  # 
  # @else
  # 
  # @endif
  def __init__(self, size=None):
    self._length = 1
    self._data = None
    self._is_new = False
    self._inited = False


  ##
  # @if jp
  # 
  # @brief ХåեĹ()
  # 
  # ХåեĹ롣(ˣ֤)
  # 
  # @param self 
  # 
  # @return ХåեĹ()
  # 
  # @else
  # 
  # @brief Get the buffer length
  # 
  # @return buffer length(always 1)
  # 
  # @endif
  def length(self):
    return 1


  ##
  # @if jp
  # 
  # @brief Хåե˥ǡ񤭹
  # 
  # Ϳ줿ǡХåե˽񤭹ࡣ
  # 
  # @param self 
  # @param value 񤭹оݥǡ
  # 
  # @return ǡ񤭹߷(true:񤭹false:񤭹߼)
  # 
  # @else
  # 
  # @brief Write data into the buffer
  # 
  # @endif
  def write(self, value, sec=-1, nsec=-1):
    self.put(value)
    return True


  ##
  # @if jp
  # 
  # @brief Хåեǡɤ߽Ф
  # 
  # Хåե˳Ǽ줿ǡɤ߽Ф
  # 
  # @param self 
  # @param value ɤ߽Фǡ
  # 
  # @return ǡɤ߽Ф(true:ɤ߽Фfalse:ɤ߽Ф)
  # 
  # @else
  # 
  # @brief Read data from the buffer
  # 
  # @endif
  def read(self, value):
    if not self._inited:
      return False
    value[0] = self.get()
    return True


  ##
  # @if jp
  # 
  # @brief Хåեfullå
  # 
  # Хåեfullå롣(false֤)
  # 
  # @param self 
  # 
  # @return fullå(false)
  # 
  # @else
  # 
  # @brief Always false.
  # 
  # @endif
  def isFull(self):
    return False


  ##
  # @if jp
  # 
  # @brief Хåեemptyå
  # 
  # Хåեemptyå롣(false֤)
  # ׳ǧ
  # 
  # @param self 
  # 
  # @return emptyå(false)
  # 
  # @else
  # 
  # @brief Always false.
  # 
  # @endif
  def isEmpty(self):
    return False


  ##
  # @if jp
  # 
  # @brief ǿǡǧ
  # 
  # ߤΥХåե֤˳ǼƤǡǿǡǧ롣
  # 
  # @param self 
  # 
  # @return ǿǡǧ
  #            ( true:ǿǡǡϤޤɤ߽ФƤʤ
  #             false:Υǡǡϴɤ߽ФƤ)
  # 
  # @else
  # 
  # @endif
  def isNew(self):
    return self._is_new


  ##
  # @if jp
  # 
  # @brief Хåե˥ǡǼ
  # 
  # Ϳ줿ǡХåե˳Ǽ롣
  # 
  # @param self 
  # @param data оݥǡ
  # 
  # @else
  # 
  # @brief Write data into the buffer
  # 
  # @endif
  def put(self, data):
    self._data = data
    self._is_new = True
    self._inited = True


  ##
  # @if jp
  # 
  # @brief Хåեǡ
  # 
  # Хåե˳Ǽ줿ǡ롣
  # 
  # @param self 
  # 
  # @return ǡ
  # 
  # @else
  # 
  # @brief Get data from the buffer
  # 
  # @endif
  def get(self):
    self._is_new = False
    return self._data


  ##
  # @if jp
  # 
  # @brief ˽񤭹ХåեؤλȤ
  # 
  # 񤭹ߥХåեؤλȤ롣
  # ܥХåեǤϥХåեĹϸǣǤ뤿ᡤ
  # Ʊ֤ؤλȤ֤
  # 
  # @param self 
  # 
  # @return ν񤭹оݥХåեؤλ()
  # 
  # @else
  # 
  # @brief Get the buffer's reference to be written the next
  # 
  # @endif
  def getRef(self):
    return self._data
