#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file Factory.py
# @brief RTComponent factory class
# @date $Date: 2006/11/06 01:28:36 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2003-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.

import OpenRTM_aist


##
# @if jp
#
# @brief brief RTݡͥ˴Ѵؿ
#
# RTݡͥȤΥ󥹥󥹤˴뤿δؿ
# ˤƻꤷRTݡͥȤΥ󥹥󥹤򡢽λƤӽФ
# ˴롣
#
# @param rtc ˴оRTݡͥȤΥ󥹥
#
# @else
#
# @endif
def Delete(rtc):
  del rtc



##
# @if jp
#
# @class FactoryBase
# @brief FactoryBase 쥯饹
# 
# RTݡͥѥեȥδ쥯饹
# ºݤγƼեȥꥯ饹ϡܥ饹ѾǼ롣
# ºݤ϶ݥ֥饹ˤƼɬפ롣
#
# @since 0.2.0
#
# @else
#
# @class FactoryBase
# @brief FactoryBase base class
#
# RTComponent factory base class.
#
# @since 0.2.0
#
# @endif
class FactoryBase:
  """
  """

  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param profile ݡͥȤΥץե
  #
  # @else
  #
  # @brief Constructor.
  #
  # Constructor.
  #
  # @param profile component profile
  #
  # @endif
  def __init__(self, profile):
    ## self._Profile Component profile
    self._Profile = profile
    ## self._Number Number of current component instances.
    self._Number = -1
    
    pass


  ##
  # @if jp
  #
  # @brief ݡͥȤ(֥饹)
  #
  # RTComponent Υ󥹥󥹤뤿δؿ<BR>
  # ºݤνϡƶݥ饹ˤƵҤ롣
  #
  # @param self
  # @param mgr ޥ͡㥪֥
  #
  # @return ݡͥ
  #
  # @else
  #
  # @brief Create component
  #
  # @param mgr pointer to RtcManager
  #
  # @endif
  def create(self, mgr):
    pass


  ##
  # @if jp
  #
  # @brief ݡͥȤ˴(֥饹)
  #
  # RTComponent Υ󥹥󥹤˴뤿δؿ<BR>
  # ºݤνϡƶݥ饹ˤƵҤ롣
  #
  # @param self
  # @param comp ˴о RTݡͥ
  #
  # @else
  #
  # @brief Destroy component
  #
  # @param comp pointer to RtcBase
  #
  # @endif
  def destroy(self, comp):
    pass


  ##
  # @if jp
  #
  # @brief ݡͥȥץեμ
  #
  # ݡͥȤΥץե
  #
  # @param self
  #
  # @return ݡͥȤΥץե
  #
  # @else
  #
  # @brief Get component profile
  #
  # Get component profile.
  #
  # @endif
  def profile(self):
    return self._Profile


  ##
  # @if jp
  #
  # @brief ߤΥ󥹥󥹿μ
  #
  # ݡͥȤθߤΥ󥹥󥹿롣
  #
  # @param self
  #
  # @return ݡͥȤΥ󥹥󥹿
  #
  # @else
  #
  # @brief Get number of component instances
  #
  # Get number of current component instances.
  #
  # @endif
  def number(self):
    return self._Number




##
# @if jp
# @class FactoryPython
# @brief FactoryPython 饹
# 
# Pythonѥݡͥȥեȥꥯ饹
#
# @since 0.4.1
#
#
# @else
#
# @class FactoryPython
# @brief FactoryPython class
#
# RTComponent factory class for Python.
#
# @endif
class FactoryPython(FactoryBase):
  """
  """

  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  # оݥݡͥȤΥץե롢ݡͥѴؿ
  # ݡͥ˴Ѵؿݡͥ̿̾ݥꥷ˼ꡢ
  # Python Ǽ줿ݡͥȤΥեȥꥯ饹롣
  #
  # @param self
  # @param profile ݡͥȤΥץե
  # @param new_func ݡͥѴؿ
  # @param delete_func ݡͥ˴Ѵؿ
  # @param policy ݡͥ̿̾ݥꥷ(ǥե:None)
  #
  # @else
  #
  # @brief Constructor.
  #
  # Constructor.
  # Create component factory class with three arguments:
  # component profile, function pointer to object create function and
  # object delete function.
  #
  # @param profile Component profile
  # @param new_func Pointer to component create function
  # @param delete_func Pointer to component delete function
  # @param policy Pointer to component delete function
  #
  # @endif
  def __init__(self, profile, new_func, delete_func, policy=None):
    FactoryBase.__init__(self, profile)
    
    if policy is None:
      self._policy = OpenRTM_aist.DefaultNumberingPolicy()
    else:
      self._policy = policy

    self._New = new_func
    
    self._Delete = delete_func


  ##
  # @if jp
  #
  # @brief ݡͥȤ
  #
  # RTComponent Υ󥹥󥹤롣
  #
  # @param self
  # @param mgr ޥ͡㥪֥
  #
  # @return ݡͥ
  #
  # @else
  #
  # @brief Create component
  #
  # Create component implemented in Python.
  #
  # @param mgr
  #
  # @endif
  def create(self, mgr):
    try:
      rtobj = self._New(mgr)
      if rtobj == 0:
        return None

      self._Number += 1
      
      rtobj.setProperties(self.profile())
      
      instance_name = rtobj.getTypeName()
      instance_name += self._policy.onCreate(rtobj)
      rtobj.setInstanceName(instance_name)

      return rtobj
    except:
      print OpenRTM_aist.Logger.print_exception()
      return None


  ##
  # @if jp
  #
  # @brief ݡͥȤ˴
  #
  # RTComponent Υ󥹥󥹤˴롣
  #
  # @param self
  # @param comp ˴о RTComponent
  #
  # @else
  #
  # @brief Destroy component
  #
  # Destroy component instance
  #
  # @param comp
  #
  # @endif
  def destroy(self, comp):
    self._Number -= 1
    self._policy.onDelete(comp)
    self._Delete(comp)
