#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file InPort.py
# @brief InPort template class
# @date $Date: 2007/09/20 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
# 
# Copyright (C) 2003-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.

from omniORB import *
from omniORB import any
import sys
import copy
import time

import OpenRTM_aist

##
# @if jp
#
# @class InPort
#
# @brief InPort 饹
# 
# InPort μ饹
# InPort ˥󥰥Хåե줿ǡ缡
# Υ󥰥Хåե˳Ǽ롣󥰥ХåեΥϥǥեȤ64
# ʤäƤ뤬󥹥ȥ饯ˤꥵꤹ뤳ȤǤ롣
# ǡϥե饰ˤä̤ɡɾ֤졢isNew(), getNewDataLen()
# getNewList(), getNewListReverse() Υ᥽åɤˤϥɥ󥰤뤳Ȥ
# Ǥ롣
#
# @since 0.2.0
#
# @else
#
# @class InPort
#
# @brief InPort template class
#
# This class template provides interfaces to input port.
# Component developer can define input value, which act as input
# port from other components, using this template.
# This is class template. This class have to be incarnated class as port
# value types. This value types are previously define RtComponent IDL.
# ex. type T: TimedFload, TimedLong etc... 
#
# @since 0.2.0
#
# @endif
class InPort(OpenRTM_aist.InPortBase):
  """
  """



  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param name InPort ̾InPortBase:name() ˤ껲Ȥ롣
  # @param value  InPort ˥Хɤѿ
  # @param read_block ɹ֥åե饰
  #        ǡɹ̤ɥǡʤ硢Υǡޤǥ֥å
  #        ɤ(ǥե:False)
  # @param write_block ֥åե饰
  #        ǡ˥ХåեեǤä硢Хåե˶Ǥ
  #        ޤǥ֥å뤫ɤ(ǥե:False)
  # @param read_timeout ɹ֥åꤷƤʤΡǡɼ西
  #        Ȼ(ߥ)(ǥե:0)
  # @param write_timeout ֥åꤷƤʤΡǡ
  #        Ȼ(ߥ)(ǥե:0)
  #
  # @else
  #
  # @brief A constructor.
  #
  # Setting channel name and registering channel value.
  #
  # @param self
  # @param name A name of the InPort. This name is referred by
  #             InPortBase::name().
  # @param value A channel value related with the channel.
  # @param read_block
  # @param write_block
  # @param read_timeout
  # @param write_timeout
  #
  # @endif
  def __init__(self, name, value, buffer=None,
               read_block=False, write_block=False,
               read_timeout=0, write_timeout = 0):
    OpenRTM_aist.InPortBase.__init__(self, name, OpenRTM_aist.toTypename(value))
    self._name           = name
    self._value          = value
    self._OnRead         = None
    self._OnReadConvert  = None


  def __del__(self, InPortBase=OpenRTM_aist.InPortBase):
    InPortBase.__del__(self)
    return

  ##
  # @if jp
  # @brief ݡ̾Τ롣
  #
  # ݡ̾Τ롣
  #
  # @param self
  #
  # @return ݡ̾
  #
  # @else
  #
  # @endif
  #
  # const char* name()
  def name(self):
    return self._name


  ##
  # @if jp
  # @brief ǿǡǧ
  #
  # ߤΥХåե֤˳ǼƤǡǿǡǧ롣
  #
  # @param self
  #
  # @return ǿǡǧ
  #            ( true:ǿǡǡϤޤɤ߽ФƤʤ
  #             false:Υǡǡϴɤ߽ФƤ)
  #
  # @else
  #
  # @endif
  #
  # bool isNew()
  def isNew(self):
    self._rtcout.RTC_TRACE("isNew()")

    if len(self._connectors) == 0:
      self._rtcout.RTC_DEBUG("no connectors")
      return False

    r = self._connectors[0].getBuffer().readable()
    if r > 0:
      self._rtcout.RTC_DEBUG("isNew() = True, readable data: %d",r)
      return True

    self._rtcout.RTC_DEBUG("isNew() = False, no readable data")
    return False


  ##
  # @if jp
  #
  # @brief Хåեɤǧ
  # 
  # InPortΥХåեɤ bool ֤ͤ
  # ξ true, ̤ɥǡ false ֤
  #
  # @return true  Хåե϶
  #         false Хåե̤ɥǡ
  # 
  # @else
  #
  # @brief Check whether the data is newest
  # 
  # Check whether the data stored at a current buffer position is newest.
  #
  # @return Newest data check result
  #         ( true:Newest data. Data has not been readout yet.
  #          false:Past dataData has already been readout.)
  # 
  # @endif
  #
  # bool isEmpty()
  def isEmpty(self):
    self._rtcout.RTC_TRACE("isEmpty()")

    if len(self._connectors) == 0:
      self._rtcout.RTC_DEBUG("no connectors")
      return True

    r = self._connectors[0].getBuffer().readable()
    if r == 0:
      self._rtcout.RTC_DEBUG("isEmpty() = true, buffer is empty")
      return True
      
    self._rtcout.RTC_DEBUG("isEmpty() = false, data exists in the buffer")
    return False


  ##
  # @if jp
  #
  # @brief DataPort ͤɤ߽Ф
  #
  # InPort˽񤭹ޤ줿ǡɤߤ³0ޤϥХåե
  # ǡ񤭹ޤƤʤ֤ɤߤͤǤ롣
  # Хåեξ֤ΤȤ
  # ꤵ줿⡼ (readback, do_nothing, block) ˱ơ
  # ʲΤ褦ư򤹤롣
  #
  # - readback: Ǹͤɤߤʤ
  #
  # - do_nothing: ⤷ʤ
  #
  # - block: ֥å롣ॢȤꤵƤϡ
  #       ॢȤޤԤġ
  #
  # Хåեξ֤ǤϡInPort˥Хɤ줿ѿ֤ͤ롣
  # äơɤ߽Фˤ֤ͤǽ롣
  # δؿѤݤˤϡ
  #
  # - isNew(), isEmpty() ʻѤ˥Хåե֤å롣
  # 
  # - ɤ߽Ф֤ͤʤ褦˥Хѿ˽
  # 
  #
  # ƥХåؿϰʲΤ褦˸ƤӽФ롣
  # - OnRead: read() ؿƤФݤɬƤФ롣
  # 
  # - OnReadConvert: ǡɤ߽Ф硢ɤߤǡ
  #       ȤOnReadConvertƤӽФ졢ͤread()
  #       Ȥ֤
  #
  # - OnEmpty: ХåեΤǡɤ߽Ф˼ԤƤӽФ롣
  #        OnEmpty ͤ read() ͤȤ֤
  #
  # - OnBufferTimeout: ǡեPushξˡɤ߽Ф
  #        ॢȤΤ˥ǡɤ߽Ф˼Ԥ˸ƤФ롣
  #
  # - OnRecvTimeout: ǡեPullξˡɤ߽Фॢ
  #        Τ˥ǡɤ߽Ф˼Ԥ˸ƤФ롣
  #
  # - OnReadError: 嵭ʳͳɤߤ˼Ԥ˸ƤФ롣
  #        ͳȤƤϡХåե硢㳰ȯʤɤͤ
  #        ̾ϵꤨʤХβǽ롣
  #
  # @return ɤ߽Фǡ
  #
  # @else
  #
  # @brief Readout the value from DataPort
  #
  # Readout the value from DataPort
  #
  # - When Callback functor OnRead is already set, OnRead will be invoked
  #   before reading from the buffer held by DataPort.
  # - When the buffer held by DataPort can detect the underflow,
  #   and when it detected the underflow at reading, callback functor
  #   OnUnderflow will be invoked.
  # - When callback functor OnReadConvert is already set, the return value of
  #   operator() of OnReadConvert will be the return value of read().
  # - When timeout of reading is already set by setReadTimeout(),
  #   it waits for only timeout time until the state of the buffer underflow
  #   is reset, and if OnUnderflow is already set, this will be invoked to 
  #   return.
  #
  # @return Readout data
  #
  # @endif
  #
  #  DataType read()
  def read(self):
    self._rtcout.RTC_TRACE("DataType read()")

    if self._OnRead is not None:
      self._OnRead()
      self._rtcout.RTC_TRACE("OnRead called")

    if len(self._connectors) == 0:
      self._rtcout.RTC_DEBUG("no connectors")
      return self._value

    _val = copy.deepcopy(self._value)
    cdr = [_val]
    ret = self._connectors[0].read(cdr)


    if ret == OpenRTM_aist.DataPortStatus.PORT_OK:
      self._rtcout.RTC_DEBUG("data read succeeded")
      self._value = cdr[0]

      if self._OnReadConvert is not None:
        self._value = self._OnReadConvert(self._value)
        self._rtcout.RTC_DEBUG("OnReadConvert called")
        return self._value
      return self._value

    elif ret == OpenRTM_aist.DataPortStatus.BUFFER_EMPTY:
      self._rtcout.RTC_WARN("buffer empty")
      return self._value

    elif ret == OpenRTM_aist.DataPortStatus.BUFFER_TIMEOUT:
      self._rtcout.RTC_WARN("buffer read timeout")
      return self._value

    self._rtcout.RTC_ERROR("unknown retern value from buffer.read()")
    return self._value


  ##
  # @if jp
  #
  # @brief Хɤ줿ѿ InPort Хåեκǿͤɤ߹
  #
  # Хɤ줿ǡ InPort κǿͤɤ߹ࡣ
  # 󥹥ȥ饯ѿ InPort ХɤƤʤФʤʤ
  # Υ᥽åɤϥݥ⡼եå˻ѤȤƤ뤿ᡢ
  # ˰¸ʤͤȤʤäƤ롣
  #
  # @param self
  #
  # @else
  #
  # @brief Read into bound T-type data from current InPort
  #
  # @endif
  def update(self):
    self.read()


  ##
  # @if jp
  #
  # @brief InPort Хåեإǡɤ߹߻ΥХå
  #
  # InPort ĥХåեǡɤ߹ޤľ˸ƤФ륳Хå
  # ֥Ȥꤹ롣
  # 
  # @param self
  # @param on_read оݥХå֥
  #
  # @else
  #
  # @endif
  def setOnRead(self, on_read):
    self._OnRead = on_read


  ##
  # @if jp
  #
  # @brief InPort Хåեإǡɤ߽ФΥХå
  #
  # InPort ĥХåեǡɤ߽Фݤ˸ƤФ륳Хå
  # ֥Ȥꤹ롣Хå֥Ȥͤread()᥽å
  # θƽз̤Ȥʤ롣
  # 
  # @param self
  # @param on_rconvert оݥХå֥
  #
  # @else
  #
  # @endif
  def setOnReadConvert(self, on_rconvert):
    self._OnReadConvert = on_rconvert
