#!/usr/bin/env python
# -*- coding: euc-jp -*-


##
# @file RTCUtil.py
# @brief RTComponent utils
# @date $Date: 2007/09/11 $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2007-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.

from omniORB import CORBA

import RTC
import OpenRTM

##
# @if jp
#
# @brief DataFlowComponent Ǥ뤫Ƚꤹ
#
# ꤵ줿RTݡͥȤ DataFlowComponent Ǥ뤫Ƚꤹ롣
# DataFlowComponent ExecutionContext  Semantics 
# Periodic Sampled Data Processing ξѤRTݡͥȤη
# Ǥ롣
#
# @param obj Ƚоݤ CORBA ֥
#
# @return DataFlowComponent Ƚ
#
# @since 0.4.0
#
# @else
#
# @endif
def isDataFlowComponent(obj):
  dfp = obj._narrow(OpenRTM.DataFlowComponent)
  return not CORBA.is_nil(dfp)


##
# @if jp
#
# @brief FsmParticipant Ǥ뤫Ƚꤹ
#
# ꤵ줿RTݡͥȤ FsmParticipant Ǥ뤫Ƚꤹ롣
# FsmParticipant ϡ ExecutionContext  Semantics 
# Stimulus Response Processing ξˡΥ뤿
# ѤRTݡͥȤηǤ롣
#
# @param obj Ƚоݤ CORBA ֥
#
# @return FsmParticipant Ƚ
#
# @since 0.4.0
#
# @else
#
# @endif
def isFsmParticipant(obj):
  fsmp = obj._narrow(RTC.FsmParticipant)
  return not CORBA.is_nil(fsmp)


##
# @if jp
#
# @brief Fsm Ǥ뤫Ƚꤹ
#
# ꤵ줿RTݡͥȤ Fsm Ǥ뤫Ƚꤹ롣
# Fsm ϡ ExecutionContext  Semantics  Stimulus Response Processing 
# ˡܤ뤿ѤRTݡͥȤηǤ롣
#
# @param obj Ƚоݤ CORBA ֥
#
# @return Fsm Ƚ
#
# @since 0.4.0
#
# @else
#
# @endif
def isFsmObject(obj):
  fsm = obj._narrow(RTC.FsmObject)
  return not CORBA.is_nil(fsm)


##
# @if jp
#
# @brief multiModeComponent Ǥ뤫Ƚꤹ
#
# ꤵ줿RTݡͥȤ multiModeComponent Ǥ뤫Ƚꤹ롣
# multiModeComponent ϡ ExecutionContext  Semantics  Modes of Operatin 
# ξˡ Mode 뤿ѤRTݡͥȤηǤ롣
#
# @param obj Ƚоݤ CORBA ֥
#
# @return multiModeComponent Ƚ
#
# @since 0.4.0
#
# @else
#
# @endif
def isMultiModeObject(obj):
  mmc = obj._narrow(RTC.MultiModeObject)
  return not CORBA.is_nil(mmc)
