#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file StateMachine.py
# @brief State machine template class
# @date $Date: 2007/08/30$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2006-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


import threading

import OpenRTM_aist
import RTC


##
# @if jp
# @class StateHolder
# @brief ݻѥ饹
# 
# ֤ݻ뤿Υۥ饹
# ߤξ֤ȡξ֡ͽξ֤ݻ롣
#
# @param State ݻ֤η
#
# @since 0.4.0
#
# @else
#
# @endif
class StateHolder:
  def __init__(self):
    self.curr = None
    self.prev = None
    self.next = None


##
# @if jp
#
# @class StateMachine
#
# @brief ֥ޥ󥯥饹
#
# StateMachine 饹Ͼ֥ޥ¸륯饹Ǥ롣
#
# : ActiveObjectϾ֥ޥĥƥ֥֥ȤǤȤ롣
# ֤3 INACTIVE, ACTIVE, ERROR ꡢƾ֤ǤEntryExitư
# ȤȡʲΤ褦˼¸롣
# <pre>
# class ActiveObject:
#   class MyState:
#     INACTIVE, ACTIVE, ERROR = range(3)
# 
#   def __init__(self):
#     m_sm = StateMachine(3)
#     m_sm.setNOP(nullAction)
#     m_sm.setListener(self)
# 
#     m_sm.setExitAction(MyState.INACTIVE, self.inactiveExit)
#       : 
#     m_sm.setPostDoAction(MyState.ERROR, self.errorPostDo)
#     m_sm.setTransitionAction(self.transition); 
# 
#   def nullAction(myStates):
#     pass
#   def inactiveExit(myStates):
#     pass
#     : 
#   def errorPostDo(myStates):
#     pass
#   def transition(myStates:
#     pass
# </pre>
# ֤饹ϰʲξ褦˼ʤФʤʤ
# <ol>
# <li> 饹Ǿ֤
# <li> StateMachine Υ󥹥ȥ饯Ͼ֤ο
# <li> ʲΥؿ(Return _function_name_(States)) δؿȤ
# <ol>
#  <li> ⤷ʤؿɬsetNOP ͿʤФʤʤ
#  <li> ƾ, set(Entry|PreDo|Do|PostDo|Exit)Action ǥ
#  <li> ܻΥ setTransitionAction() ꡣ
# </ol>
# <li> ܻΥϡͿ줿߾֤֡֡򸵤ˡ
#   桼ʤФʤʤ
# <li> ֤ѹ goTo() ǡ֤Υå isIn(state) ǹԤ
# <li> goTo()ϼ֤Ū˥åȤؿǤꡢܤβݤϡ
#   桼߾֤ȽǤåʤФʤʤ
# </ol>
#
# Υ饹ϡĤξ֤Фơ
# <ul>
# <li> Entry action
# <li> PreDo action
# <li> Do action
# <li> PostDo action
# <li> Exit action
# </ul>
# 5ĤΥ뤳ȤǤ롣
# Transition action ϤִܤǸƤӽФ륢ǡ
# ο񤤤ϥ桼ʤФʤʤ
# 
# Υ饹ϰʲΤ褦ʥߥ󥰤ǳƥ󤬼¹Ԥ롣
#
# <ul>
# <li> ֤ѹ(A->B)֤ܤ <br>
# (A:Exit)->|(ֹ:A->B)->(B:Entry)->(B:PreDo)->(B:Do)->(B:PostDo)
#
# <li> ֤ѹ줺B֤ݻ (|ϥƥåפζڤɽ)<br>
# (B(n-1):PostDo)->|(B(n):PreDo)->(B(n):Do)->(B(n):PostDo)->|(B(n+1):PreDo)<br>
# PreDo, Do, PostDo ֤¹Ԥ롣
#
# <li> ܤ <br>
# (B(n-1):PostDo)->(B(n-1):Exit)->|(B(n):Entry)->(B(n):PreDo) <br>
# ö Exit ƤФ줿塢Entry ¹Ԥ졢ʹߤƱư򤹤롣
# </ul>
#
# @since 0.4.0
#
# @else
#
# @brief
#
# @endif
class StateMachine:
  """
  """

  state_array = (RTC.CREATED_STATE,
                 RTC.INACTIVE_STATE,
                 RTC.ACTIVE_STATE,
                 RTC.ERROR_STATE)

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param num_of_state ơȥޥξֿ
  #
  # @else
  # @brief Constructor
  # @endif
  def __init__(self, num_of_state):
    self._num = num_of_state
    self._entry  = {}
    self._predo  = {}
    self._do     = {}
    self._postdo = {}
    self._exit   = {}

    self.setNullFunc(self._entry,  None)
    self.setNullFunc(self._do,     None)
    self.setNullFunc(self._exit,   None)
    self.setNullFunc(self._predo,  None)
    self.setNullFunc(self._postdo, None)
    self._transit = None
    self._mutex = threading.RLock()


  ##
  # @if jp
  # @brief NOPؿϿ
  #
  # NOPؿ(⤷ʤؿ)Ͽ롣
  #
  # @param self
  # @param call_back Хåؿ
  #
  # @else
  # @brief Set NOP function
  # @endif
  def setNOP(self, call_back):
    self.setNullFunc(self._entry,  call_back)
    self.setNullFunc(self._do,     call_back)
    self.setNullFunc(self._exit,   call_back)
    self.setNullFunc(self._predo,  call_back)
    self.setNullFunc(self._postdo, call_back)
    self._transit = call_back


  ##
  # @if jp
  # @brief Listener ֥ȤϿ
  #
  # Ƽ異¹Ի˸ƤӽФ Listener ֥ȤϿ롣
  #
  # @param self
  # @param listener Listener ֥
  #
  # @else
  # @brief Set Listener Object
  # @endif
  def setListener(self, listener):
    self._listener = listener


  ##
  # @if jp
  # @brief Entry action ؿϿ
  #
  # ƾ֤äݤ˼¹Ԥ Entry action ѥХåؿϿ롣
  #
  # @param self
  # @param state Ͽоݾ
  # @param call_back Entry action ѥХåؿ
  #
  # @return ¹Է
  #
  # @else
  # @brief Set Entry action function
  # @endif
  def setEntryAction(self, state, call_back):
    if self._entry.has_key(state):
      self._entry[state] = call_back
    else:
      self._entry.setdefault(state, call_back)
    return True


  ##
  # @if jp
  # @brief PreDo action ؿϿ
  #
  # ƾǼ¹Ԥ PreDo action ѥХåؿϿ롣
  #
  # @param self
  # @param state Ͽоݾ
  # @param call_back PreDo action ѥХåؿ
  #
  # @return ¹Է
  #
  # @else
  # @brief Set PreDo action function
  # @endif
  def setPreDoAction(self, state, call_back):
    if self._predo.has_key(state):
      self._predo[state] = call_back
    else:
      self._predo.setdefault(state, call_back)
    return True


  ##
  # @if jp
  # @brief Do action ؿϿ
  #
  # ƾǼ¹Ԥ Do action ѥХåؿϿ롣
  #
  # @param self
  # @param state Ͽоݾ
  # @param call_back Do action ѥХåؿ
  #
  # @return ¹Է
  #
  # @else
  # @brief Set Do action function
  # @endif
  def setDoAction(self, state, call_back):
    if self._do.has_key(state):
      self._do[state] = call_back
    else:
      self._do.setdefault(state, call_back)
    return True


  ##
  # @if jp
  # @brief PostDo action ؿϿ
  #
  # ƾǼ¹Ԥ PostDo action ѥХåؿϿ롣
  #
  # @param self
  # @param state Ͽоݾ
  # @param call_back PostDo action ѥХåؿ
  #
  # @return ¹Է
  #
  # @else
  # @brief Set PostDo action function
  # @endif
  def setPostDoAction(self, state, call_back):
    if self._postdo.has_key(state):
      self._postdo[state] = call_back
    else:
      self._postdo.setdefault(state, call_back)
    return True


  ##
  # @if jp
  # @brief Exit action ؿϿ
  #
  # ƾǼ¹Ԥ Exit action ѥХåؿϿ롣
  #
  # @param self
  # @param state Ͽоݾ
  # @param call_back Exit action ѥХåؿ
  #
  # @return ¹Է
  #
  # @else
  # @brief Set Exit action function
  # @endif
  def setExitAction(self, state, call_back):
    if self._exit.has_key(state):
      self._exit[state] = call_back
    else:
      self._exit.setdefault(state, call_back)
    return True


  ##
  # @if jp
  # @brief State transition action ؿϿ
  #
  # ܻ˼¹Ԥ State transition action ѥХåؿ
  # Ͽ롣
  #
  # @param self
  # @param call_back State transition ѥХåؿ
  #
  # @return ¹Է
  #
  # @else
  # @brief Set state transition action function
  # @endif
  def setTransitionAction(self, call_back):
    self._transit = call_back
    return True


  ##
  # @if jp
  # @brief ֤򥻥åȤ
  #
  # ơȥޥν֤ꤹ롣
  #
  # @param self
  # @param states 
  #
  # @else
  # @brief Set Exit action function
  # @endif
  def setStartState(self, states):
    self._states = StateHolder()
    self._states.curr = states.curr
    self._states.prev = states.prev
    self._states.next = states.next


  ##
  # @if jp
  # @brief ֤
  #
  # ־롣
  # ߤξ֡ξ֡ͽξ֤뤳ȤǤ롣
  #
  # @param self
  #
  # @return ־
  #
  # @else
  # @brief Get state machine's status
  # @endif
  def getStates(self):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    return self._states


  ##
  # @if jp
  # @brief ߤξ֤
  #
  # ߤξ֤롣
  #
  # @param self
  #
  # @return ߤξ
  #
  # @else
  # @brief Get current state
  # @endif
  def getState(self):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    return self._states.curr


  ##
  # @if jp
  # @brief ߾֤ǧ
  #
  # ߤξ֤ǻꤷ֤Ȱפ뤫ǧ롣
  #
  # @param self
  # @param state ǧоݾ
  #
  # @return ֳǧ
  #
  # @else
  # @brief Evaluate current status
  # @endif
  def isIn(self, state):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    if self._states.curr == state:
      return True
    else:
      return False


  ##
  # @if jp
  # @brief ֤
  #
  # ꤷ֤˾֤ܤ롣
  # ܴؿϼ֤Ū˥åȤؿǤ롣
  # Τᡢܤβݤϡ桼߾֤ȽǤå
  # ʤФʤʤ
  # 褬ߤξ֤Ʊˤϡܥե饰򥻥åȤ롣
  #
  # @param self
  # @param state 
  #
  # @else
  # @brief Change status
  # @endif
  def goTo(self, state):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    self._states.next = state


  ##
  # @if jp
  # @brief ưؿ
  #
  # ơȥޥζưؿ
  # ºݤξܤӾȯγƥθƤӤ¹Ԥ롣
  #
  # @param self
  #
  # @else
  # @brief Worker function
  # @endif
  def worker(self):
    states = StateHolder()
    self.sync(states)

    # If no state transition required, execute set of do-actions
    if states.curr == states.next:
      # pre-do
      if self._predo[states.curr]:
        self._predo[states.curr](states)
      if self.need_trans():
        return

      # do
      if self._do[states.curr]:
        self._do[states.curr](states)
      if self.need_trans():
        return

      # post-do
      if self._postdo[states.curr]:
        self._postdo[states.curr](states)
    # If state transition required, exit current state and enter next state
    else:
      if self._exit[states.curr]:
        self._exit[states.curr](states)
      self.sync(states)

      # If state transition still required, move to the next state
      if states.curr != states.next:
        states.curr = states.next
        if self._entry[states.curr]:
          self._entry[states.curr](states)
        self.update_curr(states.curr)


  ##
  # @if jp
  # @brief NOPؿ
  #
  # NOPؿ(⤷ʤؿ)Ͽ롣
  #
  # @param self
  # @param s Хåؿ
  # @param nullfunc Хåؿ(NOPؿ)
  #
  # @else
  # @brief Worker function
  # @endif
  def setNullFunc(self, s, nullfunc):
    for i in range(self._num):
      if s.has_key(StateMachine.state_array[i]):
        s[StateMachine.state_array[i]] = nullfunc
      else:
        s.setdefault(StateMachine.state_array[i], nullfunc)


  ##
  # @if jp
  # @brief ֤Ʊ
  #
  # @param self
  # @param states OpenRTM_aist.StateHolder<RTC.LifeCycleState>
  #
  # @else
  # @endif
  def sync(self, states):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    states.prev = self._states.prev
    states.curr = self._states.curr
    states.next = self._states.next
    


  ##
  # @if jp
  # @brief ܤɬå
  #
  # @param self
  #
  # @return ɬǧ
  #
  # @else
  # @endif
  def need_trans(self):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    return (self._states.curr != self._states.next)


  ##
  # @if jp
  # @brief ߾֤ι
  #
  # @param self
  # @param curr RTC.LifeCycleState
  #
  # @else
  # @endif
  def update_curr(self, curr):
    guard = OpenRTM_aist.ScopedLock(self._mutex)
    self._states.curr = curr
