/*!
 * @file ExecutionContext.h
 * @brief ExecutionContext class
 * @date $Date: 2007-04-13 15:45:29 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2006
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id: ExecutionContext.cpp 1220 2009-02-27 06:49:20Z n-ando $
 *
 */

#include <rtm/ExecutionContext.h>
#include <rtm/CORBA_SeqUtil.h>

namespace RTC
{
  
  ExecutionContextBase::ExecutionContextBase(RTObject_ptr owner)
    : rtclog("exec_cxt"), m_running(false)
  {
    m_profile.kind = OTHER;
    m_profile.rate = 0.0;
    m_profile.owner = owner;
    m_profile.participants.length(0);
  }

  /*!
   * @if jp
   * @brief ExecutionContext ¹椫ɤΥƥ
   * @else
   * @brief Test for ExecutionContext running state
   * @endif
   */
  CORBA::Boolean ExecutionContextBase::is_running()
  {
    RTC_TRACE(("is_running()"));
    return m_running;
  }
  

  /*!
   * @if jp
   * @brief ExecutionContext 򥹥Ȥ
   * @else
   * @brief Start the ExecutionContext
   * @endif
   */
  ReturnCode_t ExecutionContextBase::start()
  {
    RTC_TRACE(("start()"));
    return RTC::RTC_OK;
  }
  

  /*!
   * @if jp
   * @brief ExecutionContext 򥹥ȥåפ
   * @else
   * @brief Stop the ExecutionContext
   * @endif
   */
  ReturnCode_t ExecutionContextBase::stop()
  {
    RTC_TRACE(("stop()"));
    return RTC::RTC_OK;
  }
  
  
  /*!
   * @if jp
   * @brief ¹Լ(Hz)
   * @else
   * @brief Get executionrate(Hz)
   * @endif
   */
  CORBA::Double ExecutionContextBase::get_rate()
  {
    RTC_TRACE(("get_rate()"));
    return m_profile.rate;
  }
  
  
  /*!
   * @if jp
   * @brief ¹Լ(Hz)Ϳ 
   * @else
   * @brief Set rate (Hz)
   * @endif
   */
  ReturnCode_t ExecutionContextBase::set_rate(CORBA::Double rate)
  {
    RTC_TRACE(("set_rate(%f)", rate));
    if (rate > 0.0)
      {
	m_profile.rate = rate;
	return RTC::RTC_OK;
      }
    return RTC::BAD_PARAMETER;
  }
  

  /*!
   * @if jp
   * @brief ݡͥȤ򥢥ƥֲ
   * @else
   * @brief Activate a component
   * @endif
   */ 
  ReturnCode_t
  ExecutionContextBase::activate_component(LightweightRTObject_ptr comp)
  {
    RTC_TRACE(("activate_component()"));
    return RTC::RTC_OK;
  }
  

  /*!
   * @if jp
   * @brief ݡͥȤ󥢥ƥֲ
   * @else
   * @brief Deactivate a component
   * @endif
   */  
  ReturnCode_t
  ExecutionContextBase::deactivate_component(LightweightRTObject_ptr comp)
  {
    RTC_TRACE(("deactivate_component()"));
    return RTC::RTC_OK;
  }
  

  /*!
   * @if jp
   * @brief ݡͥȤ󥢥ƥֲ
   * @else
   * @brief Deactivate a component
   * @endif
   */  
  ReturnCode_t
  ExecutionContextBase::reset_component(LightweightRTObject_ptr comp)
  {
    RTC_TRACE(("reset_component()"));
    return RTC::RTC_OK;
  }
  
  
  /*!
   * @if jp
   * @brief ݡͥȤξ֤
   * @else
   * @brief Get component's state
   * @endif
   */
  LifeCycleState
  ExecutionContextBase::get_component_state(LightweightRTObject_ptr comp)
  {
    RTC_TRACE(("get_component_state()"));
    return RTC::INACTIVE_STATE;
  }
  
  
  /*!
   * @if jp
   * @brief ExecutionKind 
   * @else
   * @brief Get the ExecutionKind
   * @endif
   */
  ExecutionKind ExecutionContextBase::get_kind()
  {
    RTC_TRACE(("get_kind()"));
    return m_profile.kind;
  }
  

  /*!
   * @if jp
   * @brief ݡͥȤɲä
   * @else
   * @brief Add a component
   * @endif
   */
  ReturnCode_t
  ExecutionContextBase::add_component(LightweightRTObject_ptr comp)
  {
    RTC_TRACE(("add_component()"));
    if (!CORBA::is_nil(comp))
      {
	CORBA_SeqUtil::push_back(m_profile.participants,
				 RTC::RTObject::_narrow(comp));
	return RTC::RTC_OK;
      }
    return RTC::BAD_PARAMETER;
  }
  
  
  /*!
   * @if jp
   * @brief ݡͥȤ򥳥ݡͥȥꥹȤ
   * @else
   * @brief Remove the component from component list
   * @endif
   */	
  ReturnCode_t
  ExecutionContextBase::remove_component(LightweightRTObject_ptr comp)
  {
    RTC_TRACE(("remove_component()"));
    CORBA::ULong index;
    index = CORBA_SeqUtil::find(m_profile.participants,
		find_objref<RTObject_ptr>(RTC::RTObject::_narrow(comp)));
				
    if (index < 0) return RTC::BAD_PARAMETER;
    CORBA_SeqUtil::erase(m_profile.participants, index);
    return RTC::RTC_OK;
  }


  //============================================================
  // ExecutionContextAdmin interfaces
  //============================================================
  /*!
   * @if jp
   * @brief ExecutionContextProfile 
   * @else
   * @brief Get the ExecutionContextProfile
   * @endif
   */
  ExecutionContextProfile* ExecutionContextBase::get_profile()
  {
    RTC_TRACE(("get_profile()"));
    ExecutionContextProfile_var p;
    p = new ExecutionContextProfile(m_profile);
    return p._retn();
  }
  
  
  
}; // namespace RTC
