// -*- C++ -*-
/*!
 * @file RTCUtil.h
 * @brief RTComponent utils
 * @date $Date: 2007-12-31 03:08:06 $
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2007-2008
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id: RTCUtil.h 1703 2010-01-20 01:12:01Z fsi-katami $
 *
 */

#ifndef RTCUtil_h
#define RTCUtil_h

#include <rtm/idl/RTCSkel.h>
#include <rtm/idl/OpenRTMSkel.h>

/*!
 * @if jp
 * @namespace RTC_Utils
 *
 * @brief RTݡͥѥ桼ƥƥؿ
 *
 * RTݡͥȤФưʲΥ桼ƥƥؿ󶡤롣
 * 
 * - isDataFlowParticipant
 * - isFsmParticipant
 * - isFsmObject
 * - isMultiModeObject
 *
 * @else
 * @namespace RTC_Utils
 *
 * @brief Utility functions for RT-Component
 *
 * This provides the following utility functions to RT-Component.
 * 
 * - isDataFlowParticipant
 * - isFsmParticipant
 * - isFsmObject
 * - isMultiModeObject
 *
 * @endif
 */
namespace RTC_Utils
{
  /*!
   * @if jp
   *
   * @brief DataFlowComponent Ǥ뤫Ƚꤹ
   *
   * ꤵ줿RTݡͥȤ DataFlowComponent Ǥ뤫Ƚꤹ롣
   * DataFlowComponentϡ ExecutionContext  Semantics 
   * Periodic Sampled Data Processing ξѤRTݡͥȤη
   * Ǥ롣
   *
   * @param obj Ƚоݤ CORBA ֥
   *
   * @return DataFlowComponent Ƚ
   *
   * @since 0.4.0
   *
   * @else
   *
   * @brief Confirm whether specified RT-Component is DataFlowComponent
   *
   * Confirm whether specified RT-Component is DataFlowComponent.
   * DataFlowComponent is a type of the RT-Component which is used 
   * when Semantics of ExecutionContext is Periodic Sampled Data Processing.
   *
   * @param obj The target CORBA object for the investigation
   *
   * @return Investigation result of DataFlowComponent
   *
   * @since 0.4.0
   *
   * @endif
   */
  bool isDataFlowComponent(CORBA::Object_ptr obj);
  
  /*!
   * @if jp
   *
   * @brief FsmParticipant Ǥ뤫Ƚꤹ
   *
   * ꤵ줿RTݡͥȤ FsmParticipant Ǥ뤫Ƚꤹ롣
   * FsmParticipant ϡ ExecutionContext  Semantics 
   * Stimulus Response Processing ξˡΥ뤿
   * ѤRTݡͥȤηǤ롣
   *
   * @param obj Ƚоݤ CORBA ֥
   *
   * @return FsmParticipant Ƚ
   *
   * @since 0.4.0
   *
   * @else
   *
   * @brief Confirm whether specified RT-Component is FsmParticipant
   *
   * Confirm whether specified RT-Component is FsmParticipant.
   * FsmParticipant is a type of the RT-Component which is used when Semantics
   * of ExecutionContext is Stimulus Response Processing. It is used to define 
   * the actions in the state.
   *
   * @param obj The target CORBA object for the investigation
   *
   * @return Investigation result of FsmParticipant
   *
   * @since 0.4.0
   *
   * @endif
   */
  bool isFsmParticipant(CORBA::Object_ptr obj);
  
  /*!
   * @if jp
   *
   * @brief Fsm Ǥ뤫Ƚꤹ
   *
   * ꤵ줿RTݡͥȤ Fsm Ǥ뤫Ƚꤹ롣
   * Fsm ϡ ExecutionContext  Semantics  Stimulus Response Processing 
   * ˡܤ뤿ѤRTݡͥȤηǤ롣
   *
   * @param obj Ƚоݤ CORBA ֥
   *
   * @return Fsm Ƚ
   *
   * @since 0.4.0
   *
   * @else
   *
   * @brief Confirm whether specified RT-Component is Fsm
   *
   * Confirm whether specified RT-Component is Fsm.
   * Fsm is a type of the RT-Component that is used when Semantics of 
   * ExecutionContext is Stimulus Response Processing. It is uset to define the 
   * state transition.
   *
   * @param obj The target CORBA object for the investigation
   *
   * @return Investigation result of Fsm
   *
   * @since 0.4.0
   *
   * @endif
   */
  bool isFsmObject(CORBA::Object_ptr obj);
  
  /*!
   * @if jp
   *
   * @brief multiModeComponent Ǥ뤫Ƚꤹ
   *
   * ꤵ줿RTݡͥȤ multiModeComponent Ǥ뤫Ƚꤹ롣
   * multiModeComponent ϡ ExecutionContext  Semantics  Modes of Operation 
   * ξˡ Mode 뤿ѤRTݡͥȤηǤ롣
   *
   * @param obj Ƚоݤ CORBA ֥
   *
   * @return multiModeComponent Ƚ
   *
   * @since 0.4.0
   *
   * @else
   *
   * @brief Confirm whether specified RT-Component is multiModeComponent
   *
   * Confirm whether specified RT-Component is multiModeComponent.
   * multiModeComponent is a type of the RT-Component which is used when
   * Semantics of ExecutionContext is Modes of Operation. It is used to define
   * Mode.
   *
   * @param obj The target CORBA object for the investigation
   *
   * @return Investigation result of multiModeComponent
   *
   * @since 0.4.0
   *
   * @endif
   */
  bool isMultiModeObject(CORBA::Object_ptr obj);
}; // namespace RTC_Utils
#endif // RTCUtil_h
